#define _GNU_SOURCE

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <features.h>
#include <stdio.h>

#include "interface.h"
#include "support.h"
#include "callbacks.h"

#include "perspic.h"

int
main (int argc, char *argv[])
{


  GtkWidget *w1,*w2,*w3,*co,*w,*t;

  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

  w1 = create_window1 ();

  w2=create_window2();
  gtk_object_set_data_full (GTK_OBJECT (w1), "window2", w2,
			    (GtkDestroyNotify) gtk_widget_destroy);
  gtk_object_set_data (GTK_OBJECT (w2), "window1", w1);

  w3=create_window3();
  gtk_object_set_data_full (GTK_OBJECT (w1), "window3", w3,
			    (GtkDestroyNotify) gtk_widget_destroy);
  gtk_object_set_data (GTK_OBJECT (w3), "window1", w1);
  
  w=create_fileselection1();
  gtk_object_set_data_full (GTK_OBJECT (w1), "fileselection1", w,
			    (GtkDestroyNotify) gtk_widget_destroy);
  gtk_object_set_data (GTK_OBJECT (w), "window1", w1);
  
  w=create_fileselection2();
  gtk_object_set_data_full (GTK_OBJECT (w3), "fileselection2", w,
			    (GtkDestroyNotify) gtk_widget_destroy);
  gtk_object_set_data (GTK_OBJECT (w), "window3", w3);
  
  w=create_fontselectiondialog1();
  gtk_object_set_data_full (GTK_OBJECT (w1), "fontselectiondialog1", w,
			    (GtkDestroyNotify) gtk_widget_destroy);
  
  t=lookup_widget(w1,"text1");
  w=create_menu1();
  gtk_object_set_data_full (GTK_OBJECT (t), "menu1", w,
			    (GtkDestroyNotify) gtk_widget_destroy);
  
  w=create_menu2();
  gtk_object_set_data_full (GTK_OBJECT (t), "menu2", w,
			    (GtkDestroyNotify) gtk_widget_destroy);
  
  w=create_window4();
  gtk_object_set_data_full (GTK_OBJECT (t), "find", w,
			    (GtkDestroyNotify) gtk_widget_destroy);

  t=lookup_widget(w3,"text3");
  gtk_object_set_data_full (GTK_OBJECT (t), "find", w,
			    (GtkDestroyNotify) gtk_widget_destroy);

  
  co=lookup_widget(GTK_WIDGET(w1),"combo3");
  gtk_signal_connect(GTK_OBJECT(GTK_COMBO(co)->popwin),"hide",on_combo3_popwin_hide,co);
  co=lookup_widget(GTK_WIDGET(w1),"combo4");
  gtk_signal_connect(GTK_OBJECT(GTK_COMBO(co)->popwin),"hide",on_combo4_popwin_hide,co);
  gtk_combo_disable_activate(GTK_COMBO(co));
  
  gtk_widget_show (w1);

  archive_init(w1);
  my_err=gtk_err;

  gtk_main ();

  return 0;
}

