
/*
 * pfqueue library interface
 */

#ifndef __PFQLIB_H
#define __PFQLIB_H

#include <time.h>

#ifdef __cplusplus
extern "C" {
#endif

#define PFQL_VERSION "1.1"

struct pfql_conf_t {
	int   max_char;			/* Max char buffer length */
	short initial_queue;		/* Queue to start with */
	char  backends_path[200];	/* Path to backends */
	char  backend_name[200];	/* Backend to use */
	char  backend_config[200];	/* Backend configuration path */
	char  backend_progs[200];	/* Backend bin bath */
	int   msg_max;			/* Maximum number of messages */
	int   scan_limit;		/* Max secs for a single scan */
	int   scan_delay;		/* Secs between scans */
	char  remote_host[200];		/* Remote host (for socket backend only) */
	int   remote_port;		/* Remote port (for socket backend only) */
};

struct pfql_status_t {
	short auto_wrk_tagged;
	short wrk_tagged;
	short ask_confirm;
	short do_scan;
	short use_envelope;
	short use_colors;
	short cur_queue;
};

/* -----------------
 * Library functions
 * ----------------- */

// Initializes library
int		pfql_init();

// Start using library
int		pfql_start();

// Close library
void		pfql_close();

// Returns library version
const char*	pfql_version();

// Returns status
struct pfql_status_t *pfql_getstatus();

// Returns current configuration
struct pfql_conf_t   *pfql_getconf();

/*
 * Backend functions
 */

// Returns backend API version
int	 	pfql_backend_apiversion();

// Returns backend identifier
const char*	pfql_backend_id();

// Returns backend version
const char*	pfql_backend_version();

// Sets backend configuration path/file
void		pfql_backend_setconfig(const char*);

// Sets backend MTA command
void		pfql_backend_setcommand(const char*);

// Sets MTA version
void		pfql_backend_setversion(const char*);

// Number of queues
int		pfql_num_queues();

// Returns queue name
const char* 	pfql_queue_name(int);

// Sets current queue
void		pfql_set_queue(int);

// The last time the queue changed
time_t		pfql_queue_last_changed();

// Retreive message status
int 		pfql_retr_status(const char*);

// Retreive message headers
int		pfql_retr_headers(const char*);

// Retreive message body
int		pfql_retr_body(const char*, void*, size_t);

// Returns the number of messages in the queue
int		pfql_num_msg();

// Returns the number of tagged messages
int		pfql_num_tag();

// Tags all messages
void		pfql_tag_all();

// Untag all messages
void		pfql_tag_none();

// Tags a single message
void		pfql_msg_tag(const char*);

// Untags a single message
void		pfql_msg_untag(const char*);

// Toggle tag flag on message
void		pfql_msg_toggletag(const char*);

// Returns wether the message is tagged or not
int		pfql_msg_istagged(const char*);

// Performs an action on the message
void		pfql_msg_action(const char*,int);

// Toggle reading from envelope, if the backend supports it
void		pfql_toggle_envelope();

// Search for a regexp (first occurence)
int		pfql_msg_search(const char*);

// Search message forward
int		pfql_msg_searchnext(const char*);

// Search message backward
int		pfql_msg_searchprev(const char*);

// Search next message and tag it
void		pfql_msg_searchandtag(const char*);

// Returns message at a given position in the queue
struct msg_t*	pfql_msg_at(int);

// Returns message position
struct msg_t*	pfql_msg(const char*);

// Return codes
#define		PFQL_OK			0
#define		PFQL_ERROR		-1
#define		PFQL_INVREGEXP		-1
#define		PFQL_BENOTFOUND		-2
#define		PFQL_BEWRONGAPI 	-3
#define		PFQL_BEMISSINGSYM	-4
#define		PFQL_MALLOC		-5
#define		PFQL_NOBE		-6
#define		PFQL_BEINIT		-7
#define		PFQL_MSGNOTEX		-1

#ifdef __cplusplus
}
#endif

#endif // __PFQLIB_H

