#ifndef MEX_UTILS_H
#define MEX_UTILS_H

#include "mex.h"

namespace pfs {
	class Array2D;
}

mxArray *create_mex_double( double val );
mxArray *create_mex_string( const char *str );
char *get_mex_string( const mxArray *arg );
double get_mex_double( const mxArray *arg );
float get_mex_float( const mxArray *arg );
bool is_mex_scalar( const mxArray *arg );
bool is_mex_fid( const mxArray *arg );
int set_mex_field( mxArray *arg, const char *field_name, mxArray *value );
void copy_mex_to_pfsarray( const mxArray *arg, pfs::Array2D *array );
void copy_pfsarray_to_mex( const pfs::Array2D *array, mxArray *arg );

void copy_mex_to_pfsarray( const mxArray *arg, pfs::Array2D *d1, pfs::Array2D *d2, pfs::Array2D *d3 );
void copy_pfsarray_to_mex( const pfs::Array2D *d1, const pfs::Array2D *d2, const pfs::Array2D *d3, mxArray *arg );


mxArray *mxCreateLogicalScalar( bool value );


#endif
