/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.34 from the
 * contents of LibC.xs. Do not edit this file, edit LibC.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

/***********************************************************************************************************************************
C to Perl Interface

The following C types are mapped by the current typemap:

'AV *', 'Boolean', 'CV *', 'FILE *', 'FileHandle', 'HV *', 'I16', 'I32', 'I8', 'IV', 'InOutStream', 'InputStream', 'NV',
'OutputStream', 'PerlIO *', 'Result', 'STRLEN', 'SV *', 'SVREF', 'SysRet', 'SysRetLong', 'Time_t *', 'U16', 'U32', 'U8', 'UV',
'bool', 'bool_t', 'caddr_t', 'char', 'char *', 'char **', 'const char *', 'double', 'float', 'int', 'long', 'short', 'size_t',
'ssize_t', 'time_t', 'unsigned', 'unsigned char', 'unsigned char *', 'unsigned int', 'unsigned long', 'unsigned long *',
'unsigned short', 'void *', 'wchar_t', 'wchar_t *'
***********************************************************************************************************************************/
#include "build.auto.h"

#define PERL_NO_GET_CONTEXT

/***********************************************************************************************************************************
Perl includes

Order is critical here so don't change it.
***********************************************************************************************************************************/
#if __GNUC__ > 4 || (__GNUC__ == 4 && (__GNUC_MINOR__ > 8 || (__GNUC_MINOR__ == 8 && __GNUC_PATCHLEVEL__ >= 0)))
    #define WARNING_MAYBE_INITIALIZED 1
#elif __GNUC__ > 4 || (__GNUC__ == 4 && (__GNUC_MINOR__ > 6 || (__GNUC_MINOR__ == 6 && __GNUC_PATCHLEVEL__ >= 0)))
    #define WARNING_INITIALIZED 1
#endif

#if WARNING_MAYBE_INITIALIZED
    #pragma GCC diagnostic ignored "-Wmaybe-uninitialized"
#elif WARNING_INITIALIZED
    #pragma GCC diagnostic ignored "-Wuninitialized"
#endif

#pragma GCC diagnostic ignored "-Wsign-conversion"
#pragma GCC diagnostic ignored "-Wconversion"

#include <XSUB.h>
#include <EXTERN.h>
#include <perl.h>

#if WARNING_MAYBE_INITIALIZED
    #pragma GCC diagnostic warning "-Wmaybe-uninitialized"
#elif WARNING_INITIALIZED
    #pragma GCC diagnostic warning "-Wuninitialized"
#endif

/***********************************************************************************************************************************
C includes

These includes are from the src directory.  There is no Perl-specific code in them.
***********************************************************************************************************************************/
#include "common/crypto/common.h"
#include "common/error.h"
#include "common/io/io.h"
#include "common/lock.h"
#include "config/config.h"
#include "config/define.h"
#include "config/load.h"
#include "config/parse.h"
#include "perl/config.h"
#include "postgres/pageChecksum.h"
#include "storage/posix/storage.h"

/***********************************************************************************************************************************
Helper macros
***********************************************************************************************************************************/
#include "LibC.h"

/***********************************************************************************************************************************
XSH includes

These includes define data structures that are required for the C to Perl interface but are not part of the regular C source.
***********************************************************************************************************************************/
#include "xs/crypto/hash.xsh"
#include "xs/common/encode.xsh"
#include "xs/postgres/client.xsh"
#include "xs/storage/storage.xsh"
#include "xs/storage/storageRead.xsh"
#include "xs/storage/storageWrite.xsh"

/***********************************************************************************************************************************
Module definition
***********************************************************************************************************************************/
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif


XS_EUPXS(XS_pgBackRest__LibC_libcUvSize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_libcUvSize)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	I32	RETVAL;
	dXSTARG;
    RETVAL = UVSIZE;
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE:  Including 'xs/common/encode.xs' from 'LibC.xs' */


/* INCLUDE:  Including 'xs/common/lock.xs' from 'xs/common/encode.xs' */


/* INCLUDE:  Including 'xs/config/config.xs' from 'xs/common/lock.xs' */


/* INCLUDE:  Including 'xs/config/configTest.xs' from 'xs/config/config.xs' */


/* INCLUDE:  Including 'xs/config/define.xs' from 'xs/config/configTest.xs' */


/* INCLUDE:  Including 'xs/crypto/hash.xs' from 'xs/config/define.xs' */


/* INCLUDE:  Including 'xs/crypto/random.xs' from 'xs/crypto/hash.xs' */


/* INCLUDE:  Including 'xs/postgres/client.xs' from 'xs/crypto/random.xs' */


/* INCLUDE:  Including 'xs/postgres/pageChecksum.xs' from 'xs/postgres/client.xs' */


/* INCLUDE:  Including 'xs/storage/storage.xs' from 'xs/postgres/pageChecksum.xs' */


/* INCLUDE:  Including 'xs/storage/storageRead.xs' from 'xs/storage/storage.xs' */


/* INCLUDE:  Including 'xs/storage/storageWrite.xs' from 'xs/storage/storageRead.xs' */


XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_new)
{
    dVAR; dXSARGS;
    if (items != 9)
       croak_xs_usage(cv,  "class, storage, file, mode, user, group, timeModified, atomic, pathCreate");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	const String *	class = STR_NEW_SV(ST(0));
	pgBackRest__LibC__Storage	storage;
	const String *	file = STR_NEW_SV(ST(2));
	U32	mode = (unsigned long)SvUV(ST(3))
;
	const String *	user = STR_NEW_SV(ST(4));
	const String *	group = STR_NEW_SV(ST(5));
	IV	timeModified = (IV)SvIV(ST(6))
;
	bool	atomic = (bool)SvTRUE(ST(7))
;
	bool	pathCreate = (bool)SvTRUE(ST(8))
;
	pgBackRest__LibC__StorageWrite	RETVAL;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    storage = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageWrite::new",
			"storage", "pgBackRest::LibC::Storage")
;
    CHECK(strEqZ(class, PACKAGE_NAME_LIBC "::StorageWrite"));

    RETVAL = storageWriteMove(
        storageNewWriteP(
            storage, file, .modeFile = mode, .user = user, .group = group, .timeModified = (time_t)timeModified,
            .noCreatePath = storageFeature(storage, storageFeaturePath) ? !pathCreate : false, .noSyncPath = !atomic,
            .noAtomic = !atomic),
        MEM_CONTEXT_XS_OLD());
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "pgBackRest::LibC::StorageWrite", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_filterAdd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_filterAdd)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, filter, param");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageWrite	self;
	const String *	filter = STR_NEW_SV(ST(1));
	const String *	param = STR_NEW_SV(ST(2));

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageWrite")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageWrite,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageWrite::filterAdd",
			"self", "pgBackRest::LibC::StorageWrite")
;
    IoFilterGroup *filterGroup = ioWriteFilterGroup(storageWriteIo(self));
    storageFilterXsAdd(filterGroup, filter, param);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_open); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_open)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageWrite	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageWrite")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageWrite,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageWrite::open",
			"self", "pgBackRest::LibC::StorageWrite")
;
    ioWriteOpen(storageWriteIo(self));
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_write); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_write)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, buffer");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageWrite	self;
	const Buffer *	buffer = BUF_CONST_SV(ST(1));
	UV	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageWrite")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageWrite,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageWrite::write",
			"self", "pgBackRest::LibC::StorageWrite")
;
    ioWrite(storageWriteIo(self), buffer);
    RETVAL = bufUsed(buffer);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_close); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_close)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageWrite	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageWrite")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageWrite,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageWrite::close",
			"self", "pgBackRest::LibC::StorageWrite")
;
    ioWriteClose(storageWriteIo(self));
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_result); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_result)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, filter");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageWrite	self;
	const String *	filter = STR_NEW_SV(ST(1));
	const char *	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageWrite")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageWrite,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageWrite::result",
			"self", "pgBackRest::LibC::StorageWrite")
;
    RETVAL = strPtr(storageFilterXsResult(ioWriteFilterGroup(storageWriteIo(self)), filter));
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_resultAll); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_resultAll)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageWrite	self;
	const char *	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageWrite")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageWrite,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageWrite::resultAll",
			"self", "pgBackRest::LibC::StorageWrite")
;
    RETVAL = strPtr(storageFilterXsResultAll(ioWriteFilterGroup(storageWriteIo(self))));
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageWrite_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageWrite	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageWrite,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"pgBackRest::LibC::StorageWrite::DESTROY",
			"self")
;
    storageWriteFree(self);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


/* INCLUDE: Returning to 'xs/storage/storageRead.xs' from 'xs/storage/storageWrite.xs' */


XS_EUPXS(XS_pgBackRest__LibC__StorageRead_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageRead_new)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "class, storage, file, ignoreMissing");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	const String *	class = STR_NEW_SV(ST(0));
	pgBackRest__LibC__Storage	storage;
	const String *	file = STR_NEW_SV(ST(2));
	bool	ignoreMissing = (bool)SvTRUE(ST(3))
;
	pgBackRest__LibC__StorageRead	RETVAL;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    storage = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageRead::new",
			"storage", "pgBackRest::LibC::Storage")
;
    CHECK(strEqZ(class, PACKAGE_NAME_LIBC "::StorageRead"));

    RETVAL = storageReadMove(storageNewReadP(storage, file, .ignoreMissing = ignoreMissing), MEM_CONTEXT_XS_OLD());
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "pgBackRest::LibC::StorageRead", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__StorageRead_filterAdd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageRead_filterAdd)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, filter, param");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageRead	self;
	const String *	filter = STR_NEW_SV(ST(1));
	const String *	param = STR_NEW_SV(ST(2));

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageRead")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageRead,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageRead::filterAdd",
			"self", "pgBackRest::LibC::StorageRead")
;
    IoFilterGroup *filterGroup = ioReadFilterGroup(storageReadIo(self));
    storageFilterXsAdd(filterGroup, filter, param);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_pgBackRest__LibC__StorageRead_open); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageRead_open)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageRead	self;
	bool	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageRead")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageRead,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageRead::open",
			"self", "pgBackRest::LibC::StorageRead")
;
    RETVAL = ioReadOpen(storageReadIo(self));
	ST(0) = boolSV(RETVAL);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__StorageRead_read); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageRead_read)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, bufferSize");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageRead	self;
	U32	bufferSize = (unsigned long)SvUV(ST(1))
;
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageRead")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageRead,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageRead::read",
			"self", "pgBackRest::LibC::StorageRead")
;
    RETVAL = NEWSV(0, bufferSize);
    SvPOK_only(RETVAL);

    Buffer *bufferRead = bufNewUseC((unsigned char *)SvPV_nolen(RETVAL), bufferSize);
    ioRead(storageReadIo(self), bufferRead);

    SvCUR_set(RETVAL, bufUsed(bufferRead));
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__StorageRead_eof); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageRead_eof)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageRead	self;
	bool	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageRead")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageRead,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageRead::eof",
			"self", "pgBackRest::LibC::StorageRead")
;
    RETVAL = ioReadEof(storageReadIo(self));
	ST(0) = boolSV(RETVAL);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__StorageRead_close); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageRead_close)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageRead	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageRead")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageRead,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageRead::close",
			"self", "pgBackRest::LibC::StorageRead")
;
    ioReadClose(storageReadIo(self));
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_pgBackRest__LibC__StorageRead_result); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageRead_result)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, filter");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageRead	self;
	const String *	filter = STR_NEW_SV(ST(1));
	const char *	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageRead")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageRead,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageRead::result",
			"self", "pgBackRest::LibC::StorageRead")
;
    RETVAL = strPtr(storageFilterXsResult(ioReadFilterGroup(storageReadIo(self)), filter));
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__StorageRead_resultAll); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageRead_resultAll)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageRead	self;
	const char *	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::StorageRead")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageRead,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::StorageRead::resultAll",
			"self", "pgBackRest::LibC::StorageRead")
;
    RETVAL = strPtr(storageFilterXsResultAll(ioReadFilterGroup(storageReadIo(self))));
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__StorageRead_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__StorageRead_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageRead	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__StorageRead,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"pgBackRest::LibC::StorageRead::DESTROY",
			"self")
;
    storageReadFree(self);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


/* INCLUDE: Returning to 'xs/storage/storage.xs' from 'xs/storage/storageRead.xs' */


XS_EUPXS(XS_pgBackRest__LibC__Storage_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "class, type, path");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	const String *	class = STR_NEW_SV(ST(0));
	const String *	type = STR_NEW_SV(ST(1));
	const String *	path = STR_NEW_SV(ST(2));
	pgBackRest__LibC__Storage	RETVAL;
    CHECK(strEqZ(class, PACKAGE_NAME_LIBC "::Storage"));

    if (strEqZ(type, "<LOCAL>"))
    {
        memContextSwitch(MEM_CONTEXT_XS_OLD());
        RETVAL = storagePosixNew(
            path == NULL ? STRDEF("/") : path, STORAGE_MODE_FILE_DEFAULT, STORAGE_MODE_PATH_DEFAULT, true, NULL);
        storagePathEnforceSet((Storage *)RETVAL, false);
        memContextSwitch(MEM_CONTEXT_XS_TEMP());
    }
    else if (strEqZ(type, "<REPO>"))
    {
        CHECK(path == NULL);
        RETVAL = (Storage *)storageRepoWrite();
    }
    else if (strEqZ(type, "<DB>"))
    {
        CHECK(path == NULL);

        memContextSwitch(MEM_CONTEXT_XS_OLD());
        RETVAL = storagePosixNew(cfgOptionStr(cfgOptPgPath), STORAGE_MODE_FILE_DEFAULT, STORAGE_MODE_PATH_DEFAULT, true, NULL);
        storagePathEnforceSet((Storage *)RETVAL, false);
        memContextSwitch(MEM_CONTEXT_XS_TEMP());
    }
    else
        THROW_FMT(AssertError, "unexpected storage type '%s'", strPtr(type));
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "pgBackRest::LibC::Storage", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_bucketCreate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_bucketCreate)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__Storage	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::bucketCreate",
			"self", "pgBackRest::LibC::Storage")
;
    if (strEq(storageType(self), STORAGE_S3_TYPE_STR))
        storageS3Request((StorageS3 *)storageDriver(self), HTTP_VERB_PUT_STR, FSLASH_STR, NULL, NULL, true, false);
    else
        THROW_FMT(AssertError, "unable to create bucket on '%s' storage", strPtr(storageType(self)));
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_copy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_copy)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, source, destination");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageRead	source;
	pgBackRest__LibC__StorageWrite	destination;
	bool	RETVAL;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pgBackRest::LibC::StorageRead")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    source = INT2PTR(pgBackRest__LibC__StorageRead,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::copy",
			"source", "pgBackRest::LibC::StorageRead")
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "pgBackRest::LibC::StorageWrite")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    destination = INT2PTR(pgBackRest__LibC__StorageWrite,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::copy",
			"destination", "pgBackRest::LibC::StorageWrite")
;
    RETVAL = storageCopyNP(source, destination);
	ST(0) = boolSV(RETVAL);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_exists); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_exists)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, fileExp");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__Storage	self;
	const String *	fileExp = STR_NEW_SV(ST(1));
	bool	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::exists",
			"self", "pgBackRest::LibC::Storage")
;
    RETVAL = storageExistsNP(self, fileExp);
	ST(0) = boolSV(RETVAL);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_get); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_get)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, read");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageRead	read;
	SV *	RETVAL;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pgBackRest::LibC::StorageRead")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    read = INT2PTR(pgBackRest__LibC__StorageRead,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::get",
			"read", "pgBackRest::LibC::StorageRead")
;
    RETVAL = NULL;
    Buffer *buffer = storageGetNP(read);

    if (buffer != NULL)
    {
        if (bufUsed(buffer) == 0)
            RETVAL = newSVpv("", 0);
        else
            RETVAL = newSVpv((char *)bufPtr(buffer), bufUsed(buffer));
    }
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_info); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_info)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, pathExp, ignoreMissing");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__Storage	self;
	const String *	pathExp = STR_NEW_SV(ST(1));
	bool	ignoreMissing = (bool)SvTRUE(ST(2))
;
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::info",
			"self", "pgBackRest::LibC::Storage")
;
    RETVAL = NULL;

    StorageInfo info = storageInfoP(self, pathExp, .ignoreMissing = ignoreMissing);

    if (info.exists)
    {
        String *json = storageManifestXsInfo(NULL, &info);
        RETVAL = newSVpv((char *)strPtr(json), strSize(json));
    }
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_list)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "self, pathExp, ignoreMissing, sortAsc, expression");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__Storage	self;
	const String *	pathExp = STR_NEW_SV(ST(1));
	bool	ignoreMissing = (bool)SvTRUE(ST(2))
;
	bool	sortAsc = (bool)SvTRUE(ST(3))
;
	const String *	expression = STR_NEW_SV(ST(4));
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::list",
			"self", "pgBackRest::LibC::Storage")
;
    StringList *fileList = strLstSort(
        storageListP(self, pathExp, .errorOnMissing = storageFeature(self, storageFeaturePath) ? !ignoreMissing : false,
        .expression = expression), sortAsc ? sortOrderAsc : sortOrderDesc);

    const String *fileListJson = jsonFromVar(varNewVarLst(varLstNewStrLst(fileList)), 0);

    RETVAL = newSVpv(strPtr(fileListJson), strSize(fileListJson));
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_manifest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_manifest)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, pathExp, filter=NULL");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__Storage	self;
	const String *	pathExp = STR_NEW_SV(ST(1));
	const String *	filter = STR_NEW_SV(ST(2));
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::manifest",
			"self", "pgBackRest::LibC::Storage")
;
    StorageManifestXsCallbackData data = {.storage = self, .json = strNew("{"), .pathRoot = pathExp, .filter = filter};

    // If a path is specified
    StorageInfo info = storageInfoP(self, pathExp, .ignoreMissing = true);

    if (!info.exists || info.type == storageTypePath)
    {
        storageInfoListP(
            self, data.pathRoot, storageManifestXsCallback, &data,
            .errorOnMissing = storageFeature(self, storageFeaturePath) ? true : false);
    }
    // Else a file is specified
    else
    {
        info.name = strBase(storagePath(self, pathExp));
        strCat(data.json, strPtr(storageManifestXsInfo(NULL, &info)));
    }

    strCat(data.json, "}");

    RETVAL = newSVpv((char *)strPtr(data.json), strSize(data.json));
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_pathCreate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_pathCreate)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "self, pathExp, mode, ignoreExists, createParent");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__Storage	self;
	const String *	pathExp = STR_NEW_SV(ST(1));
	const String *	mode = STR_NEW_SV(ST(2));
	bool	ignoreExists = (bool)SvTRUE(ST(3))
;
	bool	createParent = (bool)SvTRUE(ST(4))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::pathCreate",
			"self", "pgBackRest::LibC::Storage")
;
    if (storageFeature(self, storageFeaturePath))
        storagePathCreateP(
            self, pathExp, .mode = mode ? cvtZToIntBase(strPtr(mode), 8) : 0, .errorOnExists = !ignoreExists,
            .noParentCreate = !createParent);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_pathExists); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_pathExists)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, pathExp");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__Storage	self;
	const String *	pathExp = STR_NEW_SV(ST(1));
	bool	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::pathExists",
			"self", "pgBackRest::LibC::Storage")
;
    RETVAL = true;

    if (storageFeature(self, storageFeaturePath))
        RETVAL = storagePathExistsNP(self, pathExp);
	ST(0) = boolSV(RETVAL);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_pathGet); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_pathGet)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, pathExp");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__Storage	self;
	const String *	pathExp = STR_NEW_SV(ST(1));
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::pathGet",
			"self", "pgBackRest::LibC::Storage")
;
    String *path = storagePathNP(self, pathExp);
    RETVAL = newSVpv((char *)strPtr(path), strSize(path));
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_pathRemove); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_pathRemove)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, pathExp, ignoreMissing, recurse");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__Storage	self;
	const String *	pathExp = STR_NEW_SV(ST(1));
	bool	ignoreMissing = (bool)SvTRUE(ST(2))
;
	bool	recurse = (bool)SvTRUE(ST(3))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::pathRemove",
			"self", "pgBackRest::LibC::Storage")
;
    storagePathRemoveP(
        self, pathExp, .errorOnMissing = storageFeature(self, storageFeaturePath) ? !ignoreMissing : false, .recurse = recurse);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_pathSync); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_pathSync)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, pathExp");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__Storage	self;
	const String *	pathExp = STR_NEW_SV(ST(1));

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::pathSync",
			"self", "pgBackRest::LibC::Storage")
;
    storagePathSyncNP(self, pathExp);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_put); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_put)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, write, buffer");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageWrite	write;
	const Buffer *	buffer = BUF_CONST_SV(ST(2));
	UV	RETVAL;
	dXSTARG;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pgBackRest::LibC::StorageWrite")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    write = INT2PTR(pgBackRest__LibC__StorageWrite,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::put",
			"write", "pgBackRest::LibC::StorageWrite")
;
    storagePutNP(write, buffer);
    RETVAL = buffer ? bufUsed(buffer) : 0;
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_readDrain); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_readDrain)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, read");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__StorageRead	read;
	bool	RETVAL;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "pgBackRest::LibC::StorageRead")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    read = INT2PTR(pgBackRest__LibC__StorageRead,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::readDrain",
			"read", "pgBackRest::LibC::StorageRead")
;
    RETVAL = false;

    // Read and discard all IO (this is useful for processing filters)
    if (ioReadOpen(storageReadIo(read)))
    {
        Buffer *buffer = bufNew(ioBufferSize());

        do
        {
            ioRead(storageReadIo(read), buffer);
            bufUsedZero(buffer);
        }
        while (!ioReadEof(storageReadIo(read)));

        ioReadClose(storageReadIo(read));
        RETVAL = true;
    }
	ST(0) = boolSV(RETVAL);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_remove); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_remove)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, fileExp, ignoreMissing");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__Storage	self;
	const String *	fileExp = STR_NEW_SV(ST(1));
	bool	ignoreMissing = (bool)SvTRUE(ST(2))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::remove",
			"self", "pgBackRest::LibC::Storage")
;
    storageRemoveP(self, fileExp, .errorOnMissing = storageFeature(self, storageFeaturePath) ? !ignoreMissing : false);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_cipherType); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_cipherType)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	const char *	RETVAL;
	dXSTARG;
    if (cfgOptionStr(cfgOptRepoCipherType) == NULL || cipherType(cfgOptionStr(cfgOptRepoCipherType)) == cipherTypeNone)
        RETVAL = NULL;
    else
        RETVAL = strPtr(cfgOptionStr(cfgOptRepoCipherType));
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_cipherPass); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_cipherPass)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	const char *	RETVAL;
	dXSTARG;
    RETVAL = strPtr(cfgOptionStr(cfgOptRepoCipherPass));
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__Storage_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__Storage_type)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__Storage	self;
	const char *	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::Storage")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__Storage,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::Storage::type",
			"self", "pgBackRest::LibC::Storage")
;
    RETVAL = strPtr(storageType(self));
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_storageRepoFree); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_storageRepoFree)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
    storageHelperFree();
    }
    XSRETURN_EMPTY;
}


/* INCLUDE: Returning to 'xs/postgres/pageChecksum.xs' from 'xs/storage/storage.xs' */


XS_EUPXS(XS_pgBackRest__LibC_pageChecksum); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_pageChecksum)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "page, blockNo, pageSize");
    {
	const char *	page = (const char *)SvPV_nolen(ST(0))
;
	U32	blockNo = (unsigned long)SvUV(ST(1))
;
	U32	pageSize = (unsigned long)SvUV(ST(2))
;
	U16	RETVAL;
	dXSTARG;
    RETVAL = 0;

    ERROR_XS_BEGIN()
    {
        RETVAL = pageChecksum(
            (const unsigned char *)page, blockNo, pageSize);
    }
    ERROR_XS_END();
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'xs/postgres/client.xs' from 'xs/postgres/pageChecksum.xs' */


XS_EUPXS(XS_pgBackRest__LibC__PgClient_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__PgClient_new)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "class, host, port, database, queryTimeout");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	const String *	class = STR_NEW_SV(ST(0));
	const String *	host = STR_NEW_SV(ST(1));
	U32	port = (unsigned long)SvUV(ST(2))
;
	const String *	database = STR_NEW_SV(ST(3));
	UV	queryTimeout = (UV)SvUV(ST(4))
;
	pgBackRest__LibC__PgClient	RETVAL;
    CHECK(strEqZ(class, PACKAGE_NAME_LIBC "::PgClient"));

    memContextSwitch(MEM_CONTEXT_XS_OLD());
    RETVAL = pgClientNew(host, port, database, NULL, queryTimeout);
    memContextSwitch(MEM_CONTEXT_XS_TEMP());
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "pgBackRest::LibC::PgClient", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__PgClient_open); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__PgClient_open)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__PgClient	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::PgClient")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__PgClient,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::PgClient::open",
			"self", "pgBackRest::LibC::PgClient")
;
    pgClientOpen(self);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_pgBackRest__LibC__PgClient_query); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__PgClient_query)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, query");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__PgClient	self;
	const String *	query = STR_NEW_SV(ST(1));
	const char *	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::PgClient")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__PgClient,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::PgClient::query",
			"self", "pgBackRest::LibC::PgClient")
;
    VariantList *result = pgClientQuery(self, query);
    RETVAL = result ? strPtr(jsonFromVar(varNewVarLst(result), 0)) : NULL;
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC__PgClient_close); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__PgClient_close)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__PgClient	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "pgBackRest::LibC::PgClient")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__PgClient,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"pgBackRest::LibC::PgClient::close",
			"self", "pgBackRest::LibC::PgClient")
;
    pgClientClose(self);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_pgBackRest__LibC__PgClient_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC__PgClient_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
	pgBackRest__LibC__PgClient	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(pgBackRest__LibC__PgClient,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"pgBackRest::LibC::PgClient::DESTROY",
			"self")
;
    pgClientFree(self);
    }
    MEM_CONTEXT_XS_TEMP_END();
    }
    XSRETURN_EMPTY;
}


/* INCLUDE: Returning to 'xs/crypto/random.xs' from 'xs/postgres/client.xs' */


XS_EUPXS(XS_pgBackRest__LibC_cryptoRandomBytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cryptoRandomBytes)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "size");
    {
	I32	size = (I32)SvIV(ST(0))
;
	SV *	RETVAL;
    RETVAL = newSV(size);
    SvPOK_only(RETVAL);

    cryptoRandomBytes((unsigned char *)SvPV_nolen(RETVAL), size);

    SvCUR_set(RETVAL, size);
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'xs/crypto/hash.xs' from 'xs/crypto/random.xs' */


XS_EUPXS(XS_pgBackRest__LibC_cryptoHashOne); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cryptoHashOne)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "type, message");
    {
	const char *	type = (const char *)SvPV_nolen(ST(0))
;
	SV *	message = ST(1)
;
	SV *	RETVAL;
    RETVAL = NULL;

    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
        STRLEN messageSize;
        const void *messagePtr = SvPV(message, messageSize);

        String *hash = bufHex(cryptoHashOne(strNew(type), BUF(messagePtr, messageSize)));

        RETVAL = newSV(strSize(hash));
        SvPOK_only(RETVAL);
        strcpy((char *)SvPV_nolen(RETVAL), strPtr(hash));
        SvCUR_set(RETVAL, strSize(hash));
    }
    MEM_CONTEXT_XS_TEMP_END();
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'xs/config/define.xs' from 'xs/crypto/hash.xs' */


XS_EUPXS(XS_pgBackRest__LibC_cfgCommandId); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgCommandId)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "commandName");
    {
	const char *	commandName = (const char *)SvPV_nolen(ST(0))
;
	I32	RETVAL;
	dXSTARG;
    RETVAL = 0;

    ERROR_XS_BEGIN()
    {
        RETVAL = cfgCommandId(commandName);
    }
    ERROR_XS_END();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_cfgOptionId); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgOptionId)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "optionName");
    {
	const char *	optionName = (const char *)SvPV_nolen(ST(0))
;
	I32	RETVAL;
	dXSTARG;
    RETVAL = 0;

    ERROR_XS_BEGIN()
    {
        RETVAL = cfgOptionId(optionName);
    }
    ERROR_XS_END();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_cfgDefOptionDefault); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgDefOptionDefault)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "commandId, optionId");
    {
	U32	commandId = (unsigned long)SvUV(ST(0))
;
	U32	optionId = (unsigned long)SvUV(ST(1))
;
	const char *	RETVAL;
	dXSTARG;
    RETVAL = NULL;

    ERROR_XS_BEGIN()
    {
        RETVAL = cfgDefOptionDefault(cfgCommandDefIdFromId(commandId), cfgOptionDefIdFromId(optionId));
    }
    ERROR_XS_END();
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_cfgDefOptionPrefix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgDefOptionPrefix)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "optionId");
    {
	U32	optionId = (unsigned long)SvUV(ST(0))
;
	const char *	RETVAL;
	dXSTARG;
    RETVAL = NULL;

    ERROR_XS_BEGIN()
    {
        RETVAL = cfgDefOptionPrefix(cfgOptionDefIdFromId(optionId));
    }
    ERROR_XS_END();
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_cfgDefOptionSecure); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgDefOptionSecure)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "optionId");
    {
	U32	optionId = (unsigned long)SvUV(ST(0))
;
	bool	RETVAL;
    RETVAL = false;

    ERROR_XS_BEGIN()
    {
        RETVAL = cfgDefOptionSecure(cfgOptionDefIdFromId(optionId));
    }
    ERROR_XS_END();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_cfgDefOptionType); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgDefOptionType)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "optionId");
    {
	U32	optionId = (unsigned long)SvUV(ST(0))
;
	I32	RETVAL;
	dXSTARG;
    RETVAL = 0;

    ERROR_XS_BEGIN()
    {
        RETVAL = cfgDefOptionType(cfgOptionDefIdFromId(optionId));
    }
    ERROR_XS_END();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_cfgDefOptionValid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgDefOptionValid)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "commandId, optionId");
    {
	U32	commandId = (unsigned long)SvUV(ST(0))
;
	U32	optionId = (unsigned long)SvUV(ST(1))
;
	bool	RETVAL;
    RETVAL = false;

    ERROR_XS_BEGIN()
    {
        RETVAL = cfgDefOptionValid(cfgCommandDefIdFromId(commandId), cfgOptionDefIdFromId(optionId));
    }
    ERROR_XS_END();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_cfgOptionTotal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgOptionTotal)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	U32	RETVAL;
	dXSTARG;
    RETVAL = CFG_OPTION_TOTAL;
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'xs/config/configTest.xs' from 'xs/config/define.xs' */


XS_EUPXS(XS_pgBackRest__LibC_cfgParseTest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgParseTest)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "backrestBin, parseParam");
    {
	const char *	backrestBin = (const char *)SvPV_nolen(ST(0))
;
	const char *	parseParam = (const char *)SvPV_nolen(ST(1))
;
	SV *	RETVAL;
    RETVAL = NULL;

    ERROR_XS_BEGIN()
    {
        // This should run in a temp context but for some reason getopt_long gets upset when if gets called again after the previous
        // arg list being freed.  So, this is a memory leak but it is only used for testing, not production.
        StringList *paramList = strLstNewSplitZ(strCat(strNew("pgbackrest|"), parseParam), "|");

        // Don't use cfgLoad() because it has a lot of side effects that we don't want
        configParse(strLstSize(paramList), strLstPtr(paramList), false);
        cfgExeSet(strNew(backrestBin));
        cfgLoadUpdateOption();

        String *result = perlOptionJson();

        RETVAL = newSV(strSize(result));
        SvPOK_only(RETVAL);

        strcpy(SvPV_nolen(RETVAL), strPtr(result));
        SvCUR_set(RETVAL, strSize(result));
    }
    ERROR_XS_END()
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'xs/config/config.xs' from 'xs/config/configTest.xs' */


XS_EUPXS(XS_pgBackRest__LibC_cfgCommandName); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgCommandName)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "commandId");
    {
	U32	commandId = (unsigned long)SvUV(ST(0))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = cfgCommandName(commandId);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_cfgOptionIndex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgOptionIndex)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "optionId");
    {
	U32	optionId = (unsigned long)SvUV(ST(0))
;
	I32	RETVAL;
	dXSTARG;

	RETVAL = cfgOptionIndex(optionId);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_cfgOptionIndexTotal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgOptionIndexTotal)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "optionId");
    {
	U32	optionId = (unsigned long)SvUV(ST(0))
;
	I32	RETVAL;
	dXSTARG;

	RETVAL = cfgOptionIndexTotal(optionId);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_cfgOptionName); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_cfgOptionName)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "optionId");
    {
	U32	optionId = (unsigned long)SvUV(ST(0))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = cfgOptionName(optionId);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'xs/common/lock.xs' from 'xs/config/config.xs' */


XS_EUPXS(XS_pgBackRest__LibC_lockAcquire); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_lockAcquire)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "lockPath, command, stanza, lockTimeout, failOnNoLock");
    {
	const char *	lockPath = (const char *)SvPV_nolen(ST(0))
;
	const char *	command = (const char *)SvPV_nolen(ST(1))
;
	const char *	stanza = (const char *)SvPV_nolen(ST(2))
;
	double	lockTimeout = (double)SvNV(ST(3))
;
	bool	failOnNoLock = (bool)SvTRUE(ST(4))
;
	bool	RETVAL;
    RETVAL = false;

    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
        // Set the command so we can get the correct lock type to use
        cfgCommandSet(cfgCommandId(command));

        // Attempt to acquire the lock
        if (cfgLockRequired())
            RETVAL = lockAcquire(strNew(lockPath), strNew(stanza), cfgLockType(), (TimeMSec)(lockTimeout * 1000), failOnNoLock);
    }
    MEM_CONTEXT_XS_TEMP_END();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_lockRelease); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_lockRelease)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "failOnNoLock");
    {
	bool	failOnNoLock = (bool)SvTRUE(ST(0))
;
	bool	RETVAL;
    RETVAL = false;

    MEM_CONTEXT_XS_TEMP_BEGIN()
    {
        RETVAL = lockRelease(failOnNoLock);
    }
    MEM_CONTEXT_XS_TEMP_END();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'xs/common/encode.xs' from 'xs/common/lock.xs' */


XS_EUPXS(XS_pgBackRest__LibC_encodeToStr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_encodeToStr)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "encodeType, source");
    {
	int	encodeType = (int)SvIV(ST(0))
;
	SV *	source = ST(1)
;
	SV *	RETVAL;
    RETVAL = NULL;

    STRLEN sourceSize;
    unsigned char *sourcePtr = (unsigned char *)SvPV(source, sourceSize);

    ERROR_XS_BEGIN()
    {
        RETVAL = newSV(encodeToStrSize(encodeType, sourceSize));
        SvPOK_only(RETVAL);

        encodeToStr(encodeType, sourcePtr, sourceSize, (char *)SvPV_nolen(RETVAL));
        SvCUR_set(RETVAL, encodeToStrSize(encodeType, sourceSize));
    }
    ERROR_XS_END();
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_pgBackRest__LibC_decodeToBin); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_pgBackRest__LibC_decodeToBin)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "encodeType, source");
    {
	int	encodeType = (int)SvIV(ST(0))
;
	const char *	source = (const char *)SvPV_nolen(ST(1))
;
	SV *	RETVAL;
    RETVAL = NULL;

    ERROR_XS_BEGIN()
    {
        RETVAL = newSV(decodeToBinSize(encodeType, source));
        SvPOK_only(RETVAL);

        decodeToBin(encodeType, source, (unsigned char *)SvPV_nolen(RETVAL));
        SvCUR_set(RETVAL, decodeToBinSize(encodeType, source));
    }
    ERROR_XS_END();
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'LibC.xs' from 'xs/common/encode.xs' */

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_pgBackRest__LibC); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_pgBackRest__LibC)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("pgBackRest::LibC::libcUvSize", XS_pgBackRest__LibC_libcUvSize);
        newXS_deffile("pgBackRest::LibC::StorageWrite::new", XS_pgBackRest__LibC__StorageWrite_new);
        newXS_deffile("pgBackRest::LibC::StorageWrite::filterAdd", XS_pgBackRest__LibC__StorageWrite_filterAdd);
        newXS_deffile("pgBackRest::LibC::StorageWrite::open", XS_pgBackRest__LibC__StorageWrite_open);
        newXS_deffile("pgBackRest::LibC::StorageWrite::write", XS_pgBackRest__LibC__StorageWrite_write);
        newXS_deffile("pgBackRest::LibC::StorageWrite::close", XS_pgBackRest__LibC__StorageWrite_close);
        newXS_deffile("pgBackRest::LibC::StorageWrite::result", XS_pgBackRest__LibC__StorageWrite_result);
        newXS_deffile("pgBackRest::LibC::StorageWrite::resultAll", XS_pgBackRest__LibC__StorageWrite_resultAll);
        newXS_deffile("pgBackRest::LibC::StorageWrite::DESTROY", XS_pgBackRest__LibC__StorageWrite_DESTROY);
        newXS_deffile("pgBackRest::LibC::StorageRead::new", XS_pgBackRest__LibC__StorageRead_new);
        newXS_deffile("pgBackRest::LibC::StorageRead::filterAdd", XS_pgBackRest__LibC__StorageRead_filterAdd);
        newXS_deffile("pgBackRest::LibC::StorageRead::open", XS_pgBackRest__LibC__StorageRead_open);
        newXS_deffile("pgBackRest::LibC::StorageRead::read", XS_pgBackRest__LibC__StorageRead_read);
        newXS_deffile("pgBackRest::LibC::StorageRead::eof", XS_pgBackRest__LibC__StorageRead_eof);
        newXS_deffile("pgBackRest::LibC::StorageRead::close", XS_pgBackRest__LibC__StorageRead_close);
        newXS_deffile("pgBackRest::LibC::StorageRead::result", XS_pgBackRest__LibC__StorageRead_result);
        newXS_deffile("pgBackRest::LibC::StorageRead::resultAll", XS_pgBackRest__LibC__StorageRead_resultAll);
        newXS_deffile("pgBackRest::LibC::StorageRead::DESTROY", XS_pgBackRest__LibC__StorageRead_DESTROY);
        newXS_deffile("pgBackRest::LibC::Storage::new", XS_pgBackRest__LibC__Storage_new);
        newXS_deffile("pgBackRest::LibC::Storage::bucketCreate", XS_pgBackRest__LibC__Storage_bucketCreate);
        newXS_deffile("pgBackRest::LibC::Storage::copy", XS_pgBackRest__LibC__Storage_copy);
        newXS_deffile("pgBackRest::LibC::Storage::exists", XS_pgBackRest__LibC__Storage_exists);
        newXS_deffile("pgBackRest::LibC::Storage::get", XS_pgBackRest__LibC__Storage_get);
        newXS_deffile("pgBackRest::LibC::Storage::info", XS_pgBackRest__LibC__Storage_info);
        newXS_deffile("pgBackRest::LibC::Storage::list", XS_pgBackRest__LibC__Storage_list);
        newXS_deffile("pgBackRest::LibC::Storage::manifest", XS_pgBackRest__LibC__Storage_manifest);
        newXS_deffile("pgBackRest::LibC::Storage::pathCreate", XS_pgBackRest__LibC__Storage_pathCreate);
        newXS_deffile("pgBackRest::LibC::Storage::pathExists", XS_pgBackRest__LibC__Storage_pathExists);
        newXS_deffile("pgBackRest::LibC::Storage::pathGet", XS_pgBackRest__LibC__Storage_pathGet);
        newXS_deffile("pgBackRest::LibC::Storage::pathRemove", XS_pgBackRest__LibC__Storage_pathRemove);
        newXS_deffile("pgBackRest::LibC::Storage::pathSync", XS_pgBackRest__LibC__Storage_pathSync);
        newXS_deffile("pgBackRest::LibC::Storage::put", XS_pgBackRest__LibC__Storage_put);
        newXS_deffile("pgBackRest::LibC::Storage::readDrain", XS_pgBackRest__LibC__Storage_readDrain);
        newXS_deffile("pgBackRest::LibC::Storage::remove", XS_pgBackRest__LibC__Storage_remove);
        newXS_deffile("pgBackRest::LibC::Storage::cipherType", XS_pgBackRest__LibC__Storage_cipherType);
        newXS_deffile("pgBackRest::LibC::Storage::cipherPass", XS_pgBackRest__LibC__Storage_cipherPass);
        newXS_deffile("pgBackRest::LibC::Storage::type", XS_pgBackRest__LibC__Storage_type);
        newXS_deffile("pgBackRest::LibC::storageRepoFree", XS_pgBackRest__LibC_storageRepoFree);
        newXS_deffile("pgBackRest::LibC::pageChecksum", XS_pgBackRest__LibC_pageChecksum);
        newXS_deffile("pgBackRest::LibC::PgClient::new", XS_pgBackRest__LibC__PgClient_new);
        newXS_deffile("pgBackRest::LibC::PgClient::open", XS_pgBackRest__LibC__PgClient_open);
        newXS_deffile("pgBackRest::LibC::PgClient::query", XS_pgBackRest__LibC__PgClient_query);
        newXS_deffile("pgBackRest::LibC::PgClient::close", XS_pgBackRest__LibC__PgClient_close);
        newXS_deffile("pgBackRest::LibC::PgClient::DESTROY", XS_pgBackRest__LibC__PgClient_DESTROY);
        newXS_deffile("pgBackRest::LibC::cryptoRandomBytes", XS_pgBackRest__LibC_cryptoRandomBytes);
        newXS_deffile("pgBackRest::LibC::cryptoHashOne", XS_pgBackRest__LibC_cryptoHashOne);
        newXS_deffile("pgBackRest::LibC::cfgCommandId", XS_pgBackRest__LibC_cfgCommandId);
        newXS_deffile("pgBackRest::LibC::cfgOptionId", XS_pgBackRest__LibC_cfgOptionId);
        newXS_deffile("pgBackRest::LibC::cfgDefOptionDefault", XS_pgBackRest__LibC_cfgDefOptionDefault);
        newXS_deffile("pgBackRest::LibC::cfgDefOptionPrefix", XS_pgBackRest__LibC_cfgDefOptionPrefix);
        newXS_deffile("pgBackRest::LibC::cfgDefOptionSecure", XS_pgBackRest__LibC_cfgDefOptionSecure);
        newXS_deffile("pgBackRest::LibC::cfgDefOptionType", XS_pgBackRest__LibC_cfgDefOptionType);
        newXS_deffile("pgBackRest::LibC::cfgDefOptionValid", XS_pgBackRest__LibC_cfgDefOptionValid);
        newXS_deffile("pgBackRest::LibC::cfgOptionTotal", XS_pgBackRest__LibC_cfgOptionTotal);
        newXS_deffile("pgBackRest::LibC::cfgParseTest", XS_pgBackRest__LibC_cfgParseTest);
        newXS_deffile("pgBackRest::LibC::cfgCommandName", XS_pgBackRest__LibC_cfgCommandName);
        newXS_deffile("pgBackRest::LibC::cfgOptionIndex", XS_pgBackRest__LibC_cfgOptionIndex);
        newXS_deffile("pgBackRest::LibC::cfgOptionIndexTotal", XS_pgBackRest__LibC_cfgOptionIndexTotal);
        newXS_deffile("pgBackRest::LibC::cfgOptionName", XS_pgBackRest__LibC_cfgOptionName);
        newXS_deffile("pgBackRest::LibC::lockAcquire", XS_pgBackRest__LibC_lockAcquire);
        newXS_deffile("pgBackRest::LibC::lockRelease", XS_pgBackRest__LibC_lockRelease);
        newXS_deffile("pgBackRest::LibC::encodeToStr", XS_pgBackRest__LibC_encodeToStr);
        newXS_deffile("pgBackRest::LibC::decodeToBin", XS_pgBackRest__LibC_decodeToBin);
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}
