;;; Test case to be able to profile pgloader.

#|
CREATE TABLE IF NOT EXISTS `plenty` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
|#

(defpackage #:pgloader.test.profileme
  (:use #:cl #:pgloader.params #:pgloader.mysql)
  (:export #:produce-data))

(in-package #:pgloader.test.profileme)

(defun produce-data (&key
                       ((:host *myconn-host*) *myconn-host*)
                       ((:port *myconn-port*) *myconn-port*)
                       ((:user *myconn-user*) *myconn-user*)
                       ((:pass *myconn-pass*) *myconn-pass*)
                       (dbname "profileme")
                       (rows 1250000))
  "Insert data to reproduce the test case."
  (with-mysql-connection (dbname)
    (loop :repeat rows
       :do (pgloader.mysql::mysql-query
            (format nil "INSERT INTO `plenty` (`content`) VALUES ('~a');"
                    (make-string (random 4196) :initial-element #\a))))))
