#!/usr/bin/python

# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

# Follows PEP8

import glob
import os
from subprocess import call

TOC = '''
.. toctree::
   :maxdepth: 2

%s

'''

AUTO = '''
.. automodule:: %s
   :members:
   :undoc-members:
   :show-inheritance:
'''


def title(header):
    return '%s\n%s\n'%(header, '*'*len(header))


def auto(module):
    return AUTO%module


def toc(modules):
    modules.sort()
    if not modules:
        return ''
    contents = '\n'.join(['   '+m for m in modules])
    return TOC%contents


def write(filename, module, children):
    f = open(filename, 'w')
    f.write(title(module.split('.')[-1])+auto(module)+toc(children))
    f.close()


def update(py_root, rst_root='source', exclude=['index.rst']):

    def get_rst_file(module):
        return os.path.join(rst_root, module+'.rst')

    for f in [f for f in glob.glob(os.path.join(rst_root, '*.rst'))
        if not os.path.basename(f) in exclude]:
        os.remove(f)

    root = py_root
    n = len(root)
    for parent, dirs, files in os.walk(root):
        modules = []
        rel_path = parent[n:].strip(os.path.sep)

        def get_module(path, append=True):
            """Transforms a path in a modulename and its rst location.
            """
            if append:
                parent = rel_path
            else:
                parent = ''
            module = os.path.join(parent, os.path.splitext(path)[0])\
                .replace(os.path.sep, '.')
            if append:
                modules.append(module)
            rst_file = get_rst_file(module)
            return module, rst_file

        #add subpackage dirs
        for d in dirs:
            module, rst_file = get_module(d)
        #add module files
        if '__init__.py' in files:
            files.remove('__init__.py')
        for file in files:
            if not (file.endswith('.py') and rel_path):
                continue
            module, rst_file = get_module(file)
            write(rst_file, module, [])
        if rel_path:
            module, rst_file = get_module(rel_path, append=False)
        else:
            module = 'index2'
            rst_file = get_rst_file(module)
        write(rst_file, module, modules)


def main(py_root, rst_root='source', exclude=['index.rst']):
    update(py_root, rst_root, exclude)
    call('make html', shell=True)


if __name__ == '__main__':
    py_root = os.path.abspath('../phatch')
    main(py_root)
    #update(py_root)
