# -*- coding: UTF-8 -*-

# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008  www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

from urllib import unquote
from subprocess import call
import nautilus

from phatch.core.config import load_locale_only
load_locale_only()

class phatch_image_inspector_extension(nautilus.MenuProvider):
    def __init__(self):
        pass
        
    def menu_activate_cb(self, menu, files):
        for file in files:
            if file.is_gone():
                return
        files = ["'%s'"%unquote(file.get_uri()[7:]) for file in files]
        call('phatch -n %s &'%' '.join(files),shell=True)
        
    def get_file_items(self, window, files):
        #only directories and readable image files are accepted
        files   = [file for file in files
            if (file.get_uri_scheme() == 'file' and \
            file.get_mime_type() in ['image/bmp', 'image/bw', 
            'image/cmyk', 'image/cur', 'image/dcx',
            'image/flc', 'image/fli', 'image/fpx', 'image/gbr', 
            'image/gd', 'image/gif', 'image/ico', 'image/im', 
            'image/imt', 'image/jpe', 'image/jpeg', 'image/jpg', 
            'image/mcidas', 'image/mic', 'image/msp', 'image/pbm', 
            'image/pcd', 'image/pcx', 'image/pgm', 'image/png', 
            'image/ppm', 'image/psd', 'image/rgb', 'image/sun', 
            'image/tga', 'image/tif', 'image/tiff', 'image/xbm', 
            'image/xpm'])]
        #return if nothing to do
        if not files: return
        #install menu
        item = nautilus.MenuItem(
            'NautilusPython::phatch_image_inspector',
            _("Inspect with Phatch")+"...",
            _("Inspect EXIF & IPTC tags"))
        #bind/connect menu item with method
        item.connect('activate', self.menu_activate_cb, files)
        #return menu item
        return item,
