# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is designed by Alexandre Moore (http://nuovext.pwsp.net/).

# Follows PEP8

import os
from core import ct, models
from lib.reverse_translation import _t


class Action(models.Action):
    """Defined variables: <filename> <type> <folder> <width> <height>"""

    label = _t('Write Tag')
    author = 'Stani'
    email = 'spe.stani.be@gmail.com'
    version = '0.1'
    tags = [_t('metadata')]
    __doc__ = _t('Write new value to a tag')

    def interface(self, fields):
        fields[_t('Tag (Exif, Iptc)')]= self.ExifItpcField(
            'Exif_Image_Copyright', choices=self.EXIF_IPTC)
        fields[_t('Value')] = self.CharField('Phatch')

    def apply(self, photo, setting, cache):
        info = photo.info
        tag = self.get_field('Tag (Exif, Iptc)', info)
        value = self.get_field('Value', info).strip()
        if value == '':
            value = None
        info[tag] = value
        return photo

    icon = \
'x\xda\x01\x9d\x0bb\xf4\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x0bTIDATh\x81\xed\x99{l\x1c\xc7}\xc7?3\xb3{{{\x0f\x1e\
I\xf1xTH\xeba\xf1!\x1b\xb6i\xd7\x8dT\xcb\x8a\xa4\xd8\xb1\xdc\xc6\x0c\xd0F1\
\x10\x05\r\x9c\x18q\x1d\xe5\xa1\x00A\x11\xa0\r\xd0\xc8\xfe\xa3\xad\x9b\xa6F\
\xff\x88\x9d\xc4\t\x1c\t\x01\xea\xa2F\xdc\xbav`D\xae\x8d\xc2v\x15\xc7\xb2e:\
\xb6\xa9 z0\x92H\x8a\x14\xc9\xe3\xfb\x1e\xbb;\xd3?\xf6\x8e\xbc\x17i\xa1i\xaa\
\x06\xf0\x00\x83\xdb\x9d\x99\x9d\xfd~\x7f\xbf\xef\xfc\xe6w\xb3\xc2\x18\xc3\
\xefr\x91W\x1a\xc0oZ\xde\'p\xa5\xcb\xfb\x04\xaet\xb1\xae4\x00\x80G\x1f}T\xbc\
\xfc\xf2S\xee\xc7\xf7m\xef\xe9\xeal\xb99\xe2D\xfe\xe0_\x9fz\xf3\xe1\x07\x1e\
\xf8\xfe\xd0{={E\x08\xdc{\xef\xbdr\xd7\xae\xa6d\xba=\xbe1\xd3\xde|\xeb\x9dw\
\xc6w~\xe2\xee\xfd\xdb\\\xd7Z\x1fq\xac\xb81\xc2\x9c?\xb7\xf9\x18\xf0\xff\x87\
@oo\xaf\xfd\xd7\x7f3p]_\xdf\xfa\x9d\xdf8t\xd3\xeex\xc2\xe9\x8f\xc5\xecM\xb6\
\xad,)\x05B\x08@\x00\x06c\x10]]\xa9\x8f\x00\x8f\xbf\xd7\xbc\xe2\xb7\xb1\x91\
\x1d<xPtw\xcf\xa5~\xff\x83\x9b\xaekm\x8d\xde\x92L:;\xddX\xe4\xd6D\xdcY\xa7\
\x94@HJ`e\xe9\xb7\xb2\x86m\xe7\xcf\xe7\xc6n\xea\xff\xf3-\xd3\xd3\xd3\xb9\xb5\
\xde\xf5\xbf\xe2\x81/\x7f\xf9S\xea\xae\x81\r\xeb\x9aSVO[[b\xf7_\xfc\xe5\xc6]\
\xc9\xa4s\xbde\xcb\xb4eI[\x08J\x16\xd6\x15@\x01*\x8dW\xdd\x96N\xbb\x1d\xf7\
\xdcsW/0\xb8\xd6\xbb\xffG\x1ex\xf1\xc5\x17y\xfc\xf1\x07\xdd\xfb\xee\xdbyKgWr\
G"a\xef\x8aF\xe5\rQ\xd7jW\x12!\xaab[\xad\x85\xeb\xad\xbd\x12\x0cW\xee\x8d\
\x16\xfc\xc7\xf3#_\x85\x1b\x1e\xde\xbbw\xefoF`\xdf\xbe}\xf2\x93\xfb7\xb6ww\
\xa7\xafO&#{\x12I\xeb\xd6x\xdc\xde\x16\x8d\nWJ\x83\x10\x9a\x15k\xd6\xce\xb7\
\x1a`A.\x17\xe0\xba\x11\xaa\xa5\xb42\xe6\xe4\xd0\xdcs\x03w=\xf4\xb13g\xce\
\xf8\x97M\xe0\xec\xd9\xb3|\xe5+\x7f\xea~\xf6\xde;wf\xda\xed\xab\xda3\xf1\xde\
x\xdc\xda\x95H\xda\xddN\x84uR\x19)\x84A\x08\x03\x04%\xc0e\x02\xe5Z\x06^\xfe\
\xad\x04\x1e^\xff\xe4\xd9S\x9c=;\xc3\x17\xbftK\x03\x02\xa1G.\x8e\x15\xc7_\
\x7f}\xf4k\x99L\xf3\xfc\xdf=\xf4\x93\x17\x9e|\xf2\x99\xd9Z\x02\xcbk\xa0\xb7\
\xb7\xd7\xfa\x87\x87?}{oo\xdbm\xdf\xf9\xee=;\xa3\xae}K".\x85R\x06!\xcb\x00u\
\x85\x95+\xdbj\xfb+\xad/K}\xa2\xaa\'\x9f\xf7\x99\x9c\\Z\xcd\xb0\x80\xa0\xa5%\
\x9a\xe9\xefO\x1fN\xa7Sl\xdf~\xd3\xcd\xc0\x1b\xb5\xa3\x96\xd5:55eo\xde\x94\
\xfe\xc1\x96\xee\xa6\xafu\xac\x8f\xedhnV\xc2\xb2aE\xcfe\xeb\xd6Z\xbb\xb2]\
\x03>\xa1g*e\x05\xb5\xd2\xea\xeajbddn\x15\xf0\xe1\xd8\x88\x03A\x00J\x19\xd2i\
w\xf33\xcf\xfe\xed\xe6C\x87\xeeKU\x8e\\\xf6\xc0\xe1\xc3\x87s\xd33\xa7\x8fC\
\xb2\xb3~\xb2Z]\xd7\xca\xa5\xd1\xb8\xcahC\xddu\xba=\xce\xa5K\x8b\xcc\xce\x16\
H\xa5\xdc\x9ag\xc2\xb1B\x80R\n\xcf\xf3\xd9\xf9\xa1\x8e\x1ff2\xae\xef\xba\xb1\
\xaf\x03\x8f\x94gZ\xb6\xef\xc0\xc0\x00\xa3\x17f\x8f\xe9Z\x15\\v)\xcb\xc5\xa2\
X\x84\xa3G\xcf\x93\xcb\xd5\x86\xcd\x15\x12]])lK2\xf4\xeeD\x03\xb2+s&\x93Q\
\x16\x16\n\xb8\xaeH\xc4b\xa29\xe6:\xc9\xca\x11U\x01oxx\xe9\xb5|.\xf0.\x0flmt\
Q\xa5*\x99\x9f\x0b\xf8\xc7\x87\xdf\xe0\xd5W/\xb2\xb2(\x15\x95\x0b\xda\xb6-n\
\xba\xb9\x93\x97_\xfe\xf5*s\x86\x84b1\x8b|ne\r)%\xcb\xee\xaa\'p\xf4\xe8\xcf\
\xdf\x99\x9d\xd5\xd3\x8d\xc1\xae\x06\xbc2\xc2\x84$\xd6\xb5\xc5\xf9\xf8\xbe\
\xad\xfc\xf3\x13\'\xc9\xe54\xd9l\x81\x0b\x17\xe6\x99\x9b\xf3\xaa\x9e\xff\xe8\
\x1f\xf5\xb1k\xd7\xd5\x04\x81\xa1\xde\x0b\xe1\xbde\x0b\x8a\xcb&5H)\x9cU\t\
\x9c:ufz||\xe94\rK-\x89Z\xe0!\x99\x89\x89<\x87\x7f\xf86##\xf3\xfc\xe2\xad\t\
\xbe\xf9\xd0\xcf8\xfa\xd3a\xde}w\n\xa5\x14G\x0e\x0f\xf2\xd8\xf7^\x07\x04\xfd\
7v\x12h\xc3#\x8f\x1c\xc3\x98z\xebC\xb8\x83\xdb\xb6\x8d\xefk\x84\x00)EdU\x02\
\xc3\xc3\xc3\xde\xc4x\xe1\xbf\xea\'\x0bk.\x17\xd4\x80/\x03\x0f-\xaf\xb5$\x9b\
-r\xc7\xde\x1e\xfa\xfb\xd7\xf3\xe1\xdb6322\xcf\x1f\xff\xc9\xb5\xec\xd9s5G\
\x7fz\x9a#GNp\xe3\x8d\x9d\xcbs(\xa5\xf8\xd4\xfe\x9b+\x92\xb9\xeaj\x0c\xb4\
\xb4\xba\xcc\xcf\x87!W*\x19]\x95@\xe8\x85\xf1c^\xb1^*g\xced\xf9\xd2\x17\xfe\
\x1d\xad\xab\xe5c\x8cDk\xc1\xe4d\x01c$}}i\xc6\xc7s|\xeb\xef\x8f\xb1m\xfbU\
\x0c\x0f\xcf088\xc1;\xefL244\x89\x13\xb1\xf8@gj\xd9\xe2\xdb\xb6md][\xa21x\r:\
\x08p\x1c\x1fL\x08U\xa9j\x0f\xd4%s\x17/\xe6\xde\x9a\x99\xf1\x96\xda3Vl\xa5\
\xd5\xd0\xd2\x12gtt\x9e\xd1\xd1\x05l[244\xc1\xd6\xadm<\xf9/o\xd3\xd3\xbb\x8e\
o>\xf4\x12\x9f\xb8\xfb:\xee\xff\xfc\x07y\xec\xbb\xc7I69$\x13Q>|\xdb\x16\x9e}\
\xe6\x97\x1cz\xe0\x0e\xfa\xfa2\x14\xf2\x01_<\xf0\x14\xd7_\xdf\xc1\xee==\xdc\
\xfe\x91\xde\x86\xd67\x1a\xb4\x0e\x08\xb4\x8f\x0e|,\xdb&\x08\x0cR\n{M\x02\
\xc7\x8f\x9f\x1c\xcdfo\xf8U{\xc6\xee\xaftT*\xe5\xd2\xdd\xd3\xc6\xf1\xd7F\x18\
\x1c\x1c\xe3\xcf\xee\xdf\xceL6\xc7\x8f\x7f\xfc.MI\x87\x07\x1e\xbc\x83o\xfc\
\xd5\xf347\xc7\x18\x19\x99\'\x1e\x8b\xd0\xdd\x9d&\xd3\x91\xe2\xf4\xa9)@\x12\
\x8b9\x1cz\xf0\x0fY\\,\xe2y\x86\xa6&\xb7\x1e\xbc\te\xa3u\x80\xd6>Z{\x04\xda\
\'\xea*ry\x0f!\xaa1\xd7\x11\x10B\xe4\'\xc6\x97\xde\xea\xdb\x1a\xab  \x90Rp\
\xed\xb5\x19\x9e\xf8\xa7A>\xb4k3\x1d\x1dM\xa4R.1\xd7\xe6\xae\x81k\xd8q\xebfv\
\xef\xb9\x9a\x97^\xfa5\x1b64\xf3\xd1\x81k\xe8\xecjF\x08\xc15\xd7tT\x81\x8c\
\xc7\xa35\x16\xa7\x04^\xa2\x8d\t\x81\x07>Z\xfb\x04\x81\x0f\x02\x9a\x92\t\x16\
\x17\x17\x90B\xaeM\xe0\xb9\xe7\x9e\xd3G\x8e|\xeb\xe7;\x8d\xf8\xb4\xa8\xd9[6l\
let\xf4\x04\xcf?\x7f\x8ab1`\xff\xfe\xdf\xa3\xa77\x8d\xb2\x14B(\xee\xff\xfc\
\x0e\xb46tt$+\x80Q\rr\x95\x90l\x8c\xc0\xe8\x12x\xed\x13\x04\x1eZ{\x08a\xe1DS\
XV\x84\xb1\x8b\x93(\x19\xabZ\xb7\rO%N\x9c8wzq\xb1>\xcewv6\xd3\xdd\xdd\xc6\
\xf7\x7f\xf0I\x12I\x97\xcf~\xe6\t0\x82\xbe\xde\x0c ioo\xa2\xa3#U\xf1\\u\x88\
\xad\xaf\xa5\xdc\xdf\x08\x8c\xd1h\xed\x95$\x13V)m\x9ch3J\xd9H)\x98\x9b+R,\
\xfajM\x0f\x00\xa4\xd3\x99\xb9\x89\xf1\x02\x89D9b\t\xc0\xe0\xba\x0e\xf9\x82O\
"\x11\xe5s\x9f\xdb\xc1\xa6M\xeb\xf8\xdew^\xa1\xbb\']c\xddZ\xcb7\xb2>\x15\x96\
\xd7\xe1\x82\rV4\xafd\x04\xc7I!K\x8a\xc9\xe7\x0cJj\x8aE\xbf\xea%\r\td2\x19\
\x91\xcfi0"\xcc\xa8J\xe9\xb0m[\x14\xf2>\xbe\x0f\x8e#\xb9\xfd\xf6>\xfa\xfb\
\xbbhoO\xac\x02\xfa\xbd\xc0\x87aR\x9bP\xf3e\xd9X\x96K$\x92D*+\x1co\xe0\xec\
\xd9\x19\xa2\xae@\n\xbb\xea\x05\r%\xe48\x96c0\x04U1?$\x90\xcf\xfb\xf8~HHJE{{\
\x13\xf5\xb2\xa8\x94\x9f\xaai_\xd9\xa0\x96#M\xe0\x11\x04\xc5\x10\xbc\x1d\'\
\xe2\xa4\x90\xca\xc2\x18\xc1\xdc\x9c\xe6\xc4\x1bSLN\x8d\xb3eK\x07\xcaR\xef\
\xed\x01\xc7\xb1\x9dX\\S\xc8\x1bb\xf12GA"\x11\xe5\xc0\x17v\x97\xa4u\xb9\x87z\
522\x84\xe0M\x18at\xe0\xa1u\x11\xad5\xb6\x9d\xc0\xb2\x13\xe4s\x90\xcdzd\xb3\
\x0b\x08\xb1Dg\x97\xa4u\xddz\x1c\xc7\x02S\\;\n\x01\xd8\xb6e\'\xe2>\x0b\x0b\
\x9aX|e\xcd\xb4\xb4\xc4\x19\xf8\xd8\r\x97\t\xbc\x16|xo\x8c\xa9\xd0z\xd9\xf2>\
\xf9\\\x92\xe9i\x81\x14\x8bX\xb6G2\x19\xb0e\x8b\x04\x1c\xb4\xf6\xc9\xe5\x04:\
\x08\x00\xd6N%\x00,K\xd8M\xa9(ss>\xf5\xd9g\xa3lt5\xf9T\x8f\xd1\x1a\x02\xedQ(\
\x16\xb9t\xa9\xc8\x85\xf3\x1e\xe7\xcf\x1b&/\xa5\x10\xd2\xb0\xa5[\xb2\xe9jCg\
\xa7 \x91\x10h\xe3\xa1\xb5\x8fe\xbb\x04\x81&\x08\x8a\x08\x88\x1d8p`\xd92\r= \
\x84\xb4,\xa5\xd0\xda`\x8c\xa0z?h\xb4H\x1b\xf5\x85\x8b\xdf\x18(\x14\x0c\x8b\
\x0b\x1e\xb3\xb3>\x9e\xe7cG\x0c\xad\xad.mm\x12\xdb\x16h\x13\x94\xf2\x1e\x0fm\
|\x8c\x0e0\xc6\xa0,\x87\x88\x9d@H\x8bb\xf1\x12\xbeo\x10\xc2q\x87\x86\x86\xca\
\x91\xa51\x01)\x8d\x85\x10X\x96\xc6\xf3\x04\x91\x08Pw\xda\xd0\xe8\xf8$l\x0f\
\x02\xc3\xd4\xa4!\x9b]D)\x89e\x19\xe2\t\xc1U\x1bll;\x8a1\x84\xa1\xd3\x94C\
\xa7\x8f1a\xdec\xb4F*\x1b\xc7I\xa2T\x04!\x04^Q\xb2\xb4\xb4\x846Q@\x91\xcb\
\xe5\xd6\xf6\x801B\t\xc24vv6 \x9d\xb6V\xb5|\xd9\xc2\xb33\x1e\x0b\x0b\x01\xc5\
b\x91\x88c\xd1\xdc\xac\xe9\xed\x8b\x95r\x9d\xf2X\x13zU\x07a\x042\xfe\xf2\xce\
k\x8cF\x08\x85\x13m\xc6\xb2\xa2\xcb\xcf\x19#\x18\x1b\xf3\xb1\xec\x02\xb1\xd8\
Ux~.;==\xbd6\x01@"\x04\xae\xab\x18\xbf\xe8C\x05\x01\xad\r\x85\x82a~\xcec~>\
\xa0X\x0cp\x1cMk\xabCs\x8bE$\x12\xa9=\x9a\xc3\x18\x831\xba\x02\xb8W\xba\xf6\
\xd1:@\x08I\xc4n\xc2\xb2]\xa4\x0c\xd7\x8e\xd1\xe0y01\x110qi\x8c\r\x1b2H\xa9\
\x98\xc9\x16\xa7\x96\x96\x96\x96_\xd0\x90@\x10h1~Q\x00633E>\xe0\x19\xa6&5##\
\x8b\xe4\x96\x14JA<)imq\x88\x95R\x93|\xceP\xf6l\xa5\xaf\x0c\x06\xa3M\xe9W\
\xa3\x8d\xc6h\x816\x80\x91H\xe9\xa0\xac8\xc6(\x82@\xe3\xfb\x05|?$\n\x86h\xd4\
\xa3\xbb\xbb\x85T*F>\'\xf4+\xaf\x9c\xfa\xcf\x90dX\x1a\x1e-n\xdd\xba\xd5\x9e\
\x99\x99\xb1\x0f\x1e\xbc\x7f\xf3\x1d{{\x06\x9b\x9a\xa4J$5\xa9T\x14)\x97\xd7O\
8\x81\x087\xb5\x15\xa5\x84\xfd\xe1}\xf5_\xc3eJ%\xfd\x1b\x13`J\xfa\xd7\xda\
\x074RF\x88D\x12(\xcb\xa9H\xb5!\x9f\x83W\x7f\x96}\xfa\xee\xbb\xbf\xfa\xf5\
\xc9\xc9\xc9\xb7\xd7\xf4\xc0\xc9\x93\'=\xc0\xfb\xd1\x8f\x1e+vu\xa5D*UA\xd2T^\
\x84q\x1d@\xd7-\xea\x9a\xf1"\\\xb8a\xd2\xe6\xa3\xb5o\xca\xfa\xd7\xdaG\n\x85\
\xb2\x9aP*f\x16\x17E\xe0\xfb\xf8\x9eo\xbc\xdc\x92^\x9c\x9b\xf3/\x1c\x7f\xed\
\xdc\x93\xdf\xfe\xf6\xe1\x7fs\x1cg\xb8r\xfa5\x8f\xd7\xcf\x9d\x1b\x1b{\xe1\
\x05k@\nYiaS\xb2\xa6\x11\xa2\xfcaB\x96\xeeA\x88\xcav\x10\xa2<^\x94\xfa$B8F\
\x88\xe8r\xbf\x94\xa2\xf4\x0c\xc6\x18\xa1}_\x17\x17\x17\xf3\xf9\xf9\xf9\x85\
\xa5\xa7\x9f~z\xe2\xc4\x89\x13\x85\xbe\xbe>\xef\xcd7\x07\x83Z\x8c\xbf\x95\
\x0f\x1c\xff\x97\xe5w\xfe+\xe5\xfb\x04\xaety\x9f\xc0\x95.\xff\r\xe1\xf2\xf2\
\xc6W\xaf\xbf\xb6\x00\x00\x00\x00IEND\xaeB`\x82\xd8\xad\xb7['
