#ifndef COLOURMANAGEMENT_H
#define COLOURMANAGEMENT_H

#include "../imagesource/imagesource.h"
#include "lcmswrapper.h"
#include "../support/configdb.h"
#include "../support/searchpath.h"

enum CMColourDevice
{
	CM_COLOURDEVICE_NONE=0,
	CM_COLOURDEVICE_DISPLAY,
	CM_COLOURDEVICE_EXPORT,
	CM_COLOURDEVICE_PRINTER,
	CM_COLOURDEVICE_DEFAULTRGB,
	CM_COLOURDEVICE_DEFAULTCMYK,
};

#ifndef INTENT_DEFAULT
#define INTENT_DEFAULT -1
#endif

class CMTransformFactory;
class ProfileInfo;

class ProfileManager : public ConfigDB, public SearchPath
{
	public:
	ProfileManager(ConfigFile *Configfile,const char *section);
	virtual ~ProfileManager();
	CMSProfile *GetProfile(const char *name);
	CMSProfile *GetProfile(CMColourDevice target);
	CMSProfile *GetDefaultProfile(IS_TYPE colourspace);
	void SetProfile(CMColourDevice *target,const char *name);
	void SetDefaultProfile(IS_TYPE colourspace,const char *name);
	CMTransformFactory *GetTransformFactory();

	// path handling - we override these functions from the SearchPath
	// so we can invalidate the ProfileInfo list when the path changes.
	virtual void AddPath(const char *path);
	virtual void RemovePath(const char *path);
	virtual void ClearPaths();
	virtual const char *GetNextFilename(const char *prev);
	ProfileInfo *GetFirstProfileInfo();
	ProfileInfo *FindProfileInfo(const char *fn);
	int GetIntentCount();
	const char *GetIntentName(int intent);
	const char *GetIntentDescription(int intent);

	protected:
	static ConfigTemplate Template[];
	void BuildProfileInfoList();
	void FlushProfileInfoList();
	ProfileInfo *first;
	friend class ProfileInfo;
};


class CMTransformFactoryNode
{
	public:
	CMTransformFactoryNode(CMTransformFactory *header,CMSTransform *transform,MD5Digest &d1,MD5Digest &d2,int intent);
	~CMTransformFactoryNode();
	protected:
	CMTransformFactory *header;
	CMTransformFactoryNode *prev,*next;
	CMSTransform *transform;
	MD5Digest digest1;
	MD5Digest digest2;
	int intent;
	friend class CMTransformFactory;
};


class CMTransformFactory
{
	public:
	CMTransformFactory(ProfileManager &cm);
	~CMTransformFactory();
	CMSTransform *GetTransform(enum CMColourDevice target,CMSProfile *srcprofile,int intent=INTENT_DEFAULT);
	CMSTransform *GetTransform(CMSProfile *targetprofile,CMSProfile *srcprofile,int intent=INTENT_DEFAULT);
	CMSTransform *GetTransform(enum CMColourDevice target,IS_TYPE type,int intent=INTENT_DEFAULT);
	CMSTransform *Search(MD5Digest *srcdigest,MD5Digest *dstdigest,int intent);
	void Flush();
	protected:
	ProfileManager &manager;
	CMTransformFactoryNode *first;
	friend class CMTransformFactoryNode;
};


class ProfileInfo
{
	public:
	ProfileInfo(ProfileManager &pm,const char *filename);
	~ProfileInfo();
	ProfileInfo *Next();
	const char *GetFilename();
	const char *GetDescription();
	IS_TYPE GetColourSpace();
	bool IsDeviceLink();
	protected:
	void GetInfo();
	ProfileManager &profilemanager;
	ProfileInfo *next,*prev;
	char *filename;
	bool iscached;
	char *description;
	IS_TYPE colourspace;
	bool isdevicelink;
	friend class ProfileManager;
};
#endif
