
#include <iostream>
#include "ppeffect.h"

using namespace std;

PPEffectHeader::PPEffectHeader() : firsteffect(NULL)
{
}


PPEffectHeader::~PPEffectHeader()
{
	while(firsteffect)
		delete firsteffect;
}


ImageSource *PPEffectHeader::ApplyEffects(ImageSource *source,enum PPEFFECT_STAGE stage)
{
	PPEffect *effect=GetFirstEffect(stage);
	while(effect)
	{
		source=effect->Apply(source);
		effect=effect->Next(stage);	
	}
	return(source);
}


int PPEffectHeader::EffectCount(enum PPEFFECT_STAGE stage)
{
	PPEffect *effect=GetFirstEffect(stage);
	int count=0;
	while(effect)
	{
		count++;
		effect=effect->Next(stage);
	}
	return(count);
}


PPEffect *PPEffectHeader::GetFirstEffect(enum PPEFFECT_STAGE stage)
{
	return(firsteffect);
}



PPEffect::PPEffect(PPEffectHeader &header,enum PPEFFECT_STAGE stage)
	: stage(stage), header(header),prev(NULL),next(NULL)
{
	if((prev=header.firsteffect))
	{
		while(prev->next)
			prev=prev->next;
	}
	if(prev)
		prev->next=this;
	else
		header.firsteffect=this;
}


PPEffect::~PPEffect()
{
	if(prev)
		prev->next=next;
	else
		header.firsteffect=next;
	if(next)
		next->prev=prev;
}


PPEffect *PPEffect::Next(enum PPEFFECT_STAGE stage)
{
	PPEffect *effect=next;
	while(effect)
	{
		if(effect->stage==stage)
			return(effect);
		effect=effect->next;
	}
	return(NULL);
}
