/*
 * progress.h - base class for progress displays.
 * By default, provides "twirling baton" display on stderr.
 *
 * Copyright (c) 2004 by Alastair M. Robinson
 * Distributed under the terms of the GNU General Public License -
 * see the file named "COPYING" for more details.
 *
 */

#ifndef PROGRESS_H
#define PROGRESS_H

#include <iostream>

using namespace std;

class Progress
{
	public:
	Progress() : counter(0), counter2(0)
	{
	}
	virtual ~Progress()
	{
	}
	virtual bool DoProgress(int i, int maxi)
	{
		char *baton="/-\\|";
		if((counter==0) || (i==maxi))
		{
			if(i>maxi)
				i=maxi;
			cerr << baton[counter2] << " " << ((i+1)*100)/maxi << "%\r";
			if(i==maxi)
				cerr << endl;
			cerr.flush();
			++counter2;
			counter2&=3;
		}
		++counter;
		int mod=maxi/500;
		if(!mod)
			mod=1;
		counter%=mod;
		return(true);
	}
	private:
	int counter;
	int counter2;
	int limit;
};

#endif
