#include <iostream>
#include <stdlib.h>
#include <string.h>

#include <gdk-pixbuf/gdk-pixdata.h>

#include "../imagesource/imagesource_cms.h"
#include "../layout.h"

#include "ppeffect_temperature.h"
#include "ppeffect_temperature_icon.cpp"

PPEffect_Temperature::PPEffect_Temperature(PPEffectHeader &header,enum PPEFFECT_STAGE stage)
	:	PPEffect(header,stage), tempchange(0), transform(NULL)
{
}


PPEffect_Temperature::~PPEffect_Temperature()
{
	if(transform)
		delete transform;
}


void PPEffect_Temperature::MakeTransform(IS_TYPE type)
{
	CMSRGBGamma RGBGamma(2.2,2.2,2.2);
	CMSGamma GreyGamma(2.2);
	CMSWhitePoint srcwp(6500+tempchange);
	CMSWhitePoint dstwp(6500);
	CMSProfile *source;
	switch(STRIP_ALPHA(type))
	{
		case IS_TYPE_RGB:
			source=new CMSProfile(CMSPrimaries_Rec709,RGBGamma,srcwp);
			break;
		case IS_TYPE_GREY:
			source=new CMSProfile(GreyGamma,srcwp);
			break;
		default:
			throw "Only RGB and Greyscale images are currently supported";
	}
	if(!source)
		throw "Can't create source profile";

	CMSProfile dest(CMSPrimaries_Rec709,RGBGamma,dstwp);
	transform=new CMSTransform(source,&dest,LCMSWRAPPER_INTENT_ABSOLUTE_COLORIMETRIC);
	delete source;
}


ImageSource *PPEffect_Temperature::Apply(ImageSource *source)
{
	if(!transform)
		MakeTransform(source->type);

	if(transform->GetInputColourSpace()!=STRIP_ALPHA(source->type))
	{
		delete transform;
		transform=NULL;
		MakeTransform(source->type);
	}
	return(new ImageSource_CMS(source,transform));
}


void PPEffect_Temperature::SetTempChange(int tempchange)
{
	if(transform)
		delete transform;
	transform=NULL;
	this->tempchange=tempchange;
}


GdkPixbuf *PPEffect_Temperature::icon=NULL;

GdkPixbuf *PPEffect_Temperature::GetIcon_static()
{
	if(icon)
		return(icon);
	GdkPixdata pd;
	GError *err;

	if(!gdk_pixdata_deserialize(&pd,sizeof(PPEffect_Temperature_Icon),PPEffect_Temperature_Icon,&err))
		throw(err->message);

	if(!(icon=gdk_pixbuf_from_pixdata(&pd,false,&err)))
		throw(err->message);

	return(icon);
}
