#include "../profilemanager/lcmswrapper.h"
#include "imagesource.h"

ImageSource::ImageSource() : embeddedprofile(NULL), rowbuffer(NULL)
{
}


ImageSource::ImageSource(ImageSource *src) : rowbuffer(NULL)
{
	width=src->width;
	height=src->height;
	type=src->type;
	samplesperpixel=src->samplesperpixel;
	xres=src->xres;
	yres=src->yres;
	randomaccess=src->randomaccess;
	embeddedprofile=src->embeddedprofile;
	currentrow=-1;
}


ImageSource::~ImageSource()
{
	if(rowbuffer)
		free(rowbuffer);
}


void ImageSource::MakeRowBuffer()
{
	rowbuffer=(ISDataType *)malloc(sizeof(ISDataType)*width*samplesperpixel);
	currentrow=-1;
}


void ImageSource::SetResolution(double xr,double yr)
{
	xres=xr;
	yres=yr;
}


CMSProfile *ImageSource::GetEmbeddedProfile()
{
	return(embeddedprofile);
}


void ImageSource::SetEmbeddedProfile(CMSProfile *profile)
{
	if(embeddedprofile)
		delete embeddedprofile;
	embeddedprofile=profile;
}
