/*
 * imagesource_bilinear.cpp - Interpolated scaling filter
 * Implements bilinear scaling
 *
 * Supports Greyscale, RGB and CMYK data
 * Doesn't (yet) support random access
 *
 * Copyright (c) 2004 by Alastair M. Robinson
 * Distributed under the terms of the GNU General Public License -
 * see the file named "COPYING" for more details.
 *
 */

#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "imagesource_bilinear.h"

using namespace std;


ImageSource_Bilinear::~ImageSource_Bilinear()
{
	if(source)
		delete source;

	if(lastrow)
		free(lastrow);
}


ISDataType *ImageSource_Bilinear::GetRow(int row)
{
	int i;

	if(row==currentrow)
		return(rowbuffer);

	int srow1=(row*source->height)/height;
	int srow2=srow1+1;
	if(srow2>=source->height)
		srow2=srow1;

	ISDataType *src1,*src2;

	if(srow1==cachedrow)
	{
		src1=lastrow;
	}
	else
	{
		src1=source->GetRow(srow1);
		for(int i=0;i<source->width*source->samplesperpixel;++i)
			lastrow[i]=src1[i];
		cachedrow=srow1;
		src1=lastrow;
	}

	src2=source->GetRow(srow2);

	double yfactor=row*source->height;
	yfactor/=height;
	yfactor-=srow1;

	for(i=0;i<width;++i)
	{
		int x1=(i*source->width)/width;
		int x2=x1+1;
		if(x2 >= source->width)
			x2=x1;
		float xfactor=(i*source->width);
		xfactor/=width;
		xfactor-=x1;

		x1*=samplesperpixel;
		x2*=samplesperpixel;

		for(int s=0;s<samplesperpixel;++s)
		{
			double s1=src1[x1+s];
			double s2=src1[x2+s];
			double s3=src2[x1+s];
			double s4=src2[x2+s];

			double a1=(1.0-xfactor)*s1+xfactor*s2;
			double a2=(1.0-xfactor)*s3+xfactor*s4;
			double a3=(1.0-yfactor)*a1+yfactor*a2;

			rowbuffer[i*samplesperpixel+s]=int(a3);
		}
	}

	currentrow=row;

	return(rowbuffer);
}


ImageSource_Bilinear::ImageSource_Bilinear(struct ImageSource *source,int width,int height)
	: ImageSource(source), source(source), lastrow(NULL), cachedrow(-1)
{
	this->width=width; this->height=height;
	xres=(source->xres*width); xres/=source->width;
	yres=(source->yres*height); yres/=source->height;

	lastrow=(ISDataType *)malloc(source->width*source->samplesperpixel*sizeof(ISDataType));
	MakeRowBuffer();
	randomaccess=false;
}
