#include <string.h>

#include <gtk/gtkframe.h>
#include <gtk/gtksizegroup.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkfilesel.h>
#include <gtk/gtkdialog.h>
#include <gtk/gtkscrolledwindow.h>

#include "stpui_widgets/stpui_combo.h"
#include "stpui_widgets/dimension.h"
#include "support/tiffsave.h"
#include "layout.h"
#include "dialogs.h"
#include "pp_pageextent.h"
#include "pp_layout_poster_pageview.h"
#include "pp_layout_poster.h"

#include "config.h"
#include "gettext.h"
#define _(x) gettext(x)

enum {
	CHANGED_SIGNAL,
	POPUPMENU_SIGNAL,
	SELECTIONCHANGED_SIGNAL,
	LAST_SIGNAL
};

static guint pp_layout_poster_signals[LAST_SIGNAL] = { 0 };

static void pp_layout_poster_class_init (pp_Layout_PosterClass *klass);
static void pp_layout_poster_init (pp_Layout_Poster *stpuicombo);


static void reflow(GtkWidget *wid,gpointer *ob)
{
	pp_Layout_Poster *lo=(pp_Layout_Poster *)ob;
	pp_Layout_Poster_PageView *pv=PP_LAYOUT_POSTER_PAGEVIEW(lo->pageview);
	Layout_Poster *l=(Layout_Poster*)lo->state->layout;
	l->Reflow();
	pp_layout_poster_pageview_refresh(PP_LAYOUT_POSTER_PAGEVIEW(pv));

	int pages=l->GetPages();
	pages/=l->htiles*l->vtiles;

	gtk_widget_set_sensitive(lo->page,pages>1);
	gtk_spin_button_set_range(GTK_SPIN_BUTTON(lo->page),1.0,pages);
	g_signal_emit(G_OBJECT (lo),pp_layout_poster_signals[CHANGED_SIGNAL], 0);
}


static void pe_changed(GtkWidget *wid,gpointer *ob)
{
	pp_Layout_Poster *lo=(pp_Layout_Poster *)ob;
	Layout_Poster *l=(Layout_Poster*)lo->state->layout;
	l->TilesFromSize();
	pp_layout_poster_refresh(lo);
	pp_Layout_Poster_PageView *pv=PP_LAYOUT_POSTER_PAGEVIEW(lo->pageview);
	pp_layout_poster_pageview_refresh(pv);
	g_signal_emit(G_OBJECT (ob),pp_layout_poster_signals[CHANGED_SIGNAL], 0);
}


static void posterwidth_changed(GtkWidget *wid,gpointer *ob)
{
	pp_Layout_Poster *lo=(pp_Layout_Poster *)ob;
	Layout_Poster *l=(Layout_Poster*)lo->state->layout;

	l->posterwidth=int(dimension_get_pt(DIMENSION(lo->posterwidth)));
	l->TilesFromSize();
	g_signal_emit(G_OBJECT (lo),pp_layout_poster_signals[CHANGED_SIGNAL], 0);
}


static void posterheight_changed(GtkWidget *wid,gpointer *ob)
{
	pp_Layout_Poster *lo=(pp_Layout_Poster *)ob;
	Layout_Poster *l=(Layout_Poster*)lo->state->layout;

	l->posterheight=int(dimension_get_pt(DIMENSION(lo->posterheight)));
	l->TilesFromSize();
	g_signal_emit(G_OBJECT (lo),pp_layout_poster_signals[CHANGED_SIGNAL], 0);
}


static void htiles_changed(GtkWidget *wid,gpointer *ob)
{
	pp_Layout_Poster *lo=(pp_Layout_Poster *)ob;
	Layout_Poster *l=(Layout_Poster*)lo->state->layout;
	
	l->htiles=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(lo->htiles));
	l->SizeFromTiles();
	g_signal_emit(G_OBJECT (lo),pp_layout_poster_signals[CHANGED_SIGNAL], 0);
}


static void vtiles_changed(GtkWidget *wid,gpointer *ob)
{
	pp_Layout_Poster *lo=(pp_Layout_Poster *)ob;
	Layout_Poster *l=(Layout_Poster*)lo->state->layout;

	cerr << "In VTiles_Changed" << endl;

	l->vtiles=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(lo->vtiles));
	l->SizeFromTiles();
	g_signal_emit(G_OBJECT (lo),pp_layout_poster_signals[CHANGED_SIGNAL], 0);
}


static void hoverlap_changed(GtkWidget *wid,gpointer *ob)
{
	pp_Layout_Poster *lo=(pp_Layout_Poster *)ob;
	Layout_Poster *l=(Layout_Poster*)lo->state->layout;

	l->hoverlap=int(dimension_get_pt(DIMENSION(lo->hoverlap)));
	l->TilesFromSize();
	g_signal_emit(G_OBJECT (lo),pp_layout_poster_signals[CHANGED_SIGNAL], 0);
}


static void voverlap_changed(GtkWidget *wid,gpointer *ob)
{
	pp_Layout_Poster *lo=(pp_Layout_Poster *)ob;
	Layout_Poster *l=(Layout_Poster*)lo->state->layout;

	l->voverlap=int(dimension_get_pt(DIMENSION(lo->voverlap)));
	l->TilesFromSize();
	g_signal_emit(G_OBJECT (lo),pp_layout_poster_signals[CHANGED_SIGNAL], 0);
}


static void page_changed(GtkWidget *wid,gpointer *ob)
{
	pp_Layout_Poster *lo=(pp_Layout_Poster *)ob;
	pp_Layout_Poster_PageView *pv=PP_LAYOUT_POSTER_PAGEVIEW(lo->pageview);
	int pagesperposter=pv->layout->htiles*pv->layout->vtiles;

	pp_layout_poster_pageview_set_page(pv,pagesperposter*(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(lo->page))-1));
	g_signal_emit(G_OBJECT (lo),pp_layout_poster_signals[CHANGED_SIGNAL], 0);
}


static void pageview_changed(GtkWidget *wid,gpointer *ob)
{
	pp_Layout_Poster *lo=(pp_Layout_Poster *)ob;

	g_signal_emit(G_OBJECT (lo),pp_layout_poster_signals[CHANGED_SIGNAL], 0);
}


static void pageview_popupmenu(GtkWidget *wid,gpointer *ob)
{
	pp_Layout_Poster *lo=(pp_Layout_Poster *)ob;
	cerr << "Forwarding popupmenu signal..." << endl;
	g_signal_emit(G_OBJECT (lo),pp_layout_poster_signals[POPUPMENU_SIGNAL], 0);
}


void pp_layout_poster_refresh(pp_Layout_Poster *ob)
{
	Layout_Poster *l=(Layout_Poster *)ob->state->layout;

	l->LayoutToDB(ob->state->layoutdb);

	int pages=l->GetPages();
	int cpage=l->GetCurrentPage();
	pages/=l->htiles*l->vtiles;
	cpage/=l->htiles*l->vtiles;

	gtk_widget_set_sensitive(ob->page,pages!=1);
	if(pages>1)
	{
		gtk_spin_button_set_range(GTK_SPIN_BUTTON(ob->page),1.0,pages);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(ob->page),cpage+1);
	}

	g_signal_handlers_block_matched (G_OBJECT(ob->posterwidth),G_SIGNAL_MATCH_DATA,
		0, 0, NULL, NULL, ob);
	g_signal_handlers_block_matched (G_OBJECT(ob->posterheight),G_SIGNAL_MATCH_DATA,
		0, 0, NULL, NULL, ob);
	g_signal_handlers_block_matched (G_OBJECT(ob->htiles),G_SIGNAL_MATCH_DATA,
		0, 0, NULL, NULL, ob);
	g_signal_handlers_block_matched (G_OBJECT(ob->vtiles),G_SIGNAL_MATCH_DATA,
		0, 0, NULL, NULL, ob);
	g_signal_handlers_block_matched (G_OBJECT(ob->hoverlap),G_SIGNAL_MATCH_DATA,
		0, 0, NULL, NULL, ob);
	g_signal_handlers_block_matched (G_OBJECT(ob->voverlap),G_SIGNAL_MATCH_DATA,
		0, 0, NULL, NULL, ob);

	dimension_set_pt(DIMENSION(ob->posterwidth),l->posterwidth);
	dimension_set_pt(DIMENSION(ob->posterheight),l->posterheight);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(ob->htiles),l->htiles);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(ob->vtiles),l->vtiles);
	dimension_set_pt(DIMENSION(ob->hoverlap),l->hoverlap);
	dimension_set_pt(DIMENSION(ob->voverlap),l->voverlap);

	g_signal_handlers_unblock_matched (G_OBJECT(ob->posterwidth),G_SIGNAL_MATCH_DATA,
		0, 0, NULL, NULL, ob);
	g_signal_handlers_unblock_matched (G_OBJECT(ob->posterheight),G_SIGNAL_MATCH_DATA,
		0, 0, NULL, NULL, ob);
	g_signal_handlers_unblock_matched (G_OBJECT(ob->htiles),G_SIGNAL_MATCH_DATA,
		0, 0, NULL, NULL, ob);
	g_signal_handlers_unblock_matched (G_OBJECT(ob->vtiles),G_SIGNAL_MATCH_DATA,
		0, 0, NULL, NULL, ob);
	g_signal_handlers_unblock_matched (G_OBJECT(ob->hoverlap),G_SIGNAL_MATCH_DATA,
		0, 0, NULL, NULL, ob);
	g_signal_handlers_unblock_matched (G_OBJECT(ob->voverlap),G_SIGNAL_MATCH_DATA,
		0, 0, NULL, NULL, ob);

	pp_Layout_Poster_PageView *pv=PP_LAYOUT_POSTER_PAGEVIEW(ob->pageview);
	if(pv)
		pp_layout_poster_pageview_refresh(pv);
}


void pp_layout_poster_set_unit(GtkWidget *wid,enum Units unit)
{
	pp_Layout_Poster *ob=PP_LAYOUT_POSTER(wid);
	pp_pageextent_set_unit(PP_PAGEEXTENT(ob->pageextent),unit);
	dimension_set_unit(DIMENSION(ob->posterwidth),unit);
	dimension_set_unit(DIMENSION(ob->posterheight),unit);
}


GtkWidget*
pp_layout_poster_new (PhotoPrint_State *state)
{
	pp_Layout_Poster *ob=PP_LAYOUT_POSTER(g_object_new (pp_layout_poster_get_type (), NULL));

	gtk_container_set_border_width(GTK_CONTAINER(&ob->hbox),10);
	
	ob->state=state;
	
	GtkWidget *vbox;
	GtkWidget *vbox2;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *tmp;

	ob->sizegroup = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);
	
	GtkWidget *frame = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX (&ob->hbox), frame,TRUE,TRUE,0);
	gtk_widget_show (frame); 
	
	ob->pageview = pp_layout_poster_pageview_new ((Layout_Poster *)ob->state->layout);
	g_signal_connect(G_OBJECT(ob->pageview),"changed",G_CALLBACK(pageview_changed),ob);
	g_signal_connect(G_OBJECT(ob->pageview),"popupmenu",G_CALLBACK(pageview_popupmenu),ob);
	g_signal_connect(G_OBJECT(ob->pageview),"reflow",G_CALLBACK(reflow),ob);

	gtk_container_add (GTK_CONTAINER (frame), ob->pageview);
	gtk_widget_show (ob->pageview);

	GtkWidget *scrollwin=gtk_scrolled_window_new(NULL,NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrollwin),
                                    GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	vbox = gtk_vbox_new (FALSE, 5);
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrollwin), vbox);
	gtk_box_pack_start(GTK_BOX(&ob->hbox),scrollwin,FALSE,FALSE,0);
	gtk_widget_show (vbox);
	gtk_widget_show (scrollwin);

	enum Units unit=state->GetUnits();

#define PP_BUILDDIMENSION(spinlabel,var,min,max,unit,callback) \
	hbox=gtk_hbox_new(FALSE,0); \
\
	label=gtk_label_new(spinlabel); \
	gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,5); \
	gtk_widget_show(label); \
\
	var=dimension_new(min,max,unit); \
	g_signal_connect(G_OBJECT(var),"value-changed",G_CALLBACK(callback),ob); \
	gtk_widget_show(var); \
\
	gtk_size_group_add_widget(GTK_SIZE_GROUP(ob->sizegroup),var); \
	gtk_box_pack_start(GTK_BOX(hbox),var,FALSE,FALSE,5); \
\
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,FALSE,FALSE,5); \
	gtk_widget_show(hbox)

#define PP_BUILDSPIN(spinlabel,var,min,max,step,callback) \
	hbox=gtk_hbox_new(FALSE,0); \
\
	label=gtk_label_new(spinlabel); \
	gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,5); \
	gtk_widget_show(label); \
\
	var=gtk_spin_button_new_with_range(min,max,step); \
	g_signal_connect(G_OBJECT(var),"value-changed",G_CALLBACK(callback),ob); \
	gtk_widget_show(var); \
\
	gtk_size_group_add_widget(GTK_SIZE_GROUP(ob->sizegroup),var); \
	gtk_box_pack_start(GTK_BOX(hbox),var,FALSE,FALSE,5); \
\
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,FALSE,FALSE,5); \
	gtk_widget_show(hbox)

#define PP_BUILDFRAME(framelabel) \
	frame=gtk_frame_new(framelabel); \
	gtk_box_pack_start(GTK_BOX(vbox),frame,FALSE,FALSE,0); \
	gtk_container_set_border_width(GTK_CONTAINER(frame),5); \
	gtk_widget_show(frame); \
\
	vbox2=gtk_vbox_new(FALSE,0); \
	gtk_container_add(GTK_CONTAINER(frame),vbox2); \
	gtk_widget_show(vbox2)


	// PosterSize
	PP_BUILDFRAME(_("Poster Size:"));
	PP_BUILDDIMENSION(_("Width:"),ob->posterwidth,350,10000,unit,posterwidth_changed);
	PP_BUILDDIMENSION(_("Height:"),ob->posterheight,350,10000,unit,posterheight_changed);
	PP_BUILDSPIN(_("Tiles wide:"),ob->htiles,1,10,1,htiles_changed);
	PP_BUILDSPIN(_("Tiles high:"),ob->vtiles,1,10,1,vtiles_changed);

	PP_BUILDFRAME(_("Overlap:"));
	PP_BUILDDIMENSION(_("H:"),ob->hoverlap,0,72,unit,hoverlap_changed);
	PP_BUILDDIMENSION(_("V:"),ob->voverlap,0,72,unit,voverlap_changed);


	// PageExtent

	ob->pageextent=pp_pageextent_new((Layout_Poster *)ob->state->layout,ob->state,ob->sizegroup);
	g_signal_connect(G_OBJECT(ob->pageextent),"changed",G_CALLBACK(pe_changed),ob);
	gtk_box_pack_start(GTK_BOX(vbox),ob->pageextent,FALSE,FALSE,0);
	gtk_widget_show(ob->pageextent);


	// Spacer box

	tmp=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),tmp,TRUE,TRUE,0);
	gtk_widget_show(tmp);


	// Page number

	hbox=gtk_hbox_new(FALSE,5);
	label=gtk_label_new(_("Page:"));
	gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);
	gtk_widget_show(label);

	ob->page=gtk_spin_button_new_with_range(1.0,2.0,1.0);
	g_signal_connect(G_OBJECT(ob->page),"value-changed",G_CALLBACK(page_changed),ob);
	gtk_widget_show(ob->page);

	gtk_box_pack_start(GTK_BOX(hbox),ob->page,FALSE,FALSE,0);


	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_widget_show(hbox);

	g_object_unref(G_OBJECT(ob->sizegroup));
	ob->sizegroup=NULL;

	pp_layout_poster_refresh(ob);
	pp_pageextent_refresh(PP_PAGEEXTENT(ob->pageextent));

	return(GTK_WIDGET(ob));
}


GType
pp_layout_poster_get_type (void)
{
	static GType stpuic_type = 0;

	if (!stpuic_type)
	{
		static const GTypeInfo pp_layout_poster_info =
		{
			sizeof (pp_Layout_PosterClass),
			NULL, /* base_init */
			NULL, /* base_finalize */
			(GClassInitFunc) pp_layout_poster_class_init,
			NULL, /* class_finalize */
			NULL, /* class_data */
			sizeof (pp_Layout_Poster),
			0,
			(GInstanceInitFunc) pp_layout_poster_init,
		};
		stpuic_type = g_type_register_static (GTK_TYPE_HBOX, "pp_Layout_Poster", &pp_layout_poster_info, (GTypeFlags)0);
	}
	return stpuic_type;
}


static void
pp_layout_poster_class_init (pp_Layout_PosterClass *klass)
{
	pp_layout_poster_signals[CHANGED_SIGNAL] =
	g_signal_new ("changed",
		G_TYPE_FROM_CLASS (klass),
		GSignalFlags(G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION),
		G_STRUCT_OFFSET (pp_Layout_PosterClass, changed),
		NULL, NULL,
		g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	pp_layout_poster_signals[POPUPMENU_SIGNAL] =
	g_signal_new ("popupmenu",
		G_TYPE_FROM_CLASS (klass),
		GSignalFlags(G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION),
		G_STRUCT_OFFSET (pp_Layout_PosterClass, changed),
		NULL, NULL,
		g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	pp_layout_poster_signals[SELECTIONCHANGED_SIGNAL] =
	g_signal_new ("selection_changed",
		G_TYPE_FROM_CLASS (klass),
		GSignalFlags(G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION),
		G_STRUCT_OFFSET (pp_Layout_PosterClass, changed),
		NULL, NULL,
		g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
pp_layout_poster_init (pp_Layout_Poster *ob)
{
	ob->state=NULL;
	ob->pageview=NULL;
}
