<?php
/**
 * Factory methods for Horde_Kolab_Server_Object instances.
 *
 * PHP version 5
 *
 * @category Kolab
 * @package  Kolab_Server
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @link     http://pear.horde.org/index.php?package=Kolab_Server
 */

/**
 * Factory methods for Horde_Kolab_Server_Object instances.
 *
 * Copyright 2008-2012 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @category Kolab
 * @package  Kolab_Server
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @link     http://pear.horde.org/index.php?package=Kolab_Server
 */
class Horde_Kolab_Server_Object_Factory
{
    /**
     * Attempts to return a concrete Horde_Kolab_Server_Object instance based on
     * $type.
     *
     * @param mixed  $type     The type of the Horde_Kolab_Server_Object subclass
     *                         to return.
     * @param string $uid      UID of the object
     * @param array  $storage A link to the Kolab_Server class handling read/write.
     * @param array  $data     A possible array of data for the object
     *
     * @return Horde_Kolab_Server_Object|PEAR_Error The newly created concrete
     *                                 Horde_Kolab_Server_Object instance.
     */
    static public function factory(
        $type, $uid,
        Horde_Kolab_Server_Composite $storage,
        $data = null
    ) {
        if (class_exists($type)) {
            $object = new $type($storage, $uid, $data);
        } else {
            throw new Horde_Kolab_Server_Exception('Class definition of ' . $type . ' not found.');
        }

        $object = new Horde_Kolab_Server_Object_Hash($object);
        return $object;
    }


    /**
     * Attempts to load the concrete Horde_Kolab_Server_Object class based on
     * $type.
     *
     * @param mixed $type The type of the Horde_Kolab_Server_Object subclass.
     *
     * @static
     *
     * @return true|PEAR_Error True if successfull.
     */
    static public function loadClass($type)
    {
        if (!class_exists($type)) {
            throw new Horde_Kolab_Server_Exception('Class definition of ' . $type . ' not found.');
        }
    }
}
