## Do you want to contribute?

This is a README for developers wanting to contribute to the MongoDB PHP
driver.


## Current branches

* 1.2 is the current release branch/stable branch (bugfix only)
* master is the development branch for new features (to become 1.3)


## Github

The official repository of this driver is on
[Github](http://www.github.com/mongodb/mongo-php-driver/).  When fixing a bug
in the current release branch, please ensure you branch from it, and submit the
Pull Request against it again.  If there has been a while since you update your
local fork, please ensure you rebase it properly :)

Bugfixes and Pull Requests should be filed against the *lowest release branch*
All *new* development happens in master (i.e. new features, BC changes, ..).


## Running the tests

To execute the "tests/generic/" tests in a specific mongod environment you can
export `MONGO_SERVER` environment variable to overwrite the default environment
(standalone):

    MONGO_SERVER=REPLICASET_AUTH php run-tests.php tests/generic/mongo-listdbs-001.phpt

If you export the variable, remember to unset it later - otherwise the test
suite may not be executed correctly in the environment you expect it to.


## Writing tests

The tests/utils.inc file has several helper functions to ease running the same
test case in several different environment at once (i.e. via 'make tests').

Testscases in the generic/ folder are executed in all configured environments
(see tests/mongo-test-cfg.inc), the testcases in the replicaset/ folder only
when replicaset environment is available, the testcases in standalone-auth/
only in Standalone (with auth enabled) environment and so on and on.

The most important helper function is the mongo() function, which out of the
box will return a Mongo object configured for the current environment.

When writing testcases for the Mongo construct, using the helper function won't
give you much as it abstracts the logic of connecting to servers and doesn't
provide a whole lot of room for custom options.  This is however easily
achieved by using the other helper functions such as hostname(), port(),
username() etc etc. These will return back the configured values for the
currently being executed environment.

If you need to do the same "trick" over and over again in a testcase, it is
probably worth writing a helper function for it in tests/utils.inc.


## Test template
    --TEST--
    Test for PHP-XYZ: The ticket title
    --SKIPIF--
    <?php /* Minimum mongod requirement $needs = "2.2.0"; */ ?>
    <?php require dirname(__FILE__) ."/skipif.inc"; ?>
    --FILE--
    <?php
    $cn = "PHP-XYZ";
    require_once dirname(__FILE__) . "/../utils.inc";

    $m = mongo();
    $c = $m->selectCollection(dbname(), $cn);

    /** Write your test code here **/
    ?>
    ===DONE===
    <?php exit(0); ?>
    --CLEAN--
    <?php $c = "PHP-XYZ"; require dirname(__FILE__) ."/clean.inc"; ?>
    --EXPECTF--
    ** Expected output here **
    ===DONE===

Some notes about the template:

* The dirname() is for PHP 5.2 compatibility.
* Setting the $needs variable verifies minimum mongod requirements
* skipif.inc checks if the extension is loaded and general sanity
* utils.inc is `require_once` as skipif.inc requires that file too
* If $cn is set, that collection in the dbname() database will be dropped
  before the test runs
* mongo() will return a connected Mongo object according to the envrionment or test folder
* Please use a collection named after the ticket number (for easier tracking)
* The exit(0); statement allows you to run the testcase standalone from
  the command line (without running it via run-tests.php) and see what is going
  on without being flooded with hundred of lines from the --EXPECTF-- section.
* The --CLEAN-- section is to drop the collection name assigned to $cn 


## Code coverage

Code coverage is generated by running the test suite after having enabled
coverage before compiling the driver

    $ phpize
    $ ./configure --enable-coverage
    $ make clean all tests

Then you should have a coverage/ folder with the juicy details.


