#!/bin/sh
#
# Build script for TCLink PHP module
#

ERROR=0
phpize || ERROR=1

if [ $ERROR = 1 ]; then
	echo "Couldn't execute phpize.  Check to make sure you have the php development package installed."
	exit 1
fi

./configure --with-tclink --with-ssl || exit 1

make || exit

if [ -r modules/libtclink.so.0.0 ]; then
	mv -f modules/libtclink.so.0.0 modules/tclink.so
fi


echo 
echo "   **************************************************************************" 
echo 
echo "   SUCCESS!"
echo
echo "   To install the tclink PHP module you must copy"
echo "   $PWD/modules/tclink.so"
echo "   Into your php extensions folder (as specified in your php.ini file)."
echo "   On most systems a 'make install' will accomplish that."
echo "   Then you must add 'extension=tclink.so' to the php.ini file"
echo "   and restart the web server or use 'dl("tclink.so");' in any php "
echo "   scripts that make use of it."
echo 
echo "   **************************************************************************" 

