<?php
/**
*
* acp_board [Russian]
*
* @package language
* @version $Id: board.php 10080 2009-08-31 14:57:04Z nickvergessen $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Board Settings
$lang = array_merge($lang, array(
	'ACP_BOARD_SETTINGS_EXPLAIN'	=> 'Здесь вы можете установить общие параметры конференции, дать ей имя и описание, а также указать часовой пояс и язык, которые будут использоваться по умолчанию.',
	'CUSTOM_DATEFORMAT'				=> 'Другой…',
	'DEFAULT_DATE_FORMAT'			=> 'Формат даты',
	'DEFAULT_DATE_FORMAT_EXPLAIN'	=> 'Синтаксис идентичен функции <code><a href="http://www.php.net/date">date</code></a> языка PHP.',
	'DEFAULT_LANGUAGE'				=> 'Язык конференции по умолчанию',
	'DEFAULT_STYLE'					=> 'Стиль конференции по умолчанию',
	'DISABLE_BOARD'					=> 'Отключить конференцию',
	'DISABLE_BOARD_EXPLAIN'			=> 'Конференция станет недоступной для посетителей. Также вы можете ввести короткое сообщение (до 255 символов), которое будут видеть посетители.',
	'OVERRIDE_STYLE'				=> 'Заменять стиль пользователя',
	'OVERRIDE_STYLE_EXPLAIN'		=> 'Стиль, выбранный пользователем, будет заменён стилем по умолчанию.',
	'SITE_DESC'						=> 'Описание конференции',
	'SITE_NAME'						=> 'Название конференции',
	'SYSTEM_DST'					=> 'Сейчас действует летнее время (<abbr title="Летнее время">DST</abbr>)',
	'SYSTEM_TIMEZONE'				=> 'Часовой пояс для гостей',
	'SYSTEM_TIMEZONE_EXPLAIN'		=> 'Часовой пояс, используемый для отображения времени у незарегистрированных пользователей (гости, боты). Зарегистрированные пользователи настраивают свой часовой пояс при регистрации и могут изменить его в Личном разделе.',
	'WARNINGS_EXPIRE'				=> 'Длительность предупреждений',
	'WARNINGS_EXPIRE_EXPLAIN'		=> 'Количество дней, по истечении которых выданное пользователю предупреждение будет автоматически снято. Установите 0, чтобы сделать предупреждения бессрочными.',
));

// Board Features
$lang = array_merge($lang, array(
	'ACP_BOARD_FEATURES_EXPLAIN'	=> 'Здесь вы можете включать и отключать некоторые функциональные возможности конференции.',

	'ALLOW_ATTACHMENTS'			=> 'Разрешить вложения',
	'ALLOW_BIRTHDAYS'			=> 'Разрешить дни рождения',
	'ALLOW_BIRTHDAYS_EXPLAIN'	=> 'Разрешить указывать дни рождения и отображения возраста в профиле. Учтите, что список дней рождения на странице списка форумов включается отдельно в настройках нагрузки на сервер.',
	'ALLOW_BOOKMARKS'			=> 'Разрешить закладки на темы',
	'ALLOW_BOOKMARKS_EXPLAIN'	=> 'Пользователи смогут сохранять личные закладки на любимые темы.',
	'ALLOW_BBCODE'				=> 'Разрешить BBCode',
	'ALLOW_FORUM_NOTIFY'		=> 'Разрешить подписку на форумы',
	'ALLOW_NAME_CHANGE'			=> 'Разрешить смену имени пользователя',
	'ALLOW_NO_CENSORS'			=> 'Разрешить отключение автоцензора',
	'ALLOW_NO_CENSORS_EXPLAIN'	=> 'Пользователи смогут по выбору отключать автоцензор в обычных и личных сообщениях.',
	'ALLOW_PM_ATTACHMENTS'		=> 'Разрешить вложения в личных сообщениях',
	'ALLOW_PM_REPORT'			=> 'Разрешить жалобы на личные сообщения',
	'ALLOW_PM_REPORT_EXPLAIN'	=> 'При включении данной опции у пользователей появится возможность жаловаться модераторам на полученные ими личные сообщения от других пользователей. Обжалованные личные сообщения будут видны в панели модератора.',
	'ALLOW_QUICK_REPLY'			=> 'Разрешить быстрый ответ',
	'ALLOW_QUICK_REPLY_EXPLAIN'	=> 'При включении данной опции в необходимых форумах также должна быть включена опция быстрого ответа.',
	'ALLOW_QUICK_REPLY_BUTTON'	=> 'Отправить и включить быстрый ответ во всех форумах',
	'ALLOW_SIG'					=> 'Разрешить подписи',
	'ALLOW_SIG_BBCODE'			=> 'Разрешить BBCode в подписях пользователей',
	'ALLOW_SIG_FLASH'			=> 'Разрешить использование тега BBCode <code>[FLASH]</code> в подписях пользователей',
	'ALLOW_SIG_IMG'				=> 'Разрешить использование тега BBCode <code>[IMG]</code> в подписях пользователей',
	'ALLOW_SIG_LINKS'			=> 'Разрешить ссылки в подписях пользователей',
	'ALLOW_SIG_LINKS_EXPLAIN'	=> 'В случае запрета тег BBCode <code>[URL]</code> и автоматическое преобразование текста в ссылки будут отключены.',
	'ALLOW_SIG_SMILIES'			=> 'Разрешить смайлики в подписях пользователей',
	'ALLOW_SMILIES'				=> 'Разрешить смайлики',
	'ALLOW_TOPIC_NOTIFY'		=> 'Разрешить подписку на темы',
	'BOARD_PM'					=> 'Разрешить личные сообщения',
	'BOARD_PM_EXPLAIN'			=> 'Включение обмена личными сообщениями для всех пользователей.',
));

// Avatar Settings
$lang = array_merge($lang, array(
	'ACP_AVATAR_SETTINGS_EXPLAIN'	=> 'Аватары — это небольшие индивидуальные изображения, которые пользователи могут ассоциировать со своими учётными записями. В зависимости от выбранного стиля, аватары обычно отображаются под именем пользователя при просмотре тем. Здесь вы можете настроить использование аватар пользователями. Пожалуйста, учтите, что для загрузки аватар необходимо создать папку, имя которой задаётся ниже, и удостовериться в том, что веб-сервер имеет права на запись в эту папку. Учтите также, что ограничения на размер файлов накладываются только на загружаемые на сервер аватары и не распространяются на удалённые изображения.',

	'ALLOW_AVATARS'					=> 'Разрешить аватары',
	'ALLOW_AVATARS_EXPLAIN'			=> 'Глобальное включение или отключение возможности использования аватар.<br />Примечание: если вы отключите аватары в целом или запретите использование некоторых режимов аватар, то отключённые аватары больше не будут отображаться на конференции, но пользователи по-прежнему смогут загружать свои аватары в пользовательской панели управления.',
	'ALLOW_LOCAL'					=> 'Разрешить галерею аватар',
	'ALLOW_REMOTE'					=> 'Разрешить удалённые аватары',
	'ALLOW_REMOTE_EXPLAIN'			=> 'Ссылки на аватары, отображаемые с других сайтов.',
	'ALLOW_REMOTE_UPLOAD'			=> 'Разрешить удалённую загрузку аватар',
	'ALLOW_REMOTE_UPLOAD_EXPLAIN'	=> 'Разрешить загрузку аватар с других сайтов.',
	'ALLOW_UPLOAD'					=> 'Разрешить прямую загрузку аватар',
	'AVATAR_GALLERY_PATH'			=> 'Путь к галерее аватар',
	'AVATAR_GALLERY_PATH_EXPLAIN'	=> 'Путь к папке с загруженными в неё рисунками относительно корневой папки phpBB. Например, <samp>images/avatars/gallery</samp>.',
	'AVATAR_STORAGE_PATH'			=> 'Папка для загрузки аватар',
	'AVATAR_STORAGE_PATH_EXPLAIN'	=> 'Путь к папке относительно корневой папки phpBB. Например, <samp>images/avatars/upload</samp>.',
	'MAX_AVATAR_SIZE'				=> 'Максимальные размеры аватар',
	'MAX_AVATAR_SIZE_EXPLAIN'		=> 'Ширина × высота (в пикселах).',
	'MAX_FILESIZE'					=> 'Максимальный размер файла аватары',
	'MAX_FILESIZE_EXPLAIN'			=> 'Максимальный размер файлов загружаемых аватар. Если значение равно 0, размер файла ограничен только конфигурацией PHP.',
	'MIN_AVATAR_SIZE'				=> 'Минимальные размеры аватар',
	'MIN_AVATAR_SIZE_EXPLAIN'		=> 'Ширина × высота (в пикселах).',
));

// Message Settings
$lang = array_merge($lang, array(
	'ACP_MESSAGE_SETTINGS_EXPLAIN'		=> 'Здесь вы можете задать все настройки по умолчанию для личных сообщений (ЛС).',

	'ALLOW_BBCODE_PM'			=> 'Разрешить BBCode в ЛС',
	'ALLOW_FLASH_PM'			=> 'Разрешить тег BBCode <code>[FLASH]</code>',
	'ALLOW_FLASH_PM_EXPLAIN'	=> 'Учтите, что возможность использования flash, если она включена здесь, зависит также от установленных прав доступа.',
	'ALLOW_FORWARD_PM'			=> 'Разрешить пересылку ЛС',
	'ALLOW_IMG_PM'				=> 'Разрешить тег BBCode <code>[IMG]</code>',
	'ALLOW_MASS_PM'				=> 'Разрешить отправку ЛС нескольким пользователям или группам пользователей',
	'ALLOW_MASS_PM_EXPLAIN'		=> 'Отправку ЛС группам пользователей можно настроить на странице управления группами.',
	'ALLOW_PRINT_PM'			=> 'Разрешить печатный вид в ЛС',
	'ALLOW_QUOTE_PM'			=> 'Разрешить цитаты в ЛС',
	'ALLOW_SIG_PM'				=> 'Разрешить подписи в ЛС',
	'ALLOW_SMILIES_PM'			=> 'Разрешить смайлики в ЛС',
	'BOXES_LIMIT'				=> 'Максимальное количество ЛС в папке',
	'BOXES_LIMIT_EXPLAIN'		=> 'Пользователи не смогут сохранять больше, чем указанное количество сообщений, в каждой из папок для ЛС. Установите 0 для снятия ограничений.',
	'BOXES_MAX'					=> 'Максимальное количество папок для ЛС',
	'BOXES_MAX_EXPLAIN'			=> 'По умолчанию пользователи не смогут создавать больше указанного количества папок для ЛС.',
	'ENABLE_PM_ICONS'			=> 'Разрешить использование значков тем в ЛС',
	'FULL_FOLDER_ACTION'		=> 'Действие по умолчанию для переполненной папки',
	'FULL_FOLDER_ACTION_EXPLAIN'=> 'Действие по умолчанию, выполняемое для переполненной папки пользователя, в случае, если выбранное пользователем действие для папки неприменимо. Единственным исключением является папка «Отправленные», для которой действием по умолчанию всегда является удаление старых сообщений.',
	'HOLD_NEW_MESSAGES'			=> 'Отложить новые сообщения',
	'PM_EDIT_TIME'				=> 'Ограничить время редактирования',
	'PM_EDIT_TIME_EXPLAIN'		=> 'Ограничить время, в течение которого доступно редактирование отправленного, но ещё не полученного адресатом личного сообщения. Установите 0 для снятия ограничений.',
	'PM_MAX_RECIPIENTS'			=> 'Максимальное разрешённое число получателей ЛС',
	'PM_MAX_RECIPIENTS_EXPLAIN'	=> 'Максимальное разрешённое количество получателей личного сообщения. 0 означает отсутствие ограничения. Данное значение может быть установлено для каждой группы пользователей на странице управления группами.',
));

// Post Settings
$lang = array_merge($lang, array(
	'ACP_POST_SETTINGS_EXPLAIN'			=> 'Здесь вы можете задать настройки по умолчанию для размещаемых сообщений.',
	'ALLOW_POST_LINKS'					=> 'Разрешить ссылки в обычных/личных сообщениях',
	'ALLOW_POST_LINKS_EXPLAIN'			=> 'В случае запрета тег BBCode <code>[URL]</code> и автоматическое преобразование текста в ссылки будут отключены.',
	'ALLOW_POST_FLASH'					=> 'Разрешить тег BBCode <code>[FLASH]</code> в сообщениях',
	'ALLOW_POST_FLASH_EXPLAIN'			=> 'Если тег BBCode <code>[FLASH]</code> запрещён, он будет отключён в сообщениях. Определить пользователей, имеющих право использовать тег BBCode <code>[FLASH]</code>, можно с помощью системы управления правами доступа.',

	'BUMP_INTERVAL'					=> 'Задержка поднятия темы',
	'BUMP_INTERVAL_EXPLAIN'			=> 'Количество минут, часов или дней с последнего сообщения, по прошествии которых можно поднимать тему. Введите 0 для отключения этой возможности',
	'CHAR_LIMIT'					=> 'Максимальное количество символов в сообщениях',
	'CHAR_LIMIT_EXPLAIN'			=> 'Максимальное количество символов, разрешённых в сообщениях и в личных сообщениях. Введите 0 для снятия ограничений.',
	'DELETE_TIME'					=> 'Ограничение времени на удаление',
	'DELETE_TIME_EXPLAIN'			=> 'Ограничение времени, в течение которого доступно удаление новых сообщений. Введите 0 для отключения этой возможности.',
	'DISPLAY_LAST_EDITED'			=> 'Отображать сведения о последнем редактировании',
	'DISPLAY_LAST_EDITED_EXPLAIN'	=> 'Выберите для отображения информации о последнем редактировании сообщения.',
	'EDIT_TIME'						=> 'Ограничение времени на редактирование',
	'EDIT_TIME_EXPLAIN'				=> 'Ограничение времени, в течение которого доступно редактирование новых сообщений. Введите 0 для отключения этой возможности.',
	'FLOOD_INTERVAL'				=> 'Задержка флуда',
	'FLOOD_INTERVAL_EXPLAIN'		=> 'Количество секунд, которое должно пройти между двумя сообщениями пользователя. Чтобы разрешить пользователям игнорировать это ограничение, установите им соответствующие права.',
	'HOT_THRESHOLD'					=> 'Сообщений в популярной теме',
	'HOT_THRESHOLD_EXPLAIN'			=> 'Необходимое количество сообщений в теме для того, чтобы она приобрела статус популярной темы. Введите 0 для отключения популярных тем.',
	'MAX_POLL_OPTIONS'				=> 'Максимальное количество вариантов ответа в опросах',
	'MAX_POST_FONT_SIZE'			=> 'Максимальный размер шрифта в сообщении',
	'MAX_POST_FONT_SIZE_EXPLAIN'	=> 'Максимальный размер шрифта, разрешённый в сообщении. Введите 0 для снятия ограничений.',
	'MAX_POST_IMG_HEIGHT'			=> 'Максимальная высота изображения в сообщении',
	'MAX_POST_IMG_HEIGHT_EXPLAIN'	=> 'Максимальная высота изображений/flash в сообщениях. Введите 0 для снятия ограничений.',
	'MAX_POST_IMG_WIDTH'			=> 'Максимальная ширина изображения в сообщении',
	'MAX_POST_IMG_WIDTH_EXPLAIN'	=> 'Максимальная ширина изображений/flash в сообщениях. Введите 0 для снятия ограничений.',
	'MAX_POST_URLS'					=> 'Максимальное количество ссылок в сообщении',
	'MAX_POST_URLS_EXPLAIN'			=> 'Максимальное количество ссылок в сообщении. Введите 0 для снятия ограничений.',
	'MIN_CHAR_LIMIT'				=> 'Минимальное количество символов в сообщениях',
	'MIN_CHAR_LIMIT_EXPLAIN'		=> 'Минимальное количество символов, необходимое для публикации сообщений и личных сообщений. Наименьшее возможное значение равно 1.',
	'POSTING'						=> 'Размещение сообщений',
	'POSTS_PER_PAGE'				=> 'Сообщений на странице',
	'QUOTE_DEPTH_LIMIT'				=> 'Максимальная глубина вложенности цитат',
	'QUOTE_DEPTH_LIMIT_EXPLAIN'		=> 'Максимальная глубина вложенности для цитат в сообщениях. Введите 0 для снятия ограничений.',
	'SMILIES_LIMIT'					=> 'Максимальное количество смайликов в сообщении',
	'SMILIES_LIMIT_EXPLAIN'			=> 'Максимальное количество смайликов в сообщении. Введите 0 для снятия ограничений.',
	'SMILIES_PER_PAGE'				=> 'Смайликов на странице',
	'TOPICS_PER_PAGE'				=> 'Тем на странице',
));

// Signature Settings
$lang = array_merge($lang, array(
	'ACP_SIGNATURE_SETTINGS_EXPLAIN'	=> 'Здесь вы можете задать настройки по умолчанию для подписей.',

	'MAX_SIG_FONT_SIZE'				=> 'Максимальный размер шрифта в подписи',
	'MAX_SIG_FONT_SIZE_EXPLAIN'		=> 'Максимальный размер шрифта, разрешённый в подписях пользователей. Введите 0 для снятия ограничений.',
	'MAX_SIG_IMG_HEIGHT'			=> 'Максимальная высота изображения в подписи',
	'MAX_SIG_IMG_HEIGHT_EXPLAIN'	=> 'Максимальная высота изображения/flash в подписях пользователей. Введите 0 для снятия ограничений.',
	'MAX_SIG_IMG_WIDTH'				=> 'Максимальная ширина изображения в подписи',
	'MAX_SIG_IMG_WIDTH_EXPLAIN'		=> 'Максимальная ширина изображения/flash в подписях пользователей. Введите 0 для снятия ограничений.',
	'MAX_SIG_LENGTH'				=> 'Максимальная длина подписи',
	'MAX_SIG_LENGTH_EXPLAIN'		=> 'Максимальное количество символов в подписях пользователей.',
	'MAX_SIG_SMILIES'				=> 'Максимум смайликов в подписи',
	'MAX_SIG_SMILIES_EXPLAIN'		=> 'Максимальное количество смайликов, разрешённое в подписях пользователей. Введите 0 для снятия ограничений.',
	'MAX_SIG_URLS'					=> 'Максимум ссылок в подписи',
	'MAX_SIG_URLS_EXPLAIN'			=> 'Максимальное количество ссылок в подписях пользователей. Введите 0 для снятия ограничений.',
));

// Registration Settings
$lang = array_merge($lang, array(
	'ACP_REGISTER_SETTINGS_EXPLAIN'		=> 'Здесь вы можете задать настройки, связанные с регистрацией пользователей.',

	'ACC_ACTIVATION'					=> 'Активация учётных записей',
	'ACC_ACTIVATION_EXPLAIN'			=> 'Эта группа настроек определяет, могут ли пользователи иметь доступ к конференции сразу после регистрации или для этого требуется подтверждение регистрации. Также здесь можно отключить регистрацию вообще.',
	'NEW_MEMBER_POST_LIMIT'				=> 'Лимит сообщений для новых пользователей',
	'NEW_MEMBER_POST_LIMIT_EXPLAIN'		=> 'Вновь зарегистрированные пользователи будут находиться в группе <em>Новые пользователи</em> до тех пор, пока они не опубликуют указанного здесь количества сообщений. Вы можете использовать эту группу, чтобы воспрепятствовать новым пользователям использовать систему личных сообщений, или для предварительного просмотра их сообщений. Введите 0, если хотите отключить эту возможность.',
	'NEW_MEMBER_GROUP_DEFAULT'			=> 'Установить группу «Новые пользователи» как группу по умолчанию',
	'NEW_MEMBER_GROUP_DEFAULT_EXPLAIN'	=> 'При включении данной опции и при указании лимита сообщений для новых пользователей все вновь зарегистрированные пользователи будут не только входить в группу <em>Новые пользователи</em>, но эта группа также будет назначена им в качестве группы по умолчанию. Это может быть удобно, например, если вы хотите назначить на эту группу определённое звание или аватару, которые будут наследовать новые пользователи.',

	'ACC_ADMIN'					=> 'Администратором',
	'ACC_DISABLE'				=> 'Отключить регистрацию',
	'ACC_NONE'					=> 'Без активации (немедленный доступ)',
	'ACC_USER'					=> 'Пользователем (email-подтверждение)',
//	'ACC_USER_ADMIN'			=> 'User + Admin',
	'ALLOW_EMAIL_REUSE'			=> 'Разрешить повторное использование email-адреса',
	'ALLOW_EMAIL_REUSE_EXPLAIN'	=> 'Разные пользователи смогут регистрироваться с одинаковым email-адресом.',
	'COPPA'						=> 'COPPA',
	'COPPA_FAX'					=> 'Номер факса для COPPA',
	'COPPA_MAIL'				=> 'Почтовый адрес для COPPA',
	'COPPA_MAIL_EXPLAIN'		=> 'Почтовый адрес, на который родители должны отправлять формы регистрации COPPA.',
	'ENABLE_COPPA'				=> 'Включить COPPA',
	'ENABLE_COPPA_EXPLAIN'		=> 'От пользователя потребуется подтвердить, достиг ли он возраста 13 лет или старше, для соответствия требованиям U.S. COPPA Act. Если отключено, специальные группы COPPA больше не будут отображены.',
	'MAX_CHARS'					=> 'макс.',
	'MIN_CHARS'					=> 'мин.',
	'NO_AUTH_PLUGIN'			=> 'Не найдено подходящего модуля авторизации.',
	'PASSWORD_LENGTH'			=> 'Длина пароля',
	'PASSWORD_LENGTH_EXPLAIN'	=> 'Минимальное и максимальное количество символов в паролях.',
	'REG_LIMIT'					=> 'Попытки регистрации',
	'REG_LIMIT_EXPLAIN'			=> 'Максимальное количество попыток регистрации с подтверждением против спам-ботов, разрешённое в течение одной сессии.',
	'USERNAME_ALPHA_ONLY'		=> 'Только буквенно-цифровые',
	'USERNAME_ALPHA_SPACERS'	=> 'Буквенно-цифровые и разделители',
	'USERNAME_ASCII'			=> 'ASCII (без международного юникода)',
	'USERNAME_LETTER_NUM'		=> 'Любые буквы и цифры',
	'USERNAME_LETTER_NUM_SPACERS'	=> 'Любые буквы, цифры и разделители',
	'USERNAME_CHARS'			=> 'Ограничения на символы в имени пользователя',
	'USERNAME_CHARS_ANY'		=> 'Любые символы',
	'USERNAME_CHARS_EXPLAIN'	=> 'Символы, которые могут быть использованы в именах пользователей. Разделителями считаются символы пробела, -, +, _, [ и ]',
	'USERNAME_LENGTH'			=> 'Длина имени пользователя',
	'USERNAME_LENGTH_EXPLAIN'	=> 'Минимальное и максимальное количество символов в именах пользователей.',
));

// Feeds
$lang = array_merge($lang, array(
	'ACP_FEED_MANAGEMENT'				=> 'Каналы новостей',
	'ACP_FEED_MANAGEMENT_EXPLAIN'		=> 'Данный модуль предоставляет различные каналы новостей в формате ATOM, обрабатывая BBCode в сообщениях и делая его удобочитаемым во внешних программах чтения каналов новостей.',

	'ACP_FEED_GENERAL'					=> 'Общие настройки каналов новостей',
 	'ACP_FEED_POST_BASED'				=> 'Настройки каналов сообщений',
 	'ACP_FEED_TOPIC_BASED'				=> 'Настройки каналов тем',
 	'ACP_FEED_SETTINGS_OTHER'			=> 'Прочие настройки каналов новостей',

	'ACP_FEED_ENABLE'					=> 'Включить каналы новостей',
	'ACP_FEED_ENABLE_EXPLAIN'			=> 'Включение или отключение каналов новостей для всей конференции. При отключении этой опции будут отключены все каналы новостей, независимо от указанных ниже параметров.',
	'ACP_FEED_LIMIT'					=> 'Количество элементов',
	'ACP_FEED_LIMIT_EXPLAIN'			=> 'Максимальное количество элементов канала новостей для отображения.',

 	'ACP_FEED_OVERALL'					=> 'Включить общий канал новостей',
 	'ACP_FEED_OVERALL_EXPLAIN'			=> 'Новые сообщения конференции.',
	'ACP_FEED_FORUM'					=> 'Включить каналы форумов',
	'ACP_FEED_FORUM_EXPLAIN'			=> 'Новые сообщения отдельных форумов.',
	'ACP_FEED_TOPIC'					=> 'Включить каналы тем',
	'ACP_FEED_TOPIC_EXPLAIN'			=> 'Новые сообщения отдельных тем.',

 	'ACP_FEED_TOPICS_NEW'				=> 'Включить канал новых тем',
 	'ACP_FEED_TOPICS_NEW_EXPLAIN'		=> 'Включает канал «Новые темы», который позволяет получать информацию о новых темах с текстом первого сообщения.',
 	'ACP_FEED_TOPICS_ACTIVE'			=> 'Включить канал активных тем',
 	'ACP_FEED_TOPICS_ACTIVE_EXPLAIN'	=> 'Включает канал «Активные темы», который позволяет получать новые активные темы с текстом последнего сообщения.',
 	'ACP_FEED_NEWS'						=> 'Канал новостей',
  	'ACP_FEED_NEWS_EXPLAIN'				=> 'Первые сообщения новых тем указанных форумов. Не выбирайте форумы, чтобы отключить канал новостей.<br />Чтобы выбрать несколько форумов, пользуйтесь мышью, удерживая кнопку <samp>CTRL</samp>.',

	'ACP_FEED_OVERALL_FORUMS'			=> 'Включить канал форумов',
	'ACP_FEED_OVERALL_FORUMS_EXPLAIN'	=> 'Включает канал «Все форумы», который позволяет получить список форумов.',

 	'ACP_FEED_HTTP_AUTH'				=> 'Разрешить HTTP-аутентификацию',
 	'ACP_FEED_HTTP_AUTH_EXPLAIN'		=> 'Включает аутентификацию через HTTP, которая позволяет пользователям получать информацию, недоступную для гостей, с добавлением параметра <samp>auth=http</samp> в адресную строку канала новостей. Учтите, что для работы данной функции на некоторых серверах может потребоваться внесение дополнительных изменений в файл .htaccess.',
	'ACP_FEED_ITEM_STATISTICS'			=> 'Статистика элементов',
	'ACP_FEED_ITEM_STATISTICS_EXPLAIN'	=> 'Отображение индивидуальной статистики под элементами канала (такой как автор сообщения, дата и время публикации, количество ответов и просмотров).',
	'ACP_FEED_EXCLUDE_ID'				=> 'Исключить данные форумы',
	'ACP_FEED_EXCLUDE_ID_EXPLAIN'		=> 'Содержимое следующих форумов не будет включено в каналы новостей. Не выбирайте ничего, если хотите получать данные со всех форумов. Чтобы выбрать несколько форумов, пользуйтесь мышью, удерживая кнопку <samp>CTRL</samp>.',
));

// Visual Confirmation Settings
$lang = array_merge($lang, array(
	'ACP_VC_SETTINGS_EXPLAIN'				=> 'Здесь вы можете выбрать и настроить модули, предназначенные для борьбы со спам-ботами. Эти средства обычно используют проверку пользователя с помощью <em>CAPTCHA</em> - специального теста, который сложен для автоматического распознавания.',
	'AVAILABLE_CAPTCHAS'					=> 'Доступные модули',
	'CAPTCHA_UNAVAILABLE'					=> 'Данный модуль не может быть выбран, поскольку требования для его использования не выполнены.',
	'CAPTCHA_GD'							=> 'GD картинка',
	'CAPTCHA_GD_3D'							=> 'GD 3D картинка',
	'CAPTCHA_GD_FOREGROUND_NOISE'			=> 'Шум на переднем плане',
	'CAPTCHA_GD_EXPLAIN'					=> 'Использовать библиотеку GD для создания усложнённой картинки против спам-ботов.',
	'CAPTCHA_GD_FOREGROUND_NOISE_EXPLAIN'	=> 'Использовать шум на переднем плане, чообы усложнить распознавание картинки.',
	'CAPTCHA_GD_X_GRID'						=> 'Фоновый шум по горизонтали',
	'CAPTCHA_GD_X_GRID_EXPLAIN'				=> 'Используйте меньшее значение для усложнения распознавания картинки. Введите 0 для отключения шума по горизонтали.',
	'CAPTCHA_GD_Y_GRID'						=> 'Фоновой шум по вертикали',
	'CAPTCHA_GD_Y_GRID_EXPLAIN'				=> 'Используйте меньшее значение для усложнения распознавания картинки. Введите 0 для отключения шума по вертикали.',
	'CAPTCHA_GD_WAVE'						=> 'Волновое искажение',
	'CAPTCHA_GD_WAVE_EXPLAIN'				=> 'Использовать волновое искажение картинки.',
	'CAPTCHA_GD_3D_NOISE'					=> 'Добавить 3D-шум',
	'CAPTCHA_GD_3D_NOISE_EXPLAIN'			=> 'Опция добавляет к картинке дополнительные объекты, располагая их поверх символов.',
	'CAPTCHA_GD_FONTS'						=> 'Использовать другие шрифты',
	'CAPTCHA_GD_FONTS_EXPLAIN'				=> 'Опция позволяет управлять количеством видов используемых символов. Вы можете использовать значение по умолчанию или добавить изменённые символы. Возможно добавление символов в нижнем регистре.',
	'CAPTCHA_FONT_DEFAULT'					=> 'По умолчанию',
	'CAPTCHA_FONT_NEW'						=> 'Новые виды символов',
	'CAPTCHA_FONT_LOWER'					=> 'Также использовать нижний регистр',
	'CAPTCHA_NO_GD'							=> 'Простая картинка',
	'CAPTCHA_PREVIEW_MSG'					=> 'Это предварительный просмотр. Изменения в настройках не сохранены.',
	'CAPTCHA_PREVIEW_EXPLAIN'				=> 'Здесь показывается, как будет работать модуль при использовании текущих настроек.',

	'CAPTCHA_SELECT'						=> 'Установленные модули',
	'CAPTCHA_SELECT_EXPLAIN'				=> 'В этом списке содержатся модули, распознанные вашей конференцией. Модули, помеченные серым цветом, недоступны, и, возможно, нуждаются в предварительной настройке перед их использованием.',
	'CAPTCHA_CONFIGURE'						=> 'Настройка модулей',
	'CAPTCHA_CONFIGURE_EXPLAIN'				=> 'Изменить настройки выбранного модуля.',
	'CONFIGURE'								=> 'Настроить',
	'CAPTCHA_NO_OPTIONS'					=> 'Данный модуль не имеет настроек.',

	'VISUAL_CONFIRM_POST'					=> 'Использовать средства против спам-ботов при отправке сообщений гостями',
	'VISUAL_CONFIRM_POST_EXPLAIN'			=> 'Анонимным пользователям понадобится пройти проверку средством против спам-ботов для предотвращения автоматической отправки сообщений.',
	'VISUAL_CONFIRM_REG'					=> 'Использовать средства против спам-ботов при регистрации',
	'VISUAL_CONFIRM_REG_EXPLAIN'			=> 'Новым пользователям понадобится пройти проверку средством против спам-ботов для предотвращения автоматических регистраций.',
	'VISUAL_CONFIRM_REFRESH'				=> 'Разрешить пользователям обновлять задание теста против спам-ботов',
	'VISUAL_CONFIRM_REFRESH_EXPLAIN'		=> 'Опция позволяет пользователям запрашивать новое задание теста против спам-ботов, если они не смогли справиться с текущим заданием. Некоторые модули могут не поддерживать эту функцию.',
));

// Cookie Settings
$lang = array_merge($lang, array(
	'ACP_COOKIE_SETTINGS_EXPLAIN'		=> 'Здесь вы можете изменить настройки cookies, отправляемые в браузеры посетителей. В большинстве случаев достаточно настроек по умолчанию. Если вам всё же нужно изменить настройки, то делайте это осторожно — неверные значения могут привести к невозможности входа пользователей на конференцию.',

	'COOKIE_DOMAIN'				=> 'Домен cookie',
	'COOKIE_NAME'				=> 'Имя cookie',
	'COOKIE_PATH'				=> 'Путь cookie',
	'COOKIE_SECURE'				=> 'Безопасные cookie [ https ]',
	'COOKIE_SECURE_EXPLAIN'		=> 'Если ваш сервер работает через SSL, то включите этот параметр. В противном случае оставьте выключенным. Включение этого параметра, если сервер работает не через SSL, приведёт к ошибкам при переходах по страницам конференции и при переадресации.',
	'ONLINE_LENGTH'				=> 'Временной диапазон онлайн-статистики',
	'ONLINE_LENGTH_EXPLAIN'		=> 'Количество минут, по прошествии которых неактивные пользователи перестанут быть видимыми в списке «Кто сейчас на конференции». Увеличение этого значения повышает расход ресурсов сервера на создание списка.',
	'SESSION_LENGTH'			=> 'Длительность сессии',
	'SESSION_LENGTH_EXPLAIN'	=> 'Сессия будет завершена по прошествии указанного времени в секундах.',
));

// Load Settings
$lang = array_merge($lang, array(
	'ACP_LOAD_SETTINGS_EXPLAIN'	=> 'Здесь вы можете включать и отключать некоторые функции конференции для снижения нагрузки на сервер. Для большинства серверов нет необходимости отключать какие-либо функции. Тем не менее на некоторых системах или коллективных хостингах может быть полезным отключение возможностей, которые вам не требуются. Вы можете также задать ограничения для нагрузки на сервер и активных сессий, при превышении которых конференция будет отключена.',

	'CUSTOM_PROFILE_FIELDS'			=> 'Дополнительные поля в профилях',
	'LIMIT_LOAD'					=> 'Ограничить нагрузку на сервер',
	'LIMIT_LOAD_EXPLAIN'			=> 'Если средняя ежеминутная нагрузка на сервер превышает заданное значение, конференция будет автоматически отключена. Значение, равное 1.0, означает ≈100% использование ресурсов одного процессора. Эта возможность применима только для серверов на основе UNIX. Значение будет сброшено в 0, если phpBB не сможет получить предел загрузки системы.',
	'LIMIT_SESSIONS'				=> 'Ограничить сессии',
	'LIMIT_SESSIONS_EXPLAIN'		=> 'Если количество сессий превышает заданное значение в течение одной минуты, конференция будет автоматически отключена. Введите 0 для снятия ограничений.',
	'LOAD_CPF_MEMBERLIST'			=> 'Разрешить отображение дополнительных полей профиля в списке пользователей',
	'LOAD_CPF_VIEWPROFILE'			=> 'Показывать дополнительные поля в профилях пользователей',
	'LOAD_CPF_VIEWTOPIC'			=> 'Показывать дополнительные поля на страницах тем',
	'LOAD_USER_ACTIVITY'			=> 'Показать активность пользователя',
	'LOAD_USER_ACTIVITY_EXPLAIN'	=> 'Отображение темы/форума, в которых пользователь наиболее активен, в его профиле и личном разделе. Рекомендуется отключить эту функцию на конференциях с более чем одним миллионом сообщений.',
	'RECOMPILE_STYLES'				=> 'Перекомпилировать старые шаблоны',
	'RECOMPILE_STYLES_EXPLAIN'		=> 'Проверка обновлённых компонентов стилей и повторная их компиляция в случае необходимости.',
	'YES_ANON_READ_MARKING'			=> 'Включить маркировку тем для гостей',
	'YES_ANON_READ_MARKING_EXPLAIN'	=> 'Сохранять информацию о статусе «прочитано/не прочитано» для гостей. Если отключено, сообщения для гостей всегда помечены как прочитанные.',
	'YES_BIRTHDAYS'					=> 'Включить список дней рождения',
	'YES_BIRTHDAYS_EXPLAIN'			=> 'Если список дней рождения отключён, он не будет отображаться. Для того, чтобы эта настройка работала, должна быть также включена функция дней рождения.',
	'YES_JUMPBOX'					=> 'Включить отображение быстрого перехода',
	'YES_MODERATORS'				=> 'Включить отображение модераторов',
	'YES_ONLINE'					=> 'Включить информацию об активных пользователях',
	'YES_ONLINE_EXPLAIN'			=> 'Отображать информацию об активных пользователях на главной странице, при просмотре форумов и тем.',
	'YES_ONLINE_GUESTS'				=> 'Включить отображение гостей в списках активных пользователей',
	'YES_ONLINE_GUESTS_EXPLAIN'		=> 'Разрешить отображение информации о гостях при просмотре «Кто сейчас на конференции».',
	'YES_ONLINE_TRACK'				=> 'Включить отображение информации о пользователе «в сети/не в сети»',
	'YES_ONLINE_TRACK_EXPLAIN'		=> 'Отображать информацию о нахождении пользователя в сети в профилях и при просмотре тем.',
	'YES_POST_MARKING'				=> 'Включить свои темы',
	'YES_POST_MARKING_EXPLAIN'		=> 'Указывать, оставлял ли пользователь сообщения в теме.',
	'YES_READ_MARKING'				=> 'Включить маркировку тем на сервере',
	'YES_READ_MARKING_EXPLAIN'		=> 'Сохранять информацию о статусе «прочитано/не прочитано» в базе данных, а не в cookies.',
	'YES_UNREAD_SEARCH'				=> 'Включить поиск непрочитанных сообщений',
));

// Auth settings
$lang = array_merge($lang, array(
	'ACP_AUTH_SETTINGS_EXPLAIN'	=> 'phpBB поддерживает расширения аутентификации, или модули. Они позволяют вам установить способ аутентификации пользователей при их входе на конференцию. По умолчанию доступны три модуля: DB, LDAP и Apache. Не все методы требуют дополнительной информации, поэтому заполняйте только те поля, которые необходимы для выбранного метода.',

	'AUTH_METHOD'				=> 'Выбрать метод аутентификации',

	'APACHE_SETUP_BEFORE_USE'	=> 'Необходимо настроить аутентификацию Apache при переключении phpBB на этот метод аутентификации. Помните, что имя пользователя для аутентификации в Apache должно совпадать с вашим именем пользователя в phpBB. Аутентификация Apache может использоваться только с mod_php (не с версией CGI) и с отключённым safe_mode.',

	'LDAP_DN'						=> 'Основное имя LDAP [ <var>dn</var> ]',
	'LDAP_DN_EXPLAIN'				=> 'Уникальное имя (Distinguished Name), определяющее информацию о пользователе, например <samp>o=My Company,c=US</samp>.',
	'LDAP_EMAIL'					=> 'Email-атрибут LDAP',
	'LDAP_EMAIL_EXPLAIN'			=> 'Задайте имя атрибута email пользователя (если он существует) для автоматического присвоения email-адресов новым пользователям. Если это поле оставить пустым, то email-адреса пользователей, которые впервые вошли на конференцию, также будут пустыми.',
	'LDAP_INCORRECT_USER_PASSWORD'	=> 'Попытка связи с сервером LDAP с указанным именем или паролем не удалась.',
	'LDAP_NO_EMAIL'					=> 'Указанный атрибут email не существует.',
	'LDAP_NO_IDENTITY'				=> 'Не удалось найти идентификатор входа в систему для %s.',
	'LDAP_PASSWORD'					=> 'Пароль LDAP',
	'LDAP_PASSWORD_EXPLAIN'			=> 'Оставьте поле пустым для использования анонимного соединения. В противном случае введите пароль для вышеуказанного пользователя. Требуется для серверов Active Directory.<br /><em><strong>Внимание:</strong> этот пароль будет сохранён в базе данных в незашифрованном виде и будет виден всем, кто имеет доступ к ней или к этой странице настроек.</em>',
	'LDAP_PORT'						=> 'Порт сервера LDAP',
	'LDAP_PORT_EXPLAIN'				=> 'Вы можете указать порт, который должен использоваться для соединения с сервером LDAP вместо порта по умолчанию 389.',
	'LDAP_SERVER'					=> 'Имя сервера LDAP',
	'LDAP_SERVER_EXPLAIN'			=> 'Если используется LDAP, укажите хост или IP-адрес сервера LDAP. Кроме этого, вы можете указать ссылку. Например, ldap://hostname:port/.',
	'LDAP_UID'						=> 'Идентификационный номер LDAP [ <var>uid</var> ]',
	'LDAP_UID_EXPLAIN'				=> 'Это ключ, с помощью которого производится поиск заданного идентификатора входа в систему. Например, <var>uid</var>, <var>sn</var> и так далее.',
	'LDAP_USER'						=> 'Пользователь LDAP [ <var>dn</var> ]',
	'LDAP_USER_EXPLAIN'				=> 'Оставьте поле пустым для использования анонимного соединения. Если поле заполнено, phpBB использует указанное имя при соединении с сервером LDAP для поиска правильного пользователя. Например, <samp>uid=Username,ou=MyUnit,o=MyCompany,c=US</samp>. Требуется для серверов Active Directory.',
	'LDAP_USER_FILTER'				=> 'Фильтр имени пользователя LDAP',
	'LDAP_USER_FILTER_EXPLAIN'		=> 'В дальнейшем вы можете ограничить диапазон искомых объектов с помощью дополнительных фильтров. Например, результатом <samp>objectClass=posixGroup</samp> будет <samp>(&amp;(uid=$username)(objectClass=posixGroup))</samp>.',
));

// Server Settings
$lang = array_merge($lang, array(
	'ACP_SERVER_SETTINGS_EXPLAIN'	=> 'Здесь задаются настройки, связанные с сервером и доменом. Удостоверьтесь в точности указанных вами данных, ошибки приведут к рассылке email-сообщений, содержащих неверную информацию. Задавая имя домена, помните, что оно должно включать http:// или префикс другого протокола. Изменяйте номер порта только в случае, если вам точно известно, что сервер использует другое значение, порт 80 подходит в большинстве случаев.',

	'ENABLE_GZIP'				=> 'Включить сжатие GZip',
	'ENABLE_GZIP_EXPLAIN'		=> 'Генерируемое содержимое будет сжиматься с помощью GZip перед отправкой пользователю. Включение этой опции помогает уменьшить расход сетевого трафика, но в то же время немного увеличивает использование центрального процессора, как на стороне клиента, так и на сервере. Требуется расширение PHP zlib.',
	'FORCE_SERVER_VARS'			=> 'Принудительные настройки URL сервера',
	'FORCE_SERVER_VARS_EXPLAIN'	=> 'Если выбрано, то указанные здесь настройки будут использованы вместо автоматически определённых значений.',
	'ICONS_PATH'				=> 'Путь к значкам сообщений',
	'ICONS_PATH_EXPLAIN'		=> 'Путь относительно корневой папки phpBB. Например, <samp>images/icons</samp>.',
	'PATH_SETTINGS'				=> 'Параметры путей',
	'RANKS_PATH'				=> 'Путь к картинкам званий',
	'RANKS_PATH_EXPLAIN'		=> 'Путь относительно корневой папки phpBB. Например, <samp>images/ranks</samp>.',
	'SCRIPT_PATH'				=> 'Путь к конференции',
	'SCRIPT_PATH_EXPLAIN'		=> 'Путь к папке, содержащей phpBB, относительно имени домена. Например, <samp>/phpBB3</samp>.',
	'SERVER_NAME'				=> 'Имя домена',
	'SERVER_NAME_EXPLAIN'		=> 'Имя домена, на котором работает конференция. Например, <samp>www.example.com</samp>.',
	'SERVER_PORT'				=> 'Порт сервера',
	'SERVER_PORT_EXPLAIN'		=> 'Порт, на котором запущен сервер, обычно это порт 80, изменяйте только в случае, если сервер использует другой порт.',
	'SERVER_PROTOCOL'			=> 'Протокол сервера',
	'SERVER_PROTOCOL_EXPLAIN'	=> 'Используется в качестве протокола сервера, если эти настройки включены принудительно. Если не задано или не включено принудительно, протокол будет определён по настройкам безопасных cookie (<samp>http://</samp> или <samp>https://</samp>).',
	'SERVER_URL_SETTINGS'		=> 'Настройки URL сервера',
	'SMILIES_PATH'				=> 'Путь к смайликам',
	'SMILIES_PATH_EXPLAIN'		=> 'Путь относительно корневой папки phpBB. Например, <samp>images/smilies</samp>.',
	'UPLOAD_ICONS_PATH'			=> 'Путь к значкам групп расширений',
	'UPLOAD_ICONS_PATH_EXPLAIN'	=> 'Путь относительно корневой папки phpBB. Например, <samp>images/upload_icons</samp>.',
));

// Security Settings
$lang = array_merge($lang, array(
	'ACP_SECURITY_SETTINGS_EXPLAIN'	=> 'Здесь вы можете задать настройки, связанные с сессиями и входом пользователей на конференцию.',

	'ALL'							=> 'Полная',
	'ALLOW_AUTOLOGIN'				=> 'Разрешить автоматический вход на конференцию',
	'ALLOW_AUTOLOGIN_EXPLAIN'		=> 'Опция определяет, могут ли пользователи автоматически входить на конференцию при её очередном посещении.',
	'AUTOLOGIN_LENGTH'				=> 'Время действия автоматического входа (дней)',
	'AUTOLOGIN_LENGTH_EXPLAIN'		=> 'Количество дней, в течение которого пользователь может автоматически входить на конференцию. Введите 0 для снятия ограничений.',
	'BROWSER_VALID'					=> 'Проверка браузера',
	'BROWSER_VALID_EXPLAIN'			=> 'Включает проверку браузера при каждой сессии для повышения безопасности.',
	'CHECK_DNSBL'					=> 'Проверить IP-адрес по чёрному списку DNS (DNS Blackhole List)',
	'CHECK_DNSBL_EXPLAIN'			=> 'Если включено, IP-адрес пользователя будет проверен с помощью следующих служб  DNSBL при регистрации или отправке сообщений: <a href="http://spamcop.net">spamcop.net</a> и <a href="http://www.spamhaus.org">www.spamhaus.org</a>. Эта процедура может занять некоторое время в зависимости от конфигурации сервера. В случае замедления работы сервера или большого количества ложных срабатываний рекомендуется отключить эту проверку.',
	'CLASS_B'						=> 'A.B',
	'CLASS_C'						=> 'A.B.C',
	'EMAIL_CHECK_MX'				=> 'Проверить правильность почтовой записи в DNS (MX Record) домена email-адреса',
	'EMAIL_CHECK_MX_EXPLAIN'		=> 'Если включено, домен email-адреса, указанный при регистрации или изменении профиля, проверяется на правильность  почтовой записи в DNS (MX Record).',
	'FORCE_PASS_CHANGE'				=> 'Принудительная смена пароля',
	'FORCE_PASS_CHANGE_EXPLAIN'		=> 'Пользователь должен будет сменить свой пароль по прошествии указанного количества дней. Введите 0 для отключения этой функции.',
	'FORM_TIME_MAX'					=> 'Максимальное время для отправки формы',
	'FORM_TIME_MAX_EXPLAIN'			=> 'Время, за которое пользователь должен отправить форму. Установите -1 для отключения этой функции. Учтите, что форма может устареть по истечении сессии, независимо от данной опции.',
	'FORM_SID_GUESTS'				=> 'Привязать формы к гостевым сессиям',
	'FORM_SID_GUESTS_EXPLAIN'		=> 'Если включено, формы, отправляемые гостями, будут привязаны к конкретным сессиям. Это может вызвать проблемы с некоторыми интернет-провайдерами.',
	'FORWARDED_FOR_VALID'			=> 'Проверка заголовка <var>X_FORWARDED_FOR</var>',
	'FORWARDED_FOR_VALID_EXPLAIN'	=> 'Сессия будет продолжена только в том случае, если отправленный заголовок <var>X_FORWARDED_FOR</var> соответствует отправленному в предыдущем запросе. Блокировка доступа по IP-адресу будет осуществляться по IP-адресам из заголовка <var>X_FORWARDED_FOR</var>.',
	'IP_VALID'						=> 'Проверка IP-адреса сессии',
	'IP_VALID_EXPLAIN'				=> 'Определяет, какая часть IP-адреса пользователя используется для проверки сессии. <samp>Полная</samp> означает проверку всего адреса, <samp>A.B.C</samp> — первых трёх чисел (x.x.x), <samp>A.B</samp> — первых двух чисел (x.x), <samp>Нет</samp> отключает проверку. В адресах IPv6 <samp>A.B.C</samp> сравнивает первые 4 блока и <samp>A.B</samp> — первые 3 блока.',
	'IP_LOGIN_LIMIT_MAX'			=> 'Максимальное число попыток входа для одного IP адреса',
	'IP_LOGIN_LIMIT_MAX_EXPLAIN'	=> 'Порог разрешённого числа попыток входа с одного IP адреса до включения задания против спам-ботов. Введите 0 для отключения этой функции.',
	'IP_LOGIN_LIMIT_TIME'			=> 'Время действия для попыток входа с IP адреса',
	'IP_LOGIN_LIMIT_TIME_EXPLAIN'	=> 'Информация о попытках входа будет очищена по прошествии указанного времени.',
	'IP_LOGIN_LIMIT_USE_FORWARDED'	=> 'Ограничить число попыток входа по заголовку <var>X_FORWARDED_FOR</var>',
	'IP_LOGIN_LIMIT_USE_FORWARDED_EXPLAIN'	=> 'Вместо ограничения числа попыток входа по IP адресу, ограничение будет производиться по значениям адреса в заголовке <var>X_FORWARDED_FOR</var>. <br /><em><strong>Внимание:</strong> Включайте данную функцию только в случае, если используется прокси-сервер, устанавливающий достоверные значения заголовка <var>X_FORWARDED_FOR</var>.</em>',
	'MAX_LOGIN_ATTEMPTS'			=> 'Максимальное число попыток входа по имени пользователя',
	'MAX_LOGIN_ATTEMPTS_EXPLAIN'	=> 'Порог разрешённого числа попыток входа для одной учётной записи до включения задания против спам-ботов. Введите 0 для отключения этой функции.',
	'NO_IP_VALIDATION'				=> 'Нет',
	'NO_REF_VALIDATION'				=> 'Нет',
	'PASSWORD_TYPE'					=> 'Сложность пароля',
	'PASSWORD_TYPE_EXPLAIN'			=> 'Определяет, насколько сложным должен быть пароль при его установке или изменении. Каждый следующий вариант ограничения включает в себя предыдущие.',
	'PASS_TYPE_ALPHA'				=> 'Должен содержать буквенно-цифровые символы',
	'PASS_TYPE_ANY'					=> 'Требования отсутствуют',
	'PASS_TYPE_CASE'				=> 'Должен содержать символы разного регистра',
	'PASS_TYPE_SYMBOL'				=> 'Должен содержать символы',
	'REF_HOST'						=> 'Проверять только хост',
	'REF_PATH'						=> 'Проверять также путь',
	'REFERER_VALID'					=> 'Проверять рефёрер',
	'REFERER_VALID_EXPLAIN'			=> 'Если включено, рефёрер для запросов типа POST будет проверен на параметры хоста/пути к скрипту. Это может вызвать проблемы с конференциями, использующими несколько доменов или внешние аутентификации.',
	'TPL_ALLOW_PHP'					=> 'Разрешить php в шаблонах',
	'TPL_ALLOW_PHP_EXPLAIN'			=> 'Если эта функция включена, команды <code>PHP</code> и <code>INCLUDEPHP</code> будут распознаваться и выполняться в шаблонах.',
));

// Email Settings
$lang = array_merge($lang, array(
	'ACP_EMAIL_SETTINGS_EXPLAIN'	=> 'Эта информация используется для отправки конференцией email-сообщений пользователям. Удостоверьтесь в правильности указанных email-адресов, все возвращённые или не доставленные сообщения будут, вероятно, отправлены на них. Если ваш сервер не обеспечивает использование встроенной (в PHP) службы email, вы можете отправлять сообщения напрямую с использованием SMTP. Для этого необходим адрес подходящего сервера (если нужно, спросите об этом у провайдера). Если сервер требует аутентификации (и только в этом случае), введите необходимые имя, пароль и метод аутентификации.',

	'ADMIN_EMAIL'					=> 'Обратный email-адрес',
	'ADMIN_EMAIL_EXPLAIN'			=> 'Этот адрес будет использован для возврата всех email-сообщений как email-адрес для технических контактов. Он всегда будет использоваться в качестве адресов <samp>Return-Path</samp> и <samp>Sender</samp> в email-сообщениях.',
	'BOARD_EMAIL_FORM'				=> 'Рассылка email-сообщений через конференцию',
	'BOARD_EMAIL_FORM_EXPLAIN'		=> 'Пользователи смогут отправлять email-сообщения через конференцию вместо их обычной отправки.',
	'BOARD_HIDE_EMAILS'				=> 'Скрывать email-адреса',
	'BOARD_HIDE_EMAILS_EXPLAIN'		=> 'Эта функция полностью сохраняет в тайне email-адреса.',
	'CONTACT_EMAIL'					=> 'Контактный email-адрес',
	'CONTACT_EMAIL_EXPLAIN'			=> 'Этот адрес будет использоваться при каждой необходимости контакта, например, в случае спама, ошибок и т. п. Он всегда будет использоваться в качестве адресов <samp>From</samp> и <samp>Reply-To</samp> в email-сообщениях.',
	'EMAIL_FUNCTION_NAME'			=> 'Имя функции email',
	'EMAIL_FUNCTION_NAME_EXPLAIN'	=> 'Функция email, используемая для отправки сообщений через PHP.',
	'EMAIL_PACKAGE_SIZE'			=> 'Размер почтового пакета',
	'EMAIL_PACKAGE_SIZE_EXPLAIN'	=> 'Максимальное количество email-сообщений, отправляемых за один раз. Эта настройка применяется для внутренней очереди сообщений; установите 0 при возникновении проблем, связанных с неотправленными уведомлениями по email.',
	'EMAIL_SIG'						=> 'Подпись в email-сообщении',
	'EMAIL_SIG_EXPLAIN'				=> 'Этот текст будет добавлен во все email-сообщения, отправляемые конференцией.',
	'ENABLE_EMAIL'					=> 'Включить email-сообщения',
	'ENABLE_EMAIL_EXPLAIN'			=> 'Если выключено, отправка любых электронных сообщений с конференции производиться не будет. <em>Примечание: данная опция должна быть включена, если вы хотите задействовать активацию учётной записи администратором или пользователем. При отключении данной опции варианты активации учётной записи пользователем или администратором станут недоступны.</em>',
	'SMTP_AUTH_METHOD'				=> 'Метод аутентификации для SMTP',
	'SMTP_AUTH_METHOD_EXPLAIN'		=> 'Используется только в случае, если заданы имя/пароль. Спросите у своего провайдера, если не уверены, какой метод аутентификации использовать.',
	'SMTP_CRAM_MD5'					=> 'CRAM-MD5',
	'SMTP_DIGEST_MD5'				=> 'DIGEST-MD5',
	'SMTP_LOGIN'					=> 'LOGIN',
	'SMTP_PASSWORD'					=> 'Пароль SMTP',
	'SMTP_PASSWORD_EXPLAIN'			=> 'Введите пароль, только если SMTP требует этого.<br /><em><strong>Внимание:</strong> этот пароль будет сохранён в базе данных в незашифрованном виде и будет виден всем, кто имеет доступ к ней или к этой странице настроек.</em>',
	'SMTP_PLAIN'					=> 'PLAIN',
	'SMTP_POP_BEFORE_SMTP'			=> 'POP-BEFORE-SMTP',
	'SMTP_PORT'						=> 'Порт сервера SMTP',
	'SMTP_PORT_EXPLAIN'				=> 'Изменяйте порт только в том случае, если вам точно известно, что сервер использует другой порт.',
	'SMTP_SERVER'					=> 'Адрес сервера SMTP',
	'SMTP_SETTINGS'					=> 'Настройки SMTP',
	'SMTP_USERNAME'					=> 'Имя пользователя SMTP',
	'SMTP_USERNAME_EXPLAIN'			=> 'Введите имя только в случае, если сервер SMTP требует этого.',
	'USE_SMTP'						=> 'Использовать SMTP для отправки email-сообщений',
	'USE_SMTP_EXPLAIN'				=> 'Выберите «Да», если хотите или должны отправлять email-сообщения через сервер вместо локальной функции mail.',
));

// Jabber settings
$lang = array_merge($lang, array(
	'ACP_JABBER_SETTINGS_EXPLAIN'	=> 'Здесь вы можете включить и настроить использование Jabber в качестве мгновенных сообщений и уведомлений с конференции. Jabber — это протокол с открытым исходным кодом, и поэтому доступен для использования всеми желающими. Некоторые серверы Jabber имеют шлюзы и протоколы передачи, позволяющие связываться с пользователями других сетей. Не все серверы предоставляют все виды протоколов передачи, а изменения в протоколах могут препятствовать правильной работе. Убедитесь в том, что вы ввели данные зарегистрированной учётной записи — phpBB будет использовать эти данные в своей работе.',

	'JAB_ENABLE'				=> 'Включить Jabber',
	'JAB_ENABLE_EXPLAIN'		=> 'Включение опции позволит использовать Jabber для отправки мгновенных сообщений и уведомлений.',
	'JAB_GTALK_NOTE'			=> 'GTalk не будет работать, поскольку функция <samp>dns_get_record</samp> не найдена. Данная функция недоступна в PHP4 и не реализована на платформах Windows. В настоящее время функция также не работает на системах BSD, включая Mac OS.',
	'JAB_PACKAGE_SIZE'			=> 'Размер пакета Jabber',
	'JAB_PACKAGE_SIZE_EXPLAIN'	=> 'Количество сообщений, отправляемых в одном пакете. Если ввести 0, то сообщения будут отправляться немедленно без постановки в очередь для последующей отправки.',
	'JAB_PASSWORD'				=> 'Пароль Jabber',
 	'JAB_PASSWORD_EXPLAIN'		=> '<em><strong>Внимание:</strong> этот пароль будет сохранён в базе данных в незашифрованном виде и будет виден всем, кто имеет доступ к ней или к этой странице настроек.</em>',
	'JAB_PORT'					=> 'Порт Jabber',
	'JAB_PORT_EXPLAIN'			=> 'Оставьте пустым, если вам известно, что используется порт, отличный от 5222.',
	'JAB_SERVER'				=> 'Сервер Jabber',
	'JAB_SERVER_EXPLAIN'		=> 'Смотрите список серверов на %sjabber.org%s.',
	'JAB_SETTINGS_CHANGED'		=> 'Настройки Jabber успешно изменены.',
	'JAB_USE_SSL'				=> 'Использовать SSL для соединения',
	'JAB_USE_SSL_EXPLAIN'		=> 'При включении опции будет произведена попытка установки безопасного соединения. Порт Jabber будет изменён на 5223, если указан порт 5222.',
	'JAB_USERNAME'				=> 'Имя пользователя или JID (идентификатор) Jabber',
	'JAB_USERNAME_EXPLAIN'		=> 'Введите имя или существующий JID (идентификатор) зарегистрированного пользователя. Проверка имени производиться не будет. Если указано только имя, то ваш JID (идентификатор) будет составлен из этого имени и указанного выше имени сервера. В противном случае укажите существующий JID (идентификатор), например user@jabber.org.',
));

?>