<?php
/**
*
* acp_board [Ukrainian]
*
* @package language
* @version $Id: board.php 10080 2009-08-31 14:57:04Z nickvergessen $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Board Settings
$lang = array_merge($lang, array(
	'ACP_BOARD_SETTINGS_EXPLAIN'	=> 'Тут ви можете встановити основні налаштування конференції, вказати назву і опис, встановити часовий пояс та мову форуму.',
	'CUSTOM_DATEFORMAT'	=> 'Інший…',
	'DEFAULT_DATE_FORMAT'	=> 'Формат дати',
	'DEFAULT_DATE_FORMAT_EXPLAIN'	=> 'Формат дати ідентичний до функції PHP <code>date</code>.',
	'DEFAULT_LANGUAGE'	=> 'Мова за замовчуванням',
	'DEFAULT_STYLE'	=> 'Стиль за замовчуванням',
	'DISABLE_BOARD'	=> 'Вимкнути форум',
	'DISABLE_BOARD_EXPLAIN'	=> 'Це зробить форум недоступним для користувачів. Також при бажанні ви можете ввести коротке (255 символів) повідомлення, яке буде відображатись.',
	'OVERRIDE_STYLE'	=> 'Замінити стиль користувачам',
	'OVERRIDE_STYLE_EXPLAIN'	=> 'Замінює стиль, встановлений користувачами, на стиль за замовчуванням.',
	'SITE_DESC'	=> 'Опис сайту',
	'SITE_NAME'	=> 'Назва сайту',
	'SYSTEM_DST'	=> 'Увімкнути літній час/<abbr title="Daylight Saving Time">DST</abbr>',
	'SYSTEM_TIMEZONE'	=> 'Часовий пояс для гостей форуму',
	'SYSTEM_TIMEZONE_EXPLAIN'         => 'Часовий пояс, який буде використовуватись для відображення часу для незалогованих користувачів (гостей, ботів). Залоговані користувачі встановлюють часовий пояс при реєстрації і можуть змінювати його в своїй панелі керування.',
	'WARNINGS_EXPIRE'	=> 'Тривалість попередження',
	'WARNINGS_EXPIRE_EXPLAIN'	=> 'Кількість днів, які повинні пройти до того, як попередження буде автоматично зняте з користувача. Встановіть значення 0 для того, що зробити попередження постійними.',
));

// Board Features
$lang = array_merge($lang, array(
	'ACP_BOARD_FEATURES_EXPLAIN'	=> 'Тут ви можете вмикати/вимикати деякі функції форуму.',
	'ALLOW_ATTACHMENTS'	=> 'Дозволити приєднання файлів',
	'ALLOW_BIRTHDAYS'	=> 'Дозволити дні народження',
	'ALLOW_BIRTHDAYS_EXPLAIN'	=> 'Дозволяє введення дати народження і відображення віку в профілях. Зауважте, що список днів народжень на головній сторінці форуму контролюється відповідною функцією в панелі відображення.',
	'ALLOW_BOOKMARKS'	=> 'Дозволити закладки',
	'ALLOW_BOOKMARKS_EXPLAIN'	=> 'Користувач має можливість зберігати власні закладки.',
	'ALLOW_BBCODE'	=> 'Дозволити BBCode',
	'ALLOW_FORUM_NOTIFY'	=> 'Дозволити слідкування за форумом',
	'ALLOW_NAME_CHANGE'	=> 'Дозволити зміну імен користувачів',
	'ALLOW_NO_CENSORS'	=> 'Дозволити вимкнення цензора слів',
	'ALLOW_NO_CENSORS_EXPLAIN'	=> 'Користувачі зможуть вимикати цензор слів в повідомленнях і приватних повідомленнях.',
	'ALLOW_PM_ATTACHMENTS'	=> 'Дозволити приєднання файлів в приватних повідомленнях',
	'ALLOW_PM_REPORT'			=> 'Дозволити скарги на приватні повідомлення',
	'ALLOW_PM_REPORT_EXPLAIN'	=> 'Якщо дану опцію увімкнено, у користувачів з\'явиться можливість скаржитися модераторам на приватні повідомлення, які вони отримали від інших користувачів. Ці приватні повідомлення стануть видимими в Панелі модератора.',
	'ALLOW_QUICK_REPLY'			=> 'Дозволити швидку відповідь',
	'ALLOW_QUICK_REPLY_EXPLAIN'	=> 'Цей перемикач дозволяє вимкнути швидку відповідь на усіх форумах. Якщо дане налаштування увімкнено, для визначення відображення швидкої відповіді будуть використовуватись налаштування кожного окремого форуму.',
 	'ALLOW_QUICK_REPLY_BUTTON'	=> 'Відправити і увімкнути швидку відповідь в усіх форумах',	
	'ALLOW_SIG'	=> 'Дозволити підписи',
	'ALLOW_SIG_BBCODE'	=> 'Дозволити BBCode в підписах користувачів',
	'ALLOW_SIG_FLASH'	=> 'Дозволити використання тегу <code>[FLASH]</code> в підписах користувачів',
	'ALLOW_SIG_IMG'	=> 'Дозволити використання тегу <code>[IMG]</code> в підписах користувачів',
	'ALLOW_SIG_LINKS'	=> 'Дозволити використання посилань в підписах користувачів',
	'ALLOW_SIG_LINKS_EXPLAIN'	=> 'Якщо вимкнено, тег <code>[URL]</code> і автоматичні посилання будуть вимкнуті.',
	'ALLOW_SIG_SMILIES'	=> 'Дозволити використання смайликів в підписах користувачів',
	'ALLOW_SMILIES'	=> 'Дозволити смайлики',
	'ALLOW_TOPIC_NOTIFY'	=> 'Дозволити слідкування за темами',
	'BOARD_PM'	=> 'Приватні повідомлення',
	'BOARD_PM_EXPLAIN'	=> 'Дозволяє приватні повідомлення для усіх користувачів.',
));

// Avatar Settings
$lang = array_merge($lang, array(
	'ACP_AVATAR_SETTINGS_EXPLAIN'	=> 'Аватари - це невеликі унікальні зображення, які користувач може асоціювати з своєю особистістю. В залежності від стилю, вони, як правило, відображаються під іменем користувача під час перегляду тем. Тут ви можете налаштувати використання аватарів користувачами. Будь-ласка, майте на увазі, що для завантаження аватарів, вам потрібно створити директорію, яку ви вказали внизу і переконатись, що для неї встановлені права доступу на запис. Також, зауважте, що обмеження розміру файлу встановлюються лише на завантажені аватари, вони не застосовуються для віддалених зображень, на які встановлені посилання.',
	'ALLOW_AVATARS'			=> 'Увімкнути аватари',
	'ALLOW_AVATARS_EXPLAIN'		=> 'Дозволяє глобальне використання аватарів.<br />Якщо ви вимкнете аватари в цілому або забороните використання деяких режимів аватар, то вимкнені аватари більше не будуть відображатися на форумі, але користувачі, як і раніше, зможуть завантажувати свої власні аватари в Панелі керування.',
   'ALLOW_LOCAL'	=> 'Увімкнути галерею аватарів',
	'ALLOW_REMOTE'	=> 'Дозволити віддалені аватари',
	'ALLOW_REMOTE_EXPLAIN'	=> 'Посилання на аватари з інших серверів.',
  'ALLOW_REMOTE_UPLOAD'			=> 'Увімкнути віддалене завантаження аватарів',
  'ALLOW_REMOTE_UPLOAD_EXPLAIN'	=> 'Дозволити завантаження аватарів з інших сайтів.',
	'ALLOW_UPLOAD'	=> 'Дозволити завантаження аватарів на сервер',
	'AVATAR_GALLERY_PATH'	=> 'Шлях до галереї аватарів',
	'AVATAR_GALLERY_PATH_EXPLAIN'	=> 'Шлях відносно кореневої директорії phpBB для вже завантажених зображень, наприклад <samp>images/avatars/gallery</samp>.',
	'AVATAR_STORAGE_PATH'	=> 'Шлях до директорії з аватарами',
	'AVATAR_STORAGE_PATH_EXPLAIN'	=> 'Шлях відносно кореневої директорії phpBB, наприклад <samp>images/avatars/upload</samp>.',
	'MAX_AVATAR_SIZE'	=> 'Максимальні розміри аватару',
	'MAX_AVATAR_SIZE_EXPLAIN'	=> 'Ширина x Висота в пікселях.',
	'MAX_FILESIZE'	=> 'Максимальний розмір файлу аватара.',
	'MAX_FILESIZE_EXPLAIN'	=> ' Максимальний розмір кожного файлу. Якщо встановлено значення 0, максимальний розмір файлу, який може бути завантажено, обмежується лише вашою конфігурацією PHP.',
	'MIN_AVATAR_SIZE'	=> 'Мінімальний розмір аватара',
	'MIN_AVATAR_SIZE_EXPLAIN'	=> 'Ширина x Висота в пікселях.',
));

// Message Settings
$lang = array_merge($lang, array(
	'ACP_MESSAGE_SETTINGS_EXPLAIN'	=> 'Тут ви можете задати налаштування за замовчуванням для приватних повідомлень.',
	'ALLOW_BBCODE_PM'	=> 'Дозволити BBCode в приватних повідомленнях',
	'ALLOW_FLASH_PM'	=> 'Дозволити використання тега <code>[FLASH]</code>',
	'ALLOW_FLASH_PM_EXPLAIN'	=> 'Зауважте, що увімкнена тут можливість використання flash в приватних повідомленнях, також залежить від прав доступу.',
	'ALLOW_FORWARD_PM'	=> 'Дозволити пересилання приватних повідомлень',
	'ALLOW_IMG_PM'	=> 'Дозволити використання тега <code>[IMG]</code>',
	'ALLOW_MASS_PM'	=> 'Дозволити розсилання приватних повідомлень кільком користувачам та групам',
	'ALLOW_MASS_PM_EXPLAIN'      => 'Розсилання для кожної групи можна налаштувати на сторінці налаштувань груп.',
	'ALLOW_PRINT_PM'	=> 'Дозволити перегляд для друку в приватних повідомленнях',
	'ALLOW_QUOTE_PM'	=> 'Дозволити цитати в приватних повідомленнях',
	'ALLOW_SIG_PM'	=> 'Дозволити підписи в приватних повідомленнях',
	'ALLOW_SMILIES_PM'	=> 'Дозволити смайлики в приватних повідомленнях',
	'BOXES_LIMIT'	=> 'Максимальна кількість приватних повідомлень в скринці',
	'BOXES_LIMIT_EXPLAIN'	=> 'Користувачі не можуть отримувати більше повідомлень від вказаної кількості в кожній скриньці приватних повідомлень. Для необмеженої кількості встановіть значення 0.',
	'BOXES_MAX'	=> 'Максимальна кількість папок для приватних повідомлень',
	'BOXES_MAX_EXPLAIN'	=> 'За замовчуванням користувачі не зможуть створювати більшу кількість папок для приватних повідомлень.',
	'ENABLE_PM_ICONS'	=> 'Дозволити використання значків тем в приватних повідомленнях',
	'FULL_FOLDER_ACTION'	=> 'Дія за замовчуванням для заповненої папки',
	'FULL_FOLDER_ACTION_EXPLAIN'	=> 'Дія за замовчуванням, яка буде виконуватись для переповненої папки користувача у випадку, коли обрана дія не може бути застосована. Єдиним виключенням є папка “Відправлені”, для котрої дією за замовчуванням є видалення старих повідомлень.',
	'HOLD_NEW_MESSAGES'	=> 'Відкласти нові повідомлення',
	'PM_EDIT_TIME'	=> 'Обмеження часу редагування',
	'PM_EDIT_TIME_EXPLAIN'	=> 'Обмежує час, протягом якого доступне редагування відправленого, але ще недоставленого повідомлення. Якщо встановлене значення 0, то час не обмежується.',
  	'PM_MAX_RECIPIENTS'         => 'Максимально дозволена кількість отримувачів',
  	'PM_MAX_RECIPIENTS_EXPLAIN'   => 'Максимально дозволена кількість отримувачів для приватного повідомлення. Якщо введено 0, дозволяється необмежена кількість. Це налаштування можна змінювати для кожної групи на сторінці налаштування груп.',
));

// Post Settings
$lang = array_merge($lang, array(
	'ACP_POST_SETTINGS_EXPLAIN'	=> 'Тут ви можете встановити усі налаштування за замовчуванням для повідомлень.',
	'ALLOW_POST_LINKS'	=> 'Дозволити посилання в повідомленнях/приватних повідомленнях',
	'ALLOW_POST_LINKS_EXPLAIN'	=> 'Якщо заборонено, тег <code>[URL]</code> та автоматичні посилання не будуть працювати.',
	'ALLOW_POST_FLASH'	=> 'Дозволити використання тегу <code>[FLASH]</code> в повідомленнях.',
	'ALLOW_POST_FLASH_EXPLAIN'	=> 'Якщо заборонено, тег <code>[FLASH]</code> не буде працювати в повідомленнях. Крім, того система прав доступу визначає, які користувачі можуть використовувати тег <code>[FLASH]</code>.',
 	'BUMP_INTERVAL'	=> 'Затримка підняття теми',
	'BUMP_INTERVAL_EXPLAIN'	=> 'Кількість хвилин, годин або днів, яка повинна пройти з часу останнього повідомлення, щоб можна було піднімати цю тему. Значення 0 вимикає піднімання тем.',
	'CHAR_LIMIT'	=> 'Максимальна кількість символів в повідомленні',
	'CHAR_LIMIT_EXPLAIN'	=> 'Кількість символів, яка дозволена в одному повідомленні/приватному повідомленні. Встановіть 0 для необмеженої кількості символів.',
	'DELETE_TIME'		=> 'Обмеження часу на видалення',
	'DELETE_TIME_EXPLAIN'	=> 'Обмежує час, протягом якого доступне видалення нового повідомлення. Встановлення значення 0 вимикає цю можливість.',
   'DISPLAY_LAST_EDITED'	=> 'Відображати інформацію про час останнього редагування',
	'DISPLAY_LAST_EDITED_EXPLAIN'	=> 'Оберіть для відображення інформації про час останнього редагування в повідомленнях.',
	'EDIT_TIME'	=> 'Обмежити час редагування',
	'EDIT_TIME_EXPLAIN'	=> 'Обмежує час, протягом якого можна редагувати нове повідомлення. Встановлення значення 0 вимикає цю функцію.',
	'FLOOD_INTERVAL'	=> 'Затримка фладу',
	'FLOOD_INTERVAL_EXPLAIN'	=> 'Кількість секунд, яка повинна пройти, перш ніж користувача зможе написати наступне повідомлення. Щоб дозволити користувачам ігнорувати цю функцію, встановіть їм відповідні права доступу.',
	'HOT_THRESHOLD'	=> 'Кількість повідомлень в популярній темі',
	'HOT_THRESHOLD_EXPLAIN'	=> 'Кількість повідомлень, необхідна для того, щоб тема стала популярною. Встановіть 0 для вимкнення функції.',
	'MAX_POLL_OPTIONS'	=> 'Максимальна кількість варіантів відповіді в голосуваннях',
	'MAX_POST_FONT_SIZE'	=> 'Максимальний розмір шрифту в повідомленнях',
	'MAX_POST_FONT_SIZE_EXPLAIN'	=> 'Максимальний розмір шрифту, який дозволений в повідомленнях. Встановіть 0 для необмеженого розміру.',
	'MAX_POST_IMG_HEIGHT'	=> 'Максимальна висота зображення в повідомленнях',
	'MAX_POST_IMG_HEIGHT_EXPLAIN'	=> 'Максимальна висота зображення/flash в повідомленнях. Встановіть 0 для необмеженого розміру.',
	'MAX_POST_IMG_WIDTH'	=> 'Максимальна ширина зображення в повідомленнях',
	'MAX_POST_IMG_WIDTH_EXPLAIN'	=> 'Максимальна ширина зображення/flash в повідомленнях. Встановіть 0 для необмеженого розміру.',
	'MAX_POST_URLS'	=> 'Максимальна кількість посилань в повідомленні',
	'MAX_POST_URLS_EXPLAIN'	=> 'Максимальне число посилань URL в повідомленні. Встановіть 0 для необмеженої кількості.',
	'MIN_CHAR_LIMIT' => 'Мінімальна кількість символів у повідомленні',
	'MIN_CHAR_LIMIT_EXPLAIN' => 'Мінімальна кількість символів, яку повинен ввести користувач в повідомленні/приватному повідомленні. Мінімальне значення для цього налаштування - 1.',
	'POSTING'	=> 'Повідомлень',
	'POSTS_PER_PAGE'	=> 'Повідомлень на сторінку',
	'QUOTE_DEPTH_LIMIT'	=> 'Максимальна кількість цитат в повідомленні',
	'QUOTE_DEPTH_LIMIT_EXPLAIN'	=> 'Максимальна кількість цитат в повідомленні. Встановіть 0 для необмеженої кількості.',
	'SMILIES_LIMIT'	=> 'Максимальна кількість смайликів в повідомленні',
	'SMILIES_LIMIT_EXPLAIN'	=> 'Максимальне число смайликів в повідомленні. Встановіть 0 для необмеженої кількості.',
  	'SMILIES_PER_PAGE'	=> 'Смайликів на сторінку',
	'TOPICS_PER_PAGE'	=> 'Тем на сторінку',
));

// Signature Settings
$lang = array_merge($lang, array(
	'ACP_SIGNATURE_SETTINGS_EXPLAIN'	=> 'Тут ви можете встановити налаштування за замовчуванням для підписів.',
	'MAX_SIG_FONT_SIZE'	=> 'Максимальний розмір шрифту підпису',
	'MAX_SIG_FONT_SIZE_EXPLAIN'	=> 'Максимальний розмір шрифту, дозволений в підписах користувачів. Встановіть 0 для необмеженого розміру.',
	'MAX_SIG_IMG_HEIGHT'	=> 'Максимальна висота зображення підпису',
	'MAX_SIG_IMG_HEIGHT_EXPLAIN'	=> 'Максимальна висота зображення/flash в підписах користувачів. Встановіть 0 для необмеженої висоти.',
	'MAX_SIG_IMG_WIDTH'	=> 'Максимальна ширина зображення підпису',
	'MAX_SIG_IMG_WIDTH_EXPLAIN'	=> 'Максимальна ширина зображення/flash в підписах користувачів. Встановіть 0 для необмеженої ширини.',
	'MAX_SIG_LENGTH'	=> 'Максимальна довжина підпису',
	'MAX_SIG_LENGTH_EXPLAIN'	=> 'Максимальна кількість символів в підписах користувачів.',
	'MAX_SIG_SMILIES'	=> 'Максимальна кількість смайликів в підписі',
	'MAX_SIG_SMILIES_EXPLAIN'	=> 'Максимальна кількість смайликів, дозволена в підписах користувачів. Встановіть 0 для необмеженої кількості смайликів.',
	'MAX_SIG_URLS'	=> 'Максимальна кількість посилань в підписі',
	'MAX_SIG_URLS_EXPLAIN'	=> 'Максимальна кількість посилань в підписах користувачів. Встановіть 0 для необмеженої кількості посилань.',
));

// Registration Settings
$lang = array_merge($lang, array(
	'ACP_REGISTER_SETTINGS_EXPLAIN'	=> 'Тут ви можете встановлювати налаштування, пов\'язані з реєстрацію та профілями користувачів.',
	'ACC_ACTIVATION'	=> 'Активація облікового запису',
	'ACC_ACTIVATION_EXPLAIN'	=> 'Визначає, чи користувач відразу отримує доступ до форуму чи необхідне підтвердження реєстрації. Також ви можете взагалі вимкнути реєстрацію нових користувачів. Для використання активацій адміністратором або користувачем повинна бути увімкнена функція “Масова розсилка e-mail”.',
	'NEW_MEMBER_POST_LIMIT' => 'Ліміт повідомлень для нових користувачів', 
 	'NEW_MEMBER_POST_LIMIT_EXPLAIN' => 'Нові користувачі будуть знаходитися в групі «Нещодавно зареєстровані користувачі» допоки вони не розмістять даної кількості повідомлень. Ви можете використовувати цю групу, щоб запобігти використанню ними системи приватних повідомлень або для попереднього перегляду їх повідомлень. Значення 0 вимикає цю можливість.', 
 	'NEW_MEMBER_GROUP_DEFAULT' => 'Встановити групу «Нещодавно зареєстровані користувачі» як групу за замовчуванням', 
 	'NEW_MEMBER_GROUP_DEFAULT_EXPLAIN' => 'Якщо дану опцію увімкнено і встановлено ліміт повідомлень для нових користувачів, то нові користувачі будуть не лише включені до групи «Нещодавно зареєстровані користувачі», але й цю групу буде встановлено ним, як групу за замовчуванням. Це може знадобитись, якщо ви хочете призначити цій групі певне звання або аватар, які потім будуть успадковані користувачами.',
	'ACC_ADMIN'	=> 'Адміністратором',
	'ACC_DISABLE'	=> 'Вимкнено',
	'ACC_NONE'	=> 'Без активації (загальний доступ)',
	'ACC_USER'	=> 'Користувачем (перевірка e-mail)',
	'ALLOW_EMAIL_REUSE'	=> 'Дозволити повторне використання e-mail адреси',
	'ALLOW_EMAIL_REUSE_EXPLAIN'	=> 'Різні користувачі можуть реєструватись з однією адресою e-mail.',
	'COPPA'	=> 'COPPA',
	'COPPA_FAX'	=> 'Номер факсу COPPA',
	'COPPA_MAIL'	=> 'Поштова адреса COPPA',
	'COPPA_MAIL_EXPLAIN'	=> 'Це поштова адреса, на яку батьки будуть надсилати реєстраційні форми COPPA.',
	'ENABLE_COPPA'	=> 'Увімкнути COPPA',
	'ENABLE_COPPA_EXPLAIN'	=> 'Це змушує користувачів зазначати, чи вони досягли віку 13 років згідно вимог акту США COPPA. Якщо функція вимкнута, то спеціальні групи COPPA не будуть більше відображатись.',
	'MAX_CHARS'	=> 'Макс',
	'MIN_CHARS'	=> 'Мін',
	'NO_AUTH_PLUGIN'	=> 'Не знайдено необхідного модуля авторизації.',
	'PASSWORD_LENGTH'	=> 'Довжина паролю',
	'PASSWORD_LENGTH_EXPLAIN'	=> 'Мінімальна і максимальна кількість символів в паролях.',
	'REG_LIMIT'	=> 'Кількість спроб реєстрації',
	'REG_LIMIT_EXPLAIN'	=> 'Кількість спроб реєстрації, дозволена користувачу до заблокування сесії для запобігання спам-ботам.',
	'USERNAME_ALPHA_ONLY'	=> 'Лише букви та цифри',
	'USERNAME_ALPHA_SPACERS'	=> 'Букви, цифри та розділювачі',
	'USERNAME_ASCII'	=> 'ASCII (без міжнародного унікода)',
	'USERNAME_LETTER_NUM'	=> 'Будь-які літери та цифри',
	'USERNAME_LETTER_NUM_SPACERS'	=> 'Будь-які літери та цифри і розділювачі',
	'USERNAME_CHARS'	=> 'Обмеження символів в імені користувача',
	'USERNAME_CHARS_ANY'	=> 'Будь-які символи',
	'USERNAME_CHARS_EXPLAIN'	=> 'Символи, які можуть бути використані в іменах користувачів, розділювачами є: пробіл, -, +, _, [ і ].',
	'USERNAME_LENGTH'	=> 'Довжина імені користувача',
	'USERNAME_LENGTH_EXPLAIN'	=> 'Мінімальна та максимальна кількість символів в іменах користувачів.',
 ));
 // Feeds 
 $lang=array_merge($lang, array( 
 	'ACP_FEED_MANAGEMENT' => 'Загальні параметри каналів новин', 
 	'ACP_FEED_MANAGEMENT_EXPLAIN' => 'Цей модуль робить доступними різноманітні канали новин у форматі ATOM, обробляючи BBCode в повідомленнях, і роблячи його зручним для читання в зовнішніх каналах новин.', 
 
 	'ACP_FEED_ENABLE' => 'Увімкнути канали новин', 
 	'ACP_FEED_ENABLE_EXPLAIN' => 'Вмикає або вимикає канали новин для усього форуму. Вимкнення цієї опції вимикає усі канали новин, незалежно від встановлених нижче параметрів. ', 
 	'ACP_FEED_LIMIT' => 'Кількість елементів', 
 	'ACP_FEED_LIMIT_EXPLAIN' => 'Максимальна кількість елементів каналу новин для відображення.',

 	'ACP_FEED_OVERALL'	=> 'Увікнути загальний канал',
 	'ACP_FEED_OVERALL_EXPLAIN'	=> 'Нові повідомлення з усіх форумів.', 
 	'ACP_FEED_OVERALL_FORUMS' => 'Увімкнути канал форумів', 
 	'ACP_FEED_OVERALL_FORUMS_EXPLAIN'	=> 'Вмикає канал “Усі форуми”, в якому відображається список форумів.',
 	'ACP_FEED_OVERALL_FORUMS_LIMIT' => 'Кількість елементів на сторінку, яка буде відображатись в каналі форумів', 
 
 	'ACP_FEED_OVERALL_TOPIC' => 'Увімкнути загальний канал для тем', 
 	'ACP_FEED_OVERALL_TOPIC_EXPLAIN' => 'Вмикає канал «Усі теми».', 
 	'ACP_FEED_OVERALL_TOPIC_LIMIT' => 'Кількість елементів на сторінку, яка буде відображатись в каналі тем', 
 	'ACP_FEED_FORUM' => 'Дозволити канали форумів', 
 	'ACP_FEED_FORUM_EXPLAIN' => 'Нові повідомлення окремих форумів.', 
 	'ACP_FEED_TOPIC' => 'Дозволити канали тем', 
 	'ACP_FEED_TOPIC_EXPLAIN' => 'Нові повідомлення окремих тем.', 
 	'ACP_FEED_TOPICS_NEW'				=> 'Увімкнути канал нових тем',
 	'ACP_FEED_TOPICS_NEW_EXPLAIN'		=> 'Вмикає канал “Нові теми”, в якому відображаються останні створені теми, включаючи перше повідомлення.',
 	'ACP_FEED_TOPICS_ACTIVE'			=> 'Увімкнути канал активних тем',
 	'ACP_FEED_TOPICS_ACTIVE_EXPLAIN'	=> 'Вмикає канал “Активні теми”, в якому відображаються останні активні теми, включаючи останнє повідомлення.',
 	'ACP_FEED_NEWS' => 'Канал новин форуму', 
  	'ACP_FEED_NEWS_EXPLAIN' => 'Оберіть форуми, з яких у канал новин буде братися перше повідомлення. Не обирайте жодного форуму, щоб вимкнути канал новин.<br />Для вибору декількох форумів, утримуйте клавішу <samp>Ctrl</samp> і натискайте клавішу миші на потрібних форумах.', 
 
 	'ACP_FEED_GENERAL' => 'Загальні параметри каналів новин', 
  	'ACP_FEED_POST_BASED'	=> 'Налаштування каналів повідомлень',
 	'ACP_FEED_TOPIC_BASED'	=> 'Налаштування каналів тем',
 	'ACP_FEED_SETTINGS_OTHER' => 'Інші канали новин і налаштування',
  
 	'ACP_FEED_HTTP_AUTH'				=> 'Дозволити HTTP-аутентифікацію',
 	'ACP_FEED_HTTP_AUTH_EXPLAIN'		=> 'Вмикає HTTP-аутентифікацію, яка дозволяє користувачам отримувати інформацію, яка прихована від гостей, додаючи параметр <samp>auth=http</samp> до своєї URL-адреси каналу. Зауважте, що деякі інсталяції PHP вимагають додаткових змін до файлу .htaccess. Інструкції можна знайти в цьому файлі.',
 	'ACP_FEED_ITEM_STATISTICS' => 'Статистика елементів', 
 	'ACP_FEED_ITEM_STATISTICS_EXPLAIN' => 'Відображає індивідуальну статистику під елементами каналу (наприклад, автора повідомлення, дату та час публікації, кількість відповідей та переглядів).', 
 	'ACP_FEED_EXCLUDE_ID' => 'Виключити ці форуми', 
 	'ACP_FEED_EXCLUDE_ID_EXPLAIN' => 'Вміст наступних форумів не буде включено до каналів новин. Не обирайте форумів, якщо хочете отримувати дані з усіх форумів. Для скасування вибору/вибору декількох форумів, утримуйте клавішу <samp>Ctrl</samp> і натискайте клавішу миші на потрібних форумах.', 
 ));
 

// Visual Confirmation Settings
$lang = array_merge($lang, array( 
	'ACP_VC_SETTINGS_EXPLAIN'	=> 'Тут ви можете обрати та налаштувати модулі, які розроблено для блокування автоматичного заповнення форм спам-ботами. Принцип дії цих додатків зазвичай грунтується на введенні користувачем символів з зображення <em>CAPTCHA</em> - завдання, яке досить складне для виконання комп\'ютерам.',
	'AVAILABLE_CAPTCHAS' => 'Доступні модулі',
 	'CAPTCHA_UNAVAILABLE' => 'Даний модуль CAPTCHA не може бути використано, оскільки він не відповідає необхідним вимогам.',
	'CAPTCHA_GD'	=> 'GD-зображення',
  	'CAPTCHA_GD_3D'	=> 'Тривимірне GD-зображення',
	'CAPTCHA_GD_FOREGROUND_NOISE'	=> 'Шум на передньому плані зображення',
	'CAPTCHA_GD_EXPLAIN'	=> 'Більш складне для розпізнавання спам-ботами.',
	'CAPTCHA_GD_FOREGROUND_NOISE_EXPLAIN'	=> 'Використовуйте шум на передньому плані, щоб зображення було важче розпізнати.',
	'CAPTCHA_GD_X_GRID'	=> 'Фоновий шум GD CAPTCHA по осі X',
	'CAPTCHA_GD_X_GRID_EXPLAIN'	=> 'Використовуйте менші значення, щоб зробити складнішим CAPTCHA на базі GD. Значення 0 вимкне фоновий шум по осі X.',
	'CAPTCHA_GD_Y_GRID'	=> 'Фоновий шум GD CAPTCHA по осі Y',
	'CAPTCHA_GD_Y_GRID_EXPLAIN'	=> 'Використовуйте менші значення, щоб зробити складнішим CAPTCHA  на базі GD. Значення 0 вимкне фоновий шум по осі X.',
	'CAPTCHA_GD_WAVE'                  => 'Спотвореннями у вигляді хвиль',
 	'CAPTCHA_GD_WAVE_EXPLAIN'            => 'Додає до зображення спотвореннями у вигляді хвиль.',
	'CAPTCHA_GD_3D_NOISE'               => 'Додає тривимірні об\'єкти для створення шуму',
	'CAPTCHA_GD_3D_NOISE_EXPLAIN'         => 'Додає додаткові об\'єкти до зображення поверх літер.',
	'CAPTCHA_GD_FONTS'                  => 'Використовувати різні шрифти',
	'CAPTCHA_GD_FONTS_EXPLAIN'            => 'Цей параметр визначає, яку кількість форм буде використано. Ви можете використовувати форми за замовчуванням або додавати змінені літери. Також можливе використання літер нижнього регістру.',
	'CAPTCHA_FONT_DEFAULT'               => 'За замовчуванням',
	'CAPTCHA_FONT_NEW'                  => 'Нові форми',
	'CAPTCHA_FONT_LOWER'               => 'Додатково використовувати нижній регістр',
 	'CAPTCHA_NO_GD'			=> 'Звичайне зображення',
	'CAPTCHA_PREVIEW_MSG'	=> ' Це лише попередній перегляд, зміни, які ви внесли в налаштування не збережено.',
	'CAPTCHA_PREVIEW_EXPLAIN'	=> 'Зображення матиме такий вигляд з поточними налаштуваннями модулю.',
	
 	'CAPTCHA_SELECT' => 'Встановлені модулі', 
 	'CAPTCHA_SELECT_EXPLAIN' => 'У цьому випадаючому списку містяться модулі CAPTCHA, розпізнані вашим форумом. Модулі, які позначено сірим кольором, недоступні відразу для використання і скоріш за все потребують попереднього налаштування перед використанням.', 
 	'CAPTCHA_CONFIGURE' => 'Налаштування модулів', 
 	'CAPTCHA_CONFIGURE_EXPLAIN' => 'Зміна налаштувань для обраного модуля.', 
 	'CONFIGURE' => 'Налаштування', 
 	'CAPTCHA_NO_OPTIONS' => 'Цей модуль не має параметрів для налаштування.',

	'VISUAL_CONFIRM_POST'	=> 'Увімкнути заходи для боротьби зі спам-ботами для повідомлень, які розміщуються гостями',
	'VISUAL_CONFIRM_POST_EXPLAIN'	=> 'Вимагає від гостей проходження завдання для запобігання розміщенню автоматичних повідомлень спам-ботами.',
	'VISUAL_CONFIRM_REG'	=> 'Увімкнути заходи для боротьби зі спам-ботами під час реєстрації',
	'VISUAL_CONFIRM_REG_EXPLAIN'	=> 'Вимагає від гостей проходження завдання для запобігання автоматичним реєстраціям.',
	'VISUAL_CONFIRM_REFRESH'            => 'Дозволити користувачам оновлювати завдання',
	'VISUAL_CONFIRM_REFRESH_EXPLAIN'      => 'Дозволяє користувачам надсилати запит на отримання нових завдань, якщо вони не можуть пройти їх під час реєстрації. Деякі модулі можуть не підтримувати дану функцію.',
));


// Cookie Settings
$lang = array_merge($lang, array(
	'ACP_COOKIE_SETTINGS_EXPLAIN'	=> 'Ці налаштування визначають, яка інформація використовується для надсилання cookies до браузерів користувачів. В більшості випадків налаштувань за замовчуванням цілкои достатньо. Якщо вам потрібно щось змінити, робіть це уважно, невірні налаштування можуть призвезти до неможливості залогування користувачів.',
	'COOKIE_DOMAIN'	=> 'Домен cookie',
	'COOKIE_NAME'	=> 'Назва cookie',
	'COOKIE_PATH'	=> 'Шлях cookie',
	'COOKIE_SECURE'	=> 'Безпека cookie',
	'COOKIE_SECURE_EXPLAIN'	=> 'Якщо ваш сервер працює через SSL-з\'єднання увімкніть цю функцію, в іншому випадку залиште вимкнутою. Якщо дана опція буде увімкнутою, і ваш сервер не працює через SSL, будуть виникати помилки сервера під час переадресувань.',
	'ONLINE_LENGTH'	=> 'Проміжок часу онлайн статистики',
	'ONLINE_LENGTH_EXPLAIN'	=> 'Кількість хвилин, по спливанню яких неактивні користувачі не будуть відображатись в списку “Хто зараз онлайн”. Чим більше це значення, тим більше ресурсів сервера потрібно для створення списку.',
	'SESSION_LENGTH'	=> 'Тривалість сесії',
	'SESSION_LENGTH_EXPLAIN'	=> 'Сесія буде завершеною після того як сплине цей час,в секундах.',
));

// Load Settings
$lang = array_merge($lang, array(
	'ACP_LOAD_SETTINGS_EXPLAIN'	=> 'Тут ви можете вмикати/вимикати окремі функції форуму, щоб зменшити навантаження на сервер. На більшості серверів немає потреби вимикати жодних функцій. Проте, на деяких системах або на безкоштовних хостингах можливо краще вимкнути можливості, які вам насправді непотрібні. Також ви можете задати обмеження для навантаження на систему і активних сесій, після перевищення яких форум буде вимикатись.',
	'CUSTOM_PROFILE_FIELDS'	=> 'Додаткові поля профілю',
	'LIMIT_LOAD'	=> 'Обмежити навантаження на сервер',
	'LIMIT_LOAD_EXPLAIN'	=> 'Якщо середнє навантаження системи протягом 1 хвилини перевищить це значення, форум автоматично перейде в статус офлайн. Значення 1.0 еквівалентне ~100% завантаженню одного процесора. Ця функція працює лише на серверах з UNIX  і на серверах, де ця інформація є доступною. Якщо phpBB не зможе отримати інформацію про завантаження процесора, значення автоматично скинеться на 0.',
	'LIMIT_SESSIONS'	=> 'Обмежити сесії',
	'LIMIT_SESSIONS_EXPLAIN'	=> 'Якщо кількість сесій перевищить це значення протягом однієї хвилини форум автоматично перейде в статус офлайн. Встановіть 0 для необмеженої кількості сесій.',
	'LOAD_CPF_MEMBERLIST'	=> 'Дозволити відображення додаткових полів профілів в списку учасників',
	'LOAD_CPF_VIEWPROFILE'	=> 'Відображати додаткові поля в профілях користувачів',
	'LOAD_CPF_VIEWTOPIC'	=> 'Відображати додаткові поля профілю на сторінках тем',
	'LOAD_USER_ACTIVITY'	=> 'Показати активність користувача',
	'LOAD_USER_ACTIVITY_EXPLAIN'	=> 'Відображає активні теми/форуми в профілях користувачів і панелі керування. Рекомендується вимкнути цю функцію на форумах з більше ніж мільйоном повідомлень.',
	'RECOMPILE_STYLES'	=> 'Перекомпілювати старі компоненти стилю',
	'RECOMPILE_STYLES_EXPLAIN'	=> 'Перевіряє чи не оновились компоненти стилю на сервері форуму і проводить перекомпіляцію.',
	'YES_ANON_READ_MARKING'	=> 'Дозволити гостям маркування тем',
	'YES_ANON_READ_MARKING_EXPLAIN'	=> 'Зберігає інформацію про статус прочитаних/непрочитаних повідомлень для гостей. Якщо дану опцію вимкнено, повідомлення завжди помічаються як прочитані для гостей.',
	'YES_BIRTHDAYS'	=> 'Дозволити відображення днів народжень',
	'YES_BIRTHDAYS_EXPLAIN'	=> 'Якщо вимкнено, список днів народжень не буде відображатись. Для того щоб це налаштування працювало, також повинна бути увімкнена опція днів народжень.',
	'YES_JUMPBOX'	=> 'Дозволити відображення швидкого переходу',
	'YES_MODERATORS'	=> 'Дозволити відображення модераторів',
	'YES_ONLINE'	=> 'Дозволити відображення списку онлайн користувачів',
	'YES_ONLINE_EXPLAIN'	=> 'Відображає інформацію про користувачів, які перебувають на форумі на головній сторінці, на сторінках форумів та тем.',
	'YES_ONLINE_GUESTS'	=> 'Дозволити відображення списку гостей в списку онлайн користувачів',
	'YES_ONLINE_GUESTS_EXPLAIN'	=> 'Дозволити  відображення інформації про гостей в списку онлайн користувачів.',
	'YES_ONLINE_TRACK'	=> 'Дозволити відображення інформації “онлайн/офлайн” користувачів',
	'YES_ONLINE_TRACK_EXPLAIN'	=> 'Відображає інформацію про онлайн-статус користувача в профілях і на сторінках тем.',
	'YES_POST_MARKING'	=> 'Дозволити відмічені теми',
	'YES_POST_MARKING_EXPLAIN'	=> 'Відображає, де користувач створив тему.',
	'YES_READ_MARKING'	=> 'Дозволити маркування тем на сервері',
	'YES_READ_MARKING_EXPLAIN'	=> 'Зберігає інформацію про статус прочитаних/непрочитаних повідомлень в базі даних, а не в файлах cookie.',
	'YES_UNREAD_SEARCH'            => 'Увімкнути пошук для непрочитаних повідомлень',
));

// Auth settings
$lang = array_merge($lang, array(
	'ACP_AUTH_SETTINGS_EXPLAIN'	=> 'phpBB підтримує модулі авторизації. Вони дозволяють вам встановити спосіб авторизації користувачів при логуванні на форумі. За замовчуванням доступні три модулі: DB, LDAP та Apache. Не усі методи потребують додаткової інформації, тому заповнюйте лише ті поля, які необхідні для обраного методу.',
	'AUTH_METHOD'	=> 'Оберіть метод авторизації',
	'APACHE_SETUP_BEFORE_USE'	=> 'Ви повинні налаштувати авторизацію apache перед тим, як ви перемикнете phpBB на цей метод авторизації. Пам\'ятайте, що ім\'я користувача, яке ви використовуєте для авторизації apache, повинне співпадати з ім\'ям користувача в phpBB. Авторизація apache може використовуватись з mod_php (не з CGI-версією) і вимкнутим safe_mode.',
	'LDAP_DN'	=> 'Основне ім\'я LDAP <var>dn</var>',
	'LDAP_DN_EXPLAIN'	=> 'Це повинне бути унікальне ім\'я (Distinguished Name), яке визначає інформацію про користувача, наприклад <samp>o=My Company,c=US</samp>.',
	'LDAP_EMAIL'	=> 'Атрибут e-mail LDAP',
	'LDAP_EMAIL_EXPLAIN'	=> 'Задайте ім\'я атрибуту e-mail користувача (якщо він існує) для автоматичного встановлення адрес e-mail address для нових користувачів. Якщо це поле залишити порожнім, адреси e-mail користувачів, які вперше залогувались, теж будуть порожніми.',
	'LDAP_INCORRECT_USER_PASSWORD'	=> 'З\'єднання з сервером LDAP не вдалось з заданими іменем користувача/паролем.',
	'LDAP_NO_EMAIL'	=> 'Заданий атрибут e-mail не існує.',
	'LDAP_NO_IDENTITY'	=> 'Не вдається знайти ідентифікатор входу в систему для %s.',
	'LDAP_PASSWORD'	=> 'Пароль LDAP',
	'LDAP_PASSWORD_EXPLAIN'	=> 'Залиште порожнім для використання анонімного доступу, в протилежному випадку введіть пароль вказаного вище користувача. Обо\'язково для серверів з Active Directory.<br /><em><strong>ЗАСТЕРЕЖЕННЯ:</strong> Цей пароль буде зберігатись в базі даних у звичайному текстовому вигляді та буде видимий усім, хто має доступ до вашої бази даних або до цієї сторінки.</em>',
	'LDAP_PORT'	=> 'Порт сервера LDAP',
	'LDAP_PORT_EXPLAIN'	=> 'Ви можете задати порт, який буде використовуватись для з\'єднання з сервером LDAP замість стандартного порту 389.',
	'LDAP_USER_FILTER'	=> 'Фільтр користувачів LDAP',
	'LDAP_USER_FILTER_EXPLAIN'	=> 'Ви можете обмежувати кількість об\'єктів пошуку за допомогою додаткових фільтрів. Наприклад <samp>objectClass=posixGroup</samp> дасть результат використання <samp>(&amp;(uid=$username)(objectClass=posixGroup))</samp>',
	'LDAP_SERVER'	=> 'Сервер LDAP',
	'LDAP_SERVER_EXPLAIN'	=> 'Якщо використовується LDAP, вкажіть ім\'я хосту або IP-адресу сервера.',
	'LDAP_UID'	=> 'LDAP <var>uid</var>',
	'LDAP_UID_EXPLAIN'	=> 'Це ключ, за допомогою якого здійснюється пошук заданого ідентифікатора, наприклад <var>uid</var>, <var>sn</var> та ін.',
	'LDAP_USER'	=> 'Користувач LDAP',
	'LDAP_USER_EXPLAIN'	=> 'Залиште порожнім для використання анонімного доступу. Якщо заповнено, phpBB буде з\'єднуватись з сервером LDAP під заданим іменем користувача.',

));

// Server Settings
$lang = array_merge($lang, array(
	'ACP_SERVER_SETTINGS_EXPLAIN'	=> 'Тут ви можете встановити налаштування серверу і домену. Будь-ласка, переконайтесь, що дані, які ви вводите вірні, помилки призведуть до розсилання листів e-mails з невірною інформацією. При введенні доменного імені, пам\'ятайте, що воно повинне включати http:// або інший префікс протоколу. Номер порту змінюйте лише у випадку, якщо ви впевнені, що ваш сервер використовує інше значення, найчастіше це порт 80.',
	'ENABLE_GZIP'	=> 'Дозволити стиснення GZip',
	'ENABLE_GZIP_EXPLAIN'	=> 'Згенерований вміст буде стиснено перед відправкою користувачу. Це може знизити мережевий трафік, але збільшити навантаження на процесор, як і на стороні сервера, так і клієнта. Потребує завантаження розширення PHP zlib.',
	'FORCE_SERVER_VARS'	=> 'Примусові налаштування адреси URL сервера',
	'FORCE_SERVER_VARS_EXPLAIN'	=> 'Якщо обрано "так", будуть використовуватись налаштування серверу вказані тут замість автоматично визначених.',
	'ICONS_PATH'	=> 'Шлях до іконок повідомлень',
	'ICONS_PATH_EXPLAIN'	=> 'Шлях відносно кореневої директорії phpBB, наприклад <samp>images/icons</samp>.',
	'PATH_SETTINGS'	=> 'Шлях',
	'RANKS_PATH'	=> 'Шлях до зображень звання',
	'RANKS_PATH_EXPLAIN'	=> 'Шлях відносно кореневої директорії phpBB, наприклад <samp>images/ranks</samp>.',
	'SCRIPT_PATH'	=> 'Шлях до форуму',
	'SCRIPT_PATH_EXPLAIN'	=> 'Шлях до phpBB відносно імені домену, наприклад <samp>/phpBB3</samp>.',
	'SERVER_NAME'	=> 'Ім\'я домену',
	'SERVER_NAME_EXPLAIN'	=> 'Ім\'я домену, на якому працює цей форум (наприклад: <samp>www.example.com</samp>).',
	'SERVER_PORT'	=> 'Порт',
	'SERVER_PORT_EXPLAIN'	=> 'Порт, на якому працює ваш вебсервер, зазвичай 80, змінюйте лише у випадку, якщо він інший.',
	'SERVER_PROTOCOL'	=> 'Протокол',
	'SERVER_PROTOCOL_EXPLAIN'	=> 'Використовується в якості протоколу серверу, якщо встановлені примусові налаштування. Якщо не вказано або не встановлені примусові налаштування, протокол буде визначатись за налаштуваннями безпечних cookie (<samp>http://</samp> or <samp>https://</samp>).',
	'SERVER_URL_SETTINGS'	=> 'Налаштування URL сервера',
	'SMILIES_PATH'	=> 'Шлях зберігання смайликів',
	'SMILIES_PATH_EXPLAIN'	=> 'Шлях відносно кореневої директорії phpBB, наприклад <samp>images/smilies</samp>.',
	'UPLOAD_ICONS_PATH'	=> 'Шлях до значків груп розширень',
	'UPLOAD_ICONS_PATH_EXPLAIN'	=> 'Шлях відносно кореневої директорії phpBB, наприклад <samp>images/upload_icons</samp>.',
));

// Security Settings
$lang = array_merge($lang, array(
	'ACP_SECURITY_SETTINGS_EXPLAIN'	=> 'Тут ви можете встановити налаштування сесії та логування.',
	'ALL'	=> 'Повна',
	'ALLOW_AUTOLOGIN'	=> 'Дозволити автоматичне логування',
	'ALLOW_AUTOLOGIN_EXPLAIN'	=> 'Визначає, чи можуть користувачі автоматично логуватись при відвідуванні форуму.',
	'AUTOLOGIN_LENGTH'	=> 'Термін дії ключа автоматичного логування (в днях)',
	'AUTOLOGIN_LENGTH_EXPLAIN'	=> 'Кількість днів, по проходженню яких, ключі логування буде видалено. Встановіть 0 для вимкнення даної функції.',
	'BROWSER_VALID'	=> 'Перевірка браузера',
	'BROWSER_VALID_EXPLAIN'	=> 'Вмикає перевірку браузера для кожної сесії для підвищення безпеки.',
	'CHECK_DNSBL'	=> 'Перевірити IP-адресу по чорному списку DNS Blackhole List',
	'CHECK_DNSBL_EXPLAIN'	=> 'Якщо дана функція увімкнена, IP-адреса користувача буде перевірятись за допомогою наступних служб DNSBL при реєстрації та при розміщенні повідомлень: <a href="http://spamcop.net">spamcop.net</a> та <a href="http://www.spamhaus.org">www.spamhaus.org</a>. Ця процедура може зайняти якийсь певний час, залежно від конфігурації сервера. Якщо, це призводить до сповільнення роботи, або спостерігається велика кількість помилкових спрацювань, рекомендується вимкнути цю функцію.',
	'CLASS_B'	=> 'A.B',
	'CLASS_C'	=> 'A.B.C',
	'EMAIL_CHECK_MX'	=> 'Перевірити правильність поштового запису MX для домену',
	'EMAIL_CHECK_MX_EXPLAIN'	=> 'Якщо увімкнено, домен адреси e-mail, вказаний при реєстрації і при зміні у профілі, буде перевірятись на правильність поштового запису MX.',
	'FORCE_PASS_CHANGE'	=> 'Ініціювати зміну паролю',
	'FORCE_PASS_CHANGE_EXPLAIN'	=> 'Вимагає від користувача зміну паролю через встановлену кількість днів. Встановлення значення 0 вимикає дану функцію.',
	'FORM_TIME_MAX'					=> 'Максимальний час для відправки форм',
	'FORM_TIME_MAX_EXPLAIN'			=> 'Час, протягом якого користувач повинен відправити форму. Встановіть -1 для вимкнення. Зауважте, що форма може застаріти, якщо час сесії сплине, незалежно від цього налаштування.',
	'FORM_SID_GUESTS'				=> 'Прив\'язати форми до гостьових сесій',
	'FORM_SID_GUESTS_EXPLAIN'		=> 'Якщо увімкнено, форми, які відправляються гостями, будуть прив\'язані до конкретних сесій. Це може призвести до проблем з деякими інтернет-провайдерами.',
	'FORWARDED_FOR_VALID'	=> 'Перевірка заголовку <var>X_FORWARDED_FOR</var>',
	'FORWARDED_FOR_VALID_EXPLAIN'	=> 'Сесія буде продовжена, лише у тому випадку, якщо відправлений заголовок <var>X_FORWARDED_FOR</var> відповідає надісланому в попередньому запиті. Також буде перевірятись заборона доступу по IP з заголовку <var>X_FORWARDED_FOR</var>.',
	'IP_VALID'	=> 'Перевірка IP сесії',
	'IP_VALID_EXPLAIN'	=> 'Визаначає, як перевіряється IP-адреса користувача при перевірці сесії, <samp>Повністю</samp> перевіряє усю адресу, <samp>A.B.C</samp> - перші три числа x.x.x, <samp>A.B</samp> - перші два числа x.x, <samp>Ні</samp> вимикає перевірку. В адресах IPv6 <samp>A.B.C</samp> перевіряє перші 4 блоки, <samp>A.B</samp> - перші 3 блоки.',
  'IP_LOGIN_LIMIT_MAX'			=> 'Максимальна кількість спроб логування з однієї IP-адреси',
	'IP_LOGIN_LIMIT_MAX_EXPLAIN'	=> 'Поріг дозволеної кількості спроб логування з однієї IP-адреси до увімкнення завдання для захисту від спам-ботів. Введіть 0 для вимкнення цієї функції.',
	'IP_LOGIN_LIMIT_TIME'			=> 'Термін дії для спроб логування з однієї IP-адреси',
	'IP_LOGIN_LIMIT_TIME_EXPLAIN'	=> 'Спроби логування буде дозволено після спливання цього часу, в секундах.',
	'IP_LOGIN_LIMIT_USE_FORWARDED'	=> 'Обмежити кількість спроб логування по заголовку <var>X_FORWARDED_FOR</var>',
	'IP_LOGIN_LIMIT_USE_FORWARDED_EXPLAIN'	=> 'Замість обмеження спроб логування з однієї IP-адреси, діятиме обмеження по значенням <var>X_FORWARDED_FOR</var>. <br /><em><strong>Застереження:</strong> Вмикайте цю функцію лише у випадку, якщо ваш проксі-сервер встановлює достовірні значення заголовку <var>X_FORWARDED_FOR</var>.</em>',
  'MAX_LOGIN_ATTEMPTS'	=> 'Максимальна кількість спроб логування',
	'MAX_LOGIN_ATTEMPTS_EXPLAIN'	=> 'Після цієї кількості спроб невдалого логування, користувачу необхідно буде додатково пройти завдання для запобігання спам-ботам.',
	'NO_IP_VALIDATION'	=> 'Відсутня',
	'NO_REF_VALIDATION'				=> 'Відсутня',
	'PASSWORD_TYPE'	=> 'Складність паролю',
	'PASSWORD_TYPE_EXPLAIN'	=> 'Визначає, наскільки складним повинен бути пароль при його встановленні та зміні, кожен наступний варіант включає в себе попередні.',
	'PASS_TYPE_ALPHA'	=> 'Повинен містити букви та цифри',
	'PASS_TYPE_ANY'	=> 'Немає вимог',
	'PASS_TYPE_CASE'	=> 'Повинен містити великі і маленькі букви',
	'PASS_TYPE_SYMBOL'	=> 'Повинен містити символи',
	'REF_HOST'						=> 'Перевіряти лише хост',
	'REF_PATH'						=> 'Перевіряти також шлях',
	'REFERER_VALID'					=> 'Перевіряти реферер',
	'REFERER_VALID_EXPLAIN'			=> 'Якщо увімкнуто, реферер запитів POST буде перевірятись на параметри шляху хосту/шляху до скрипта. Це може призвести до проблем з форумами, які використовують декілька доменів або зовнішні логування.',
	'TPL_ALLOW_PHP'	=> 'Дозволити php в шаблонах',
	'TPL_ALLOW_PHP_EXPLAIN'	=> 'Якщо ця опція увімкнута, функції <code>PHP</code> і <code>INCLUDEPHP</code> будуть розпізнаватись і виконуватись в шаблонах.',
));

// Email Settings
$lang = array_merge($lang, array(
	'ACP_EMAIL_SETTINGS_EXPLAIN'	=> 'Ця інформацію буде використано при надсиланні повідомлень користувачам форуму. Будь-ласка, переконайтесь, що вказана вами адреса e-mail вірна, усі повернені або недоставлені повідомлення буде, скоріш за все, надіслано на цю адресу. Якщо ваш сервер не забезпечує використання вмонтованої в PHP функції e-mail, ви можете надсилати повідомлення безпосередньо за допомогою SMTP. Для цього потрібна адреса відповідного сервера (при необхідності проконсультуйтесь в свого провайдера). Якщо сервер вимагає автентифікації (і лише у цьому випадку), введіть необхідні ім\'я та пароль. Зауважте, що запропоновано лише загальний метод автентифікації, інші методи на даний час не підтримуються.',
	'ADMIN_EMAIL'	=> 'Зворотня адреса e-mail',
	'ADMIN_EMAIL_EXPLAIN'	=> 'Використовується як зворотня адреса на усі електронні листи, які повертаються, та як контактна адреса e-mail для зв\'язку з технічних питань. Вона завжди буде використана в якості адрес <samp>Return-Path</samp> та <samp>Sender</samp> в електронних листах.',
	'BOARD_EMAIL_FORM'	=> 'Надсилання користувачами листів e-mail через форум',
	'BOARD_EMAIL_FORM_EXPLAIN'	=> 'Замість звичайної відправки листів e-mail, користувачі можуть надсилати листи через форум.',
	'BOARD_HIDE_EMAILS'	=> 'Приховати адреси e-mail',
	'BOARD_HIDE_EMAILS_EXPLAIN'	=> 'Ця функція повністю тримає адреси e-mail прихованими.',
	'CONTACT_EMAIL'	=> 'Контактна адреса e-mail',
	'CONTACT_EMAIL_EXPLAIN'	=> 'Ця адреса буде використовуватись при особливій необхідності зв\'язку, наприклад, повідомлень про спам, помилки та ін. Вона завжди буде використана в якості адрес <samp>From</samp> та <samp>Reply-To</samp> в електронних листах.',
	'EMAIL_FUNCTION_NAME'	=> 'Функція e-mail',
	'EMAIL_FUNCTION_NAME_EXPLAIN'	=> 'Функція e-mail, яка використовується для надсилання листів через PHP.',
	'EMAIL_PACKAGE_SIZE'	=> 'Розмір пакету E-mail',
	'EMAIL_PACKAGE_SIZE_EXPLAIN'	=> 'Кількість електронних листів, які надсилаються в одному пакеті.',
	'EMAIL_SIG'	=> 'Підпис E-mail',
	'EMAIL_SIG_EXPLAIN'	=> 'Цей текст буде додано до усіх листів e-mail, які надсилаються форумом.',
	'ENABLE_EMAIL'	=> 'Увімкнути функцію електронної пошти на форумі',
	'ENABLE_EMAIL_EXPLAIN'	=> 'Якщо цю опцію вимкнено, надсилання листів e-mail на форумі взагалі не буде відбуватись.<em>Зауважте, що налаштування активації облікових записів користувачами та адміністраторами вимагає, щоб ця функція була увімкненою. Якщо в даний момент використовується активація користувачами або адміністраторами в налаштуваннях активації, вимкнення даної опції призведе до вимкнення активації нових облікових записів.</em>',

	'SMTP_AUTH_METHOD'	=> 'Метод авторизації для SMTP',
	'SMTP_AUTH_METHOD_EXPLAIN'	=> 'Використовуйте, лише якщо задані ім\'я користувача та пароль. Проконсультуйтесь в свого провайдера, якщо ви не впевнені, який метод використовувати.',
	'SMTP_CRAM_MD5'	=> 'CRAM-MD5',
	'SMTP_DIGEST_MD5'	=> 'DIGEST-MD5',
	'SMTP_LOGIN'	=> 'LOGIN',
	'SMTP_PASSWORD'	=> 'Пароль SMTP',
	'SMTP_PASSWORD_EXPLAIN'	=> 'Вводьте пароль, лише якщо ваш SMTP-сервер його вимагає. <em><strong>Застереження:</strong> цей пароль зберігається в базі даних у відкритому вигляді.</em>',
	'SMTP_PLAIN'	=> 'PLAIN',
	'SMTP_POP_BEFORE_SMTP'	=> 'POP-BEFORE-SMTP',
	'SMTP_PORT'	=> 'Порт сервера SMTP',
	'SMTP_PORT_EXPLAIN'	=> 'Змінюйте лише, якщо ви впевнені, що ваш SMTP-сервер використовує інший порт.',
	'SMTP_SERVER'	=> 'Адреса сервера SMTP',
	'SMTP_SETTINGS'	=> 'Налаштування SMTP',
	'SMTP_USERNAME'	=> 'Ім\'я користувача SMTP',
	'SMTP_USERNAME_EXPLAIN'	=> 'Вводьте ім\'я користувача, лише якщо ваш SMTP-сервер його вимагає.',
	'USE_SMTP'	=> 'Використовувати SMTP-сервер для електронної пошти',
	'USE_SMTP_EXPLAIN'	=> 'Оберіть “Так”, якщо ви хочете відправляти листи e-mail через сервер замість локальної функції пошти.',
));

// Jabber settings
$lang = array_merge($lang, array(
	'ACP_JABBER_SETTINGS_EXPLAIN'	=> 'Тут ви можете увімкнути і керувати використанням Jabber для миттєвих повідомлень і повідомлень форуму. Jabber - протокол з відкритим кодом і тому він доступний для використання усім. Деякі сервери Jabber включають в себе шлюзи та протоколи передавання даних, які дозволяють з\'єднуватись з користувачами інших мереж. Не усі сервери надають усі протоколи передавання і можуть впливати на їх нормальне функціонування. Переконайтесь, будь-ласка, що ви ввели дані зареєстрованого облікового запису - phpBB буде використовувати їх у своїй роботі.',
	'JAB_ENABLE'	=> 'Увімкнути Jabber',
	'JAB_ENABLE_EXPLAIN'	=> 'Дозволяє використання обмін повідомленнями Jabber.',
	'JAB_GTALK_NOTE'	=> 'Майте на увазі, GTalk не буде працювати, оскільки функцію <samp>dns_get_record</samp> не знайдено. Ця функція недоступна в PHP4, і не працює на Windows-платформах. На даний момент вона не працює також на системах на базі BSD, включаючи Mac OS.',
	'JAB_PACKAGE_SIZE'	=> 'Розмір пакету Jabber',
	'JAB_PACKAGE_SIZE_EXPLAIN'	=> 'Це кількість повідомлень, які відсилаються в одному пакеті. Якщо встановлено 0 повідомлення відправляється миттєво і не буде поставлено в чергу для пізнішого надсилання.',
	'JAB_PASSWORD'	=> 'Пароль Jabber',
 	'JAB_PASSWORD_EXPLAIN'		=> '<em><strong>Застереження:</strong> цей пароль зберігається в базі даних у відкритому вигляді.</em>',
	'JAB_PORT'	=> 'Порт Jabber',
	'JAB_PORT_EXPLAIN'	=> 'Залиште порожнім, за винятком, якщо ви знаєте що це не порт 5222.',
	'JAB_SERVER'	=> 'Сервер Jabber',
	'JAB_SERVER_EXPLAIN'	=> 'Перегляньте список серверів на %sjabber.org%s.',
	'JAB_SETTINGS_CHANGED'	=> 'Налаштування Jabber успішно змінені.',
	'JAB_USE_SSL'	=> 'Використовувати SSL для з\'єднання',
	'JAB_USE_SSL_EXPLAIN'	=> 'Якщо дана функція увімкнута, буде здійснено спробу безпечного з\'єднання. Порт Jabber буде автоматично змінено на 5223, якщо було вказано порт 5222.',
	'JAB_USERNAME'	=> 'Ім\'я користувача Jabber або JID',
	'JAB_USERNAME_EXPLAIN'	=> 'Вкажіть зареєстроване ім\'я користувача або правильний JID. Ім\'я користувача буде перевірено на коректність. Якшо ви вказали лише ім\'я користувача, то ваш JID буде іменем користувача та сервера, вказаними нижче. Або, вкажіть правильний JID, наприклад  user@jabber.org.',
));

?>