<?php
/**
* This file is part of French (Casual Honorifics) phpBB Translation.
* Copyright (C) 2010 phpBB.fr
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* acp_database [French (Casual Honorifics)]
*
* @package   language
* @author    Maël Soucaze <maelsoucaze@phpbb.fr> (Maël Soucaze) http://www.phpbb.fr/
* @copyright 2005 phpBB Group
* @license   http://www.gnu.org/licenses/gpl-2.0.txt GNU General Public License
* @version   $Id: database.php 9765 2009-07-17 10:11:10Z bantu $
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Database Backup/Restore
$lang = array_merge($lang, array(
	'ACP_BACKUP_EXPLAIN'	=> 'Tu peux sauvegarder ici toutes les données relatives à ton forum phpBB. Tu peux stocker l’archive de sauvegarde dans ton répertoire <samp>store/</samp> ou la télécharger directement. Selon la configuration de ton serveur, tu peux compresser cette archive dans un certain nombre de formats.',
	'ACP_RESTORE_EXPLAIN'	=> 'Cela exécutera une restauration complète de toutes les tables de phpBB à partir d’un fichier de sauvegarde. Si ton serveur le supporte, tu peux utiliser un fichier texte compressé en GZip ou BZip2 qui sera automatiquement décompressé. <strong>ATTENTION :</strong> cela écrasera toutes les données existantes. La restauration est un processus qui peut prendre un certain temps, ne te déplace pas de la page tant que l’opération n’est pas terminée. Les sauvegardes sont stockées dans le répertoire <samp>store/</samp> et sont supposées être réalisées par l’outil de restauration de phpBB. La restauration de bases de données qui n’ont pas été sauvegardées par ce système peuvent ne pas fonctionner.',

	'BACKUP_DELETE'		=> 'Le fichier de sauvegarde a été supprimé avec succès.',
	'BACKUP_INVALID'	=> 'Le fichier de sauvegarde que tu as sélectionné est incorrect.',
	'BACKUP_OPTIONS'	=> 'Options de sauvegarde',
	'BACKUP_SUCCESS'	=> 'Le fichier de sauvegarde a été créé avec succès.',
	'BACKUP_TYPE'		=> 'Type de sauvegarde',

	'DATABASE'			=> 'Utilitaires de la base de données',
	'DATA_ONLY'			=> 'Données uniquement',
	'DELETE_BACKUP'		=> 'Supprimer la sauvegarde',
	'DELETE_SELECTED_BACKUP'	=> 'Es-tu sûr de vouloir supprimer la sauvegarde sélectionnée ?',
	'DESELECT_ALL'		=> 'Tout désélectionner',
	'DOWNLOAD_BACKUP'	=> 'Télécharger la sauvegarde',

	'FILE_TYPE'			=> 'Type de fichier',
	'FILE_WRITE_FAIL'	=> 'Impossible d’écrire le fichier dans le répertoire de stockage.',
	'FULL_BACKUP'		=> 'Complète',

	'RESTORE_FAILURE'		=> 'Le fichier de sauvegarde semble corrompu.',
	'RESTORE_OPTIONS'		=> 'Options de restauration',
	'RESTORE_SUCCESS'		=> 'La base de données a été restaurée avec succès.<br /><br />Ton forum devrait être tel qu’il était lorsque la sauvegarde a été réalisée.',

	'SELECT_ALL'			=> 'Tout sélectionner',
	'SELECT_FILE'			=> 'Sélectionner un fichier',
	'START_BACKUP'			=> 'Démarrer la sauvegarde',
	'START_RESTORE'			=> 'Démarrer la restauration',
	'STORE_AND_DOWNLOAD'	=> 'Stocker et télécharger',
	'STORE_LOCAL'			=> 'Stocker le fichier localement',
	'STRUCTURE_ONLY'		=> 'Structure uniquement',

	'TABLE_SELECT'		=> 'Sélection de la table',
	'TABLE_SELECT_ERROR'=> 'Tu dois sélectionner au moins une table.',
));

?>