<?php
/** 
*
* common [Hebrew]
*
* @package language
* @version $Id: $
* @copyright (c) 2007 phpBB Group 
* @author 2008-07-16 - phpBB הישראלי - www.phpBB.co.il
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste: 
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'מבוסס על <a href="http://www.phpbb.co.il">phpBB.co.il - פורומים בעברית</a>. כל הזכויות שמורות &copy; 2008 - phpBB.co.il.',
	'DIRECTION'			=> 'rtl',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'he',

	'1_DAY'			=> 'יום אחד',
	'1_MONTH'		=> 'חודש אחד',
	'1_YEAR'		=> 'שנה אחת',
	'2_WEEKS'		=> 'שבועיים',
	'3_MONTHS'		=> 'שלושה חודשים',
	'6_MONTHS'		=> 'חצי שנה',
	'7_DAYS'		=> 'שבוע',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'חשבונך כבר הופעל.',
	'ACCOUNT_DEACTIVATED'			=> 'חשבונך הופסק ידנית וניתן להפעלה מחדש על-ידי מנהל ראשי בלבד.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'חשבונך עדיין לא הופעל.',
	'ACP'							=> 'לוח בקרה למנהל הראשי',
	'ACTIVE'						=> 'פעיל',
	'ACTIVE_ERROR'					=> 'שם המשתמש שצוין לא פעיל כרגע. אם אתה נתקל בבעיות בהפעלת חשבונך, צור קשר עם המנהל הראשי של המערכת.',
	'ADMINISTRATOR'					=> 'מנהל ראשי',
	'ADMINISTRATORS'				=> 'מנהלים ראשיים',
	'AGE'							=> 'גיל',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'מורשה',
	'ALL_FILES'						=> 'כל הקבצים',
	'ALL_FORUMS'					=> 'כל הפורומים',
	'ALL_MESSAGES'					=> 'כל ההודעות',
	'ALL_POSTS'						=> 'כל ההודעות',
	'ALL_TIMES'						=> 'כל הזמנים הם %1$s %2$s',
	'ALL_TOPICS'					=> 'כל הנושאים',
	'AND'							=> 'וגם',
	'ARE_WATCHING_FORUM'			=> 'נרשמת לקבל עדכונים על הודעות חדשות בפורום זה.',
	'ARE_WATCHING_TOPIC'			=> 'נרשמת לקבל עדכונים על הודעות חדשות בנושא זה.',
	'ASCENDING'						=> 'עולה',
	'ATTACHMENTS'					=> 'קבצים מצורפים',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'קובץ התמונה אשר ניסית לצרף אינו חוקי.',
	'AUTHOR'						=> 'מחבר',
	'AUTH_NO_PROFILE_CREATED'		=> 'המערכת לא הצליחה ליצור פרופיל משתמש.',
	'AVATAR_DISALLOWED_CONTENT'     => 'העלאת הקובץ נדחתה מכיוון שהקובץ זוהה כקובץ חשוד.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'הקובץ אינו ניתן לתצוגה מפני שהסיומת <strong>%s</strong> אינה מורשית.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'הסמל האישי שצוין אינו ניתן להעלאה מפני שהנתונים הרחוקים נראים לא חוקיים או פגומים.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'קובץ הסמל האישי שהועלה ריק.',
	'AVATAR_INVALID_FILENAME'		=> '%s אינו שם קובץ חוקי.',
	'AVATAR_NOT_UPLOADED'			=> 'הסמל האישי אינו ניתן להעלאה.',
	'AVATAR_NO_SIZE'				=> 'לא ניתן לקבוע את הרוחב או הגובה של הסמל האישי המקושר. הזן אותם ידנית.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'הקובץ שצוין הועלה חלקית בלבד.',
	'AVATAR_PHP_SIZE_NA'			=> 'קובץ הסמל האישי גדול מדי.<br />לא ניתן לקבל את גודל הקובץ המירבי אשר מוגדר ב php.ini.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'קובץ הסמל האישי גדול מדי. הגודל המירבי המורשה להעלאה הוא  %1$d %2$s.<br />שים לב שהגודל נקבע ב php.ini ואינו ניתן לשינוי.',
	'AVATAR_URL_INVALID'			=> 'הכתובת שציינת אינה חוקית.',
	'AVATAR_URL_NOT_FOUND'			=> 'הקובץ שצוין לא נמצא.',
	'AVATAR_WRONG_FILESIZE'			=> 'הסמל האישי חייב להיות בין 0 ו %1d %2s.',
	'AVATAR_WRONG_SIZE'				=> 'הסמל האישי שנשלח הוא ברוחב של %5$d פיקסלים ובגובה של %6$d פיקסלים. הסמל האישי חייב להיות לפחות %1$d פיקסלים ברוחב ו %2$d פיקסלים בגובה, אבל לא יותר גדול מ %3$d פיקסלים ברוחב ו %4$d פיקסלים בגובה.',

	'BACK_TO_TOP'			=> 'חזור למעלה',
	'BACK_TO_PREV'			=> 'חזרה לעמוד הקודם',
	'BAN_TRIGGERED_BY_EMAIL'=> 'כתובת הדואר האלקטרוני שלך חסומה.',
	'BAN_TRIGGERED_BY_IP'	=> 'כתובת ה IP שלך חסומה.',
	'BAN_TRIGGERED_BY_USER'	=> 'שם המשתמש שלך חסום.',
	'BBCODE_GUIDE'			=> 'מדריך BBCode',
	'BCC'					=> 'עותק חסוי',
	'BIRTHDAYS'				=> 'ימי הולדת',
	'BOARD_BAN_PERM'		=> 'נחסמת <strong>לצמיתות</strong> מהמערכת.<br /><br />צור קשר עם %2$sהמנהל הראשי%3$s למידע נוסף.',
	'BOARD_BAN_REASON'		=> 'הסיבה שניתנה לחסימה: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'נחסמת מהמערכת עד <strong>%1$s</strong>.<br /><br />צור קשר עם %2$sהמנהל הראשי%3$s למידע נוסף.',
	'BOARD_DISABLE'			=> 'מערכת הפורומים אינה זמינה כרגע. עמכם הסליחה.',
	'BOARD_DISABLED'		=> 'המערכת כבויה כרגע.',
	'BOARD_UNAVAILABLE'		=> 'סליחה, אך המערכת אינה זמינה כרגע, אנא נסה שוב בעוד מספר דקות.',
	'BROWSING_FORUM'      => 'משתמשים הגולשים בפורום זה: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'משתמשים הגולשים בפורום זה: %1$s ואורח אחד',
	'BROWSING_FORUM_GUESTS'	=> 'משתמשים הגולשים בפורום זה: %1$s ו %2$d אורחים',
	'BYTES'					=> 'Bytes',

	'CANCEL'				=> 'בטל',
	'CHANGE'				=> 'שנה',
	'CHANGE_FONT_SIZE'		=> 'שנה גודל גופן',
	'CHANGING_PREFERENCES'	=> 'משנה העדפות מערכת',
	'CHANGING_PROFILE'		=> 'משנה הגדרות פרופיל',
	'CLICK_VIEW_PRIVMSG'	=> '%sעבור לתיבת הדואר הנכנס%s',
	'COLLAPSE_VIEW'			=> 'צמצם תצוגה',
	'CLOSE_WINDOW'			=> 'סגור חלון',
	'COLOUR_SWATCH'			=> 'מאגר צבעים',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'אישור',
	'CONFIRM_CODE'			=> 'קוד אישור',
	'CONFIRM_CODE_EXPLAIN'	=> 'הזן את הקוד בדיוק כפי שהוא מופיע. כל האותיות הן אותיות גדולות.',
	'CONFIRM_CODE_WRONG'	=> 'קוד האישור שהזנת שגוי.',
	'CONFIRM_OPERATION'		=> 'האם אתה בטוח שברצונך להמשיך?',
	'CONGRATULATIONS'		=> 'מזל טוב ל',
	'CONNECTION_FAILED'		=> 'ההתחברות נכשלה.',
	'CONNECTION_SUCCESS'	=> 'ההתחברות הצליחה!',
	'COOKIES_DELETED'		=> 'כל עוגיות המערכת נמחקו בהצלחה.',
	'CURRENT_TIME'			=> 'עכשיו %s', // phpBBrew Group:: Original english is 'It is currently %s', but in hebrew we don't really need to say "It is.. bla bla", just showing the date and time is enough.

	'DAY'					=> 'יום',
	'DAYS'					=> 'ימים',
	'DELETE'				=> 'מחק',
	'DELETE_ALL'			=> 'מחק הכל',
	'DELETE_COOKIES'		=> 'מחק את כל עוגיות המערכת',
	'DELETE_MARKED'			=> 'מחק מסומנים',
	'DELETE_POST'			=> 'מחק הודעה',
	'DELIMITER'				=> 'תוחם',
	'DESCENDING'			=> 'יורד',
	'DISABLED'				=> 'מכובה',
	'DISPLAY'				=> 'הצג',
	'DISPLAY_GUESTS'		=> 'הצג אורחים',
	'DISPLAY_MESSAGES'		=> 'הצג הודעות קודמות',
	'DISPLAY_POSTS'			=> 'הצג הודעות החל מה',
	'DISPLAY_TOPICS'		=> 'הצג נושאים קודמים',
	'DOWNLOADED'			=> 'הורד',
	'DOWNLOADING_FILE'		=> 'מוריד קובץ',
	'DOWNLOAD_COUNT'		=> 'הורד פעם אחת', // phpBBrew Group:: Original english is 'Downloade %d time', but in hebrew we don't really need "%d", just say "Downloade one time" and that is it.
	'DOWNLOAD_COUNTS'		=> 'הורד %d פעמים',
	'DOWNLOAD_COUNT_NONE'	=> 'עדיין לא הורד',
	'VIEWED_COUNT'			=> 'נצפה פעם אחת', // phpBBrew Group:: Original english is 'Viewed %d time', but in hebrew we don't really need "%d", just say "Viewed one time" and that is it.
	'VIEWED_COUNTS'			=> 'נצפה %d פעמים',
	'VIEWED_COUNT_NONE'		=> 'עדיין לא נצפה',

	'EDIT_POST'							=> 'ערוך הודעה',
	'EMAIL'								=> 'דואר אלקטרוני',		// Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'כתובת דואר אלקטרוני',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'שגיאה בשליחת הדואר האלקטרוני ב<strong>שורה %1$s</strong>. תגובה: %2$s.',
	'EMPTY_SUBJECT'						=> 'יש לציין כותרת בעת שליחת נושא חדש.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'יש לציין כותרת בעת שליחת הודעה חדשה.',
	'ENABLED'							=> 'מופעל',
	'ENCLOSURE'							=> 'סגור',
	'ERR_CHANGING_DIRECTORY'			=> 'לא ניתן לשנות תיקיה.',
	'ERR_CONNECTING_SERVER'				=> 'שגיאה בהתחברות לשרת.',
	'ERR_JAB_AUTH'						=> 'לא ניתן לאמת בשרת Jabber.',
	'ERR_JAB_CONNECT'					=> 'לא ניתן להתחבר לשרת Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'שם המשתמש או הסיסמה שצוינו לא נכונים.',
	'ERR_UNWATCHING'					=> 'שגיאה התרחשה בעת הנסיון לבטל ההרשמה.',
	'ERR_WATCHING'						=> 'שגיאה התרחשה בעת הנסיון להרשם.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'נתיב phpBB שצוין שגוי.',
	'EXPAND_VIEW'						=> 'הרחב תצוגה',
	'EXTENSION'							=> 'סיומת',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'הסיומת <strong>%s</strong> נחסמה ואינה ניתנת יותר לתצוגה.',

	'FAQ'					=> 'שאלות נפוצות',
	'FAQ_EXPLAIN'			=> 'שאלות נפוצות',
	'FILENAME'				=> 'שם הקובץ',
	'FILESIZE'				=> 'גודל הקובץ',
	'FILEDATE'				=> 'תאריך קובץ',
	'FILE_COMMENT'			=> 'הערה לקובץ',
	'FILE_NOT_FOUND'		=> 'הקובץ המבוקש לא נמצא.',
	'FIND_USERNAME'			=> 'מצא משתמש',
	'FOLDER'				=> 'תיקיה',
	'FORGOT_PASS'			=> 'שכחתי את סיסמתי',
	'FORM_INVALID'          => 'הטופס שנשלח לא תקין. נסה לשלוח שנית.',
	'FORUM'					=> 'פורום',
	'FORUMS'				=> 'פורומים',
	'FORUMS_MARKED'			=> 'הפורומים הנבחרים סומנו כנקראו.',
	'FORUM_CAT'				=> 'קטגוריות הפורום',
	'FORUM_INDEX'			=> 'עמוד ראשי',
	'FORUM_LINK'			=> 'פורום קישור',
	'FORUM_LOCATION'		=> 'מיקום בפורום',
	'FORUM_LOCKED'			=> 'פורום נעול',
	'FORUM_RULES'			=> 'חוקי הפורום',
	'FORUM_RULES_LINK'		=> 'אנא לחץ כאן על מנת לצפות בחוקי הפורום',
	'FROM'					=> 'מאת',
	'FSOCK_DISABLED'		=> 'לא ניתן להשלים את הפעולה מפני שהפונקציה <var>fsockopen</var> כבויה או שהשרת שהתבקש לא נמצא.',

	'FTP_FSOCK_HOST'				=> 'שרת FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'שרת ה-FTP המשמש להתחברות לאתר שלך.',
	'FTP_FSOCK_PASSWORD'			=> 'סיסמה ל-FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'סיסמה למשתמש ה-FTP.',
	'FTP_FSOCK_PORT'				=> 'יציאת FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'יציאת התקשורת המשמשת להתחברות לשרת.',
	'FTP_FSOCK_ROOT_PATH'			=> 'נתיב ל-phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'נתיב מהתיקיה הראשית לתיקיה של מערכת phpBB.',
	'FTP_FSOCK_TIMEOUT'				=> 'זמן הפסקה ל-FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'הזמן, בשניות, בו המערכת תמתין לתגובה מהשרת.',
	'FTP_FSOCK_USERNAME'			=> 'שם משתמש ל-FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'שם המשתמש שבשימוש להתחברות לשרת.',

	'FTP_HOST'					=> 'שרת FTP',
	'FTP_HOST_EXPLAIN'			=> 'שרת ה-FTP המשמש להתחברות לאתר שלך.',
	'FTP_PASSWORD'				=> 'סיסמה ל-FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'סיסמה למשתמש ה-FTP.',
	'FTP_PORT'					=> 'יציאת FTP',
	'FTP_PORT_EXPLAIN'			=> 'יציאת התקשורת המשמשת להתחברות לשרת.',
	'FTP_ROOT_PATH'				=> 'נתיב ל-phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'נתיב מהתיקיה הראשית לתיקיה של מערכת phpBB.',
	'FTP_TIMEOUT'				=> 'זמן הפסקה ל-FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'הזמן, בשניות, בו המערכת תמתין לתגובה מהשרת.',
	'FTP_USERNAME'				=> 'שם משתמש ל-FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'שם המשתמש שבשימוש להתחברות לשרת.',

	'GENERAL_ERROR'				=> 'שגיאה כללית',
	'GB'                  => 'GB',
	'GIB'                  => 'GiB',
	'GO'						=> 'עבור',
	'GOTO_PAGE'					=> 'עבור לעמוד',
	'GROUP'						=> 'קבוצה',
	'GROUPS'					=> 'קבוצות',
	'GROUP_ERR_TYPE'			=> 'סוג הקבוצה שצוין לא מתאים.',
	'GROUP_ERR_USERNAME'		=> 'שם הקבוצה לא צוין.',
	'GROUP_ERR_USER_LONG'		=> 'שם הקבוצה עובר את מגבלת האורך של 60 תווים.',
	'GUEST'						=> 'אורח',
	'GUEST_USERS_ONLINE'		=> 'יש %d אורחים מחוברים',
	'GUEST_USERS_TOTAL'			=> '%d אורחים',
	'GUEST_USERS_ZERO_ONLINE'	=> 'אין אורחים מחוברים',
	'GUEST_USERS_ZERO_TOTAL'	=> 'אין אורחים',
	'GUEST_USER_ONLINE'			=> 'יש אורח אחד מחובר',
	'GUEST_USER_TOTAL'			=> 'אורח אחד',
	'G_ADMINISTRATORS'			=> 'מנהלים ראשיים',
	'G_BOTS'					=> 'בוטים',
	'G_GUESTS'					=> 'אורחים',
	'G_REGISTERED'				=> 'משתמשים רשומים',
	'G_REGISTERED_COPPA'		=> 'משתמשי COPPA רשומים',
	'G_GLOBAL_MODERATORS'		=> 'מנהלים גלובאלים',
	'G_NEWLY_REGISTERED'		=> 'משתמשים שנרשמו לאחרונה',

	'HIDDEN_USERS_ONLINE'         => '%d משתמשים מוסתרים מחוברים',
	'HIDDEN_USERS_TOTAL'         => '%d מוסתרים',
	'HIDDEN_USERS_TOTAL_AND'      => '%d מוסתרים ו-',
	'HIDDEN_USERS_ZERO_ONLINE'      => 'אין משתמשים מוסתרים מחוברים',
	'HIDDEN_USERS_ZERO_TOTAL'      => 'אין מוסתרים',
	'HIDDEN_USERS_ZERO_TOTAL_AND'   => 'אין מוסתרים ו-',
	'HIDDEN_USER_ONLINE'         => 'משתמש מוסתר אחד מחובר',
	'HIDDEN_USER_TOTAL'            => 'מוסתר אחד',
	'HIDDEN_USER_TOTAL_AND'         => 'מוסתר אחד ו-',
	'HIDE_GUESTS'               => 'הסתר אורחים',
	'HIDE_ME'					=> 'בהתחברות זו אל תאפשר למשתמשים אחרים לראות אם אני מחובר',
	'HOURS'						=> 'שעות',
	'HOME'						=> 'בית',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'מצב ICQ',	
	'IF'						=> 'אם',
	'IMAGE'						=> 'תמונה',
	'IMAGE_FILETYPE_INVALID'	=> 'סוג קובץ התמונה %d לסוג mime %s אינו נתמך.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'סוג קובץ התמונה אינו מתאים: הסיומת הצפויה היא %1$s אבל הסיומת שהתקבלה היא %2$s.',
	'IN'						=> 'ב',
	'INDEX'						=> 'עמוד ראשי',
	'INFORMATION'				=> 'מידע',
	'INTERESTS'					=> 'תחומי עניין',
	'INVALID_DIGEST_CHALLENGE'	=> 'אתגר תקציר שגוי.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> ייתכן שזוהי כתובת דואר אלקטרוני לא תקנית?',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'ה IPשלך %1$s נחסם מפני שהוא רשום ברשימה השחורה. לפרטים: <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'הצטרף',
	'JUMP_PAGE'				=> 'הכנס את מספר העמוד שאליו ברצונך לעבור',
	'JUMP_TO'				=> 'עבור ל',
	'JUMP_TO_PAGE'			=> 'לחץ כאן כדי לקפוץ לעמוד אחר…',

	'KB'					=> 'KB',
	'KIB'                   => 'KiB',

	'LAST_POST'							=> 'הודעה אחרונה',
	'LAST_UPDATED'						=> 'עודכן לאחרונה',
	'LAST_VISIT'						=> 'ביקור אחרון',
	'LDAP_NO_LDAP_EXTENSION'			=> 'סיומת LDAP לא זמינה.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'לא ניתן להתחבר לשרת LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'שגיאה התרחשה בזמן החיפוש בתיקית LDAP.',
	'LEGEND'							=> 'מקרא',
	'LOCATION'							=> 'מיקום',
	'LOCK_POST'							=> 'נעל הודעה',
	'LOCK_POST_EXPLAIN'					=> 'נעל מפני עריכה',
	'LOCK_TOPIC'						=> 'נעל נושא',
	'LOGIN'								=> 'התחבר',
	'LOGIN_CHECK_PM'					=> 'התחבר כדי לבדוק הודעות פרטיות.',
	'LOGIN_CONFIRMATION'				=> 'אישור התחברות',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'כדי להמנע מחשבונות של גורמים עוינים, המערכת דורשת ממך להזין קוד אישור לאחר כמות מירבית של התחברויות שנכשלו. הקוד מוצג בתמונה אשר אתה רואה להלן. אם אינך מצליח לראות את התמונה צור קשר עם %sהמנהל הראשי של המערכת%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'עברת את המספר המירבי המותר של נסיונות התחברות. בנוסף לשם המשתמש והסיסמה שלך אתה צריך לפתור את האנטי-בוט שמתחת.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'אינך אומתת על-ידי Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'ציינת סיסמה שגוייה. בדוק את סיסמתך ונסה שנית. אם אתה ממשיך להתקל בבעיות צור קשר עם %sהמנהל הראשי של המערכת%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'לא היה ניתן להמיר את סיסמתך בעת עדכון מערכת זו. אנא %sבקש סיסמה חדשה%s. אם אתה ממשיך להתקל בבעיות צור קשר עם %sהמנהל הראשי של המערכת%s.',
	'LOGIN_ERROR_USERNAME'				=> 'ציינת שם משתמש שגוי. בדוק את שם המשתמש שלך ונסה שנית. אם אתה ממשיך להתקל בבעיות צור קשר עם %sהמנהל הראשי של המערכת%s.',
	'LOGIN_FORUM'						=> 'כדי לצפות או לשלוח בפורום זה אתה חייב להזין את סיסמתו.',
	'LOGIN_INFO'						=> 'כדי להתחבר אתה חייב להיות רשום. ההרשמה לוקחת מספר שניות ומאפשרת לך יכולות גבוהות יותר. המנהל הראשי של המערכת יכול לתת בנוסף הרשאות נוספות למשתמשים רשומים. לפני שאתה מתחבר וודא שאתה מסכים עם תנאי השימוש שלנו וכללי המדיניות. אנא וודא שקראת כל כללי פורום בזמן שאתה גולש במערכת.',
	'LOGIN_VIEWFORUM'					=> 'המערכת דורשת ממך להיות רשום ומחובר כדי לראות פורום זה.',
	'LOGIN_EXPLAIN_EDIT'				=> 'כדי לערוך הודעות בפורום זה אתה חייב להיות רשום ומחובר.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'כדי לראות את רשימת המחוברים אתה חייב להיות רשום ומחובר.',
	'LOGOUT'							=> 'התנתק',
	'LOGOUT_USER'						=> '[ %s ] התנתק',
	'LOG_ME_IN'							=> 'חבר אותי אוטומטית בכל פעם שאבקר ממחשב זה',

	'MARK'					=> 'סמן',
	'MARK_ALL'				=> 'סמן הכל',
	'MARK_FORUMS_READ'		=> 'סמן פורומים כנקראו',
	'MARK_SUBFORUMS_READ'	=> 'סמן תת-פורומים כנקראו',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'לוח בקרה למנהל',
	'MEMBERLIST'			=> 'משתמשים',
	'MEMBERLIST_EXPLAIN'	=> 'צפה ברשימת המשתמשים המלאה',
	'MERGE'					=> 'מיזוג',
	'MERGE_POSTS'			=> 'העבר הודעות',
	'MERGE_TOPIC'			=> 'מזג נושאים',
	'MESSAGE'				=> 'הודעה',
	'MESSAGES'				=> 'הודעות',
	'MESSAGE_BODY'			=> 'גוף ההודעה',
	'MINUTES'				=> 'דקות',
	'MODERATE'				=> 'נהל',
	'MODERATOR'				=> 'מנהל',
	'MODERATORS'			=> 'המנהלים',
	'MONTH'					=> 'חודש',
	'MOVE'					=> 'העבר',
	'MSNM'					=> 'MSNM/WLM',	

	'NA'						=> 'לא זמין',
	'NEWEST_USER'				=> 'המשתמש החדש ביותר <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'הודעה חדשה',
	'NEW_MESSAGES'				=> 'הודעות חדשות',
	'NEW_PM'					=> 'הודעה <strong>%d</strong> חדשה',
	'NEW_PMS'					=> '<strong>%d</strong> הודעות חדשות',
	'NEW_POST'					=> 'הודעה חדשה',	// Not used anymore
	'NEW_POSTS'					=> 'יש הודעות חדשות',	// Not used anymore
	'NEXT'						=> 'הבא',		// Used in pagination
	'NEXT_STEP'					=> 'הבא',
	'NEVER'						=> 'לעולם לא',
	'NO'						=> 'לא',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'אינך מורשה לנהל את הקבוצה הזו.',
	'NOT_AUTHORISED'			=> 'אינך מורשה להכנס לאיזור זה.',
	'NOT_WATCHING_FORUM'		=> 'אינך רשום יותר לקבלת עידכונים עבור פורום זה.',
	'NOT_WATCHING_TOPIC'		=> 'אינך רשום יותר לקבלת עידכונים עבור נושא זה.',
	'NOTIFY_ADMIN'				=> 'אנא הודע למנהל הראשי של המערכת או למנהל האתר.',
	'NOTIFY_ADMIN_EMAIL'		=> 'אנא הודע למנהל הראשי של המערכת או למנהל האתר: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'אינך מורשה לגשת לקובץ זה.',
	'NO_ACTION'					=> 'לא צויינה פעולה.',
	'NO_ADMINISTRATORS'			=> 'לא קיימים מנהלים ראשיים.',
	'NO_AUTH_ADMIN'				=> 'הגישה ללוח הבקרה למנהל הראשי אסורה מפני שאין לך את הרשאות הניהול הראשי.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'אתה לא יכול להתאמת מחדש בתור משתמש אחר.',
	'NO_AUTH_OPERATION'			=> 'אין לך את ההרשאות המתאימות להשלמת פעולה זו.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'לא ניתן להתחבר לשרת smtp : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'אף משתמש לא חוגג יום הולדת היום',
	'NO_EMAIL_MESSAGE'			=> 'הודעת הדואר האלקטרוני ריקה.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'לא ניתן לקבל את תשובת שרת הדואר.',
	'NO_EMAIL_SUBJECT'			=> 'לא צויינה כותרת הודעת הדואר האלקטרוני.',
	'NO_FORUM'					=> 'הפורום שבחרת לא קיים.',
	'NO_FORUMS'					=> 'במערכת זו אין פורומים.',
	'NO_GROUP'					=> 'קבוצת המשתמשים שהתבקשה אינה קיימת.',
	'NO_GROUP_MEMBERS'			=> 'לקבוצה זו אין כרגע חברים.',
	'NO_IPS_DEFINED'			=> 'אין כתובות IP או שמות שרתים מוגדרים',
	'NO_MEMBERS'				=> 'לא נמצאו משתמשים לאפשרות חיפוש זו.',
	'NO_MESSAGES'				=> 'אין הודעות',
	'NO_MODE'					=> 'אין מצב מסויים.',
	'NO_MODERATORS'				=> 'לא קיימים מנהלים',
	'NO_NEW_MESSAGES'			=> 'אין הודעות חדשות',
	'NO_NEW_PM'					=> '<strong>0</strong> הודעות חדשות',
	'NO_NEW_POSTS'				=> 'אין הודעות חדשות',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'אין משתמשים רשומים',
	'NO_POSTS'					=> 'אין הודעות',
	'NO_POSTS_TIME_FRAME'		=> 'אין הודעות קיימות בנושא זה למסגרת הזמן שנבחרה.',
	'NO_FEED_ENABLED'			=> 'הזנות לא זמינות במערכת זו.',
	'NO_FEED'					=> 'ההזנה שביקשת לא זמינה.',
	'NO_SUBJECT'				=> 'לא צויינה כותרת', // Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'שיטת החיפוש שצויינה אינה קיימת.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'אין שיטות אימות נתמכות.',
	'NO_TOPIC'					=> 'הנושא המבוקש לא קיים.',
	'NO_TOPIC_FORUM'                        => 'הנושא או הפורום לא קיימים יותר.',
	'NO_TOPICS'					=> 'אין נושאים או הודעות בפורום זה.',
	'NO_TOPICS_TIME_FRAME'		=> 'אין נושאים קיימים בפורום זה למסגרת הזמן שנבחרה.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> הודעות שלא נקראו',
	'NO_UNREAD_POSTS'			=> 'אין הודעות שלא נקראו',
	'NO_UPLOAD_FORM_FOUND'		=> 'ההעלאה הותחלה אבל לא נמצא טופס העלאת קובץ חוקי.',
	'NO_USER'					=> 'המשתמש המבוקש לא נמצא.',
	'NO_USERS'					=> 'המשתמשים המבוקשים לא נמצאו.',
	'NO_USER_SPECIFIED'			=> 'לא צויין שם משתמש.',
	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'אין הודעות ממתינות',		// 0
		1			=> 'הודעה ממתינה אחת',		// 1
		2			=> '%d הודעות ממתינות',		// 2+
	),
	
	'OCCUPATION'				=> 'מקצוע',
	'OFFLINE'					=> 'מנותק',
	'ONLINE'					=> 'מחובר',
	'ONLINE_BUDDIES'			=> 'חברים מחוברים',
	'ONLINE_USERS_TOTAL'		=> 'בסך הכל יש <strong>%d</strong> משתמשים מחוברים :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'אין משתמשים מחוברים :: ',
	'ONLINE_USER_TOTAL'			=> 'כרגע מחובר רק <strong>משתמש אחד</strong> :: ',
	'OPTIONS'					=> 'אפשרויות',

	'PAGE_OF'				=> 'עמוד <strong>%1$d</strong> מתוך <strong>%2$d</strong>',
	'PASSWORD'				=> 'סיסמה',
	'PIXEL'					=> 'פיקסלים',
	'PLAY_QUICKTIME_FILE'	=> 'Quicktime נגן קובץ',
	'PM'					=> 'הודעה פרטית',
	'PM_REPORTED'			=> 'לחץ כאן על מנת לצפות בדיווח',
	'POSTING_MESSAGE'		=> 'מפרסם הודעה ב%s',
	'POSTING_PRIVATE_MESSAGE'	=> 'כותב הודעה פרטית',
	'POST'					=> 'הודעה',
	'POST_ANNOUNCEMENT'		=> 'הכרזה',
	'POST_STICKY'			=> 'דביק',
	'POSTED'				=> 'פורסם',
	'POSTED_IN_FORUM'		=> 'ב',
	'POSTED_ON_DATE'		=> 'ב',
	'POSTS'					=> 'הודעות',
	'POSTS_UNAPPROVED'		=> 'לפחות הודעה אחת בנושא זה לא אושרה.',
	'POST_BY_AUTHOR'		=> 'על ידי',
	'POST_BY_FOE'			=> 'תגובה זו מוסתרת משום שנכתבה על ידי <strong>%1$s</strong> שנמצא ברשימת הנודניקים שלך. %2$s<strong>לחץ כאן כדי להציג אותה</strong>%3$s.',
	'POST_DAY'				=> '%.2f הודעות ליום',
	'POST_DETAILS'			=> 'פרטי ההודעה',
	'POST_NEW_TOPIC'		=> 'פרסם נושא חדש',
	'POST_PCT'				=> '%.2f%% מכל ההודעות',
	'POST_PCT_ACTIVE'		=> '%.2f%% מההודעות של המשתמש',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% מההודעות שלך',
	'POST_REPLY'			=> 'פרסם תגובה',
	'POST_REPORTED'			=> 'לחץ על מנת לצפות בדיווח',
	'POST_SUBJECT'			=> 'נושא ההודעה',
	'POST_TIME'				=> 'זמן ההודעה',
	'POST_TOPIC'			=> 'פרסם נושא חדש',
	'POST_UNAPPROVED'		=> 'הודעה זו מחכה לאישור',
	'PREVIEW'				=> 'תצוגה מקדימה',
	'PREVIOUS'				=> 'הקודם',		// Used in pagination
	'PREVIOUS_STEP'			=> 'הקודם',
	'PRIVACY'				=> 'מדיניות הפרטיות',
	'PRIVATE_MESSAGE'		=> 'הודעה פרטית',
	'PRIVATE_MESSAGES'		=> 'הודעות פרטיות',
	'PRIVATE_MESSAGING'		=> 'התכתבות פרטית',
	'PROFILE'				=> 'לוח בקרה למשתמש',

	'READING_FORUM'				=> 'צופה בנושאים ב%s',
	'READING_GLOBAL_ANNOUNCE'	=> 'קורא הכרזה גלובאלית',
	'READING_LINK'				=> 'עובר בקישור לפורום %s',
	'READING_TOPIC'				=> 'קורא נושא ב%s',
	'READ_PROFILE'				=> 'פרופיל אישי',
	'REASON'					=> 'סיבה',
	'RECORD_ONLINE_USERS'		=> 'מספר הגולשים הרב ביותר אי-פעם הוא <strong>%1$s</strong> ב %2$s',
	'REDIRECT'					=> 'העברה',
	'REDIRECTS'					=> 'סך הכל העברות',
	'REGISTER'					=> 'הרשמה',
	'REGISTERED_USERS'			=> 'משתמשים רשומים:',
	'REG_USERS_ONLINE'			=> 'ישנם %d משתמשים רשומים ו',
	'REG_USERS_TOTAL'			=> '%d רשומים, ',
	'REG_USERS_TOTAL_AND'      => '%d רשומים ו ',
	'REG_USERS_ZERO_ONLINE'		=> 'אין משתמשים רשומים ו',
	'REG_USERS_ZERO_TOTAL'		=> 'אין רשומים, ',
	'REG_USERS_ZERO_TOTAL_AND'   => 'אין רשומים ו ',
	'REG_USER_ONLINE'			=> 'יש משתמש אחד רשום ו',
	'REG_USER_TOTAL'			=> 'אחד רשום, ',
	'REG_USER_TOTAL_AND'      => 'אחד רשום ו ',
	'REMOVE'					=> 'הסר',
	'REMOVE_INSTALL'			=> 'אנא מחק, העבר או שנה את שם התיקיה install לפני שאתה משתמש במערכת. אם התיקיה עדיין קיימת, לוח הבקרה למנהל הראשי בלבד יהיה נגיש.',
	'REPLIES'					=> 'תגובות',
	'REPLY_WITH_QUOTE'			=> 'הגב עם ציטוט',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'מגיב להכרזה גלובאלית',
	'REPLYING_MESSAGE'			=> 'מגיב להודעה ב%s',
	'REPORT_BY'					=> 'דווח על ידי',
	'REPORT_POST'				=> 'דווח על הודעה זו',
	'REPORTING_POST'			=> 'מדווח על הודעה',
	'RESEND_ACTIVATION'			=> 'שלח מחדש הפעלה לדואר אלקטרוני',
	'RESET'						=> 'איפוס טופס',
	'RESTORE_PERMISSIONS'		=> 'שחזר הרשאות',
	'RETURN_INDEX'				=> '%sחזור לעמוד הראשי%s',
	'RETURN_FORUM'				=> '%sחזור לפורום בו ביקרת לאחרונה%s',
	'RETURN_PAGE'				=> '%sחזור לעמוד הקודם%s',
	'RETURN_TOPIC'				=> '%sחזור לנושא שבו צפית%s',
	'RETURN_TO'					=> 'חזור אל',
	'FEED'						=> 'הזנות',
	'FEED_NEWS'					=> 'חדשות',
	'FEED_TOPICS_ACTIVE'		=> 'נושאים פעילים',
	'FEED_TOPICS_NEW'			=> 'נושאים חדשים',
	'RULES_ATTACH_CAN'			=> 'אתה <strong>יכול</strong> לצרף קבצים בפורום זה',
	'RULES_ATTACH_CANNOT'		=> 'אתה <strong>לא יכול</strong> לצרף קבצים בפורום זה',
	'RULES_DELETE_CAN'			=> 'אתה <strong>יכול</strong> למחוק את הודעותיך בפורום זה',
	'RULES_DELETE_CANNOT'		=> 'אתה <strong>לא יכול</strong> למחוק את הודעותיך בפורום זה',
	'RULES_DOWNLOAD_CAN'		=> 'אתה <strong>יכול</strong> להוריד קבצים שצורפו בפורום זה',
	'RULES_DOWNLOAD_CANNOT'		=> 'אתה <strong>לא יכול</strong> להוריד קבצים שצורפו בפורום זה',
	'RULES_EDIT_CAN'			=> 'אתה <strong>יכול</strong> לערוך את ההודעות שלך בפורום זה',
	'RULES_EDIT_CANNOT'			=> 'אתה <strong>לא יכול</strong> לערוך את ההודעות שלך בפורום זה',
	'RULES_LOCK_CAN'			=> 'אתה <strong>יכול</strong> לנעול את ההודעות שלך בפורום זה',
	'RULES_LOCK_CANNOT'			=> 'אתה <strong>לא יכול</strong> לנעול את ההודעות שלך בפורום זה',
	'RULES_POST_CAN'			=> 'אתה <strong>יכול</strong> לכתוב נושאים חדשים בפורום זה',
	'RULES_POST_CANNOT'			=> 'אתה <strong>לא יכול</strong> לכתוב נושאים חדשים בפורום זה',
	'RULES_REPLY_CAN'			=> 'אתה <strong>יכול</strong> להגיב לנושאים קיימים בפורום זה',
	'RULES_REPLY_CANNOT'		=> 'אתה <strong>לא יכול</strong> להגיב לנושאים קיימים בפורום זה',
	'RULES_VOTE_CAN'			=> 'אתה <strong>יכול</strong> להצביע בסקרים בפורום זה',
	'RULES_VOTE_CANNOT'			=> 'אתה <strong>לא יכול</strong> להצביע בסקרים בפורום זה',

	'SEARCH'					=> 'חיפוש',
	'SEARCH_MINI'				=> 'חיפוש…',
	'SEARCH_ADV'				=> 'חיפוש מתקדם',
	'SEARCH_ADV_EXPLAIN'		=> 'צפה באפשרויות החיפוש המתקדם',
	'SEARCH_KEYWORDS'			=> 'חיפוש מילות מפתח',
	'SEARCHING_FORUMS'			=> 'מחפש בפורומים',
	'SEARCH_ACTIVE_TOPICS'		=> 'הצג נושאים פעילים',
	'SEARCH_FOR'				=> 'חפש',
	'SEARCH_FORUM'				=> 'חפש בפורום הזה…',	
	'SEARCH_NEW'				=> 'הצג הודעות חדשות',
	'SEARCH_POSTS_BY'			=> 'חפש הודעות שנכתבו ע"י',
	'SEARCH_SELF'				=> 'הצג את הודעותיך',
	'SEARCH_TOPIC'				=> 'חפש בתוך הנושא הזה…',
	'SEARCH_UNANSWERED'			=> 'הצג נושאים ללא תגובות',
	'SEARCH_UNREAD'				=> 'הצג הודעות שלא נקראו',
	'SEARCH_USER_POSTS'			=> 'חפש את הודעות המשתמש',
	'SECONDS'					=> 'שניות',
	'SELECT'					=> 'בחר',
	'SELECT_ALL_CODE'			=> 'בחר הכל',
	'SELECT_DESTINATION_FORUM'	=> 'אנא בחר פורום יעד',
	'SELECT_FORUM'				=> 'בחר פורום',
	'SEND_EMAIL'				=> 'דואר אלקטרוני',		// Used for submit buttons
	'SEND_EMAIL_USER'         => 'דואר אלקטרוני', 
	'SEND_PRIVATE_MESSAGE'		=> 'שלח הודעה פרטית',
	'SETTINGS'					=> 'הגדרות',
	'SIGNATURE'					=> 'חתימה',
	'SKIP'						=> 'דלג לתוכן',
	'SMTP_NO_AUTH_SUPPORT'		=> 'שרת ה SMTP אינו תומך באימות.',
	'SORRY_AUTH_READ'			=> 'אינך מורשה לקרוא בפורום זה.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'אינך מורשה להוריד קובץ מצורף זה.',
	'SORT_BY'					=> 'מיין לפי',
	'SORT_JOINED'				=> 'תאריך הצטרפות',
	'SORT_LOCATION'				=> 'מיקום',
	'SORT_RANK'					=> 'דירוג',
	'SORT_POSTS'				=> 'הודעות',
	'SORT_TOPIC_TITLE'			=> 'כותרת הנושא',
	'SORT_USERNAME'				=> 'שם משתמש',
	'SPLIT_TOPIC'				=> 'פצל נושא',
	'SQL_ERROR_OCCURRED'		=> 'שגיאת SQL התרחשה בעת טעינת עמוד זה. צור קשר עם %sהמנהל הראשי של המערכת%s אם הבעיה ממשיכה.',
	'STATISTICS'				=> 'סטטיסטיקות',
	'START_WATCHING_FORUM'		=> 'הרשם לקבלת עדכונים מפורום זה',
	'START_WATCHING_TOPIC'		=> 'הרשם לקבלת עדכונים מנושא זה',
	'STOP_WATCHING_FORUM'		=> 'בטל הרשמתך מפורום זה',
	'STOP_WATCHING_TOPIC'		=> 'בטל הרשמתך מנושא זה',
	'SUBFORUM'					=> 'תת פורום',
	'SUBFORUMS'					=> 'תת פורומים',
	'SUBJECT'					=> 'נושא',
	'SUBMIT'					=> 'שלח',

	'TERMS_USE'			=> 'תנאי שימוש',
	'TEST_CONNECTION'	=> 'בדוק חיבור',
	'THE_TEAM'			=> 'הצוות',
	'TIME'			=> 'זמן',
	'TOO_LARGE'						=> 'הערך שהזנת גדול מידי.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'הערך שהזנת ל<strong>מספר מירבי של נמענים מורשים לכל הודעה פרטית</strong> גדול מידי.',
	'TOO_LONG'						=> 'הערך שהזנת ארוך מדי.',

	'TOO_LONG_AIM'					=> 'שם המסך שהזנך ארוך מידי.',
	'TOO_LONG_CONFIRM_CODE'			=> 'קוד האישור שהזנת ארוך מידי.',
	'TOO_LONG_DATEFORMAT'			=> 'תבנית התאריך שהזנת ארוכה מדי.',
	'TOO_LONG_ICQ'					=> 'מספר ה ICQ שהזנת ארוך מידי.',
	'TOO_LONG_INTERESTS'			=> 'תחומי העניין שהזנת ארוכים מידי.',
	'TOO_LONG_JABBER'				=> 'שם חשבון ה Jabber שהזנת ארוך מידי.',
	'TOO_LONG_LOCATION'				=> 'המיקום שהזנת ארוך מידי.',
	'TOO_LONG_MSN'					=> 'שם ה MSNM/WLM name שהזנת ארוך מידי.',
	'TOO_LONG_NEW_PASSWORD'			=> 'הסיסמה שהזנת ארוכה מידי.',
	'TOO_LONG_OCCUPATION'			=> 'העיסוק שהזנת ארוך מידי.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'סיסמאת האישור שהזנת ארוכה מידי.',
	'TOO_LONG_USER_PASSWORD'		=> 'הסיסמה שהזנת ארוכה מידי.',
	'TOO_LONG_USERNAME'				=> 'שם המשתמש שהזנת ארוך מידי.',
	'TOO_LONG_EMAIL'				=> 'כתובת הדואר האלקטרוני שהזנת ארוך מידי.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'אישור כתובת הדואר האלקטרוני שהזנת ארוך מידי.',
	'TOO_LONG_WEBSITE'				=> 'כתובת אתר הבית ארוך מידי.',
	'TOO_LONG_YIM'					=> 'שם ה Yahoo! Messenger שהזנת ארוך מידי.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'ניסת להצביע ליותר מידי אפשרויות.',
	'TOO_SHORT'						=> 'הערך שהזנת קצר מדי.',

	'TOO_SHORT_AIM'					=> 'שם התצוגה שהזנת קצר מידי.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'קוד האישור שהזנת קצר מידי.',
	'TOO_SHORT_DATEFORMAT'			=> 'תבנית התאריך שהזנת קצרה מדי.',
	'TOO_SHORT_ICQ'					=> 'מספר ה ICQ שהזנת קצר מידי.',
	'TOO_SHORT_INTERESTS'			=> 'תחומי העניין שהזנת קצרים מידי.',
	'TOO_SHORT_JABBER'				=> 'שם חשבון ה Jabber שהזנת קצר מידי.',
	'TOO_SHORT_LOCATION'			=> 'המיקום שהזנת קצר מידי.',
	'TOO_SHORT_MSN'					=> 'שם ה MSNM/WLM שהזנת קצר מידי.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'הסיסמה שהזנת קצרה מידי.',
	'TOO_SHORT_OCCUPATION'			=> 'העיסוק שהזנת קצר מידי.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'סיסמאת האישור שהזנת קצרה מידי.',
	'TOO_SHORT_USER_PASSWORD'		=> 'הסיסמה שהזנת קצרה מידי.',
	'TOO_SHORT_USERNAME'			=> 'שם המשתמש שהזנת קצר מידי.',
	'TOO_SHORT_EMAIL'				=> 'כתובת הדואר האלקטרוני שהזנת ארוכה מידי.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'אישור כתובת הדואר האלקטרוני שהזנת ארוך מידי.',
	'TOO_SHORT_WEBSITE'				=> 'כתובת אתר הבית שהזנת קצר מידי.',
	'TOO_SHORT_YIM'					=> 'שם ה Yahoo! Messenger שהזנת קצר מידי.',
	'TOO_SMALL'						=> 'הערך שהזנת קטן מידי.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'הערך שהזנת ל<strong>מספר מירבי של נמענים מורשים לכל הודעה פרטית</strong> קטן מידי.',

	'TOPIC'				=> 'נושא',
	'TOPICS'			=> 'נושאים',
	'TOPICS_UNAPPROVED'	=> 'לפחות נושא אחד בפורום זה לא אושר.',
	'TOPIC_ICON'		=> 'אייקון לנושא',
	'TOPIC_LOCKED'		=> 'נושא זה נעול, אינך יכול לערוך הודעות או לבצע תגובות עתידיות.',
	'TOPIC_LOCKED_SHORT'=> 'נושא נעול',
	'TOPIC_MOVED'		=> 'נושא הועבר',
	'TOPIC_REVIEW'		=> 'תקציר הנושא',
	'TOPIC_TITLE'		=> 'כותרת הנושא',
	'TOPIC_UNAPPROVED'	=> 'נושא זה לא אושר',
	'TOTAL_ATTACHMENTS'	=> 'קבצים מצורפים',
	'TOTAL_LOG'			=> 'פעולה אחת',
	'TOTAL_LOGS'		=> '%d פעולות',
	'TOTAL_NO_PM'		=> '0 הודעות פרטיות בסך הכל',
	'TOTAL_PM'			=> 'הודעה פרטית אחת בסך הכל',
	'TOTAL_PMS'			=> '%d הודעות פרטיות בסך הכל',
	'TOTAL_POSTS'		=> 'הודעות בסך הכל',
	'TOTAL_POSTS_OTHER'	=> '<strong>%d</strong> הודעות בסך הכל',
	'TOTAL_POSTS_ZERO'	=> '<strong>0</strong> נושאים בסך הכל',
	'TOPIC_REPORTED'	=> 'נושא זה דווח',
	'TOTAL_TOPICS_OTHER'=> '<strong>%d</strong> נושאים בסך הכל',
	'TOTAL_TOPICS_ZERO'	=> '<strong>0</strong> נושאים בסך הכל',
	'TOTAL_USERS_OTHER'	=> '<strong>%d</strong> משתמשים בסך הכל',
	'TOTAL_USERS_ZERO'	=> '<strong>0</strong> משתמשים בסך הכל',
	'TRACKED_PHP_ERROR'	=> 'שגיאות PHP מעוקבות: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'לא ניתן לקבוע את מימדי התמונה.',
	'UNABLE_TO_DELIVER_FILE'=> 'לא ניתן למסור קובץ.',
	'UNKNOWN_BROWSER'		=> 'דפדפן לא ידוע',
	'UNMARK_ALL'			=> 'בטל סימון',
	'UNREAD_MESSAGES'		=> 'הודעות שלא נקראו',
	'UNREAD_PM'				=> '<strong>הודעה שלא נקראה</strong>',
	'UNREAD_PMS'			=> '<strong>%d</strong> הודעות שלא נקראו',
	'UNREAD_POST'			=> 'הודעה שלא נקראה',
	'UNREAD_POSTS'			=> 'הודעות שלא נקראו',
	'UNWATCHED_FORUMS'		=> 'אינך רשום יותר לעדכונים לפורומים שנבחרו.',
	'UNWATCHED_TOPICS'		=> 'אינך רשום יותר לעדכונים לנושאים שנבחרו.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'אינך רשום יותר לקבלת עדכונים בפריטים הנבחרים.',
	'UPDATE'				=> 'עדכן',
	'UPLOAD_IN_PROGRESS'	=> 'ההעלאה כרגע בביצוע.',
	'URL_REDIRECT'			=> 'אם הדפדפן שלך אינו תומך בהפניית meta %sלחץ כאן כדי לעבור%s.',
	'USERGROUPS'			=> 'קבוצות',
	'USERNAME'				=> 'שם משתמש',
	'USERNAMES'				=> 'שמות משתמשים',
	'USER_AVATAR'			=> 'סמל אישי של המשתמש',
	'USER_CANNOT_READ'		=> 'אינך יכול לקרוא הודעות בפורום זה.',
	'USER_POST'				=> 'הודעה אחת',
	'USER_POSTS'			=> '%d הודעות',
	'USERS'					=> 'משתמשים',
	'USE_PERMISSIONS'		=> 'נסה את הרשאות המשתמש',
	'USER_NEW_PERMISSION_DISALLOWED'	=> 'אנו מצטערים, אך אינך מורשה להשתמש באפשרות זו. יכול להיות שרק נרשמת לכאן והינך צריך להשתתף יותר כדי להשתמש באפשרות זו.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'נצפה',
	'VIEWING_FAQ'				=> 'צופה בשאלות נפוצות',
	'VIEWING_MEMBERS'			=> 'צופה בפרטי משתמש',
	'VIEWING_ONLINE'			=> 'צופה במי מחובר',
	'VIEWING_MCP'				=> 'צופה בלוח הבקרה למנהל',
	'VIEWING_MEMBER_PROFILE'	=> 'צופה בפרופיל משתמש',
	'VIEWING_PRIVATE_MESSAGES'	=> 'צופה בהודעות פרטיות',
	'VIEWING_REGISTER'			=> 'נרשם לפורום',
	'VIEWING_UCP'				=> 'צופה בלוח הבקרה למשתמש',
	'VIEWS'						=> 'צפיות',
	'VIEW_BOOKMARKS'			=> 'צפה בנושאים מועדפים',
	'VIEW_FORUM_LOGS'			=> 'צופה בלוגים של הפורום',
	'VIEW_LATEST_POST'			=> 'צפה בהודעה האחרונה',
	'VIEW_NEWEST_POST'			=> 'צפה בהודעה הראשונה שלא נקראה',
	'VIEW_NOTES'				=> 'צפה בהערות על המשתמש',
	'VIEW_ONLINE_TIME'			=> 'מבוסס על משתמשים פעילים בדקה האחרונה',
	'VIEW_ONLINE_TIMES'			=> 'מבוסס על משתמשים פעילים ב-%d הדקות האחרונות',
	'VIEW_TOPIC'				=> 'צפה בנושא',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'הכרזה: ',
	'VIEW_TOPIC_GLOBAL'			=> 'הכרזה גלובאלית: ',
	'VIEW_TOPIC_LOCKED'			=> 'נעול: ',
	'VIEW_TOPIC_LOGS'			=> 'ראה פעולות',
	'VIEW_TOPIC_MOVED'			=> 'הועבר: ',
	'VIEW_TOPIC_POLL'			=> 'סקר: ',
	'VIEW_TOPIC_STICKY'			=> 'דביק: ',
	'VISIT_WEBSITE'				=> 'בקר באתר הבית',

	'WARNINGS'			=> 'אזהרות',
	'WARN_USER'			=> 'הזהר משתמש',
	'WELCOME_SUBJECT'	=> 'ברוך הבא לפורום %s',
	'WEBSITE'			=> 'אתר בית',
	'WHOIS'				=> 'מי זה',
	'WHO_IS_ONLINE'		=> 'מי מחובר',
	'WRONG_PASSWORD'	=> 'הזנת סיסמה שגויה.',

	'WRONG_DATA_ICQ'			=> 'המספר שהזנת אינו מספר ICQ חוקי.',
	'WRONG_DATA_JABBER'			=> 'השם שהזנת אינו שם חשבון Jabber חוקי.',
	'WRONG_DATA_LANG'			=> 'השפה שציינת אינה חוקית.',
	'WRONG_DATA_WEBSITE'		=> 'כתובת אתר האינטרנט חייבת להיות כתובת חוקית, כולל הפרוטוקול. לדוגמה http://www.example.com/.',
	'WROTE'						=> 'כתב',

	'YEAR'				=> 'שנה',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'YES'				=> 'כן',
	'YIM'				=> 'YIM',	
	'YOU_LAST_VISIT'	=> 'ביקורך האחרון היה ב: %s',
	'YOU_NEW_PM'		=> 'הודעה פרטית חדשה מחכה לך בתיבת הדואר הנכנס שלך.',
	'YOU_NEW_PMS'		=> 'הודעות פרטיות מחכות שלך בתיבת הדואר הנכנס שלך.',
	'YOU_NO_NEW_PM'		=> 'אין הודעות פרטיות חדשות בתיבת הדואר הנכנס שלך.',

	'datetime'			=> array(
		'TODAY'		=> 'היום',
		'TOMORROW'	=> 'מחר',
		'YESTERDAY'	=> 'אתמול',
	
	'AGO'		=> array(
			0		=> 'לפני פחות מדקה',
			1		=> 'לפני דקה',
			2		=> 'לפני %d דקות',
			60		=> 'לפני שעה',
		),

		'Sunday'	=> 'יום ראשון',
		'Monday'	=> 'יום שני',
		'Tuesday'	=> 'יום שלישי',
		'Wednesday'	=> 'יום רביעי',
		'Thursday'	=> 'יום חמישי',
		'Friday'	=> 'יום שישי',
		'Saturday'	=> 'יום שבת',

		'Sun'		=> 'א\'',
		'Mon'		=> 'ב\'',
		'Tue'		=> 'ג\'',
		'Wed'		=> 'ד\'',
		'Thu'		=> 'ה\'',
		'Fri'		=> 'ו\'',
		'Sat'		=> 'ש\'',

		'January'	=> 'ינואר',
		'February'	=> 'פברואר',
		'March'		=> 'מרץ',
		'April'		=> 'אפריל',
		'May'		=> 'מאי',
		'June'		=> 'יוני',
		'July'		=> 'יולי',
		'August'	=> 'אוגוסט',
		'September' 	=> 'ספטמבר',
		'October'	=> 'אוקטובר',
		'November'	=> 'נובמבר',
		'December'	=> 'דצמבר',

		'Jan'		=> 'ינואר',
		'Feb'		=> 'פברואר',
		'Mar'		=> 'מרץ',
		'Apr'		=> 'אפריל',
		'May_short'	=> 'מאי',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'יוני',
		'Jul'		=> 'יולי',
		'Aug'		=> 'אוגוסט',
		'Sep'		=> 'ספטמבר',
		'Oct'		=> 'אוקטובר',
		'Nov'		=> 'נובמבר',
		'Dec'		=> 'דצמבר',
	),

	'tz'				=> array(
		'-12'	=> 'UTC - 12 שעות',
		'-11'	=> 'UTC - 11 שעות',
		'-10'	=> 'UTC - 10 שעות',
		'-9.5'	=> 'UTC - 9:30 שעות',
		'-9'	=> 'UTC - 9 שעות',
		'-8'	=> 'UTC - 8 שעות',
		'-7'	=> 'UTC - 7 שעות',
		'-6'	=> 'UTC - 6 שעות',
		'-5'	=> 'UTC - 5 שעות',
		'-4.5'	=> 'UTC - 4:30 שעות',
		'-4'	=> 'UTC - 4 שעות',
		'-3.5'	=> 'UTC - 3:30 שעות',
		'-3'	=> 'UTC - 3 שעות',
		'-2'	=> 'UTC - 2 שעות',
		'-1'	=> 'UTC - שעה',
		'0'	=> 'UTC',
		'1'	=> 'UTC + שעה',
		'2'	=> 'UTC + 2 שעות',
		'3'	=> 'UTC + 3 שעות',
		'3.5'	=> 'UTC + 3:30 שעות',
		'4'	=> 'UTC + 4 שעות',
		'4.5'	=> 'UTC + 4:30 שעות',
		'5'	=> 'UTC + 5 שעות',
		'5.5'	=> 'UTC + 5:30 שעות',
		'5.75'	=> 'UTC + 5:45 שעות',
		'6'	=> 'UTC + 6 שעות',
		'6.5'	=> 'UTC + 6:30 שעות',
		'7'	=> 'UTC + 7 שעות',
		'8'	=> 'UTC + 8 שעות',
		'8.75'	=> 'UTC + 8:45 שעות',
		'9'	=> 'UTC + 9 שעות',
		'9.5'	=> 'UTC + 9:30 שעות',
		'10'	=> 'UTC + 10 שעות',
		'10.5'	=> 'UTC + 10:30 שעות',
		'11'	=> 'UTC + 11 שעות',
		'11.5'	=> 'UTC + 11:30 שעות',
		'12'	=> 'UTC + 12 שעות',
		'12.75'	=> 'UTC + 12:45 שעות',
		'13'	=> 'UTC + 13 שעות',
		'14'	=> 'UTC + 14 שעות',
		'dst'	=> '[ שעון קיץ ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] שעון האי בקר',
		'-11'	=> '[UTC - 11] שעון ניו, שעון סמואה רגיל',
		'-10'	=> '[UTC - 10] שעון הוואי האלאוטית רגיל, שעון האי קוק',
		'-9.5'	=> '[UTC - 9:30] שעון איי מרקוסס',
		'-9'	=> '[UTC - 9] שעון אלסקה רגיל, שעון האי גמבייר',
		'-8'	=> '[UTC - 8] שעון האוקיינוס השקט רגיל',
		'-7'	=> '[UTC - 7] שעון הררי רגיל',
		'-6'	=> '[UTC - 6] שעון מרכזי רגיל',
		'-5'	=> '[UTC - 5] שעון מזרחי רגיל',
		'-4.5'	=> '[UTC - 4:30] שעון ונצואלה רגיל',
		'-4'	=> '[UTC - 4] שעון אטלנטי רגיל',
		'-3.5'	=> '[UTC - 3:30] שעון ניו פאונדלנד רגיל',
		'-3'	=> '[UTC - 3] שעון אמזונס רגיל, שעון גרינלנד רגיל',
		'-2'	=> '[UTC - 2] שעון פרננדו דה נורונה, דרום ג\'ורג\'יה &amp; שעון איי סנדוויץ\' דרומי',
		'-1'	=> '[UTC - 1] שעון אזורס רגיל, שעון כף ורדה, שעון גרינלנד מזרחי',
		'0'		=> '[UTC] שעון אירופה מערבי, שעון גריניץ\'',
		'1'		=> '[UTC + 1] שעון אירופה המרכזית, שעון מערב אפריקה',
		'2'		=> '[UTC + 2] שעון ישראל, שעון אירופה המזרחית, שעון אפריקה המרכזית',
		'3'		=> '[UTC + 3] שעון מוסקווה רגיל, שעון אפריקה המזרחית',
		'3.5'	=> '[UTC + 3:30] שעון איראן רגיל',
		'4'		=> '[UTC + 4] שעון גולף רגיל, שעון סאמארה רגיל',
		'4.5'	=> '[UTC + 4:30] שעון אפגניסטן',
		'5'		=> '[UTC + 5] שעון פקיסטן רגיל, שעון יקטרינבורג רגיל',
		'5.5'	=> '[UTC + 5:30] שעון הודו רגיל, שעון סרי לנקה',
		'5.75'	=> '[UTC + 5:45] שעון נפאל',
		'6'		=> '[UTC + 6] שעון בנגלדש, שעון בוטן, שעון נובוסיבירסק רגיל',
		'6.5'	=> '[UTC + 6:30] שעון איי קוקוז, שעון מיאנמר',
		'7'		=> '[UTC + 7] שעון הודו-סין, שעון קרסנויארסק רגיל',
		'8'		=> '[UTC + 8] שעון סין רגיל, שעון אוסטרליה המערבית רגיל, שעון אירקוטסק רגיל',
		'8.75'	=> '[UTC + 8:45] שעון דרום מערב אוסטרליה רגיל',
		'9'		=> '[UTC + 9] שעון יפן רגיל, שעון קוריאה רגיל, שעון צי\'טה רגיל',
		'9.5'	=> '[UTC + 9:30] שעון אוסטרליה המרכזית רגיל',
		'10'	=> '[UTC + 10] שעון אוסטרליה המזרחית רגיל, שעון ולאדיבוסטוק רגיל',
		'10.5'	=> '[UTC + 10:30] שעון לורד הווה רגיל',
		'11'	=> '[UTC + 11] שעון האי שלמה, שעון מגאדן רגיל',
		'11.5'	=> '[UTC + 11:30] שעון האי נורפולק',
		'12'	=> '[UTC + 12] שעון ניו זילנד, שעון פיג\'י, שעון קמחטקה רגיל',
		'12.75'	=> '[UTC + 12:45] שעון איי צ\'אדם',
		'13'	=> '[UTC + 13] שעון טונגה, שעון איי פיניקס',
		'14'	=> '[UTC + 14] שעון האי ליין',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Jan 1st, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Mon Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'January 1st, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Today, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Today, 1:37 pm / January 1st, 2007, 1:37 pm'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D M d, Y g:i a', // Mon Jan 01, 2007 1:37 pm

));

?>