<?php
	/**
	* Creation of graphical buttons
	* @author Lars Kneschke
	* @copyright Copyright (C) 2001 Lars Kneschke
	* @copyright Portions Copyright (C) 2004 Free Software Foundation, Inc. http://www.fsf.org/
	* @license http://www.fsf.org/licenses/lgpl.html GNU Lesser General Public License
	* @package phpgwapi
	* @subpackage gui
	* @version $Id: class.graphics.inc.php,v 1.5.4.4 2004/02/10 13:51:18 ceb Exp $
	*/

	/**
	* Creation of graphical buttons
	* 
	* @package phpgwapi
	* @subpackage gui
	*/
	class graphics
	{
		/* put a valid font here */
		var $font="/opt/future-project/src/management-server/ttf/arial.ttf";

		function createImage($_text, $_fontsize=11)
		{
			/* create filename */
			$filename = 'button_' . md5($_text) . '.png';
			$filename = strtolower($filename);

			/* see if file exists already, we cache it */
			if (file_exists(PHPGW_IMAGES_FILEDIR.'/'.$filename))
			{
				return $filename;
			}

			$size = imagettfbbox($_fontsize,0,$this->font,$_text);
			$dx = abs($size[2]-$size[0]);
			$dy = abs($size[5]-$size[3]);
			$xpad=9;
			$ypad=9;
			$im = imagecreate($dx+$xpad,$dy+$ypad);
			$blue = ImageColorAllocate($im, 0x2c,0x6d,0xaf);
			$black = ImageColorAllocate($im, 0,0,0);
			$white = ImageColorAllocate($im, 255,255,255);
			ImageRectangle($im,0,0,$dx+$xpad-1,$dy+$ypad-1,$black);
			ImageRectangle($im,0,0,$dx+$xpad,$dy+$ypad,$white);
			ImageTTFText($im, $_fontsize, 0, (int)($xpad/2)+1, $dy+(int)($ypad/2), -$black, $this->font, $_text);
			ImageTTFText($im, $_fontsize, 0, (int)($xpad/2), $dy+(int)($ypad/2)-1, -$white, $this->font, $_text);
			ImagePNG($im,PHPGW_IMAGES_FILEDIR.'/'.$filename);
			ImageDestroy($im);

			return $filename;
		}

		function createInputButton($_text, $_name, $_mode='graphic')
		{
			if ($_mode == 'graphic' && extension_loaded('gd'))
			{
				return '<input type="image" src="/phpgroupware/phpgwapi/templates/default/images/'.$this->createImage($_text).'" border="0" name="'.$_name.'">';
			}
			else
			{
				return '<input type="submit" value="'.$_text.'" name="'.$_name.'">';
			}
		}

		// this function checks, if there is a variable $aaa_x and $aaa_y
		// if so, it will create a new variable $aaa
		function parseHTTPPostVars()
		{
			// execute only if libgd support is enabled
			if (!extension_loaded('gd'))
			{
				return;
			}

			if (is_array($_POST))
			{
				while( list($key, $val) = each($_POST)) 
				{
					if (ereg("(.*)_x",$key,$varName) && $_POST[$varName[1]."_y"])
					{
						$name = $varName[1];
						global $$name;
						$$name = "content generated by parseHTTPPostVars()";
					}
				}
			}
		}
	}
