/**
* phpGroupWare desktop template - javascript functions
* @author Dave Hall dave.hall at mbox.com.au
* @copyright Copyright (C) 2004 Free Software Foundation http://www.fsf.org/
* @license http://www.gnu.org/licenses/gpl.html GNU General Public License
* @version $Id: desktop.js,v 1.1.2.1 2004/02/22 07:08:20 skwashd Exp $
*/

var winW = 630, winH = 460;

var appWin, menu;

if (typeof(window.innerWidth) != "undefined") //N4/6/moz
{
	winW = window.innerWidth;
	winH = window.innerHeight;
}

else if (document.body && typeof(document.body.offsetWidth) != "undefined") //IE6+
{
	winW = document.body.offsetWidth;
	winH = document.body.offsetHeight;
}
else if( document.body 
	&& ( document.body.clientWidth || document.body.clientHeight ))  // IE4/5
{
	winW = document.body.clientWidth;
	winH = document.body.clientHeight;
}

/*
function changeHREF(targetElm)
{
	if(document.getElementsByTagName && document.getElementsByName)
	{
		alert('changeHREF() called - using DOM');
		o = document.getElementById('ifrcontent' + targetElm);
		
		alert('typeof(o) == ' +typeof(o));
		els = o.getElementsByTagName('A');
		for(i = 0; i < els.length; i++)
		{
			els[i].search += '&desktop_target=iframe' + targetElm;
		}
		
		els = o.getElementsByTagName('FORM');
		for(i = 0; i < els.length; i++)
		{
			els[i].action += '&desktop_target=iframe' + targetElm;
		}
	
	}
	else
	{
		
		o = eval('window.ifrcontent' + targetElm); //document.getElementById(targetElm);
		if(o.forms)
		{
			for(i = 0; i < o.forms.length; i++)
			{
				o.forms[i].action += '&desktop_target=iframe' + targetElm;
			}
		}

		if(o.links)
		{
			for(i = 0; i < o.links.length; i++)
			{
				o.links[i].href += '&desktop_target=iframe' + targetElm;
			}
		}
	}
}
*/
function changeHTML(id, html)
{
	if(typeof(document.getElementById(id)) != "undefined")
	{
		eval('document.getElementById("' + id + '").innerHTML' 
			+ "= '" + html + "';");
	}
	else if(typeof(document.all[id]) != "undefined")
	{
		eval('document.all["' + id + '"].innerHTML.' 
			+ "= '" + html + "';");
	}
	else if(typeof(document.layers[id]) != "undefined")
	{
		eval('document.layers["' + id + '"].document.open();');
		eval('document.layers["' + id + '"].document.write(' 
			+ "'" + html + "');");
		eval('document.layers["' + id + '"].document.close();');
	}
}

function changeStyle(id, attr, value)
{
	if(typeof(document.getElementById(id)) != "undefined")
	{
		eval('document.getElementById("' + id + '").style.' 
			+ attr + '= "' + value + '";');
	}
	else if(typeof(document.all[id]) != "undefined")
	{
		eval('document.all["' + id + '"].style.' 
			+ attr + '= "' + value + '";');
	}
	else if(typeof(document.layers[id]) != "undefined")
	{
		eval('document.layers["' + id + '"].style.' 
			+ attr + '= "' + value + '";');
	}
}

function Menu(items)
{

	this.h 		= winH;
	this.items	= items
	this.w		= winW;
	this.timeIOutID;

	Menu.prototype.display	= display;
	Menu.prototype.hide	= hide;
	Menu.prototype.hiLite	= hiLite;
	Menu.prototype.normal	= normal;
	Menu.prototype.position	= position;
	Menu.prototype.toggle	= toggle;

	this.position();

	function hiLite(id)
	{
		changeStyle(id, 'backgroundColor', '#55E');
		this.display();
	}

	function normal(id)
	{
		changeStyle(id, 'backgroundColor', 'inherit');
		this.display();
	}

	function position()
	{
		var width = (this.w + 'px');
		changeStyle('menubar', 'width', width);
		changeStyle('menubar', 'visibility', 'visible');
	}

	function toggle()
	{
		if(this.show)
		{
			this.hide();
		}
		else
		{
			this.display();
		}
	}
	function display()
	{
		clearTimeout(this.timeOutID);
		if(!this.show)
		{
			changeStyle('menupopup', 'visibility', 'visible');
		}
		this.timeOutID = setTimeout('menu.hide()', 2000);
		this.show = true;
		
	}

	function hide()
	{
		clearTimeout(this.timeOutID);
		if(this.show)
		{
			changeStyle('menupopup', 'visibility', 'hidden');
		}
		this.show = false;
	}


	function setMenuItems(items)
	{
		changeStyle('menupopup', 'height', (items * 15) + 'px');
	}	
}

function tickTock()
{
	var mths = new Array('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 
				'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');

	var now = new Date();
	var yr = now.getYear();
	var mth = now.getMonth();
	var day = now.getDay();
	var hrs = now.getHours();
	var mins = now.getMinutes();
	var secs = now.getSeconds();
	var ampm = "AM";
	
	if (hrs > 11)
	{
		ampm = "PM";
		hrs = hrs - 12;
	}

	yr = ((yr < 2000) ? yr + 1900 : yr);
	hrs = ((hrs == 0) ?  12 : hrs);
	hrs = ((hrs < 10) ? "0" + hrs : hrs);
	mins = ((mins < 10) ? "0" + mins : mins);
	secs = ((secs < 10) ? "0" + secs : secs);

	var clock = hrs + ":" + mins + ":" + secs + " " + ampm
			+ '<br />'
			+ day + '-' + mths[mth] + '-' + yr;

	changeHTML('clock', clock);
	setTimeout('tickTock()', 1000);
}

function appWindows(maxWins, contentPrefix, buttonDiv, loadPage)
{
	this.inUse 		= new Array(0,0,0,0,0);
	this.active 		= -1;
	this.maxWins		= maxWins;
	this.contentPrefix	= contentPrefix;
	this.buttonDiv		= buttonDiv;
	
	appWindows.prototype.close	= close;
	appWindows.prototype.drawApps	= drawApps;
	appWindows.prototype.findNext	= findNext;
	appWindows.prototype.getActive	= getActive;
	appWindows.prototype.max	= max;
	appWindows.prototype.min	= min;
	appWindows.prototype.openWin	= openWin;
	appWindows.prototype.showDesktop= showDesktop;

	changeStyle(buttonDiv, 'width', (winW - 175) + 'px');

	
	if(typeof(loadPage) != 'undefined' && loadPage != '')
	{
		this.openWin(loadPage);
	}

	function close(id)
	{
		this.min(id);

		document.getElementById('ifr' + this.contentPrefix + (win2use + 1)).src = urlNull;
		
		this.inUse[id] = 0;
		this.drawApps();
	}

	function drawApps()
	{
		var buttonW = (winW - 185) / this.maxWins;
		var start = buttonW;
		html = '';
		for(i = 0; i < maxWins; i++)
		{
			if(this.inUse[i])
			{
				useClass = (this.active == (i + 1) ? 'appactive' : 'appinactive');
				html += '<div onClick="parent.appWin.max(' + (i + 1) + ');" '
					+ 'class="' + useClass + '" title="' + this.inUse[i][0] + '" '
					+ 'style="width: ' + buttonW + 'px; ' + 'left: ' + start + 'px;">'
					+ '<img src="' + this.inUse[i][1] + '" height="16" width="16" '
					+ 'alt="' + this.inUse[i][0] + '" />'
					+ this.inUse[i][0]
					+ '</div>';
				start += buttonW;
			}
		}
		changeHTML(this.buttonDiv, html);
	}

	function findNext()
	{
		for(i = 0; i < maxWins; i++)
		{
			if(!this.inUse[i])
			{
				return i;
			}
		}
		return -1;
	}

	function getActive()
	{
		return parseInt(this.active);
	}

	function max(id)
	{
		this.showDesktop();
		changeStyle(contentPrefix + id, 'zIndex', 15);
		changeStyle('ifr' + contentPrefix + id, 'zIndex', 24);
		changeStyle(contentPrefix + id, 'visibility', 'visible');
		this.active = id;
		this.drawApps();	
	}

	function min(id)
	{
		this.showDesktop();
		changeStyle(contentPrefix + id, 'visibility', 'hidden');
		changeStyle('ifr' + contentPrefix + id, 'zIndex', -1);
		changeStyle(contentPrefix + id, 'zIndex', -1);
		this.active = -1;
		this.drawApps();
	}

	function openWin(name, icon, url)
	{
		menu.hide();
		this.showDesktop(0);
		win2use = this.findNext();
		if(win2use != -1)
		{
			this.inUse[win2use] = new Array(name, icon);
			
			document.getElementById('content' + (win2use + 1) + 'img').src = icon;

			document.getElementById('ifr' + this.contentPrefix + (win2use + 1)).src = url + '&desktop_target=iframe' + (win2use + 1);

			changeHTML('content' + (win2use + 1) + 'apptitle', name);

			this.max( win2use + 1 );
			this.active = win2use;
		}
		else
		{
			alert('You have ' + this.maxWins + ' open. '
				+ 'Please close at least 1 before trying to open any more.');
		}
	}

	function showDesktop(redraw)
	{
		for(i = 0; i < this.maxWins; i++)
		{
			changeStyle(contentPrefix + (i+1), 'visibility', 'hidden');
		}
		active = -1;
		if(redraw)
		{
			this.drawApps();
		}
	}
}

function startMain(items, loadURL)
{
	appWin = new appWindows(3, 'content', 'menurun', loadURL);
	menu = new Menu();
	tickTock();
}

function startFrame()
{
	changeHREF(window.top.appWin.active + 1);
}
