<?php

/**************************************************************************
 * A form select element.
 *
 * Copyright (C) 2001, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

// $Id: select.inc,v 1.1.1.1 2001/12/30 02:39:25 mjp16 Exp $

class formSelect extends formElement {
	// An associative array of strings containing the text for the
	// corresponding item.  For instance,
	// $options["short"] = "A short option"
	// will render something like
	// <option value="short">A short option</option>
	var $options;
	// A simple array containing the values of the options which are
	// selected.
	var $selected;
	// The size of the select element
	var $size;
	var $multiple;
	
	function formSelect($name) {
		parent::formElement("select", $name);
		$vals = parent::value();
		if (gettype($vals) == "string") {
			$this->selected = array($vals);
		} else {
			$this->selected = $vals;
		}
		$this->size = 1;
		$this->multiple = 0;
	}
	
	function addOption($optTag, $optValue) {
		$this->options = array_merge($this->options, array($optTag => $optValue));
	}

	function setSize($size) {
		if ($size < 0) {
			return;
		}
		$this->size = $size;
	}

	function getVal() {
		return $selected;
	}

	function selected($opt) {
		return array_intersect($this->selected, array($opt));
	}

	function set($opt, $val) {
		if (!$this->multiple) {
			if ($val) {
				$this->selected = array($val);
			} else {
				$this->selected = array();
			}
		} else {
			if ($val) {
				$this->selected = array_merge($this->selected, array($val));
			} else {
				$this->selected = array_diff($this->selected, array($val));
			}
		}
	}
			
	function HTML() {
		$el = parent::HTML();
		$retval = "<select";
		if ($this->size == 0) {
			$size = count($this->options);
		} else {
			$size = $this->size;
		}
		$retval .= " size=\"$size\"";
		if ($this->multiple) {
			$retval .= " multiple";
		}
		$retval .= ">\n";
		foreach ($this->options as $val => $display) {
			$retval .= "<option value=\"$val\"";
			if (array_intersect($this->selected, array($val))) {
				$retval .= " selected";
			}
			$retval .= ">$display</option>\n";
		}
		$retval .= "</select>";

		return $retval;
	}
}

?>
			
