<?php

/**************************************************************************
 * A textarea form element.
 *
 * Copyright (C) 2001, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

// $Id: textarea.inc,v 1.1.1.1 2001/12/30 02:39:25 mjp16 Exp $
 
require_once("lib/form/textarea.inc");

class formTextarea extends formElement {
	var $value, $height, $width;
	
	function formTextarea($name) {
		parent::formElement($name);
		$this->value = parent::value();
		$this->height = 3;
		$this->width = 20;
	}
	
	function set($value) {
		$this->value = $value;
	}
	
	function HTML() {
		$ev = parent::HTML();
		return "<textarea rows=\"$this->height\" cols=\"$this->width\"$ev>$this->value</textarea>";
	}
}

?>
