<?

/**************************************************************************
 * Logging functions.  Provides both access to the standard syslog()
 * functionality, and also a file-based logging mechanism.
 *
 * Copyright (C) 2001, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

// $Id: log.inc,v 1.6 2002/07/12 08:54:35 mjp16 Exp $

require_once("phtml/html.inc");
require_once("phtml/misc.inc");

/* Syslog support.
 */
define_syslog_variables();
openlog($PROGNAME, LOG_PID, LOG_LOCAL5);

/* "Open" a log file.  Provide the handle you will use to reference the log,
 * $file is the name of the file to write the log message to, and $prefix
 * is what will precede each message (after the date and time).
 */
function log_open($handle, $file, $prefix)
{
	global $LOG_FILES;
	
	$LOG_FILES[$handle]["file"] = $file;
	$LOG_FILES[$handle]["prefix"] = $prefix;

	return 1;
}

/* Write a message to the log specified by $handle.
 */
function logmsg($handle, $message)
{
	global $LOG_FILES;
	$logdata = $LOG_FILES[$handle];
	if (!$logdata) {
		echo "<p>Unopened log file handle referenced: [$handle]";
		syslog(LOG_ERR, "Error while logging - Unopened log file handle referenced: [$handle]");
		return FALSE;
	}

	$message = date("M d Y H:i:s ").$logdata["prefix"].": ".$message."\n";

	$fp = fopen($logdata["file"], "a");
	if (!$fp) {
		global $ADMIN_MAIL;
		echo "<P>There was a problem while attempting to perform logging.  Please inform the admin (".html_link($ADMIN_MAIL, "mailto:$ADMIN_MAIL").") of this problem.";
		syslog(LOG_CRIT, "Error while opening log file ".$logdata["file"]." and PHP doesn't tell me what it is.");
		return FALSE;
	}
	if (!flock($fp, LOCK_EX)) {
		global $ADMIN_MAIL;
		echo "<P>There was a problem while attempting to perform logging.  Please inform the admin ".html_link($ADMIN_MAIL, "mailto:$ADMIN_MAIL")." of this problem.";
		syslog("Error while locking log file ".$logdata["file"]." and PHP doesn't tell me what it is.");
		return FALSE;
	}

	fputs($fp, $message);

	flock($fp, LOCK_UN);

	fclose($fp);
	
	return TRUE;
}

?>
