<?

/* Debugging message.  Checks if the global variable $DEBUG evaluates to
 * true, and if it is, then write the message as a HTML comment.
 */
function debug($msg)
{
	global $DEBUG;
	
	if ($DEBUG) {
		echo "<!-- $msg -->\n";
	}
}

function dump_var($var)
{
	global $DEBUG;

	if (!$DEBUG) {
		return;
	}
	echo "\n<!--\n";
	print_r($var);
	echo "\n-->\n";
}

/* Take a look at $HTTP_POST_VARS and see if there are keys in there with
 * non-empty values for every key given in $items.  Return true if this is
 * the case, or false otherwise.
 */
function all_reqd($items)
{
	global $HTTP_POST_VARS;
	
	foreach ($items as $it) {
		if (!$HTTP_POST_VARS[$it]) {
			return false;
		}
	}
	return true;
}

/* Print a MySQL-type 'insert' query string for each and every one of the
 * keys given in $items, with values taken from $HTTP_POST_VARS.  Return
 * the string containing this lot.  Does mysql_escape_string() to ensure
 * safety.  ONLY DOES THE DATA PORTION OF THE QUERY.  Do an example to see
 * the results of this function.
 */
function dump_insert_values($items)
{
	global $HTTP_POST_VARS;
	
	foreach ($items as $it) {
		$val = mysql_escape_string($HTTP_POST_VARS[$it]);
		if (!$retval) {
			$retval = "'$val'";
		} else {
			$retval .= ",'$val'";
		}
	}
	
	return $retval;
}

/* Print a MySQL-type 'update' query strings for each and every one of the
 * keys given in $items, with values taken from $HTTP_POST_VARS.  Return
 * the string containing this lot.  Does mysql_escape_string() to ensure
 * safety.  ONLY DOES THE DATA PORTION OF THE QUERY.
 */
function dump_update_values($items)
{
	global $HTTP_POST_VARS;
	
	foreach ($items as $it) {
		$val = mysql_escape_string($HTTP_POST_VARS[$it]);
		if (!$retval) {
			$retval = "$it='$val'";
		} else {
			$retval .= ",$it='$val'";
		}
	}
	
	return $retval;
}

/* Parses the extra options passed to an HTML function and turns it into a
 * string suitable for inclusion in the HTML tag.
 */
function misc_extraopts($e)
{
	if (is_string($e)) {
		return " ".$e;
	}
	$extras = "";
	if ($e != NULL) {
		foreach ($e as $var => $val) {
			$extras .= " $var=\"$val\"";
		}
	}

	return $extras;
}

?>
