/*
Copyright (c) 2008-2010
	Lars-Dominik Braun <lars@6xq.net>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/* encryption key for xmlrpc */

#ifndef _CRYPT_KEY_OUTPUT_H
#define _CRYPT_KEY_OUTPUT_H

#include <stdint.h>

const unsigned int out_key_n = 16;

static const uint32_t out_key_p[16 + 2] = {
		0x77B1CD94L, 0xDCB48217L, 0x69404CDCL, 0x2C02F724L,
		0x22961551L, 0xB497993BL, 0x5B5EEE8CL, 0xA209AE23L,
		0xE26B1B43L, 0x90F1CE4CL, 0xB86F975AL, 0xF3CB8371L,
		0xDED8E87CL, 0xB2882D4FL, 0x74984776L, 0x361650B2L,
		0x666FB475L, 0x85A10677L,
		};

static const uint32_t out_key_s[4][256] = {{
		0xBA448614L, 0xC35FBBD7L, 0x31B6EC14L, 0xA85F989BL,
		0x89A83B0EL, 0xAB11C2E7L, 0xFC376FBBL, 0x55B2E7B6L,
		0xA330F22EL, 0xA8229AE0L, 0x9D025EF0L, 0x5E917398L,
		0x3BE382F9L, 0x8F103C90L, 0x463C36A2L, 0xD223C350L,
		0x29DDD3F8L, 0x35075D14L, 0x0F963F64L, 0x74D02046L,
		0x28DCFBF1L, 0xEE12889EL, 0x46C74707L, 0xA1C5A67FL,
		0x8FFE2E9DL, 0xACE75324L, 0x49DA447CL, 0x3061FBB3L,
		0x14579E12L, 0xF1E8ED6EL, 0x76A679C1L, 0xD8EF0FEFL,
		0xA5EA7835L, 0xD63EDB8DL, 0x484F139DL, 0x3D3AD62AL,
		0x8A6331F1L, 0xEF43FE4EL, 0x3745B29FL, 0xEAF8A9ADL,
		0xF9FFF4AEL, 0x1E5BB3C5L, 0xFF988E0AL, 0x8C9E1147L,
		0x3EC6CED1L, 0x4CE0F56DL, 0x206E4341L, 0x79C0520FL,
		0x4FA3C2FDL, 0x1A8189E5L, 0xFA0BC58EL, 0xA0F29358L,
		0x42B379BBL, 0xEC55CB3DL, 0xBD7F1551L, 0x31E17BEAL,
		0xACC91098L, 0x7C36A984L, 0x8611A88BL, 0x255CE7CFL,
		0xC80DB988L, 0x743CEEBCL, 0x7AA258B6L, 0xE82424C9L,
		0xD1EAC3DBL, 0x2D562386L, 0x5250E40BL, 0x9B5285F5L,
		0x895D0124L, 0xAB8037D6L, 0xFD67BA8FL, 0x351B05D7L,
		0x0B124E65L, 0x20CF592BL, 0x91BE281FL, 0x879AD90AL,
		0x6609FEB6L, 0xD8A2305FL, 0x861194A2L, 0xD51DB0E3L,
		0xF735D810L, 0xAEFA5174L, 0x56A9577FL, 0x24F3408BL,
		0x10627B95L, 0xBEE74251L, 0x7ECD2211L, 0x95A8B55EL,
		0xBDE1028EL, 0xDEF339E2L, 0xD0768D34L, 0x6BD5A569L,
		0xC2240D0FL, 0xE171393DL, 0x14A24028L, 0x96760DFAL,
		0x4C78040FL, 0xBD6F76D0L, 0x5EE4BA83L, 0xB20C926FL,
		0xC0F0DCD8L, 0xEF5D4105L, 0x383D3B65L, 0x51E42A4AL,
		0x1505EECEL, 0x86B2BFFDL, 0x56EE7DFCL, 0x8734574BL,
		0xCAA9E52DL, 0xE0F66450L, 0x76B7037BL, 0x84AE5148L,
		0xFB7EC4EBL, 0x6A3DEB3DL, 0x06C7EA69L, 0x165F2DFFL,
		0x7B9DB92AL, 0xB9B24C67L, 0x43AB448AL, 0xA64F30D7L,
		0x998BE34DL, 0x628E747AL, 0x294162B9L, 0xAB8014C7L,
		0x22E1516FL, 0x74C3E589L, 0x003D14D0L, 0x8D724CE1L,
		0x2053C615L, 0x9AD67B30L, 0x29C3D0E8L, 0xBC3269B5L,
		0x7CD7D118L, 0x892FD6BEL, 0x30170170L, 0xF582162AL,
		0x35C8F272L, 0x19844866L, 0x85259078L, 0x7C744927L,
		0x1DA54115L, 0x5505DEC7L, 0x7A84A6D8L, 0xC7D8C609L,
		0x2E198969L, 0xF6020F4BL, 0x837DCD75L, 0x2DF45B36L,
		0x83C0DA9FL, 0x4DE5E15CL, 0x8F70E4A4L, 0x364CF096L,
		0xECBDAE6FL, 0x548DC21BL, 0xAFD70D50L, 0x60378522L,
		0x7A405AB5L, 0x60A18616L, 0xFA0905BCL, 0x953A1CCBL,
		0xBE5141D0L, 0xA9403F7BL, 0x5D1E37B6L, 0x500DA5D5L,
		0xBCDB815CL, 0xE78B89E3L, 0x63A3546FL, 0x5AAD9FD4L,
		0x5C6E8B71L, 0xD7971A6FL, 0x40856F48L, 0x91F6CA81L,
		0x956C447AL, 0xF966868FL, 0xF191BB51L, 0x7C015EAFL,
		0x58A8785BL, 0x43710423L, 0x2C246B80L, 0x0072DCD6L,
		0x40569C99L, 0xCB544BB9L, 0x2CC2B579L, 0xA3AF010DL,
		0x5638B6A5L, 0x8918B2D4L, 0x18928D95L, 0x557BAE61L,
		0xA0D578F2L, 0x3CF4B1F1L, 0x1D592634L, 0xED9B40B5L,
		0x0BE033EBL, 0xDD437BAEL, 0x6188202DL, 0x9F0A444DL,
		0x4DCD2CC0L, 0xC28D6DC5L, 0x9ABDD269L, 0xB0843012L,
		0x00951EE5L, 0x4715466DL, 0x3CC39115L, 0xB270DD7BL,
		0x6510D189L, 0x2BBC6F8FL, 0x331B8E06L, 0x54F13F9EL,
		0xA8223944L, 0xC7B1B375L, 0xFD79FA77L, 0xB7930324L,
		0x6197A094L, 0x46CB50D9L, 0xC49A908FL, 0xAC297BAFL,
		0x84D14B51L, 0x0A50682AL, 0x8AFB5E73L, 0x1C1172C6L,
		0x358A5364L, 0x88415003L, 0x4D5666F8L, 0xA287110CL,
		0xD61B0A4AL, 0x3CC0961BL, 0x44BF5FC3L, 0xD69E0492L,
		0xCFD94EE6L, 0x019813D5L, 0xB7D38A5FL, 0x69C15DC1L,
		0x0D896A60L, 0x7ACB18CEL, 0x5CE6D6E7L, 0x743A4295L,
		0xD7E5A8B7L, 0x457E7DD5L, 0x4A07442BL, 0x2ADA51DEL,
		0xF3202F3BL, 0xD4574157L, 0x81A94A0AL, 0xF26BDDFDL,
		0x775935B3L, 0xB9BC3B76L, 0x3FD81E05L, 0xB95EE989L,
		0x9A0F555DL, 0xFD7E49C8L, 0x3A1D12C5L, 0x7955E2EFL,
		0x7F4A75A1L, 0x16DD1739L, 0x3B3EF7E0L, 0x8795C597L,
		}, {
		0x0640766DL, 0xCD661DAFL, 0x2BDECFBDL, 0xDAA77B87L,
		0x5A7E41B5L, 0x9A3CD4EAL, 0xC6CA8D2FL, 0x65F989EBL,
		0x736C3573L, 0xFA69679CL, 0xB317B71BL, 0x41A7E6FEL,
		0x72D83E2AL, 0xE22CAB56L, 0x08920117L, 0x7030D96EL,
		0x35CDE674L, 0x7405A058L, 0x97D69990L, 0xE95C5EF3L,
		0xDC992FB4L, 0xD33C9F8BL, 0xDAF1AD7AL, 0x03503095L,
		0x00967754L, 0x8CF12CD7L, 0x950FD719L, 0x1ADB3F8CL,
		0xDB4F120AL, 0x712C33D5L, 0x8626D609L, 0x1F2CA165L,
		0x3B8FB27FL, 0xBBA56B76L, 0xD0D7517CL, 0xE1B34706L,
		0x2D89956EL, 0xFFDFF151L, 0xD992E142L, 0x9C662E5AL,
		0xD3D210A4L, 0xD914DD04L, 0x712980F3L, 0xF5AE77E4L,
		0x1E186A6DL, 0xC3CED643L, 0x5A8841B0L, 0xD113DB05L,
		0x1C93C9FDL, 0xB0B64822L, 0xDCDA2B02L, 0x09F3B19AL,
		0xF59692CEL, 0x01117325L, 0xCA61CC6BL, 0xF3E6788AL,
		0xAE70FCF0L, 0x2BA3BDD7L, 0x359B04A2L, 0xB422ECFFL,
		0x4CF00372L, 0x6374AD34L, 0xEB0C631BL, 0x56587BA8L,
		0xC32CD2DEL, 0x5294BDC9L, 0x65B79362L, 0x5E38BFADL,
		0x2A8FBE8CL, 0x8E738683L, 0xC673FFD0L, 0x4B04FB4DL,
		0xCC76EE0FL, 0xF45FD305L, 0xB77848D3L, 0x0D3CB64EL,
		0x48772949L, 0xB5E5B2EEL, 0x354BFBEAL, 0x22BDE81FL,
		0x2181F5BEL, 0x40F5F099L, 0x99C49F11L, 0xEF46CF3BL,
		0x4F9B3DD0L, 0x2E34B17EL, 0xF35F478EL, 0xB0ADC5E2L,
		0x06A4CE4EL, 0xF0395C8AL, 0x3F344031L, 0x0B4A502CL,
		0x85DD868CL, 0x0E52D760L, 0x84124817L, 0x08197C7AL,
		0x5520AD9AL, 0xEA8268FCL, 0xA11B655BL, 0xE3204A0EL,
		0x9183F85FL, 0x9A294A29L, 0xE6350EC4L, 0x09202931L,
		0x28BA52EFL, 0x21B2DB1CL, 0xA20FF528L, 0x42918DAEL,
		0xB8E49971L, 0x9E203A81L, 0x2A07F36CL, 0xA2F84D75L,
		0x824D4513L, 0x1D8AC558L, 0x7E65E471L, 0x06002169L,
		0xBEBC8C82L, 0x9B7B8B6BL, 0x3FF164C2L, 0x5672E9C3L,
		0xBFC72AA3L, 0xD3C9D9E3L, 0xCB64E2DDL, 0xE196A84DL,
		0xCF336932L, 0xA5F3CA20L, 0xA8D3D903L, 0x81CB0B86L,
		0xFB4BF27DL, 0xFCA4C125L, 0x21F1D5B6L, 0xCF6BA988L,
		0x1D408BB7L, 0x629F088FL, 0xF4746130L, 0x1B5C2212L,
		0x47AD1F87L, 0x1E1E9B5CL, 0xCD01B844L, 0x5D3307E1L,
		0xA68FE8F7L, 0x3B13346BL, 0x602308E7L, 0x751416ABL,
		0x38030F2BL, 0x1ABC8EF6L, 0x8929E128L, 0x97040FCAL,
		0x13E59C8DL, 0xA121B4D9L, 0xDB599765L, 0x95EDA62DL,
		0xDAEA1CC5L, 0x2CAF5AC9L, 0x5490F679L, 0xFB410588L,
		0x023C15F3L, 0x5FCD4247L, 0x99455DD9L, 0x82CFC454L,
		0x2EBECB55L, 0xE6ED032FL, 0x876F578DL, 0xA4BF3657L,
		0x8DAD590EL, 0xF6ECC607L, 0xF8B5CD9CL, 0xEC124316L,
		0x4159E6DAL, 0xD7EFA744L, 0x2A20A160L, 0x982F527FL,
		0x60C84A77L, 0xFF60A850L, 0xFD5C6EAFL, 0xFD2D5797L,
		0x954F58C6L, 0xA48A9852L, 0x55B5A9D2L, 0xF3F29933L,
		0xB3580EC7L, 0xF7021CB8L, 0x25238BDBL, 0x7FE667E2L,
		0x47353A71L, 0xD9F9D37DL, 0x79374988L, 0x939566EFL,
		0xC1279574L, 0x835BD0DCL, 0xCB52DE4FL, 0x028364BDL,
		0xBE33E780L, 0xB09647D8L, 0x73FA4EABL, 0x859922EAL,
		0xC7520CCAL, 0x72A331D2L, 0x3F5CFE19L, 0x008F9772L,
		0x5CBFD2B8L, 0xF1937A57L, 0xACC6DBA9L, 0xEFF7AB89L,
		0x72A55667L, 0x628DE4B7L, 0xA0CE9591L, 0x3BFD1D5FL,
		0xCA8D7811L, 0x55BE1BD2L, 0x8B4E3C73L, 0xE0ADA4A4L,
		0xB0A9AB99L, 0xFE319FE4L, 0x1C2BE3A3L, 0x037B2517L,
		0xC084B5D6L, 0x2BE02274L, 0xFF05F558L, 0x8482CABDL,
		0x8B3D719AL, 0x1CB98561L, 0x80DA6AEEL, 0x443B8093L,
		0x01D8FAA4L, 0xD7B783D6L, 0x33F0B71EL, 0x73CA82D8L,
		0x4D9DFDA4L, 0xA91F57FEL, 0x17AB093CL, 0x689F8D37L,
		0x40EE7199L, 0xFA702024L, 0xD1DD8C1FL, 0x5F9BD69BL,
		0x64D28176L, 0xF9DAA31BL, 0xBB186496L, 0x078787B1L,
		0x3783C428L, 0xBDA68050L, 0x7E709830L, 0x1BBDB10EL,
		0x6349027FL, 0xF8306215L, 0xD8855420L, 0x0BE3D1A8L,
		0xD3D9C187L, 0x5329049FL, 0xE3395F69L, 0x65AC7995L,
		0x664848D1L, 0x68C64650L, 0x0F9C1F75L, 0xA4808E20L,
		}, {
		0x5CFD009FL, 0x4C09F290L, 0xA786F99CL, 0x76A5A243L,
		0x2DC97400L, 0x424D9AAEL, 0x6644DE0CL, 0x30DAFAE5L,
		0x5ED77CC3L, 0xD1003D99L, 0xCD3C1222L, 0x1CA766C1L,
		0x5B976615L, 0x014E4796L, 0x0A715936L, 0x405D0D57L,
		0x0AB115F1L, 0x8A963877L, 0xBE96D670L, 0xE2310AACL,
		0x148D00F2L, 0x9787F4BFL, 0xE5F62A68L, 0xFD025DA4L,
		0x194B6DF7L, 0x960D3E7BL, 0xB330C5C1L, 0x2932C25BL,
		0x13738072L, 0x9D62ABA1L, 0x0ECD92CAL, 0xF75ACC9BL,
		0x229E433AL, 0xD0A247BFL, 0xE4B0D9BAL, 0xFA69F70EL,
		0x9B7D254FL, 0xD2849281L, 0x4132F364L, 0xF2E4B87FL,
		0x4189B43CL, 0x7E807CBCL, 0x10498724L, 0xF48C5F29L,
		0x03312ACEL, 0x239307BDL, 0x3541CEBCL, 0x1B1AE36DL,
		0xF993F1B1L, 0x3B6BE060L, 0x9782191AL, 0xACC1CC1BL,
		0xA8B4798EL, 0x486399CDL, 0x59A7ECB9L, 0x46490B98L,
		0xB80EA77EL, 0x1071EE10L, 0x8FE10517L, 0xE29D8F08L,
		0x9BDA44C2L, 0x629C5056L, 0xE40E10E3L, 0x0048CBB1L,
		0xF8E698E7L, 0x09369CB7L, 0x898942DCL, 0x0F49BFE0L,
		0x3600B868L, 0x44EE4C88L, 0x6625BBFBL, 0x7C956C83L,
		0x5C42B182L, 0x080AF33BL, 0x1503CC24L, 0xAE64DA10L,
		0x9F3537D3L, 0x99618740L, 0xE7D50FFDL, 0x6CBB4AFFL,
		0x56062EE1L, 0x70C1AD52L, 0xAC54BF35L, 0x5A7D4D07L,
		0x65DC58DEL, 0x7B362255L, 0x6133AFC8L, 0x4C2ACE68L,
		0x858FA998L, 0x5C336C93L, 0x78193EA7L, 0x5613E9BDL,
		0x8B1F58ACL, 0x563D5D47L, 0x6163AF27L, 0x71183690L,
		0x5944DDC3L, 0x817D18BEL, 0x41260F8BL, 0x259ED297L,
		0xA3CCEE2EL, 0xDBB13DDDL, 0x1009CD47L, 0xD12B82C3L,
		0x9A6FF89DL, 0x4248C9D4L, 0x31484739L, 0x7C3DEEC3L,
		0x2E2CBAC1L, 0x9597DDA3L, 0xF64414B0L, 0x066FC96FL,
		0x31F4AAA0L, 0xB2DBBCFFL, 0x50B991ADL, 0x95AC5272L,
		0x0CAA50C4L, 0x0864DE61L, 0xF38A70D4L, 0x08CE8D6CL,
		0x53941C89L, 0xC54DBEBEL, 0xE4DBC2B0L, 0x2B3E9E66L,
		0x6F3E0BA4L, 0x164DC014L, 0xCC6CEC5FL, 0x08238664L,
		0x30988E18L, 0xFDE4501AL, 0x030B3099L, 0xE6F49802L,
		0x94A08714L, 0xC3A784E5L, 0xECDA930DL, 0x0B40E2F9L,
		0x0EE564F8L, 0xF5993B88L, 0x5B8DB5DBL, 0xF77CCA85L,
		0x9C4FCDA9L, 0x2114F372L, 0x2AA12CCEL, 0x2B07C3F1L,
		0xD660E47AL, 0xD0B26A65L, 0x56F8945CL, 0x4C07FCA5L,
		0x5EF2197FL, 0x073CBFFCL, 0xF83E8935L, 0x04DB4798L,
		0x79DE4FB4L, 0x207E0BB1L, 0xD0D47C14L, 0x9DADB205L,
		0x5EBD3EA0L, 0xCA83B290L, 0xC8BF53A1L, 0x4DCBF491L,
		0xB590CD79L, 0x9C98C12EL, 0x8C877D6EL, 0xD0F17FD2L,
		0xB3FFF22FL, 0xE8D38B07L, 0x15641B63L, 0x6FE5D245L,
		0x04045C48L, 0xEF16069BL, 0xB58781CEL, 0x7D07653DL,
		0xCFB9BD0CL, 0x21CA5DE7L, 0xB35606D9L, 0xA7854DE0L,
		0xC134207CL, 0xFE978430L, 0x0C830455L, 0xCB784991L,
		0xC95A3072L, 0xC0AC5E17L, 0x7B999149L, 0xA289D877L,
		0xB4E3254EL, 0x743F72B1L, 0x98CF8054L, 0x7E4E1C3FL,
		0x0A64C32CL, 0xF04CEB0FL, 0x0488ABF6L, 0x004554B3L,
		0x359E3441L, 0x192ABA6FL, 0x28DC322EL, 0xDDE52491L,
		0xF1D8C2A7L, 0xEAE3E74AL, 0xA10B3376L, 0x7A879F55L,
		0xB5F13C45L, 0x5194862CL, 0x6F65DC08L, 0x753F6AFEL,
		0xF08EA616L, 0x26D382C3L, 0x3315E1E5L, 0x538106B9L,
		0xEC0B9F78L, 0xF298C82DL, 0x0125FD86L, 0x07465A0DL,
		0x23953151L, 0x70569F93L, 0x75D261A5L, 0xC5AD33E5L,
		0x49464CDFL, 0xB4E0D04DL, 0xA0866011L, 0x383CC817L,
		0x545FBC56L, 0xA49BED33L, 0x4E4B516AL, 0x38CBF5D4L,
		0x6DBA987CL, 0x1DFE208FL, 0x65466F04L, 0x6D3DCD1DL,
		0xEB4D60C6L, 0xE3FB6AECL, 0xFA16DBDBL, 0xCD1CDF2BL,
		0xF07F845DL, 0x4DA0ECD1L, 0x0EEB40B0L, 0x1CB7A2F0L,
		0xCD8E54F3L, 0x37376D53L, 0xF7AAC8D3L, 0x8BA724AAL,
		0xEF5C922DL, 0x6F1BE181L, 0xD1808DF8L, 0x44764B58L,
		0x0CD247C4L, 0x0C137F60L, 0xB77F6981L, 0x4AC13745L,
		0xBA311B48L, 0x42A5DE75L, 0x4522E7E0L, 0x84E90F54L,
		0xCC0AD21CL, 0x00F8D9A7L, 0x9CA2CED9L, 0x4F8E0583L,
		}, {
		0x6AFF5CA7L, 0x0D8AB1F0L, 0x75E3AD44L, 0x6B5A1A52L,
		0xE9658216L, 0x71B42FBBL, 0xF57D3F6CL, 0x0A79678EL,
		0x534F306FL, 0xB9C725ABL, 0x7157BF11L, 0x2A52F490L,
		0x4D01079CL, 0x6D18FC2BL, 0x94EC0BDBL, 0xA736324EL,
		0x7540D554L, 0x6B9DFB4DL, 0xFA158CA1L, 0xECE8E1ABL,
		0xAFAF64B2L, 0x61450E7BL, 0x4CEBA4FAL, 0xB2AFAAA2L,
		0xFE669447L, 0x4E63D10BL, 0xFBD8AEC8L, 0x5F6B6B1AL,
		0x70A8F15BL, 0xA91D68B6L, 0x59034211L, 0x98273D40L,
		0xB9A9C9ADL, 0xCE4DDCD7L, 0xC3159554L, 0xFD5D1C2DL,
		0x9ABF93B5L, 0x70A8C01FL, 0xA70FCF1AL, 0x641301DDL,
		0x4EDB9E0BL, 0xC548E7B1L, 0x4884B172L, 0x714610B7L,
		0x4086DCCFL, 0xC8D88CC6L, 0x77594608L, 0xBCABFDE1L,
		0x77962F00L, 0x56F6372CL, 0xB9507A98L, 0x0EF9473EL,
		0xDBA8C6E2L, 0x5BE1AA28L, 0xCEA5C805L, 0x750F1D15L,
		0x1F986C17L, 0x3693A790L, 0x71B0C4CCL, 0xC0776116L,
		0xD660B7BCL, 0x8D0ABAB1L, 0x7F1FDFB7L, 0x4900FDE1L,
		0x2208372BL, 0xB8263157L, 0xB53378F5L, 0x10DF5849L,
		0xC3C8CD69L, 0x5E842514L, 0x8085986AL, 0xC305CE78L,
		0x6C5D3C16L, 0xC11A49B6L, 0x391DBE69L, 0x3BACD18DL,
		0x87253FDEL, 0x56D409DEL, 0x68629118L, 0x1C1E9C6FL,
		0x7F737B29L, 0x96838CC1L, 0xC300D7B2L, 0x2A23D185L,
		0x52271100L, 0xCB4B3F01L, 0xB78A9B86L, 0xB9BEDEF5L,
		0x5D8075FFL, 0x5C325E39L, 0x48A76A2BL, 0x96A61231L,
		0x933ADA05L, 0xF9971C9CL, 0xFF2C75FCL, 0x27FA5DAAL,
		0xAEF8AD6EL, 0xF2DEA20BL, 0x11F247FBL, 0xC383DA2AL,
		0xF85A5ED1L, 0xC35FBC79L, 0xBDCEF0ADL, 0xEEBBCFB3L,
		0xCA711BF4L, 0xB7DABFB3L, 0xE03177D0L, 0xBB727F1FL,
		0x142CC33DL, 0xDB6C384EL, 0xAC6D38B4L, 0xF55B4325L,
		0xF020F44FL, 0x5630D9C1L, 0xED39B172L, 0xACB5AFF7L,
		0x8D98DC58L, 0xB6DF90A1L, 0xEC98CD13L, 0xE0C6A237L,
		0xAC64BDF0L, 0x3560D439L, 0x7B0DDB44L, 0x1D3682C3L,
		0x664EBF1AL, 0xD41A4A0CL, 0x0D5DFE5BL, 0x4E133D8CL,
		0xB129ECD6L, 0xD9DA3194L, 0xE45DADBAL, 0x6B27E47FL,
		0xBA9600DDL, 0x8E1936D2L, 0x1F8B1E51L, 0x3860AE03L,
		0xEE540893L, 0x5F31C76BL, 0xE9302FA1L, 0x452CB6B9L,
		0x5D9CA533L, 0xA19F4B2FL, 0x6C0046A4L, 0x657713DDL,
		0x1B5D5A04L, 0xC3D594E6L, 0xBB80FA30L, 0x9BF9E647L,
		0x716F2F97L, 0xF2B8ADA6L, 0x7F242755L, 0x40FB6614L,
		0x4F85BCF9L, 0x18799EB2L, 0x76B4124AL, 0xFCAEC005L,
		0x38231D8AL, 0xD449CE69L, 0xC6877AD2L, 0x16B37A06L,
		0x7DAF096BL, 0xCE11C2B4L, 0x750754B5L, 0xCAC33C86L,
		0x10E20D73L, 0xE4997D0FL, 0x6B06DE8DL, 0x1D70D15FL,
		0xBF060E4FL, 0x18BC4C59L, 0xD1C8585EL, 0x1AEC12B4L,
		0x9AB3F241L, 0x46CFC4CDL, 0xCF16D587L, 0xF1722424L,
		0x0ECA4D9CL, 0xCC6131F3L, 0x0E990CC3L, 0x9771D4BFL,
		0x4C624E9FL, 0x5CA79CBCL, 0x02368C90L, 0x25826D54L,
		0x32D1B4C9L, 0xDA9A049BL, 0x616CC784L, 0x47B562F3L,
		0xB5553B6EL, 0xF205F397L, 0x6FA01B63L, 0xC857201FL,
		0xC5C7C8A1L, 0xA27C47E2L, 0xDB185877L, 0x67236F63L,
		0xBF369D88L, 0x4E7054BDL, 0xD6544BEAL, 0x36EF3BC3L,
		0x60F4B74DL, 0x430EA61EL, 0xC3E9C76DL, 0x499A0517L,
		0x91D45BCDL, 0xDCAEADFAL, 0x355FBC9DL, 0x8CA1770EL,
		0x820BE4F9L, 0x00AE9FD2L, 0x9E63CE49L, 0x46FE33E8L,
		0xA07048A3L, 0x225FBD27L, 0xAF0FD02CL, 0x8F9D7C95L,
		0xD4F0E647L, 0x6DFB3949L, 0xE289B0B0L, 0xF9CC7F56L,
		0x7F168AD2L, 0xED8433E0L, 0xEBB189B5L, 0x765AD69CL,
		0x7730DCF0L, 0xD54C3A0DL, 0xACF6BD6BL, 0x1E19DF12L,
		0xBD984D49L, 0xC4FC38B8L, 0x0D36C9FFL, 0xCC3AD912L,
		0x0A6E4ED6L, 0x27B27847L, 0x604F6917L, 0xD4C1ADADL,
		0xCB19F4BEL, 0x5127D2FDL, 0x38FFA03AL, 0xB983BC5FL,
		0x5CAF3A6EL, 0x84E94F45L, 0xFC3FA473L, 0xC9299B07L,
		0x322F38AFL, 0x2A228E93L, 0x76D63922L, 0x1326A518L,
		0xFEC3F151L, 0xB821D755L, 0x8D1C67ACL, 0x5DA96628L,
		0x04F7335FL, 0xC6F5CD2EL, 0x7D211328L, 0xE19180D3L,
		}};

#endif /* _CRYPT_KEY_OUTPUT_H */
