# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Kaye. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Kaye
#
#
# ***** END LICENSE BLOCK *****

import sys, os, re

################################################################################

# Debug messages can be given a "tag", where a tag is a dot-separated list of
# words, e.g. "tunepimp.event.add".  The default tag is "default".
#
# Debugging can then be enabled / disabled via the PICARD_DEBUG environment
# variable, like so:
#
#	PICARD_DEBUG not set: all tags are "off"
#	PICARD_DEBUG=1 (or "y", or "Y"): all tags are "on"
#	PICARD_DEBUG=0 (or "n", or "N"): all tags are "off"
#
# Apart from the special cases (1,y,Y,0,n,N), PICARD_DEBUG is a
# comma-separated list of options.  Each option is of the form +TAG
# (equivalent to just TAG) or -TAG.  Matching a debug message to a TAG is then
# "hierarchical", in that PICARD_DEBUG=tunepimp matches the tags "tunepimp"
# and "tunepimp.event", but not "tunepimped".  When choosing whether or not to
# display a debug message, the whole comma-separated list of options is
# traversed.
#
# Examples:
#	Enable "tunepimp" (and tunepimp.event, etc) and disable the rest:
#	PICARD_DEBUG=tunepimp
#
#	Enable "tunepimp" and "tunepimp.foo" (etc), disable "tunepimp.event":
#	PICARD_DEBUG=tunepimp,-tunepimp.event
#
#	Enable everything except "tunepimp.event"
#	PICARD_DEBUG=+,-tunepimp.event

debugTagOptions = []
debugTagEnabled = {}

def parseOptions(spec):
    if not spec:
	return []

    if re.match("^(1|y|Y)$", spec):
	return [ ("", True) ]
    if re.match("^(0|n|N)$", spec):
	return []

    options = []

    for specpart in spec.split(","):
	on = True
	if specpart.startswith("+"):
	    specpart = specpart[1:]
	elif specpart.startswith("-"):
	    on = False
	    specpart = specpart[1:]
	try:
	    options.append( (specpart,on) )
	except:
	    pass

    return options

def doesTagMatchOption(tag, opt):
    prefix = opt[0]

    if prefix == "": return True
    elif prefix == tag: return True
    elif tag.startswith(prefix+"."): return True
    else: return False
 
def isOptionOn(opt):
    return opt[1]

def isDebugClassEnabled(tag):
    try:
	return debugTagEnabled[tag]
    except LookupError:
	enabled = False
	for opt in debugTagOptions:
	    if doesTagMatchOption(tag, opt):
		enabled = isOptionOn(opt)
	debugTagEnabled[tag] = enabled
	return enabled

if "PICARD_DEBUG" in os.environ.keys():
    spec = os.environ["PICARD_DEBUG"]
    debugTagOptions = parseOptions(spec)

################################################################################

def debug(text, tag = "default"):
    if not isDebugClassEnabled(tag):
	return

    if isinstance(text, unicode):
	text = text.encode('utf-8', 'ignore')

    if sys.platform == 'win32':
       try:
           log = open("tagger.log", "a")
           log.write(text + "\n")
           log.close()
       except IOError:
           sys.stdio.write(text + "\n")

    else:
       print text

################################################################################

class NestedDumper(object):
    """
    Enables generation of simple indented debug output, to stdout by default

    Example use:
    n = NestedDumper()
    n("This is my output")
    n2 = n.nest()
    n2("This is indented one level")
    n("This is back at the first level")
    """

    def __init__(self, stream = sys.stdout, indent = ""):
	self.stream = stream
	self.indent = indent

    def __call__(self, line):
	self.stream.write(self.indent + line + "\n")

    def nest(self):
	return self.__class__(self.stream, self.indent + "  ")

