# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Kaye. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED,G AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Kaye
#
#
# ***** END LICENSE BLOCK *****
import wx, wx.lib.stattext
import images
from picard.browser import launch

class URLLink(wx.lib.stattext.GenStaticText):

    def __init__(self, *args, **kwargs):
        try:
            self.url = kwargs['url']
            del kwargs['url']
        except KeyError:
            self.url = ''

        try:
            self.post = kwargs['post']
            del kwargs['post']
        except KeyError:
            self.post = ''

        try:
            self.parent = args[1]
        except LookupError:
            self.parent = None

        self.state = False
        self.cursorHand = wx.StockCursor(wx.CURSOR_HAND)

        wx.lib.stattext.GenStaticText.__init__(self, *args, **kwargs)
        wx.EVT_LEFT_DOWN(self, self.OnEnter)
        wx.EVT_ENTER_WINDOW(self, self.OnMouseOver)
        wx.EVT_LEAVE_WINDOW(self, self.OnMouseOut)

        self.enable(self.post or self.url)

    def enable(self, state):
        font = self.GetFont()
        if state:
	    font.SetUnderlined(True)
            self.SetForegroundColour(wx.BLUE)
        else:
	    font.SetUnderlined(False)
            self.SetForegroundColour(wx.BLACK)
        self.SetFont(font)
        self.state = state

    def updateURL(self, url):
        self.post = ''
        self.url = url
        self.enable(self.post or self.url)

    def updatePOST(self, post):
        self.url = ''
        self.post = post
        self.enable(self.post or self.url)

    def OnEnter(self, event):
        if self.url:
            l = launch.Launch(self.parent)
            l.launch(self.url)
        else:
            if self.post:
                l = launch.Launch(self.parent)
                l.post(self.post)
            else:
                event.Skip()

    def OnMouseOver(self, event):
        if self.state:
          self.SetCursor(self.cursorHand)

    def OnMouseOut(self, event):
        if self.state:
          self.SetCursor(wx.NullCursor)

class CoverArtPanel(wx.Panel):

    infoLinkId = wx.NewId()
    buyLinkId = wx.NewId()
    postPage = \
       '<html>\n' + \
       '<head><title>Redirecting to Amazon.com</title></head>\n' + \
       '<body onLoad=\"document.forms[0].submit()">\n' + \
       '    <h2>Redirecting to Amazon.com...</h2>\n' + \
       '    <p>If this page does not automaticaly load, please click the Buy button below.</p>\n' + \
       '    <form name="AddToCartForm" method="POST"\n' +  \
       '          action="http://amazon.com/exec/obidos/dt/assoc/handle-buy-box=%s">' +  \
       '    <input type="hidden" name="asin.%s" value="1">\n' +  \
       '    <input type="hidden" name="tag-value" value="">\n' +  \
       '    <input type="hidden" name="tag_value" value="">\n' +  \
       '    <input type="hidden" name="dev-tag-value" value="D1TBI5FHXK38IE">\n' +  \
       '    <input type="submit" name="submit.add-to-cart" value="Buy">\n' +  \
       '    </form>\n' +  \
       '</body>\n' +  \
       '</html>\n'

    def __init__(self, parent):
        wx.Panel.__init__(self, parent, -1, wx.DefaultPosition, wx.DefaultSize, wx.SIMPLE_BORDER)
        self.asin = ''

        boxSizer = wx.BoxSizer(wx.VERTICAL)
        self.staticBitmap = wx.StaticBitmap(self, -1, images.getNoAlbumImageBitmap())
        self.infoLink = URLLink(self, self.infoLinkId, _("Info"), url="")
        self.buyLink = URLLink(self, self.buyLinkId, _("Buy"), url="")

        hSizer = wx.BoxSizer(wx.HORIZONTAL)
        hSizer.Add(wx.StaticText(self, -1, "Amazon: "), 0, wx.ALL, 2)
        hSizer.Add(self.infoLink, 0, wx.ALL, 2)
        hSizer.Add(wx.StaticText(self, -1, " | "), 0, wx.ALL, 2)
        hSizer.Add(self.buyLink, 0, wx.ALL, 2)

        boxSizer.Add(self.staticBitmap, 0, wx.ALL, 5)
        boxSizer.Add(hSizer, 1, wx.ALIGN_CENTER)

        #boxSizer.SetSizeHints(self)
        self.SetSizer(boxSizer)
        self.Fit()

    def showImage(self, image, asin = ''):
        if asin and asin[0] != '<':
            self.infoLink.updateURL("http://amazon.com/exec/obidos/ASIN/%s/?v=glance&s=music" % asin)
            self.buyLink.updatePOST(self.postPage % (asin, asin))
        else:
            self.infoLink.updateURL("")
            self.buyLink.updateURL("")
        self.staticBitmap.SetBitmap(wx.BitmapFromImage(image))

    def getStaticBitmap(self):
        return self.staticBitmap
