# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Kaye. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Kaye
#
#
# ***** END LICENSE BLOCK *****

import wx, sys, re, os
from musicbrainz2.utils import getCountryName
from picard import events, util
from tunepimp import metadata

class InfoPanel(wx.Panel):

    def __init__(self, parent, config):
        wx.Panel.__init__(self, parent, -1, wx.DefaultPosition, wx.DefaultSize, wx.SIMPLE_BORDER)
        self.frame = parent
        self.tunePimp = config.getTunePimp()
        self.config = config

        self.statusText = wx.StaticText(self, -1, _("Welcome to Picard!"), style=wx.ALIGN_CENTER | 
                                        wx.ST_NO_AUTORESIZE)
        font = self.statusText.GetFont()
        font.SetWeight(wx.BOLD)
        self.statusText.SetFont(font)

        self.numTracksLabel = wx.StaticText(self, -1, _("Number of tracks") + ":", style=wx.ALIGN_RIGHT)
        self.releaseTypeLabel = wx.StaticText(self, -1, _("Release type") + ":", style=wx.ALIGN_RIGHT)
        self.releaseStatusLabel = wx.StaticText(self, -1, _("Release status") + ":", style=wx.ALIGN_RIGHT)
        self.releaseDateLabel = wx.StaticText(self, -1, _("Release date") + ":", style=wx.ALIGN_RIGHT)

        self.numTracks= wx.StaticText(self, -1, u"-")
        self.releaseType= wx.StaticText(self, -1, u"-")
        self.releaseStatus= wx.StaticText(self, -1, u"-")
        self.releaseDate = wx.StaticText(self, -1, u"-")

        vSizer = wx.FlexGridSizer(3, 2, 4, 4)
        vSizer.AddMany([
            (self.numTracksLabel, 1, wx.EXPAND), 
            (self.numTracks, 0, wx.EXPAND), 
            (self.releaseTypeLabel, 1, wx.EXPAND),
            (self.releaseType, 0, wx.EXPAND), 
            (self.releaseStatusLabel, 1, wx.EXPAND),
            (self.releaseStatus, 0, wx.EXPAND),
            (self.releaseDateLabel, 0, wx.EXPAND),
            (self.releaseDate, 1, wx.EXPAND)])
        vSizer.AddGrowableCol(1)

        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.statusText, 0, wx.EXPAND | wx.ALL, 4)
        sizer.Add((-1, 5))
        sizer.Add(vSizer, 0, wx.ALL, 8)
        sizer.Add((-1, 5))

        sizer.SetSizeHints(self)
        self.SetSizer(sizer)
        self.Fit()

    def setStatusText(self, text):
        self.statusText.SetLabel(text)

    def setInfo(self, al):
        self.numTracks.SetLabel("%d" % al.getNumTracks())
        self.releaseType.SetLabel("%s" % al.getReleaseType())
        self.releaseStatus.SetLabel("%s" % al.getReleaseStatus())
        if al.getReleaseYear():
            country = al.getReleaseCountry()
            country = getCountryName(country) or country
            self.releaseDate.SetLabel("%s\n%s" % (al.getReleaseDate(), country))
        else:
            self.releaseDate.SetLabel(u'-')

