# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Vollmert. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Vollmert
#
#
# ***** END LICENSE BLOCK *****

import wx

class HostCtrl(wx.Panel):
    """Controls for entering host/port with labels"""

    def __init__(self, parent, id=-1,
                 hostdesc="Host:", portdesc="Port:", host="", port=80):
        wx.Panel.__init__(self, parent, id)
        
        label_host = wx.StaticText(self, -1, hostdesc)
        label_port = wx.StaticText(self, -1, portdesc)
        self.host = wx.TextCtrl(self, -1, host)
        self.port = wx.SpinCtrl(self, -1, str(port), size=(80,-1), min=0, max=65535)
        
        sizer = wx.FlexGridSizer(2, hgap=5)
        sizer.Add(label_host)
        sizer.Add(label_port)
        sizer.Add(self.host, 1, wx.EXPAND)
        sizer.Add(self.port)
        sizer.AddGrowableCol(0)
        self.SetSizerAndFit(sizer)

    def GetValue(self):
        return (self.host.GetValue(), self.port.GetValue())

    def SetValue(self, host, port):
        self.host.SetValue(host)
        self.port.SetValue(port)

class TextDefaultCtrl(wx.Panel):
    """Textbox with label and Default-button"""

    buttonId = 1

    def __init__(self, parent, id=-1, desc="", value=None, default=""):
        wx.Panel.__init__(self, parent, id)

        if value is None:
            value = default
        self.default = default

        label = wx.StaticText(self, -1, desc)
        self.text = wx.TextCtrl(self, -1, value)
        button = wx.Button(self, self.buttonId, _("Default"))
        wx.EVT_BUTTON(self, self.buttonId, self.OnClick)

        sizerh = wx.BoxSizer(wx.HORIZONTAL)
        sizerh.Add(self.text, 1, wx.EXPAND)
        sizerh.Add((5,-1))
        sizerh.Add(button)
        
        sizerv = wx.BoxSizer(wx.VERTICAL)
        sizerv.Add(label)
        sizerv.Add(sizerh, 0, wx.EXPAND)
        
        self.SetSizerAndFit(sizerv)

    def GetValue(self):
        return self.text.GetValue()

    def SetValue(self, value):
        self.text.SetValue(value)

    def OnClick(self, event):
        self.SetValue(self.default)

class DirectoryCtrl(wx.Panel):
    """Checkbox with textbox and Browse-button in frame"""

    checkId = wx.NewId()
    buttonId = wx.NewId()
    textId = wx.NewId()

    def __init__(self, parent, id=-1, config=None, title="", desc="", dir="", checked=False):
        wx.Panel.__init__(self, parent, id)

        self.config = config
        self.check = wx.CheckBox(self, self.checkId, desc)
        self.text = wx.TextCtrl(self, self.textId, dir)
        self.button = wx.Button(self, self.buttonId, _("Browse"))
        self.enable(checked)
        self.check.SetValue(checked)

        sizerh = wx.BoxSizer(wx.HORIZONTAL)
        sizerh.Add(self.text, 1, wx.EXPAND | wx.ALL, 5)
        sizerh.Add(self.button, 0, wx.ALL, 5)

        box = wx.StaticBox(self, -1, title)
        sizerv = wx.StaticBoxSizer(box, wx.VERTICAL)
        sizerv.Add(self.check, 0, wx.LEFT | wx.RIGHT | wx.TOP, 5)
        sizerv.Add(sizerh, 0, wx.EXPAND)

        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(sizerv, 1, wx.EXPAND)
        self.SetSizerAndFit(sizer)

        wx.EVT_CHECKBOX(self, self.checkId, self.OnCheck)
        wx.EVT_BUTTON(self, self.buttonId, self.OnButton)

    def enable(self, val):
        self.text.Enable(val)
        self.button.Enable(val)

    def getValue(self):
        return self.text.GetValue()

    def isChecked(self):
        return self.check.IsChecked()

    def OnCheck(self, event):
        self.enable(event.IsChecked())

    def OnButton(self, event):
        dlg = wx.DirDialog(self, _("Select a directory"), self.getValue())
        if dlg.ShowModal() == wx.ID_OK:
            self.text.SetValue(dlg.GetPath())
        dlg.Destroy()

class CondSpinCtrl(wx.Panel):
    """Checkbox with spin-control and text"""

    checkId = 1

    def __init__(self, parent, id=-1, text1="", text2="", value=100, withCheck=True):
        wx.Panel.__init__(self, parent, id)
        self.withCheck = withCheck
        if withCheck:
            self.check = wx.CheckBox(self, self.checkId, text1)
        else:
            self.check = wx.StaticText(self, self.checkId, text1)
        self.spin = wx.SpinCtrl(self, -1, size=(50,-1),
                                min=0, max=100, value=str(abs(value)))
        self.label = wx.StaticText(self, -1, text2)

        sizerh = wx.BoxSizer(wx.HORIZONTAL)
        sizerh.Add((20,-1), 0)
        sizerh.Add(self.spin, 0, wx.RIGHT, 5)
        sizerh.Add(self.label, 0, wx.ALIGN_CENTER_VERTICAL)

        sizerv = wx.BoxSizer(wx.VERTICAL)
        sizerv.Add(self.check, 0, wx.BOTTOM, 5)
        sizerv.Add(sizerh, 0)

        self.SetSizerAndFit(sizerv)

        if withCheck:
            wx.EVT_CHECKBOX(self, self.checkId, self.OnCheck)
            self.enable(value >= 0)
            self.check.SetValue(value >= 0)

    def enable(self, val):
        self.spin.Enable(val)
        self.label.Enable(val)

    def OnCheck(self, event):
        self.enable(event.IsChecked())

    def GetValue(self):
        return self.spin.GetValue()

    def IsChecked(self):
        if self.withCheck:
            return self.check.IsChecked()
        else:
            return True

