# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Vollmert. All Rights Reserved.
# Portions Copyright (c) 2005 Lukas Lalinsky. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Vollmert, Lukas Lalinsky
#
#
# ***** END LICENSE BLOCK *****

import wx, sys

from page import Page

formats = [("%artist", N_("Track artist name")),
           ("%albumartist", N_("Album artist name")),
           ("%albumartistsortname", N_("Album artist sortname")),
           ("%sortname", N_("Track artist sortname")),
           ("%album", N_("Album name")),
           ("%albumtracks", N_("Number of tracks on the album")),
           ("%abc", N_("The first character of the artist sortname")),
           ("%abc2", N_("The first two characters of the artist sortname")),
           ("%abc3", N_("The first three characters of the artist sortname")),
           ("%track", N_("Track name")),
           ("%0num", N_("Zero padded track number")),
           ("%num", N_("Track number")),
           ("%format", N_("File format (e.g. mp3, ogg, wav)")),
           ("%type", N_("Album type (album, single, EP, etc.)")),
           ("%status", N_("Album Status (official, promo, etc.)")),
           ("%month", N_("Album release month")),
           ("%day", N_("Album release day")),
           ("%year", N_("Album release year")),
           ("%country", N_("Album release country"))
          ]

class NamingHelpDialog(wx.Dialog):

    closeId = wx.NewId() 

    def __init__(self, parent, config):
        wx.Dialog.__init__(self, parent, -1, _("Naming specification help"),
                           style=wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER)

        panel = wx.Panel(self, -1)

        # key handling currently only works after mouse-clicking
        # the panel
        wx.EVT_BUTTON(self, self.closeId, self.OnClose)
        wx.EVT_CHAR(panel, self.handle_key)

        text1 = wx.StaticText(panel, -1,
                              _("You may use the following variables in the "
                                "filenaming\n"
                                "specifications in the options dialog:"))

        grid = wx.FlexGridSizer(cols=2, hgap=5)
        for (pat,desc) in formats:
            # creating bold labels should be easier...
            label_pat = wx.StaticText(panel, -1, pat)
            font = label_pat.GetFont()
            font.SetWeight(wx.BOLD)
            label_pat.SetFont(font)
            grid.Add(label_pat, 0, wx.ALIGN_RIGHT)
            grid.Add(wx.StaticText(panel, -1, _(desc)))
       
        sep = "/"
        if sys.platform == 'win32':
            sep = "\\"

        text2 = wx.StaticText(panel, -1,
                              _("A %s in the naming specification will create "
                                "a new subfolder.") % sep)
        
        button = wx.Button(panel, self.closeId, _("Close"))

        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(text1)
        sizer.Add((-1,5))
        sizer.Add(grid)
        sizer.Add((-1,5))
        sizer.Add(text2)
        sizer.Add((-1,5))

        # border required to draw default button properly with GTK
        sizer.Add(button, 0, wx.ALIGN_RIGHT|wx.ALL, border=8)

        panel.SetSizerAndFit(sizer)

        sizer2 = wx.BoxSizer(wx.VERTICAL)
        sizer2.Add(panel, 1, wx.EXPAND|wx.ALL, border=5)
        self.SetSizerAndFit(sizer2)

        #button.SetDefault()

    def OnClose(self, event):
        self.Close()

    def handle_key(self, event):
        if not event.HasModifiers() and event.GetKeyCode() == wx.WXK_ESCAPE:
            self.Show(False)
        else:
            event.Skip()
