# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Vollmert. All Rights Reserved.
# Portions Copyright (c) 2005 Lukas Lalinsky. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Vollmert, Lukas Lalinsky
#
#
# ***** END LICENSE BLOCK *****

import wx
from picard.ui.options.page import Page
from picard.ui.options.controls import TextDefaultCtrl
from tunepimp import tunepimp

class TagsPage(Page):

    name = N_("Tags")
    latin1Id = wx.NewId()
    utf8Id = wx.NewId()
    utf16Id = wx.NewId()
    id3v23Id = wx.NewId()

    def __init__(self, parent, config):
        Page.__init__(self, parent, config)

        wx.EVT_RADIOBUTTON(self, self.latin1Id, self.OnLatin1Button)
        wx.EVT_RADIOBUTTON(self, self.utf8Id, self.OnUTF8Button)
        wx.EVT_RADIOBUTTON(self, self.utf16Id, self.OnUTF16Button)
        wx.EVT_CHECKBOX(self, self.id3v23Id, self.OnID3v23Check)

        box = wx.StaticBox(self, -1, _("Tags"))
        sizer = wx.StaticBoxSizer(box, wx.VERTICAL)
        
        self.id3V1Check = wx.CheckBox(self, -1, 
                             _("Write ID3v1 tags to MP3 files (ID3v2 tags will always be written)"))
        self.id3V1Check.SetValue(self.config.settingWriteID3v1)
        self.clearTagsCheck = wx.CheckBox(self, -1, _("Clear existing tags before writing new tags"))
        self.clearTagsCheck.SetValue(self.config.settingClearTags)

        self.writeID3v23 = wx.CheckBox(self, self.id3v23Id, _("Write ID3v2 version 2.3 tags (2.4 is default)"))
        self.writeID3v23.SetValue(self.config.settingWriteID3v23)

        self.encodingText = wx.StaticText(self, -1, _("Text encoding to use while writing ID3 tags") + ":")
        self.hSizer = wx.BoxSizer(wx.HORIZONTAL)
        self.latin1Radio = wx.RadioButton(self, self.latin1Id, "Latin1 (ISO-8859-1)")
        self.utf8Radio = wx.RadioButton(self, self.utf8Id, "UTF-8 (" + _("ID3v2.4 only") + ")")
        self.utf16Radio = wx.RadioButton(self, self.utf16Id, "UTF-16")
        self.hSizer.Add(self.latin1Radio, 0, wx.LEFT, 15)
        self.hSizer.Add(self.utf8Radio, 0, wx.RIGHT | wx.LEFT, 5)
        self.hSizer.Add(self.utf16Radio, 0, wx.RIGHT | wx.LEFT,  5)

        self.encoding = self.config.settingID3Encoding
        self.latin1Radio.SetValue(self.config.settingID3Encoding == tunepimp.eLatin1)
        self.utf8Radio.SetValue(self.config.settingID3Encoding == tunepimp.eUTF8)
        self.utf16Radio.SetValue(self.config.settingID3Encoding == tunepimp.eUTF16)

        sizer.Add(self.id3V1Check, 0, wx.ALL, 5)
        sizer.Add(self.clearTagsCheck, 0, wx.ALL, 5)
        sizer.Add(self.writeID3v23, 0, wx.ALL, 5)
        sizer.Add(self.encodingText, 0, wx.ALL, 5)
        sizer.Add(self.hSizer, 0, wx.ALL, 5)
        
        self.content.Add(sizer, 0, wx.EXPAND)
        
        box = wx.StaticBox(self, -1, _("Custom fields"))
        sizer = wx.StaticBoxSizer(box, wx.VERTICAL)
        
        self.vaEdit = TextDefaultCtrl(self, desc=_("Various artists:"),
                                              value = self.config.settingVA,
                                              default = self.config.defaultVA)
        self.nonAlbumTracksEdit = TextDefaultCtrl(self, desc=_("Non-album tracks:"),
                                              value = self.config.settingNonAlbumTracks,
                                              default = self.config.defaultNonAlbumTracks)
        sizer.Add(self.vaEdit, 0, wx.EXPAND | wx.ALL, 5)
        sizer.Add(self.nonAlbumTracksEdit, 0, wx.EXPAND | wx.ALL, 5)

        self.content.Add(sizer, 0, wx.EXPAND | wx.TOP, 5)
        
        self.Fit()

        self.OnID3v23Check(None)

    def OnLatin1Button(self, event):
        self.encoding = tunepimp.eLatin1

    def OnUTF8Button(self, event):
        self.encoding = tunepimp.eUTF8

    def OnUTF16Button(self, event):
        self.encoding = tunepimp.eUTF16

    def OnID3v23Check(self, event):
        if self.writeID3v23.GetValue():
            if self.encoding == tunepimp.eUTF8:
                self.utf8Radio.SetValue(False)
                self.latin1Radio.SetValue(True)
            self.utf8Radio.Enable(False)
        else:
            self.utf8Radio.Enable(True)

    def save(self):
        self.config.settingWriteID3v1 = self.id3V1Check.GetValue()
        self.config.settingClearTags = self.clearTagsCheck.GetValue()
        self.config.settingWriteID3v23 = self.writeID3v23.GetValue()
        self.config.settingID3Encoding = self.encoding
        self.config.settingVA = self.vaEdit.GetValue()
        self.config.settingNonAlbumTracks = self.nonAlbumTracksEdit.GetValue()

