# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Kaye. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Kaye
#
#
# ***** END LICENSE BLOCK *****

import sys
import os
import locale
import wx
import urllib2
from tunepimp import tunepimp
from musicbrainz2.webservice import WebService
        
class StringConverter(object):
 
    def __init__(self, encoding):
        self.encoding = encoding

    def conv(self, text):

        if text.__class__.__name__ == 'int':
            text = unicode(text)

        if text.__class__.__name__ == 'unicode' and self.encoding != 'unicode':
            return text.encode(self.encoding)
        else:
            return text

class ConfigSettings(object):

    # Application defaults that might need to be reset during the application run
    defaultFileMask   = os.path.join(u"%albumartist", 
                        os.path.join(u"%album", u"%album-%0num-%track"))
    defaultVAFileMask = os.path.join(u"%albumartist",
                        os.path.join(u"%album", u"%album-%0num-%artist-%track"))
    defaultVA = u"Various Artists"                        
    defaultNonAlbumTracks = u"[non-album tracks]"                        
                        
    # Application settings that get read/written from/to the config file.
    # This section is also used to initialize the defaults for the settings.
    settingMoveFiles = False
    settingRenameFiles = True
    settingServer = u"musicbrainz.org"
    settingServerPort = 80
    settingMatchThreshold = 60
    settingAlbumLoadClusterMatchThreshold = .8
    settingFileMask = defaultFileMask 
    settingVAFileMask = defaultVAFileMask
    settingVA = defaultVA
    settingNonAlbumTracks = defaultNonAlbumTracks
    settingDestDir = u""
    settingAllowedChars = u""
    settingWriteID3v1 = True
    settingWriteID3v23 = False
    settingID3Encoding = tunepimp.eUTF8
    settingClearTags = False
    settingCDLookupDevice = u"/dev/cdrom"
    settingIOEncoding = u"utf-8"
    settingGoodMatchBGColor = wx.Colour(0xff, 0xff, 0xff)
    settingBadMatchBGColor = wx.Colour(0xda, 0x83, 0x83)
    settingFontColor = wx.Colour(0x00, 0x00, 0x00)
    settingLanguage = u""
    settingReloadAlbums = True
    settingArtistTranslation = False
    settingAutoAnalyze = False
    settingPUIDMatchThreshold = 40
    settingPUIDCollisionThreshold = 60
    settingUserName = u""
    settingUserPassword = u""
    settingUseProxyServer = False
    settingProxyServer = u""
    settingProxyServerPort = 80
    settingWinSafeFileNames = False

    # Application persistence value that get read/written from/to the config file
    persistDirControlPath = u""
    persistWindowGeometry = u"100,100,790,580"
    persistSplitterPos = 300
    persistFileSplitterPos = 200 
    persistColumnProps = u".5/.1/.4"
    persistAddFilePath = u""
    persistAddDirPath = u""
    persistClusterThreshold = 65
    persistOpenAlbums = u""

    persistOptionsSplitterPos = 140
    persistOptionsSize=u"620,420"
    
    # internal varables
    tagger = None
    tunePimp = None
    toolbar = None

    def __init__(self, config, appVersion):

        self.config = config
        self.appVersion = appVersion
        self.config.SetExpandEnvVars(False)

        if sys.platform == 'win32':
            self.settingIOEncoding = sys.getfilesystemencoding()
            encoding = locale.getpreferredencoding()
            try:
                self.persistDirControlPath = unicode(os.environ.get('HOMEDRIVE'), encoding) + \
                                             unicode(os.environ.get('HOMEPATH'), encoding)
            except:
                self.persistDirControlPath = unicode(os.environ.get('HOMEDRIVE'))
            settingCDLookupDevice = u""
        else:
            self.persistDirControlPath = unicode(os.environ.get('HOME'))

    def getAppName(self):
        return self.config.GetAppName()
            
    def getAppVersion(self):
        return self.appVersion

    def setTagger(self, tagger):
        self.tagger = tagger

    def setToolbar(self, toolbar):
        self.toolbar = toolbar

    def getTagger(self):
        return self.tagger

    def getStringConverter(self):
        return self.stringConverter

    def getTunePimp(self):
        return self.tunePimp

    def setTunePimp(self, tunePimp):
        self.tunePimp = tunePimp

    def getWebService(self):
        opener = None
        if self.settingUseProxyServer:
            netloc = 'http://%s:%s' % (self.settingProxyServer, self.settingProxyServerPort)
            opener = urllib2.build_opener(urllib2.ProxyHandler({'http': netloc}))
        ws = WebService(host=self.settingServer,
                        port=self.settingServerPort,
                        username=self.settingUserName,
                        password=self.settingUserPassword,
                        opener=opener)
        return ws
        
    def readSection(self, section):

        self.config.SetPath("/" + section)
        for item in ConfigSettings.__dict__:
           if item.startswith(section):
              attr = getattr(self, item)
              name = item[len(section):]
              if attr.__class__.__name__ == "bool" or attr.__class__.__name__ == "int":
                  attr = self.config.ReadInt(name, attr)
              else:
                  if attr.__class__.__name__ == "unicode":
                      # The Read function does something funky to backslashes --
                      # to avoid these problems we call unDoubleBackslashes()
                      # in order undo what we may have done with doubleBackSlashes()
                      if self.config.HasEntry(name):
                          new = self.config.Read(name, u"")
                          if sys.platform == 'win32':
                              new = self.unDoubleBackslashes(new)
                          attr = new 
                  else:
                      if attr.__class__.__name__ == "float":
                          attr = self.config.ReadFloat(name, attr)
                      else:
                          if attr.__class__.__name__ == "Colour":
                              if self.config.HasEntry(name):
                                  new = self.config.Read(name, u"")
                                  new = new[1:len(new)-1]
                                  tup = [int(x) for x in new.split(',')]
                                  attr = wx.Colour(tup[0], tup[1], tup[2])
                          else:
                              assert(0, "Unknown type (%s) for configuration setting %s." % (attr.__class__.__name__, attr))
              setattr(self, item, attr)

    def writeSection(self, section):

        self.config.SetPath("/" + section)
        for item in ConfigSettings.__dict__:
           if item.startswith(section):
              attr = getattr(self, item)
              name = item[len(section):]
              if attr.__class__.__name__ == "bool" or attr.__class__.__name__ == "int":
                  self.config.WriteInt(name, attr)
              else:
                  if attr.__class__.__name__ == "unicode":
                      # Sometimes single backslashes just vanish when calling Write,
                      # so for strings that are not pathnames, we double up on the backslashes
                      # which seems to help
                      if sys.platform == 'win32':
                          attr = self.doubleBackslashes(attr)
                      self.config.Write(name, attr)
                  else:
                      if attr.__class__.__name__ == "float":
                          self.config.WriteFloat(name, attr)
                      else:
                          if attr.__class__.__name__ == "str":
                              self.config.Write(name, unicode(attr))
                          else:
                              if attr.__class__.__name__ == "Colour":
                                  self.config.Write(name, u"[%d,%d,%d]" % (attr.Red(), attr.Green(), attr.Blue()))
                              else:
                                  assert(0, "Unknown type (%s) for configuration setting %s." % 
                                         (attr.__class__.__name__, attr))

    def readSettings(self):

        self.readSection("setting")
        self.readSection("persist")

    def writeSettings(self):

        self.writeSection("setting")
        self.writeSection("persist")
        self.config.Flush()

    def doubleBackslashes(self, str):

        if str[1:3] == ':\\':
            return str
       
        i = str.find('\\')
        while i >= 0:
            str = str[0:i] + '\\\\' + str[i+1:]
            i = str.find('\\', i + 2)

        return str

    def unDoubleBackslashes(self, str):
        return str.replace('\\\\', '\\')
