# -*- coding: utf-8 -*- 

# vim:set shiftwidth=4 tabstop=4 expandtab textwidth=79:
#Copyright (c) 2006 The PIDA Project 

#Permission is hereby granted, free of charge, to any person obtaining a copy
#of this software and associated documentation files (the "Software"), to deal
#in the Software without restriction, including without limitation the rights
#to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#copies of the Software, and to permit persons to whom the Software is
#furnished to do so, subject to the following conditions:

#The above copyright notice and this permission notice shall be included in
#all copies or substantial portions of the Software.

#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#SOFTWARE.

import gtk

from pida.core import actions
from pida.core.service import service, types, definitions as defs

class ApplicationController(service):
    """Service to house major actions."""

    @actions.action(stock_id=gtk.STOCK_QUIT, label=None,
                    default_accel='<Alt><Control>q')
    def act_quit_pida(self, action):
        """Quits the application"""
        self.boss.stop()

    def get_menu_definition(self):
        return """<menubar><menu name="base_file" action="base_file_menu">
                    <placeholder name="GlobalFileMenu">
                    <menuitem name="quit" action="appcontroller+quit_pida" />
                    </placeholder>
                   </menu></menubar>
                """

Service = ApplicationController
