
"""
    enum helper class
    ~~~~~~~~~~~~~~~~~

    >>> class Colors(Enum):
    ...     red, blue = 1, 2
    >>> print Colors.red
    Colors.red
    >>> Colors.blue
    <Colors.blue: 2>
    >>> int(Colors.blue)
    2

"""

class EnumInstance(object):
    """
    represets a enum value

    >>> a=EnumInstance("test","red",1)
    >>> str(a)
    'test.red'
    >>> int(a)
    1
    >>> 1==a
    True
    >>> EnumInstance("test","blue","blue")
    Traceback (most recent call last):
    ...
    AssertionError: only integers as enum values !

    """

    __slots__="classname name value".split()
    
    def __init__(self, classname, name, value):
        assert isinstance(value,int), "only integers as enum values !"
        self.classname = classname
        self.name = name
        self.value = value
    
    def __str__(self):
        return "%s.%s"%(self.classname, self.name)
    
    def __int__(self):
        return self.value

    def __eq__(self,other):
        if isinstance(other,int):
            return self.value==other
        elif isinstance(other,EnumInstance):
            return self.value==other.value
        else:
            return False
    
    def __repr__(self):
        return "<%s: %d>"%(self,self)


    def __hash__(self):
        return hash(self.value)

class EnumMeta(type):
    "Metaclass for Enums, ensures mixing enums and normal classes wont work"
    def __init__(cls, name, bases, fields):
        for base in bases:
            assert isinstance(base,EnumMeta), "cant join enums with non-enums"
        for k, v in fields.iteritems():
            if isinstance(v,int):
                setattr(cls,k,EnumInstance(name,k,v))
            else:
                setattr(cls,k,v)
        if "__doc__" in fields:
            print "DOCK !!!!"
   
class Enum:
    """
    base clas for enums

    >>> class test(Enum):
    ...     a, b = 1, 2
    >>> test.a
    <test.a: 1>
    >>> test.b
    <test.b: 2>
    """
    __metaclass__ = EnumMeta
