# -*- coding: utf-8 -*- 
# vim:set shiftwidth=4 tabstop=4 expandtab textwidth=79:
"""
    anyvcs file helpers
    ~~~~~~~~~~~~~~~~~~~

    :copyright: 2006 by Ronny Pfannschmidt

    :license: BSD License
"""
from enum import Enum
from os.path import dirname, basename

class State(Enum):
    """
    abuse it as enum
    """
    ignored, none, normal, nochange, \
    error, empty, new, \
    modified, conflict, removed, \
    missing, max = range(12)

class StatedFile(object):
    """
    stores status informations about files

    >>> StatedFile("a.txt", State.none)
    <StatedFile: a.txt :none>

    """

    __slots__ = "fullname path name state".split()
    
    def __init__(self,name,state):
        self.fullname = name
        self.path = dirname(name)
        self.name = basename(name)
        self.state = state
    
    def __repr__(self):
        return "<%s: %s :%s>"%(
                self.__class__.__name__,
                self.fullname,
                self.state.name)

    def __str__(self):
        return self.fullname
