# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python tools
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

import pgm

class Drawable(object):

    def __init__(self):
        object.__init__(self)
        self._position_offset=(0.0, 0.0, 0.0)
        self._opacity=self.widget_class.get_opacity(self)
        self._opacity_factor=1.0
        self._visible=self.widget_class.is_visible (self)
        self._parent_visibility=True

    def position__get(self):
        absolute_position = self.widget_class.get_position(self)
        relative_position = tuple(map(lambda x,y: x-y,
                                               absolute_position,
                                               self._position_offset))
        return relative_position


    def x__get(self):
        x = self.widget_class.get_position(self)[0]
        relative_x = x - self._position_offset[0]
        return relative_x


    def x__set(self, value):
        #FIXME : there is not set_x function in pigment.... need to add
        current_position = self.position
        current_position = (value, current_position[1], current_position[2])
        self.position = current_position


    def y__get(self):
        y = self.widget_class.get_position(self)[1]
        relative_y = y - self._position_offset[1]
        return relative_y


    def y__set(self, value):
        #FIXME : there is not set_x function in pigment.... need to add
        current_position = self.position
        current_position = (current_position[0], value, current_position[2])
        self.position = current_position


    def z__get(self):
        z = self.widget_class.get_position(self)[2]
        relative_z = z - self._position_offset[2]
        return relative_z


    def z__set(self, value):
        #FIXME : there is not set_x function in pigment.... need to add
        current_position = self.position
        current_position = (current_position[0], current_position[1], value)
        self.position = current_position


    def position__set(self, relative_position):
        absolute_position = tuple(map(lambda x,y: x+y,
                                               self._position_offset,
                                               relative_position))
        self.widget_class.set_position(self, absolute_position[0], absolute_position[1], absolute_position[2])


    def position_offset__get(self):
        return self._position_offset


    def position_offset__set(self, value):
        previous_position = self.position
        self._position_offset = value
        self.position = previous_position

    def opacity_factor_offset__set (self, factor):
        self._opacity_factor = factor
        self.opacity = self._opacity

    def x_offset__get(self):
        return self._position_offset[0]


    def y_offset__get(self):
        return self._position_offset[1]


    def z_offset__get(self):
        return self._position_offset[2]


    def x_offset__set(self, value):
        previous_position = self.position
        new_position = (value, previous_position[1], previous_position[2])
        self.position_offset = new_position


    def y_offset__set(self, value):
        previous_position = self.position
        new_position = (previous_position[0], value, previous_position[2])
        self.position_offset = new_position


    def z_offset__set(self, value):
        previous_position = self.position
        new_position = (previous_position[0], previous_position[1], value)
        self.position_offset = new_position

    def opacity__get(self):
        return self._opacity

    def opacity__set(self, value):
        self._opacity = value
        new_opacity = value * self._opacity_factor
        self.widget_class.set_opacity(self, int (new_opacity))

    def parent_visibility__get (self):
        return self._parent_visibility

    def parent_visibility__set (self, value):
        self._parent_visibility = value
        self.visible=self._visible

    def visible__get (self):
        return self.widget_class.is_visible(self)

    def visible__set(self, value):
        self._visible = value
        if self._visible and self._parent_visibility:
            self.widget_class.show(self)
        else:
            self.widget_class.hide(self)

    def size__set(self, value):
        self.widget_class.set_size(self, value[0], value[1])

    def size__get(self):
        return self.widget_class.get_size(self)


    position = property(position__get, position__set)
    position_offset = property(position_offset__get, position_offset__set)
    x_offset = property(x_offset__get, x_offset__set)
    y_offset = property(y_offset__get, y_offset__set)
    z_offset = property(z_offset__get, z_offset__set)
    opacity = property(opacity__get, opacity__set)
    visible = property(visible__get, visible__set)
    parent_visibility = property(parent_visibility__get, parent_visibility__set)
    size = property(size__get, size__set)
    x = property(x__get, x__set)
    y = property(y__get, y__set)
    z = property(z__get, z__set)
