# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python tools
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

"""
"""

from pypgmtools.utils import classinit, maths


class KeyFrame(object):
    """
    """

    # Allows property fget/fset/fdel/doc overriding
    __metaclass__ = classinit.ClassInitMeta
    __classinit__ = classinit.build_properties

    def __init__(self, value=None, time=0.0):
        self.value = value
        self.time = time

    def __repr__(self):
        return "<keyframe.KeyFrame(%r, %.2f)>" % (self._value, self._time)

    # Property definitions

    def value__get(self):
        """The value"""
        return self._value

    def value__set(self, value):
        self._value = value

    def time__get(self):
        """The time in the range [0.0, 1.0]"""
        return self._time

    def time__set(self, time):
        self._time = maths.clamp(time, 0.0, 1.0)
