/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment Boilerplate plugin
 *
 * Copyright © 2006, 2007 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_BP_VIEWPORT_H__
#define __PGM_BP_VIEWPORT_H__

#include <pgm/pgm.h>

G_BEGIN_DECLS

#define PGM_TYPE_BP_VIEWPORT (pgm_bp_viewport_get_type())
#define PGM_BP_VIEWPORT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_BP_VIEWPORT, PgmBpViewport))
#define PGM_BP_VIEWPORT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_BP_VIEWPORT, PgmBpViewportClass))
#define PGM_IS_BP_VIEWPORT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_BP_VIEWPORT))
#define PGM_IS_BP_VIEWPORT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_BP_VIEWPORT))
#define PGM_BP_VIEWPORT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_BP_VIEWPORT, PgmBpViewportClass))

typedef struct _PgmBpViewport      PgmBpViewport;
typedef struct _PgmBpViewportClass PgmBpViewportClass;

struct _PgmBpViewport {
  PgmViewport parent;

  GMutex   *mutex;
  gboolean  initialized;
};

struct _PgmBpViewportClass {
  PgmViewportClass parent_class;
};

GType        pgm_bp_viewport_get_type (void) G_GNUC_CONST;
PgmViewport *pgm_bp_viewport_new      (void);

G_END_DECLS

#endif /* __PGM_BP_VIEWPORT_H__ */
