/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment unit test for pgmviewport.c
 *
 * Copyright © 2006, 2007 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gst/check/gstcheck.h>
#include <pgm/pgm.h>

/* test default values */
GST_START_TEST (test_viewport_default_values)
{
  PgmViewport *viewport;
  PgmViewportFactory *factory;
  PgmError ret;
  gint width, height;
  PgmViewportCursor cursor;
  gboolean fullscreen;
  GdkPixbuf *icon;

  pgm_init (NULL, NULL);
  /* FIXME: ref count bug in pgm_viewport_factory_make(), see #105 */
  /*
  ret = pgm_viewport_factory_make ("boilerplate", &viewport);
  fail_if (ret != PGM_ERROR_OK, "viewport_factory_make error");
  */
  factory = pgm_viewport_factory_new ("boilerplate");
  ret = pgm_viewport_factory_create (factory, &viewport);
  fail_if (ret != PGM_ERROR_OK, "viewport_factory_create error");

  /* size */
  ret = pgm_viewport_get_size (viewport, &width, &height);
  fail_if (ret != PGM_ERROR_OK, "viewport_get_size error");
  fail_if (width != 800 || height != 600, "bad default size");

  /* cursor */
  ret = pgm_viewport_get_cursor (viewport, &cursor);
  fail_if (ret != PGM_ERROR_OK, "viewport_get_cursor error");
  fail_if (cursor != PGM_VIEWPORT_LEFT_ARROW, "bad default cursor");

  /* icon */
  ret = pgm_viewport_get_icon (viewport, &icon);
  fail_if (ret != PGM_ERROR_OK, "viewport_get_icon error");
  fail_if (icon != NULL, "bad default icon");

  /* fullscreen */
  ret = pgm_viewport_get_fullscreen (viewport, &fullscreen);
  fail_if (ret != PGM_ERROR_OK, "viewport_get_fullscreen error");
  fail_if (fullscreen != FALSE, "bad default fullscreen");

  gst_object_unref (GST_OBJECT_CAST (viewport));
  ASSERT_OBJECT_REFCOUNT (viewport, "viewport", 0);
  gst_object_unref (GST_OBJECT_CAST (factory));
  ASSERT_OBJECT_REFCOUNT (factory, "factory", 0);

  pgm_deinit ();
}
GST_END_TEST;

/* test set/get correctness */
GST_START_TEST (test_viewport_set_get_correctness)
{
  PgmViewport *viewport;
  PgmViewportFactory *factory;
  PgmError ret;
  gint width, height;
  PgmViewportCursor cursor;
  gboolean fullscreen;
  GdkPixbuf *icon_src, *icon;

  pgm_init (NULL, NULL);
  /* FIXME: ref count bug in pgm_viewport_factory_make(), see #105 */
  /*
  ret = pgm_viewport_factory_make ("boilerplate", &viewport);
  fail_if (ret != PGM_ERROR_OK, "viewport_factory_make error");
  */
  factory = pgm_viewport_factory_new ("boilerplate");
  ret = pgm_viewport_factory_create (factory, &viewport);
  fail_if (ret != PGM_ERROR_OK, "viewport_factory_create error");

  /* size */
  ret = pgm_viewport_set_size (viewport, 640, 480);
  fail_if (ret != PGM_ERROR_OK, "viewport_set_size error");
  ret = pgm_viewport_get_size (viewport, &width, &height);
  fail_if (ret != PGM_ERROR_OK, "viewport_get_size error");
  fail_if (width != 640 || height != 480, "size not set");

  /* cursor */
  ret = pgm_viewport_set_cursor (viewport, PGM_VIEWPORT_NONE);
  fail_if (ret != PGM_ERROR_OK, "viewport_set_cursor error");
  ret = pgm_viewport_get_cursor (viewport, &cursor);
  fail_if (ret != PGM_ERROR_OK, "viewport_get_cursor error");
  fail_if (cursor != PGM_VIEWPORT_NONE, "cursor not set");

  /* icon */
  icon_src = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, 32, 32);
  fail_if (icon_src == NULL, "problem in gdk_pixbuf_new");
  ret = pgm_viewport_set_icon (viewport, icon_src);
  fail_if (ret != PGM_ERROR_OK, "viewport_set_icon error");
  ret = pgm_viewport_get_icon (viewport, &icon);
  fail_if (ret != PGM_ERROR_OK, "viewport_get_icon error");
  fail_if (icon != icon_src, "icon not set");

  /* fullscreen */
  ret = pgm_viewport_set_fullscreen (viewport, TRUE);
  fail_if (ret != PGM_ERROR_OK, "viewport_set_fullscreen error");
  ret = pgm_viewport_get_fullscreen (viewport, &fullscreen);
  fail_if (ret != PGM_ERROR_OK, "viewport_get_fullscreen error");
  fail_if (fullscreen != TRUE, "fullscreen not set");

  gst_object_unref (GST_OBJECT_CAST (viewport));
  gst_object_unref (GST_OBJECT_CAST (factory));
  ASSERT_OBJECT_REFCOUNT (factory, "factory", 0);

  pgm_deinit ();
}
GST_END_TEST

Suite *
pgm_viewport_suite (void)
{
  Suite *s = suite_create ("PgmViewport");
  TCase *tc_chain = tcase_create ("pgmviewport tests");

  suite_add_tcase (s, tc_chain);
  tcase_add_test (tc_chain, test_viewport_default_values);
  tcase_add_test (tc_chain, test_viewport_set_get_correctness);

  return s;
}

GST_CHECK_MAIN (pgm_viewport);
