# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python tools unit tests
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

import unittest
import sys

from pypgmtools.graph.group import Group
from pypgmtools.graph.image import Image
from pypgmtools.widgets.list import List
import pgm
 
class TestList(unittest.TestCase):

    def test_image(self):
        canvas = pgm.Canvas()
        l = List(canvas, pgm.DRAWABLE_MIDDLE)
        img = Image()

        self.assertEqual(sys.getrefcount(l), 2)
        self.assertEqual(sys.getrefcount(img), 3)

        # adding img directly to the list _as a Group_
        l.add(img)
        self.assertEqual(sys.getrefcount(img), 4)

        # trying to add img again to the list _as a Group_
        l.add(img)
        self.assertEqual(sys.getrefcount(img), 4)

        # removing img from the list
        l.remove(img)
        self.assertEqual(sys.getrefcount(img), 3)

        # same but adding img to the canvas before adding it to the list _as a
        # Group_
        canvas.add(pgm.DRAWABLE_MIDDLE, img)
        self.assertEqual(sys.getrefcount(img), 3)

        l.add(img)
        self.assertEqual(sys.getrefcount(img), 4)
        l.remove(img)
        self.assertEqual(sys.getrefcount(img), 3)

        canvas.remove(img)
        self.assertEqual(sys.getrefcount(img), 3)


        # adding img directly to the list _as a List_
        l.append(img)
        # 4 references added: one for the Group, one for the List, two for the
        # implicitely animated object (implicit + one modifier)
        self.assertEqual(sys.getrefcount(img), 7)
        self.assertEqual(len(l.widgets), 1)
        self.assertEqual(len(l.animated_widgets), 1)

        # trying to add img again to the list _as a List_
        l.append(img)
        self.assertEqual(sys.getrefcount(img), 7)
        self.assertEqual(len(l.widgets), 1)
        self.assertEqual(len(l.animated_widgets), 1)

        # removing img from the list
        l.remove(img)
        self.assertEqual(len(l.widgets), 0)
        self.assertEqual(len(l.animated_widgets), 0)
        self.assertEqual(sys.getrefcount(img), 3)

    def test_group(self):
        canvas = pgm.Canvas()
        l = List(canvas, pgm.DRAWABLE_MIDDLE)
        g = Group(canvas, pgm.DRAWABLE_MIDDLE)

        self.assertEqual(sys.getrefcount(l), 2)
        self.assertEqual(sys.getrefcount(g), 2)

        # adding group directly to the list _as a List_
        l.append(g)
        self.assertEqual(sys.getrefcount(g), 8)
        self.assertEqual(len(l.widgets), 1)
        self.assertEqual(len(l.animated_widgets), 1)

        # removing group from the list
        l.remove(g)
        self.assertEqual(len(l.widgets), 0)
        self.assertEqual(len(l.animated_widgets), 0)
        self.assertEqual(sys.getrefcount(g), 2)

    def test_multiple(self):
        canvas = pgm.Canvas()
        l = List(canvas, pgm.DRAWABLE_MIDDLE)
        g = Group(canvas, pgm.DRAWABLE_MIDDLE)
        img = Image()

        self.assertEqual(sys.getrefcount(l), 2)
        self.assertEqual(sys.getrefcount(g), 2)
        self.assertEqual(sys.getrefcount(img), 3)

        # adding group directly to the list _as a List_
        l.append(g)
        l.append(img)
        self.assertEqual(sys.getrefcount(img), 7)
        self.assertEqual(sys.getrefcount(g), 8)
        self.assertEqual(len(l.widgets), 2)
        self.assertEqual(len(l.animated_widgets), 2)

        # removing img from the list
        l.remove(img)
        self.assertEqual(len(l.widgets), 1)
        self.assertEqual(len(l.animated_widgets), 1)
        self.assertEqual(sys.getrefcount(img), 3)

        # adding img to the group
        g.add(img)
        self.assertEqual(len(l.widgets), 1)
        self.assertEqual(len(l.animated_widgets), 1)
        self.assertEqual(sys.getrefcount(img), 4)
        self.assertEqual(sys.getrefcount(g), 8)

        # removing group from the list
        l.remove(g)
        self.assertEqual(len(l.widgets), 0)
        self.assertEqual(len(l.animated_widgets), 0)
        self.assertEqual(sys.getrefcount(l), 2)
        self.assertEqual(sys.getrefcount(g), 2)
        self.assertEqual(sys.getrefcount(img), 3)
