/***************************************************************************
 *            qof-expenses.h
 *
 *  Thu Oct 21 08:18:44 2004-2005
 *  Copyright  2004-2005  Neil Williams  <linux@codehelp.co.uk>
 ****************************************************************************/
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
/** @addtogroup QOF
	@{ */
/** @addtogroup Exp Expenses

	Like ::DB, Expenses uses UTC time within QOF and sets localtime when
	calling pilot-link code.

	\note pack_Expense still uses the old prototype
	using 0xffff instead of pi_buf->used. exp_pack has
	been modified to set pi_buf->used from the length returned
	by pack_Expense. Other databases already support pi_buffer
	and if expense is updated, this will need to be changed.

	@{ */
/** @file  qof-expenses.h
	@brief QOF expense definitions for pilot-link
	@author Copyright (c) 2004-2005 Neil Williams <linux@codehelp.co.uk>
*/

#ifndef _QOF_EXPENSES_H
#define _QOF_EXPENSES_H

#include <glib.h>
#include <qof.h>
#include "pilot-qof.h"
#include "pi-expense.h"
#include "qof-main.h"

#define PILOT_LINK_QOF_EXPENSES "pilot_expenses"
#define EXP_DATE      "expense_date"
#define EXP_TYPE      "type_of_expense"
#define EXP_PAYMENT   "form_of_payment"
#define EXP_CURRENCY  "currency_code"
#define EXP_AMOUNT    "expense_amount"
#define EXP_VENDOR    "expense_vendor"
#define EXP_CITY      "expense_city"
#define EXP_ATTENDEES "expense_attendees"
#define EXP_NOTE      "expense_note"
#define EXP_CATEGORY  "category"
#define EXP_DISTANCE  "distance_unit"

/** \brief Wraps QOF around Expense_t

This allows QOF to build as an option rather than adding QofInstance to
Expense_t and requiring QOF for all builds.

*/
typedef struct
{
	QofInstance inst;
	Expense_t wrap; // 0.12
	enum ExpenseDistance distance_unit;
	char *category;
} qof_exp;

/** \brief Register this object with QOF
*/
gboolean ExpensesRegister (void);

int exp_unpack(QofEntity *ent, gpointer user_data);
int exp_pack(QofEntity *ent, gpointer user_data);
int qof_exp_free(QofEntity *ent, gpointer user_data);
int exp_appinfo_unpack(QofEntity *ent, gpointer user_data);

/** \brief create a new object using QOF.
*/
qof_exp *expense_create (QofBook*);

#endif				/* _QOF_EXPENSES_H */

/** @} */
/** @} */
