/*
 */

#include "proto.h"
#include "../src/pimppa.h"

GtkWidget *InfoWindow=NULL;
GtkWidget *InfoText=NULL;

#define LOGWINSIZE_X    640
#define LOGWINSIZE_Y    480

static void
closeinfowindow(GtkWidget *widget, gpointer data)
{
	if(widget)
		gtk_widget_hide(widget);
}

int createinfowindow(gchar *dummy, gpointer visible)
{
	GtkAccelGroup *accel_grp;
	GtkWidget *vbox, *scrolled_window;

	if(InfoWindow)
	{
		if(visible)
			gtk_widget_show(InfoWindow);
		return(1);
	}
		
	InfoWindow=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	
	gtk_widget_set_usize(GTK_WIDGET(InfoWindow), LOGWINSIZE_X, LOGWINSIZE_Y);
	gtk_window_set_title(GTK_WINDOW(InfoWindow), "PIMPPA status/info window");
	
	gtk_signal_connect_object(GTK_OBJECT(InfoWindow), "delete_event",
		GTK_SIGNAL_FUNC(closeinfowindow),
		GTK_OBJECT(InfoWindow));
	gtk_signal_connect_object(GTK_OBJECT(InfoWindow), "destroy",
		GTK_SIGNAL_FUNC(closeinfowindow),
		GTK_OBJECT(InfoWindow));
	
	accel_grp=gtk_accel_group_new();
	gtk_window_add_accel_group(GTK_WINDOW(InfoWindow),accel_grp);
	
	vbox=gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 1);
	gtk_container_add(GTK_CONTAINER(InfoWindow), vbox);
	gtk_widget_show(vbox);

	scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
  		                            GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_box_pack_start(GTK_BOX(vbox),
   	                   scrolled_window, TRUE, TRUE, 0);
	gtk_widget_show(scrolled_window);

    InfoText=gtk_text_new (NULL, NULL);
    gtk_container_add(GTK_CONTAINER(scrolled_window), GTK_WIDGET(InfoText));
    gtk_widget_show(InfoText);
    gtk_widget_realize(InfoText);
    
	if(visible)
		gtk_widget_show(InfoWindow);

	return(1);
}
		
GtkWidget *note_dialog(const gchar * format,...) 
{
	GtkWidget *dialog, *label;
	va_list args;
	gchar *note;

	va_start(args, format);
	note = g_strdup_vprintf(format, args);
	va_end(args);

	
	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), _("Note"));
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	label=gtk_label_new(note);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), label,
 						FALSE,FALSE,0);
	gtk_widget_show_all(dialog);
	
	while(gtk_events_pending())
		gtk_main_iteration(); 

	return(dialog);
}

void my_error_dialog(const gchar * format,...) {
  GtkWidget *dialog;
  va_list args;
  gchar *error;

  va_start(args, format);
  error = g_strdup_vprintf(format, args);
  va_end(args);

  dialog = gnome_error_dialog(error);
  gnome_dialog_run(GNOME_DIALOG (dialog));
  g_free(error);
}

