/*********************************************************************
 *                
 * Copyright (C) 2004-2005,  Karlsruhe University
 *                
 * File path:     bench/pingpong/amd64.h
 * Description:   AMD64 specific pingpong functions
 *                
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *                
 * $Id: amd64.h,v 1.2.2.2 2005/06/24 14:56:35 stoess Exp $
 *                
 ********************************************************************/
#include <l4/arch.h>

//#define HAVE_ARCH_SPECIFIC
#define HAVE_ARCH_IPC
#define HAVE_HANDLE_ARCH_PAGEFAULT
#define HAVE_READ_CYCLES
//#define HAVE_ARCH_SPECIFIC

#define L4_REQUEST_MASK		( ~((~0UL) >> ((sizeof (L4_Word_t) * 8) - 20)))

#define L4_IO_PAGEFAULT		(-8UL << 20)
#define L4_IO_PORT_START	(0)
#define L4_IO_PORT_END		(1<<16)

L4_INLINE L4_Word_t read_cycles (void)
{
    L4_Word32_t __eax, __edx;

    asm volatile (
	"rdtsc"
	: "=a"(__eax), "=d"(__edx));
    
    return ( (((L4_Word_t) __edx) << 32) | ( (L4_Word_t) __eax));	     
}


L4_Fpage_t handle_arch_pagefault (L4_MsgTag_t tag, L4_Word_t faddr, L4_Word_t fip, L4_Word_t log2size)
{
    // If pagefault is an IO-Page, return that IO Fpage 
    if ((tag.raw & L4_REQUEST_MASK) == L4_IO_PAGEFAULT && L4_IsIoFpage(faddr))
    {
	L4_Fpage_t ret = { raw : faddr };
	//printf("pingpong: pager maps IO-Page %x\n", (int) ret.raw); 
	return ret;
    }
	
    return L4_FpageLog2 (faddr, log2size);
}


void arch_specific (void)
{
    L4_Word_t cycles1, cycles2;
    L4_Clock_t usec1, usec2;
    L4_Word_t tot = 1000, i;

    i = tot;
    
    usec1 = L4_SystemClock();
    cycles1 = read_cycles();

    while (i--)
	//L4_Nop();
    
    usec2 = L4_SystemClock();
    cycles2 = read_cycles();

    
    printf( "\nNULL system call: %ld cycles1, %ld usec\n",
	    ((cycles2-cycles1)/tot),((usec2-usec1).raw)/tot);
}

L4_INLINE L4_Word_t pingpong_ipc (L4_ThreadId_t dest, L4_Word_t untyped)
{
    L4_Word_t dummy;
    __asm__ __volatile__ (
	"/* pingpong_arch_ipc() */\n"
	"movq   %%rax, %%r9	\n"
	"xorq	%%r8, %%r8	\n"
	"pushq	%%rbp		\n"
	"call	*__L4_Ipc	\n"	/* jump via KIP */
	"popq	%%rbp		\n"
	"movq   %%r9, %%rax	\n"
	: "=S" (dummy), 
	  "=a" (untyped),
	  "=d" (dest)
	: "a" (untyped), 
	  "d" (dest), 
	  "S" (dest), 
	  "D" (__L4_X86_Utcb())
	: "rbx", "rcx", "r8", "r9", "r10", "r11", "r12", "r13", "r14", "r15");

    return untyped;
}

