sub DB_Open()
{
    # Initialize table list :
  %db_table_type=(
    'Hearbeat'		=> '0',
    'Alert'		=> '1',

    'Action'		=> '2',
    'Address'		=> '2.2',
    'Assessment'	=> '2',
    'Classification'	=> '2',
    'Confidence'	=> '2',
    'DetectTime'	=> '2',
    'FileList'		=> '2',
    'File'		=> '2',
    'FileAccess'	=> '2',
    'Impact'		=> '2',
    'Inode'		=> '2',
    'Linkage'		=> '2',
    'Node'		=> '2.1',
    'Process'		=> '2.1',
    'ProcessArg'	=> '2',
    'ProcessEnv'	=> '2',
    'SNMPService'	=> '2',
    'Service'           => '2.1',
    'ServicePortlist'	=> '2',
    'Source'		=> '2',
    'Target'		=> '2',
    'User'		=> '2',
    'UserId'		=> '2',
    'WebService'	=> '2',
    'WebServiceArg'	=> '2',

    'AdditionalData'	=> '3.1',
    'Analyzer'		=> '3',
    'AnalyzerTime'	=> '3.1',
    'CreateTime'	=> '3',
  );

  # 0 : no link to an Alert
  # 1 : Alert itself	=> ident=?
  # 2 : Alert child only	=> alert_ident=?
  # 3 : X child		=> parent_type='A' AND parent_ident=?

  if (!$conf{'nb_resbypage'}) {$conf{'nb_resbypage'}=30;};
  if (!defined($conf{'nb_resbygroup'})) {$conf{'nb_resbygroup'}=5;};
  if (!$conf{'nb_topattack*s'}) {$conf{'nb_topattack*s'}=15;};

  if (!$conf{'GMTdiff'}) {$conf{'GMTdiff'}=0;};

  my $cstring="DBI:$conf{'dbtype'}:";

  if (!$conf{'dbhost'}) {$conf{'dbhost'}='localhost';};
  if (!$conf{'dbname'}) {$conf{'dbname'}='prelude'};
  if (!$conf{'dblogin'}) {$conf{'dblogin'}='prelude'};

  if ($conf{'dbtype'} =~ m/^mysql$/i)
  {
    $cstring.="database=$conf{'dbname'};host=$conf{'dbhost'}";
    if ($conf{'dbport'}) {$cstring.=";port=$conf{'dbport'}";};
    if ($conf{'dboptions'})
    {
      $cstring.=";options=$conf{'dboptions'}";
    }
  }

  if ($conf{'dbtype'} =~ m/^pg$/i)
  {
    $cstring.="dbname=$conf{'dbname'};host=$conf{'dbhost'}";
    if ($conf{'dbport'}) {$cstring.=";port=$conf{'dbport'};";};
    if ($conf{'dboptions'})
    {
      $cstring.="options=$conf{'dboptions'}";
    }
  }

    # Open DB connection :
  return DBI->connect($cstring,$conf{'dblogin'},$conf{'dbpasswd'}) || DB_CONNECT_ERROR(DBI->errstr);
}

sub DB_CONNECT_ERROR($)
{
	error( 'Problem connecting to DB : '.shift()."\n" );
	exit;
}

sub get($)
{
	my $Path = shift;

	my $Field;
	( $Path, $Field ) = split( /\./, $Path );
	if ( ! exists( $Cache{$Path} ) )
	{
		my %tmp;
		if ( $Path eq 'Alert' )
		{
			%tmp = ( 'ident', $AlertId );
		}
		else
		{
			%tmp = get_Data( $Path, $AlertId, 'FIRST' );
		}
		$Cache{$Path} = \%tmp;
	}

	return $Cache{$Path}->{$Field};
}

sub LIMIT_sql()
{
  if ($conf{'dbtype'} =~ m/^mysql$/i)
  {
    return 'LIMIT ?,?';
  }

  if ($conf{'dbtype'} =~ m/^pg$/i)
  {
    return 'LIMIT ? OFFSET ?';
  }
}

sub LIMIT_values($$$)
{
  my $Sth=shift;
  my $Nb=shift;
  my $Offset=shift;

  if ($conf{'dbtype'} =~ m/^mysql$/i)
  {
    $Sth->bind_param(1,$Offset, { TYPE => DBI::SQL_INTEGER } );
    $Sth->bind_param(2,$Nb, {TYPE => DBI::SQL_INTEGER } );
  }

  if ($conf{'dbtype'} =~ m/^pg$/i)
  {
    $Sth->bind_param(2,$Offset,{ TYPE => DBI::SQL_INTEGER } );
    $Sth->bind_param(1,$Nb,{ TYPE => DBI::SQL_INTEGER } );
  }
}

sub get_Data($$$)
{
  my $Path=shift;
  my $AlertID=int(shift);
  my $Type=shift;

    # Get table list from Data Path :
  my @Tables=split(/\//,$Path);

    # Build Table name : (the one which contains information we want)
  my $LastTable='Prelude_'.$Tables[$#Tables];

  my $Statement="SELECT * FROM $LastTable WHERE alert_ident=?";

  if ($db_table_type{$Tables[$#Tables]} =~ m/\.(\d)$/)
  {
    $Statement.=" AND parent_type='".substr($Tables[$#Tables-$1],0,1)."'";
  }

  if ($db_table_type{$Tables[$#Tables]} =~ m/^3/)
  {
      # For type 3 tables, Alert ident is parent_ident :
    $Statement =~ s/alert_/parent_/;
  }

  $Statement.=';';

  my $Sth=$dbh->prepare($Statement);
  $Sth->execute($AlertID);
  my $RowsNb=$Sth->rows();
  my @Result=($RowsNb);
  if ($RowsNb)
  {
    my $First=1;
    my @Fields;
    while(my $Hash=$Sth->fetchrow_hashref())
    {
      if ($First)
      {
          # Build field list :
        foreach my $Field (keys %{$Hash}) {push @Fields,$Field;};
          # Result would contain field number followed by fields :
        @Result=($RowsNb,$#Fields+1,@Fields);

        $First=0;
      }

        # Add values of each line to results :
      foreach my $Field (@Fields) {push @Result,$Hash->{$Field};};
    }
  }

  $Sth->finish();

  if (!defined($Type)) {$Type='FIRST';};
  if ($Type eq 'FIRST')
  {
    return get_DataLine(\@Result,1);
  }
  else
  {
    return @Result;
  }
}

sub get_DataLine($$)
{
  my $ArrayRef=shift;
  my $LineNum=shift;

  my $LineNb=$ArrayRef->[0];if (!$LineNb) {return '-','';};
  my $FieldNb=$ArrayRef->[1];

  my $Offset=2+$LineNum*$FieldNb;
  my %Hash;
  for(my $i=0;$i<$FieldNb;$i++)
  {
    $Hash{$ArrayRef->[2+$i]}=$ArrayRef->[$Offset+$i];
  }

  return %Hash;
}

1;
