/* Copyright (c) 2001-2007, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

// Automatically generated from template - EDITS WILL BE LOST

package com.pixelmed.dicom;

import java.util.HashMap;
import java.util.TreeSet;
import java.util.Iterator;

/**
 * <p>The {@link com.pixelmed.dicom.DicomDictionary DicomDictionary} class
 * is a complete standard dictionary of DICOM attributes and associated information.</p>
 *
 * <p>The accessor methods that an application would normally use are defined in the
 * {@link com.pixelmed.dicom.DicomDictionaryBase DicomDictionaryBase} class.</p>
 *
 * @author	dclunie
 */

public class DicomDictionary extends DicomDictionaryBase {

	private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomDictionary.java,v 1.58 2009/10/29 16:08:56 dclunie Exp $";

	protected void createTagList() {

		tagList = new TreeSet();	// sorted, based on AttributeTag's implementation of Comparable

		tagList.add(TagFromName.CommandGroupLength);
		tagList.add(TagFromName.CommandLengthToEnd);
		tagList.add(TagFromName.AffectedSOPClassUID);
		tagList.add(TagFromName.RequestedSOPClassUID);
		tagList.add(TagFromName.CommandRecognitionCode);
		tagList.add(TagFromName.CommandField);
		tagList.add(TagFromName.MessageID);
		tagList.add(TagFromName.MessageIDBeingRespondedTo);
		tagList.add(TagFromName.Initiator);
		tagList.add(TagFromName.Receiver);
		tagList.add(TagFromName.FindLocation);
		tagList.add(TagFromName.MoveDestination);
		tagList.add(TagFromName.Priority);
		tagList.add(TagFromName.DataSetType);
		tagList.add(TagFromName.NumberOfMatches);
		tagList.add(TagFromName.ResponseSequenceNumber);
		tagList.add(TagFromName.Status);
		tagList.add(TagFromName.OffendingElement);
		tagList.add(TagFromName.ErrorComment);
		tagList.add(TagFromName.ErrorID);
		tagList.add(TagFromName.AffectedSOPInstanceUID);
		tagList.add(TagFromName.RequestedSOPInstanceUID);
		tagList.add(TagFromName.EventTypeID);
		tagList.add(TagFromName.AttributeIdentifierList);
		tagList.add(TagFromName.ActionTypeID);
		tagList.add(TagFromName.NumberOfRemainingSuboperations);
		tagList.add(TagFromName.NumberOfCompletedSuboperations);
		tagList.add(TagFromName.NumberOfFailedSuboperations);
		tagList.add(TagFromName.NumberOfWarningSuboperations);
		tagList.add(TagFromName.MoveOriginatorApplicationEntityTitle);
		tagList.add(TagFromName.MoveOriginatorMessageID);
		tagList.add(TagFromName.DialogReceiver);
		tagList.add(TagFromName.TerminalType);
		tagList.add(TagFromName.MessageSetID);
		tagList.add(TagFromName.EndMessageSet);
		tagList.add(TagFromName.DisplayFormat);
		tagList.add(TagFromName.PagePositionID);
		tagList.add(TagFromName.TextFormatID);
		tagList.add(TagFromName.NormalReverse);
		tagList.add(TagFromName.AddGrayScale);
		tagList.add(TagFromName.Borders);
		tagList.add(TagFromName.Copies);
		tagList.add(TagFromName.OldMagnificationType);
		tagList.add(TagFromName.Erase);
		tagList.add(TagFromName.Print);
		tagList.add(TagFromName.Overlays);
		tagList.add(TagFromName.FileMetaInformationGroupLength);
		tagList.add(TagFromName.FileMetaInformationVersion);
		tagList.add(TagFromName.MediaStorageSOPClassUID);
		tagList.add(TagFromName.MediaStorageSOPInstanceUID);
		tagList.add(TagFromName.TransferSyntaxUID);
		tagList.add(TagFromName.ImplementationClassUID);
		tagList.add(TagFromName.ImplementationVersionName);
		tagList.add(TagFromName.SourceApplicationEntityTitle);
		tagList.add(TagFromName.PrivateInformationCreatorUID);
		tagList.add(TagFromName.PrivateInformation);
		tagList.add(TagFromName.FileSetID);
		tagList.add(TagFromName.FileSetDescriptorFileID);
		tagList.add(TagFromName.FileSetCharacterSet);
		tagList.add(TagFromName.RootDirectoryFirstRecord);
		tagList.add(TagFromName.RootDirectoryLastRecord);
		tagList.add(TagFromName.FileSetConsistencyFlag);
		tagList.add(TagFromName.DirectoryRecordSequence);
		tagList.add(TagFromName.NextDirectoryRecordOffset);
		tagList.add(TagFromName.RecordInUseFlag);
		tagList.add(TagFromName.LowerLevelDirectoryOffset);
		tagList.add(TagFromName.DirectoryRecordType);
		tagList.add(TagFromName.PrivateRecordUID);
		tagList.add(TagFromName.ReferencedFileID);
		tagList.add(TagFromName.MRDRDirectoryRecordOffset);
		tagList.add(TagFromName.ReferencedSOPClassUIDInFile);
		tagList.add(TagFromName.ReferencedSOPInstanceUIDInFile);
		tagList.add(TagFromName.ReferencedTransferSyntaxUIDInFile);
		tagList.add(TagFromName.ReferencedRelatedGeneralSOPClassUIDInFile);
		tagList.add(TagFromName.NumberOfReferences);
		tagList.add(TagFromName.LengthToEnd);
		tagList.add(TagFromName.SpecificCharacterSet);
		tagList.add(TagFromName.LanguageCodeSequence);
		tagList.add(TagFromName.ImageType);
		tagList.add(TagFromName.RecognitionCode);
		tagList.add(TagFromName.InstanceCreationDate);
		tagList.add(TagFromName.InstanceCreationTime);
		tagList.add(TagFromName.InstanceCreatorUID);
		tagList.add(TagFromName.SOPClassUID);
		tagList.add(TagFromName.SOPInstanceUID);
		tagList.add(TagFromName.RelatedGeneralSOPClassUID);
		tagList.add(TagFromName.OriginalSpecializedSOPClassUID);
		tagList.add(TagFromName.StudyDate);
		tagList.add(TagFromName.SeriesDate);
		tagList.add(TagFromName.AcquisitionDate);
		tagList.add(TagFromName.ContentDate);
		tagList.add(TagFromName.OverlayDate);
		tagList.add(TagFromName.CurveDate);
		tagList.add(TagFromName.AcquisitionDateTime);
		tagList.add(TagFromName.StudyTime);
		tagList.add(TagFromName.SeriesTime);
		tagList.add(TagFromName.AcquisitionTime);
		tagList.add(TagFromName.ContentTime);
		tagList.add(TagFromName.OverlayTime);
		tagList.add(TagFromName.CurveTime);
		tagList.add(TagFromName.OldDataSetType);
		tagList.add(TagFromName.OldDataSetSubtype);
		tagList.add(TagFromName.NuclearMedicineSeriesTypeRetired);
		tagList.add(TagFromName.AccessionNumber);
		tagList.add(TagFromName.IssuerOfAccessionNumberSequence);
		tagList.add(TagFromName.QueryRetrieveLevel);
		tagList.add(TagFromName.RetrieveAETitle);
		tagList.add(TagFromName.InstanceAvailability);
		tagList.add(TagFromName.FailedSOPInstanceUIDList);
		tagList.add(TagFromName.Modality);
		tagList.add(TagFromName.ModalitiesInStudy);
		tagList.add(TagFromName.SOPClassesInStudy);
		tagList.add(TagFromName.ConversionType);
		tagList.add(TagFromName.PresentationIntentType);
		tagList.add(TagFromName.Manufacturer);
		tagList.add(TagFromName.InstitutionName);
		tagList.add(TagFromName.InstitutionAddress);
		tagList.add(TagFromName.InstitutionCodeSequence);
		tagList.add(TagFromName.ReferringPhysicianName);
		tagList.add(TagFromName.ReferringPhysicianAddress);
		tagList.add(TagFromName.ReferringPhysicianTelephoneNumber);
		tagList.add(TagFromName.ReferringPhysicianIdentificationSequence);
		tagList.add(TagFromName.CodeValue);
		tagList.add(TagFromName.CodingSchemeDesignator);
		tagList.add(TagFromName.CodingSchemeVersion);
		tagList.add(TagFromName.CodeMeaning);
		tagList.add(TagFromName.MappingResource);
		tagList.add(TagFromName.ContextGroupVersion);
		tagList.add(TagFromName.ContextGroupLocalVersion);
		tagList.add(TagFromName.ContextGroupExtensionFlag);
		tagList.add(TagFromName.CodingSchemeUID);
		tagList.add(TagFromName.ContextGroupExtensionCreatorUID);
		tagList.add(TagFromName.ContextIdentifier);
		tagList.add(TagFromName.CodingSchemeIdentificationSequence);
		tagList.add(TagFromName.CodingSchemeRegistry);
		tagList.add(TagFromName.CodingSchemeExternalID);
		tagList.add(TagFromName.CodingSchemeName);
		tagList.add(TagFromName.CodingSchemeResponsibleOrganization);
		tagList.add(TagFromName.ContextUID);
		tagList.add(TagFromName.TimezoneOffsetFromUTC);
		tagList.add(TagFromName.NetworkID);
		tagList.add(TagFromName.StationName);
		tagList.add(TagFromName.StudyDescription);
		tagList.add(TagFromName.ProcedureCodeSequence);
		tagList.add(TagFromName.SeriesDescription);
		tagList.add(TagFromName.InstitutionalDepartmentName);
		tagList.add(TagFromName.PhysicianOfRecord);
		tagList.add(TagFromName.PhysicianOfRecordIdentificationSequence);
		tagList.add(TagFromName.PerformingPhysicianName);
		tagList.add(TagFromName.PerformingPhysicianIdentificationSequence);
		tagList.add(TagFromName.PhysicianReadingStudy);
		tagList.add(TagFromName.PhysicianReadingStudyIdentificationSequence);
		tagList.add(TagFromName.OperatorName);
		tagList.add(TagFromName.OperatorIdentificationSequence);
		tagList.add(TagFromName.AdmittingDiagnosesDescription);
		tagList.add(TagFromName.AdmittingDiagnosesCodeSequence);
		tagList.add(TagFromName.ManufacturerModelName);
		tagList.add(TagFromName.ReferencedResultsSequence);
		tagList.add(TagFromName.ReferencedStudySequence);
		tagList.add(TagFromName.ReferencedPerformedProcedureStepSequence);
		tagList.add(TagFromName.ReferencedSeriesSequence);
		tagList.add(TagFromName.ReferencedPatientSequence);
		tagList.add(TagFromName.ReferencedVisitSequence);
		tagList.add(TagFromName.ReferencedOverlaySequence);
		tagList.add(TagFromName.ReferencedStereometricInstanceSequence);
		tagList.add(TagFromName.ReferencedWaveformSequence);
		tagList.add(TagFromName.ReferencedImageSequence);
		tagList.add(TagFromName.ReferencedCurveSequence);
		tagList.add(TagFromName.ReferencedInstanceSequence);
		tagList.add(TagFromName.ReferencedRealWorldValueMappingInstanceSequence);
		tagList.add(TagFromName.ReferencedSOPClassUID);
		tagList.add(TagFromName.ReferencedSOPInstanceUID);
		tagList.add(TagFromName.SOPClassesSupported);
		tagList.add(TagFromName.ReferencedFrameNumber);
		tagList.add(TagFromName.TransactionUID);
		tagList.add(TagFromName.FailureReason);
		tagList.add(TagFromName.FailedSOPSequence);
		tagList.add(TagFromName.ReferencedSOPSequence);
		tagList.add(TagFromName.StudiesContainingOtherReferencedInstancesSequence);
		tagList.add(TagFromName.RelatedSeriesSequence);
		tagList.add(TagFromName.OldLossyImageCompression);
		tagList.add(TagFromName.DerivationDescription);
		tagList.add(TagFromName.SourceImageSequence);
		tagList.add(TagFromName.StageName);
		tagList.add(TagFromName.StageNumber);
		tagList.add(TagFromName.NumberOfStages);
		tagList.add(TagFromName.ViewName);
		tagList.add(TagFromName.ViewNumber);
		tagList.add(TagFromName.NumberOfEventTimers);
		tagList.add(TagFromName.NumberOfViewsInStage);
		tagList.add(TagFromName.EventElapsedTime);
		tagList.add(TagFromName.EventTimerName);
		tagList.add(TagFromName.EventTimerSequence);
		tagList.add(TagFromName.EventTimeOffset);
		tagList.add(TagFromName.EventCodeSequence);
		tagList.add(TagFromName.StartTrim);
		tagList.add(TagFromName.StopTrim);
		tagList.add(TagFromName.RecommendedDisplayFrameRate);
		tagList.add(TagFromName.TransducerPosition);
		tagList.add(TagFromName.TransducerOrientation);
		tagList.add(TagFromName.AnatomicStructure);
		tagList.add(TagFromName.AnatomicRegionSequence);
		tagList.add(TagFromName.AnatomicRegionModifierSequence);
		tagList.add(TagFromName.PrimaryAnatomicStructureSequence);
		tagList.add(TagFromName.AnatomicStructureSpaceOrRegionSequence);
		tagList.add(TagFromName.PrimaryAnatomicStructureModifierSequence);
		tagList.add(TagFromName.TransducerPositionSequence);
		tagList.add(TagFromName.TransducerPositionModifierSequence);
		tagList.add(TagFromName.TransducerOrientationSequence);
		tagList.add(TagFromName.TransducerOrientationModifierSequence);
		tagList.add(TagFromName.AnatomicStructureSpaceOrRegionCodeSequenceTrial);
		tagList.add(TagFromName.AnatomicPortalOfEntranceCodeSequenceTrial);
		tagList.add(TagFromName.AnatomicApproachDirectionCodeSequenceTrial);
		tagList.add(TagFromName.AnatomicPerspectiveDescriptionTrial);
		tagList.add(TagFromName.AnatomicPerspectiveCodeSequenceTrial);
		tagList.add(TagFromName.AnatomicLocationOfExaminingInstrumentDescriptionTrial);
		tagList.add(TagFromName.AnatomicLocationOfExaminingInstrumentCodeSequenceTrial);
		tagList.add(TagFromName.AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial);
		tagList.add(TagFromName.OnAxisBackgroundAnatomicStructureCodeSequenceTrial);
		tagList.add(TagFromName.AlternateRepresentationSequence);
		tagList.add(TagFromName.IrradiationEventUID);
		tagList.add(TagFromName.IdentifyingComments);
		tagList.add(TagFromName.FrameType);
		tagList.add(TagFromName.ReferencedImageEvidenceSequence);
		tagList.add(TagFromName.ReferencedRawDataSequence);
		tagList.add(TagFromName.CreatorVersionUID);
		tagList.add(TagFromName.DerivationImageSequence);
		tagList.add(TagFromName.SourceImageEvidenceSequence);
		tagList.add(TagFromName.PixelPresentation);
		tagList.add(TagFromName.VolumetricProperties);
		tagList.add(TagFromName.VolumeBasedCalculationTechnique);
		tagList.add(TagFromName.ComplexImageComponent);
		tagList.add(TagFromName.AcquisitionContrast);
		tagList.add(TagFromName.DerivationCodeSequence);
		tagList.add(TagFromName.ReferencedPresentationStateSequence);
		tagList.add(TagFromName.ReferencedOtherPlaneSequence);
		tagList.add(TagFromName.FrameDisplaySequence);
		tagList.add(TagFromName.RecommendedDisplayFrameRateInFloat);
		tagList.add(TagFromName.SkipFrameRangeFlag);
		tagList.add(TagFromName.PatientName);
		tagList.add(TagFromName.PatientID);
		tagList.add(TagFromName.IssuerOfPatientID);
		tagList.add(TagFromName.TypeOfPatientID);
		tagList.add(TagFromName.IssuerOfPatientIDQualifiersSequence);
		tagList.add(TagFromName.PatientBirthDate);
		tagList.add(TagFromName.PatientBirthTime);
		tagList.add(TagFromName.PatientSex);
		tagList.add(TagFromName.PatientInsurancePlanCodeSequence);
		tagList.add(TagFromName.PatientPrimaryLanguageCodeSequence);
		tagList.add(TagFromName.PatientPrimaryLanguageModifierCodeSequence);
		tagList.add(TagFromName.OtherPatientID);
		tagList.add(TagFromName.OtherPatientName);
		tagList.add(TagFromName.OtherPatientIDSequence);
		tagList.add(TagFromName.PatientBirthName);
		tagList.add(TagFromName.PatientAge);
		tagList.add(TagFromName.PatientSize);
		tagList.add(TagFromName.PatientWeight);
		tagList.add(TagFromName.PatientAddress);
		tagList.add(TagFromName.InsurancePlanIdentification);
		tagList.add(TagFromName.PatientMotherBirthName);
		tagList.add(TagFromName.MilitaryRank);
		tagList.add(TagFromName.BranchOfService);
		tagList.add(TagFromName.MedicalRecordLocator);
		tagList.add(TagFromName.MedicalAlerts);
		tagList.add(TagFromName.Allergies);
		tagList.add(TagFromName.CountryOfResidence);
		tagList.add(TagFromName.RegionOfResidence);
		tagList.add(TagFromName.PatientTelephoneNumber);
		tagList.add(TagFromName.EthnicGroup);
		tagList.add(TagFromName.Occupation);
		tagList.add(TagFromName.SmokingStatus);
		tagList.add(TagFromName.AdditionalPatientHistory);
		tagList.add(TagFromName.PregnancyStatus);
		tagList.add(TagFromName.LastMenstrualDate);
		tagList.add(TagFromName.PatientReligiousPreference);
		tagList.add(TagFromName.PatientSpeciesDescription);
		tagList.add(TagFromName.PatientSpeciesCodeSequence);
		tagList.add(TagFromName.PatientSexNeutered);
		tagList.add(TagFromName.PatientBreedDescription);
		tagList.add(TagFromName.PatientBreedCodeSequence);
		tagList.add(TagFromName.BreedRegistrationSequence);
		tagList.add(TagFromName.BreedRegistrationNumber);
		tagList.add(TagFromName.BreedRegistryCodeSequence);
		tagList.add(TagFromName.ResponsiblePerson);
		tagList.add(TagFromName.ResponsiblePersonRole);
		tagList.add(TagFromName.ResponsibleOrganization);
		tagList.add(TagFromName.PatientComments);
		tagList.add(TagFromName.ExaminedBodyThickness);
		tagList.add(TagFromName.ClinicalTrialSponsorName);
		tagList.add(TagFromName.ClinicalTrialProtocolID);
		tagList.add(TagFromName.ClinicalTrialProtocolName);
		tagList.add(TagFromName.ClinicalTrialSiteID);
		tagList.add(TagFromName.ClinicalTrialSiteName);
		tagList.add(TagFromName.ClinicalTrialSubjectID);
		tagList.add(TagFromName.ClinicalTrialSubjectReadingID);
		tagList.add(TagFromName.ClinicalTrialTimePointID);
		tagList.add(TagFromName.ClinicalTrialTimePointDescription);
		tagList.add(TagFromName.ClinicalTrialCoordinatingCenterName);
		tagList.add(TagFromName.PatientIdentityRemoved);
		tagList.add(TagFromName.DeidentificationMethod);
		tagList.add(TagFromName.DeidentificationMethodCodeSequence);
		tagList.add(TagFromName.ClinicalTrialSeriesID);
		tagList.add(TagFromName.ClinicalTrialSeriesDescription);
		tagList.add(TagFromName.ClinicalTrialProtocolEthicsCommitteeName);
		tagList.add(TagFromName.ClinicalTrialProtocolEthicsCommitteeApprovalNumber);
		tagList.add(TagFromName.ConsentForClinicalTrialUseSequence);
		tagList.add(TagFromName.DistributionType);
		tagList.add(TagFromName.ConsentForDistributionFlag);
		tagList.add(TagFromName.ContrastBolusAgent);
		tagList.add(TagFromName.ContrastBolusAgentSequence);
		tagList.add(TagFromName.ContrastBolusAdministrationRouteSequence);
		tagList.add(TagFromName.BodyPartExamined);
		tagList.add(TagFromName.ScanningSequence);
		tagList.add(TagFromName.SequenceVariant);
		tagList.add(TagFromName.ScanOptions);
		tagList.add(TagFromName.MRAcquisitionType);
		tagList.add(TagFromName.SequenceName);
		tagList.add(TagFromName.AngioFlag);
		tagList.add(TagFromName.InterventionDrugInformationSequence);
		tagList.add(TagFromName.InterventionDrugStopTime);
		tagList.add(TagFromName.InterventionDrugDose);
		tagList.add(TagFromName.InterventionDrugCodeSequence);
		tagList.add(TagFromName.AdditionalDrugSequence);
		tagList.add(TagFromName.Radionuclide);
		tagList.add(TagFromName.Radiopharmaceutical);
		tagList.add(TagFromName.EnergyWindowCenterline);
		tagList.add(TagFromName.EnergyWindowTotalWidth);
		tagList.add(TagFromName.InterventionDrugName);
		tagList.add(TagFromName.InterventionDrugStartTime);
		tagList.add(TagFromName.InterventionSequence);
		tagList.add(TagFromName.TherapyType);
		tagList.add(TagFromName.InterventionStatus);
		tagList.add(TagFromName.TherapyDescription);
		tagList.add(TagFromName.InterventionDescription);
		tagList.add(TagFromName.CineRate);
		tagList.add(TagFromName.InitialCineRunState);
		tagList.add(TagFromName.SliceThickness);
		tagList.add(TagFromName.KVP);
		tagList.add(TagFromName.CountsAccumulated);
		tagList.add(TagFromName.AcquisitionTerminationCondition);
		tagList.add(TagFromName.EffectiveDuration);
		tagList.add(TagFromName.AcquisitionStartCondition);
		tagList.add(TagFromName.AcquisitionStartConditionData);
		tagList.add(TagFromName.AcquisitionTerminationConditionData);
		tagList.add(TagFromName.RepetitionTime);
		tagList.add(TagFromName.EchoTime);
		tagList.add(TagFromName.InversionTime);
		tagList.add(TagFromName.NumberOfAverages);
		tagList.add(TagFromName.ImagingFrequency);
		tagList.add(TagFromName.ImagedNucleus);
		tagList.add(TagFromName.EchoNumber);
		tagList.add(TagFromName.MagneticFieldStrength);
		tagList.add(TagFromName.SpacingBetweenSlices);
		tagList.add(TagFromName.NumberOfPhaseEncodingSteps);
		tagList.add(TagFromName.DataCollectionDiameter);
		tagList.add(TagFromName.EchoTrainLength);
		tagList.add(TagFromName.PercentSampling);
		tagList.add(TagFromName.PercentPhaseFieldOfView);
		tagList.add(TagFromName.PixelBandwidth);
		tagList.add(TagFromName.DeviceSerialNumber);
		tagList.add(TagFromName.DeviceUID);
		tagList.add(TagFromName.PlateID);
		tagList.add(TagFromName.GeneratorID);
		tagList.add(TagFromName.GridID);
		tagList.add(TagFromName.CassetteID);
		tagList.add(TagFromName.GantryID);
		tagList.add(TagFromName.SecondaryCaptureDeviceID);
		tagList.add(TagFromName.HardcopyCreationDeviceID);
		tagList.add(TagFromName.DateOfSecondaryCapture);
		tagList.add(TagFromName.TimeOfSecondaryCapture);
		tagList.add(TagFromName.SecondaryCaptureDeviceManufacturer);
		tagList.add(TagFromName.HardcopyDeviceManufacturer);
		tagList.add(TagFromName.SecondaryCaptureDeviceManufacturerModelName);
		tagList.add(TagFromName.SecondaryCaptureDeviceSoftwareVersion);
		tagList.add(TagFromName.HardcopyDeviceSoftwareVersion);
		tagList.add(TagFromName.HardcopyDeviceManufacturerModelName);
		tagList.add(TagFromName.SoftwareVersion);
		tagList.add(TagFromName.VideoImageFormatAcquired);
		tagList.add(TagFromName.DigitalImageFormatAcquired);
		tagList.add(TagFromName.ProtocolName);
		tagList.add(TagFromName.ContrastBolusRoute);
		tagList.add(TagFromName.ContrastBolusVolume);
		tagList.add(TagFromName.ContrastBolusStartTime);
		tagList.add(TagFromName.ContrastBolusStopTime);
		tagList.add(TagFromName.ContrastBolusTotalDose);
		tagList.add(TagFromName.SyringeCounts);
		tagList.add(TagFromName.ContrastFlowRate);
		tagList.add(TagFromName.ContrastFlowDuration);
		tagList.add(TagFromName.ContrastBolusIngredient);
		tagList.add(TagFromName.ContrastBolusIngredientConcentration);
		tagList.add(TagFromName.SpatialResolution);
		tagList.add(TagFromName.TriggerTime);
		tagList.add(TagFromName.TriggerSourceOrType);
		tagList.add(TagFromName.NominalInterval);
		tagList.add(TagFromName.FrameTime);
		tagList.add(TagFromName.CardiacFramingType);
		tagList.add(TagFromName.FrameTimeVector);
		tagList.add(TagFromName.FrameDelay);
		tagList.add(TagFromName.ImageTriggerDelay);
		tagList.add(TagFromName.MultiplexGroupTimeOffset);
		tagList.add(TagFromName.TriggerTimeOffset);
		tagList.add(TagFromName.SynchronizationTrigger);
		tagList.add(TagFromName.SynchronizationChannel);
		tagList.add(TagFromName.TriggerSamplePosition);
		tagList.add(TagFromName.RadiopharmaceuticalRoute);
		tagList.add(TagFromName.RadiopharmaceuticalVolume);
		tagList.add(TagFromName.RadiopharmaceuticalStartTime);
		tagList.add(TagFromName.RadiopharmaceuticalStopTime);
		tagList.add(TagFromName.RadionuclideTotalDose);
		tagList.add(TagFromName.RadionuclideHalfLife);
		tagList.add(TagFromName.RadionuclidePositronFraction);
		tagList.add(TagFromName.RadiopharmaceuticalSpecificActivity);
		tagList.add(TagFromName.RadiopharmaceuticalStartDateTime);
		tagList.add(TagFromName.RadiopharmaceuticalStopDateTime);
		tagList.add(TagFromName.BeatRejectionFlag);
		tagList.add(TagFromName.LowRRValue);
		tagList.add(TagFromName.HighRRValue);
		tagList.add(TagFromName.IntervalsAcquired);
		tagList.add(TagFromName.IntervalsRejected);
		tagList.add(TagFromName.PVCRejection);
		tagList.add(TagFromName.SkipBeats);
		tagList.add(TagFromName.HeartRate);
		tagList.add(TagFromName.CardiacNumberOfImages);
		tagList.add(TagFromName.TriggerWindow);
		tagList.add(TagFromName.ReconstructionDiameter);
		tagList.add(TagFromName.DistanceSourceToDetector);
		tagList.add(TagFromName.DistanceSourceToPatient);
		tagList.add(TagFromName.EstimatedRadiographicMagnificationFactor);
		tagList.add(TagFromName.GantryDetectorTilt);
		tagList.add(TagFromName.GantryDetectorSlew);
		tagList.add(TagFromName.TableHeight);
		tagList.add(TagFromName.TableTraverse);
		tagList.add(TagFromName.TableMotion);
		tagList.add(TagFromName.TableVerticalIncrement);
		tagList.add(TagFromName.TableLateralIncrement);
		tagList.add(TagFromName.TableLongitudinalIncrement);
		tagList.add(TagFromName.TableAngle);
		tagList.add(TagFromName.TableType);
		tagList.add(TagFromName.RotationDirection);
		tagList.add(TagFromName.AngularPosition);
		tagList.add(TagFromName.RadialPosition);
		tagList.add(TagFromName.ScanArc);
		tagList.add(TagFromName.AngularStep);
		tagList.add(TagFromName.CenterOfRotationOffset);
		tagList.add(TagFromName.RotationOffset);
		tagList.add(TagFromName.FieldOfViewShape);
		tagList.add(TagFromName.FieldOfViewDimensions);
		tagList.add(TagFromName.ExposureTime);
		tagList.add(TagFromName.XRayTubeCurrent);
		tagList.add(TagFromName.Exposure);
		tagList.add(TagFromName.ExposureInuAs);
		tagList.add(TagFromName.AveragePulseWidth);
		tagList.add(TagFromName.RadiationSetting);
		tagList.add(TagFromName.RectificationType);
		tagList.add(TagFromName.RadiationMode);
		tagList.add(TagFromName.ImageAndFluoroscopyAreaDoseProduct);
		tagList.add(TagFromName.FilterType);
		tagList.add(TagFromName.TypeOfFilters);
		tagList.add(TagFromName.IntensifierSize);
		tagList.add(TagFromName.ImagerPixelSpacing);
		tagList.add(TagFromName.Grid);
		tagList.add(TagFromName.GeneratorPower);
		tagList.add(TagFromName.CollimatorGridName);
		tagList.add(TagFromName.CollimatorType);
		tagList.add(TagFromName.FocalDistance);
		tagList.add(TagFromName.XFocusCenter);
		tagList.add(TagFromName.YFocusCenter);
		tagList.add(TagFromName.FocalSpot);
		tagList.add(TagFromName.AnodeTargetMaterial);
		tagList.add(TagFromName.BodyPartThickness);
		tagList.add(TagFromName.CompressionForce);
		tagList.add(TagFromName.DateOfLastCalibration);
		tagList.add(TagFromName.TimeOfLastCalibration);
		tagList.add(TagFromName.ConvolutionKernel);
		tagList.add(TagFromName.UpperLowerPixelValues);
		tagList.add(TagFromName.ActualFrameDuration);
		tagList.add(TagFromName.CountRate);
		tagList.add(TagFromName.PreferredPlaybackSequencing);
		tagList.add(TagFromName.ReceiveCoilName);
		tagList.add(TagFromName.TransmitCoilName);
		tagList.add(TagFromName.PlateType);
		tagList.add(TagFromName.PhosphorType);
		tagList.add(TagFromName.ScanVelocity);
		tagList.add(TagFromName.WholeBodyTechnique);
		tagList.add(TagFromName.ScanLength);
		tagList.add(TagFromName.AcquisitionMatrix);
		tagList.add(TagFromName.InPlanePhaseEncodingDirection);
		tagList.add(TagFromName.FlipAngle);
		tagList.add(TagFromName.VariableFlipAngleFlag);
		tagList.add(TagFromName.SAR);
		tagList.add(TagFromName.dBdt);
		tagList.add(TagFromName.AcquisitionDeviceProcessingDescription);
		tagList.add(TagFromName.AcquisitionDeviceProcessingCode);
		tagList.add(TagFromName.CassetteOrientation);
		tagList.add(TagFromName.CassetteSize);
		tagList.add(TagFromName.ExposuresOnPlate);
		tagList.add(TagFromName.RelativeXRayExposure);
		tagList.add(TagFromName.ColumnAngulation);
		tagList.add(TagFromName.TomoLayerHeight);
		tagList.add(TagFromName.TomoAngle);
		tagList.add(TagFromName.TomoTime);
		tagList.add(TagFromName.TomoType);
		tagList.add(TagFromName.TomoClass);
		tagList.add(TagFromName.NumberOfTomosynthesisSourceImages);
		tagList.add(TagFromName.PositionerMotion);
		tagList.add(TagFromName.PositionerType);
		tagList.add(TagFromName.PositionerPrimaryAngle);
		tagList.add(TagFromName.PositionerSecondaryAngle);
		tagList.add(TagFromName.PositionerPrimaryAngleIncrement);
		tagList.add(TagFromName.PositionerSecondaryAngleIncrement);
		tagList.add(TagFromName.DetectorPrimaryAngle);
		tagList.add(TagFromName.DetectorSecondaryAngle);
		tagList.add(TagFromName.ShutterShape);
		tagList.add(TagFromName.ShutterLeftVerticalEdge);
		tagList.add(TagFromName.ShutterRightVerticalEdge);
		tagList.add(TagFromName.ShutterUpperHorizontalEdge);
		tagList.add(TagFromName.ShutterLowerHorizontalEdge);
		tagList.add(TagFromName.CenterOfCircularShutter);
		tagList.add(TagFromName.RadiusOfCircularShutter);
		tagList.add(TagFromName.VerticesOfPolygonalShutter);
		tagList.add(TagFromName.ShutterPresentationValue);
		tagList.add(TagFromName.ShutterOverlayGroup);
		tagList.add(TagFromName.ShutterPresentationColorCIELabValue);
		tagList.add(TagFromName.CollimatorShape);
		tagList.add(TagFromName.CollimatorLeftVerticalEdge);
		tagList.add(TagFromName.CollimatorRightVerticalEdge);
		tagList.add(TagFromName.CollimatorUpperHorizontalEdge);
		tagList.add(TagFromName.CollimatorLowerHorizontalEdge);
		tagList.add(TagFromName.CenterOfCircularCollimator);
		tagList.add(TagFromName.RadiusOfCircularCollimator);
		tagList.add(TagFromName.VerticesOfPolygonalCollimator);
		tagList.add(TagFromName.AcquisitionTimeSynchronized);
		tagList.add(TagFromName.TimeSource);
		tagList.add(TagFromName.TimeDistributionProtocol);
		tagList.add(TagFromName.NTPSourceAddress);
		tagList.add(TagFromName.PageNumberVector);
		tagList.add(TagFromName.FrameLabelVector);
		tagList.add(TagFromName.FramePrimaryAngleVector);
		tagList.add(TagFromName.FrameSecondaryAngleVector);
		tagList.add(TagFromName.SliceLocationVector);
		tagList.add(TagFromName.DisplayWindowLabelVector);
		tagList.add(TagFromName.NominalScannedPixelSpacing);
		tagList.add(TagFromName.DigitizingDeviceTransportDirection);
		tagList.add(TagFromName.RotationOfScannedFilm);
		tagList.add(TagFromName.IVUSAcquisition);
		tagList.add(TagFromName.IVUSPullbackRate);
		tagList.add(TagFromName.IVUSGatedRate);
		tagList.add(TagFromName.IVUSPullbackStartFrameNumber);
		tagList.add(TagFromName.IVUSPullbackStopFrameNumber);
		tagList.add(TagFromName.LesionNumber);
		tagList.add(TagFromName.AcquisitionComments);
		tagList.add(TagFromName.OutputPower);
		tagList.add(TagFromName.TransducerData);
		tagList.add(TagFromName.FocusDepth);
		tagList.add(TagFromName.ProcessingFunction);
		tagList.add(TagFromName.PostprocessingFunction);
		tagList.add(TagFromName.MechanicalIndex);
		tagList.add(TagFromName.BoneThermalIndex);
		tagList.add(TagFromName.CranialThermalIndex);
		tagList.add(TagFromName.SoftTissueThermalIndex);
		tagList.add(TagFromName.SoftTissueFocusThermalIndex);
		tagList.add(TagFromName.SoftTissueSurfaceThermalIndex);
		tagList.add(TagFromName.DynamicRange);
		tagList.add(TagFromName.TotalGain);
		tagList.add(TagFromName.DepthOfScanField);
		tagList.add(TagFromName.PatientPosition);
		tagList.add(TagFromName.ViewPosition);
		tagList.add(TagFromName.ProjectionEponymousNameCodeSequence);
		tagList.add(TagFromName.ImageTransformationMatrix);
		tagList.add(TagFromName.ImageTranslationVector);
		tagList.add(TagFromName.Sensitivity);
		tagList.add(TagFromName.SequenceOfUltrasoundRegions);
		tagList.add(TagFromName.RegionSpatialFormat);
		tagList.add(TagFromName.RegionDataType);
		tagList.add(TagFromName.RegionFlags);
		tagList.add(TagFromName.RegionLocationMinX0);
		tagList.add(TagFromName.RegionLocationMinY0);
		tagList.add(TagFromName.RegionLocationMaxX1);
		tagList.add(TagFromName.RegionLocationMaxY1);
		tagList.add(TagFromName.ReferencePixelX0);
		tagList.add(TagFromName.ReferencePixelY0);
		tagList.add(TagFromName.PhysicalUnitsXDirection);
		tagList.add(TagFromName.PhysicalUnitsYDirection);
		tagList.add(TagFromName.ReferencePixelPhysicalValueX);
		tagList.add(TagFromName.ReferencePixelPhysicalValueY);
		tagList.add(TagFromName.PhysicalDeltaX);
		tagList.add(TagFromName.PhysicalDeltaY);
		tagList.add(TagFromName.TransducerFrequency);
		tagList.add(TagFromName.TransducerType);
		tagList.add(TagFromName.PulseRepetitionFrequency);
		tagList.add(TagFromName.DopplerCorrectionAngle);
		tagList.add(TagFromName.SteeringAngle);
		tagList.add(TagFromName.DopplerSampleVolumeXPositionRetired);
		tagList.add(TagFromName.DopplerSampleVolumeXPosition);
		tagList.add(TagFromName.DopplerSampleVolumeYPositionRetired);
		tagList.add(TagFromName.DopplerSampleVolumeYPosition);
		tagList.add(TagFromName.TMLinePositionX0Retired);
		tagList.add(TagFromName.TMLinePositionX0);
		tagList.add(TagFromName.TMLinePositionY0Retired);
		tagList.add(TagFromName.TMLinePositionY0);
		tagList.add(TagFromName.TMLinePositionX1Retired);
		tagList.add(TagFromName.TMLinePositionX1);
		tagList.add(TagFromName.TMLinePositionY1Retired);
		tagList.add(TagFromName.TMLinePositionY1);
		tagList.add(TagFromName.PixelComponentOrganization);
		tagList.add(TagFromName.PixelComponentMask);
		tagList.add(TagFromName.PixelComponentRangeStart);
		tagList.add(TagFromName.PixelComponentRangeStop);
		tagList.add(TagFromName.PixelComponentPhysicalUnits);
		tagList.add(TagFromName.PixelComponentDataType);
		tagList.add(TagFromName.NumberOfTableBreakPoints);
		tagList.add(TagFromName.TableOfXBreakPoints);
		tagList.add(TagFromName.TableOfYBreakPoints);
		tagList.add(TagFromName.NumberOfTableEntries);
		tagList.add(TagFromName.TableOfPixelValues);
		tagList.add(TagFromName.TableOfParameterValues);
		tagList.add(TagFromName.RWaveTimeVector);
		tagList.add(TagFromName.DetectorConditionsNominalFlag);
		tagList.add(TagFromName.DetectorTemperature);
		tagList.add(TagFromName.DetectorType);
		tagList.add(TagFromName.DetectorConfiguration);
		tagList.add(TagFromName.DetectorDescription);
		tagList.add(TagFromName.DetectorMode);
		tagList.add(TagFromName.DetectorID);
		tagList.add(TagFromName.DateOfLastDetectorCalibration);
		tagList.add(TagFromName.TimeOfLastDetectorCalibration);
		tagList.add(TagFromName.ExposuresOnDetectorSinceLastCalibration);
		tagList.add(TagFromName.ExposuresOnDetectorSinceManufactured);
		tagList.add(TagFromName.DetectorTimeSinceLastExposure);
		tagList.add(TagFromName.DetectorActiveTime);
		tagList.add(TagFromName.DetectorActivationOffsetFromExposure);
		tagList.add(TagFromName.DetectorBinning);
		tagList.add(TagFromName.DetectorElementPhysicalSize);
		tagList.add(TagFromName.DetectorElementSpacing);
		tagList.add(TagFromName.DetectorActiveShape);
		tagList.add(TagFromName.DetectorActiveDimensions);
		tagList.add(TagFromName.DetectorActiveOrigin);
		tagList.add(TagFromName.DetectorManufacturerName);
		tagList.add(TagFromName.DetectorManufacturerModelName);
		tagList.add(TagFromName.FieldOfViewOrigin);
		tagList.add(TagFromName.FieldOfViewRotation);
		tagList.add(TagFromName.FieldOfViewHorizontalFlip);
		tagList.add(TagFromName.GridAbsorbingMaterial);
		tagList.add(TagFromName.GridSpacingMaterial);
		tagList.add(TagFromName.GridThickness);
		tagList.add(TagFromName.GridPitch);
		tagList.add(TagFromName.GridAspectRatio);
		tagList.add(TagFromName.GridPeriod);
		tagList.add(TagFromName.GridFocalDistance);
		tagList.add(TagFromName.FilterMaterial);
		tagList.add(TagFromName.FilterThicknessMinimum);
		tagList.add(TagFromName.FilterThicknessMaximum);
		tagList.add(TagFromName.ExposureControlMode);
		tagList.add(TagFromName.ExposureControlModeDescription);
		tagList.add(TagFromName.ExposureStatus);
		tagList.add(TagFromName.PhototimerSetting);
		tagList.add(TagFromName.ExposureTimeInuS);
		tagList.add(TagFromName.XRayTubeCurrentInuA);
		tagList.add(TagFromName.ContentQualification);
		tagList.add(TagFromName.PulseSequenceName);
		tagList.add(TagFromName.MRImagingModifierSequence);
		tagList.add(TagFromName.EchoPulseSequence);
		tagList.add(TagFromName.InversionRecovery);
		tagList.add(TagFromName.FlowCompensation);
		tagList.add(TagFromName.MultipleSpinEcho);
		tagList.add(TagFromName.MultiplanarExcitation);
		tagList.add(TagFromName.PhaseContrast);
		tagList.add(TagFromName.TimeOfFlightContrast);
		tagList.add(TagFromName.Spoiling);
		tagList.add(TagFromName.SteadyStatePulseSequence);
		tagList.add(TagFromName.EchoPlanarPulseSequence);
		tagList.add(TagFromName.TagAngleFirstAxis);
		tagList.add(TagFromName.MagnetizationTransfer);
		tagList.add(TagFromName.T2Preparation);
		tagList.add(TagFromName.BloodSignalNulling);
		tagList.add(TagFromName.SaturationRecovery);
		tagList.add(TagFromName.SpectrallySelectedSuppression);
		tagList.add(TagFromName.SpectrallySelectedExcitation);
		tagList.add(TagFromName.SpatialPresaturation);
		tagList.add(TagFromName.Tagging);
		tagList.add(TagFromName.OversamplingPhase);
		tagList.add(TagFromName.TagSpacingFirstDimension);
		tagList.add(TagFromName.GeometryOfKSpaceTraversal);
		tagList.add(TagFromName.SegmentedKSpaceTraversal);
		tagList.add(TagFromName.RectilinearPhaseEncodeReordering);
		tagList.add(TagFromName.TagThickness);
		tagList.add(TagFromName.PartialFourierDirection);
		tagList.add(TagFromName.CardiacSynchronizationTechnique);
		tagList.add(TagFromName.ReceiveCoilManufacturerName);
		tagList.add(TagFromName.MRReceiveCoilSequence);
		tagList.add(TagFromName.ReceiveCoilType);
		tagList.add(TagFromName.QuadratureReceiveCoil);
		tagList.add(TagFromName.MultiCoilDefinitionSequence);
		tagList.add(TagFromName.MultiCoilConfiguration);
		tagList.add(TagFromName.MultiCoilElementName);
		tagList.add(TagFromName.MultiCoilElementUsed);
		tagList.add(TagFromName.MRTransmitCoilSequence);
		tagList.add(TagFromName.TransmitCoilManufacturerName);
		tagList.add(TagFromName.TransmitCoilType);
		tagList.add(TagFromName.SpectralWidth);
		tagList.add(TagFromName.ChemicalShiftReference);
		tagList.add(TagFromName.VolumeLocalizationTechnique);
		tagList.add(TagFromName.MRAcquisitionFrequencyEncodingSteps);
		tagList.add(TagFromName.Decoupling);
		tagList.add(TagFromName.DecoupledNucleus);
		tagList.add(TagFromName.DecouplingFrequency);
		tagList.add(TagFromName.DecouplingMethod);
		tagList.add(TagFromName.DecouplingChemicalShiftReference);
		tagList.add(TagFromName.KSpaceFiltering);
		tagList.add(TagFromName.TimeDomainFiltering);
		tagList.add(TagFromName.NumberOfZeroFills);
		tagList.add(TagFromName.BaselineCorrection);
		tagList.add(TagFromName.ParallelReductionFactorInPlane);
		tagList.add(TagFromName.CardiacRRIntervalSpecified);
		tagList.add(TagFromName.AcquisitionDuration);
		tagList.add(TagFromName.FrameAcquisitionDateTime);
		tagList.add(TagFromName.DiffusionDirectionality);
		tagList.add(TagFromName.DiffusionGradientDirectionSequence);
		tagList.add(TagFromName.ParallelAcquisition);
		tagList.add(TagFromName.ParallelAcquisitionTechnique);
		tagList.add(TagFromName.InversionTimes);
		tagList.add(TagFromName.MetaboliteMapDescription);
		tagList.add(TagFromName.PartialFourier);
		tagList.add(TagFromName.EffectiveEchoTime);
		tagList.add(TagFromName.MetaboliteCodeSequence);
		tagList.add(TagFromName.ChemicalShiftSequence);
		tagList.add(TagFromName.CardiacSignalSource);
		tagList.add(TagFromName.DiffusionBValue);
		tagList.add(TagFromName.DiffusionGradientOrientation);
		tagList.add(TagFromName.VelocityEncodingDirection);
		tagList.add(TagFromName.VelocityEncodingMinimumValue);
		tagList.add(TagFromName.NumberOfKSpaceTrajectories);
		tagList.add(TagFromName.CoverageOfKSpace);
		tagList.add(TagFromName.SpectroscopyAcquisitionPhaseRows);
		tagList.add(TagFromName.ParallelReductionFactorInPlaneRetired);
		tagList.add(TagFromName.TransmitterFrequency);
		tagList.add(TagFromName.ResonantNucleus);
		tagList.add(TagFromName.FrequencyCorrection);
		tagList.add(TagFromName.MRSpectroscopyFOVGeometrySequence);
		tagList.add(TagFromName.SlabThickness);
		tagList.add(TagFromName.SlabOrientation);
		tagList.add(TagFromName.MidSlabPosition);
		tagList.add(TagFromName.MRSpatialSaturationSequence);
		tagList.add(TagFromName.MRTimingAndRelatedParametersSequence);
		tagList.add(TagFromName.MREchoSequence);
		tagList.add(TagFromName.MRModifierSequence);
		tagList.add(TagFromName.MRDiffusionSequence);
		tagList.add(TagFromName.CardiacSynchronizationSequence);
		tagList.add(TagFromName.MRAveragesSequence);
		tagList.add(TagFromName.MRFOVGeometrySequence);
		tagList.add(TagFromName.VolumeLocalizationSequence);
		tagList.add(TagFromName.SpectroscopyAcquisitionDataColumns);
		tagList.add(TagFromName.DiffusionAnisotropyType);
		tagList.add(TagFromName.FrameReferenceDateTime);
		tagList.add(TagFromName.MRMetaboliteMapSequence);
		tagList.add(TagFromName.ParallelReductionFactorOutOfPlane);
		tagList.add(TagFromName.SpectroscopyAcquisitionOutOfPlanePhaseSteps);
		tagList.add(TagFromName.BulkMotionStatus);
		tagList.add(TagFromName.ParallelReductionFactorSecondInPlane);
		tagList.add(TagFromName.CardiacBeatRejectionTechnique);
		tagList.add(TagFromName.RespiratoryMotionCompensationTechnique);
		tagList.add(TagFromName.RespiratorySignalSource);
		tagList.add(TagFromName.BulkMotionCompensationTechnique);
		tagList.add(TagFromName.BulkMotionSignalSource);
		tagList.add(TagFromName.ApplicableSafetyStandardAgency);
		tagList.add(TagFromName.ApplicableSafetyStandardDescription);
		tagList.add(TagFromName.OperatingModeSequence);
		tagList.add(TagFromName.OperatingModeType);
		tagList.add(TagFromName.OperatingMode);
		tagList.add(TagFromName.SpecificAbsorptionRateDefinition);
		tagList.add(TagFromName.GradientOutputType);
		tagList.add(TagFromName.SpecificAbsorptionRateValue);
		tagList.add(TagFromName.GradientOutput);
		tagList.add(TagFromName.FlowCompensationDirection);
		tagList.add(TagFromName.TaggingDelay);
		tagList.add(TagFromName.RespiratoryMotionCompensationTechniqueDescription);
		tagList.add(TagFromName.RespiratorySignalSourceID);
		tagList.add(TagFromName.ChemicalShiftMinimumIntegrationLimitInHz);
		tagList.add(TagFromName.ChemicalShiftMaximumIntegrationLimitInHz);
		tagList.add(TagFromName.MRVelocityEncodingSequence);
		tagList.add(TagFromName.FirstOrderPhaseCorrection);
		tagList.add(TagFromName.WaterReferencedPhaseCorrection);
		tagList.add(TagFromName.MRSpectroscopyAcquisitionType);
		tagList.add(TagFromName.RespiratoryCyclePosition);
		tagList.add(TagFromName.VelocityEncodingMaximumValue);
		tagList.add(TagFromName.TagSpacingSecondDimension);
		tagList.add(TagFromName.TagAngleSecondAxis);
		tagList.add(TagFromName.FrameAcquisitionDuration);
		tagList.add(TagFromName.MRImageFrameTypeSequence);
		tagList.add(TagFromName.MRSpectroscopyFrameTypeSequence);
		tagList.add(TagFromName.MRAcquisitionPhaseEncodingStepsInPlane);
		tagList.add(TagFromName.MRAcquisitionPhaseEncodingStepsOutOfPlane);
		tagList.add(TagFromName.SpectroscopyAcquisitionPhaseColumns);
		tagList.add(TagFromName.CardiacCyclePosition);
		tagList.add(TagFromName.SpecificAbsorptionRateSequence);
		tagList.add(TagFromName.RFEchoTrainLength);
		tagList.add(TagFromName.GradientEchoTrainLength);
		tagList.add(TagFromName.ChemicalShiftMinimumIntegrationLimitInPPM);
		tagList.add(TagFromName.ChemicalShiftMaximumIntegrationLimitInPPM);
		tagList.add(TagFromName.CTAcquisitionTypeSequence);
		tagList.add(TagFromName.AcquisitionType);
		tagList.add(TagFromName.TubeAngle);
		tagList.add(TagFromName.CTAcquisitionDetailsSequence);
		tagList.add(TagFromName.RevolutionTime);
		tagList.add(TagFromName.SingleCollimationWidth);
		tagList.add(TagFromName.TotalCollimationWidth);
		tagList.add(TagFromName.CTTableDynamicsSequence);
		tagList.add(TagFromName.TableSpeed);
		tagList.add(TagFromName.TableFeedPerRotation);
		tagList.add(TagFromName.SpiralPitchFactor);
		tagList.add(TagFromName.CTGeometrySequence);
		tagList.add(TagFromName.DataCollectionCenterPatient);
		tagList.add(TagFromName.CTReconstructionSequence);
		tagList.add(TagFromName.ReconstructionAlgorithm);
		tagList.add(TagFromName.ConvolutionKernelGroup);
		tagList.add(TagFromName.ReconstructionFieldOfView);
		tagList.add(TagFromName.ReconstructionTargetCenterPatient);
		tagList.add(TagFromName.ReconstructionAngle);
		tagList.add(TagFromName.ImageFilter);
		tagList.add(TagFromName.CTExposureSequence);
		tagList.add(TagFromName.ReconstructionPixelSpacing);
		tagList.add(TagFromName.ExposureModulationType);
		tagList.add(TagFromName.EstimatedDoseSaving);
		tagList.add(TagFromName.CTXRayDetailsSequence);
		tagList.add(TagFromName.CTPositionSequence);
		tagList.add(TagFromName.TablePosition);
		tagList.add(TagFromName.ExposureTimeInms);
		tagList.add(TagFromName.CTImageFrameTypeSequence);
		tagList.add(TagFromName.XRayTubeCurrentInmA);
		tagList.add(TagFromName.ExposureInmAs);
		tagList.add(TagFromName.ConstantVolumeFlag);
		tagList.add(TagFromName.FluoroscopyFlag);
		tagList.add(TagFromName.DistanceSourceToDataCollectionCenter);
		tagList.add(TagFromName.ContrastBolusAgentNumber);
		tagList.add(TagFromName.ContrastBolusIngredientCodeSequence);
		tagList.add(TagFromName.ContrastAdministrationProfileSequence);
		tagList.add(TagFromName.ContrastBolusUsageSequence);
		tagList.add(TagFromName.ContrastBolusAgentAdministered);
		tagList.add(TagFromName.ContrastBolusAgentDetected);
		tagList.add(TagFromName.ContrastBolusAgentPhase);
		tagList.add(TagFromName.CTDIvol);
		tagList.add(TagFromName.CTDIPhantomTypeCodeSequence);
		tagList.add(TagFromName.CalciumScoringMassFactorPatient);
		tagList.add(TagFromName.CalciumScoringMassFactorDevice);
		tagList.add(TagFromName.EnergyWeightingFactor);
		tagList.add(TagFromName.CTAdditionalXRaySourceSequence);
		tagList.add(TagFromName.ProjectionPixelCalibrationSequence);
		tagList.add(TagFromName.DistanceSourceToIsocenter);
		tagList.add(TagFromName.DistanceObjectToTableTop);
		tagList.add(TagFromName.ObjectPixelSpacingInCenterOfBeam);
		tagList.add(TagFromName.PositionerPositionSequence);
		tagList.add(TagFromName.TablePositionSequence);
		tagList.add(TagFromName.CollimatorShapeSequence);
		tagList.add(TagFromName.XAXRFFrameCharacteristicsSequence);
		tagList.add(TagFromName.FrameAcquisitionSequence);
		tagList.add(TagFromName.XRayReceptorType);
		tagList.add(TagFromName.AcquisitionProtocolName);
		tagList.add(TagFromName.AcquisitionProtocolDescription);
		tagList.add(TagFromName.ContrastBolusIngredientOpaque);
		tagList.add(TagFromName.DistanceReceptorPlaneToDetectorHousing);
		tagList.add(TagFromName.IntensifierActiveShape);
		tagList.add(TagFromName.IntensifierActiveDimensions);
		tagList.add(TagFromName.PhysicalDetectorSize);
		tagList.add(TagFromName.PositionOfIsocenterProjection);
		tagList.add(TagFromName.FieldOfViewSequence);
		tagList.add(TagFromName.FieldOfViewDescription);
		tagList.add(TagFromName.ExposureControlSensingRegionsSequence);
		tagList.add(TagFromName.ExposureControlSensingRegionShape);
		tagList.add(TagFromName.ExposureControlSensingRegionLeftVerticalEdge);
		tagList.add(TagFromName.ExposureControlSensingRegionRightVerticalEdge);
		tagList.add(TagFromName.ExposureControlSensingRegionUpperHorizontalEdge);
		tagList.add(TagFromName.ExposureControlSensingRegionLowerHorizontalEdge);
		tagList.add(TagFromName.CenterOfCircularExposureControlSensingRegion);
		tagList.add(TagFromName.RadiusOfCircularExposureControlSensingRegion);
		tagList.add(TagFromName.VerticesOfPolygonalExposureControlSensingRegion);
		tagList.add(TagFromName.ColumnAngulationPatient);
		tagList.add(TagFromName.BeamAngle);
		tagList.add(TagFromName.FrameDetectorParametersSequence);
		tagList.add(TagFromName.CalculatedAnatomyThickness);
		tagList.add(TagFromName.CalibrationSequence);
		tagList.add(TagFromName.ObjectThicknessSequence);
		tagList.add(TagFromName.PlaneIdentification);
		tagList.add(TagFromName.FieldOfViewDimensionsInFloat);
		tagList.add(TagFromName.IsocenterReferenceSystemSequence);
		tagList.add(TagFromName.PositionerIsocenterPrimaryAngle);
		tagList.add(TagFromName.PositionerIsocenterSecondaryAngle);
		tagList.add(TagFromName.PositionerIsocenterDetectorRotationAngle);
		tagList.add(TagFromName.TableXPositionToIsocenter);
		tagList.add(TagFromName.TableYPositionToIsocenter);
		tagList.add(TagFromName.TableZPositionToIsocenter);
		tagList.add(TagFromName.TableHorizontalRotationAngle);
		tagList.add(TagFromName.TableHeadTiltAngle);
		tagList.add(TagFromName.TableCradleTiltAngle);
		tagList.add(TagFromName.FrameDisplayShutterSequence);
		tagList.add(TagFromName.AcquiredImageAreaDoseProduct);
		tagList.add(TagFromName.CArmPositionerTabletopRelationship);
		tagList.add(TagFromName.XRayGeometrySequence);
		tagList.add(TagFromName.IrradiationEventIdentificationSequence);
		tagList.add(TagFromName.XRay3DFrameTypeSequence);
		tagList.add(TagFromName.ContributingSourcesSequence);
		tagList.add(TagFromName.XRay3DAcquisitionSequence);
		tagList.add(TagFromName.PrimaryPositionerScanArc);
		tagList.add(TagFromName.SecondaryPositionerScanArc);
		tagList.add(TagFromName.PrimaryPositionerScanStartAngle);
		tagList.add(TagFromName.SecondaryPositionerScanStartAngle);
		tagList.add(TagFromName.PrimaryPositionerIncrement);
		tagList.add(TagFromName.SecondaryPositionerIncrement);
		tagList.add(TagFromName.StartAcquisitionDateTime);
		tagList.add(TagFromName.EndAcquisitionDateTime);
		tagList.add(TagFromName.ApplicationName);
		tagList.add(TagFromName.ApplicationVersion);
		tagList.add(TagFromName.ApplicationManufacturer);
		tagList.add(TagFromName.AlgorithmType);
		tagList.add(TagFromName.AlgorithmDescription);
		tagList.add(TagFromName.XRay3DReconstructionSequence);
		tagList.add(TagFromName.ReconstructionDescription);
		tagList.add(TagFromName.PerProjectionAcquisitionSequence);
		tagList.add(TagFromName.DiffusionBMatrixSequence);
		tagList.add(TagFromName.DiffusionBMatrixValueXX);
		tagList.add(TagFromName.DiffusionBMatrixValueXY);
		tagList.add(TagFromName.DiffusionBMatrixValueXZ);
		tagList.add(TagFromName.DiffusionBMatrixValueYY);
		tagList.add(TagFromName.DiffusionBMatrixValueYZ);
		tagList.add(TagFromName.DiffusionBMatrixValueZZ);
		tagList.add(TagFromName.DecayCorrectionDateTime);
		tagList.add(TagFromName.StartDensityThreshold);
		tagList.add(TagFromName.StartRelativeDensityDifferenceThreshold);
		tagList.add(TagFromName.StartCardiacTriggerCountThreshold);
		tagList.add(TagFromName.StartRespiratoryTriggerCountThreshold);
		tagList.add(TagFromName.TerminationCountsThreshold);
		tagList.add(TagFromName.TerminationDensityThreshold);
		tagList.add(TagFromName.TerminationRelativeDensityThreshold);
		tagList.add(TagFromName.TerminationTimeThreshold);
		tagList.add(TagFromName.TerminationCardiacTriggerCountThreshold);
		tagList.add(TagFromName.TerminationRespiratoryTriggerCountThreshold);
		tagList.add(TagFromName.DetectorGeometry);
		tagList.add(TagFromName.TransverseDetectorSeparation);
		tagList.add(TagFromName.AxialDetectorDimension);
		tagList.add(TagFromName.RadiopharmaceuticalAgentNumber);
		tagList.add(TagFromName.PETFrameAcquisitionSequence);
		tagList.add(TagFromName.PETDetectorMotionDetailsSequence);
		tagList.add(TagFromName.PETTableDynamicsSequence);
		tagList.add(TagFromName.PETPositionSequence);
		tagList.add(TagFromName.PETFrameCorrectionFactorsSequence);
		tagList.add(TagFromName.RadiopharmaceuticalUsageSequence);
		tagList.add(TagFromName.AttenuationCorrectionSource);
		tagList.add(TagFromName.NumberOfIterations);
		tagList.add(TagFromName.NumberOfSubsets);
		tagList.add(TagFromName.PETReconstructionSequence);
		tagList.add(TagFromName.PETFrameTypeSequence);
		tagList.add(TagFromName.TimeOfFlightInformationUsed);
		tagList.add(TagFromName.ReconstructionType);
		tagList.add(TagFromName.DecayCorrected);
		tagList.add(TagFromName.AttenuationCorrected);
		tagList.add(TagFromName.ScatterCorrected);
		tagList.add(TagFromName.DeadTimeCorrected);
		tagList.add(TagFromName.GantryMotionCorrected);
		tagList.add(TagFromName.PatientMotionCorrected);
		tagList.add(TagFromName.CountLossNormalizationCorrected);
		tagList.add(TagFromName.RandomsCorrected);
		tagList.add(TagFromName.NonUniformRadialSamplingCorrected);
		tagList.add(TagFromName.SensitivityCalibrated);
		tagList.add(TagFromName.DetectorNormalizationCorrection);
		tagList.add(TagFromName.IterativeReconstructionMethod);
		tagList.add(TagFromName.AttenuationCorrectionTemporalRelationship);
		tagList.add(TagFromName.PatientPhysiologicalStateSequence);
		tagList.add(TagFromName.PatientPhysiologicalStateCodeSequence);
		tagList.add(TagFromName.DepthsOfFocus);
		tagList.add(TagFromName.ExcludedIntervalsSequence);
		tagList.add(TagFromName.ExclusionStartDatetime);
		tagList.add(TagFromName.ExclusionDuration);
		tagList.add(TagFromName.USImageDescriptionSequence);
		tagList.add(TagFromName.ImageDataTypeSequence);
		tagList.add(TagFromName.DataType);
		tagList.add(TagFromName.TransducerScanPatternCodeSequence);
		tagList.add(TagFromName.AliasedDataType);
		tagList.add(TagFromName.PositionMeasuringDeviceUsed);
		tagList.add(TagFromName.TransducerGeometryCodeSequence);
		tagList.add(TagFromName.TransducerBeamSteeringCodeSequence);
		tagList.add(TagFromName.TransducerApplicationCodeSequence);
		tagList.add(TagFromName.ContributingEquipmentSequence);
		tagList.add(TagFromName.ContributionDateTime);
		tagList.add(TagFromName.ContributionDescription);
		tagList.add(TagFromName.StudyInstanceUID);
		tagList.add(TagFromName.SeriesInstanceUID);
		tagList.add(TagFromName.StudyID);
		tagList.add(TagFromName.SeriesNumber);
		tagList.add(TagFromName.AcquisitionNumber);
		tagList.add(TagFromName.InstanceNumber);
		tagList.add(TagFromName.IsotopeNumber);
		tagList.add(TagFromName.PhaseNumber);
		tagList.add(TagFromName.IntervalNumber);
		tagList.add(TagFromName.TimeSlotNumber);
		tagList.add(TagFromName.AngleNumber);
		tagList.add(TagFromName.ItemNumber);
		tagList.add(TagFromName.PatientOrientation);
		tagList.add(TagFromName.OverlayNumber);
		tagList.add(TagFromName.CurveNumber);
		tagList.add(TagFromName.LUTNumber);
		tagList.add(TagFromName.ImagePosition);
		tagList.add(TagFromName.ImagePositionPatient);
		tagList.add(TagFromName.ImageOrientation);
		tagList.add(TagFromName.ImageOrientationPatient);
		tagList.add(TagFromName.Location);
		tagList.add(TagFromName.FrameOfReferenceUID);
		tagList.add(TagFromName.Laterality);
		tagList.add(TagFromName.ImageLaterality);
		tagList.add(TagFromName.ImageGeometryType);
		tagList.add(TagFromName.MaskingImage);
		tagList.add(TagFromName.ReportNumberTrial);
		tagList.add(TagFromName.TemporalPositionIdentifier);
		tagList.add(TagFromName.NumberOfTemporalPositions);
		tagList.add(TagFromName.TemporalResolution);
		tagList.add(TagFromName.SynchronizationFrameOfReferenceUID);
		tagList.add(TagFromName.SeriesInStudy);
		tagList.add(TagFromName.AcquisitionsInSeries);
		tagList.add(TagFromName.ImagesInAcquisition);
		tagList.add(TagFromName.ImagesInSeries);
		tagList.add(TagFromName.AcquisitionsInStudy);
		tagList.add(TagFromName.ImagesInStudy);
		tagList.add(TagFromName.Reference);
		tagList.add(TagFromName.PositionReferenceIndicator);
		tagList.add(TagFromName.SliceLocation);
		tagList.add(TagFromName.OtherStudyNumbers);
		tagList.add(TagFromName.NumberOfPatientRelatedStudies);
		tagList.add(TagFromName.NumberOfPatientRelatedSeries);
		tagList.add(TagFromName.NumberOfPatientRelatedInstances);
		tagList.add(TagFromName.NumberOfStudyRelatedSeries);
		tagList.add(TagFromName.NumberOfStudyRelatedInstances);
		tagList.add(TagFromName.NumberOfSeriesRelatedInstances);
		tagList.add(TagFromName.SourceImageID);
		tagList.add(TagFromName.ModifyingDeviceID);
		tagList.add(TagFromName.ModifiedImageID);
		tagList.add(TagFromName.ModifiedImageDate);
		tagList.add(TagFromName.ModifyingDeviceManufacturer);
		tagList.add(TagFromName.ModifiedImageTime);
		tagList.add(TagFromName.ModifiedImageDescription);
		tagList.add(TagFromName.ImageComments);
		tagList.add(TagFromName.OriginalImageIdentification);
		tagList.add(TagFromName.OriginalImageIdentificationNomenclature);
		tagList.add(TagFromName.StackID);
		tagList.add(TagFromName.InStackPositionNumber);
		tagList.add(TagFromName.FrameAnatomySequence);
		tagList.add(TagFromName.FrameLaterality);
		tagList.add(TagFromName.FrameContentSequence);
		tagList.add(TagFromName.PlanePositionSequence);
		tagList.add(TagFromName.PlaneOrientationSequence);
		tagList.add(TagFromName.TemporalPositionIndex);
		tagList.add(TagFromName.NominalCardiacTriggerDelayTime);
		tagList.add(TagFromName.FrameAcquisitionNumber);
		tagList.add(TagFromName.DimensionIndexValues);
		tagList.add(TagFromName.FrameComments);
		tagList.add(TagFromName.ConcatenationUID);
		tagList.add(TagFromName.InConcatenationNumber);
		tagList.add(TagFromName.InConcatenationTotalNumber);
		tagList.add(TagFromName.DimensionOrganizationUID);
		tagList.add(TagFromName.DimensionIndexPointer);
		tagList.add(TagFromName.FunctionalGroupPointer);
		tagList.add(TagFromName.DimensionIndexPrivateCreator);
		tagList.add(TagFromName.DimensionOrganizationSequence);
		tagList.add(TagFromName.DimensionIndexSequence);
		tagList.add(TagFromName.ConcatenationFrameOffsetNumber);
		tagList.add(TagFromName.FunctionalGroupPrivateCreator);
		tagList.add(TagFromName.NominalPercentageOfCardiacPhase);
		tagList.add(TagFromName.NominalPercentageOfRespiratoryPhase);
		tagList.add(TagFromName.StartingRespiratoryAmplitude);
		tagList.add(TagFromName.StartingRespiratoryPhase);
		tagList.add(TagFromName.EndingRespiratoryAmplitude);
		tagList.add(TagFromName.EndingRespiratoryPhase);
		tagList.add(TagFromName.RespiratoryTriggerType);
		tagList.add(TagFromName.RRIntervalTimeNominal);
		tagList.add(TagFromName.ActualCardiacTriggerDelayTime);
		tagList.add(TagFromName.RespiratorySynchronizationSequence);
		tagList.add(TagFromName.RespiratoryIntervalTime);
		tagList.add(TagFromName.NominalRespiratoryTriggerDelayTime);
		tagList.add(TagFromName.RespiratoryTriggerDelayThreshold);
		tagList.add(TagFromName.ActualRespiratoryTriggerDelayTime);
		tagList.add(TagFromName.ImagePositionVolume);
		tagList.add(TagFromName.ImageOrientationVolume);
		tagList.add(TagFromName.UltrasoundAcquisitionGeometry);
		tagList.add(TagFromName.ApexPosition);
		tagList.add(TagFromName.VolumeToTransducerMappingMatrix);
		tagList.add(TagFromName.VolumeToTableMappingMatrix);
		tagList.add(TagFromName.PatientFrameofReferenceSource);
		tagList.add(TagFromName.TemporalPositionTimeOffset);
		tagList.add(TagFromName.PlanePositionVolumeSequence);
		tagList.add(TagFromName.PlaneOrientationVolumeSequence);
		tagList.add(TagFromName.TemporalPositionSequence);
		tagList.add(TagFromName.DimensionOrganizationType);
		tagList.add(TagFromName.VolumeFrameOfReferenceUID);
		tagList.add(TagFromName.TableFrameOfReferenceUID);
		tagList.add(TagFromName.DimensionDescriptionLabel);
		tagList.add(TagFromName.PatientOrientationInFrameSequence);
		tagList.add(TagFromName.FrameLabel);
		tagList.add(TagFromName.AcquisitionIndex);
		tagList.add(TagFromName.ContributingSOPInstancesReferenceSequence);
		tagList.add(TagFromName.ReconstructionIndex);
		tagList.add(TagFromName.LightPathFilterPassThroughWavelength);
		tagList.add(TagFromName.LightPathFilterPassBand);
		tagList.add(TagFromName.ImagePathFilterPassThroughWavelength);
		tagList.add(TagFromName.ImagePathFilterPassBand);
		tagList.add(TagFromName.PatientEyeMovementCommanded);
		tagList.add(TagFromName.PatientEyeMovementCommandedCodeSequence);
		tagList.add(TagFromName.SphericalLensPower);
		tagList.add(TagFromName.CylinderLensPower);
		tagList.add(TagFromName.CylinderAxis);
		tagList.add(TagFromName.EmmetropicMagnification);
		tagList.add(TagFromName.IntraOcularPressure);
		tagList.add(TagFromName.HorizontalFieldOfView);
		tagList.add(TagFromName.PupilDilated);
		tagList.add(TagFromName.DegreeOfDilation);
		tagList.add(TagFromName.StereoBaselineAngle);
		tagList.add(TagFromName.StereoBaselineDisplacement);
		tagList.add(TagFromName.StereoHorizontalPixelOffset);
		tagList.add(TagFromName.StereoVerticalPixelOffset);
		tagList.add(TagFromName.StereoRotation);
		tagList.add(TagFromName.AcquisitionDeviceTypeCodeSequence);
		tagList.add(TagFromName.IlluminationTypeCodeSequence);
		tagList.add(TagFromName.LightPathFilterTypeStackCodeSequence);
		tagList.add(TagFromName.ImagePathFilterTypeStackCodeSequence);
		tagList.add(TagFromName.LensesCodeSequence);
		tagList.add(TagFromName.ChannelDescriptionCodeSequence);
		tagList.add(TagFromName.RefractiveStateSequence);
		tagList.add(TagFromName.MydriaticAgentCodeSequence);
		tagList.add(TagFromName.RelativeImagePositionCodeSequence);
		tagList.add(TagFromName.StereoPairsSequence);
		tagList.add(TagFromName.LeftImageSequence);
		tagList.add(TagFromName.RightImageSequence);
		tagList.add(TagFromName.AxialLengthOfEye);
		tagList.add(TagFromName.OphthalmicFrameLocationSequence);
		tagList.add(TagFromName.ReferenceCoordinates);
		tagList.add(TagFromName.DepthSpatialResolution);
		tagList.add(TagFromName.MaximumDepthDistortion);
		tagList.add(TagFromName.AlongScanSpatialResolution);
		tagList.add(TagFromName.MaximumAlongScanDistortion);
		tagList.add(TagFromName.OphthalmicImageOrientation);
		tagList.add(TagFromName.DepthOfTransverseImage);
		tagList.add(TagFromName.MydriaticAgentConcentrationUnitsSequence);
		tagList.add(TagFromName.AcrossScanSpatialResolution);
		tagList.add(TagFromName.MaximumAcrossScanDistortion);
		tagList.add(TagFromName.MydriaticAgentConcentration);
		tagList.add(TagFromName.IlluminationWaveLength);
		tagList.add(TagFromName.IlluminationPower);
		tagList.add(TagFromName.IlluminationBandwidth);
		tagList.add(TagFromName.MydriaticAgentSequence);
		tagList.add(TagFromName.SamplesPerPixel);
		tagList.add(TagFromName.SamplesPerPixelUsed);
		tagList.add(TagFromName.PhotometricInterpretation);
		tagList.add(TagFromName.ImageDimensions);
		tagList.add(TagFromName.PlanarConfiguration);
		tagList.add(TagFromName.NumberOfFrames);
		tagList.add(TagFromName.FrameIncrementPointer);
		tagList.add(TagFromName.FrameDimensionPointer);
		tagList.add(TagFromName.Rows);
		tagList.add(TagFromName.Columns);
		tagList.add(TagFromName.Planes);
		tagList.add(TagFromName.UltrasoundColorDataPresent);
		tagList.add(TagFromName.PixelSpacing);
		tagList.add(TagFromName.ZoomFactor);
		tagList.add(TagFromName.ZoomCenter);
		tagList.add(TagFromName.PixelAspectRatio);
		tagList.add(TagFromName.ImageFormat);
		tagList.add(TagFromName.ManipulatedImage);
		tagList.add(TagFromName.CorrectedImage);
		tagList.add(TagFromName.CompressionRecognitionCode);
		tagList.add(TagFromName.CompressionCode);
		tagList.add(TagFromName.CompressionOriginator);
		tagList.add(TagFromName.CompressionLabel);
		tagList.add(TagFromName.CompressionDescription);
		tagList.add(TagFromName.CompressionSequence);
		tagList.add(TagFromName.CompressionStepPointers);
		tagList.add(TagFromName.RepeatInterval);
		tagList.add(TagFromName.BitsGrouped);
		tagList.add(TagFromName.PerimeterTable);
		tagList.add(TagFromName.PerimeterValue);
		tagList.add(TagFromName.PredictorRows);
		tagList.add(TagFromName.PredictorColumns);
		tagList.add(TagFromName.PredictorConstants);
		tagList.add(TagFromName.BlockedPixels);
		tagList.add(TagFromName.BlockRows);
		tagList.add(TagFromName.BlockColumns);
		tagList.add(TagFromName.RowOverlap);
		tagList.add(TagFromName.ColumnOverlap);
		tagList.add(TagFromName.BitsAllocated);
		tagList.add(TagFromName.BitsStored);
		tagList.add(TagFromName.HighBit);
		tagList.add(TagFromName.PixelRepresentation);
		tagList.add(TagFromName.SmallestValidPixelValue);
		tagList.add(TagFromName.LargestValidPixelValue);
		tagList.add(TagFromName.SmallestImagePixelValue);
		tagList.add(TagFromName.LargestImagePixelValue);
		tagList.add(TagFromName.SmallestPixelValueInSeries);
		tagList.add(TagFromName.LargestPixelValueInSeries);
		tagList.add(TagFromName.SmallestPixelValueInPlane);
		tagList.add(TagFromName.LargestPixelValueInPlane);
		tagList.add(TagFromName.PixelPaddingValue);
		tagList.add(TagFromName.PixelPaddingRangeLimit);
		tagList.add(TagFromName.ImageLocation);
		tagList.add(TagFromName.QualityControlImage);
		tagList.add(TagFromName.BurnedInAnnotation);
		tagList.add(TagFromName.TransformLabel);
		tagList.add(TagFromName.TransformVersionNumber);
		tagList.add(TagFromName.SequenceOfCompressedData);
		tagList.add(TagFromName.DCTLabel);
		tagList.add(TagFromName.DataBlockDescription);
		tagList.add(TagFromName.DataBlock);
		tagList.add(TagFromName.NormalizationFactorFormat);
		tagList.add(TagFromName.ZonalMapNumberFormat);
		tagList.add(TagFromName.ZonalMapLocation);
		tagList.add(TagFromName.ZonalMapFormat);
		tagList.add(TagFromName.AdaptiveMapFormat);
		tagList.add(TagFromName.CodeNumberFormat);
		tagList.add(TagFromName.PixelSpacingCalibrationType);
		tagList.add(TagFromName.PixelSpacingCalibrationDescription);
		tagList.add(TagFromName.PixelIntensityRelationship);
		tagList.add(TagFromName.PixelIntensityRelationshipSign);
		tagList.add(TagFromName.WindowCenter);
		tagList.add(TagFromName.WindowWidth);
		tagList.add(TagFromName.RescaleIntercept);
		tagList.add(TagFromName.RescaleSlope);
		tagList.add(TagFromName.RescaleType);
		tagList.add(TagFromName.WindowCenterWidthExplanation);
		tagList.add(TagFromName.VOILUTFunction);
		tagList.add(TagFromName.GrayScale);
		tagList.add(TagFromName.RecommendedViewingMode);
		tagList.add(TagFromName.GrayLookupTableDescriptor);
		tagList.add(TagFromName.RedPaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.GreenPaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.BluePaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.AlphaPaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.LargeRedPaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.LargeGreenPaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.LargeBluePaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.PaletteColorLookupTableUID);
		tagList.add(TagFromName.GrayLookupTableData);
		tagList.add(TagFromName.RedPaletteColorLookupTableData);
		tagList.add(TagFromName.GreenPaletteColorLookupTableData);
		tagList.add(TagFromName.BluePaletteColorLookupTableData);
		tagList.add(TagFromName.AlphaPaletteColorLookupTableData);
		tagList.add(TagFromName.LargeRedPaletteColorLookupTableData);
		tagList.add(TagFromName.LargeGreenPaletteColorLookupTableData);
		tagList.add(TagFromName.LargeBluePaletteColorLookupTableData);
		tagList.add(TagFromName.LargePaletteColorLookupTableUID);
		tagList.add(TagFromName.SegmentedRedPaletteColorLookupTableData);
		tagList.add(TagFromName.SegmentedGreenPaletteColorLookupTableData);
		tagList.add(TagFromName.SegmentedBluePaletteColorLookupTableData);
		tagList.add(TagFromName.BreastImplantPresent);
		tagList.add(TagFromName.PartialView);
		tagList.add(TagFromName.PartialViewDescription);
		tagList.add(TagFromName.PartialViewCodeSequence);
		tagList.add(TagFromName.SpatialLocationsPreserved);
		tagList.add(TagFromName.DataFrameAssignmentSequence);
		tagList.add(TagFromName.DataPathAssignment);
		tagList.add(TagFromName.BitsMappedToColorLookupTable);
		tagList.add(TagFromName.BlendingLUT1Sequence);
		tagList.add(TagFromName.BlendingLUT1TransferFunction);
		tagList.add(TagFromName.BlendingWeightConstant);
		tagList.add(TagFromName.BlendingLookupTableDescriptor);
		tagList.add(TagFromName.BlendingLookupTableData);
		tagList.add(TagFromName.EnhancedPaletteColorLookupTableSequence);
		tagList.add(TagFromName.BlendingLUT2Sequence);
		tagList.add(TagFromName.BlendingLUT2TransferFunction);
		tagList.add(TagFromName.DataPathID);
		tagList.add(TagFromName.RGBLUTTransferFunction);
		tagList.add(TagFromName.AlphaLUTTransferFunction);
		tagList.add(TagFromName.ICCProfile);
		tagList.add(TagFromName.LossyImageCompression);
		tagList.add(TagFromName.LossyImageCompressionRatio);
		tagList.add(TagFromName.LossyImageCompressionMethod);
		tagList.add(TagFromName.ModalityLUTSequence);
		tagList.add(TagFromName.LUTDescriptor);
		tagList.add(TagFromName.LUTExplanation);
		tagList.add(TagFromName.ModalityLUTType);
		tagList.add(TagFromName.LUTData);
		tagList.add(TagFromName.VOILUTSequence);
		tagList.add(TagFromName.SoftcopyVOILUTSequence);
		tagList.add(TagFromName.ImagePresentationComments);
		tagList.add(TagFromName.BiplaneAcquisitionSequence);
		tagList.add(TagFromName.RepresentativeFrameNumber);
		tagList.add(TagFromName.FrameNumbersOfInterest);
		tagList.add(TagFromName.FrameOfInterestDescription);
		tagList.add(TagFromName.FrameOfInterestType);
		tagList.add(TagFromName.MaskPointer);
		tagList.add(TagFromName.RWavePointer);
		tagList.add(TagFromName.MaskSubtractionSequence);
		tagList.add(TagFromName.MaskOperation);
		tagList.add(TagFromName.ApplicableFrameRange);
		tagList.add(TagFromName.MaskFrameNumbers);
		tagList.add(TagFromName.ContrastFrameAveraging);
		tagList.add(TagFromName.MaskSubPixelShift);
		tagList.add(TagFromName.TIDOffset);
		tagList.add(TagFromName.MaskOperationExplanation);
		tagList.add(TagFromName.PixelDataProviderURL);
		tagList.add(TagFromName.DataPointRows);
		tagList.add(TagFromName.DataPointColumns);
		tagList.add(TagFromName.SignalDomainColumns);
		tagList.add(TagFromName.LargestMonochromePixelValue);
		tagList.add(TagFromName.DataRepresentation);
		tagList.add(TagFromName.PixelMeasuresSequence);
		tagList.add(TagFromName.FrameVOILUTSequence);
		tagList.add(TagFromName.PixelValueTransformationSequence);
		tagList.add(TagFromName.SignalDomainRows);
		tagList.add(TagFromName.DisplayFilterPercentage);
		tagList.add(TagFromName.FramePixelShiftSequence);
		tagList.add(TagFromName.SubtractionItemID);
		tagList.add(TagFromName.PixelIntensityRelationshipLUTSequence);
		tagList.add(TagFromName.FramePixelDataPropertiesSequence);
		tagList.add(TagFromName.GeometricalProperties);
		tagList.add(TagFromName.GeometricMaximumDistortion);
		tagList.add(TagFromName.ImageProcessingApplied);
		tagList.add(TagFromName.MaskSelectionMode);
		tagList.add(TagFromName.LUTFunction);
		tagList.add(TagFromName.MaskVisibilityPercentage);
		tagList.add(TagFromName.PixelShiftSequence);
		tagList.add(TagFromName.RegionPixelShiftSequence);
		tagList.add(TagFromName.VerticesOfTheRegion);
		tagList.add(TagFromName.MultiframePresentationSequence);
		tagList.add(TagFromName.PixelShiftFrameRange);
		tagList.add(TagFromName.LUTFrameRange);
		tagList.add(TagFromName.ImageToEquipmentMappingMatrix);
		tagList.add(TagFromName.EquipmentCoordinateSystemIdentification);
		tagList.add(TagFromName.StudyStatusID);
		tagList.add(TagFromName.StudyPriorityID);
		tagList.add(TagFromName.StudyIDIssuer);
		tagList.add(TagFromName.StudyVerifiedDate);
		tagList.add(TagFromName.StudyVerifiedTime);
		tagList.add(TagFromName.StudyReadDate);
		tagList.add(TagFromName.StudyReadTime);
		tagList.add(TagFromName.ScheduledStudyStartDate);
		tagList.add(TagFromName.ScheduledStudyStartTime);
		tagList.add(TagFromName.ScheduledStudyStopDate);
		tagList.add(TagFromName.ScheduledStudyStopTime);
		tagList.add(TagFromName.ScheduledStudyLocation);
		tagList.add(TagFromName.ScheduledStudyLocationAETitle);
		tagList.add(TagFromName.ReasonForStudy);
		tagList.add(TagFromName.RequestingPhysicianIdentificationSequence);
		tagList.add(TagFromName.RequestingPhysician);
		tagList.add(TagFromName.RequestingService);
		tagList.add(TagFromName.StudyArrivalDate);
		tagList.add(TagFromName.StudyArrivalTime);
		tagList.add(TagFromName.StudyCompletionDate);
		tagList.add(TagFromName.StudyCompletionTime);
		tagList.add(TagFromName.StudyComponentStatusID);
		tagList.add(TagFromName.RequestedProcedureDescription);
		tagList.add(TagFromName.RequestedProcedureCodeSequence);
		tagList.add(TagFromName.RequestedContrastAgent);
		tagList.add(TagFromName.StudyComments);
		tagList.add(TagFromName.ReferencedPatientAliasSequence);
		tagList.add(TagFromName.VisitStatusID);
		tagList.add(TagFromName.AdmissionID);
		tagList.add(TagFromName.IssuerOfAdmissionID);
		tagList.add(TagFromName.IssuerOfAdmissionIDSequence);
		tagList.add(TagFromName.RouteOfAdmissions);
		tagList.add(TagFromName.ScheduledAdmissionDate);
		tagList.add(TagFromName.ScheduledAdmissionTime);
		tagList.add(TagFromName.ScheduledDischargeDate);
		tagList.add(TagFromName.ScheduledDischargeTime);
		tagList.add(TagFromName.ScheduledPatientInstitutionResidence);
		tagList.add(TagFromName.AdmittingDate);
		tagList.add(TagFromName.AdmittingTime);
		tagList.add(TagFromName.DischargeDate);
		tagList.add(TagFromName.DischargeTime);
		tagList.add(TagFromName.DischargeDiagnosisDescription);
		tagList.add(TagFromName.DischargeDiagnosisCodeSequence);
		tagList.add(TagFromName.SpecialNeeds);
		tagList.add(TagFromName.ServiceEpisodeID);
		tagList.add(TagFromName.IssuerOfServiceEpisodeID);
		tagList.add(TagFromName.ServiceEpisodeDescription);
		tagList.add(TagFromName.IssuerOfServiceEpisodeIDSequence);
		tagList.add(TagFromName.PertinentDocumentsSequence);
		tagList.add(TagFromName.CurrentPatientLocation);
		tagList.add(TagFromName.PatientInstitutionResidence);
		tagList.add(TagFromName.PatientState);
		tagList.add(TagFromName.PatientClinicalTrialParticipationSequence);
		tagList.add(TagFromName.VisitComments);
		tagList.add(TagFromName.WaveformOriginality);
		tagList.add(TagFromName.NumberOfWaveformChannels);
		tagList.add(TagFromName.NumberOfWaveformSamples);
		tagList.add(TagFromName.SamplingFrequency);
		tagList.add(TagFromName.MultiplexGroupLabel);
		tagList.add(TagFromName.ChannelDefinitionSequence);
		tagList.add(TagFromName.WaveformChannelNumber);
		tagList.add(TagFromName.ChannelLabel);
		tagList.add(TagFromName.ChannelStatus);
		tagList.add(TagFromName.ChannelSourceSequence);
		tagList.add(TagFromName.ChannelSourceModifiersSequence);
		tagList.add(TagFromName.SourceWaveformSequence);
		tagList.add(TagFromName.ChannelDerivationDescription);
		tagList.add(TagFromName.ChannelSensitivity);
		tagList.add(TagFromName.ChannelSensitivityUnitsSequence);
		tagList.add(TagFromName.ChannelSensitivityCorrectionFactor);
		tagList.add(TagFromName.ChannelBaseline);
		tagList.add(TagFromName.ChannelTimeSkew);
		tagList.add(TagFromName.ChannelSampleSkew);
		tagList.add(TagFromName.ChannelOffset);
		tagList.add(TagFromName.WaveformBitsStored);
		tagList.add(TagFromName.FilterLowFrequency);
		tagList.add(TagFromName.FilterHighFrequency);
		tagList.add(TagFromName.NotchFilterFrequency);
		tagList.add(TagFromName.NotchFilterBandwidth);
		tagList.add(TagFromName.WaveformDataDisplayScale);
		tagList.add(TagFromName.WaveformDisplayBackgroundCIELabValue);
		tagList.add(TagFromName.WaveformPresentationGroupSequence);
		tagList.add(TagFromName.PresentationGroupNumber);
		tagList.add(TagFromName.ChannelDisplaySequence);
		tagList.add(TagFromName.ChannelRecommendedDisplayCIELabValue);
		tagList.add(TagFromName.ChannelPosition);
		tagList.add(TagFromName.DisplayShadingFlag);
		tagList.add(TagFromName.FractionalChannelDisplayScale);
		tagList.add(TagFromName.AbsoluteChannelDisplayScale);
		tagList.add(TagFromName.MultiplexedAudioChannelsDescriptionCodeSequence);
		tagList.add(TagFromName.ChannelIdentificationCode);
		tagList.add(TagFromName.ChannelMode);
		tagList.add(TagFromName.ScheduledStationAETitle);
		tagList.add(TagFromName.ScheduledProcedureStepStartDate);
		tagList.add(TagFromName.ScheduledProcedureStepStartTime);
		tagList.add(TagFromName.ScheduledProcedureStepEndDate);
		tagList.add(TagFromName.ScheduledProcedureStepEndTime);
		tagList.add(TagFromName.ScheduledPerformingPhysicianName);
		tagList.add(TagFromName.ScheduledProcedureStepDescription);
		tagList.add(TagFromName.ScheduledProtocolCodeSequence);
		tagList.add(TagFromName.ScheduledProcedureStepID);
		tagList.add(TagFromName.StageCodeSequence);
		tagList.add(TagFromName.ScheduledPerformingPhysicianIdentificationSequence);
		tagList.add(TagFromName.ScheduledStationName);
		tagList.add(TagFromName.ScheduledProcedureStepLocation);
		tagList.add(TagFromName.PreMedication);
		tagList.add(TagFromName.ScheduledProcedureStepStatus);
		tagList.add(TagFromName.OrderPlacerIdentifierSequence);
		tagList.add(TagFromName.OrderFillerIdentifierSequence);
		tagList.add(TagFromName.LocalNamespaceEntityID);
		tagList.add(TagFromName.UniversalEntityID);
		tagList.add(TagFromName.UniversalEntityIDType);
		tagList.add(TagFromName.IdentifierTypeCode);
		tagList.add(TagFromName.AssigningFacilitySequence);
		tagList.add(TagFromName.AssigningJurisdictionCodeSequence);
		tagList.add(TagFromName.AssigningAgencyOrDepartmentCodeSequence);
		tagList.add(TagFromName.ScheduledProcedureStepSequence);
		tagList.add(TagFromName.ReferencedNonImageCompositeSOPInstanceSequence);
		tagList.add(TagFromName.PerformedStationAETitle);
		tagList.add(TagFromName.PerformedStationName);
		tagList.add(TagFromName.PerformedLocation);
		tagList.add(TagFromName.PerformedProcedureStepStartDate);
		tagList.add(TagFromName.PerformedProcedureStepStartTime);
		tagList.add(TagFromName.PerformedProcedureStepEndDate);
		tagList.add(TagFromName.PerformedProcedureStepEndTime);
		tagList.add(TagFromName.PerformedProcedureStepStatus);
		tagList.add(TagFromName.PerformedProcedureStepID);
		tagList.add(TagFromName.PerformedProcedureStepDescription);
		tagList.add(TagFromName.PerformedProcedureTypeDescription);
		tagList.add(TagFromName.PerformedProtocolCodeSequence);
		tagList.add(TagFromName.PerformedProtocolType);
		tagList.add(TagFromName.ScheduledStepAttributesSequence);
		tagList.add(TagFromName.RequestAttributesSequence);
		tagList.add(TagFromName.CommentsOnPerformedProcedureStep);
		tagList.add(TagFromName.PerformedProcedureStepDiscontinuationReasonCodeSequence);
		tagList.add(TagFromName.QuantitySequence);
		tagList.add(TagFromName.Quantity);
		tagList.add(TagFromName.MeasuringUnitsSequence);
		tagList.add(TagFromName.BillingItemSequence);
		tagList.add(TagFromName.TotalTimeOfFluoroscopy);
		tagList.add(TagFromName.TotalNumberOfExposures);
		tagList.add(TagFromName.EntranceDose);
		tagList.add(TagFromName.ExposedArea);
		tagList.add(TagFromName.DistanceSourceToEntrance);
		tagList.add(TagFromName.DistanceSourceToSupport);
		tagList.add(TagFromName.ExposureDoseSequence);
		tagList.add(TagFromName.CommentsOnRadiationDose);
		tagList.add(TagFromName.XRayOutput);
		tagList.add(TagFromName.HalfValueLayer);
		tagList.add(TagFromName.OrganDose);
		tagList.add(TagFromName.OrganExposed);
		tagList.add(TagFromName.BillingProcedureStepSequence);
		tagList.add(TagFromName.FilmConsumptionSequence);
		tagList.add(TagFromName.BillingSuppliesAndDevicesSequence);
		tagList.add(TagFromName.ReferencedProcedureStepSequence);
		tagList.add(TagFromName.PerformedSeriesSequence);
		tagList.add(TagFromName.CommentsOnScheduledProcedureStep);
		tagList.add(TagFromName.ProtocolContextSequence);
		tagList.add(TagFromName.ContentItemModifierSequence);
		tagList.add(TagFromName.ScheduledSpecimenSequence);
		tagList.add(TagFromName.SpecimenAccessionNumber);
		tagList.add(TagFromName.ContainerIdentifier);
		tagList.add(TagFromName.IssuerOfTheContainerIdentifierSequence);
		tagList.add(TagFromName.AlternateContainerIdentifierSequence);
		tagList.add(TagFromName.ContainerTypeCodeSequence);
		tagList.add(TagFromName.ContainerDescription);
		tagList.add(TagFromName.ContainerComponentSequence);
		tagList.add(TagFromName.SpecimenSequence);
		tagList.add(TagFromName.SpecimenIdentifier);
		tagList.add(TagFromName.SpecimenDescriptionSequenceTrial);
		tagList.add(TagFromName.SpecimenDescriptionTrial);
		tagList.add(TagFromName.SpecimenUID);
		tagList.add(TagFromName.AcquisitionContextSequence);
		tagList.add(TagFromName.AcquisitionContextDescription);
		tagList.add(TagFromName.SpecimenDescriptionSequence);
		tagList.add(TagFromName.IssuerOfTheSpecimenIdentifierSequence);
		tagList.add(TagFromName.SpecimenTypeCodeSequence);
		tagList.add(TagFromName.SpecimenShortDescription);
		tagList.add(TagFromName.SpecimenDetailedDescription);
		tagList.add(TagFromName.SpecimenPreparationSequence);
		tagList.add(TagFromName.SpecimenPreparationStepContentItemSequence);
		tagList.add(TagFromName.SpecimenLocalizationContentItemSequence);
		tagList.add(TagFromName.SlideIdentifier);
		tagList.add(TagFromName.ImageCenterPointCoordinatesSequence);
		tagList.add(TagFromName.XOffsetInSlideCoordinateSystem);
		tagList.add(TagFromName.YOffsetInSlideCoordinateSystem);
		tagList.add(TagFromName.ZOffsetInSlideCoordinateSystem);
		tagList.add(TagFromName.PixelSpacingSequence);
		tagList.add(TagFromName.CoordinateSystemAxisCodeSequence);
		tagList.add(TagFromName.MeasurementUnitsCodeSequence);
		tagList.add(TagFromName.VitalStainCodeSequenceTrial);
		tagList.add(TagFromName.RequestedProcedureID);
		tagList.add(TagFromName.ReasonForRequestedProcedure);
		tagList.add(TagFromName.RequestedProcedurePriority);
		tagList.add(TagFromName.PatientTransportArrangements);
		tagList.add(TagFromName.RequestedProcedureLocation);
		tagList.add(TagFromName.PlacerOrderNumberOfProcedure);
		tagList.add(TagFromName.FillerOrderNumberOfProcedure);
		tagList.add(TagFromName.ConfidentialityCode);
		tagList.add(TagFromName.ReportingPriority);
		tagList.add(TagFromName.ReasonForRequestedProcedureCodeSequence);
		tagList.add(TagFromName.NamesOfIntendedRecipientsOfResults);
		tagList.add(TagFromName.IntendedRecipientsOfResultsIdentificationSequence);
		tagList.add(TagFromName.PersonIdentificationCodeSequence);
		tagList.add(TagFromName.PersonAddress);
		tagList.add(TagFromName.PersonTelephoneNumbers);
		tagList.add(TagFromName.RequestedProcedureComments);
		tagList.add(TagFromName.ReasonForImagingServiceRequest);
		tagList.add(TagFromName.IssueDateOfImagingServiceRequest);
		tagList.add(TagFromName.IssueTimeOfImagingServiceRequest);
		tagList.add(TagFromName.PlacerOrderNumberOfImagingServiceRequestRetired);
		tagList.add(TagFromName.FillerOrderNumberOfImagingServiceRequestRetired);
		tagList.add(TagFromName.OrderEnteredBy);
		tagList.add(TagFromName.OrderEntererLocation);
		tagList.add(TagFromName.OrderCallbackPhoneNumber);
		tagList.add(TagFromName.PlacerOrderNumberOfImagingServiceRequest);
		tagList.add(TagFromName.FillerOrderNumberOfImagingServiceRequest);
		tagList.add(TagFromName.ImagingServiceRequestComments);
		tagList.add(TagFromName.ConfidentialityConstraintOnPatientDataDescription);
		tagList.add(TagFromName.GeneralPurposeScheduledProcedureStepStatus);
		tagList.add(TagFromName.GeneralPurposePerformedProcedureStepStatus);
		tagList.add(TagFromName.GeneralPurposeScheduledProcedureStepPriority);
		tagList.add(TagFromName.ScheduledProcessingApplicationsCodeSequence);
		tagList.add(TagFromName.ScheduledProcedureStepStartDateAndTime);
		tagList.add(TagFromName.MultipleCopiesFlag);
		tagList.add(TagFromName.PerformedProcessingApplicationsCodeSequence);
		tagList.add(TagFromName.HumanPerformerCodeSequence);
		tagList.add(TagFromName.ScheduledProcedureStepModificationDateAndTime);
		tagList.add(TagFromName.ExpectedCompletionDateAndTime);
		tagList.add(TagFromName.ResultingGeneralPurposePerformedProcedureStepsSequence);
		tagList.add(TagFromName.ReferencedGeneralPurposeScheduledProcedureStepSequence);
		tagList.add(TagFromName.ScheduledWorkitemCodeSequence);
		tagList.add(TagFromName.PerformedWorkitemCodeSequence);
		tagList.add(TagFromName.InputAvailabilityFlag);
		tagList.add(TagFromName.InputInformationSequence);
		tagList.add(TagFromName.RelevantInformationSequence);
		tagList.add(TagFromName.ReferencedGeneralPurposeScheduledProcedureStepTransactionUID);
		tagList.add(TagFromName.ScheduledStationNameCodeSequence);
		tagList.add(TagFromName.ScheduledStationClassCodeSequence);
		tagList.add(TagFromName.ScheduledStationGeographicLocationCodeSequence);
		tagList.add(TagFromName.PerformedStationNameCodeSequence);
		tagList.add(TagFromName.PerformedStationClassCodeSequence);
		tagList.add(TagFromName.PerformedStationGeographicLocationCodeSequence);
		tagList.add(TagFromName.RequestedSubsequentWorkitemCodeSequence);
		tagList.add(TagFromName.NonDICOMOutputCodeSequence);
		tagList.add(TagFromName.OutputInformationSequence);
		tagList.add(TagFromName.ScheduledHumanPerformersSequence);
		tagList.add(TagFromName.ActualHumanPerformersSequence);
		tagList.add(TagFromName.HumanPerformersOrganization);
		tagList.add(TagFromName.HumanPerformersName);
		tagList.add(TagFromName.EntranceDoseInmGy);
		tagList.add(TagFromName.ReferencedImageRealWorldValueMappingSequence);
		tagList.add(TagFromName.RealWorldValueMappingSequence);
		tagList.add(TagFromName.PixelValueMappingCodeSequence);
		tagList.add(TagFromName.LUTLabel);
		tagList.add(TagFromName.RealWorldValueLastValueMapped);
		tagList.add(TagFromName.RealWorldValueLUTData);
		tagList.add(TagFromName.RealWorldValueFirstValueMapped);
		tagList.add(TagFromName.RealWorldValueIntercept);
		tagList.add(TagFromName.RealWorldValueSlope);
		tagList.add(TagFromName.FindingsFlagTrial);
		tagList.add(TagFromName.RelationshipType);
		tagList.add(TagFromName.FindingsSequenceTrial);
		tagList.add(TagFromName.FindingsGroupUIDTrial);
		tagList.add(TagFromName.ReferencedFindingsGroupUIDTrial);
		tagList.add(TagFromName.FindingsGroupRecordingDateTrial);
		tagList.add(TagFromName.FindingsGroupRecordingTimeTrial);
		tagList.add(TagFromName.FindingsSourceCategoryCodeSequenceTrial);
		tagList.add(TagFromName.VerifyingOrganization);
		tagList.add(TagFromName.DocumentingOrganizationIdentifierCodeSequenceTrial);
		tagList.add(TagFromName.VerificationDateTime);
		tagList.add(TagFromName.ObservationDateTime);
		tagList.add(TagFromName.ValueType);
		tagList.add(TagFromName.ConceptNameCodeSequence);
		tagList.add(TagFromName.MeasurementPrecisionDescriptionTrial);
		tagList.add(TagFromName.ContinuityOfContent);
		tagList.add(TagFromName.UrgencyOrPriorityAlertsTrial);
		tagList.add(TagFromName.SequencingIndicatorTrial);
		tagList.add(TagFromName.DocumentIdentifierCodeSequenceTrial);
		tagList.add(TagFromName.DocumentAuthorTrial);
		tagList.add(TagFromName.DocumentAuthorIdentifierCodeSequenceTrial);
		tagList.add(TagFromName.IdentifierCodeSequenceTrial);
		tagList.add(TagFromName.VerifyingObserverSequence);
		tagList.add(TagFromName.ObjectBinaryIdentifierTrial);
		tagList.add(TagFromName.VerifyingObserverName);
		tagList.add(TagFromName.DocumentingObserverIdentifierCodeSequenceTrial);
		tagList.add(TagFromName.AuthorObserverSequence);
		tagList.add(TagFromName.ParticipantSequence);
		tagList.add(TagFromName.CustodialOrganizationSequence);
		tagList.add(TagFromName.ParticipationType);
		tagList.add(TagFromName.ParticipationDateTime);
		tagList.add(TagFromName.ObserverType);
		tagList.add(TagFromName.ProcedureIdentifierCodeSequenceTrial);
		tagList.add(TagFromName.VerifyingObserverIdentificationCodeSequence);
		tagList.add(TagFromName.ObjectDirectoryBinaryIdentifierTrial);
		tagList.add(TagFromName.EquivalentCDADocumentSequence);
		tagList.add(TagFromName.ReferencedWaveformChannels);
		tagList.add(TagFromName.DateOfDocumentOrVerbalTransactionTrial);
		tagList.add(TagFromName.TimeOfDocumentCreationOrVerbalTransactionTrial);
		tagList.add(TagFromName.DateTime);
		tagList.add(TagFromName.Date);
		tagList.add(TagFromName.Time);
		tagList.add(TagFromName.PersonName);
		tagList.add(TagFromName.UID);
		tagList.add(TagFromName.ReportStatusIDTrial);
		tagList.add(TagFromName.TemporalRangeType);
		tagList.add(TagFromName.ReferencedSamplePositions);
		tagList.add(TagFromName.ReferencedFrameNumbers);
		tagList.add(TagFromName.ReferencedTimeOffsets);
		tagList.add(TagFromName.ReferencedDateTime);
		tagList.add(TagFromName.TextValue);
		tagList.add(TagFromName.ObservationCategoryCodeSequenceTrial);
		tagList.add(TagFromName.ConceptCodeSequence);
		tagList.add(TagFromName.BibliographicCitationTrial);
		tagList.add(TagFromName.PurposeOfReferenceCodeSequence);
		tagList.add(TagFromName.ObservationUIDTrial);
		tagList.add(TagFromName.ReferencedObservationUIDTrial);
		tagList.add(TagFromName.ReferencedObservationClassTrial);
		tagList.add(TagFromName.ReferencedObjectObservationClassTrial);
		tagList.add(TagFromName.AnnotationGroupNumber);
		tagList.add(TagFromName.ObservationDateTrial);
		tagList.add(TagFromName.ObservationTimeTrial);
		tagList.add(TagFromName.MeasurementAutomationTrial);
		tagList.add(TagFromName.ModifierCodeSequence);
		tagList.add(TagFromName.IdentificationDescriptionTrial);
		tagList.add(TagFromName.CoordinatesSetGeometricTypeTrial);
		tagList.add(TagFromName.AlgorithmCodeSequenceTrial);
		tagList.add(TagFromName.AlgorithmDescriptionTrial);
		tagList.add(TagFromName.PixelCoordinatesSetTrial);
		tagList.add(TagFromName.MeasuredValueSequence);
		tagList.add(TagFromName.NumericValueQualifierCodeSequence);
		tagList.add(TagFromName.CurrentObserverTrial);
		tagList.add(TagFromName.NumericValue);
		tagList.add(TagFromName.ReferencedAccessionSequenceTrial);
		tagList.add(TagFromName.ReportStatusCommentTrial);
		tagList.add(TagFromName.ProcedureContextSequenceTrial);
		tagList.add(TagFromName.VerbalSourceTrial);
		tagList.add(TagFromName.AddressTrial);
		tagList.add(TagFromName.TelephoneNumberTrial);
		tagList.add(TagFromName.VerbalSourceIdentifierCodeSequenceTrial);
		tagList.add(TagFromName.PredecessorDocumentsSequence);
		tagList.add(TagFromName.ReferencedRequestSequence);
		tagList.add(TagFromName.PerformedProcedureCodeSequence);
		tagList.add(TagFromName.CurrentRequestedProcedureEvidenceSequence);
		tagList.add(TagFromName.ReportDetailSequenceTrial);
		tagList.add(TagFromName.PertinentOtherEvidenceSequence);
		tagList.add(TagFromName.HL7StructuredDocumentReferenceSequence);
		tagList.add(TagFromName.ObservationSubjectUIDTrial);
		tagList.add(TagFromName.ObservationSubjectClassTrial);
		tagList.add(TagFromName.ObservationSubjectTypeCodeSequenceTrial);
		tagList.add(TagFromName.CompletionFlag);
		tagList.add(TagFromName.CompletionFlagDescription);
		tagList.add(TagFromName.VerificationFlag);
		tagList.add(TagFromName.ArchiveRequested);
		tagList.add(TagFromName.PreliminaryFlag);
		tagList.add(TagFromName.ContentTemplateSequence);
		tagList.add(TagFromName.IdenticalDocumentsSequence);
		tagList.add(TagFromName.ObservationSubjectContextFlagTrial);
		tagList.add(TagFromName.ObserverContextFlagTrial);
		tagList.add(TagFromName.ProcedureContextFlagTrial);
		tagList.add(TagFromName.ContentSequence);
		tagList.add(TagFromName.RelationshipSequenceTrial);
		tagList.add(TagFromName.RelationshipTypeCodeSequenceTrial);
		tagList.add(TagFromName.LanguageCodeSequenceTrial);
		tagList.add(TagFromName.UniformResourceLocatorTrial);
		tagList.add(TagFromName.WaveformAnnotationSequence);
		tagList.add(TagFromName.TemplateIdentifier);
		tagList.add(TagFromName.TemplateVersion);
		tagList.add(TagFromName.TemplateLocalVersion);
		tagList.add(TagFromName.TemplateExtensionFlag);
		tagList.add(TagFromName.TemplateExtensionOrganizationUID);
		tagList.add(TagFromName.TemplateExtensionCreatorUID);
		tagList.add(TagFromName.RelationshipTypeCodeSequenceModifierTrial);
		tagList.add(TagFromName.ReferencedContentItemIdentifier);
		tagList.add(TagFromName.HL7InstanceIdentifier);
		tagList.add(TagFromName.HL7DocumentEffectiveTime);
		tagList.add(TagFromName.HL7DocumentTypeCodeSequence);
		tagList.add(TagFromName.RetrieveURI);
		tagList.add(TagFromName.RetrieveLocationUID);
		tagList.add(TagFromName.DocumentTitle);
		tagList.add(TagFromName.EncapsulatedDocument);
		tagList.add(TagFromName.MIMETypeOfEncapsulatedDocument);
		tagList.add(TagFromName.SourceInstanceSequence);
		tagList.add(TagFromName.ListOfMIMETypes);
		tagList.add(TagFromName.ProductPackageIdentifier);
		tagList.add(TagFromName.SubstanceAdministrationApproval);
		tagList.add(TagFromName.ApprovalStatusFurtherDescription);
		tagList.add(TagFromName.ApprovalStatusDateTime);
		tagList.add(TagFromName.ProductTypeCodeSequence);
		tagList.add(TagFromName.ProductName);
		tagList.add(TagFromName.ProductDescription);
		tagList.add(TagFromName.ProductLotIdentifier);
		tagList.add(TagFromName.ProductExpirationDateTime);
		tagList.add(TagFromName.SubstanceAdministrationDateTime);
		tagList.add(TagFromName.SubstanceAdministrationNotes);
		tagList.add(TagFromName.SubstanceAdministrationDeviceID);
		tagList.add(TagFromName.ProductParameterSequence);
		tagList.add(TagFromName.SubstanceAdministrationParameterSequence);
		tagList.add(TagFromName.LensDescription);
		tagList.add(TagFromName.RightLensSequence);
		tagList.add(TagFromName.LeftLensSequence);
		tagList.add(TagFromName.UnspecifiedLateralityLensSequence);
		tagList.add(TagFromName.CylinderSequence);
		tagList.add(TagFromName.PrismSequence);
		tagList.add(TagFromName.HorizontalPrismPower);
		tagList.add(TagFromName.HorizontalPrismBase);
		tagList.add(TagFromName.VerticalPrismPower);
		tagList.add(TagFromName.VerticalPrismBase);
		tagList.add(TagFromName.LensSegmentType);
		tagList.add(TagFromName.OpticalTransmittance);
		tagList.add(TagFromName.ChannelWidth);
		tagList.add(TagFromName.PupilSize);
		tagList.add(TagFromName.CornealSize);
		tagList.add(TagFromName.AutorefractionRightEyeSequence);
		tagList.add(TagFromName.AutorefractionLeftEyeSequence);
		tagList.add(TagFromName.DistancePupillaryDistance);
		tagList.add(TagFromName.NearPupillaryDistance);
		tagList.add(TagFromName.IntermediatePupillaryDistance);
		tagList.add(TagFromName.OtherPupillaryDistance);
		tagList.add(TagFromName.KeratometryRightEyeSequence);
		tagList.add(TagFromName.KeratometryLeftEyeSequence);
		tagList.add(TagFromName.SteepKeratometricAxisSequence);
		tagList.add(TagFromName.RadiusOfCurvature);
		tagList.add(TagFromName.KeratometricPower);
		tagList.add(TagFromName.KeratometricAxis);
		tagList.add(TagFromName.FlatKeratometricAxisSequence);
		tagList.add(TagFromName.BackgroundColor);
		tagList.add(TagFromName.Optotype);
		tagList.add(TagFromName.OptotypePresentation);
		tagList.add(TagFromName.SubjectiveRefractionRightEyeSequence);
		tagList.add(TagFromName.SubjectiveRefractionLeftEyeSequence);
		tagList.add(TagFromName.AddNearSequence);
		tagList.add(TagFromName.AddIntermediateSequence);
		tagList.add(TagFromName.AddOtherSequence);
		tagList.add(TagFromName.AddPower);
		tagList.add(TagFromName.ViewingDistance);
		tagList.add(TagFromName.VisualAcuityTypeCodeSequence);
		tagList.add(TagFromName.VisualAcuityRightEyeSequence);
		tagList.add(TagFromName.VisualAcuityLeftEyeSequence);
		tagList.add(TagFromName.VisualAcuityBothEyesOpenSequence);
		tagList.add(TagFromName.ViewingDistanceType);
		tagList.add(TagFromName.VisualAcuityModifiers);
		tagList.add(TagFromName.DecimalVisualAcuity);
		tagList.add(TagFromName.OptotypeDetailedDefinition);
		tagList.add(TagFromName.ReferencedRefractiveMeasurementsSequence);
		tagList.add(TagFromName.SpherePower);
		tagList.add(TagFromName.CylinderPower);
		tagList.add(TagFromName.CalibrationImage);
		tagList.add(TagFromName.DeviceSequence);
		tagList.add(TagFromName.ContainerComponentTypeCodeSequence);
		tagList.add(TagFromName.ContainerComponentThickness);
		tagList.add(TagFromName.DeviceLength);
		tagList.add(TagFromName.ContainerComponentWidth);
		tagList.add(TagFromName.DeviceDiameter);
		tagList.add(TagFromName.DeviceDiameterUnits);
		tagList.add(TagFromName.DeviceVolume);
		tagList.add(TagFromName.InterMarkerDistance);
		tagList.add(TagFromName.ContainerComponentMaterial);
		tagList.add(TagFromName.ContainerComponentID);
		tagList.add(TagFromName.ContainerComponentLength);
		tagList.add(TagFromName.ContainerComponentDiameter);
		tagList.add(TagFromName.ContainerComponentDescription);
		tagList.add(TagFromName.DeviceDescription);
		tagList.add(TagFromName.EnergyWindowVector);
		tagList.add(TagFromName.NumberOfEnergyWindows);
		tagList.add(TagFromName.EnergyWindowInformationSequence);
		tagList.add(TagFromName.EnergyWindowRangeSequence);
		tagList.add(TagFromName.EnergyWindowLowerLimit);
		tagList.add(TagFromName.EnergyWindowUpperLimit);
		tagList.add(TagFromName.RadiopharmaceuticalInformationSequence);
		tagList.add(TagFromName.ResidualSyringeCounts);
		tagList.add(TagFromName.EnergyWindowName);
		tagList.add(TagFromName.DetectorVector);
		tagList.add(TagFromName.NumberOfDetectors);
		tagList.add(TagFromName.DetectorInformationSequence);
		tagList.add(TagFromName.PhaseVector);
		tagList.add(TagFromName.NumberOfPhases);
		tagList.add(TagFromName.PhaseInformationSequence);
		tagList.add(TagFromName.NumberOfFramesInPhase);
		tagList.add(TagFromName.PhaseDelay);
		tagList.add(TagFromName.PauseBetweenFrames);
		tagList.add(TagFromName.PhaseDescription);
		tagList.add(TagFromName.RotationVector);
		tagList.add(TagFromName.NumberOfRotations);
		tagList.add(TagFromName.RotationInformationSequence);
		tagList.add(TagFromName.NumberOfFramesInRotation);
		tagList.add(TagFromName.RRIntervalVector);
		tagList.add(TagFromName.NumberOfRRIntervals);
		tagList.add(TagFromName.GatedInformationSequence);
		tagList.add(TagFromName.DataInformationSequence);
		tagList.add(TagFromName.TimeSlotVector);
		tagList.add(TagFromName.NumberOfTimeSlots);
		tagList.add(TagFromName.TimeSlotInformationSequence);
		tagList.add(TagFromName.TimeSlotTime);
		tagList.add(TagFromName.SliceVector);
		tagList.add(TagFromName.NumberOfSlices);
		tagList.add(TagFromName.AngularViewVector);
		tagList.add(TagFromName.TimeSliceVector);
		tagList.add(TagFromName.NumberOfTimeSlices);
		tagList.add(TagFromName.StartAngle);
		tagList.add(TagFromName.TypeOfDetectorMotion);
		tagList.add(TagFromName.TriggerVector);
		tagList.add(TagFromName.NumberOfTriggersInPhase);
		tagList.add(TagFromName.ViewCodeSequence);
		tagList.add(TagFromName.ViewModifierCodeSequence);
		tagList.add(TagFromName.RadionuclideCodeSequence);
		tagList.add(TagFromName.AdministrationRouteCodeSequence);
		tagList.add(TagFromName.RadiopharmaceuticalCodeSequence);
		tagList.add(TagFromName.CalibrationDataSequence);
		tagList.add(TagFromName.EnergyWindowNumber);
		tagList.add(TagFromName.ImageID);
		tagList.add(TagFromName.PatientOrientationCodeSequence);
		tagList.add(TagFromName.PatientOrientationModifierCodeSequence);
		tagList.add(TagFromName.PatientGantryRelationshipCodeSequence);
		tagList.add(TagFromName.SliceProgressionDirection);
		tagList.add(TagFromName.SeriesType);
		tagList.add(TagFromName.Units);
		tagList.add(TagFromName.CountsSource);
		tagList.add(TagFromName.ReprojectionMethod);
		tagList.add(TagFromName.RandomsCorrectionMethod);
		tagList.add(TagFromName.AttenuationCorrectionMethod);
		tagList.add(TagFromName.DecayCorrection);
		tagList.add(TagFromName.ReconstructionMethod);
		tagList.add(TagFromName.DetectorLinesOfResponseUsed);
		tagList.add(TagFromName.ScatterCorrectionMethod);
		tagList.add(TagFromName.AxialAcceptance);
		tagList.add(TagFromName.AxialMash);
		tagList.add(TagFromName.TransverseMash);
		tagList.add(TagFromName.DetectorElementSize);
		tagList.add(TagFromName.CoincidenceWindowWidth);
		tagList.add(TagFromName.SecondaryCountsType);
		tagList.add(TagFromName.FrameReferenceTime);
		tagList.add(TagFromName.PrimaryPromptsCountsAccumulated);
		tagList.add(TagFromName.SecondaryCountsAccumulated);
		tagList.add(TagFromName.SliceSensitivityFactor);
		tagList.add(TagFromName.DecayFactor);
		tagList.add(TagFromName.DoseCalibrationFactor);
		tagList.add(TagFromName.ScatterFractionFactor);
		tagList.add(TagFromName.DeadTimeFactor);
		tagList.add(TagFromName.ImageIndex);
		tagList.add(TagFromName.CountsIncluded);
		tagList.add(TagFromName.DeadTimeCorrectionFlag);
		tagList.add(TagFromName.HistogramSequence);
		tagList.add(TagFromName.HistogramNumberOfBins);
		tagList.add(TagFromName.HistogramFirstBinValue);
		tagList.add(TagFromName.HistogramLastBinValue);
		tagList.add(TagFromName.HistogramBinWidth);
		tagList.add(TagFromName.HistogramExplanation);
		tagList.add(TagFromName.HistogramData);
		tagList.add(TagFromName.SegmentationType);
		tagList.add(TagFromName.SegmentSequence);
		tagList.add(TagFromName.SegmentedPropertyCategoryCodeSequence);
		tagList.add(TagFromName.SegmentNumber);
		tagList.add(TagFromName.SegmentLabel);
		tagList.add(TagFromName.SegmentDescription);
		tagList.add(TagFromName.SegmentAlgorithmType);
		tagList.add(TagFromName.SegmentAlgorithmName);
		tagList.add(TagFromName.SegmentIdentificationSequence);
		tagList.add(TagFromName.ReferencedSegmentNumber);
		tagList.add(TagFromName.RecommendedDisplayGrayscaleValue);
		tagList.add(TagFromName.RecommendedDisplayCIELabValue);
		tagList.add(TagFromName.MaximumFractionalValue);
		tagList.add(TagFromName.SegmentedPropertyTypeCodeSequence);
		tagList.add(TagFromName.SegmentationFractionalType);
		tagList.add(TagFromName.DeformableRegistrationSequence);
		tagList.add(TagFromName.SourceFrameOfReferenceUID);
		tagList.add(TagFromName.DeformableRegistrationGridSequence);
		tagList.add(TagFromName.GridDimensions);
		tagList.add(TagFromName.GridResolution);
		tagList.add(TagFromName.VectorGridData);
		tagList.add(TagFromName.PreDeformationMatrixRegistrationSequence);
		tagList.add(TagFromName.PostDeformationMatrixRegistrationSequence);
		tagList.add(TagFromName.NumberOfSurfaces);
		tagList.add(TagFromName.SurfaceSequence);
		tagList.add(TagFromName.SurfaceNumber);
		tagList.add(TagFromName.SurfaceComments);
		tagList.add(TagFromName.SurfaceProcessing);
		tagList.add(TagFromName.SurfaceProcessingRatio);
		tagList.add(TagFromName.SurfaceProcessingDescription);
		tagList.add(TagFromName.RecommendedPresentationOpacity);
		tagList.add(TagFromName.RecommendedPresentationType);
		tagList.add(TagFromName.FiniteVolume);
		tagList.add(TagFromName.Manifold);
		tagList.add(TagFromName.SurfacePointsSequence);
		tagList.add(TagFromName.SurfacePointsNormalsSequence);
		tagList.add(TagFromName.SurfaceMeshPrimitivesSequence);
		tagList.add(TagFromName.SurfaceNumberOfPoints);
		tagList.add(TagFromName.PointCoordinatesData);
		tagList.add(TagFromName.PointPositionAccuracy);
		tagList.add(TagFromName.MeanPointDistance);
		tagList.add(TagFromName.MaximumPointDistance);
		tagList.add(TagFromName.PointsBoundingBoxCoordinates);
		tagList.add(TagFromName.AxisOfRotation);
		tagList.add(TagFromName.CenterOfRotation);
		tagList.add(TagFromName.NumberOfVectors);
		tagList.add(TagFromName.VectorDimensionality);
		tagList.add(TagFromName.VectorAccuracy);
		tagList.add(TagFromName.VectorCoordinateData);
		tagList.add(TagFromName.TrianglePointIndexList);
		tagList.add(TagFromName.EdgePointIndexList);
		tagList.add(TagFromName.VertexPointIndexList);
		tagList.add(TagFromName.TriangleStripSequence);
		tagList.add(TagFromName.TriangleFanSequence);
		tagList.add(TagFromName.LineSequence);
		tagList.add(TagFromName.PrimitivePointIndexList);
		tagList.add(TagFromName.SurfaceCount);
		tagList.add(TagFromName.ReferencedSurfaceSequence);
		tagList.add(TagFromName.ReferencedSurfaceNumber);
		tagList.add(TagFromName.SegmentSurfaceGenerationAlgorithmIdentificationSequence);
		tagList.add(TagFromName.SegmentSurfaceSourceInstanceSequence);
		tagList.add(TagFromName.AlgorithmFamilyCodeSequence);
		tagList.add(TagFromName.AlgorithmNameCodeSequence);
		tagList.add(TagFromName.AlgorithmVersion);
		tagList.add(TagFromName.AlgorithmParameters);
		tagList.add(TagFromName.FacetSequence);
		tagList.add(TagFromName.SurfaceProcessingAlgorithmIdentificationSequence);
		tagList.add(TagFromName.AlgorithmName);
		tagList.add(TagFromName.GraphicAnnotationSequence);
		tagList.add(TagFromName.GraphicLayer);
		tagList.add(TagFromName.BoundingBoxAnnotationUnits);
		tagList.add(TagFromName.AnchorPointAnnotationUnits);
		tagList.add(TagFromName.GraphicAnnotationUnits);
		tagList.add(TagFromName.UnformattedTextValue);
		tagList.add(TagFromName.TextObjectSequence);
		tagList.add(TagFromName.GraphicObjectSequence);
		tagList.add(TagFromName.BoundingBoxTopLeftHandCorner);
		tagList.add(TagFromName.BoundingBoxBottomRightHandCorner);
		tagList.add(TagFromName.BoundingBoxTextHorizontalJustification);
		tagList.add(TagFromName.AnchorPoint);
		tagList.add(TagFromName.AnchorPointVisibility);
		tagList.add(TagFromName.GraphicDimensions);
		tagList.add(TagFromName.NumberOfGraphicPoints);
		tagList.add(TagFromName.GraphicData);
		tagList.add(TagFromName.GraphicType);
		tagList.add(TagFromName.GraphicFilled);
		tagList.add(TagFromName.ImageRotationTrial);
		tagList.add(TagFromName.ImageHorizontalFlip);
		tagList.add(TagFromName.ImageRotation);
		tagList.add(TagFromName.DisplayedAreaTopLeftHandCornerTrial);
		tagList.add(TagFromName.DisplayedAreaBottomRightHandCornerTrial);
		tagList.add(TagFromName.DisplayedAreaTopLeftHandCorner);
		tagList.add(TagFromName.DisplayedAreaBottomRightHandCorner);
		tagList.add(TagFromName.DisplayedAreaSelectionSequence);
		tagList.add(TagFromName.GraphicLayerSequence);
		tagList.add(TagFromName.GraphicLayerOrder);
		tagList.add(TagFromName.GraphicLayerRecommendedDisplayGrayscaleValue);
		tagList.add(TagFromName.GraphicLayerRecommendedDisplayRGBValue);
		tagList.add(TagFromName.GraphicLayerDescription);
		tagList.add(TagFromName.ContentLabel);
		tagList.add(TagFromName.ContentDescription);
		tagList.add(TagFromName.PresentationCreationDate);
		tagList.add(TagFromName.PresentationCreationTime);
		tagList.add(TagFromName.ContentCreatorsName);
		tagList.add(TagFromName.ContentCreatorsIdentificationCodeSequence);
		tagList.add(TagFromName.AlternateContentDescriptionSequence);
		tagList.add(TagFromName.PresentationSizeMode);
		tagList.add(TagFromName.PresentationPixelSpacing);
		tagList.add(TagFromName.PresentationPixelAspectRatio);
		tagList.add(TagFromName.PresentationPixelMagnificationRatio);
		tagList.add(TagFromName.ShapeType);
		tagList.add(TagFromName.RegistrationSequence);
		tagList.add(TagFromName.MatrixRegistrationSequence);
		tagList.add(TagFromName.MatrixSequence);
		tagList.add(TagFromName.FrameOfReferenceTransformationMatrixType);
		tagList.add(TagFromName.RegistrationTypeCodeSequence);
		tagList.add(TagFromName.FiducialDescription);
		tagList.add(TagFromName.FiducialIdentifier);
		tagList.add(TagFromName.FiducialIdentifierCodeSequence);
		tagList.add(TagFromName.ContourUncertaintyRadius);
		tagList.add(TagFromName.UsedFiducialsSequence);
		tagList.add(TagFromName.GraphicCoordinatesDataSequence);
		tagList.add(TagFromName.FiducialUID);
		tagList.add(TagFromName.FiducialSetSequence);
		tagList.add(TagFromName.FiducialSequence);
		tagList.add(TagFromName.GraphicLayerRecommendedDisplayCIELabValue);
		tagList.add(TagFromName.BlendingSequence);
		tagList.add(TagFromName.RelativeOpacity);
		tagList.add(TagFromName.ReferencedSpatialRegistrationSequence);
		tagList.add(TagFromName.BlendingPosition);
		tagList.add(TagFromName.HangingProtocolName);
		tagList.add(TagFromName.HangingProtocolDescription);
		tagList.add(TagFromName.HangingProtocolLevel);
		tagList.add(TagFromName.HangingProtocolCreator);
		tagList.add(TagFromName.HangingProtocolCreationDateTime);
		tagList.add(TagFromName.HangingProtocolDefinitionSequence);
		tagList.add(TagFromName.HangingProtocolUserIdentificationCodeSequence);
		tagList.add(TagFromName.HangingProtocolUserGroupName);
		tagList.add(TagFromName.SourceHangingProtocolSequence);
		tagList.add(TagFromName.NumberOfPriorsReferenced);
		tagList.add(TagFromName.ImageSetsSequence);
		tagList.add(TagFromName.ImageSetSelectorSequence);
		tagList.add(TagFromName.ImageSetSelectorUsageFlag);
		tagList.add(TagFromName.SelectorAttribute);
		tagList.add(TagFromName.SelectorValueNumber);
		tagList.add(TagFromName.TimeBasedImageSetsSequence);
		tagList.add(TagFromName.ImageSetNumber);
		tagList.add(TagFromName.ImageSetSelectorCategory);
		tagList.add(TagFromName.RelativeTime);
		tagList.add(TagFromName.RelativeTimeUnits);
		tagList.add(TagFromName.AbstractPriorValue);
		tagList.add(TagFromName.AbstractPriorCodeSequence);
		tagList.add(TagFromName.ImageSetLabel);
		tagList.add(TagFromName.SelectorAttributeVR);
		tagList.add(TagFromName.SelectorSequencePointer);
		tagList.add(TagFromName.SelectorSequencePointerPrivateCreator);
		tagList.add(TagFromName.SelectorAttributePrivateCreator);
		tagList.add(TagFromName.SelectorATValue);
		tagList.add(TagFromName.SelectorCSValue);
		tagList.add(TagFromName.SelectorISValue);
		tagList.add(TagFromName.SelectorLOValue);
		tagList.add(TagFromName.SelectorLTValue);
		tagList.add(TagFromName.SelectorPNValue);
		tagList.add(TagFromName.SelectorSHValue);
		tagList.add(TagFromName.SelectorSTValue);
		tagList.add(TagFromName.SelectorUTValue);
		tagList.add(TagFromName.SelectorDSValue);
		tagList.add(TagFromName.SelectorFDValue);
		tagList.add(TagFromName.SelectorFLValue);
		tagList.add(TagFromName.SelectorULValue);
		tagList.add(TagFromName.SelectorUSValue);
		tagList.add(TagFromName.SelectorSLValue);
		tagList.add(TagFromName.SelectorSSValue);
		tagList.add(TagFromName.SelectorCodeSequenceValue);
		tagList.add(TagFromName.NumberOfScreens);
		tagList.add(TagFromName.NominalScreenDefinitionSequence);
		tagList.add(TagFromName.NumberOfVerticalPixels);
		tagList.add(TagFromName.NumberOfHorizontalPixels);
		tagList.add(TagFromName.DisplayEnvironmentSpatialPosition);
		tagList.add(TagFromName.ScreenMinimumGrayscaleBitDepth);
		tagList.add(TagFromName.ScreenMinimumColorBitDepth);
		tagList.add(TagFromName.ApplicationMaximumRepaintTime);
		tagList.add(TagFromName.DisplaySetsSequence);
		tagList.add(TagFromName.DisplaySetNumber);
		tagList.add(TagFromName.DisplaySetLabel);
		tagList.add(TagFromName.DisplaySetPresentationGroup);
		tagList.add(TagFromName.DisplaySetPresentationGroupDescription);
		tagList.add(TagFromName.PartialDataDisplayHandling);
		tagList.add(TagFromName.SynchronizedScrollingSequence);
		tagList.add(TagFromName.DisplaySetScrollingGroup);
		tagList.add(TagFromName.NavigationIndicatorSequence);
		tagList.add(TagFromName.NavigationDisplaySet);
		tagList.add(TagFromName.ReferenceDisplaySets);
		tagList.add(TagFromName.ImageBoxesSequence);
		tagList.add(TagFromName.ImageBoxNumber);
		tagList.add(TagFromName.ImageBoxLayoutType);
		tagList.add(TagFromName.ImageBoxTileHorizontalDimension);
		tagList.add(TagFromName.ImageBoxTileVerticalDimension);
		tagList.add(TagFromName.ImageBoxScrollDirection);
		tagList.add(TagFromName.ImageBoxSmallScrollType);
		tagList.add(TagFromName.ImageBoxSmallScrollAmount);
		tagList.add(TagFromName.ImageBoxLargeScrollType);
		tagList.add(TagFromName.ImageBoxLargeScrollAmount);
		tagList.add(TagFromName.ImageBoxOverlapPriority);
		tagList.add(TagFromName.CineRelativeToRealTime);
		tagList.add(TagFromName.FilterOperationsSequence);
		tagList.add(TagFromName.FilterByCategory);
		tagList.add(TagFromName.FilterByAttributePresence);
		tagList.add(TagFromName.FilterByOperator);
		tagList.add(TagFromName.StructuredDisplayBackgroundCIELabValue);
		tagList.add(TagFromName.EmptyImageBoxCIELabValue);
		tagList.add(TagFromName.StructuredDisplayImageBoxSequence);
		tagList.add(TagFromName.StructuredDisplayTextBoxSequence);
		tagList.add(TagFromName.ReferencedFirstFrameSequence);
		tagList.add(TagFromName.ImageBoxSynchronizationSequence);
		tagList.add(TagFromName.SynchronizedImageBoxList);
		tagList.add(TagFromName.TypeOfSynchronization);
		tagList.add(TagFromName.BlendingOperationType);
		tagList.add(TagFromName.ReformattingOperationType);
		tagList.add(TagFromName.ReformattingThickness);
		tagList.add(TagFromName.ReformattingInterval);
		tagList.add(TagFromName.ReformattingOperationInitialViewDirection);
		tagList.add(TagFromName.ThreeDRenderingType);
		tagList.add(TagFromName.SortingOperationsSequence);
		tagList.add(TagFromName.SortByCategory);
		tagList.add(TagFromName.SortingDirection);
		tagList.add(TagFromName.DisplaySetPatientOrientation);
		tagList.add(TagFromName.VOIType);
		tagList.add(TagFromName.PseudocolorType);
		tagList.add(TagFromName.ShowGrayscaleInverted);
		tagList.add(TagFromName.ShowImageTrueSizeFlag);
		tagList.add(TagFromName.ShowGraphicAnnotationFlag);
		tagList.add(TagFromName.ShowPatientDemographicsFlag);
		tagList.add(TagFromName.ShowAcquisitionTechniquesFlag);
		tagList.add(TagFromName.DisplaySetHorizontalJustification);
		tagList.add(TagFromName.DisplaySetVerticalJustification);
		tagList.add(TagFromName.StorageMediaFileSetID);
		tagList.add(TagFromName.StorageMediaFileSetUID);
		tagList.add(TagFromName.IconImageSequence);
		tagList.add(TagFromName.TopicTitle);
		tagList.add(TagFromName.TopicSubject);
		tagList.add(TagFromName.TopicAuthor);
		tagList.add(TagFromName.TopicKeyWords);
		tagList.add(TagFromName.SOPInstanceStatus);
		tagList.add(TagFromName.SOPAuthorizationDateAndTime);
		tagList.add(TagFromName.SOPAuthorizationComment);
		tagList.add(TagFromName.AuthorizationEquipmentCertificationNumber);
		tagList.add(TagFromName.MACIDNumber);
		tagList.add(TagFromName.MACCalculationTransferSyntaxUID);
		tagList.add(TagFromName.MACAlgorithm);
		tagList.add(TagFromName.DataElementsSigned);
		tagList.add(TagFromName.DigitalSignatureUID);
		tagList.add(TagFromName.DigitalSignatureDateTime);
		tagList.add(TagFromName.CertificateType);
		tagList.add(TagFromName.CertificateOfSigner);
		tagList.add(TagFromName.Signature);
		tagList.add(TagFromName.CertifiedTimestampType);
		tagList.add(TagFromName.CertifiedTimestamp);
		tagList.add(TagFromName.DigitalSignaturePurposeCodeSequence);
		tagList.add(TagFromName.ReferencedDigitalSignatureSequence);
		tagList.add(TagFromName.ReferencedSOPInstanceMACSequence);
		tagList.add(TagFromName.MAC);
		tagList.add(TagFromName.EncryptedAttributesSequence);
		tagList.add(TagFromName.EncryptedContentTransferSyntaxUID);
		tagList.add(TagFromName.EncryptedContent);
		tagList.add(TagFromName.ModifiedAttributesSequence);
		tagList.add(TagFromName.OriginalAttributesSequence);
		tagList.add(TagFromName.AttributeModificationDateTime);
		tagList.add(TagFromName.ModifyingSystem);
		tagList.add(TagFromName.SourceOfPreviousValues);
		tagList.add(TagFromName.ReasonForTheAttributeModification);
		tagList.add(TagFromName.ZonalMap);
		tagList.add(TagFromName.NumberOfCopies);
		tagList.add(TagFromName.PrinterConfigurationSequence);
		tagList.add(TagFromName.PrintPriority);
		tagList.add(TagFromName.MediumType);
		tagList.add(TagFromName.FilmDestination);
		tagList.add(TagFromName.FilmSessionLabel);
		tagList.add(TagFromName.MemoryAllocation);
		tagList.add(TagFromName.MaximumMemoryAllocation);
		tagList.add(TagFromName.ColorImagePrintingFlag);
		tagList.add(TagFromName.CollationFlag);
		tagList.add(TagFromName.AnnotationFlag);
		tagList.add(TagFromName.ImageOverlayFlag);
		tagList.add(TagFromName.PresentationLUTFlag);
		tagList.add(TagFromName.ImageBoxPresentationLUTFlag);
		tagList.add(TagFromName.MemoryBitDepth);
		tagList.add(TagFromName.PrintingBitDepth);
		tagList.add(TagFromName.MediaInstalledSequence);
		tagList.add(TagFromName.OtherMediaAvailableSequence);
		tagList.add(TagFromName.SupportedImageDisplayFormatsSequence);
		tagList.add(TagFromName.ReferencedFilmBoxSequence);
		tagList.add(TagFromName.ReferencedStoredPrintSequence);
		tagList.add(TagFromName.ImageDisplayFormat);
		tagList.add(TagFromName.AnnotationDisplayFormatID);
		tagList.add(TagFromName.FilmOrientation);
		tagList.add(TagFromName.FilmSizeID);
		tagList.add(TagFromName.PrinterResolutionID);
		tagList.add(TagFromName.DefaultPrinterResolutionID);
		tagList.add(TagFromName.MagnificationType);
		tagList.add(TagFromName.SmoothingType);
		tagList.add(TagFromName.DefaultMagnificationType);
		tagList.add(TagFromName.OtherMagnificationTypesAvailable);
		tagList.add(TagFromName.DefaultSmoothingType);
		tagList.add(TagFromName.OtherSmoothingTypesAvailable);
		tagList.add(TagFromName.BorderDensity);
		tagList.add(TagFromName.EmptyImageDensity);
		tagList.add(TagFromName.MinDensity);
		tagList.add(TagFromName.MaxDensity);
		tagList.add(TagFromName.Trim);
		tagList.add(TagFromName.ConfigurationInformation);
		tagList.add(TagFromName.ConfigurationInformationDescription);
		tagList.add(TagFromName.MaximumCollatedFilms);
		tagList.add(TagFromName.Illumination);
		tagList.add(TagFromName.ReflectedAmbientLight);
		tagList.add(TagFromName.PrinterPixelSpacing);
		tagList.add(TagFromName.ReferencedFilmSessionSequence);
		tagList.add(TagFromName.ReferencedImageBoxSequence);
		tagList.add(TagFromName.ReferencedBasicAnnotationBoxSequence);
		tagList.add(TagFromName.ImageBoxPosition);
		tagList.add(TagFromName.Polarity);
		tagList.add(TagFromName.RequestedImageSize);
		tagList.add(TagFromName.RequestedDecimateCropBehavior);
		tagList.add(TagFromName.RequestedResolutionID);
		tagList.add(TagFromName.RequestedImageSizeFlag);
		tagList.add(TagFromName.DecimateCropResult);
		tagList.add(TagFromName.BasicGrayscaleImageSequence);
		tagList.add(TagFromName.BasicColorImageSequence);
		tagList.add(TagFromName.ReferencedImageOverlayBoxSequence);
		tagList.add(TagFromName.ReferencedVOILUTBoxSequence);
		tagList.add(TagFromName.AnnotationPosition);
		tagList.add(TagFromName.TextString);
		tagList.add(TagFromName.ReferencedOverlayPlaneSequence);
		tagList.add(TagFromName.ReferencedOverlayPlaneGroups);
		tagList.add(TagFromName.OverlayPixelDataSequence);
		tagList.add(TagFromName.OverlayMagnificationType);
		tagList.add(TagFromName.OverlaySmoothingType);
		tagList.add(TagFromName.OverlayOrImageMagnification);
		tagList.add(TagFromName.MagnifyToNumberOfColumns);
		tagList.add(TagFromName.OverlayForegroundDensity);
		tagList.add(TagFromName.OverlayBackgroundDensity);
		tagList.add(TagFromName.OverlayMode);
		tagList.add(TagFromName.ThresholdDensity);
		tagList.add(TagFromName.ReferencedOverlayImageBoxSequence);
		tagList.add(TagFromName.PresentationLUTSequence);
		tagList.add(TagFromName.PresentationLUTShape);
		tagList.add(TagFromName.ReferencedPresentationLUTSequence);
		tagList.add(TagFromName.PrintJobID);
		tagList.add(TagFromName.ExecutionStatus);
		tagList.add(TagFromName.ExecutionStatusInfo);
		tagList.add(TagFromName.CreationDate);
		tagList.add(TagFromName.CreationTime);
		tagList.add(TagFromName.Originator);
		tagList.add(TagFromName.DestinationAE);
		tagList.add(TagFromName.OwnerID);
		tagList.add(TagFromName.NumberOfFilms);
		tagList.add(TagFromName.ReferencedPrintJobSequencePull);
		tagList.add(TagFromName.PrinterStatus);
		tagList.add(TagFromName.PrinterStatusInfo);
		tagList.add(TagFromName.PrinterName);
		tagList.add(TagFromName.PrintQueueID);
		tagList.add(TagFromName.QueueStatus);
		tagList.add(TagFromName.PrintJobDescriptionSequence);
		tagList.add(TagFromName.ReferencedPrintJobSequenceQueue);
		tagList.add(TagFromName.PrintManagementCapabilitiesSequence);
		tagList.add(TagFromName.PrinterCharacteristicsSequence);
		tagList.add(TagFromName.FilmBoxContentSequence);
		tagList.add(TagFromName.ImageBoxContentSequence);
		tagList.add(TagFromName.AnnotationContentSequence);
		tagList.add(TagFromName.ImageOverlayBoxContentSequence);
		tagList.add(TagFromName.PresentationLUTContentSequence);
		tagList.add(TagFromName.ProposedStudySequence);
		tagList.add(TagFromName.OriginalImageSequence);
		tagList.add(TagFromName.LabelUsingInformationExtractedFromInstances);
		tagList.add(TagFromName.LabelText);
		tagList.add(TagFromName.LabelStyleSelection);
		tagList.add(TagFromName.MediaDisposition);
		tagList.add(TagFromName.BarcodeValue);
		tagList.add(TagFromName.BarcodeSymbology);
		tagList.add(TagFromName.AllowMediaSplitting);
		tagList.add(TagFromName.IncludeNonDICOMObjects);
		tagList.add(TagFromName.IncludeDisplayApplication);
		tagList.add(TagFromName.PreserveCompositeInstancesAfterMediaCreation);
		tagList.add(TagFromName.TotalNumberOfPiecesOfMediaCreated);
		tagList.add(TagFromName.RequestedMediaApplicationProfile);
		tagList.add(TagFromName.ReferencedStorageMediaSequence);
		tagList.add(TagFromName.FailureAttributes);
		tagList.add(TagFromName.AllowLossyCompression);
		tagList.add(TagFromName.RequestPriority);
		tagList.add(TagFromName.RTImageLabel);
		tagList.add(TagFromName.RTImageName);
		tagList.add(TagFromName.RTImageDescription);
		tagList.add(TagFromName.ReportedValuesOrigin);
		tagList.add(TagFromName.RTImagePlane);
		tagList.add(TagFromName.XRayImageReceptorTranslation);
		tagList.add(TagFromName.XRayImageReceptorAngle);
		tagList.add(TagFromName.RTImageOrientation);
		tagList.add(TagFromName.ImagePlanePixelSpacing);
		tagList.add(TagFromName.RTImagePosition);
		tagList.add(TagFromName.RadiationMachineName);
		tagList.add(TagFromName.RadiationMachineSAD);
		tagList.add(TagFromName.RadiationMachineSSD);
		tagList.add(TagFromName.RTImageSID);
		tagList.add(TagFromName.SourceToReferenceObjectDistance);
		tagList.add(TagFromName.FractionNumber);
		tagList.add(TagFromName.ExposureSequence);
		tagList.add(TagFromName.MetersetExposure);
		tagList.add(TagFromName.DiaphragmPosition);
		tagList.add(TagFromName.FluenceMapSequence);
		tagList.add(TagFromName.FluenceDataSource);
		tagList.add(TagFromName.FluenceDataScale);
		tagList.add(TagFromName.DVHType);
		tagList.add(TagFromName.DoseUnits);
		tagList.add(TagFromName.DoseType);
		tagList.add(TagFromName.DoseComment);
		tagList.add(TagFromName.NormalizationPoint);
		tagList.add(TagFromName.DoseSummationType);
		tagList.add(TagFromName.GridFrameOffsetVector);
		tagList.add(TagFromName.DoseGridScaling);
		tagList.add(TagFromName.RTDoseROISequence);
		tagList.add(TagFromName.DoseValue);
		tagList.add(TagFromName.TissueHeterogeneityCorrection);
		tagList.add(TagFromName.DVHNormalizationPoint);
		tagList.add(TagFromName.DVHNormalizationDoseValue);
		tagList.add(TagFromName.DVHSequence);
		tagList.add(TagFromName.DVHDoseScaling);
		tagList.add(TagFromName.DVHVolumeUnits);
		tagList.add(TagFromName.DVHNumberOfBins);
		tagList.add(TagFromName.DVHData);
		tagList.add(TagFromName.DVHReferencedROISequence);
		tagList.add(TagFromName.DVHROIContributionType);
		tagList.add(TagFromName.DVHMinimumDose);
		tagList.add(TagFromName.DVHMaximumDose);
		tagList.add(TagFromName.DVHMeanDose);
		tagList.add(TagFromName.StructureSetLabel);
		tagList.add(TagFromName.StructureSetName);
		tagList.add(TagFromName.StructureSetDescription);
		tagList.add(TagFromName.StructureSetDate);
		tagList.add(TagFromName.StructureSetTime);
		tagList.add(TagFromName.ReferencedFrameOfReferenceSequence);
		tagList.add(TagFromName.RTReferencedStudySequence);
		tagList.add(TagFromName.RTReferencedSeriesSequence);
		tagList.add(TagFromName.ContourImageSequence);
		tagList.add(TagFromName.StructureSetROISequence);
		tagList.add(TagFromName.ROINumber);
		tagList.add(TagFromName.ReferencedFrameOfReferenceUID);
		tagList.add(TagFromName.ROIName);
		tagList.add(TagFromName.ROIDescription);
		tagList.add(TagFromName.ROIDisplayColor);
		tagList.add(TagFromName.ROIVolume);
		tagList.add(TagFromName.RTRelatedROISequence);
		tagList.add(TagFromName.RTROIRelationship);
		tagList.add(TagFromName.ROIGenerationAlgorithm);
		tagList.add(TagFromName.ROIGenerationDescription);
		tagList.add(TagFromName.ROIContourSequence);
		tagList.add(TagFromName.ContourSequence);
		tagList.add(TagFromName.ContourGeometricType);
		tagList.add(TagFromName.ContourSlabThickness);
		tagList.add(TagFromName.ContourOffsetVector);
		tagList.add(TagFromName.NumberOfContourPoints);
		tagList.add(TagFromName.ContourNumber);
		tagList.add(TagFromName.AttachedContours);
		tagList.add(TagFromName.ContourData);
		tagList.add(TagFromName.RTROIObservationsSequence);
		tagList.add(TagFromName.ObservationNumber);
		tagList.add(TagFromName.ReferencedROINumber);
		tagList.add(TagFromName.ROIObservationLabel);
		tagList.add(TagFromName.RTROIIdentificationCodeSequence);
		tagList.add(TagFromName.ROIObservationDescription);
		tagList.add(TagFromName.RelatedRTROIObservationsSequence);
		tagList.add(TagFromName.RTROIInterpretedType);
		tagList.add(TagFromName.ROIInterpreter);
		tagList.add(TagFromName.ROIPhysicalPropertiesSequence);
		tagList.add(TagFromName.ROIPhysicalProperty);
		tagList.add(TagFromName.ROIPhysicalPropertyValue);
		tagList.add(TagFromName.ROIElementalCompositionSequence);
		tagList.add(TagFromName.ROIElementalCompositionAtomicNumber);
		tagList.add(TagFromName.ROIElementalCompositionAtomicMassFraction);
		tagList.add(TagFromName.FrameOfReferenceRelationshipSequence);
		tagList.add(TagFromName.RelatedFrameOfReferenceUID);
		tagList.add(TagFromName.FrameOfReferenceTransformationType);
		tagList.add(TagFromName.FrameOfReferenceTransformationMatrix);
		tagList.add(TagFromName.FrameOfReferenceTransformationComment);
		tagList.add(TagFromName.MeasuredDoseReferenceSequence);
		tagList.add(TagFromName.MeasuredDoseDescription);
		tagList.add(TagFromName.MeasuredDoseType);
		tagList.add(TagFromName.MeasuredDoseValue);
		tagList.add(TagFromName.TreatmentSessionBeamSequence);
		tagList.add(TagFromName.TreatmentSessionIonBeamSequence);
		tagList.add(TagFromName.CurrentFractionNumber);
		tagList.add(TagFromName.TreatmentControlPointDate);
		tagList.add(TagFromName.TreatmentControlPointTime);
		tagList.add(TagFromName.TreatmentTerminationStatus);
		tagList.add(TagFromName.TreatmentTerminationCode);
		tagList.add(TagFromName.TreatmentVerificationStatus);
		tagList.add(TagFromName.ReferencedTreatmentRecordSequence);
		tagList.add(TagFromName.SpecifiedPrimaryMeterset);
		tagList.add(TagFromName.SpecifiedSecondaryMeterset);
		tagList.add(TagFromName.DeliveredPrimaryMeterset);
		tagList.add(TagFromName.DeliveredSecondaryMeterset);
		tagList.add(TagFromName.SpecifiedTreatmentTime);
		tagList.add(TagFromName.DeliveredTreatmentTime);
		tagList.add(TagFromName.ControlPointDeliverySequence);
		tagList.add(TagFromName.IonControlPointDeliverySequence);
		tagList.add(TagFromName.SpecifiedMeterset);
		tagList.add(TagFromName.DeliveredMeterset);
		tagList.add(TagFromName.MetersetRateSet);
		tagList.add(TagFromName.MetersetRateDelivered);
		tagList.add(TagFromName.ScanSpotMetersetsDelivered);
		tagList.add(TagFromName.DoseRateDelivered);
		tagList.add(TagFromName.TreatmentSummaryCalculatedDoseReferenceSequence);
		tagList.add(TagFromName.CumulativeDoseToDoseReference);
		tagList.add(TagFromName.FirstTreatmentDate);
		tagList.add(TagFromName.MostRecentTreatmentDate);
		tagList.add(TagFromName.NumberOfFractionsDelivered);
		tagList.add(TagFromName.OverrideSequence);
		tagList.add(TagFromName.ParameterSequencePointer);
		tagList.add(TagFromName.OverrideParameterPointer);
		tagList.add(TagFromName.ParameterItemIndex);
		tagList.add(TagFromName.MeasuredDoseReferenceNumber);
		tagList.add(TagFromName.ParameterPointer);
		tagList.add(TagFromName.OverrideReason);
		tagList.add(TagFromName.CorrectedParameterSequence);
		tagList.add(TagFromName.CorrectionValue);
		tagList.add(TagFromName.CalculatedDoseReferenceSequence);
		tagList.add(TagFromName.CalculatedDoseReferenceNumber);
		tagList.add(TagFromName.CalculatedDoseReferenceDescription);
		tagList.add(TagFromName.CalculatedDoseReferenceDoseValue);
		tagList.add(TagFromName.StartMeterset);
		tagList.add(TagFromName.EndMeterset);
		tagList.add(TagFromName.ReferencedMeasuredDoseReferenceSequence);
		tagList.add(TagFromName.ReferencedMeasuredDoseReferenceNumber);
		tagList.add(TagFromName.ReferencedCalculatedDoseReferenceSequence);
		tagList.add(TagFromName.ReferencedCalculatedDoseReferenceNumber);
		tagList.add(TagFromName.BeamLimitingDeviceLeafPairsSequence);
		tagList.add(TagFromName.RecordedWedgeSequence);
		tagList.add(TagFromName.RecordedCompensatorSequence);
		tagList.add(TagFromName.RecordedBlockSequence);
		tagList.add(TagFromName.TreatmentSummaryMeasuredDoseReferenceSequence);
		tagList.add(TagFromName.RecordedSnoutSequence);
		tagList.add(TagFromName.RecordedRangeShifterSequence);
		tagList.add(TagFromName.RecordedLateralSpreadingDeviceSequence);
		tagList.add(TagFromName.RecordedRangeModulatorSequence);
		tagList.add(TagFromName.RecordedSourceSequence);
		tagList.add(TagFromName.SourceSerialNumber);
		tagList.add(TagFromName.TreatmentSessionApplicationSetupSequence);
		tagList.add(TagFromName.ApplicationSetupCheck);
		tagList.add(TagFromName.RecordedBrachyAccessoryDeviceSequence);
		tagList.add(TagFromName.ReferencedBrachyAccessoryDeviceNumber);
		tagList.add(TagFromName.RecordedChannelSequence);
		tagList.add(TagFromName.SpecifiedChannelTotalTime);
		tagList.add(TagFromName.DeliveredChannelTotalTime);
		tagList.add(TagFromName.SpecifiedNumberOfPulses);
		tagList.add(TagFromName.DeliveredNumberOfPulses);
		tagList.add(TagFromName.SpecifiedPulseRepetitionInterval);
		tagList.add(TagFromName.DeliveredPulseRepetitionInterval);
		tagList.add(TagFromName.RecordedSourceApplicatorSequence);
		tagList.add(TagFromName.ReferencedSourceApplicatorNumber);
		tagList.add(TagFromName.RecordedChannelShieldSequence);
		tagList.add(TagFromName.ReferencedChannelShieldNumber);
		tagList.add(TagFromName.BrachyControlPointDeliveredSequence);
		tagList.add(TagFromName.SafePositionExitDate);
		tagList.add(TagFromName.SafePositionExitTime);
		tagList.add(TagFromName.SafePositionReturnDate);
		tagList.add(TagFromName.SafePositionReturnTime);
		tagList.add(TagFromName.CurrentTreatmentStatus);
		tagList.add(TagFromName.TreatmentStatusComment);
		tagList.add(TagFromName.FractionGroupSummarySequence);
		tagList.add(TagFromName.ReferencedFractionNumber);
		tagList.add(TagFromName.FractionGroupType);
		tagList.add(TagFromName.BeamStopperPosition);
		tagList.add(TagFromName.FractionStatusSummarySequence);
		tagList.add(TagFromName.TreatmentDate);
		tagList.add(TagFromName.TreatmentTime);
		tagList.add(TagFromName.RTPlanLabel);
		tagList.add(TagFromName.RTPlanName);
		tagList.add(TagFromName.RTPlanDescription);
		tagList.add(TagFromName.RTPlanDate);
		tagList.add(TagFromName.RTPlanTime);
		tagList.add(TagFromName.TreatmentProtocols);
		tagList.add(TagFromName.PlanIntent);
		tagList.add(TagFromName.TreatmentSites);
		tagList.add(TagFromName.RTPlanGeometry);
		tagList.add(TagFromName.PrescriptionDescription);
		tagList.add(TagFromName.DoseReferenceSequence);
		tagList.add(TagFromName.DoseReferenceNumber);
		tagList.add(TagFromName.DoseReferenceUID);
		tagList.add(TagFromName.DoseReferenceStructureType);
		tagList.add(TagFromName.NominalBeamEnergyUnit);
		tagList.add(TagFromName.DoseReferenceDescription);
		tagList.add(TagFromName.DoseReferencePointCoordinates);
		tagList.add(TagFromName.NominalPriorDose);
		tagList.add(TagFromName.DoseReferenceType);
		tagList.add(TagFromName.ConstraintWeight);
		tagList.add(TagFromName.DeliveryWarningDose);
		tagList.add(TagFromName.DeliveryMaximumDose);
		tagList.add(TagFromName.TargetMinimumDose);
		tagList.add(TagFromName.TargetPrescriptionDose);
		tagList.add(TagFromName.TargetMaximumDose);
		tagList.add(TagFromName.TargetUnderdoseVolumeFraction);
		tagList.add(TagFromName.OrganAtRiskFullVolumeDose);
		tagList.add(TagFromName.OrganAtRiskLimitDose);
		tagList.add(TagFromName.OrganAtRiskMaximumDose);
		tagList.add(TagFromName.OrganAtRiskOverdoseVolumeFraction);
		tagList.add(TagFromName.ToleranceTableSequence);
		tagList.add(TagFromName.ToleranceTableNumber);
		tagList.add(TagFromName.ToleranceTableLabel);
		tagList.add(TagFromName.GantryAngleTolerance);
		tagList.add(TagFromName.BeamLimitingDeviceAngleTolerance);
		tagList.add(TagFromName.BeamLimitingDeviceToleranceSequence);
		tagList.add(TagFromName.BeamLimitingDevicePositionTolerance);
		tagList.add(TagFromName.SnoutPositionTolerance);
		tagList.add(TagFromName.PatientSupportAngleTolerance);
		tagList.add(TagFromName.TableTopEccentricAngleTolerance);
		tagList.add(TagFromName.TableTopPitchAngleTolerance);
		tagList.add(TagFromName.TableTopRollAngleTolerance);
		tagList.add(TagFromName.TableTopVerticalPositionTolerance);
		tagList.add(TagFromName.TableTopLongitudinalPositionTolerance);
		tagList.add(TagFromName.TableTopLateralPositionTolerance);
		tagList.add(TagFromName.RTPlanRelationship);
		tagList.add(TagFromName.FractionGroupSequence);
		tagList.add(TagFromName.FractionGroupNumber);
		tagList.add(TagFromName.FractionGroupDescription);
		tagList.add(TagFromName.NumberOfFractionsPlanned);
		tagList.add(TagFromName.NumberOfFractionPatternDigitsPerDay);
		tagList.add(TagFromName.RepeatFractionCycleLength);
		tagList.add(TagFromName.FractionPattern);
		tagList.add(TagFromName.NumberOfBeams);
		tagList.add(TagFromName.BeamDoseSpecificationPoint);
		tagList.add(TagFromName.BeamDose);
		tagList.add(TagFromName.BeamMeterset);
		tagList.add(TagFromName.BeamDosePointDepth);
		tagList.add(TagFromName.BeamDosePointEquivalentDepth);
		tagList.add(TagFromName.BeamDosePointSSD);
		tagList.add(TagFromName.NumberOfBrachyApplicationSetups);
		tagList.add(TagFromName.BrachyApplicationSetupDoseSpecificationPoint);
		tagList.add(TagFromName.BrachyApplicationSetupDose);
		tagList.add(TagFromName.BeamSequence);
		tagList.add(TagFromName.TreatmentMachineName);
		tagList.add(TagFromName.PrimaryDosimeterUnit);
		tagList.add(TagFromName.SourceAxisDistance);
		tagList.add(TagFromName.BeamLimitingDeviceSequence);
		tagList.add(TagFromName.RTBeamLimitingDeviceType);
		tagList.add(TagFromName.SourceToBeamLimitingDeviceDistance);
		tagList.add(TagFromName.IsocenterToBeamLimitingDeviceDistance);
		tagList.add(TagFromName.NumberOfLeafJawPairs);
		tagList.add(TagFromName.LeafPositionBoundaries);
		tagList.add(TagFromName.BeamNumber);
		tagList.add(TagFromName.BeamName);
		tagList.add(TagFromName.BeamDescription);
		tagList.add(TagFromName.BeamType);
		tagList.add(TagFromName.RadiationType);
		tagList.add(TagFromName.HighDoseTechniqueType);
		tagList.add(TagFromName.ReferenceImageNumber);
		tagList.add(TagFromName.PlannedVerificationImageSequence);
		tagList.add(TagFromName.ImagingDeviceSpecificAcquisitionParameters);
		tagList.add(TagFromName.TreatmentDeliveryType);
		tagList.add(TagFromName.NumberOfWedges);
		tagList.add(TagFromName.WedgeSequence);
		tagList.add(TagFromName.WedgeNumber);
		tagList.add(TagFromName.WedgeType);
		tagList.add(TagFromName.WedgeID);
		tagList.add(TagFromName.WedgeAngle);
		tagList.add(TagFromName.WedgeFactor);
		tagList.add(TagFromName.TotalWedgeTrayWaterEquivalentThickness);
		tagList.add(TagFromName.WedgeOrientation);
		tagList.add(TagFromName.IsocenterToWedgeTrayDistance);
		tagList.add(TagFromName.SourceToWedgeTrayDistance);
		tagList.add(TagFromName.WedgeThinEdgePosition);
		tagList.add(TagFromName.BolusID);
		tagList.add(TagFromName.BolusDescription);
		tagList.add(TagFromName.NumberOfCompensators);
		tagList.add(TagFromName.MaterialID);
		tagList.add(TagFromName.TotalCompensatorTrayFactor);
		tagList.add(TagFromName.CompensatorSequence);
		tagList.add(TagFromName.CompensatorNumber);
		tagList.add(TagFromName.CompensatorID);
		tagList.add(TagFromName.SourceToCompensatorTrayDistance);
		tagList.add(TagFromName.CompensatorRows);
		tagList.add(TagFromName.CompensatorColumns);
		tagList.add(TagFromName.CompensatorPixelSpacing);
		tagList.add(TagFromName.CompensatorPosition);
		tagList.add(TagFromName.CompensatorTransmissionData);
		tagList.add(TagFromName.CompensatorThicknessData);
		tagList.add(TagFromName.NumberOfBoli);
		tagList.add(TagFromName.CompensatorType);
		tagList.add(TagFromName.NumberOfBlocks);
		tagList.add(TagFromName.TotalBlockTrayFactor);
		tagList.add(TagFromName.TotalBlockTrayWaterEquivalentThickness);
		tagList.add(TagFromName.BlockSequence);
		tagList.add(TagFromName.BlockTrayID);
		tagList.add(TagFromName.SourceToBlockTrayDistance);
		tagList.add(TagFromName.IsocenterToBlockTrayDistance);
		tagList.add(TagFromName.BlockType);
		tagList.add(TagFromName.AccessoryCode);
		tagList.add(TagFromName.BlockDivergence);
		tagList.add(TagFromName.BlockMountingPosition);
		tagList.add(TagFromName.BlockNumber);
		tagList.add(TagFromName.BlockName);
		tagList.add(TagFromName.BlockThickness);
		tagList.add(TagFromName.BlockTransmission);
		tagList.add(TagFromName.BlockNumberOfPoints);
		tagList.add(TagFromName.BlockData);
		tagList.add(TagFromName.ApplicatorSequence);
		tagList.add(TagFromName.ApplicatorID);
		tagList.add(TagFromName.ApplicatorType);
		tagList.add(TagFromName.ApplicatorDescription);
		tagList.add(TagFromName.CumulativeDoseReferenceCoefficient);
		tagList.add(TagFromName.FinalCumulativeMetersetWeight);
		tagList.add(TagFromName.NumberOfControlPoints);
		tagList.add(TagFromName.ControlPointSequence);
		tagList.add(TagFromName.ControlPointIndex);
		tagList.add(TagFromName.NominalBeamEnergy);
		tagList.add(TagFromName.DoseRateSet);
		tagList.add(TagFromName.WedgePositionSequence);
		tagList.add(TagFromName.WedgePosition);
		tagList.add(TagFromName.BeamLimitingDevicePositionSequence);
		tagList.add(TagFromName.LeafJawPositions);
		tagList.add(TagFromName.GantryAngle);
		tagList.add(TagFromName.GantryRotationDirection);
		tagList.add(TagFromName.BeamLimitingDeviceAngle);
		tagList.add(TagFromName.BeamLimitingDeviceRotationDirection);
		tagList.add(TagFromName.PatientSupportAngle);
		tagList.add(TagFromName.PatientSupportRotationDirection);
		tagList.add(TagFromName.TableTopEccentricAxisDistance);
		tagList.add(TagFromName.TableTopEccentricAngle);
		tagList.add(TagFromName.TableTopEccentricRotationDirection);
		tagList.add(TagFromName.TableTopVerticalPosition);
		tagList.add(TagFromName.TableTopLongitudinalPosition);
		tagList.add(TagFromName.TableTopLateralPosition);
		tagList.add(TagFromName.IsocenterPosition);
		tagList.add(TagFromName.SurfaceEntryPoint);
		tagList.add(TagFromName.SourceToSurfaceDistance);
		tagList.add(TagFromName.CumulativeMetersetWeight);
		tagList.add(TagFromName.TableTopPitchAngle);
		tagList.add(TagFromName.TableTopPitchRotationDirection);
		tagList.add(TagFromName.TableTopRollAngle);
		tagList.add(TagFromName.TableTopRollRotationDirection);
		tagList.add(TagFromName.HeadFixationAngle);
		tagList.add(TagFromName.GantryPitchAngle);
		tagList.add(TagFromName.GantryPitchRotationDirection);
		tagList.add(TagFromName.GantryPitchAngleTolerance);
		tagList.add(TagFromName.PatientSetupSequence);
		tagList.add(TagFromName.PatientSetupNumber);
		tagList.add(TagFromName.PatientSetupLabel);
		tagList.add(TagFromName.PatientAdditionalPosition);
		tagList.add(TagFromName.FixationDeviceSequence);
		tagList.add(TagFromName.FixationDeviceType);
		tagList.add(TagFromName.FixationDeviceLabel);
		tagList.add(TagFromName.FixationDeviceDescription);
		tagList.add(TagFromName.FixationDevicePosition);
		tagList.add(TagFromName.FixationDevicePitchAngle);
		tagList.add(TagFromName.FixationDeviceRollAngle);
		tagList.add(TagFromName.ShieldingDeviceSequence);
		tagList.add(TagFromName.ShieldingDeviceType);
		tagList.add(TagFromName.ShieldingDeviceLabel);
		tagList.add(TagFromName.ShieldingDeviceDescription);
		tagList.add(TagFromName.ShieldingDevicePosition);
		tagList.add(TagFromName.SetupTechnique);
		tagList.add(TagFromName.SetupTechniqueDescription);
		tagList.add(TagFromName.SetupDeviceSequence);
		tagList.add(TagFromName.SetupDeviceType);
		tagList.add(TagFromName.SetupDeviceLabel);
		tagList.add(TagFromName.SetupDeviceDescription);
		tagList.add(TagFromName.SetupDeviceParameter);
		tagList.add(TagFromName.SetupReferenceDescription);
		tagList.add(TagFromName.TableTopVerticalSetupDisplacement);
		tagList.add(TagFromName.TableTopLongitudinalSetupDisplacement);
		tagList.add(TagFromName.TableTopLateralSetupDisplacement);
		tagList.add(TagFromName.BrachyTreatmentTechnique);
		tagList.add(TagFromName.BrachyTreatmentType);
		tagList.add(TagFromName.TreatmentMachineSequence);
		tagList.add(TagFromName.SourceSequence);
		tagList.add(TagFromName.SourceNumber);
		tagList.add(TagFromName.SourceType);
		tagList.add(TagFromName.SourceManufacturer);
		tagList.add(TagFromName.ActiveSourceDiameter);
		tagList.add(TagFromName.ActiveSourceLength);
		tagList.add(TagFromName.SourceEncapsulationNominalThickness);
		tagList.add(TagFromName.SourceEncapsulationNominalTransmission);
		tagList.add(TagFromName.SourceIsotopeName);
		tagList.add(TagFromName.SourceIsotopeHalfLife);
		tagList.add(TagFromName.SourceStrengthUnits);
		tagList.add(TagFromName.ReferenceAirKermaRate);
		tagList.add(TagFromName.SourceStrength);
		tagList.add(TagFromName.SourceStrengthReferenceDate);
		tagList.add(TagFromName.SourceStrengthReferenceTime);
		tagList.add(TagFromName.ApplicationSetupSequence);
		tagList.add(TagFromName.ApplicationSetupType);
		tagList.add(TagFromName.ApplicationSetupNumber);
		tagList.add(TagFromName.ApplicationSetupName);
		tagList.add(TagFromName.ApplicationSetupManufacturer);
		tagList.add(TagFromName.TemplateNumber);
		tagList.add(TagFromName.TemplateType);
		tagList.add(TagFromName.TemplateName);
		tagList.add(TagFromName.TotalReferenceAirKerma);
		tagList.add(TagFromName.BrachyAccessoryDeviceSequence);
		tagList.add(TagFromName.BrachyAccessoryDeviceNumber);
		tagList.add(TagFromName.BrachyAccessoryDeviceID);
		tagList.add(TagFromName.BrachyAccessoryDeviceType);
		tagList.add(TagFromName.BrachyAccessoryDeviceName);
		tagList.add(TagFromName.BrachyAccessoryDeviceNominalThickness);
		tagList.add(TagFromName.BrachyAccessoryDeviceNominalTransmission);
		tagList.add(TagFromName.ChannelSequence);
		tagList.add(TagFromName.ChannelNumber);
		tagList.add(TagFromName.ChannelLength);
		tagList.add(TagFromName.ChannelTotalTime);
		tagList.add(TagFromName.SourceMovementType);
		tagList.add(TagFromName.NumberOfPulses);
		tagList.add(TagFromName.PulseRepetitionInterval);
		tagList.add(TagFromName.SourceApplicatorNumber);
		tagList.add(TagFromName.SourceApplicatorID);
		tagList.add(TagFromName.SourceApplicatorType);
		tagList.add(TagFromName.SourceApplicatorName);
		tagList.add(TagFromName.SourceApplicatorLength);
		tagList.add(TagFromName.SourceApplicatorManufacturer);
		tagList.add(TagFromName.SourceApplicatorWallNominalThickness);
		tagList.add(TagFromName.SourceApplicatorWallNominalTransmission);
		tagList.add(TagFromName.SourceApplicatorStepSize);
		tagList.add(TagFromName.TransferTubeNumber);
		tagList.add(TagFromName.TransferTubeLength);
		tagList.add(TagFromName.ChannelShieldSequence);
		tagList.add(TagFromName.ChannelShieldNumber);
		tagList.add(TagFromName.ChannelShieldID);
		tagList.add(TagFromName.ChannelShieldName);
		tagList.add(TagFromName.ChannelShieldNominalThickness);
		tagList.add(TagFromName.ChannelShieldNominalTransmission);
		tagList.add(TagFromName.FinalCumulativeTimeWeight);
		tagList.add(TagFromName.BrachyControlPointSequence);
		tagList.add(TagFromName.ControlPointRelativePosition);
		tagList.add(TagFromName.ControlPoint3DPosition);
		tagList.add(TagFromName.CumulativeTimeWeight);
		tagList.add(TagFromName.CompensatorDivergence);
		tagList.add(TagFromName.CompensatorMountingPosition);
		tagList.add(TagFromName.SourceToCompensatorDistance);
		tagList.add(TagFromName.TotalCompensatorTrayWaterEquivalentThickness);
		tagList.add(TagFromName.IsocenterToCompensatorTrayDistance);
		tagList.add(TagFromName.CompensatorColumnOffset);
		tagList.add(TagFromName.IsocenterToCompensatorDistances);
		tagList.add(TagFromName.CompensatorRelativeStoppingPowerRatio);
		tagList.add(TagFromName.CompensatorMillingToolDiameter);
		tagList.add(TagFromName.IonRangeCompensatorSequence);
		tagList.add(TagFromName.CompensatorDescription);
		tagList.add(TagFromName.RadiationMassNumber);
		tagList.add(TagFromName.RadiationAtomicNumber);
		tagList.add(TagFromName.RadiationChargeState);
		tagList.add(TagFromName.ScanMode);
		tagList.add(TagFromName.VirtualSourceAxisDistances);
		tagList.add(TagFromName.SnoutSequence);
		tagList.add(TagFromName.SnoutPosition);
		tagList.add(TagFromName.SnoutID);
		tagList.add(TagFromName.NumberOfRangeShifters);
		tagList.add(TagFromName.RangeShifterSequence);
		tagList.add(TagFromName.RangeShifterNumber);
		tagList.add(TagFromName.RangeShifterID);
		tagList.add(TagFromName.RangeShifterType);
		tagList.add(TagFromName.RangeShifterDescription);
		tagList.add(TagFromName.NumberOfLateralSpreadingDevices);
		tagList.add(TagFromName.LateralSpreadingDeviceSequence);
		tagList.add(TagFromName.LateralSpreadingDeviceNumber);
		tagList.add(TagFromName.LateralSpreadingDeviceID);
		tagList.add(TagFromName.LateralSpreadingDeviceType);
		tagList.add(TagFromName.LateralSpreadingDeviceDescription);
		tagList.add(TagFromName.LateralSpreadingDeviceWaterEquivalentThickness);
		tagList.add(TagFromName.NumberOfRangeModulators);
		tagList.add(TagFromName.RangeModulatorSequence);
		tagList.add(TagFromName.RangeModulatorNumber);
		tagList.add(TagFromName.RangeModulatorID);
		tagList.add(TagFromName.RangeModulatorType);
		tagList.add(TagFromName.RangeModulatorDescription);
		tagList.add(TagFromName.BeamCurrentModulationID);
		tagList.add(TagFromName.PatientSupportType);
		tagList.add(TagFromName.PatientSupportID);
		tagList.add(TagFromName.PatientSupportAccessoryCode);
		tagList.add(TagFromName.FixationLightAzimuthalAngle);
		tagList.add(TagFromName.FixationLightPolarAngle);
		tagList.add(TagFromName.MetersetRate);
		tagList.add(TagFromName.RangeShifterSettingsSequence);
		tagList.add(TagFromName.RangeShifterSetting);
		tagList.add(TagFromName.IsocenterToRangeShifterDistance);
		tagList.add(TagFromName.RangeShifterWaterEquivalentThickness);
		tagList.add(TagFromName.LateralSpreadingDeviceSettingsSequence);
		tagList.add(TagFromName.LateralSpreadingDeviceSetting);
		tagList.add(TagFromName.IsocenterToLateralSpreadingDeviceDistance);
		tagList.add(TagFromName.RangeModulatorSettingsSequence);
		tagList.add(TagFromName.RangeModulatorGatingStartValue);
		tagList.add(TagFromName.RangeModulatorGatingStopValue);
		tagList.add(TagFromName.RangeModulatorGatingStartWaterEquivalentThickness);
		tagList.add(TagFromName.RangeModulatorGatingStopWaterEquivalentThickness);
		tagList.add(TagFromName.IsocenterToRangeModulatorDistance);
		tagList.add(TagFromName.ScanSpotTuneID);
		tagList.add(TagFromName.NumberOfScanSpotPositions);
		tagList.add(TagFromName.ScanSpotPositionMap);
		tagList.add(TagFromName.ScanSpotMetersetWeights);
		tagList.add(TagFromName.ScanningSpotSize);
		tagList.add(TagFromName.NumberOfPaintings);
		tagList.add(TagFromName.IonToleranceTableSequence);
		tagList.add(TagFromName.IonBeamSequence);
		tagList.add(TagFromName.IonBeamLimitingDeviceSequence);
		tagList.add(TagFromName.IonBlockSequence);
		tagList.add(TagFromName.IonControlPointSequence);
		tagList.add(TagFromName.IonWedgeSequence);
		tagList.add(TagFromName.IonWedgePositionSequence);
		tagList.add(TagFromName.ReferencedSetupImageSequence);
		tagList.add(TagFromName.SetupImageComment);
		tagList.add(TagFromName.MotionSynchronizationSequence);
		tagList.add(TagFromName.ControlPointOrientation);
		tagList.add(TagFromName.GeneralAccessorySequence);
		tagList.add(TagFromName.GeneralAccessoryID);
		tagList.add(TagFromName.GeneralAccessoryDescription);
		tagList.add(TagFromName.GeneralAccessoryType);
		tagList.add(TagFromName.GeneralAccessoryNumber);
		tagList.add(TagFromName.ReferencedRTPlanSequence);
		tagList.add(TagFromName.ReferencedBeamSequence);
		tagList.add(TagFromName.ReferencedBeamNumber);
		tagList.add(TagFromName.ReferencedReferenceImageNumber);
		tagList.add(TagFromName.StartCumulativeMetersetWeight);
		tagList.add(TagFromName.EndCumulativeMetersetWeight);
		tagList.add(TagFromName.ReferencedBrachyApplicationSetupSequence);
		tagList.add(TagFromName.ReferencedBrachyApplicationSetupNumber);
		tagList.add(TagFromName.ReferencedSourceNumber);
		tagList.add(TagFromName.ReferencedFractionGroupSequence);
		tagList.add(TagFromName.ReferencedFractionGroupNumber);
		tagList.add(TagFromName.ReferencedVerificationImageSequence);
		tagList.add(TagFromName.ReferencedReferenceImageSequence);
		tagList.add(TagFromName.ReferencedDoseReferenceSequence);
		tagList.add(TagFromName.ReferencedDoseReferenceNumber);
		tagList.add(TagFromName.BrachyReferencedDoseReferenceSequence);
		tagList.add(TagFromName.ReferencedStructureSetSequence);
		tagList.add(TagFromName.ReferencedPatientSetupNumber);
		tagList.add(TagFromName.ReferencedDoseSequence);
		tagList.add(TagFromName.ReferencedToleranceTableNumber);
		tagList.add(TagFromName.ReferencedBolusSequence);
		tagList.add(TagFromName.ReferencedWedgeNumber);
		tagList.add(TagFromName.ReferencedCompensatorNumber);
		tagList.add(TagFromName.ReferencedBlockNumber);
		tagList.add(TagFromName.ReferencedControlPointIndex);
		tagList.add(TagFromName.ReferencedControlPointSequence);
		tagList.add(TagFromName.ReferencedStartControlPointIndex);
		tagList.add(TagFromName.ReferencedStopControlPointIndex);
		tagList.add(TagFromName.ReferencedRangeShifterNumber);
		tagList.add(TagFromName.ReferencedLateralSpreadingDeviceNumber);
		tagList.add(TagFromName.ReferencedRangeModulatorNumber);
		tagList.add(TagFromName.ApprovalStatus);
		tagList.add(TagFromName.ReviewDate);
		tagList.add(TagFromName.ReviewTime);
		tagList.add(TagFromName.ReviewerName);
		tagList.add(TagFromName.Arbitrary);
		tagList.add(TagFromName.TextComments);
		tagList.add(TagFromName.ResultsID);
		tagList.add(TagFromName.ResultsIDIssuer);
		tagList.add(TagFromName.ReferencedInterpretationSequence);
		tagList.add(TagFromName.ReportProductionStatusTrial);
		tagList.add(TagFromName.InterpretationRecordedDate);
		tagList.add(TagFromName.InterpretationRecordedTime);
		tagList.add(TagFromName.InterpretationRecorder);
		tagList.add(TagFromName.ReferenceToRecordedSound);
		tagList.add(TagFromName.InterpretationTranscriptionDate);
		tagList.add(TagFromName.InterpretationTranscriptionTime);
		tagList.add(TagFromName.InterpretationTranscriber);
		tagList.add(TagFromName.InterpretationText);
		tagList.add(TagFromName.InterpretationAuthor);
		tagList.add(TagFromName.InterpretationApproverSequence);
		tagList.add(TagFromName.InterpretationApprovalDate);
		tagList.add(TagFromName.InterpretationApprovalTime);
		tagList.add(TagFromName.PhysicianApprovingInterpretation);
		tagList.add(TagFromName.InterpretationDiagnosisDescription);
		tagList.add(TagFromName.InterpretationDiagnosisCodeSequence);
		tagList.add(TagFromName.ResultsDistributionListSequence);
		tagList.add(TagFromName.DistributionName);
		tagList.add(TagFromName.DistributionAddress);
		tagList.add(TagFromName.InterpretationID);
		tagList.add(TagFromName.InterpretationIDIssuer);
		tagList.add(TagFromName.InterpretationTypeID);
		tagList.add(TagFromName.InterpretationStatusID);
		tagList.add(TagFromName.Impressions);
		tagList.add(TagFromName.ResultsComments);
		tagList.add(TagFromName.MACParametersSequence);
		tagList.add(TagFromName.CurveDimensions);
		tagList.add(TagFromName.NumberOfPoints);
		tagList.add(TagFromName.TypeOfData);
		tagList.add(TagFromName.CurveDescription);
		tagList.add(TagFromName.AxisUnits);
		tagList.add(TagFromName.AxisLabels);
		tagList.add(TagFromName.DataValueRepresentation);
		tagList.add(TagFromName.MinimumCoordinateValue);
		tagList.add(TagFromName.MaximumCoordinateValue);
		tagList.add(TagFromName.CurveRange);
		tagList.add(TagFromName.CurveDataDescriptor);
		tagList.add(TagFromName.CoordinateStartValue);
		tagList.add(TagFromName.CoordinateStepValue);
		tagList.add(TagFromName.CurveActivationLayer);
		tagList.add(TagFromName.AudioType);
		tagList.add(TagFromName.AudioSampleFormat);
		tagList.add(TagFromName.NumberOfChannels);
		tagList.add(TagFromName.NumberOfSamples);
		tagList.add(TagFromName.SampleRate);
		tagList.add(TagFromName.TotalTime);
		tagList.add(TagFromName.AudioSampleData);
		tagList.add(TagFromName.AudioComments);
		tagList.add(TagFromName.CurveLabel);
		tagList.add(TagFromName.CurveReferencedOverlaySequence);
		tagList.add(TagFromName.CurveReferencedOverlayGroup);
		tagList.add(TagFromName.CurveData);
		tagList.add(TagFromName.SharedFunctionalGroupsSequence);
		tagList.add(TagFromName.PerFrameFunctionalGroupsSequence);
		tagList.add(TagFromName.WaveformSequence);
		tagList.add(TagFromName.ChannelMinimumValue);
		tagList.add(TagFromName.ChannelMaximumValue);
		tagList.add(TagFromName.WaveformBitsAllocated);
		tagList.add(TagFromName.WaveformSampleInterpretation);
		tagList.add(TagFromName.WaveformPaddingValue);
		tagList.add(TagFromName.WaveformData);
		tagList.add(TagFromName.FirstOrderPhaseCorrectionAngle);
		tagList.add(TagFromName.SpectroscopyData);
		tagList.add(TagFromName.OverlayRows);
		tagList.add(TagFromName.OverlayColumns);
		tagList.add(TagFromName.OverlayPlanes);
		tagList.add(TagFromName.NumberOfFramesInOverlay);
		tagList.add(TagFromName.OverlayDescription);
		tagList.add(TagFromName.OverlayType);
		tagList.add(TagFromName.OverlaySubtype);
		tagList.add(TagFromName.OverlayOrigin);
		tagList.add(TagFromName.ImageFrameOrigin);
		tagList.add(TagFromName.PlaneOrigin);
		tagList.add(TagFromName.OverlayCompressionCode);
		tagList.add(TagFromName.OverlayCompressionOriginator);
		tagList.add(TagFromName.OverlayCompressionLabel);
		tagList.add(TagFromName.OverlayCompressionDescription);
		tagList.add(TagFromName.OverlayCompressionStepPointers);
		tagList.add(TagFromName.OverlayRepeatInterval);
		tagList.add(TagFromName.OverlayBitsGrouped);
		tagList.add(TagFromName.OverlayBitsAllocated);
		tagList.add(TagFromName.OverlayBitPosition);
		tagList.add(TagFromName.OverlayFormat);
		tagList.add(TagFromName.OverlayLocation);
		tagList.add(TagFromName.OverlayCodeLabel);
		tagList.add(TagFromName.OverlayNumberOfTables);
		tagList.add(TagFromName.OverlayCodeTableLocation);
		tagList.add(TagFromName.OverlayBitsForCodeWord);
		tagList.add(TagFromName.OverlayActivationLayer);
		tagList.add(TagFromName.OverlayDescriptorGray);
		tagList.add(TagFromName.OverlayDescriptorRed);
		tagList.add(TagFromName.OverlayDescriptorGreen);
		tagList.add(TagFromName.OverlayDescriptorBlue);
		tagList.add(TagFromName.OverlayGray);
		tagList.add(TagFromName.OverlayRed);
		tagList.add(TagFromName.OverlayGreen);
		tagList.add(TagFromName.OverlayBlue);
		tagList.add(TagFromName.ROIArea);
		tagList.add(TagFromName.ROIMean);
		tagList.add(TagFromName.ROIStandardDeviation);
		tagList.add(TagFromName.OverlayLabel);
		tagList.add(TagFromName.OverlayData);
		tagList.add(TagFromName.OverlayComments);
		tagList.add(TagFromName.PixelData);
		tagList.add(TagFromName.CoefficientsSDVN);
		tagList.add(TagFromName.CoefficientsSDHN);
		tagList.add(TagFromName.CoefficientsSDDN);
		tagList.add(TagFromName.VariablePixelData);
		tagList.add(TagFromName.VariableNextDataGroup);
		tagList.add(TagFromName.VariableCoefficientsSDVN);
		tagList.add(TagFromName.VariableCoefficientsSDHN);
		tagList.add(TagFromName.VariableCoefficientsSDDN);
		tagList.add(TagFromName.DigitalSignaturesSequence);
		tagList.add(TagFromName.DataSetTrailingPadding);
	}

	protected void createValueRepresentationsByTag() {

		valueRepresentationsByTag = new HashMap(100);

		valueRepresentationsByTag.put(TagFromName.CommandGroupLength,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.CommandLengthToEnd,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.AffectedSOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.RequestedSOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.CommandRecognitionCode,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.CommandField,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MessageID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MessageIDBeingRespondedTo,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Initiator,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.Receiver,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.FindLocation,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.MoveDestination,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.Priority,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DataSetType,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfMatches,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ResponseSequenceNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Status,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OffendingElement,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.ErrorComment,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ErrorID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.AffectedSOPInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.RequestedSOPInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.EventTypeID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.AttributeIdentifierList,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.ActionTypeID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfRemainingSuboperations,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfCompletedSuboperations,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfFailedSuboperations,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfWarningSuboperations,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MoveOriginatorApplicationEntityTitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.MoveOriginatorMessageID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DialogReceiver,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.TerminalType,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.MessageSetID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.EndMessageSet,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DisplayFormat,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.PagePositionID,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.TextFormatID,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.NormalReverse,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.AddGrayScale,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.Borders,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.Copies,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.OldMagnificationType,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.Erase,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.Print,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.Overlays,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FileMetaInformationGroupLength,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.FileMetaInformationVersion,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.MediaStorageSOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.MediaStorageSOPInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.TransferSyntaxUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ImplementationClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ImplementationVersionName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SourceApplicationEntityTitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.PrivateInformationCreatorUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.PrivateInformation,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.FileSetID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FileSetDescriptorFileID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FileSetCharacterSet,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RootDirectoryFirstRecord,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RootDirectoryLastRecord,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.FileSetConsistencyFlag,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DirectoryRecordSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NextDirectoryRecordOffset,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RecordInUseFlag,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LowerLevelDirectoryOffset,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DirectoryRecordType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PrivateRecordUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedFileID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRDRDirectoryRecordOffset,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ReferencedSOPClassUIDInFile,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedSOPInstanceUIDInFile,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedTransferSyntaxUIDInFile,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedRelatedGeneralSOPClassUIDInFile,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.NumberOfReferences,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.LengthToEnd,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SpecificCharacterSet,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LanguageCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RecognitionCode,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InstanceCreationDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.InstanceCreationTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.InstanceCreatorUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SOPInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.RelatedGeneralSOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.OriginalSpecializedSOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.StudyDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.SeriesDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.AcquisitionDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ContentDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.OverlayDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.CurveDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.AcquisitionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.StudyTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.SeriesTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.AcquisitionTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ContentTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.OverlayTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.CurveTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.OldDataSetType,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OldDataSetSubtype,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NuclearMedicineSeriesTypeRetired,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AccessionNumber,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.IssuerOfAccessionNumberSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.QueryRetrieveLevel,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RetrieveAETitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.InstanceAvailability,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FailedSOPInstanceUIDList,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.Modality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ModalitiesInStudy,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SOPClassesInStudy,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ConversionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PresentationIntentType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Manufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InstitutionName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InstitutionAddress,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.InstitutionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferringPhysicianName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ReferringPhysicianAddress,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ReferringPhysicianTelephoneNumber,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ReferringPhysicianIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CodeValue,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeDesignator,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeVersion,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CodeMeaning,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MappingResource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContextGroupVersion,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ContextGroupLocalVersion,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ContextGroupExtensionFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ContextGroupExtensionCreatorUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ContextIdentifier,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeRegistry,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeExternalID,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeName,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeResponsibleOrganization,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ContextUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.TimezoneOffsetFromUTC,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.NetworkID,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.StationName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.StudyDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProcedureCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SeriesDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InstitutionalDepartmentName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PhysicianOfRecord,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.PhysicianOfRecordIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformingPhysicianName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.PerformingPhysicianIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PhysicianReadingStudy,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.PhysicianReadingStudyIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OperatorName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.OperatorIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AdmittingDiagnosesDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AdmittingDiagnosesCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ManufacturerModelName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedResultsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedStudySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedPerformedProcedureStepSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSeriesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedPatientSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedVisitSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedOverlaySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedStereometricInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedWaveformSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedCurveSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedRealWorldValueMappingInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedSOPInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SOPClassesSupported,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedFrameNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TransactionUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.FailureReason,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FailedSOPSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSOPSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StudiesContainingOtherReferencedInstancesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelatedSeriesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OldLossyImageCompression,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DerivationDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SourceImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StageName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.StageNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfStages,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ViewName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ViewNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfEventTimers,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfViewsInStage,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.EventElapsedTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EventTimerName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.EventTimerSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EventTimeOffset,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.EventCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StartTrim,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.StopTrim,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RecommendedDisplayFrameRate,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TransducerPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TransducerOrientation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnatomicStructure,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnatomicRegionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicRegionModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrimaryAnatomicStructureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicStructureSpaceOrRegionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrimaryAnatomicStructureModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransducerPositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransducerPositionModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransducerOrientationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransducerOrientationModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicStructureSpaceOrRegionCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicPortalOfEntranceCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicApproachDirectionCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicPerspectiveDescriptionTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.AnatomicPerspectiveCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicLocationOfExaminingInstrumentDescriptionTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.AnatomicLocationOfExaminingInstrumentCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OnAxisBackgroundAnatomicStructureCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlternateRepresentationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IrradiationEventUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.IdentifyingComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.FrameType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedImageEvidenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedRawDataSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CreatorVersionUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DerivationImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceImageEvidenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PixelPresentation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VolumetricProperties,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VolumeBasedCalculationTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ComplexImageComponent,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionContrast,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DerivationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedPresentationStateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedOtherPlaneSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameDisplaySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecommendedDisplayFrameRateInFloat,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SkipFrameRangeFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.PatientID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssuerOfPatientID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TypeOfPatientID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IssuerOfPatientIDQualifiersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientBirthDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.PatientBirthTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PatientSex,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientInsurancePlanCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientPrimaryLanguageCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientPrimaryLanguageModifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OtherPatientID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OtherPatientName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.OtherPatientIDSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientBirthName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.PatientAge,ValueRepresentation.AS);
		valueRepresentationsByTag.put(TagFromName.PatientSize,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PatientWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PatientAddress,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InsurancePlanIdentification,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.PatientMotherBirthName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.MilitaryRank,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BranchOfService,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MedicalRecordLocator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MedicalAlerts,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.Allergies,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CountryOfResidence,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RegionOfResidence,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientTelephoneNumber,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.EthnicGroup,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.Occupation,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SmokingStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AdditionalPatientHistory,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.PregnancyStatus,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LastMenstrualDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.PatientReligiousPreference,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientSpeciesDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientSpeciesCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientSexNeutered,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientBreedDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientBreedCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BreedRegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BreedRegistrationNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BreedRegistryCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ResponsiblePerson,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ResponsiblePersonRole,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ResponsibleOrganization,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ExaminedBodyThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSponsorName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialProtocolID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialProtocolName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSiteID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSiteName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSubjectID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSubjectReadingID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialTimePointID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialTimePointDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialCoordinatingCenterName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientIdentityRemoved,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeidentificationMethod,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DeidentificationMethodCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSeriesID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSeriesDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialProtocolEthicsCommitteeName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialProtocolEthicsCommitteeApprovalNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ConsentForClinicalTrialUseSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DistributionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ConsentForDistributionFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAgent,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAgentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAdministrationRouteSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BodyPartExamined,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScanningSequence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SequenceVariant,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScanOptions,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRAcquisitionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SequenceName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.AngioFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InterventionDrugInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.InterventionDrugStopTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.InterventionDrugDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.InterventionDrugCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AdditionalDrugSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.Radionuclide,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.Radiopharmaceutical,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowCenterline,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowTotalWidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.InterventionDrugName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InterventionDrugStartTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.InterventionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TherapyType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InterventionStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TherapyDescription,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InterventionDescription,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CineRate,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.InitialCineRunState,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SliceThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.KVP,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CountsAccumulated,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionTerminationCondition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EffectiveDuration,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionStartCondition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionStartConditionData,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionTerminationConditionData,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RepetitionTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EchoTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.InversionTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfAverages,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImagingFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImagedNucleus,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.EchoNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.MagneticFieldStrength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SpacingBetweenSlices,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfPhaseEncodingSteps,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.DataCollectionDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EchoTrainLength,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PercentSampling,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PercentPhaseFieldOfView,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PixelBandwidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeviceSerialNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DeviceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.PlateID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.GeneratorID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.GridID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CassetteID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.GantryID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SecondaryCaptureDeviceID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HardcopyCreationDeviceID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DateOfSecondaryCapture,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TimeOfSecondaryCapture,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.SecondaryCaptureDeviceManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HardcopyDeviceManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SecondaryCaptureDeviceManufacturerModelName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SecondaryCaptureDeviceSoftwareVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HardcopyDeviceSoftwareVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HardcopyDeviceManufacturerModelName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SoftwareVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.VideoImageFormatAcquired,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DigitalImageFormatAcquired,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProtocolName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusRoute,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusVolume,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusStartTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusStopTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusTotalDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SyringeCounts,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ContrastFlowRate,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContrastFlowDuration,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusIngredient,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusIngredientConcentration,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SpatialResolution,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TriggerTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TriggerSourceOrType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NominalInterval,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.FrameTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CardiacFramingType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FrameTimeVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FrameDelay,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImageTriggerDelay,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MultiplexGroupTimeOffset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TriggerTimeOffset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SynchronizationTrigger,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SynchronizationChannel,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TriggerSamplePosition,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalRoute,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalVolume,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalStartTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalStopTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.RadionuclideTotalDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadionuclideHalfLife,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadionuclidePositronFraction,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalSpecificActivity,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalStartDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalStopDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.BeatRejectionFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LowRRValue,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.HighRRValue,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IntervalsAcquired,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IntervalsRejected,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PVCRejection,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SkipBeats,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.HeartRate,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CardiacNumberOfImages,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TriggerWindow,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReconstructionDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DistanceSourceToDetector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DistanceSourceToPatient,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EstimatedRadiographicMagnificationFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GantryDetectorTilt,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GantryDetectorSlew,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableHeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTraverse,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableMotion,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TableVerticalIncrement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableLateralIncrement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableLongitudinalIncrement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AngularPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadialPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ScanArc,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.AngularStep,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CenterOfRotationOffset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RotationOffset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewDimensions,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ExposureTime,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.XRayTubeCurrent,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.Exposure,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ExposureInuAs,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AveragePulseWidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiationSetting,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RectificationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RadiationMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageAndFluoroscopyAreaDoseProduct,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FilterType,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TypeOfFilters,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IntensifierSize,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImagerPixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.Grid,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GeneratorPower,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CollimatorGridName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CollimatorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FocalDistance,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.XFocusCenter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.YFocusCenter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FocalSpot,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.AnodeTargetMaterial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BodyPartThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompressionForce,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DateOfLastCalibration,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TimeOfLastCalibration,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ConvolutionKernel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.UpperLowerPixelValues,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ActualFrameDuration,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CountRate,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PreferredPlaybackSequencing,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ReceiveCoilName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TransmitCoilName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PlateType,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PhosphorType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScanVelocity,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WholeBodyTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScanLength,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionMatrix,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.InPlanePhaseEncodingDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FlipAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.VariableFlipAngleFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SAR,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.dBdt,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionDeviceProcessingDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AcquisitionDeviceProcessingCode,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CassetteOrientation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CassetteSize,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExposuresOnPlate,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RelativeXRayExposure,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ColumnAngulation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TomoLayerHeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TomoAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TomoTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TomoType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TomoClass,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfTomosynthesisSourceImages,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PositionerMotion,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PositionerType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PositionerPrimaryAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PositionerSecondaryAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PositionerPrimaryAngleIncrement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PositionerSecondaryAngleIncrement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorPrimaryAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorSecondaryAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ShutterShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShutterLeftVerticalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ShutterRightVerticalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ShutterUpperHorizontalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ShutterLowerHorizontalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CenterOfCircularShutter,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RadiusOfCircularShutter,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.VerticesOfPolygonalShutter,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ShutterPresentationValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ShutterOverlayGroup,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ShutterPresentationColorCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CollimatorShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CollimatorLeftVerticalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CollimatorRightVerticalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CollimatorUpperHorizontalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CollimatorLowerHorizontalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CenterOfCircularCollimator,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RadiusOfCircularCollimator,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.VerticesOfPolygonalCollimator,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionTimeSynchronized,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TimeSource,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TimeDistributionProtocol,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NTPSourceAddress,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PageNumberVector,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.FrameLabelVector,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.FramePrimaryAngleVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FrameSecondaryAngleVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SliceLocationVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DisplayWindowLabelVector,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.NominalScannedPixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DigitizingDeviceTransportDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RotationOfScannedFilm,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IVUSAcquisition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IVUSPullbackRate,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IVUSGatedRate,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IVUSPullbackStartFrameNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IVUSPullbackStopFrameNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.LesionNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionComments,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OutputPower,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TransducerData,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FocusDepth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ProcessingFunction,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PostprocessingFunction,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MechanicalIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BoneThermalIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CranialThermalIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SoftTissueThermalIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SoftTissueFocusThermalIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SoftTissueSurfaceThermalIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DynamicRange,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TotalGain,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DepthOfScanField,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PatientPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ViewPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ProjectionEponymousNameCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageTransformationMatrix,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImageTranslationVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.Sensitivity,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SequenceOfUltrasoundRegions,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RegionSpatialFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RegionDataType,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RegionFlags,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RegionLocationMinX0,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RegionLocationMinY0,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RegionLocationMaxX1,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RegionLocationMaxY1,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ReferencePixelX0,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.ReferencePixelY0,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.PhysicalUnitsXDirection,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PhysicalUnitsYDirection,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ReferencePixelPhysicalValueX,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ReferencePixelPhysicalValueY,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PhysicalDeltaX,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PhysicalDeltaY,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TransducerFrequency,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TransducerType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PulseRepetitionFrequency,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DopplerCorrectionAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SteeringAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DopplerSampleVolumeXPositionRetired,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DopplerSampleVolumeXPosition,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.DopplerSampleVolumeYPositionRetired,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DopplerSampleVolumeYPosition,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionX0Retired,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionX0,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionY0Retired,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionY0,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionX1Retired,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionX1,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionY1Retired,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionY1,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.PixelComponentOrganization,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PixelComponentMask,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.PixelComponentRangeStart,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.PixelComponentRangeStop,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.PixelComponentPhysicalUnits,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PixelComponentDataType,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfTableBreakPoints,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TableOfXBreakPoints,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TableOfYBreakPoints,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.NumberOfTableEntries,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TableOfPixelValues,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TableOfParameterValues,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RWaveTimeVector,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DetectorConditionsNominalFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DetectorTemperature,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DetectorConfiguration,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DetectorDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.DetectorMode,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.DetectorID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DateOfLastDetectorCalibration,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TimeOfLastDetectorCalibration,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ExposuresOnDetectorSinceLastCalibration,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ExposuresOnDetectorSinceManufactured,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.DetectorTimeSinceLastExposure,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorActiveTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorActivationOffsetFromExposure,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorBinning,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorElementPhysicalSize,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorElementSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorActiveShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DetectorActiveDimensions,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorActiveOrigin,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorManufacturerName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DetectorManufacturerModelName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewOrigin,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewRotation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewHorizontalFlip,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GridAbsorbingMaterial,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.GridSpacingMaterial,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.GridThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GridPitch,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GridAspectRatio,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.GridPeriod,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GridFocalDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FilterMaterial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilterThicknessMinimum,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FilterThicknessMaximum,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ExposureControlMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExposureControlModeDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ExposureStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PhototimerSetting,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ExposureTimeInuS,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.XRayTubeCurrentInuA,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContentQualification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PulseSequenceName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.MRImagingModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EchoPulseSequence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InversionRecovery,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FlowCompensation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MultipleSpinEcho,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MultiplanarExcitation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PhaseContrast,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TimeOfFlightContrast,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Spoiling,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SteadyStatePulseSequence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EchoPlanarPulseSequence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TagAngleFirstAxis,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MagnetizationTransfer,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.T2Preparation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BloodSignalNulling,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SaturationRecovery,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpectrallySelectedSuppression,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpectrallySelectedExcitation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpatialPresaturation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Tagging,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OversamplingPhase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TagSpacingFirstDimension,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.GeometryOfKSpaceTraversal,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SegmentedKSpaceTraversal,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RectilinearPhaseEncodeReordering,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TagThickness,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PartialFourierDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CardiacSynchronizationTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReceiveCoilManufacturerName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MRReceiveCoilSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReceiveCoilType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.QuadratureReceiveCoil,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MultiCoilDefinitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MultiCoilConfiguration,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MultiCoilElementName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.MultiCoilElementUsed,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRTransmitCoilSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransmitCoilManufacturerName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TransmitCoilType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpectralWidth,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ChemicalShiftReference,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VolumeLocalizationTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRAcquisitionFrequencyEncodingSteps,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Decoupling,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DecoupledNucleus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DecouplingFrequency,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DecouplingMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DecouplingChemicalShiftReference,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.KSpaceFiltering,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TimeDomainFiltering,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfZeroFills,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BaselineCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ParallelReductionFactorInPlane,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CardiacRRIntervalSpecified,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.AcquisitionDuration,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FrameAcquisitionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.DiffusionDirectionality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DiffusionGradientDirectionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ParallelAcquisition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ParallelAcquisitionTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InversionTimes,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MetaboliteMapDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PartialFourier,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EffectiveEchoTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MetaboliteCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChemicalShiftSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CardiacSignalSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DiffusionBValue,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DiffusionGradientOrientation,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VelocityEncodingDirection,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VelocityEncodingMinimumValue,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.NumberOfKSpaceTrajectories,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CoverageOfKSpace,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpectroscopyAcquisitionPhaseRows,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ParallelReductionFactorInPlaneRetired,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TransmitterFrequency,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ResonantNucleus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FrequencyCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRSpectroscopyFOVGeometrySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SlabThickness,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SlabOrientation,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MidSlabPosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MRSpatialSaturationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRTimingAndRelatedParametersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MREchoSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRDiffusionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CardiacSynchronizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRAveragesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRFOVGeometrySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VolumeLocalizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpectroscopyAcquisitionDataColumns,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DiffusionAnisotropyType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FrameReferenceDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.MRMetaboliteMapSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ParallelReductionFactorOutOfPlane,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SpectroscopyAcquisitionOutOfPlanePhaseSteps,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.BulkMotionStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ParallelReductionFactorSecondInPlane,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CardiacBeatRejectionTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RespiratoryMotionCompensationTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RespiratorySignalSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BulkMotionCompensationTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BulkMotionSignalSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApplicableSafetyStandardAgency,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApplicableSafetyStandardDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OperatingModeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OperatingModeType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OperatingMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpecificAbsorptionRateDefinition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GradientOutputType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpecificAbsorptionRateValue,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.GradientOutput,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FlowCompensationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TaggingDelay,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RespiratoryMotionCompensationTechniqueDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.RespiratorySignalSourceID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ChemicalShiftMinimumIntegrationLimitInHz,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ChemicalShiftMaximumIntegrationLimitInHz,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MRVelocityEncodingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FirstOrderPhaseCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.WaterReferencedPhaseCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRSpectroscopyAcquisitionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RespiratoryCyclePosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VelocityEncodingMaximumValue,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TagSpacingSecondDimension,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TagAngleSecondAxis,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.FrameAcquisitionDuration,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MRImageFrameTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRSpectroscopyFrameTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRAcquisitionPhaseEncodingStepsInPlane,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MRAcquisitionPhaseEncodingStepsOutOfPlane,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SpectroscopyAcquisitionPhaseColumns,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.CardiacCyclePosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpecificAbsorptionRateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RFEchoTrainLength,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.GradientEchoTrainLength,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ChemicalShiftMinimumIntegrationLimitInPPM,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ChemicalShiftMaximumIntegrationLimitInPPM,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTAcquisitionTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AcquisitionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TubeAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTAcquisitionDetailsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RevolutionTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SingleCollimationWidth,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TotalCollimationWidth,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTTableDynamicsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TableSpeed,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TableFeedPerRotation,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SpiralPitchFactor,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTGeometrySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DataCollectionCenterPatient,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTReconstructionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReconstructionAlgorithm,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ConvolutionKernelGroup,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReconstructionFieldOfView,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ReconstructionTargetCenterPatient,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ReconstructionAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ImageFilter,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CTExposureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReconstructionPixelSpacing,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ExposureModulationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EstimatedDoseSaving,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTXRayDetailsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CTPositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TablePosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ExposureTimeInms,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTImageFrameTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XRayTubeCurrentInmA,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ExposureInmAs,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ConstantVolumeFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FluoroscopyFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DistanceSourceToDataCollectionCenter,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAgentNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusIngredientCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContrastAdministrationProfileSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusUsageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAgentAdministered,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAgentDetected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAgentPhase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CTDIvol,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTDIPhantomTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CalciumScoringMassFactorPatient,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CalciumScoringMassFactorDevice,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.EnergyWeightingFactor,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CTAdditionalXRaySourceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ProjectionPixelCalibrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DistanceSourceToIsocenter,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DistanceObjectToTableTop,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ObjectPixelSpacingInCenterOfBeam,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PositionerPositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TablePositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CollimatorShapeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XAXRFFrameCharacteristicsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameAcquisitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XRayReceptorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionProtocolName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AcquisitionProtocolDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusIngredientOpaque,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DistanceReceptorPlaneToDetectorHousing,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IntensifierActiveShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IntensifierActiveDimensions,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PhysicalDetectorSize,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PositionOfIsocenterProjection,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ExposureControlSensingRegionsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ExposureControlSensingRegionShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExposureControlSensingRegionLeftVerticalEdge,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ExposureControlSensingRegionRightVerticalEdge,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ExposureControlSensingRegionUpperHorizontalEdge,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ExposureControlSensingRegionLowerHorizontalEdge,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.CenterOfCircularExposureControlSensingRegion,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.RadiusOfCircularExposureControlSensingRegion,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.VerticesOfPolygonalExposureControlSensingRegion,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ColumnAngulationPatient,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BeamAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FrameDetectorParametersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CalculatedAnatomyThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CalibrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObjectThicknessSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlaneIdentification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewDimensionsInFloat,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IsocenterReferenceSystemSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PositionerIsocenterPrimaryAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PositionerIsocenterSecondaryAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PositionerIsocenterDetectorRotationAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableXPositionToIsocenter,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableYPositionToIsocenter,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableZPositionToIsocenter,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableHorizontalRotationAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableHeadTiltAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableCradleTiltAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FrameDisplayShutterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AcquiredImageAreaDoseProduct,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CArmPositionerTabletopRelationship,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.XRayGeometrySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IrradiationEventIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XRay3DFrameTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContributingSourcesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XRay3DAcquisitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrimaryPositionerScanArc,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SecondaryPositionerScanArc,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PrimaryPositionerScanStartAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SecondaryPositionerScanStartAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PrimaryPositionerIncrement,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SecondaryPositionerIncrement,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StartAcquisitionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.EndAcquisitionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ApplicationName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ApplicationVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ApplicationManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AlgorithmType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AlgorithmDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.XRay3DReconstructionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReconstructionDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PerProjectionAcquisitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DiffusionBMatrixSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DiffusionBMatrixValueXX,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DiffusionBMatrixValueXY,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DiffusionBMatrixValueXZ,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DiffusionBMatrixValueYY,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DiffusionBMatrixValueYZ,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DiffusionBMatrixValueZZ,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DecayCorrectionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.StartDensityThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.StartRelativeDensityDifferenceThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.StartCardiacTriggerCountThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.StartRespiratoryTriggerCountThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TerminationCountsThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TerminationDensityThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TerminationRelativeDensityThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TerminationTimeThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TerminationCardiacTriggerCountThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TerminationRespiratoryTriggerCountThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DetectorGeometry,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TransverseDetectorSeparation,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.AxialDetectorDimension,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalAgentNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PETFrameAcquisitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PETDetectorMotionDetailsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PETTableDynamicsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PETPositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PETFrameCorrectionFactorsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalUsageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AttenuationCorrectionSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfIterations,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfSubsets,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PETReconstructionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PETFrameTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TimeOfFlightInformationUsed,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReconstructionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DecayCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AttenuationCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScatterCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeadTimeCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GantryMotionCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientMotionCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CountLossNormalizationCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RandomsCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NonUniformRadialSamplingCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SensitivityCalibrated,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DetectorNormalizationCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IterativeReconstructionMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AttenuationCorrectionTemporalRelationship,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientPhysiologicalStateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientPhysiologicalStateCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DepthsOfFocus,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ExcludedIntervalsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ExclusionStartDatetime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ExclusionDuration,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.USImageDescriptionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageDataTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DataType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TransducerScanPatternCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AliasedDataType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PositionMeasuringDeviceUsed,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TransducerGeometryCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransducerBeamSteeringCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransducerApplicationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContributingEquipmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContributionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ContributionDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.StudyInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SeriesInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.StudyID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SeriesNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.InstanceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IsotopeNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PhaseNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IntervalNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TimeSlotNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AngleNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ItemNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PatientOrientation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CurveNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.LUTNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ImagePosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImagePositionPatient,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImageOrientation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImageOrientationPatient,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.Location,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.Laterality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageLaterality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageGeometryType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MaskingImage,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ReportNumberTrial,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TemporalPositionIdentifier,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfTemporalPositions,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TemporalResolution,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SynchronizationFrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SeriesInStudy,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionsInSeries,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ImagesInAcquisition,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ImagesInSeries,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionsInStudy,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ImagesInStudy,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.Reference,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PositionReferenceIndicator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SliceLocation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OtherStudyNumbers,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfPatientRelatedStudies,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfPatientRelatedSeries,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfPatientRelatedInstances,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfStudyRelatedSeries,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfStudyRelatedInstances,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfSeriesRelatedInstances,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SourceImageID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ModifyingDeviceID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ModifiedImageID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ModifiedImageDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ModifyingDeviceManufacturer,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ModifiedImageTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ModifiedImageDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ImageComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.OriginalImageIdentification,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.OriginalImageIdentificationNomenclature,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.StackID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.InStackPositionNumber,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.FrameAnatomySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameLaterality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FrameContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlanePositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlaneOrientationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TemporalPositionIndex,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.NominalCardiacTriggerDelayTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FrameAcquisitionNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DimensionIndexValues,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.FrameComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ConcatenationUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.InConcatenationNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.InConcatenationTotalNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DimensionOrganizationUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DimensionIndexPointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.FunctionalGroupPointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.DimensionIndexPrivateCreator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DimensionOrganizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DimensionIndexSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ConcatenationFrameOffsetNumber,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.FunctionalGroupPrivateCreator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NominalPercentageOfCardiacPhase,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NominalPercentageOfRespiratoryPhase,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StartingRespiratoryAmplitude,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StartingRespiratoryPhase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EndingRespiratoryAmplitude,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.EndingRespiratoryPhase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RespiratoryTriggerType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RRIntervalTimeNominal,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ActualCardiacTriggerDelayTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RespiratorySynchronizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RespiratoryIntervalTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.NominalRespiratoryTriggerDelayTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RespiratoryTriggerDelayThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ActualRespiratoryTriggerDelayTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ImagePositionVolume,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ImageOrientationVolume,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.UltrasoundAcquisitionGeometry,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApexPosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VolumeToTransducerMappingMatrix,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VolumeToTableMappingMatrix,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PatientFrameofReferenceSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TemporalPositionTimeOffset,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PlanePositionVolumeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlaneOrientationVolumeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TemporalPositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DimensionOrganizationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VolumeFrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.TableFrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DimensionDescriptionLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientOrientationInFrameSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AcquisitionIndex,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ContributingSOPInstancesReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReconstructionIndex,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LightPathFilterPassThroughWavelength,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LightPathFilterPassBand,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImagePathFilterPassThroughWavelength,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImagePathFilterPassBand,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PatientEyeMovementCommanded,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientEyeMovementCommandedCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SphericalLensPower,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CylinderLensPower,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CylinderAxis,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.EmmetropicMagnification,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IntraOcularPressure,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.HorizontalFieldOfView,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PupilDilated,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DegreeOfDilation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StereoBaselineAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StereoBaselineDisplacement,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StereoHorizontalPixelOffset,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StereoVerticalPixelOffset,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StereoRotation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AcquisitionDeviceTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IlluminationTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LightPathFilterTypeStackCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImagePathFilterTypeStackCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LensesCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelDescriptionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RefractiveStateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MydriaticAgentCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelativeImagePositionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StereoPairsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LeftImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RightImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AxialLengthOfEye,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.OphthalmicFrameLocationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferenceCoordinates,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DepthSpatialResolution,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MaximumDepthDistortion,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AlongScanSpatialResolution,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MaximumAlongScanDistortion,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.OphthalmicImageOrientation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DepthOfTransverseImage,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MydriaticAgentConcentrationUnitsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AcrossScanSpatialResolution,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MaximumAcrossScanDistortion,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MydriaticAgentConcentration,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IlluminationWaveLength,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IlluminationPower,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IlluminationBandwidth,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MydriaticAgentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SamplesPerPixel,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SamplesPerPixelUsed,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PhotometricInterpretation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageDimensions,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PlanarConfiguration,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfFrames,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.FrameIncrementPointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.FrameDimensionPointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.Rows,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Columns,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Planes,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.UltrasoundColorDataPresent,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ZoomFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ZoomCenter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PixelAspectRatio,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ImageFormat,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ManipulatedImage,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CorrectedImage,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CompressionRecognitionCode,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CompressionCode,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CompressionOriginator,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CompressionLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CompressionDescription,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CompressionSequence,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CompressionStepPointers,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.RepeatInterval,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BitsGrouped,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PerimeterTable,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PerimeterValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.PredictorRows,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PredictorColumns,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PredictorConstants,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BlockedPixels,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BlockRows,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BlockColumns,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RowOverlap,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ColumnOverlap,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BitsAllocated,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BitsStored,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.HighBit,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PixelRepresentation,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SmallestValidPixelValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.LargestValidPixelValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.SmallestImagePixelValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.LargestImagePixelValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.SmallestPixelValueInSeries,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.LargestPixelValueInSeries,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.SmallestPixelValueInPlane,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.LargestPixelValueInPlane,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.PixelPaddingValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.PixelPaddingRangeLimit,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.ImageLocation,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.QualityControlImage,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BurnedInAnnotation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TransformLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TransformVersionNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SequenceOfCompressedData,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DCTLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DataBlockDescription,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DataBlock,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.NormalizationFactorFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ZonalMapNumberFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ZonalMapLocation,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.ZonalMapFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.AdaptiveMapFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CodeNumberFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PixelSpacingCalibrationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PixelSpacingCalibrationDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PixelIntensityRelationship,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PixelIntensityRelationshipSign,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.WindowCenter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WindowWidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RescaleIntercept,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RescaleSlope,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RescaleType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.WindowCenterWidthExplanation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.VOILUTFunction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GrayScale,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.RecommendedViewingMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GrayLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.RedPaletteColorLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.GreenPaletteColorLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.BluePaletteColorLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.AlphaPaletteColorLookupTableDescriptor,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LargeRedPaletteColorLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.LargeGreenPaletteColorLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.LargeBluePaletteColorLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.PaletteColorLookupTableUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.GrayLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.RedPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.GreenPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.BluePaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.AlphaPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.LargeRedPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.LargeGreenPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.LargeBluePaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.LargePaletteColorLookupTableUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SegmentedRedPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.SegmentedGreenPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.SegmentedBluePaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.BreastImplantPresent,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PartialView,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PartialViewDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PartialViewCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpatialLocationsPreserved,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DataFrameAssignmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DataPathAssignment,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BitsMappedToColorLookupTable,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BlendingLUT1Sequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BlendingLUT1TransferFunction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BlendingWeightConstant,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.BlendingLookupTableDescriptor,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BlendingLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.EnhancedPaletteColorLookupTableSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BlendingLUT2Sequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BlendingLUT2TransferFunction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DataPathID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RGBLUTTransferFunction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AlphaLUTTransferFunction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ICCProfile,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.LossyImageCompression,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LossyImageCompressionRatio,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.LossyImageCompressionMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ModalityLUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LUTDescriptor,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LUTExplanation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ModalityLUTType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.LUTData,ValueRepresentation.XO);
		valueRepresentationsByTag.put(TagFromName.VOILUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SoftcopyVOILUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImagePresentationComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.BiplaneAcquisitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RepresentativeFrameNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FrameNumbersOfInterest,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FrameOfInterestDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FrameOfInterestType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MaskPointer,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RWavePointer,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MaskSubtractionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MaskOperation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApplicableFrameRange,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MaskFrameNumbers,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ContrastFrameAveraging,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MaskSubPixelShift,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TIDOffset,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.MaskOperationExplanation,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PixelDataProviderURL,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.DataPointRows,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DataPointColumns,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SignalDomainColumns,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LargestMonochromePixelValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DataRepresentation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PixelMeasuresSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameVOILUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PixelValueTransformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SignalDomainRows,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DisplayFilterPercentage,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FramePixelShiftSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SubtractionItemID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PixelIntensityRelationshipLUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FramePixelDataPropertiesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GeometricalProperties,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GeometricMaximumDistortion,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ImageProcessingApplied,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MaskSelectionMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LUTFunction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MaskVisibilityPercentage,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PixelShiftSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RegionPixelShiftSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerticesOfTheRegion,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.MultiframePresentationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PixelShiftFrameRange,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LUTFrameRange,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageToEquipmentMappingMatrix,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EquipmentCoordinateSystemIdentification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.StudyStatusID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.StudyPriorityID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.StudyIDIssuer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.StudyVerifiedDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.StudyVerifiedTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.StudyReadDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.StudyReadTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledStudyStartDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ScheduledStudyStartTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledStudyStopDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ScheduledStudyStopTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledStudyLocation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScheduledStudyLocationAETitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.ReasonForStudy,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RequestingPhysicianIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RequestingPhysician,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.RequestingService,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.StudyArrivalDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.StudyArrivalTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.StudyCompletionDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.StudyCompletionTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.StudyComponentStatusID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedureDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedureCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RequestedContrastAgent,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.StudyComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ReferencedPatientAliasSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisitStatusID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AdmissionID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssuerOfAdmissionID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssuerOfAdmissionIDSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RouteOfAdmissions,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScheduledAdmissionDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ScheduledAdmissionTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledDischargeDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ScheduledDischargeTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledPatientInstitutionResidence,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AdmittingDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.AdmittingTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.DischargeDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.DischargeTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.DischargeDiagnosisDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DischargeDiagnosisCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecialNeeds,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ServiceEpisodeID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssuerOfServiceEpisodeID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ServiceEpisodeDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssuerOfServiceEpisodeIDSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PertinentDocumentsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CurrentPatientLocation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientInstitutionResidence,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientState,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientClinicalTrialParticipationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisitComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.WaveformOriginality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfWaveformChannels,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfWaveformSamples,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SamplingFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MultiplexGroupLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ChannelDefinitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WaveformChannelNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ChannelLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ChannelStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ChannelSourceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelSourceModifiersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceWaveformSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelDerivationDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ChannelSensitivity,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelSensitivityUnitsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelSensitivityCorrectionFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelBaseline,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelTimeSkew,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelSampleSkew,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelOffset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WaveformBitsStored,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FilterLowFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FilterHighFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NotchFilterFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NotchFilterBandwidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WaveformDataDisplayScale,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.WaveformDisplayBackgroundCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.WaveformPresentationGroupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PresentationGroupNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ChannelDisplaySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelRecommendedDisplayCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ChannelPosition,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DisplayShadingFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FractionalChannelDisplayScale,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AbsoluteChannelDisplayScale,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MultiplexedAudioChannelsDescriptionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelIdentificationCode,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ChannelMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScheduledStationAETitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepStartDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepStartTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepEndDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepEndTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledPerformingPhysicianName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScheduledProtocolCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.StageCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledPerformingPhysicianIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledStationName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepLocation,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PreMedication,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OrderPlacerIdentifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OrderFillerIdentifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LocalNamespaceEntityID,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.UniversalEntityID,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.UniversalEntityIDType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IdentifierTypeCode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AssigningFacilitySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AssigningJurisdictionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AssigningAgencyOrDepartmentCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedNonImageCompositeSOPInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedStationAETitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.PerformedStationName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PerformedLocation,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepStartDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepStartTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepEndDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepEndTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureTypeDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PerformedProtocolCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedProtocolType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScheduledStepAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RequestAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CommentsOnPerformedProcedureStep,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepDiscontinuationReasonCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.QuantitySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.Quantity,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MeasuringUnitsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BillingItemSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TotalTimeOfFluoroscopy,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TotalNumberOfExposures,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.EntranceDose,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ExposedArea,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DistanceSourceToEntrance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DistanceSourceToSupport,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ExposureDoseSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CommentsOnRadiationDose,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.XRayOutput,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.HalfValueLayer,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OrganDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OrganExposed,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BillingProcedureStepSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FilmConsumptionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BillingSuppliesAndDevicesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedProcedureStepSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedSeriesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CommentsOnScheduledProcedureStep,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ProtocolContextSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContentItemModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledSpecimenSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenAccessionNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContainerIdentifier,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssuerOfTheContainerIdentifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlternateContainerIdentifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContainerTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContainerDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenIdentifier,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SpecimenDescriptionSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenDescriptionTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SpecimenUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.AcquisitionContextSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AcquisitionContextDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SpecimenDescriptionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IssuerOfTheSpecimenIdentifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenShortDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SpecimenDetailedDescription,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.SpecimenPreparationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenPreparationStepContentItemSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenLocalizationContentItemSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SlideIdentifier,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImageCenterPointCoordinatesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XOffsetInSlideCoordinateSystem,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.YOffsetInSlideCoordinateSystem,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ZOffsetInSlideCoordinateSystem,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PixelSpacingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemAxisCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MeasurementUnitsCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VitalStainCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedureID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ReasonForRequestedProcedure,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedurePriority,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PatientTransportArrangements,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedureLocation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PlacerOrderNumberOfProcedure,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.FillerOrderNumberOfProcedure,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ConfidentialityCode,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReportingPriority,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ReasonForRequestedProcedureCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NamesOfIntendedRecipientsOfResults,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.IntendedRecipientsOfResultsIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PersonIdentificationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PersonAddress,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PersonTelephoneNumbers,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedureComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ReasonForImagingServiceRequest,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssueDateOfImagingServiceRequest,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.IssueTimeOfImagingServiceRequest,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PlacerOrderNumberOfImagingServiceRequestRetired,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.FillerOrderNumberOfImagingServiceRequestRetired,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.OrderEnteredBy,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.OrderEntererLocation,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.OrderCallbackPhoneNumber,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PlacerOrderNumberOfImagingServiceRequest,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FillerOrderNumberOfImagingServiceRequest,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImagingServiceRequestComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ConfidentialityConstraintOnPatientDataDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.GeneralPurposeScheduledProcedureStepStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GeneralPurposePerformedProcedureStepStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GeneralPurposeScheduledProcedureStepPriority,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcessingApplicationsCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepStartDateAndTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.MultipleCopiesFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PerformedProcessingApplicationsCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HumanPerformerCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepModificationDateAndTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ExpectedCompletionDateAndTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ResultingGeneralPurposePerformedProcedureStepsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedGeneralPurposeScheduledProcedureStepSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledWorkitemCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedWorkitemCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.InputAvailabilityFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InputInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelevantInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedGeneralPurposeScheduledProcedureStepTransactionUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ScheduledStationNameCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledStationClassCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledStationGeographicLocationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedStationNameCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedStationClassCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedStationGeographicLocationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RequestedSubsequentWorkitemCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NonDICOMOutputCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OutputInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledHumanPerformersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ActualHumanPerformersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HumanPerformersOrganization,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HumanPerformersName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.EntranceDoseInmGy,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReferencedImageRealWorldValueMappingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RealWorldValueMappingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PixelValueMappingCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LUTLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RealWorldValueLastValueMapped,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.RealWorldValueLUTData,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RealWorldValueFirstValueMapped,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.RealWorldValueIntercept,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RealWorldValueSlope,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FindingsFlagTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RelationshipType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FindingsSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FindingsGroupUIDTrial,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedFindingsGroupUIDTrial,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.FindingsGroupRecordingDateTrial,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.FindingsGroupRecordingTimeTrial,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.FindingsSourceCategoryCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerifyingOrganization,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DocumentingOrganizationIdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerificationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ObservationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ValueType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ConceptNameCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MeasurementPrecisionDescriptionTrial,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContinuityOfContent,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.UrgencyOrPriorityAlertsTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SequencingIndicatorTrial,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DocumentIdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DocumentAuthorTrial,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.DocumentAuthorIdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerifyingObserverSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObjectBinaryIdentifierTrial,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.VerifyingObserverName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.DocumentingObserverIdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AuthorObserverSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ParticipantSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CustodialOrganizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ParticipationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ParticipationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ObserverType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ProcedureIdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerifyingObserverIdentificationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObjectDirectoryBinaryIdentifierTrial,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.EquivalentCDADocumentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedWaveformChannels,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DateOfDocumentOrVerbalTransactionTrial,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TimeOfDocumentCreationOrVerbalTransactionTrial,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.DateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.Date,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.Time,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PersonName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.UID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReportStatusIDTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TemporalRangeType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedSamplePositions,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ReferencedFrameNumbers,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ReferencedTimeOffsets,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReferencedDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.TextValue,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.ObservationCategoryCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ConceptCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BibliographicCitationTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PurposeOfReferenceCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObservationUIDTrial,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedObservationUIDTrial,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedObservationClassTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedObjectObservationClassTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnnotationGroupNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ObservationDateTrial,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ObservationTimeTrial,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.MeasurementAutomationTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ModifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IdentificationDescriptionTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CoordinatesSetGeometricTypeTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AlgorithmCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlgorithmDescriptionTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PixelCoordinatesSetTrial,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.MeasuredValueSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumericValueQualifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CurrentObserverTrial,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.NumericValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReferencedAccessionSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReportStatusCommentTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ProcedureContextSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerbalSourceTrial,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.AddressTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.TelephoneNumberTrial,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.VerbalSourceIdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PredecessorDocumentsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedRequestSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CurrentRequestedProcedureEvidenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReportDetailSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PertinentOtherEvidenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HL7StructuredDocumentReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObservationSubjectUIDTrial,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ObservationSubjectClassTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ObservationSubjectTypeCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CompletionFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CompletionFlagDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.VerificationFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ArchiveRequested,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PreliminaryFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContentTemplateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IdenticalDocumentsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObservationSubjectContextFlagTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ObserverContextFlagTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ProcedureContextFlagTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelationshipSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelationshipTypeCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LanguageCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.UniformResourceLocatorTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.WaveformAnnotationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TemplateIdentifier,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TemplateVersion,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.TemplateLocalVersion,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.TemplateExtensionFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TemplateExtensionOrganizationUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.TemplateExtensionCreatorUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.RelationshipTypeCodeSequenceModifierTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedContentItemIdentifier,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.HL7InstanceIdentifier,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.HL7DocumentEffectiveTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.HL7DocumentTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RetrieveURI,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.RetrieveLocationUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DocumentTitle,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.EncapsulatedDocument,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.MIMETypeOfEncapsulatedDocument,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ListOfMIMETypes,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProductPackageIdentifier,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SubstanceAdministrationApproval,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApprovalStatusFurtherDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ApprovalStatusDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ProductTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ProductName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProductDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ProductLotIdentifier,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProductExpirationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.SubstanceAdministrationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.SubstanceAdministrationNotes,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SubstanceAdministrationDeviceID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProductParameterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SubstanceAdministrationParameterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LensDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RightLensSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LeftLensSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.UnspecifiedLateralityLensSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CylinderSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrismSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HorizontalPrismPower,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.HorizontalPrismBase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VerticalPrismPower,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VerticalPrismBase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LensSegmentType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OpticalTransmittance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ChannelWidth,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PupilSize,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CornealSize,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.AutorefractionRightEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AutorefractionLeftEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DistancePupillaryDistance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.NearPupillaryDistance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.IntermediatePupillaryDistance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.OtherPupillaryDistance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.KeratometryRightEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.KeratometryLeftEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SteepKeratometricAxisSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RadiusOfCurvature,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.KeratometricPower,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.KeratometricAxis,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FlatKeratometricAxisSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BackgroundColor,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Optotype,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OptotypePresentation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SubjectiveRefractionRightEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SubjectiveRefractionLeftEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AddNearSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AddIntermediateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AddOtherSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AddPower,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ViewingDistance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VisualAcuityTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisualAcuityRightEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisualAcuityLeftEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisualAcuityBothEyesOpenSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ViewingDistanceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VisualAcuityModifiers,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.DecimalVisualAcuity,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.OptotypeDetailedDefinition,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedRefractiveMeasurementsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpherePower,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CylinderPower,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CalibrationImage,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentThickness,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DeviceLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentWidth,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DeviceDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeviceDiameterUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeviceVolume,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.InterMarkerDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentMaterial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentLength,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentDiameter,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DeviceDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfEnergyWindows,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowRangeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowLowerLimit,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowUpperLimit,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ResidualSyringeCounts,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DetectorVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfDetectors,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DetectorInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PhaseVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfPhases,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PhaseInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfFramesInPhase,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PhaseDelay,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PauseBetweenFrames,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PhaseDescription,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RotationVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfRotations,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RotationInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfFramesInRotation,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RRIntervalVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfRRIntervals,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.GatedInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DataInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TimeSlotVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfTimeSlots,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TimeSlotInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TimeSlotTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SliceVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfSlices,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.AngularViewVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TimeSliceVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfTimeSlices,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.StartAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TypeOfDetectorMotion,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TriggerVector,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfTriggersInPhase,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ViewCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ViewModifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RadionuclideCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AdministrationRouteCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CalibrationDataSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PatientOrientationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientOrientationModifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientGantryRelationshipCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SliceProgressionDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SeriesType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Units,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CountsSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReprojectionMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RandomsCorrectionMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AttenuationCorrectionMethod,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DecayCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReconstructionMethod,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DetectorLinesOfResponseUsed,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScatterCorrectionMethod,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AxialAcceptance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.AxialMash,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TransverseMash,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.DetectorElementSize,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CoincidenceWindowWidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SecondaryCountsType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FrameReferenceTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PrimaryPromptsCountsAccumulated,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SecondaryCountsAccumulated,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SliceSensitivityFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DecayFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DoseCalibrationFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ScatterFractionFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeadTimeFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImageIndex,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CountsIncluded,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeadTimeCorrectionFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.HistogramSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HistogramNumberOfBins,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.HistogramFirstBinValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.HistogramLastBinValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.HistogramBinWidth,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.HistogramExplanation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HistogramData,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SegmentationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SegmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SegmentedPropertyCategoryCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SegmentNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SegmentLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SegmentDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SegmentAlgorithmType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SegmentAlgorithmName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SegmentIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSegmentNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RecommendedDisplayGrayscaleValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RecommendedDisplayCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MaximumFractionalValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SegmentedPropertyTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SegmentationFractionalType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeformableRegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceFrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DeformableRegistrationGridSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GridDimensions,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.GridResolution,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VectorGridData,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.PreDeformationMatrixRegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PostDeformationMatrixRegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfSurfaces,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SurfaceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SurfaceNumber,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SurfaceComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.SurfaceProcessing,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SurfaceProcessingRatio,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SurfaceProcessingDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RecommendedPresentationOpacity,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RecommendedPresentationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FiniteVolume,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Manifold,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SurfacePointsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SurfacePointsNormalsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SurfaceMeshPrimitivesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SurfaceNumberOfPoints,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.PointCoordinatesData,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.PointPositionAccuracy,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MeanPointDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MaximumPointDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PointsBoundingBoxCoordinates,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AxisOfRotation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CenterOfRotation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NumberOfVectors,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.VectorDimensionality,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.VectorAccuracy,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.VectorCoordinateData,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.TrianglePointIndexList,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.EdgePointIndexList,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.VertexPointIndexList,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.TriangleStripSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TriangleFanSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LineSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrimitivePointIndexList,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.SurfaceCount,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ReferencedSurfaceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSurfaceNumber,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SegmentSurfaceGenerationAlgorithmIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SegmentSurfaceSourceInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlgorithmFamilyCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlgorithmNameCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlgorithmVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AlgorithmParameters,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.FacetSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SurfaceProcessingAlgorithmIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlgorithmName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.GraphicAnnotationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicLayer,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BoundingBoxAnnotationUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnchorPointAnnotationUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GraphicAnnotationUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.UnformattedTextValue,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.TextObjectSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicObjectSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BoundingBoxTopLeftHandCorner,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BoundingBoxBottomRightHandCorner,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BoundingBoxTextHorizontalJustification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnchorPoint,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AnchorPointVisibility,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GraphicDimensions,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfGraphicPoints,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.GraphicData,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GraphicType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GraphicFilled,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageRotationTrial,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ImageHorizontalFlip,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageRotation,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplayedAreaTopLeftHandCornerTrial,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplayedAreaBottomRightHandCornerTrial,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplayedAreaTopLeftHandCorner,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.DisplayedAreaBottomRightHandCorner,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.DisplayedAreaSelectionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicLayerSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicLayerOrder,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.GraphicLayerRecommendedDisplayGrayscaleValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.GraphicLayerRecommendedDisplayRGBValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.GraphicLayerDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContentLabel,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContentDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PresentationCreationDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.PresentationCreationTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ContentCreatorsName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ContentCreatorsIdentificationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlternateContentDescriptionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PresentationSizeMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PresentationPixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PresentationPixelAspectRatio,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PresentationPixelMagnificationRatio,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ShapeType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MatrixRegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MatrixSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceTransformationMatrixType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RegistrationTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FiducialDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.FiducialIdentifier,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.FiducialIdentifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContourUncertaintyRadius,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.UsedFiducialsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicCoordinatesDataSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FiducialUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.FiducialSetSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FiducialSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicLayerRecommendedDisplayCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BlendingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelativeOpacity,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ReferencedSpatialRegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BlendingPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolLevel,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolCreator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolCreationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolDefinitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolUserIdentificationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolUserGroupName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceHangingProtocolSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfPriorsReferenced,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageSetsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageSetSelectorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageSetSelectorUsageFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SelectorAttribute,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.SelectorValueNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TimeBasedImageSetsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageSetNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageSetSelectorCategory,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RelativeTime,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RelativeTimeUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AbstractPriorValue,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.AbstractPriorCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageSetLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SelectorAttributeVR,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SelectorSequencePointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.SelectorSequencePointerPrivateCreator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SelectorAttributePrivateCreator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SelectorATValue,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.SelectorCSValue,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SelectorISValue,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SelectorLOValue,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SelectorLTValue,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.SelectorPNValue,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.SelectorSHValue,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SelectorSTValue,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SelectorUTValue,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.SelectorDSValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SelectorFDValue,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SelectorFLValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SelectorULValue,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SelectorUSValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SelectorSLValue,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.SelectorSSValue,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.SelectorCodeSequenceValue,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfScreens,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NominalScreenDefinitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfVerticalPixels,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfHorizontalPixels,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplayEnvironmentSpatialPosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ScreenMinimumGrayscaleBitDepth,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ScreenMinimumColorBitDepth,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ApplicationMaximumRepaintTime,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplaySetsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DisplaySetNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplaySetLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DisplaySetPresentationGroup,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplaySetPresentationGroupDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PartialDataDisplayHandling,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SynchronizedScrollingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DisplaySetScrollingGroup,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NavigationIndicatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NavigationDisplaySet,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ReferenceDisplaySets,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageBoxesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageBoxNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageBoxLayoutType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageBoxTileHorizontalDimension,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageBoxTileVerticalDimension,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageBoxScrollDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageBoxSmallScrollType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageBoxSmallScrollAmount,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageBoxLargeScrollType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageBoxLargeScrollAmount,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageBoxOverlapPriority,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CineRelativeToRealTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FilterOperationsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FilterByCategory,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilterByAttributePresence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilterByOperator,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.StructuredDisplayBackgroundCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.EmptyImageBoxCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.StructuredDisplayImageBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StructuredDisplayTextBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedFirstFrameSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageBoxSynchronizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SynchronizedImageBoxList,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TypeOfSynchronization,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BlendingOperationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReformattingOperationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReformattingThickness,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ReformattingInterval,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ReformattingOperationInitialViewDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ThreeDRenderingType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SortingOperationsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SortByCategory,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SortingDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DisplaySetPatientOrientation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VOIType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PseudocolorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShowGrayscaleInverted,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShowImageTrueSizeFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShowGraphicAnnotationFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShowPatientDemographicsFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShowAcquisitionTechniquesFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DisplaySetHorizontalJustification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DisplaySetVerticalJustification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.StorageMediaFileSetID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.StorageMediaFileSetUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.IconImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TopicTitle,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TopicSubject,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.TopicAuthor,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TopicKeyWords,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SOPInstanceStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SOPAuthorizationDateAndTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.SOPAuthorizationComment,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.AuthorizationEquipmentCertificationNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MACIDNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MACCalculationTransferSyntaxUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.MACAlgorithm,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DataElementsSigned,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.DigitalSignatureUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DigitalSignatureDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.CertificateType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CertificateOfSigner,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.Signature,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.CertifiedTimestampType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CertifiedTimestamp,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.DigitalSignaturePurposeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedDigitalSignatureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSOPInstanceMACSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MAC,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.EncryptedAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EncryptedContentTransferSyntaxUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.EncryptedContent,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.ModifiedAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OriginalAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AttributeModificationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ModifyingSystem,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceOfPreviousValues,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReasonForTheAttributeModification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ZonalMap,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfCopies,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PrinterConfigurationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrintPriority,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MediumType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilmDestination,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilmSessionLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MemoryAllocation,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.MaximumMemoryAllocation,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ColorImagePrintingFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CollationFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnnotationFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageOverlayFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PresentationLUTFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageBoxPresentationLUTFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MemoryBitDepth,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PrintingBitDepth,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MediaInstalledSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OtherMediaAvailableSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SupportedImageDisplayFormatsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedFilmBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedStoredPrintSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageDisplayFormat,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.AnnotationDisplayFormatID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilmOrientation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilmSizeID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PrinterResolutionID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DefaultPrinterResolutionID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MagnificationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SmoothingType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DefaultMagnificationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OtherMagnificationTypesAvailable,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DefaultSmoothingType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OtherSmoothingTypesAvailable,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BorderDensity,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EmptyImageDensity,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MinDensity,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MaxDensity,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Trim,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ConfigurationInformation,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ConfigurationInformationDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.MaximumCollatedFilms,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.Illumination,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ReflectedAmbientLight,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PrinterPixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReferencedFilmSessionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedImageBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedBasicAnnotationBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageBoxPosition,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Polarity,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RequestedImageSize,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RequestedDecimateCropBehavior,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RequestedResolutionID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RequestedImageSizeFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DecimateCropResult,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BasicGrayscaleImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BasicColorImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedImageOverlayBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedVOILUTBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnnotationPosition,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TextString,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedOverlayPlaneSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedOverlayPlaneGroups,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayPixelDataSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OverlayMagnificationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlaySmoothingType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayOrImageMagnification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MagnifyToNumberOfColumns,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayForegroundDensity,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayBackgroundDensity,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ThresholdDensity,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedOverlayImageBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PresentationLUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PresentationLUTShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedPresentationLUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrintJobID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ExecutionStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExecutionStatusInfo,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CreationDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.CreationTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.Originator,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.DestinationAE,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.OwnerID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.NumberOfFilms,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedPrintJobSequencePull,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrinterStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PrinterStatusInfo,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PrinterName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PrintQueueID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.QueueStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PrintJobDescriptionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedPrintJobSequenceQueue,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrintManagementCapabilitiesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrinterCharacteristicsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FilmBoxContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageBoxContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnnotationContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageOverlayBoxContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PresentationLUTContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ProposedStudySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OriginalImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LabelUsingInformationExtractedFromInstances,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LabelText,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.LabelStyleSelection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MediaDisposition,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.BarcodeValue,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.BarcodeSymbology,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AllowMediaSplitting,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IncludeNonDICOMObjects,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IncludeDisplayApplication,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PreserveCompositeInstancesAfterMediaCreation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TotalNumberOfPiecesOfMediaCreated,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RequestedMediaApplicationProfile,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedStorageMediaSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FailureAttributes,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.AllowLossyCompression,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RequestPriority,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RTImageLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RTImageName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RTImageDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ReportedValuesOrigin,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RTImagePlane,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.XRayImageReceptorTranslation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.XRayImageReceptorAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTImageOrientation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImagePlanePixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTImagePosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiationMachineName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RadiationMachineSAD,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiationMachineSSD,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTImageSID,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceToReferenceObjectDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FractionNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ExposureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MetersetExposure,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DiaphragmPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FluenceMapSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FluenceDataSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FluenceDataScale,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DoseUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DoseType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DoseComment,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NormalizationPoint,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DoseSummationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GridFrameOffsetVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DoseGridScaling,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTDoseROISequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DoseValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TissueHeterogeneityCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DVHNormalizationPoint,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHNormalizationDoseValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DVHDoseScaling,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHVolumeUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DVHNumberOfBins,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.DVHData,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHReferencedROISequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DVHROIContributionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DVHMinimumDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHMaximumDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHMeanDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.StructureSetLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.StructureSetName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.StructureSetDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.StructureSetDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.StructureSetTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ReferencedFrameOfReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RTReferencedStudySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RTReferencedSeriesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContourImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StructureSetROISequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ROINumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedFrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ROIName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ROIDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ROIDisplayColor,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ROIVolume,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTRelatedROISequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RTROIRelationship,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ROIGenerationAlgorithm,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ROIGenerationDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ROIContourSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContourSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContourGeometricType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContourSlabThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContourOffsetVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfContourPoints,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ContourNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AttachedContours,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ContourData,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTROIObservationsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObservationNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedROINumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ROIObservationLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RTROIIdentificationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ROIObservationDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.RelatedRTROIObservationsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RTROIInterpretedType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ROIInterpreter,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ROIPhysicalPropertiesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ROIPhysicalProperty,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ROIPhysicalPropertyValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ROIElementalCompositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ROIElementalCompositionAtomicNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ROIElementalCompositionAtomicMassFraction,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceRelationshipSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelatedFrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceTransformationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceTransformationMatrix,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceTransformationComment,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MeasuredDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MeasuredDoseDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.MeasuredDoseType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MeasuredDoseValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TreatmentSessionBeamSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TreatmentSessionIonBeamSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CurrentFractionNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TreatmentControlPointDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TreatmentControlPointTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.TreatmentTerminationStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TreatmentTerminationCode,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TreatmentVerificationStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedTreatmentRecordSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecifiedPrimaryMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SpecifiedSecondaryMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveredPrimaryMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveredSecondaryMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SpecifiedTreatmentTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveredTreatmentTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ControlPointDeliverySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonControlPointDeliverySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecifiedMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveredMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MetersetRateSet,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MetersetRateDelivered,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ScanSpotMetersetsDelivered,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DoseRateDelivered,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TreatmentSummaryCalculatedDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CumulativeDoseToDoseReference,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FirstTreatmentDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.MostRecentTreatmentDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.NumberOfFractionsDelivered,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.OverrideSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ParameterSequencePointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.OverrideParameterPointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.ParameterItemIndex,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.MeasuredDoseReferenceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ParameterPointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.OverrideReason,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CorrectedParameterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CorrectionValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CalculatedDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CalculatedDoseReferenceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CalculatedDoseReferenceDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CalculatedDoseReferenceDoseValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.StartMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EndMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReferencedMeasuredDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedMeasuredDoseReferenceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedCalculatedDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedCalculatedDoseReferenceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDeviceLeafPairsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedWedgeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedCompensatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedBlockSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TreatmentSummaryMeasuredDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedSnoutSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedRangeShifterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedLateralSpreadingDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedRangeModulatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedSourceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceSerialNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TreatmentSessionApplicationSetupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ApplicationSetupCheck,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RecordedBrachyAccessoryDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedBrachyAccessoryDeviceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RecordedChannelSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecifiedChannelTotalTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveredChannelTotalTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SpecifiedNumberOfPulses,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.DeliveredNumberOfPulses,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SpecifiedPulseRepetitionInterval,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveredPulseRepetitionInterval,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RecordedSourceApplicatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSourceApplicatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RecordedChannelShieldSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedChannelShieldNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BrachyControlPointDeliveredSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SafePositionExitDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.SafePositionExitTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.SafePositionReturnDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.SafePositionReturnTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.CurrentTreatmentStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TreatmentStatusComment,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.FractionGroupSummarySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedFractionNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.FractionGroupType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BeamStopperPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FractionStatusSummarySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TreatmentDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TreatmentTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.RTPlanLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RTPlanName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RTPlanDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.RTPlanDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.RTPlanTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.TreatmentProtocols,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PlanIntent,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TreatmentSites,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RTPlanGeometry,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PrescriptionDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.DoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DoseReferenceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.DoseReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DoseReferenceStructureType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NominalBeamEnergyUnit,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DoseReferenceDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DoseReferencePointCoordinates,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NominalPriorDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DoseReferenceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ConstraintWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveryWarningDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveryMaximumDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TargetMinimumDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TargetPrescriptionDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TargetMaximumDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TargetUnderdoseVolumeFraction,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OrganAtRiskFullVolumeDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OrganAtRiskLimitDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OrganAtRiskMaximumDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OrganAtRiskOverdoseVolumeFraction,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ToleranceTableSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ToleranceTableNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ToleranceTableLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.GantryAngleTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDeviceAngleTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDeviceToleranceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDevicePositionTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SnoutPositionTolerance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PatientSupportAngleTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopEccentricAngleTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopPitchAngleTolerance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableTopRollAngleTolerance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableTopVerticalPositionTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopLongitudinalPositionTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopLateralPositionTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTPlanRelationship,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FractionGroupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FractionGroupNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.FractionGroupDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NumberOfFractionsPlanned,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfFractionPatternDigitsPerDay,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RepeatFractionCycleLength,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.FractionPattern,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.NumberOfBeams,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BeamDoseSpecificationPoint,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamDosePointDepth,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BeamDosePointEquivalentDepth,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BeamDosePointSSD,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NumberOfBrachyApplicationSetups,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BrachyApplicationSetupDoseSpecificationPoint,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BrachyApplicationSetupDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TreatmentMachineName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PrimaryDosimeterUnit,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SourceAxisDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RTBeamLimitingDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SourceToBeamLimitingDeviceDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IsocenterToBeamLimitingDeviceDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NumberOfLeafJawPairs,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.LeafPositionBoundaries,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BeamName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BeamDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.BeamType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RadiationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.HighDoseTechniqueType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferenceImageNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PlannedVerificationImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImagingDeviceSpecificAcquisitionParameters,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TreatmentDeliveryType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfWedges,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.WedgeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WedgeNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.WedgeType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.WedgeID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.WedgeAngle,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.WedgeFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TotalWedgeTrayWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.WedgeOrientation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IsocenterToWedgeTrayDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SourceToWedgeTrayDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeThinEdgePosition,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BolusID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.BolusDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.NumberOfCompensators,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.MaterialID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TotalCompensatorTrayFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompensatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CompensatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CompensatorID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SourceToCompensatorTrayDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompensatorRows,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CompensatorColumns,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CompensatorPixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompensatorPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompensatorTransmissionData,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompensatorThicknessData,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfBoli,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CompensatorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfBlocks,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TotalBlockTrayFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TotalBlockTrayWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BlockSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BlockTrayID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SourceToBlockTrayDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IsocenterToBlockTrayDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BlockType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AccessoryCode,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BlockDivergence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BlockMountingPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BlockNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BlockName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BlockThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BlockTransmission,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BlockNumberOfPoints,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BlockData,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ApplicatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ApplicatorID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ApplicatorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApplicatorDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CumulativeDoseReferenceCoefficient,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FinalCumulativeMetersetWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfControlPoints,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ControlPointSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ControlPointIndex,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NominalBeamEnergy,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DoseRateSet,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgePositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WedgePosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDevicePositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LeafJawPositions,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GantryAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GantryRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDeviceAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDeviceRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientSupportAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PatientSupportRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TableTopEccentricAxisDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopEccentricAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopEccentricRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TableTopVerticalPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopLongitudinalPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopLateralPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IsocenterPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SurfaceEntryPoint,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceToSurfaceDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CumulativeMetersetWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopPitchAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableTopPitchRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TableTopRollAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableTopRollRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.HeadFixationAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GantryPitchAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GantryPitchRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GantryPitchAngleTolerance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PatientSetupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientSetupNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PatientSetupLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientAdditionalPosition,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FixationDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FixationDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FixationDeviceLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.FixationDeviceDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.FixationDevicePosition,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.FixationDevicePitchAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FixationDeviceRollAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ShieldingDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ShieldingDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShieldingDeviceLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ShieldingDeviceDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ShieldingDevicePosition,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SetupTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SetupTechniqueDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SetupDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SetupDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SetupDeviceLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SetupDeviceDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SetupDeviceParameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SetupReferenceDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.TableTopVerticalSetupDisplacement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopLongitudinalSetupDisplacement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopLateralSetupDisplacement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BrachyTreatmentTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BrachyTreatmentType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TreatmentMachineSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SourceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SourceManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ActiveSourceDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ActiveSourceLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceEncapsulationNominalThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceEncapsulationNominalTransmission,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceIsotopeName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceIsotopeHalfLife,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceStrengthUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferenceAirKermaRate,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceStrength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceStrengthReferenceDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.SourceStrengthReferenceTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ApplicationSetupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ApplicationSetupType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApplicationSetupNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ApplicationSetupName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ApplicationSetupManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TemplateNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TemplateType,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TemplateName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TotalReferenceAirKerma,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceNominalThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceNominalTransmission,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ChannelLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelTotalTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceMovementType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfPulses,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PulseRepetitionInterval,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorWallNominalThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorWallNominalTransmission,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorStepSize,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TransferTubeNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TransferTubeLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelShieldSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelShieldNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ChannelShieldID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ChannelShieldName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ChannelShieldNominalThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelShieldNominalTransmission,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FinalCumulativeTimeWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BrachyControlPointSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ControlPointRelativePosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ControlPoint3DPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CumulativeTimeWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompensatorDivergence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CompensatorMountingPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SourceToCompensatorDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TotalCompensatorTrayWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IsocenterToCompensatorTrayDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CompensatorColumnOffset,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IsocenterToCompensatorDistances,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CompensatorRelativeStoppingPowerRatio,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CompensatorMillingToolDiameter,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IonRangeCompensatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CompensatorDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.RadiationMassNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RadiationAtomicNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RadiationChargeState,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ScanMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VirtualSourceAxisDistances,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SnoutSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SnoutPosition,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SnoutID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.NumberOfRangeShifters,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RangeShifterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RangeShifterNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RangeShifterID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RangeShifterType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RangeShifterDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NumberOfLateralSpreadingDevices,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NumberOfRangeModulators,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BeamCurrentModulationID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PatientSupportType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientSupportID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PatientSupportAccessoryCode,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FixationLightAzimuthalAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FixationLightPolarAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MetersetRate,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RangeShifterSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RangeShifterSetting,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IsocenterToRangeShifterDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RangeShifterWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceSetting,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IsocenterToLateralSpreadingDeviceDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorGatingStartValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorGatingStopValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorGatingStartWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorGatingStopWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IsocenterToRangeModulatorDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ScanSpotTuneID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.NumberOfScanSpotPositions,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ScanSpotPositionMap,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ScanSpotMetersetWeights,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ScanningSpotSize,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NumberOfPaintings,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IonToleranceTableSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonBeamSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonBeamLimitingDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonBlockSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonControlPointSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonWedgeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonWedgePositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSetupImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SetupImageComment,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.MotionSynchronizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ControlPointOrientation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GeneralAccessorySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GeneralAccessoryID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.GeneralAccessoryDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.GeneralAccessoryType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GeneralAccessoryNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedRTPlanSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedBeamSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedBeamNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedReferenceImageNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.StartCumulativeMetersetWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EndCumulativeMetersetWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReferencedBrachyApplicationSetupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedBrachyApplicationSetupNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedSourceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedFractionGroupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedFractionGroupNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedVerificationImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedReferenceImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedDoseReferenceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BrachyReferencedDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedStructureSetSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedPatientSetupNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedDoseSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedToleranceTableNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedBolusSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedWedgeNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedCompensatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedBlockNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedControlPointIndex,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedControlPointSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedStartControlPointIndex,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedStopControlPointIndex,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedRangeShifterNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedLateralSpreadingDeviceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedRangeModulatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ApprovalStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReviewDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ReviewTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ReviewerName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.Arbitrary,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.TextComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ResultsID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ResultsIDIssuer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedInterpretationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReportProductionStatusTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InterpretationRecordedDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.InterpretationRecordedTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.InterpretationRecorder,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ReferenceToRecordedSound,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InterpretationTranscriptionDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.InterpretationTranscriptionTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.InterpretationTranscriber,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.InterpretationText,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.InterpretationAuthor,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.InterpretationApproverSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.InterpretationApprovalDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.InterpretationApprovalTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PhysicianApprovingInterpretation,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.InterpretationDiagnosisDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.InterpretationDiagnosisCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ResultsDistributionListSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DistributionName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.DistributionAddress,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InterpretationID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.InterpretationIDIssuer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InterpretationTypeID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InterpretationStatusID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Impressions,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ResultsComments,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.MACParametersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CurveDimensions,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfPoints,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TypeOfData,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CurveDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AxisUnits,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.AxisLabels,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DataValueRepresentation,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MinimumCoordinateValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MaximumCoordinateValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CurveRange,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CurveDataDescriptor,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CoordinateStartValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CoordinateStepValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CurveActivationLayer,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AudioType,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.AudioSampleFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfChannels,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfSamples,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SampleRate,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TotalTime,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.AudioSampleData,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.AudioComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.CurveLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CurveReferencedOverlaySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CurveReferencedOverlayGroup,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CurveData,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.SharedFunctionalGroupsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerFrameFunctionalGroupsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WaveformSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelMinimumValue,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.ChannelMaximumValue,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.WaveformBitsAllocated,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.WaveformSampleInterpretation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.WaveformPaddingValue,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.WaveformData,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.FirstOrderPhaseCorrectionAngle,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.SpectroscopyData,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.OverlayRows,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayColumns,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayPlanes,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfFramesInOverlay,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.OverlayDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OverlayType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlaySubtype,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OverlayOrigin,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ImageFrameOrigin,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PlaneOrigin,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayCompressionCode,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.OverlayCompressionOriginator,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.OverlayCompressionLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.OverlayCompressionDescription,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayCompressionStepPointers,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.OverlayRepeatInterval,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayBitsGrouped,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayBitsAllocated,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayBitPosition,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayFormat,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.OverlayLocation,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayCodeLabel,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayNumberOfTables,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayCodeTableLocation,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.OverlayBitsForCodeWord,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayActivationLayer,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayDescriptorGray,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayDescriptorRed,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayDescriptorGreen,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayDescriptorBlue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayGray,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayRed,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayGreen,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayBlue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ROIArea,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ROIMean,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ROIStandardDeviation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OverlayLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OverlayData,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.OverlayComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.PixelData,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.CoefficientsSDVN,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.CoefficientsSDHN,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.CoefficientsSDDN,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.VariablePixelData,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.VariableNextDataGroup,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.VariableCoefficientsSDVN,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.VariableCoefficientsSDHN,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.VariableCoefficientsSDDN,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.DigitalSignaturesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DataSetTrailingPadding,ValueRepresentation.OB);
	}

	protected void createInformationEntityByTag() {

		informationEntityByTag = new HashMap(100);

		informationEntityByTag.put(TagFromName.ReferencedFrameNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedSegmentNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedSeriesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PrimaryAnatomicStructureSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AnatomicRegionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AnatomicRegionModifierSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PrimaryAnatomicStructureModifierSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RequestedProcedureID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.IssuerOfAccessionNumberSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.RequestedProcedureDescription,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.RequestedProcedureCodeSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ReasonForRequestedProcedure,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ReasonForRequestedProcedureCodeSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ScheduledProcedureStepID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ScheduledProcedureStepDescription,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ScheduledProtocolCodeSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PixelSpacing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelSpacingCalibrationType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelSpacingCalibrationDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterShape,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterLeftVerticalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterRightVerticalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterUpperHorizontalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterLowerHorizontalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CenterOfCircularShutter,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiusOfCircularShutter,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VerticesOfPolygonalShutter,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterPresentationValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterPresentationColorCIELabValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentLabel,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentCreatorsName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentCreatorsIdentificationCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Rows,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Columns,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BitsStored,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LossyImageCompression,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LossyImageCompressionRatio,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LossyImageCompressionMethod,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PerformedProcedureStepID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PerformedProcedureStepStartDate,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PerformedProcedureStepStartTime,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PerformedProcedureStepDescription,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PerformedProtocolCodeSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.CommentsOnPerformedProcedureStep,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PatientName,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientID,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientBirthDate,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientSex,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ReferencedPatientSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientBirthTime,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.OtherPatientID,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.OtherPatientIDSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.OtherPatientName,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.EthnicGroup,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientComments,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientSpeciesDescription,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientSpeciesCodeSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientBreedDescription,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientBreedCodeSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.BreedRegistrationSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ResponsiblePerson,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ResponsiblePersonRole,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ResponsibleOrganization,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientIdentityRemoved,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.DeidentificationMethod,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.DeidentificationMethodCodeSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialSponsorName,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialProtocolID,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialProtocolName,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialSiteID,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialSiteName,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialSubjectID,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialSubjectReadingID,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.StudyDate,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.StudyTime,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ReferringPhysicianName,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ReferringPhysicianIdentificationSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.StudyID,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.StudyDescription,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PhysicianOfRecord,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PhysicianOfRecordIdentificationSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PhysicianReadingStudy,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PhysicianReadingStudyIdentificationSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ProcedureCodeSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.AdmittingDiagnosesDescription,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.AdmittingDiagnosesCodeSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PatientAge,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PatientSize,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PatientWeight,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.Occupation,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.AdditionalPatientHistory,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.AdmissionID,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.IssuerOfAdmissionID,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.IssuerOfAdmissionIDSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ServiceEpisodeID,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.IssuerOfServiceEpisodeIDSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ServiceEpisodeDescription,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PatientSexNeutered,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ClinicalTrialTimePointID,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ClinicalTrialTimePointDescription,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.Modality,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SeriesNumber,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.Laterality,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SeriesDate,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SeriesTime,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PerformingPhysicianName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PerformingPhysicianIdentificationSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ProtocolName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SeriesDescription,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.OperatorIdentificationSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ReferencedPerformedProcedureStepSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.RelatedSeriesSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.BodyPartExamined,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SmallestPixelValueInSeries,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.LargestPixelValueInSeries,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.RequestAttributesSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ClinicalTrialCoordinatingCenterName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ClinicalTrialSeriesID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ClinicalTrialSeriesDescription,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.FrameOfReferenceUID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PositionReferenceIndicator,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.Manufacturer,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.StationName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.InstitutionalDepartmentName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ManufacturerModelName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DeviceSerialNumber,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SoftwareVersion,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.GantryID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SpatialResolution,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DateOfLastCalibration,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.TimeOfLastCalibration,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PixelPaddingValue,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PatientOrientation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentDate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionDate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionDateTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DerivationDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DerivationCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SourceImageSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedInstanceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagesInAcquisition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageComments,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.QualityControlImage,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BurnedInAnnotation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IconImageSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PresentationLUTShape,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IrradiationEventUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageOrientationPatient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagePositionPatient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SliceThickness,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SliceLocation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SamplesPerPixel,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PhotometricInterpretation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BitsAllocated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.HighBit,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelRepresentation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PlanarConfiguration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelAspectRatio,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SmallestImagePixelValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LargestImagePixelValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RedPaletteColorLookupTableDescriptor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GreenPaletteColorLookupTableDescriptor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BluePaletteColorLookupTableDescriptor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RedPaletteColorLookupTableData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GreenPaletteColorLookupTableData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BluePaletteColorLookupTableData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ICCProfile,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelDataProviderURL,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelPaddingRangeLimit,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusAgent,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusAgentSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusRoute,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusAdministrationRouteSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusVolume,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusStartTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusStopTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusTotalDose,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastFlowRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastFlowDuration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusIngredient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusIngredientConcentration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PreferredPlaybackSequencing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameTimeVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StartTrim,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StopTrim,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RecommendedDisplayFrameRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CineRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameDelay,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageTriggerDelay,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EffectiveDuration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ActualFrameDuration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MultiplexedAudioChannelsDescriptionCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfFrames,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameIncrementPointer,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ConcatenationFrameOffsetNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RepresentativeFrameNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InConcatenationNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DimensionOrganizationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DimensionIndexSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CardiacSynchronizationTechnique,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CardiacSignalSource,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CardiacRRIntervalSpecified,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CardiacBeatRejectionTechnique,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LowRRValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.HighRRValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IntervalsAcquired,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IntervalsRejected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RespiratoryMotionCompensationTechnique,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RespiratorySignalSource,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RespiratoryTriggerDelayThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RespiratoryTriggerType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PaletteColorLookupTableUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentedRedPaletteColorLookupTableData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentedGreenPaletteColorLookupTableData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentedBluePaletteColorLookupTableData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageToEquipmentMappingMatrix,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EquipmentCoordinateSystemIdentification,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CollimatorGridName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PlateType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PhosphorType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.KVP,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PlateID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DistanceSourceToDetector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DistanceSourceToPatient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRayTubeCurrent,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Exposure,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureInuAs,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagerPixelSpacing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GeneratorPower,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionDeviceProcessingDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionDeviceProcessingCode,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CassetteOrientation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CassetteSize,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposuresOnPlate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RelativeXRayExposure,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Sensitivity,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RescaleIntercept,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RescaleSlope,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScanOptions,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DataCollectionDiameter,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DataCollectionCenterPatient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReconstructionTargetCenterPatient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableHeight,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RotationDirection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RevolutionTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SingleCollimationWidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TotalCollimationWidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableSpeed,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableFeedPerRotation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SpiralPitchFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureModulationType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EstimatedDoseSaving,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CTDIvol,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CTDIPhantomTypeCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CalciumScoringMassFactorPatient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CalciumScoringMassFactorDevice,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CTAdditionalXRaySourceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScanningSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SequenceVariant,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MRAcquisitionType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RepetitionTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EchoTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EchoTrainLength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InversionTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TriggerTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SequenceName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AngioFlag,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfAverages,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagingFrequency,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagedNucleus,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EchoNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MagneticFieldStrength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SpacingBetweenSlices,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfPhaseEncodingSteps,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PercentSampling,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PercentPhaseFieldOfView,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelBandwidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NominalInterval,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CardiacNumberOfImages,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TriggerWindow,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReceiveCoilName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransmitCoilName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionMatrix,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InPlanePhaseEncodingDirection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FlipAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SAR,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VariableFlipAngleFlag,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.dBdt,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TemporalPositionIdentifier,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfTemporalPositions,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TemporalResolution,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EnergyWindowVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfEnergyWindows,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfDetectors,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PhaseVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfPhases,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RotationVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfRotations,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RRIntervalVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimeSlotVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SliceVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AngularViewVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimeSliceVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CountsAccumulated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTraverse,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CountRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ProcessingFunction,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.WholeBodyTechnique,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScanVelocity,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScanLength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedImageRealWorldValueMappingSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EnergyWindowInformationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorInformationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RotationInformationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GatedInformationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PhaseInformationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SliceProgressionDirection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SequenceOfUltrasoundRegions,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfStages,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfViewsInStage,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RWaveTimeVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.UltrasoundColorDataPresent,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StageName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StageCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StageNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ViewName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ViewNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfEventTimers,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EventElapsedTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EventTimerName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ViewCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IVUSAcquisition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IVUSPullbackRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IVUSGatedRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IVUSPullbackStartFrameNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IVUSPullbackStopFrameNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LesionNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OutputPower,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransducerData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransducerType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FocusDepth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MechanicalIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BoneThermalIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CranialThermalIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SoftTissueThermalIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SoftTissueFocusThermalIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SoftTissueSurfaceThermalIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DepthOfScanField,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlaySubtype,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SecondaryCaptureDeviceID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SecondaryCaptureDeviceManufacturer,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SecondaryCaptureDeviceManufacturerModelName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SecondaryCaptureDeviceSoftwareVersion,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.VideoImageFormatAcquired,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DigitalImageFormatAcquired,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DateOfSecondaryCapture,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimeOfSecondaryCapture,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NominalScannedPixelSpacing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Illumination,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReflectedAmbientLight,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RescaleType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DigitizingDeviceTransportDirection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RotationOfScannedFilm,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PageNumberVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameLabelVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FramePrimaryAngleVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameSecondaryAngleVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SliceLocationVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DisplayWindowLabelVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayRows,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayColumns,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayOrigin,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayBitsAllocated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayBitPosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayLabel,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ROIArea,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ROIMean,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ROIStandardDeviation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfFramesInOverlay,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageFrameOrigin,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ModalityLUTSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VOILUTSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.WindowCenter,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.WindowWidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.WindowCenterWidthExplanation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VOILUTFunction,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MACParametersSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DigitalSignaturesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SpecificCharacterSet,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InstanceCreationDate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InstanceCreationTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InstanceCreatorUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RelatedGeneralSOPClassUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OriginalSpecializedSOPClassUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CodingSchemeIdentificationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimezoneOffsetFromUTC,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContributingEquipmentSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SOPInstanceStatus,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SOPAuthorizationDateAndTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SOPAuthorizationComment,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AuthorizationEquipmentCertificationNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EncryptedAttributesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OriginalAttributesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.HL7StructuredDocumentReferenceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StudiesContainingOtherReferencedInstancesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentationType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentationFractionalType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MaximumFractionalValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SharedFunctionalGroupsSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PerFrameFunctionalGroupsSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Units,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.CountsSource,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SeriesType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ReprojectionMethod,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.NumberOfTimeSlices,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.RandomsCorrectionMethod,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AttenuationCorrectionMethod,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ScatterCorrectionMethod,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DecayCorrection,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ReconstructionMethod,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DetectorLinesOfResponseUsed,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AcquisitionStartCondition,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AcquisitionStartConditionData,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AcquisitionTerminationConditionData,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.GantryDetectorSlew,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.CollimatorType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AxialAcceptance,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AxialMash,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.TransverseMash,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DetectorElementSize,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.CoincidenceWindowWidth,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.EnergyWindowRangeSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SecondaryCountsType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.FrameReferenceTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PrimaryPromptsCountsAccumulated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SecondaryCountsAccumulated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SliceSensitivityFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DecayFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoseCalibrationFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScatterFractionFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DeadTimeFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StartDensityThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StartRelativeDensityDifferenceThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StartCardiacTriggerCountThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StartRespiratoryTriggerCountThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TerminationCountsThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TerminationDensityThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TerminationRelativeDensityThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TerminationTimeThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TerminationCardiacTriggerCountThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TerminationRespiratoryTriggerCountThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorGeometry,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransverseDetectorSeparation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AxialDetectorDimension,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableMotion,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimeOfFlightInformationUsed,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionDuration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DecayCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AttenuationCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScatterCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DeadTimeCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GantryMotionCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PatientMotionCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CountLossNormalizationCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RandomsCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NonUniformRadialSamplingCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SensitivityCalibrated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorNormalizationCorrection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AttenuationCorrectionSource,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AttenuationCorrectionTemporalRelationship,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DecayCorrectionDateTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedRawDataSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedWaveformSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedImageEvidenceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SourceImageEvidenceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentQualification,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelIntensityRelationship,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelIntensityRelationshipSign,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImageLabel,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImageName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImageDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReportedValuesOrigin,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImagePlane,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRayImageReceptorAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImageOrientation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagePlanePixelSpacing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImagePosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiationMachineName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PrimaryDosimeterUnit,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiationMachineSAD,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiationMachineSSD,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImageSID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SourceToReferenceObjectDistance,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedRTPlanSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedBeamNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedFractionGroupNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FractionNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StartCumulativeMetersetWeight,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EndCumulativeMetersetWeight,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FluenceMapSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GantryAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GantryPitchAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BeamLimitingDeviceAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PatientSupportAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopEccentricAxisDistance,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopEccentricAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopPitchAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopRollAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopVerticalPosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopLongitudinalPosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopLateralPosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IsocenterPosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoseUnits,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoseType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoseComment,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NormalizationPoint,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoseSummationType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridFrameOffsetVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoseGridScaling,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TissueHeterogeneityCorrection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedStructureSetSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DVHNormalizationPoint,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DVHNormalizationDoseValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DVHSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTDoseROISequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionContextSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionContextDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SpecimenAccessionNumber,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.SpecimenSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.XRayTubeCurrentInuA,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureTimeInuS,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageAndFluoroscopyAreaDoseProduct,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BodyPartThickness,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EntranceDose,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EntranceDoseInmGy,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposedArea,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DistanceSourceToEntrance,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CommentsOnRadiationDose,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRayOutput,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.HalfValueLayer,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OrganDose,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OrganExposed,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AnodeTargetMaterial,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FilterMaterial,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FilterThicknessMaximum,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FilterThicknessMinimum,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RectificationType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureControlMode,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureControlModeDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureStatus,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PhototimerSetting,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GeneratorID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Grid,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridAbsorbingMaterial,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridSpacingMaterial,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridThickness,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridPitch,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridAspectRatio,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridPeriod,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridFocalDistance,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PresentationIntentType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ImageLaterality,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CalibrationImage,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorConfiguration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorMode,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DateOfLastDetectorCalibration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimeOfLastDetectorCalibration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposuresOnDetectorSinceLastCalibration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposuresOnDetectorSinceManufactured,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorTimeSinceLastExposure,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorBinning,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorManufacturerName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorManufacturerModelName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorConditionsNominalFlag,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorTemperature,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorElementPhysicalSize,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorElementSpacing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorActiveShape,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorActiveDimensions,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorActiveOrigin,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorActiveTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorActivationOffsetFromExposure,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FieldOfViewOrigin,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FieldOfViewRotation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FieldOfViewHorizontalFlip,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CassetteID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ProjectionEponymousNameCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ViewModifierCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PatientOrientationModifierCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EstimatedRadiographicMagnificationFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerPrimaryAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerSecondaryAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorPrimaryAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorSecondaryAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ColumnAngulation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CompressionForce,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BreastImplantPresent,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PartialView,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PartialViewDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PartialViewCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.HistogramSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageCenterPointCoordinatesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelSpacingSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SamplesPerPixelUsed,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionDeviceTypeCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IlluminationTypeCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LightPathFilterTypeStackCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LightPathFilterPassThroughWavelength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LightPathFilterPassBand,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagePathFilterTypeStackCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagePathFilterPassThroughWavelength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagePathFilterPassBand,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LensesCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ChannelDescriptionCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RefractiveStateSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EmmetropicMagnification,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IntraOcularPressure,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.HorizontalFieldOfView,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PupilDilated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MydriaticAgentCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DegreeOfDilation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PatientEyeMovementCommanded,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PatientEyeMovementCommandedCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RelativeImagePositionCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StereoPairsSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AxialLengthOfEye,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IlluminationWaveLength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IlluminationPower,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IlluminationBandwidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DepthSpatialResolution,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MaximumDepthDistortion,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AlongScanSpatialResolution,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MaximumAlongScanDistortion,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcrossScanSpatialResolution,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MaximumAcrossScanDistortion,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OphthalmicFrameLocationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SynchronizationFrameOfReferenceUID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SynchronizationTrigger,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SynchronizationChannel,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AcquisitionTimeSynchronized,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.TimeSource,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.TimeDistributionProtocol,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.NTPSourceAddress,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.WaveformSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.WaveformAnnotationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CompletionFlag,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CompletionFlagDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VerificationFlag,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VerifyingObserverSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AuthorObserverSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ParticipantSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CustodialOrganizationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PredecessorDocumentsSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IdenticalDocumentsSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedRequestSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PerformedProcedureCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CurrentRequestedProcedureEvidenceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PertinentOtherEvidenceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterOverlayGroup,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DisplayedAreaSelectionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GraphicAnnotationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageRotation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageHorizontalFlip,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GraphicLayerSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PresentationLUTSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayActivationLayer,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SoftcopyVOILUTSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PresentationCreationDate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PresentationCreationTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MaskSubtractionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RecommendedViewingMode,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BlendingSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RelativeOpacity,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedSpatialRegistrationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelPresentation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VolumetricProperties,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VolumeBasedCalculationTechnique,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ComplexImageComponent,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionContrast,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedPresentationStateSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ResonantNucleus,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.KSpaceFiltering,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ApplicableSafetyStandardAgency,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ApplicableSafetyStandardDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PulseSequenceName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EchoPulseSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MultipleSpinEcho,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MultiplanarExcitation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PhaseContrast,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimeOfFlightContrast,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SteadyStatePulseSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EchoPlanarPulseSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SaturationRecovery,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SpectrallySelectedSuppression,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OversamplingPhase,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GeometryOfKSpaceTraversal,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RectilinearPhaseEncodeReordering,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentedKSpaceTraversal,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CoverageOfKSpace,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfKSpaceTrajectories,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameNumbersOfInterest,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameOfInterestDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameOfInterestType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DeviceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InterventionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RWavePointer,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameDimensionPointer,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiationSetting,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AveragePulseWidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiationMode,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TypeOfFilters,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IntensifierSize,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CollimatorShape,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CollimatorLeftVerticalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CollimatorRightVerticalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CollimatorUpperHorizontalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CollimatorLowerHorizontalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CenterOfCircularCollimator,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiusOfCircularCollimator,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VerticesOfPolygonalCollimator,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableVerticalIncrement,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableLongitudinalIncrement,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableLateralIncrement,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerMotion,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerPrimaryAngleIncrement,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerSecondaryAngleIncrement,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TomoLayerHeight,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TomoAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TomoTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TomoType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TomoClass,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfTomosynthesisSourceImages,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PlaneIdentification,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionProtocolName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionProtocolDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExaminedBodyThickness,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedOtherPlaneSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRayTubeCurrentInmA,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureTimeInms,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureInmAs,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRayReceptorType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DistanceReceptorPlaneToDetectorHousing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CArmPositionerTabletopRelationship,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquiredImageAreaDoseProduct,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IntensifierActiveShape,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IntensifierActiveDimensions,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PhysicalDetectorSize,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionOfIsocenterProjection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameDisplaySequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContributingSourcesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRay3DAcquisitionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRay3DReconstructionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OperatorName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InterpretationAuthor,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.OtherStudyNumbers,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.NumberOfStudyRelatedSeries,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.NumberOfStudyRelatedInstances,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.NumberOfPatientRelatedSeries,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.NumberOfPatientRelatedInstances,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.InstitutionCodeSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.InConcatenationTotalNumber,InformationEntity.CONCATENATION);
		informationEntityByTag.put(TagFromName.AccessionNumber,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.SOPClassesInStudy,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.NumberOfSeriesRelatedInstances,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.NumberOfPatientRelatedStudies,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ConcatenationUID,InformationEntity.CONCATENATION);
		informationEntityByTag.put(TagFromName.SeriesInstanceUID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.TransferSyntaxUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InstanceNumber,InformationEntity.CONCATENATION);
		informationEntityByTag.put(TagFromName.StudyInstanceUID,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.InstitutionAddress,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SOPClassUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SourceApplicationEntityTitle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SOPInstanceUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ModalitiesInStudy,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ViewPosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InstitutionName,InformationEntity.SERIES);
	}

	protected void createTagByName() {

		tagByName = new HashMap(100);

		tagByName.put("CommandGroupLength",TagFromName.CommandGroupLength);
		tagByName.put("CommandLengthToEnd",TagFromName.CommandLengthToEnd);
		tagByName.put("AffectedSOPClassUID",TagFromName.AffectedSOPClassUID);
		tagByName.put("RequestedSOPClassUID",TagFromName.RequestedSOPClassUID);
		tagByName.put("CommandRecognitionCode",TagFromName.CommandRecognitionCode);
		tagByName.put("CommandField",TagFromName.CommandField);
		tagByName.put("MessageID",TagFromName.MessageID);
		tagByName.put("MessageIDBeingRespondedTo",TagFromName.MessageIDBeingRespondedTo);
		tagByName.put("Initiator",TagFromName.Initiator);
		tagByName.put("Receiver",TagFromName.Receiver);
		tagByName.put("FindLocation",TagFromName.FindLocation);
		tagByName.put("MoveDestination",TagFromName.MoveDestination);
		tagByName.put("Priority",TagFromName.Priority);
		tagByName.put("DataSetType",TagFromName.DataSetType);
		tagByName.put("NumberOfMatches",TagFromName.NumberOfMatches);
		tagByName.put("ResponseSequenceNumber",TagFromName.ResponseSequenceNumber);
		tagByName.put("Status",TagFromName.Status);
		tagByName.put("OffendingElement",TagFromName.OffendingElement);
		tagByName.put("ErrorComment",TagFromName.ErrorComment);
		tagByName.put("ErrorID",TagFromName.ErrorID);
		tagByName.put("AffectedSOPInstanceUID",TagFromName.AffectedSOPInstanceUID);
		tagByName.put("RequestedSOPInstanceUID",TagFromName.RequestedSOPInstanceUID);
		tagByName.put("EventTypeID",TagFromName.EventTypeID);
		tagByName.put("AttributeIdentifierList",TagFromName.AttributeIdentifierList);
		tagByName.put("ActionTypeID",TagFromName.ActionTypeID);
		tagByName.put("NumberOfRemainingSuboperations",TagFromName.NumberOfRemainingSuboperations);
		tagByName.put("NumberOfCompletedSuboperations",TagFromName.NumberOfCompletedSuboperations);
		tagByName.put("NumberOfFailedSuboperations",TagFromName.NumberOfFailedSuboperations);
		tagByName.put("NumberOfWarningSuboperations",TagFromName.NumberOfWarningSuboperations);
		tagByName.put("MoveOriginatorApplicationEntityTitle",TagFromName.MoveOriginatorApplicationEntityTitle);
		tagByName.put("MoveOriginatorMessageID",TagFromName.MoveOriginatorMessageID);
		tagByName.put("DialogReceiver",TagFromName.DialogReceiver);
		tagByName.put("TerminalType",TagFromName.TerminalType);
		tagByName.put("MessageSetID",TagFromName.MessageSetID);
		tagByName.put("EndMessageSet",TagFromName.EndMessageSet);
		tagByName.put("DisplayFormat",TagFromName.DisplayFormat);
		tagByName.put("PagePositionID",TagFromName.PagePositionID);
		tagByName.put("TextFormatID",TagFromName.TextFormatID);
		tagByName.put("NormalReverse",TagFromName.NormalReverse);
		tagByName.put("AddGrayScale",TagFromName.AddGrayScale);
		tagByName.put("Borders",TagFromName.Borders);
		tagByName.put("Copies",TagFromName.Copies);
		tagByName.put("OldMagnificationType",TagFromName.OldMagnificationType);
		tagByName.put("Erase",TagFromName.Erase);
		tagByName.put("Print",TagFromName.Print);
		tagByName.put("Overlays",TagFromName.Overlays);
		tagByName.put("FileMetaInformationGroupLength",TagFromName.FileMetaInformationGroupLength);
		tagByName.put("FileMetaInformationVersion",TagFromName.FileMetaInformationVersion);
		tagByName.put("MediaStorageSOPClassUID",TagFromName.MediaStorageSOPClassUID);
		tagByName.put("MediaStorageSOPInstanceUID",TagFromName.MediaStorageSOPInstanceUID);
		tagByName.put("TransferSyntaxUID",TagFromName.TransferSyntaxUID);
		tagByName.put("ImplementationClassUID",TagFromName.ImplementationClassUID);
		tagByName.put("ImplementationVersionName",TagFromName.ImplementationVersionName);
		tagByName.put("SourceApplicationEntityTitle",TagFromName.SourceApplicationEntityTitle);
		tagByName.put("PrivateInformationCreatorUID",TagFromName.PrivateInformationCreatorUID);
		tagByName.put("PrivateInformation",TagFromName.PrivateInformation);
		tagByName.put("FileSetID",TagFromName.FileSetID);
		tagByName.put("FileSetDescriptorFileID",TagFromName.FileSetDescriptorFileID);
		tagByName.put("FileSetCharacterSet",TagFromName.FileSetCharacterSet);
		tagByName.put("RootDirectoryFirstRecord",TagFromName.RootDirectoryFirstRecord);
		tagByName.put("RootDirectoryLastRecord",TagFromName.RootDirectoryLastRecord);
		tagByName.put("FileSetConsistencyFlag",TagFromName.FileSetConsistencyFlag);
		tagByName.put("DirectoryRecordSequence",TagFromName.DirectoryRecordSequence);
		tagByName.put("NextDirectoryRecordOffset",TagFromName.NextDirectoryRecordOffset);
		tagByName.put("RecordInUseFlag",TagFromName.RecordInUseFlag);
		tagByName.put("LowerLevelDirectoryOffset",TagFromName.LowerLevelDirectoryOffset);
		tagByName.put("DirectoryRecordType",TagFromName.DirectoryRecordType);
		tagByName.put("PrivateRecordUID",TagFromName.PrivateRecordUID);
		tagByName.put("ReferencedFileID",TagFromName.ReferencedFileID);
		tagByName.put("MRDRDirectoryRecordOffset",TagFromName.MRDRDirectoryRecordOffset);
		tagByName.put("ReferencedSOPClassUIDInFile",TagFromName.ReferencedSOPClassUIDInFile);
		tagByName.put("ReferencedSOPInstanceUIDInFile",TagFromName.ReferencedSOPInstanceUIDInFile);
		tagByName.put("ReferencedTransferSyntaxUIDInFile",TagFromName.ReferencedTransferSyntaxUIDInFile);
		tagByName.put("ReferencedRelatedGeneralSOPClassUIDInFile",TagFromName.ReferencedRelatedGeneralSOPClassUIDInFile);
		tagByName.put("NumberOfReferences",TagFromName.NumberOfReferences);
		tagByName.put("LengthToEnd",TagFromName.LengthToEnd);
		tagByName.put("SpecificCharacterSet",TagFromName.SpecificCharacterSet);
		tagByName.put("LanguageCodeSequence",TagFromName.LanguageCodeSequence);
		tagByName.put("ImageType",TagFromName.ImageType);
		tagByName.put("RecognitionCode",TagFromName.RecognitionCode);
		tagByName.put("InstanceCreationDate",TagFromName.InstanceCreationDate);
		tagByName.put("InstanceCreationTime",TagFromName.InstanceCreationTime);
		tagByName.put("InstanceCreatorUID",TagFromName.InstanceCreatorUID);
		tagByName.put("SOPClassUID",TagFromName.SOPClassUID);
		tagByName.put("SOPInstanceUID",TagFromName.SOPInstanceUID);
		tagByName.put("RelatedGeneralSOPClassUID",TagFromName.RelatedGeneralSOPClassUID);
		tagByName.put("OriginalSpecializedSOPClassUID",TagFromName.OriginalSpecializedSOPClassUID);
		tagByName.put("StudyDate",TagFromName.StudyDate);
		tagByName.put("SeriesDate",TagFromName.SeriesDate);
		tagByName.put("AcquisitionDate",TagFromName.AcquisitionDate);
		tagByName.put("ContentDate",TagFromName.ContentDate);
		tagByName.put("OverlayDate",TagFromName.OverlayDate);
		tagByName.put("CurveDate",TagFromName.CurveDate);
		tagByName.put("AcquisitionDateTime",TagFromName.AcquisitionDateTime);
		tagByName.put("StudyTime",TagFromName.StudyTime);
		tagByName.put("SeriesTime",TagFromName.SeriesTime);
		tagByName.put("AcquisitionTime",TagFromName.AcquisitionTime);
		tagByName.put("ContentTime",TagFromName.ContentTime);
		tagByName.put("OverlayTime",TagFromName.OverlayTime);
		tagByName.put("CurveTime",TagFromName.CurveTime);
		tagByName.put("OldDataSetType",TagFromName.OldDataSetType);
		tagByName.put("OldDataSetSubtype",TagFromName.OldDataSetSubtype);
		tagByName.put("NuclearMedicineSeriesTypeRetired",TagFromName.NuclearMedicineSeriesTypeRetired);
		tagByName.put("AccessionNumber",TagFromName.AccessionNumber);
		tagByName.put("IssuerOfAccessionNumberSequence",TagFromName.IssuerOfAccessionNumberSequence);
		tagByName.put("QueryRetrieveLevel",TagFromName.QueryRetrieveLevel);
		tagByName.put("RetrieveAETitle",TagFromName.RetrieveAETitle);
		tagByName.put("InstanceAvailability",TagFromName.InstanceAvailability);
		tagByName.put("FailedSOPInstanceUIDList",TagFromName.FailedSOPInstanceUIDList);
		tagByName.put("Modality",TagFromName.Modality);
		tagByName.put("ModalitiesInStudy",TagFromName.ModalitiesInStudy);
		tagByName.put("SOPClassesInStudy",TagFromName.SOPClassesInStudy);
		tagByName.put("ConversionType",TagFromName.ConversionType);
		tagByName.put("PresentationIntentType",TagFromName.PresentationIntentType);
		tagByName.put("Manufacturer",TagFromName.Manufacturer);
		tagByName.put("InstitutionName",TagFromName.InstitutionName);
		tagByName.put("InstitutionAddress",TagFromName.InstitutionAddress);
		tagByName.put("InstitutionCodeSequence",TagFromName.InstitutionCodeSequence);
		tagByName.put("ReferringPhysicianName",TagFromName.ReferringPhysicianName);
		tagByName.put("ReferringPhysicianAddress",TagFromName.ReferringPhysicianAddress);
		tagByName.put("ReferringPhysicianTelephoneNumber",TagFromName.ReferringPhysicianTelephoneNumber);
		tagByName.put("ReferringPhysicianIdentificationSequence",TagFromName.ReferringPhysicianIdentificationSequence);
		tagByName.put("CodeValue",TagFromName.CodeValue);
		tagByName.put("CodingSchemeDesignator",TagFromName.CodingSchemeDesignator);
		tagByName.put("CodingSchemeVersion",TagFromName.CodingSchemeVersion);
		tagByName.put("CodeMeaning",TagFromName.CodeMeaning);
		tagByName.put("MappingResource",TagFromName.MappingResource);
		tagByName.put("ContextGroupVersion",TagFromName.ContextGroupVersion);
		tagByName.put("ContextGroupLocalVersion",TagFromName.ContextGroupLocalVersion);
		tagByName.put("ContextGroupExtensionFlag",TagFromName.ContextGroupExtensionFlag);
		tagByName.put("CodingSchemeUID",TagFromName.CodingSchemeUID);
		tagByName.put("ContextGroupExtensionCreatorUID",TagFromName.ContextGroupExtensionCreatorUID);
		tagByName.put("ContextIdentifier",TagFromName.ContextIdentifier);
		tagByName.put("CodingSchemeIdentificationSequence",TagFromName.CodingSchemeIdentificationSequence);
		tagByName.put("CodingSchemeRegistry",TagFromName.CodingSchemeRegistry);
		tagByName.put("CodingSchemeExternalID",TagFromName.CodingSchemeExternalID);
		tagByName.put("CodingSchemeName",TagFromName.CodingSchemeName);
		tagByName.put("CodingSchemeResponsibleOrganization",TagFromName.CodingSchemeResponsibleOrganization);
		tagByName.put("ContextUID",TagFromName.ContextUID);
		tagByName.put("TimezoneOffsetFromUTC",TagFromName.TimezoneOffsetFromUTC);
		tagByName.put("NetworkID",TagFromName.NetworkID);
		tagByName.put("StationName",TagFromName.StationName);
		tagByName.put("StudyDescription",TagFromName.StudyDescription);
		tagByName.put("ProcedureCodeSequence",TagFromName.ProcedureCodeSequence);
		tagByName.put("SeriesDescription",TagFromName.SeriesDescription);
		tagByName.put("InstitutionalDepartmentName",TagFromName.InstitutionalDepartmentName);
		tagByName.put("PhysicianOfRecord",TagFromName.PhysicianOfRecord);
		tagByName.put("PhysicianOfRecordIdentificationSequence",TagFromName.PhysicianOfRecordIdentificationSequence);
		tagByName.put("PerformingPhysicianName",TagFromName.PerformingPhysicianName);
		tagByName.put("PerformingPhysicianIdentificationSequence",TagFromName.PerformingPhysicianIdentificationSequence);
		tagByName.put("PhysicianReadingStudy",TagFromName.PhysicianReadingStudy);
		tagByName.put("PhysicianReadingStudyIdentificationSequence",TagFromName.PhysicianReadingStudyIdentificationSequence);
		tagByName.put("OperatorName",TagFromName.OperatorName);
		tagByName.put("OperatorIdentificationSequence",TagFromName.OperatorIdentificationSequence);
		tagByName.put("AdmittingDiagnosesDescription",TagFromName.AdmittingDiagnosesDescription);
		tagByName.put("AdmittingDiagnosesCodeSequence",TagFromName.AdmittingDiagnosesCodeSequence);
		tagByName.put("ManufacturerModelName",TagFromName.ManufacturerModelName);
		tagByName.put("ReferencedResultsSequence",TagFromName.ReferencedResultsSequence);
		tagByName.put("ReferencedStudySequence",TagFromName.ReferencedStudySequence);
		tagByName.put("ReferencedPerformedProcedureStepSequence",TagFromName.ReferencedPerformedProcedureStepSequence);
		tagByName.put("ReferencedSeriesSequence",TagFromName.ReferencedSeriesSequence);
		tagByName.put("ReferencedPatientSequence",TagFromName.ReferencedPatientSequence);
		tagByName.put("ReferencedVisitSequence",TagFromName.ReferencedVisitSequence);
		tagByName.put("ReferencedOverlaySequence",TagFromName.ReferencedOverlaySequence);
		tagByName.put("ReferencedStereometricInstanceSequence",TagFromName.ReferencedStereometricInstanceSequence);
		tagByName.put("ReferencedWaveformSequence",TagFromName.ReferencedWaveformSequence);
		tagByName.put("ReferencedImageSequence",TagFromName.ReferencedImageSequence);
		tagByName.put("ReferencedCurveSequence",TagFromName.ReferencedCurveSequence);
		tagByName.put("ReferencedInstanceSequence",TagFromName.ReferencedInstanceSequence);
		tagByName.put("ReferencedRealWorldValueMappingInstanceSequence",TagFromName.ReferencedRealWorldValueMappingInstanceSequence);
		tagByName.put("ReferencedSOPClassUID",TagFromName.ReferencedSOPClassUID);
		tagByName.put("ReferencedSOPInstanceUID",TagFromName.ReferencedSOPInstanceUID);
		tagByName.put("SOPClassesSupported",TagFromName.SOPClassesSupported);
		tagByName.put("ReferencedFrameNumber",TagFromName.ReferencedFrameNumber);
		tagByName.put("TransactionUID",TagFromName.TransactionUID);
		tagByName.put("FailureReason",TagFromName.FailureReason);
		tagByName.put("FailedSOPSequence",TagFromName.FailedSOPSequence);
		tagByName.put("ReferencedSOPSequence",TagFromName.ReferencedSOPSequence);
		tagByName.put("StudiesContainingOtherReferencedInstancesSequence",TagFromName.StudiesContainingOtherReferencedInstancesSequence);
		tagByName.put("RelatedSeriesSequence",TagFromName.RelatedSeriesSequence);
		tagByName.put("OldLossyImageCompression",TagFromName.OldLossyImageCompression);
		tagByName.put("DerivationDescription",TagFromName.DerivationDescription);
		tagByName.put("SourceImageSequence",TagFromName.SourceImageSequence);
		tagByName.put("StageName",TagFromName.StageName);
		tagByName.put("StageNumber",TagFromName.StageNumber);
		tagByName.put("NumberOfStages",TagFromName.NumberOfStages);
		tagByName.put("ViewName",TagFromName.ViewName);
		tagByName.put("ViewNumber",TagFromName.ViewNumber);
		tagByName.put("NumberOfEventTimers",TagFromName.NumberOfEventTimers);
		tagByName.put("NumberOfViewsInStage",TagFromName.NumberOfViewsInStage);
		tagByName.put("EventElapsedTime",TagFromName.EventElapsedTime);
		tagByName.put("EventTimerName",TagFromName.EventTimerName);
		tagByName.put("EventTimerSequence",TagFromName.EventTimerSequence);
		tagByName.put("EventTimeOffset",TagFromName.EventTimeOffset);
		tagByName.put("EventCodeSequence",TagFromName.EventCodeSequence);
		tagByName.put("StartTrim",TagFromName.StartTrim);
		tagByName.put("StopTrim",TagFromName.StopTrim);
		tagByName.put("RecommendedDisplayFrameRate",TagFromName.RecommendedDisplayFrameRate);
		tagByName.put("TransducerPosition",TagFromName.TransducerPosition);
		tagByName.put("TransducerOrientation",TagFromName.TransducerOrientation);
		tagByName.put("AnatomicStructure",TagFromName.AnatomicStructure);
		tagByName.put("AnatomicRegionSequence",TagFromName.AnatomicRegionSequence);
		tagByName.put("AnatomicRegionModifierSequence",TagFromName.AnatomicRegionModifierSequence);
		tagByName.put("PrimaryAnatomicStructureSequence",TagFromName.PrimaryAnatomicStructureSequence);
		tagByName.put("AnatomicStructureSpaceOrRegionSequence",TagFromName.AnatomicStructureSpaceOrRegionSequence);
		tagByName.put("PrimaryAnatomicStructureModifierSequence",TagFromName.PrimaryAnatomicStructureModifierSequence);
		tagByName.put("TransducerPositionSequence",TagFromName.TransducerPositionSequence);
		tagByName.put("TransducerPositionModifierSequence",TagFromName.TransducerPositionModifierSequence);
		tagByName.put("TransducerOrientationSequence",TagFromName.TransducerOrientationSequence);
		tagByName.put("TransducerOrientationModifierSequence",TagFromName.TransducerOrientationModifierSequence);
		tagByName.put("AnatomicStructureSpaceOrRegionCodeSequenceTrial",TagFromName.AnatomicStructureSpaceOrRegionCodeSequenceTrial);
		tagByName.put("AnatomicPortalOfEntranceCodeSequenceTrial",TagFromName.AnatomicPortalOfEntranceCodeSequenceTrial);
		tagByName.put("AnatomicApproachDirectionCodeSequenceTrial",TagFromName.AnatomicApproachDirectionCodeSequenceTrial);
		tagByName.put("AnatomicPerspectiveDescriptionTrial",TagFromName.AnatomicPerspectiveDescriptionTrial);
		tagByName.put("AnatomicPerspectiveCodeSequenceTrial",TagFromName.AnatomicPerspectiveCodeSequenceTrial);
		tagByName.put("AnatomicLocationOfExaminingInstrumentDescriptionTrial",TagFromName.AnatomicLocationOfExaminingInstrumentDescriptionTrial);
		tagByName.put("AnatomicLocationOfExaminingInstrumentCodeSequenceTrial",TagFromName.AnatomicLocationOfExaminingInstrumentCodeSequenceTrial);
		tagByName.put("AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial",TagFromName.AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial);
		tagByName.put("OnAxisBackgroundAnatomicStructureCodeSequenceTrial",TagFromName.OnAxisBackgroundAnatomicStructureCodeSequenceTrial);
		tagByName.put("AlternateRepresentationSequence",TagFromName.AlternateRepresentationSequence);
		tagByName.put("IrradiationEventUID",TagFromName.IrradiationEventUID);
		tagByName.put("IdentifyingComments",TagFromName.IdentifyingComments);
		tagByName.put("FrameType",TagFromName.FrameType);
		tagByName.put("ReferencedImageEvidenceSequence",TagFromName.ReferencedImageEvidenceSequence);
		tagByName.put("ReferencedRawDataSequence",TagFromName.ReferencedRawDataSequence);
		tagByName.put("CreatorVersionUID",TagFromName.CreatorVersionUID);
		tagByName.put("DerivationImageSequence",TagFromName.DerivationImageSequence);
		tagByName.put("SourceImageEvidenceSequence",TagFromName.SourceImageEvidenceSequence);
		tagByName.put("PixelPresentation",TagFromName.PixelPresentation);
		tagByName.put("VolumetricProperties",TagFromName.VolumetricProperties);
		tagByName.put("VolumeBasedCalculationTechnique",TagFromName.VolumeBasedCalculationTechnique);
		tagByName.put("ComplexImageComponent",TagFromName.ComplexImageComponent);
		tagByName.put("AcquisitionContrast",TagFromName.AcquisitionContrast);
		tagByName.put("DerivationCodeSequence",TagFromName.DerivationCodeSequence);
		tagByName.put("ReferencedPresentationStateSequence",TagFromName.ReferencedPresentationStateSequence);
		tagByName.put("ReferencedOtherPlaneSequence",TagFromName.ReferencedOtherPlaneSequence);
		tagByName.put("FrameDisplaySequence",TagFromName.FrameDisplaySequence);
		tagByName.put("RecommendedDisplayFrameRateInFloat",TagFromName.RecommendedDisplayFrameRateInFloat);
		tagByName.put("SkipFrameRangeFlag",TagFromName.SkipFrameRangeFlag);
		tagByName.put("PatientName",TagFromName.PatientName);
		tagByName.put("PatientID",TagFromName.PatientID);
		tagByName.put("IssuerOfPatientID",TagFromName.IssuerOfPatientID);
		tagByName.put("TypeOfPatientID",TagFromName.TypeOfPatientID);
		tagByName.put("IssuerOfPatientIDQualifiersSequence",TagFromName.IssuerOfPatientIDQualifiersSequence);
		tagByName.put("PatientBirthDate",TagFromName.PatientBirthDate);
		tagByName.put("PatientBirthTime",TagFromName.PatientBirthTime);
		tagByName.put("PatientSex",TagFromName.PatientSex);
		tagByName.put("PatientInsurancePlanCodeSequence",TagFromName.PatientInsurancePlanCodeSequence);
		tagByName.put("PatientPrimaryLanguageCodeSequence",TagFromName.PatientPrimaryLanguageCodeSequence);
		tagByName.put("PatientPrimaryLanguageModifierCodeSequence",TagFromName.PatientPrimaryLanguageModifierCodeSequence);
		tagByName.put("OtherPatientID",TagFromName.OtherPatientID);
		tagByName.put("OtherPatientName",TagFromName.OtherPatientName);
		tagByName.put("OtherPatientIDSequence",TagFromName.OtherPatientIDSequence);
		tagByName.put("PatientBirthName",TagFromName.PatientBirthName);
		tagByName.put("PatientAge",TagFromName.PatientAge);
		tagByName.put("PatientSize",TagFromName.PatientSize);
		tagByName.put("PatientWeight",TagFromName.PatientWeight);
		tagByName.put("PatientAddress",TagFromName.PatientAddress);
		tagByName.put("InsurancePlanIdentification",TagFromName.InsurancePlanIdentification);
		tagByName.put("PatientMotherBirthName",TagFromName.PatientMotherBirthName);
		tagByName.put("MilitaryRank",TagFromName.MilitaryRank);
		tagByName.put("BranchOfService",TagFromName.BranchOfService);
		tagByName.put("MedicalRecordLocator",TagFromName.MedicalRecordLocator);
		tagByName.put("MedicalAlerts",TagFromName.MedicalAlerts);
		tagByName.put("Allergies",TagFromName.Allergies);
		tagByName.put("CountryOfResidence",TagFromName.CountryOfResidence);
		tagByName.put("RegionOfResidence",TagFromName.RegionOfResidence);
		tagByName.put("PatientTelephoneNumber",TagFromName.PatientTelephoneNumber);
		tagByName.put("EthnicGroup",TagFromName.EthnicGroup);
		tagByName.put("Occupation",TagFromName.Occupation);
		tagByName.put("SmokingStatus",TagFromName.SmokingStatus);
		tagByName.put("AdditionalPatientHistory",TagFromName.AdditionalPatientHistory);
		tagByName.put("PregnancyStatus",TagFromName.PregnancyStatus);
		tagByName.put("LastMenstrualDate",TagFromName.LastMenstrualDate);
		tagByName.put("PatientReligiousPreference",TagFromName.PatientReligiousPreference);
		tagByName.put("PatientSpeciesDescription",TagFromName.PatientSpeciesDescription);
		tagByName.put("PatientSpeciesCodeSequence",TagFromName.PatientSpeciesCodeSequence);
		tagByName.put("PatientSexNeutered",TagFromName.PatientSexNeutered);
		tagByName.put("PatientBreedDescription",TagFromName.PatientBreedDescription);
		tagByName.put("PatientBreedCodeSequence",TagFromName.PatientBreedCodeSequence);
		tagByName.put("BreedRegistrationSequence",TagFromName.BreedRegistrationSequence);
		tagByName.put("BreedRegistrationNumber",TagFromName.BreedRegistrationNumber);
		tagByName.put("BreedRegistryCodeSequence",TagFromName.BreedRegistryCodeSequence);
		tagByName.put("ResponsiblePerson",TagFromName.ResponsiblePerson);
		tagByName.put("ResponsiblePersonRole",TagFromName.ResponsiblePersonRole);
		tagByName.put("ResponsibleOrganization",TagFromName.ResponsibleOrganization);
		tagByName.put("PatientComments",TagFromName.PatientComments);
		tagByName.put("ExaminedBodyThickness",TagFromName.ExaminedBodyThickness);
		tagByName.put("ClinicalTrialSponsorName",TagFromName.ClinicalTrialSponsorName);
		tagByName.put("ClinicalTrialProtocolID",TagFromName.ClinicalTrialProtocolID);
		tagByName.put("ClinicalTrialProtocolName",TagFromName.ClinicalTrialProtocolName);
		tagByName.put("ClinicalTrialSiteID",TagFromName.ClinicalTrialSiteID);
		tagByName.put("ClinicalTrialSiteName",TagFromName.ClinicalTrialSiteName);
		tagByName.put("ClinicalTrialSubjectID",TagFromName.ClinicalTrialSubjectID);
		tagByName.put("ClinicalTrialSubjectReadingID",TagFromName.ClinicalTrialSubjectReadingID);
		tagByName.put("ClinicalTrialTimePointID",TagFromName.ClinicalTrialTimePointID);
		tagByName.put("ClinicalTrialTimePointDescription",TagFromName.ClinicalTrialTimePointDescription);
		tagByName.put("ClinicalTrialCoordinatingCenterName",TagFromName.ClinicalTrialCoordinatingCenterName);
		tagByName.put("PatientIdentityRemoved",TagFromName.PatientIdentityRemoved);
		tagByName.put("DeidentificationMethod",TagFromName.DeidentificationMethod);
		tagByName.put("DeidentificationMethodCodeSequence",TagFromName.DeidentificationMethodCodeSequence);
		tagByName.put("ClinicalTrialSeriesID",TagFromName.ClinicalTrialSeriesID);
		tagByName.put("ClinicalTrialSeriesDescription",TagFromName.ClinicalTrialSeriesDescription);
		tagByName.put("ClinicalTrialProtocolEthicsCommitteeName",TagFromName.ClinicalTrialProtocolEthicsCommitteeName);
		tagByName.put("ClinicalTrialProtocolEthicsCommitteeApprovalNumber",TagFromName.ClinicalTrialProtocolEthicsCommitteeApprovalNumber);
		tagByName.put("ConsentForClinicalTrialUseSequence",TagFromName.ConsentForClinicalTrialUseSequence);
		tagByName.put("DistributionType",TagFromName.DistributionType);
		tagByName.put("ConsentForDistributionFlag",TagFromName.ConsentForDistributionFlag);
		tagByName.put("ContrastBolusAgent",TagFromName.ContrastBolusAgent);
		tagByName.put("ContrastBolusAgentSequence",TagFromName.ContrastBolusAgentSequence);
		tagByName.put("ContrastBolusAdministrationRouteSequence",TagFromName.ContrastBolusAdministrationRouteSequence);
		tagByName.put("BodyPartExamined",TagFromName.BodyPartExamined);
		tagByName.put("ScanningSequence",TagFromName.ScanningSequence);
		tagByName.put("SequenceVariant",TagFromName.SequenceVariant);
		tagByName.put("ScanOptions",TagFromName.ScanOptions);
		tagByName.put("MRAcquisitionType",TagFromName.MRAcquisitionType);
		tagByName.put("SequenceName",TagFromName.SequenceName);
		tagByName.put("AngioFlag",TagFromName.AngioFlag);
		tagByName.put("InterventionDrugInformationSequence",TagFromName.InterventionDrugInformationSequence);
		tagByName.put("InterventionDrugStopTime",TagFromName.InterventionDrugStopTime);
		tagByName.put("InterventionDrugDose",TagFromName.InterventionDrugDose);
		tagByName.put("InterventionDrugCodeSequence",TagFromName.InterventionDrugCodeSequence);
		tagByName.put("AdditionalDrugSequence",TagFromName.AdditionalDrugSequence);
		tagByName.put("Radionuclide",TagFromName.Radionuclide);
		tagByName.put("Radiopharmaceutical",TagFromName.Radiopharmaceutical);
		tagByName.put("EnergyWindowCenterline",TagFromName.EnergyWindowCenterline);
		tagByName.put("EnergyWindowTotalWidth",TagFromName.EnergyWindowTotalWidth);
		tagByName.put("InterventionDrugName",TagFromName.InterventionDrugName);
		tagByName.put("InterventionDrugStartTime",TagFromName.InterventionDrugStartTime);
		tagByName.put("InterventionSequence",TagFromName.InterventionSequence);
		tagByName.put("TherapyType",TagFromName.TherapyType);
		tagByName.put("InterventionStatus",TagFromName.InterventionStatus);
		tagByName.put("TherapyDescription",TagFromName.TherapyDescription);
		tagByName.put("InterventionDescription",TagFromName.InterventionDescription);
		tagByName.put("CineRate",TagFromName.CineRate);
		tagByName.put("InitialCineRunState",TagFromName.InitialCineRunState);
		tagByName.put("SliceThickness",TagFromName.SliceThickness);
		tagByName.put("KVP",TagFromName.KVP);
		tagByName.put("CountsAccumulated",TagFromName.CountsAccumulated);
		tagByName.put("AcquisitionTerminationCondition",TagFromName.AcquisitionTerminationCondition);
		tagByName.put("EffectiveDuration",TagFromName.EffectiveDuration);
		tagByName.put("AcquisitionStartCondition",TagFromName.AcquisitionStartCondition);
		tagByName.put("AcquisitionStartConditionData",TagFromName.AcquisitionStartConditionData);
		tagByName.put("AcquisitionTerminationConditionData",TagFromName.AcquisitionTerminationConditionData);
		tagByName.put("RepetitionTime",TagFromName.RepetitionTime);
		tagByName.put("EchoTime",TagFromName.EchoTime);
		tagByName.put("InversionTime",TagFromName.InversionTime);
		tagByName.put("NumberOfAverages",TagFromName.NumberOfAverages);
		tagByName.put("ImagingFrequency",TagFromName.ImagingFrequency);
		tagByName.put("ImagedNucleus",TagFromName.ImagedNucleus);
		tagByName.put("EchoNumber",TagFromName.EchoNumber);
		tagByName.put("MagneticFieldStrength",TagFromName.MagneticFieldStrength);
		tagByName.put("SpacingBetweenSlices",TagFromName.SpacingBetweenSlices);
		tagByName.put("NumberOfPhaseEncodingSteps",TagFromName.NumberOfPhaseEncodingSteps);
		tagByName.put("DataCollectionDiameter",TagFromName.DataCollectionDiameter);
		tagByName.put("EchoTrainLength",TagFromName.EchoTrainLength);
		tagByName.put("PercentSampling",TagFromName.PercentSampling);
		tagByName.put("PercentPhaseFieldOfView",TagFromName.PercentPhaseFieldOfView);
		tagByName.put("PixelBandwidth",TagFromName.PixelBandwidth);
		tagByName.put("DeviceSerialNumber",TagFromName.DeviceSerialNumber);
		tagByName.put("DeviceUID",TagFromName.DeviceUID);
		tagByName.put("PlateID",TagFromName.PlateID);
		tagByName.put("GeneratorID",TagFromName.GeneratorID);
		tagByName.put("GridID",TagFromName.GridID);
		tagByName.put("CassetteID",TagFromName.CassetteID);
		tagByName.put("GantryID",TagFromName.GantryID);
		tagByName.put("SecondaryCaptureDeviceID",TagFromName.SecondaryCaptureDeviceID);
		tagByName.put("HardcopyCreationDeviceID",TagFromName.HardcopyCreationDeviceID);
		tagByName.put("DateOfSecondaryCapture",TagFromName.DateOfSecondaryCapture);
		tagByName.put("TimeOfSecondaryCapture",TagFromName.TimeOfSecondaryCapture);
		tagByName.put("SecondaryCaptureDeviceManufacturer",TagFromName.SecondaryCaptureDeviceManufacturer);
		tagByName.put("HardcopyDeviceManufacturer",TagFromName.HardcopyDeviceManufacturer);
		tagByName.put("SecondaryCaptureDeviceManufacturerModelName",TagFromName.SecondaryCaptureDeviceManufacturerModelName);
		tagByName.put("SecondaryCaptureDeviceSoftwareVersion",TagFromName.SecondaryCaptureDeviceSoftwareVersion);
		tagByName.put("HardcopyDeviceSoftwareVersion",TagFromName.HardcopyDeviceSoftwareVersion);
		tagByName.put("HardcopyDeviceManufacturerModelName",TagFromName.HardcopyDeviceManufacturerModelName);
		tagByName.put("SoftwareVersion",TagFromName.SoftwareVersion);
		tagByName.put("VideoImageFormatAcquired",TagFromName.VideoImageFormatAcquired);
		tagByName.put("DigitalImageFormatAcquired",TagFromName.DigitalImageFormatAcquired);
		tagByName.put("ProtocolName",TagFromName.ProtocolName);
		tagByName.put("ContrastBolusRoute",TagFromName.ContrastBolusRoute);
		tagByName.put("ContrastBolusVolume",TagFromName.ContrastBolusVolume);
		tagByName.put("ContrastBolusStartTime",TagFromName.ContrastBolusStartTime);
		tagByName.put("ContrastBolusStopTime",TagFromName.ContrastBolusStopTime);
		tagByName.put("ContrastBolusTotalDose",TagFromName.ContrastBolusTotalDose);
		tagByName.put("SyringeCounts",TagFromName.SyringeCounts);
		tagByName.put("ContrastFlowRate",TagFromName.ContrastFlowRate);
		tagByName.put("ContrastFlowDuration",TagFromName.ContrastFlowDuration);
		tagByName.put("ContrastBolusIngredient",TagFromName.ContrastBolusIngredient);
		tagByName.put("ContrastBolusIngredientConcentration",TagFromName.ContrastBolusIngredientConcentration);
		tagByName.put("SpatialResolution",TagFromName.SpatialResolution);
		tagByName.put("TriggerTime",TagFromName.TriggerTime);
		tagByName.put("TriggerSourceOrType",TagFromName.TriggerSourceOrType);
		tagByName.put("NominalInterval",TagFromName.NominalInterval);
		tagByName.put("FrameTime",TagFromName.FrameTime);
		tagByName.put("CardiacFramingType",TagFromName.CardiacFramingType);
		tagByName.put("FrameTimeVector",TagFromName.FrameTimeVector);
		tagByName.put("FrameDelay",TagFromName.FrameDelay);
		tagByName.put("ImageTriggerDelay",TagFromName.ImageTriggerDelay);
		tagByName.put("MultiplexGroupTimeOffset",TagFromName.MultiplexGroupTimeOffset);
		tagByName.put("TriggerTimeOffset",TagFromName.TriggerTimeOffset);
		tagByName.put("SynchronizationTrigger",TagFromName.SynchronizationTrigger);
		tagByName.put("SynchronizationChannel",TagFromName.SynchronizationChannel);
		tagByName.put("TriggerSamplePosition",TagFromName.TriggerSamplePosition);
		tagByName.put("RadiopharmaceuticalRoute",TagFromName.RadiopharmaceuticalRoute);
		tagByName.put("RadiopharmaceuticalVolume",TagFromName.RadiopharmaceuticalVolume);
		tagByName.put("RadiopharmaceuticalStartTime",TagFromName.RadiopharmaceuticalStartTime);
		tagByName.put("RadiopharmaceuticalStopTime",TagFromName.RadiopharmaceuticalStopTime);
		tagByName.put("RadionuclideTotalDose",TagFromName.RadionuclideTotalDose);
		tagByName.put("RadionuclideHalfLife",TagFromName.RadionuclideHalfLife);
		tagByName.put("RadionuclidePositronFraction",TagFromName.RadionuclidePositronFraction);
		tagByName.put("RadiopharmaceuticalSpecificActivity",TagFromName.RadiopharmaceuticalSpecificActivity);
		tagByName.put("RadiopharmaceuticalStartDateTime",TagFromName.RadiopharmaceuticalStartDateTime);
		tagByName.put("RadiopharmaceuticalStopDateTime",TagFromName.RadiopharmaceuticalStopDateTime);
		tagByName.put("BeatRejectionFlag",TagFromName.BeatRejectionFlag);
		tagByName.put("LowRRValue",TagFromName.LowRRValue);
		tagByName.put("HighRRValue",TagFromName.HighRRValue);
		tagByName.put("IntervalsAcquired",TagFromName.IntervalsAcquired);
		tagByName.put("IntervalsRejected",TagFromName.IntervalsRejected);
		tagByName.put("PVCRejection",TagFromName.PVCRejection);
		tagByName.put("SkipBeats",TagFromName.SkipBeats);
		tagByName.put("HeartRate",TagFromName.HeartRate);
		tagByName.put("CardiacNumberOfImages",TagFromName.CardiacNumberOfImages);
		tagByName.put("TriggerWindow",TagFromName.TriggerWindow);
		tagByName.put("ReconstructionDiameter",TagFromName.ReconstructionDiameter);
		tagByName.put("DistanceSourceToDetector",TagFromName.DistanceSourceToDetector);
		tagByName.put("DistanceSourceToPatient",TagFromName.DistanceSourceToPatient);
		tagByName.put("EstimatedRadiographicMagnificationFactor",TagFromName.EstimatedRadiographicMagnificationFactor);
		tagByName.put("GantryDetectorTilt",TagFromName.GantryDetectorTilt);
		tagByName.put("GantryDetectorSlew",TagFromName.GantryDetectorSlew);
		tagByName.put("TableHeight",TagFromName.TableHeight);
		tagByName.put("TableTraverse",TagFromName.TableTraverse);
		tagByName.put("TableMotion",TagFromName.TableMotion);
		tagByName.put("TableVerticalIncrement",TagFromName.TableVerticalIncrement);
		tagByName.put("TableLateralIncrement",TagFromName.TableLateralIncrement);
		tagByName.put("TableLongitudinalIncrement",TagFromName.TableLongitudinalIncrement);
		tagByName.put("TableAngle",TagFromName.TableAngle);
		tagByName.put("TableType",TagFromName.TableType);
		tagByName.put("RotationDirection",TagFromName.RotationDirection);
		tagByName.put("AngularPosition",TagFromName.AngularPosition);
		tagByName.put("RadialPosition",TagFromName.RadialPosition);
		tagByName.put("ScanArc",TagFromName.ScanArc);
		tagByName.put("AngularStep",TagFromName.AngularStep);
		tagByName.put("CenterOfRotationOffset",TagFromName.CenterOfRotationOffset);
		tagByName.put("RotationOffset",TagFromName.RotationOffset);
		tagByName.put("FieldOfViewShape",TagFromName.FieldOfViewShape);
		tagByName.put("FieldOfViewDimensions",TagFromName.FieldOfViewDimensions);
		tagByName.put("ExposureTime",TagFromName.ExposureTime);
		tagByName.put("XRayTubeCurrent",TagFromName.XRayTubeCurrent);
		tagByName.put("Exposure",TagFromName.Exposure);
		tagByName.put("ExposureInuAs",TagFromName.ExposureInuAs);
		tagByName.put("AveragePulseWidth",TagFromName.AveragePulseWidth);
		tagByName.put("RadiationSetting",TagFromName.RadiationSetting);
		tagByName.put("RectificationType",TagFromName.RectificationType);
		tagByName.put("RadiationMode",TagFromName.RadiationMode);
		tagByName.put("ImageAndFluoroscopyAreaDoseProduct",TagFromName.ImageAndFluoroscopyAreaDoseProduct);
		tagByName.put("FilterType",TagFromName.FilterType);
		tagByName.put("TypeOfFilters",TagFromName.TypeOfFilters);
		tagByName.put("IntensifierSize",TagFromName.IntensifierSize);
		tagByName.put("ImagerPixelSpacing",TagFromName.ImagerPixelSpacing);
		tagByName.put("Grid",TagFromName.Grid);
		tagByName.put("GeneratorPower",TagFromName.GeneratorPower);
		tagByName.put("CollimatorGridName",TagFromName.CollimatorGridName);
		tagByName.put("CollimatorType",TagFromName.CollimatorType);
		tagByName.put("FocalDistance",TagFromName.FocalDistance);
		tagByName.put("XFocusCenter",TagFromName.XFocusCenter);
		tagByName.put("YFocusCenter",TagFromName.YFocusCenter);
		tagByName.put("FocalSpot",TagFromName.FocalSpot);
		tagByName.put("AnodeTargetMaterial",TagFromName.AnodeTargetMaterial);
		tagByName.put("BodyPartThickness",TagFromName.BodyPartThickness);
		tagByName.put("CompressionForce",TagFromName.CompressionForce);
		tagByName.put("DateOfLastCalibration",TagFromName.DateOfLastCalibration);
		tagByName.put("TimeOfLastCalibration",TagFromName.TimeOfLastCalibration);
		tagByName.put("ConvolutionKernel",TagFromName.ConvolutionKernel);
		tagByName.put("UpperLowerPixelValues",TagFromName.UpperLowerPixelValues);
		tagByName.put("ActualFrameDuration",TagFromName.ActualFrameDuration);
		tagByName.put("CountRate",TagFromName.CountRate);
		tagByName.put("PreferredPlaybackSequencing",TagFromName.PreferredPlaybackSequencing);
		tagByName.put("ReceiveCoilName",TagFromName.ReceiveCoilName);
		tagByName.put("TransmitCoilName",TagFromName.TransmitCoilName);
		tagByName.put("PlateType",TagFromName.PlateType);
		tagByName.put("PhosphorType",TagFromName.PhosphorType);
		tagByName.put("ScanVelocity",TagFromName.ScanVelocity);
		tagByName.put("WholeBodyTechnique",TagFromName.WholeBodyTechnique);
		tagByName.put("ScanLength",TagFromName.ScanLength);
		tagByName.put("AcquisitionMatrix",TagFromName.AcquisitionMatrix);
		tagByName.put("InPlanePhaseEncodingDirection",TagFromName.InPlanePhaseEncodingDirection);
		tagByName.put("FlipAngle",TagFromName.FlipAngle);
		tagByName.put("VariableFlipAngleFlag",TagFromName.VariableFlipAngleFlag);
		tagByName.put("SAR",TagFromName.SAR);
		tagByName.put("dBdt",TagFromName.dBdt);
		tagByName.put("AcquisitionDeviceProcessingDescription",TagFromName.AcquisitionDeviceProcessingDescription);
		tagByName.put("AcquisitionDeviceProcessingCode",TagFromName.AcquisitionDeviceProcessingCode);
		tagByName.put("CassetteOrientation",TagFromName.CassetteOrientation);
		tagByName.put("CassetteSize",TagFromName.CassetteSize);
		tagByName.put("ExposuresOnPlate",TagFromName.ExposuresOnPlate);
		tagByName.put("RelativeXRayExposure",TagFromName.RelativeXRayExposure);
		tagByName.put("ColumnAngulation",TagFromName.ColumnAngulation);
		tagByName.put("TomoLayerHeight",TagFromName.TomoLayerHeight);
		tagByName.put("TomoAngle",TagFromName.TomoAngle);
		tagByName.put("TomoTime",TagFromName.TomoTime);
		tagByName.put("TomoType",TagFromName.TomoType);
		tagByName.put("TomoClass",TagFromName.TomoClass);
		tagByName.put("NumberOfTomosynthesisSourceImages",TagFromName.NumberOfTomosynthesisSourceImages);
		tagByName.put("PositionerMotion",TagFromName.PositionerMotion);
		tagByName.put("PositionerType",TagFromName.PositionerType);
		tagByName.put("PositionerPrimaryAngle",TagFromName.PositionerPrimaryAngle);
		tagByName.put("PositionerSecondaryAngle",TagFromName.PositionerSecondaryAngle);
		tagByName.put("PositionerPrimaryAngleIncrement",TagFromName.PositionerPrimaryAngleIncrement);
		tagByName.put("PositionerSecondaryAngleIncrement",TagFromName.PositionerSecondaryAngleIncrement);
		tagByName.put("DetectorPrimaryAngle",TagFromName.DetectorPrimaryAngle);
		tagByName.put("DetectorSecondaryAngle",TagFromName.DetectorSecondaryAngle);
		tagByName.put("ShutterShape",TagFromName.ShutterShape);
		tagByName.put("ShutterLeftVerticalEdge",TagFromName.ShutterLeftVerticalEdge);
		tagByName.put("ShutterRightVerticalEdge",TagFromName.ShutterRightVerticalEdge);
		tagByName.put("ShutterUpperHorizontalEdge",TagFromName.ShutterUpperHorizontalEdge);
		tagByName.put("ShutterLowerHorizontalEdge",TagFromName.ShutterLowerHorizontalEdge);
		tagByName.put("CenterOfCircularShutter",TagFromName.CenterOfCircularShutter);
		tagByName.put("RadiusOfCircularShutter",TagFromName.RadiusOfCircularShutter);
		tagByName.put("VerticesOfPolygonalShutter",TagFromName.VerticesOfPolygonalShutter);
		tagByName.put("ShutterPresentationValue",TagFromName.ShutterPresentationValue);
		tagByName.put("ShutterOverlayGroup",TagFromName.ShutterOverlayGroup);
		tagByName.put("ShutterPresentationColorCIELabValue",TagFromName.ShutterPresentationColorCIELabValue);
		tagByName.put("CollimatorShape",TagFromName.CollimatorShape);
		tagByName.put("CollimatorLeftVerticalEdge",TagFromName.CollimatorLeftVerticalEdge);
		tagByName.put("CollimatorRightVerticalEdge",TagFromName.CollimatorRightVerticalEdge);
		tagByName.put("CollimatorUpperHorizontalEdge",TagFromName.CollimatorUpperHorizontalEdge);
		tagByName.put("CollimatorLowerHorizontalEdge",TagFromName.CollimatorLowerHorizontalEdge);
		tagByName.put("CenterOfCircularCollimator",TagFromName.CenterOfCircularCollimator);
		tagByName.put("RadiusOfCircularCollimator",TagFromName.RadiusOfCircularCollimator);
		tagByName.put("VerticesOfPolygonalCollimator",TagFromName.VerticesOfPolygonalCollimator);
		tagByName.put("AcquisitionTimeSynchronized",TagFromName.AcquisitionTimeSynchronized);
		tagByName.put("TimeSource",TagFromName.TimeSource);
		tagByName.put("TimeDistributionProtocol",TagFromName.TimeDistributionProtocol);
		tagByName.put("NTPSourceAddress",TagFromName.NTPSourceAddress);
		tagByName.put("PageNumberVector",TagFromName.PageNumberVector);
		tagByName.put("FrameLabelVector",TagFromName.FrameLabelVector);
		tagByName.put("FramePrimaryAngleVector",TagFromName.FramePrimaryAngleVector);
		tagByName.put("FrameSecondaryAngleVector",TagFromName.FrameSecondaryAngleVector);
		tagByName.put("SliceLocationVector",TagFromName.SliceLocationVector);
		tagByName.put("DisplayWindowLabelVector",TagFromName.DisplayWindowLabelVector);
		tagByName.put("NominalScannedPixelSpacing",TagFromName.NominalScannedPixelSpacing);
		tagByName.put("DigitizingDeviceTransportDirection",TagFromName.DigitizingDeviceTransportDirection);
		tagByName.put("RotationOfScannedFilm",TagFromName.RotationOfScannedFilm);
		tagByName.put("IVUSAcquisition",TagFromName.IVUSAcquisition);
		tagByName.put("IVUSPullbackRate",TagFromName.IVUSPullbackRate);
		tagByName.put("IVUSGatedRate",TagFromName.IVUSGatedRate);
		tagByName.put("IVUSPullbackStartFrameNumber",TagFromName.IVUSPullbackStartFrameNumber);
		tagByName.put("IVUSPullbackStopFrameNumber",TagFromName.IVUSPullbackStopFrameNumber);
		tagByName.put("LesionNumber",TagFromName.LesionNumber);
		tagByName.put("AcquisitionComments",TagFromName.AcquisitionComments);
		tagByName.put("OutputPower",TagFromName.OutputPower);
		tagByName.put("TransducerData",TagFromName.TransducerData);
		tagByName.put("FocusDepth",TagFromName.FocusDepth);
		tagByName.put("ProcessingFunction",TagFromName.ProcessingFunction);
		tagByName.put("PostprocessingFunction",TagFromName.PostprocessingFunction);
		tagByName.put("MechanicalIndex",TagFromName.MechanicalIndex);
		tagByName.put("BoneThermalIndex",TagFromName.BoneThermalIndex);
		tagByName.put("CranialThermalIndex",TagFromName.CranialThermalIndex);
		tagByName.put("SoftTissueThermalIndex",TagFromName.SoftTissueThermalIndex);
		tagByName.put("SoftTissueFocusThermalIndex",TagFromName.SoftTissueFocusThermalIndex);
		tagByName.put("SoftTissueSurfaceThermalIndex",TagFromName.SoftTissueSurfaceThermalIndex);
		tagByName.put("DynamicRange",TagFromName.DynamicRange);
		tagByName.put("TotalGain",TagFromName.TotalGain);
		tagByName.put("DepthOfScanField",TagFromName.DepthOfScanField);
		tagByName.put("PatientPosition",TagFromName.PatientPosition);
		tagByName.put("ViewPosition",TagFromName.ViewPosition);
		tagByName.put("ProjectionEponymousNameCodeSequence",TagFromName.ProjectionEponymousNameCodeSequence);
		tagByName.put("ImageTransformationMatrix",TagFromName.ImageTransformationMatrix);
		tagByName.put("ImageTranslationVector",TagFromName.ImageTranslationVector);
		tagByName.put("Sensitivity",TagFromName.Sensitivity);
		tagByName.put("SequenceOfUltrasoundRegions",TagFromName.SequenceOfUltrasoundRegions);
		tagByName.put("RegionSpatialFormat",TagFromName.RegionSpatialFormat);
		tagByName.put("RegionDataType",TagFromName.RegionDataType);
		tagByName.put("RegionFlags",TagFromName.RegionFlags);
		tagByName.put("RegionLocationMinX0",TagFromName.RegionLocationMinX0);
		tagByName.put("RegionLocationMinY0",TagFromName.RegionLocationMinY0);
		tagByName.put("RegionLocationMaxX1",TagFromName.RegionLocationMaxX1);
		tagByName.put("RegionLocationMaxY1",TagFromName.RegionLocationMaxY1);
		tagByName.put("ReferencePixelX0",TagFromName.ReferencePixelX0);
		tagByName.put("ReferencePixelY0",TagFromName.ReferencePixelY0);
		tagByName.put("PhysicalUnitsXDirection",TagFromName.PhysicalUnitsXDirection);
		tagByName.put("PhysicalUnitsYDirection",TagFromName.PhysicalUnitsYDirection);
		tagByName.put("ReferencePixelPhysicalValueX",TagFromName.ReferencePixelPhysicalValueX);
		tagByName.put("ReferencePixelPhysicalValueY",TagFromName.ReferencePixelPhysicalValueY);
		tagByName.put("PhysicalDeltaX",TagFromName.PhysicalDeltaX);
		tagByName.put("PhysicalDeltaY",TagFromName.PhysicalDeltaY);
		tagByName.put("TransducerFrequency",TagFromName.TransducerFrequency);
		tagByName.put("TransducerType",TagFromName.TransducerType);
		tagByName.put("PulseRepetitionFrequency",TagFromName.PulseRepetitionFrequency);
		tagByName.put("DopplerCorrectionAngle",TagFromName.DopplerCorrectionAngle);
		tagByName.put("SteeringAngle",TagFromName.SteeringAngle);
		tagByName.put("DopplerSampleVolumeXPositionRetired",TagFromName.DopplerSampleVolumeXPositionRetired);
		tagByName.put("DopplerSampleVolumeXPosition",TagFromName.DopplerSampleVolumeXPosition);
		tagByName.put("DopplerSampleVolumeYPositionRetired",TagFromName.DopplerSampleVolumeYPositionRetired);
		tagByName.put("DopplerSampleVolumeYPosition",TagFromName.DopplerSampleVolumeYPosition);
		tagByName.put("TMLinePositionX0Retired",TagFromName.TMLinePositionX0Retired);
		tagByName.put("TMLinePositionX0",TagFromName.TMLinePositionX0);
		tagByName.put("TMLinePositionY0Retired",TagFromName.TMLinePositionY0Retired);
		tagByName.put("TMLinePositionY0",TagFromName.TMLinePositionY0);
		tagByName.put("TMLinePositionX1Retired",TagFromName.TMLinePositionX1Retired);
		tagByName.put("TMLinePositionX1",TagFromName.TMLinePositionX1);
		tagByName.put("TMLinePositionY1Retired",TagFromName.TMLinePositionY1Retired);
		tagByName.put("TMLinePositionY1",TagFromName.TMLinePositionY1);
		tagByName.put("PixelComponentOrganization",TagFromName.PixelComponentOrganization);
		tagByName.put("PixelComponentMask",TagFromName.PixelComponentMask);
		tagByName.put("PixelComponentRangeStart",TagFromName.PixelComponentRangeStart);
		tagByName.put("PixelComponentRangeStop",TagFromName.PixelComponentRangeStop);
		tagByName.put("PixelComponentPhysicalUnits",TagFromName.PixelComponentPhysicalUnits);
		tagByName.put("PixelComponentDataType",TagFromName.PixelComponentDataType);
		tagByName.put("NumberOfTableBreakPoints",TagFromName.NumberOfTableBreakPoints);
		tagByName.put("TableOfXBreakPoints",TagFromName.TableOfXBreakPoints);
		tagByName.put("TableOfYBreakPoints",TagFromName.TableOfYBreakPoints);
		tagByName.put("NumberOfTableEntries",TagFromName.NumberOfTableEntries);
		tagByName.put("TableOfPixelValues",TagFromName.TableOfPixelValues);
		tagByName.put("TableOfParameterValues",TagFromName.TableOfParameterValues);
		tagByName.put("RWaveTimeVector",TagFromName.RWaveTimeVector);
		tagByName.put("DetectorConditionsNominalFlag",TagFromName.DetectorConditionsNominalFlag);
		tagByName.put("DetectorTemperature",TagFromName.DetectorTemperature);
		tagByName.put("DetectorType",TagFromName.DetectorType);
		tagByName.put("DetectorConfiguration",TagFromName.DetectorConfiguration);
		tagByName.put("DetectorDescription",TagFromName.DetectorDescription);
		tagByName.put("DetectorMode",TagFromName.DetectorMode);
		tagByName.put("DetectorID",TagFromName.DetectorID);
		tagByName.put("DateOfLastDetectorCalibration",TagFromName.DateOfLastDetectorCalibration);
		tagByName.put("TimeOfLastDetectorCalibration",TagFromName.TimeOfLastDetectorCalibration);
		tagByName.put("ExposuresOnDetectorSinceLastCalibration",TagFromName.ExposuresOnDetectorSinceLastCalibration);
		tagByName.put("ExposuresOnDetectorSinceManufactured",TagFromName.ExposuresOnDetectorSinceManufactured);
		tagByName.put("DetectorTimeSinceLastExposure",TagFromName.DetectorTimeSinceLastExposure);
		tagByName.put("DetectorActiveTime",TagFromName.DetectorActiveTime);
		tagByName.put("DetectorActivationOffsetFromExposure",TagFromName.DetectorActivationOffsetFromExposure);
		tagByName.put("DetectorBinning",TagFromName.DetectorBinning);
		tagByName.put("DetectorElementPhysicalSize",TagFromName.DetectorElementPhysicalSize);
		tagByName.put("DetectorElementSpacing",TagFromName.DetectorElementSpacing);
		tagByName.put("DetectorActiveShape",TagFromName.DetectorActiveShape);
		tagByName.put("DetectorActiveDimensions",TagFromName.DetectorActiveDimensions);
		tagByName.put("DetectorActiveOrigin",TagFromName.DetectorActiveOrigin);
		tagByName.put("DetectorManufacturerName",TagFromName.DetectorManufacturerName);
		tagByName.put("DetectorManufacturerModelName",TagFromName.DetectorManufacturerModelName);
		tagByName.put("FieldOfViewOrigin",TagFromName.FieldOfViewOrigin);
		tagByName.put("FieldOfViewRotation",TagFromName.FieldOfViewRotation);
		tagByName.put("FieldOfViewHorizontalFlip",TagFromName.FieldOfViewHorizontalFlip);
		tagByName.put("GridAbsorbingMaterial",TagFromName.GridAbsorbingMaterial);
		tagByName.put("GridSpacingMaterial",TagFromName.GridSpacingMaterial);
		tagByName.put("GridThickness",TagFromName.GridThickness);
		tagByName.put("GridPitch",TagFromName.GridPitch);
		tagByName.put("GridAspectRatio",TagFromName.GridAspectRatio);
		tagByName.put("GridPeriod",TagFromName.GridPeriod);
		tagByName.put("GridFocalDistance",TagFromName.GridFocalDistance);
		tagByName.put("FilterMaterial",TagFromName.FilterMaterial);
		tagByName.put("FilterThicknessMinimum",TagFromName.FilterThicknessMinimum);
		tagByName.put("FilterThicknessMaximum",TagFromName.FilterThicknessMaximum);
		tagByName.put("ExposureControlMode",TagFromName.ExposureControlMode);
		tagByName.put("ExposureControlModeDescription",TagFromName.ExposureControlModeDescription);
		tagByName.put("ExposureStatus",TagFromName.ExposureStatus);
		tagByName.put("PhototimerSetting",TagFromName.PhototimerSetting);
		tagByName.put("ExposureTimeInuS",TagFromName.ExposureTimeInuS);
		tagByName.put("XRayTubeCurrentInuA",TagFromName.XRayTubeCurrentInuA);
		tagByName.put("ContentQualification",TagFromName.ContentQualification);
		tagByName.put("PulseSequenceName",TagFromName.PulseSequenceName);
		tagByName.put("MRImagingModifierSequence",TagFromName.MRImagingModifierSequence);
		tagByName.put("EchoPulseSequence",TagFromName.EchoPulseSequence);
		tagByName.put("InversionRecovery",TagFromName.InversionRecovery);
		tagByName.put("FlowCompensation",TagFromName.FlowCompensation);
		tagByName.put("MultipleSpinEcho",TagFromName.MultipleSpinEcho);
		tagByName.put("MultiplanarExcitation",TagFromName.MultiplanarExcitation);
		tagByName.put("PhaseContrast",TagFromName.PhaseContrast);
		tagByName.put("TimeOfFlightContrast",TagFromName.TimeOfFlightContrast);
		tagByName.put("Spoiling",TagFromName.Spoiling);
		tagByName.put("SteadyStatePulseSequence",TagFromName.SteadyStatePulseSequence);
		tagByName.put("EchoPlanarPulseSequence",TagFromName.EchoPlanarPulseSequence);
		tagByName.put("TagAngleFirstAxis",TagFromName.TagAngleFirstAxis);
		tagByName.put("MagnetizationTransfer",TagFromName.MagnetizationTransfer);
		tagByName.put("T2Preparation",TagFromName.T2Preparation);
		tagByName.put("BloodSignalNulling",TagFromName.BloodSignalNulling);
		tagByName.put("SaturationRecovery",TagFromName.SaturationRecovery);
		tagByName.put("SpectrallySelectedSuppression",TagFromName.SpectrallySelectedSuppression);
		tagByName.put("SpectrallySelectedExcitation",TagFromName.SpectrallySelectedExcitation);
		tagByName.put("SpatialPresaturation",TagFromName.SpatialPresaturation);
		tagByName.put("Tagging",TagFromName.Tagging);
		tagByName.put("OversamplingPhase",TagFromName.OversamplingPhase);
		tagByName.put("TagSpacingFirstDimension",TagFromName.TagSpacingFirstDimension);
		tagByName.put("GeometryOfKSpaceTraversal",TagFromName.GeometryOfKSpaceTraversal);
		tagByName.put("SegmentedKSpaceTraversal",TagFromName.SegmentedKSpaceTraversal);
		tagByName.put("RectilinearPhaseEncodeReordering",TagFromName.RectilinearPhaseEncodeReordering);
		tagByName.put("TagThickness",TagFromName.TagThickness);
		tagByName.put("PartialFourierDirection",TagFromName.PartialFourierDirection);
		tagByName.put("CardiacSynchronizationTechnique",TagFromName.CardiacSynchronizationTechnique);
		tagByName.put("ReceiveCoilManufacturerName",TagFromName.ReceiveCoilManufacturerName);
		tagByName.put("MRReceiveCoilSequence",TagFromName.MRReceiveCoilSequence);
		tagByName.put("ReceiveCoilType",TagFromName.ReceiveCoilType);
		tagByName.put("QuadratureReceiveCoil",TagFromName.QuadratureReceiveCoil);
		tagByName.put("MultiCoilDefinitionSequence",TagFromName.MultiCoilDefinitionSequence);
		tagByName.put("MultiCoilConfiguration",TagFromName.MultiCoilConfiguration);
		tagByName.put("MultiCoilElementName",TagFromName.MultiCoilElementName);
		tagByName.put("MultiCoilElementUsed",TagFromName.MultiCoilElementUsed);
		tagByName.put("MRTransmitCoilSequence",TagFromName.MRTransmitCoilSequence);
		tagByName.put("TransmitCoilManufacturerName",TagFromName.TransmitCoilManufacturerName);
		tagByName.put("TransmitCoilType",TagFromName.TransmitCoilType);
		tagByName.put("SpectralWidth",TagFromName.SpectralWidth);
		tagByName.put("ChemicalShiftReference",TagFromName.ChemicalShiftReference);
		tagByName.put("VolumeLocalizationTechnique",TagFromName.VolumeLocalizationTechnique);
		tagByName.put("MRAcquisitionFrequencyEncodingSteps",TagFromName.MRAcquisitionFrequencyEncodingSteps);
		tagByName.put("Decoupling",TagFromName.Decoupling);
		tagByName.put("DecoupledNucleus",TagFromName.DecoupledNucleus);
		tagByName.put("DecouplingFrequency",TagFromName.DecouplingFrequency);
		tagByName.put("DecouplingMethod",TagFromName.DecouplingMethod);
		tagByName.put("DecouplingChemicalShiftReference",TagFromName.DecouplingChemicalShiftReference);
		tagByName.put("KSpaceFiltering",TagFromName.KSpaceFiltering);
		tagByName.put("TimeDomainFiltering",TagFromName.TimeDomainFiltering);
		tagByName.put("NumberOfZeroFills",TagFromName.NumberOfZeroFills);
		tagByName.put("BaselineCorrection",TagFromName.BaselineCorrection);
		tagByName.put("ParallelReductionFactorInPlane",TagFromName.ParallelReductionFactorInPlane);
		tagByName.put("CardiacRRIntervalSpecified",TagFromName.CardiacRRIntervalSpecified);
		tagByName.put("AcquisitionDuration",TagFromName.AcquisitionDuration);
		tagByName.put("FrameAcquisitionDateTime",TagFromName.FrameAcquisitionDateTime);
		tagByName.put("DiffusionDirectionality",TagFromName.DiffusionDirectionality);
		tagByName.put("DiffusionGradientDirectionSequence",TagFromName.DiffusionGradientDirectionSequence);
		tagByName.put("ParallelAcquisition",TagFromName.ParallelAcquisition);
		tagByName.put("ParallelAcquisitionTechnique",TagFromName.ParallelAcquisitionTechnique);
		tagByName.put("InversionTimes",TagFromName.InversionTimes);
		tagByName.put("MetaboliteMapDescription",TagFromName.MetaboliteMapDescription);
		tagByName.put("PartialFourier",TagFromName.PartialFourier);
		tagByName.put("EffectiveEchoTime",TagFromName.EffectiveEchoTime);
		tagByName.put("MetaboliteCodeSequence",TagFromName.MetaboliteCodeSequence);
		tagByName.put("ChemicalShiftSequence",TagFromName.ChemicalShiftSequence);
		tagByName.put("CardiacSignalSource",TagFromName.CardiacSignalSource);
		tagByName.put("DiffusionBValue",TagFromName.DiffusionBValue);
		tagByName.put("DiffusionGradientOrientation",TagFromName.DiffusionGradientOrientation);
		tagByName.put("VelocityEncodingDirection",TagFromName.VelocityEncodingDirection);
		tagByName.put("VelocityEncodingMinimumValue",TagFromName.VelocityEncodingMinimumValue);
		tagByName.put("NumberOfKSpaceTrajectories",TagFromName.NumberOfKSpaceTrajectories);
		tagByName.put("CoverageOfKSpace",TagFromName.CoverageOfKSpace);
		tagByName.put("SpectroscopyAcquisitionPhaseRows",TagFromName.SpectroscopyAcquisitionPhaseRows);
		tagByName.put("ParallelReductionFactorInPlaneRetired",TagFromName.ParallelReductionFactorInPlaneRetired);
		tagByName.put("TransmitterFrequency",TagFromName.TransmitterFrequency);
		tagByName.put("ResonantNucleus",TagFromName.ResonantNucleus);
		tagByName.put("FrequencyCorrection",TagFromName.FrequencyCorrection);
		tagByName.put("MRSpectroscopyFOVGeometrySequence",TagFromName.MRSpectroscopyFOVGeometrySequence);
		tagByName.put("SlabThickness",TagFromName.SlabThickness);
		tagByName.put("SlabOrientation",TagFromName.SlabOrientation);
		tagByName.put("MidSlabPosition",TagFromName.MidSlabPosition);
		tagByName.put("MRSpatialSaturationSequence",TagFromName.MRSpatialSaturationSequence);
		tagByName.put("MRTimingAndRelatedParametersSequence",TagFromName.MRTimingAndRelatedParametersSequence);
		tagByName.put("MREchoSequence",TagFromName.MREchoSequence);
		tagByName.put("MRModifierSequence",TagFromName.MRModifierSequence);
		tagByName.put("MRDiffusionSequence",TagFromName.MRDiffusionSequence);
		tagByName.put("CardiacSynchronizationSequence",TagFromName.CardiacSynchronizationSequence);
		tagByName.put("MRAveragesSequence",TagFromName.MRAveragesSequence);
		tagByName.put("MRFOVGeometrySequence",TagFromName.MRFOVGeometrySequence);
		tagByName.put("VolumeLocalizationSequence",TagFromName.VolumeLocalizationSequence);
		tagByName.put("SpectroscopyAcquisitionDataColumns",TagFromName.SpectroscopyAcquisitionDataColumns);
		tagByName.put("DiffusionAnisotropyType",TagFromName.DiffusionAnisotropyType);
		tagByName.put("FrameReferenceDateTime",TagFromName.FrameReferenceDateTime);
		tagByName.put("MRMetaboliteMapSequence",TagFromName.MRMetaboliteMapSequence);
		tagByName.put("ParallelReductionFactorOutOfPlane",TagFromName.ParallelReductionFactorOutOfPlane);
		tagByName.put("SpectroscopyAcquisitionOutOfPlanePhaseSteps",TagFromName.SpectroscopyAcquisitionOutOfPlanePhaseSteps);
		tagByName.put("BulkMotionStatus",TagFromName.BulkMotionStatus);
		tagByName.put("ParallelReductionFactorSecondInPlane",TagFromName.ParallelReductionFactorSecondInPlane);
		tagByName.put("CardiacBeatRejectionTechnique",TagFromName.CardiacBeatRejectionTechnique);
		tagByName.put("RespiratoryMotionCompensationTechnique",TagFromName.RespiratoryMotionCompensationTechnique);
		tagByName.put("RespiratorySignalSource",TagFromName.RespiratorySignalSource);
		tagByName.put("BulkMotionCompensationTechnique",TagFromName.BulkMotionCompensationTechnique);
		tagByName.put("BulkMotionSignalSource",TagFromName.BulkMotionSignalSource);
		tagByName.put("ApplicableSafetyStandardAgency",TagFromName.ApplicableSafetyStandardAgency);
		tagByName.put("ApplicableSafetyStandardDescription",TagFromName.ApplicableSafetyStandardDescription);
		tagByName.put("OperatingModeSequence",TagFromName.OperatingModeSequence);
		tagByName.put("OperatingModeType",TagFromName.OperatingModeType);
		tagByName.put("OperatingMode",TagFromName.OperatingMode);
		tagByName.put("SpecificAbsorptionRateDefinition",TagFromName.SpecificAbsorptionRateDefinition);
		tagByName.put("GradientOutputType",TagFromName.GradientOutputType);
		tagByName.put("SpecificAbsorptionRateValue",TagFromName.SpecificAbsorptionRateValue);
		tagByName.put("GradientOutput",TagFromName.GradientOutput);
		tagByName.put("FlowCompensationDirection",TagFromName.FlowCompensationDirection);
		tagByName.put("TaggingDelay",TagFromName.TaggingDelay);
		tagByName.put("RespiratoryMotionCompensationTechniqueDescription",TagFromName.RespiratoryMotionCompensationTechniqueDescription);
		tagByName.put("RespiratorySignalSourceID",TagFromName.RespiratorySignalSourceID);
		tagByName.put("ChemicalShiftMinimumIntegrationLimitInHz",TagFromName.ChemicalShiftMinimumIntegrationLimitInHz);
		tagByName.put("ChemicalShiftMaximumIntegrationLimitInHz",TagFromName.ChemicalShiftMaximumIntegrationLimitInHz);
		tagByName.put("MRVelocityEncodingSequence",TagFromName.MRVelocityEncodingSequence);
		tagByName.put("FirstOrderPhaseCorrection",TagFromName.FirstOrderPhaseCorrection);
		tagByName.put("WaterReferencedPhaseCorrection",TagFromName.WaterReferencedPhaseCorrection);
		tagByName.put("MRSpectroscopyAcquisitionType",TagFromName.MRSpectroscopyAcquisitionType);
		tagByName.put("RespiratoryCyclePosition",TagFromName.RespiratoryCyclePosition);
		tagByName.put("VelocityEncodingMaximumValue",TagFromName.VelocityEncodingMaximumValue);
		tagByName.put("TagSpacingSecondDimension",TagFromName.TagSpacingSecondDimension);
		tagByName.put("TagAngleSecondAxis",TagFromName.TagAngleSecondAxis);
		tagByName.put("FrameAcquisitionDuration",TagFromName.FrameAcquisitionDuration);
		tagByName.put("MRImageFrameTypeSequence",TagFromName.MRImageFrameTypeSequence);
		tagByName.put("MRSpectroscopyFrameTypeSequence",TagFromName.MRSpectroscopyFrameTypeSequence);
		tagByName.put("MRAcquisitionPhaseEncodingStepsInPlane",TagFromName.MRAcquisitionPhaseEncodingStepsInPlane);
		tagByName.put("MRAcquisitionPhaseEncodingStepsOutOfPlane",TagFromName.MRAcquisitionPhaseEncodingStepsOutOfPlane);
		tagByName.put("SpectroscopyAcquisitionPhaseColumns",TagFromName.SpectroscopyAcquisitionPhaseColumns);
		tagByName.put("CardiacCyclePosition",TagFromName.CardiacCyclePosition);
		tagByName.put("SpecificAbsorptionRateSequence",TagFromName.SpecificAbsorptionRateSequence);
		tagByName.put("RFEchoTrainLength",TagFromName.RFEchoTrainLength);
		tagByName.put("GradientEchoTrainLength",TagFromName.GradientEchoTrainLength);
		tagByName.put("ChemicalShiftMinimumIntegrationLimitInPPM",TagFromName.ChemicalShiftMinimumIntegrationLimitInPPM);
		tagByName.put("ChemicalShiftMaximumIntegrationLimitInPPM",TagFromName.ChemicalShiftMaximumIntegrationLimitInPPM);
		tagByName.put("CTAcquisitionTypeSequence",TagFromName.CTAcquisitionTypeSequence);
		tagByName.put("AcquisitionType",TagFromName.AcquisitionType);
		tagByName.put("TubeAngle",TagFromName.TubeAngle);
		tagByName.put("CTAcquisitionDetailsSequence",TagFromName.CTAcquisitionDetailsSequence);
		tagByName.put("RevolutionTime",TagFromName.RevolutionTime);
		tagByName.put("SingleCollimationWidth",TagFromName.SingleCollimationWidth);
		tagByName.put("TotalCollimationWidth",TagFromName.TotalCollimationWidth);
		tagByName.put("CTTableDynamicsSequence",TagFromName.CTTableDynamicsSequence);
		tagByName.put("TableSpeed",TagFromName.TableSpeed);
		tagByName.put("TableFeedPerRotation",TagFromName.TableFeedPerRotation);
		tagByName.put("SpiralPitchFactor",TagFromName.SpiralPitchFactor);
		tagByName.put("CTGeometrySequence",TagFromName.CTGeometrySequence);
		tagByName.put("DataCollectionCenterPatient",TagFromName.DataCollectionCenterPatient);
		tagByName.put("CTReconstructionSequence",TagFromName.CTReconstructionSequence);
		tagByName.put("ReconstructionAlgorithm",TagFromName.ReconstructionAlgorithm);
		tagByName.put("ConvolutionKernelGroup",TagFromName.ConvolutionKernelGroup);
		tagByName.put("ReconstructionFieldOfView",TagFromName.ReconstructionFieldOfView);
		tagByName.put("ReconstructionTargetCenterPatient",TagFromName.ReconstructionTargetCenterPatient);
		tagByName.put("ReconstructionAngle",TagFromName.ReconstructionAngle);
		tagByName.put("ImageFilter",TagFromName.ImageFilter);
		tagByName.put("CTExposureSequence",TagFromName.CTExposureSequence);
		tagByName.put("ReconstructionPixelSpacing",TagFromName.ReconstructionPixelSpacing);
		tagByName.put("ExposureModulationType",TagFromName.ExposureModulationType);
		tagByName.put("EstimatedDoseSaving",TagFromName.EstimatedDoseSaving);
		tagByName.put("CTXRayDetailsSequence",TagFromName.CTXRayDetailsSequence);
		tagByName.put("CTPositionSequence",TagFromName.CTPositionSequence);
		tagByName.put("TablePosition",TagFromName.TablePosition);
		tagByName.put("ExposureTimeInms",TagFromName.ExposureTimeInms);
		tagByName.put("CTImageFrameTypeSequence",TagFromName.CTImageFrameTypeSequence);
		tagByName.put("XRayTubeCurrentInmA",TagFromName.XRayTubeCurrentInmA);
		tagByName.put("ExposureInmAs",TagFromName.ExposureInmAs);
		tagByName.put("ConstantVolumeFlag",TagFromName.ConstantVolumeFlag);
		tagByName.put("FluoroscopyFlag",TagFromName.FluoroscopyFlag);
		tagByName.put("DistanceSourceToDataCollectionCenter",TagFromName.DistanceSourceToDataCollectionCenter);
		tagByName.put("ContrastBolusAgentNumber",TagFromName.ContrastBolusAgentNumber);
		tagByName.put("ContrastBolusIngredientCodeSequence",TagFromName.ContrastBolusIngredientCodeSequence);
		tagByName.put("ContrastAdministrationProfileSequence",TagFromName.ContrastAdministrationProfileSequence);
		tagByName.put("ContrastBolusUsageSequence",TagFromName.ContrastBolusUsageSequence);
		tagByName.put("ContrastBolusAgentAdministered",TagFromName.ContrastBolusAgentAdministered);
		tagByName.put("ContrastBolusAgentDetected",TagFromName.ContrastBolusAgentDetected);
		tagByName.put("ContrastBolusAgentPhase",TagFromName.ContrastBolusAgentPhase);
		tagByName.put("CTDIvol",TagFromName.CTDIvol);
		tagByName.put("CTDIPhantomTypeCodeSequence",TagFromName.CTDIPhantomTypeCodeSequence);
		tagByName.put("CalciumScoringMassFactorPatient",TagFromName.CalciumScoringMassFactorPatient);
		tagByName.put("CalciumScoringMassFactorDevice",TagFromName.CalciumScoringMassFactorDevice);
		tagByName.put("EnergyWeightingFactor",TagFromName.EnergyWeightingFactor);
		tagByName.put("CTAdditionalXRaySourceSequence",TagFromName.CTAdditionalXRaySourceSequence);
		tagByName.put("ProjectionPixelCalibrationSequence",TagFromName.ProjectionPixelCalibrationSequence);
		tagByName.put("DistanceSourceToIsocenter",TagFromName.DistanceSourceToIsocenter);
		tagByName.put("DistanceObjectToTableTop",TagFromName.DistanceObjectToTableTop);
		tagByName.put("ObjectPixelSpacingInCenterOfBeam",TagFromName.ObjectPixelSpacingInCenterOfBeam);
		tagByName.put("PositionerPositionSequence",TagFromName.PositionerPositionSequence);
		tagByName.put("TablePositionSequence",TagFromName.TablePositionSequence);
		tagByName.put("CollimatorShapeSequence",TagFromName.CollimatorShapeSequence);
		tagByName.put("XAXRFFrameCharacteristicsSequence",TagFromName.XAXRFFrameCharacteristicsSequence);
		tagByName.put("FrameAcquisitionSequence",TagFromName.FrameAcquisitionSequence);
		tagByName.put("XRayReceptorType",TagFromName.XRayReceptorType);
		tagByName.put("AcquisitionProtocolName",TagFromName.AcquisitionProtocolName);
		tagByName.put("AcquisitionProtocolDescription",TagFromName.AcquisitionProtocolDescription);
		tagByName.put("ContrastBolusIngredientOpaque",TagFromName.ContrastBolusIngredientOpaque);
		tagByName.put("DistanceReceptorPlaneToDetectorHousing",TagFromName.DistanceReceptorPlaneToDetectorHousing);
		tagByName.put("IntensifierActiveShape",TagFromName.IntensifierActiveShape);
		tagByName.put("IntensifierActiveDimensions",TagFromName.IntensifierActiveDimensions);
		tagByName.put("PhysicalDetectorSize",TagFromName.PhysicalDetectorSize);
		tagByName.put("PositionOfIsocenterProjection",TagFromName.PositionOfIsocenterProjection);
		tagByName.put("FieldOfViewSequence",TagFromName.FieldOfViewSequence);
		tagByName.put("FieldOfViewDescription",TagFromName.FieldOfViewDescription);
		tagByName.put("ExposureControlSensingRegionsSequence",TagFromName.ExposureControlSensingRegionsSequence);
		tagByName.put("ExposureControlSensingRegionShape",TagFromName.ExposureControlSensingRegionShape);
		tagByName.put("ExposureControlSensingRegionLeftVerticalEdge",TagFromName.ExposureControlSensingRegionLeftVerticalEdge);
		tagByName.put("ExposureControlSensingRegionRightVerticalEdge",TagFromName.ExposureControlSensingRegionRightVerticalEdge);
		tagByName.put("ExposureControlSensingRegionUpperHorizontalEdge",TagFromName.ExposureControlSensingRegionUpperHorizontalEdge);
		tagByName.put("ExposureControlSensingRegionLowerHorizontalEdge",TagFromName.ExposureControlSensingRegionLowerHorizontalEdge);
		tagByName.put("CenterOfCircularExposureControlSensingRegion",TagFromName.CenterOfCircularExposureControlSensingRegion);
		tagByName.put("RadiusOfCircularExposureControlSensingRegion",TagFromName.RadiusOfCircularExposureControlSensingRegion);
		tagByName.put("VerticesOfPolygonalExposureControlSensingRegion",TagFromName.VerticesOfPolygonalExposureControlSensingRegion);
		tagByName.put("ColumnAngulationPatient",TagFromName.ColumnAngulationPatient);
		tagByName.put("BeamAngle",TagFromName.BeamAngle);
		tagByName.put("FrameDetectorParametersSequence",TagFromName.FrameDetectorParametersSequence);
		tagByName.put("CalculatedAnatomyThickness",TagFromName.CalculatedAnatomyThickness);
		tagByName.put("CalibrationSequence",TagFromName.CalibrationSequence);
		tagByName.put("ObjectThicknessSequence",TagFromName.ObjectThicknessSequence);
		tagByName.put("PlaneIdentification",TagFromName.PlaneIdentification);
		tagByName.put("FieldOfViewDimensionsInFloat",TagFromName.FieldOfViewDimensionsInFloat);
		tagByName.put("IsocenterReferenceSystemSequence",TagFromName.IsocenterReferenceSystemSequence);
		tagByName.put("PositionerIsocenterPrimaryAngle",TagFromName.PositionerIsocenterPrimaryAngle);
		tagByName.put("PositionerIsocenterSecondaryAngle",TagFromName.PositionerIsocenterSecondaryAngle);
		tagByName.put("PositionerIsocenterDetectorRotationAngle",TagFromName.PositionerIsocenterDetectorRotationAngle);
		tagByName.put("TableXPositionToIsocenter",TagFromName.TableXPositionToIsocenter);
		tagByName.put("TableYPositionToIsocenter",TagFromName.TableYPositionToIsocenter);
		tagByName.put("TableZPositionToIsocenter",TagFromName.TableZPositionToIsocenter);
		tagByName.put("TableHorizontalRotationAngle",TagFromName.TableHorizontalRotationAngle);
		tagByName.put("TableHeadTiltAngle",TagFromName.TableHeadTiltAngle);
		tagByName.put("TableCradleTiltAngle",TagFromName.TableCradleTiltAngle);
		tagByName.put("FrameDisplayShutterSequence",TagFromName.FrameDisplayShutterSequence);
		tagByName.put("AcquiredImageAreaDoseProduct",TagFromName.AcquiredImageAreaDoseProduct);
		tagByName.put("CArmPositionerTabletopRelationship",TagFromName.CArmPositionerTabletopRelationship);
		tagByName.put("XRayGeometrySequence",TagFromName.XRayGeometrySequence);
		tagByName.put("IrradiationEventIdentificationSequence",TagFromName.IrradiationEventIdentificationSequence);
		tagByName.put("XRay3DFrameTypeSequence",TagFromName.XRay3DFrameTypeSequence);
		tagByName.put("ContributingSourcesSequence",TagFromName.ContributingSourcesSequence);
		tagByName.put("XRay3DAcquisitionSequence",TagFromName.XRay3DAcquisitionSequence);
		tagByName.put("PrimaryPositionerScanArc",TagFromName.PrimaryPositionerScanArc);
		tagByName.put("SecondaryPositionerScanArc",TagFromName.SecondaryPositionerScanArc);
		tagByName.put("PrimaryPositionerScanStartAngle",TagFromName.PrimaryPositionerScanStartAngle);
		tagByName.put("SecondaryPositionerScanStartAngle",TagFromName.SecondaryPositionerScanStartAngle);
		tagByName.put("PrimaryPositionerIncrement",TagFromName.PrimaryPositionerIncrement);
		tagByName.put("SecondaryPositionerIncrement",TagFromName.SecondaryPositionerIncrement);
		tagByName.put("StartAcquisitionDateTime",TagFromName.StartAcquisitionDateTime);
		tagByName.put("EndAcquisitionDateTime",TagFromName.EndAcquisitionDateTime);
		tagByName.put("ApplicationName",TagFromName.ApplicationName);
		tagByName.put("ApplicationVersion",TagFromName.ApplicationVersion);
		tagByName.put("ApplicationManufacturer",TagFromName.ApplicationManufacturer);
		tagByName.put("AlgorithmType",TagFromName.AlgorithmType);
		tagByName.put("AlgorithmDescription",TagFromName.AlgorithmDescription);
		tagByName.put("XRay3DReconstructionSequence",TagFromName.XRay3DReconstructionSequence);
		tagByName.put("ReconstructionDescription",TagFromName.ReconstructionDescription);
		tagByName.put("PerProjectionAcquisitionSequence",TagFromName.PerProjectionAcquisitionSequence);
		tagByName.put("DiffusionBMatrixSequence",TagFromName.DiffusionBMatrixSequence);
		tagByName.put("DiffusionBMatrixValueXX",TagFromName.DiffusionBMatrixValueXX);
		tagByName.put("DiffusionBMatrixValueXY",TagFromName.DiffusionBMatrixValueXY);
		tagByName.put("DiffusionBMatrixValueXZ",TagFromName.DiffusionBMatrixValueXZ);
		tagByName.put("DiffusionBMatrixValueYY",TagFromName.DiffusionBMatrixValueYY);
		tagByName.put("DiffusionBMatrixValueYZ",TagFromName.DiffusionBMatrixValueYZ);
		tagByName.put("DiffusionBMatrixValueZZ",TagFromName.DiffusionBMatrixValueZZ);
		tagByName.put("DecayCorrectionDateTime",TagFromName.DecayCorrectionDateTime);
		tagByName.put("StartDensityThreshold",TagFromName.StartDensityThreshold);
		tagByName.put("StartRelativeDensityDifferenceThreshold",TagFromName.StartRelativeDensityDifferenceThreshold);
		tagByName.put("StartCardiacTriggerCountThreshold",TagFromName.StartCardiacTriggerCountThreshold);
		tagByName.put("StartRespiratoryTriggerCountThreshold",TagFromName.StartRespiratoryTriggerCountThreshold);
		tagByName.put("TerminationCountsThreshold",TagFromName.TerminationCountsThreshold);
		tagByName.put("TerminationDensityThreshold",TagFromName.TerminationDensityThreshold);
		tagByName.put("TerminationRelativeDensityThreshold",TagFromName.TerminationRelativeDensityThreshold);
		tagByName.put("TerminationTimeThreshold",TagFromName.TerminationTimeThreshold);
		tagByName.put("TerminationCardiacTriggerCountThreshold",TagFromName.TerminationCardiacTriggerCountThreshold);
		tagByName.put("TerminationRespiratoryTriggerCountThreshold",TagFromName.TerminationRespiratoryTriggerCountThreshold);
		tagByName.put("DetectorGeometry",TagFromName.DetectorGeometry);
		tagByName.put("TransverseDetectorSeparation",TagFromName.TransverseDetectorSeparation);
		tagByName.put("AxialDetectorDimension",TagFromName.AxialDetectorDimension);
		tagByName.put("RadiopharmaceuticalAgentNumber",TagFromName.RadiopharmaceuticalAgentNumber);
		tagByName.put("PETFrameAcquisitionSequence",TagFromName.PETFrameAcquisitionSequence);
		tagByName.put("PETDetectorMotionDetailsSequence",TagFromName.PETDetectorMotionDetailsSequence);
		tagByName.put("PETTableDynamicsSequence",TagFromName.PETTableDynamicsSequence);
		tagByName.put("PETPositionSequence",TagFromName.PETPositionSequence);
		tagByName.put("PETFrameCorrectionFactorsSequence",TagFromName.PETFrameCorrectionFactorsSequence);
		tagByName.put("RadiopharmaceuticalUsageSequence",TagFromName.RadiopharmaceuticalUsageSequence);
		tagByName.put("AttenuationCorrectionSource",TagFromName.AttenuationCorrectionSource);
		tagByName.put("NumberOfIterations",TagFromName.NumberOfIterations);
		tagByName.put("NumberOfSubsets",TagFromName.NumberOfSubsets);
		tagByName.put("PETReconstructionSequence",TagFromName.PETReconstructionSequence);
		tagByName.put("PETFrameTypeSequence",TagFromName.PETFrameTypeSequence);
		tagByName.put("TimeOfFlightInformationUsed",TagFromName.TimeOfFlightInformationUsed);
		tagByName.put("ReconstructionType",TagFromName.ReconstructionType);
		tagByName.put("DecayCorrected",TagFromName.DecayCorrected);
		tagByName.put("AttenuationCorrected",TagFromName.AttenuationCorrected);
		tagByName.put("ScatterCorrected",TagFromName.ScatterCorrected);
		tagByName.put("DeadTimeCorrected",TagFromName.DeadTimeCorrected);
		tagByName.put("GantryMotionCorrected",TagFromName.GantryMotionCorrected);
		tagByName.put("PatientMotionCorrected",TagFromName.PatientMotionCorrected);
		tagByName.put("CountLossNormalizationCorrected",TagFromName.CountLossNormalizationCorrected);
		tagByName.put("RandomsCorrected",TagFromName.RandomsCorrected);
		tagByName.put("NonUniformRadialSamplingCorrected",TagFromName.NonUniformRadialSamplingCorrected);
		tagByName.put("SensitivityCalibrated",TagFromName.SensitivityCalibrated);
		tagByName.put("DetectorNormalizationCorrection",TagFromName.DetectorNormalizationCorrection);
		tagByName.put("IterativeReconstructionMethod",TagFromName.IterativeReconstructionMethod);
		tagByName.put("AttenuationCorrectionTemporalRelationship",TagFromName.AttenuationCorrectionTemporalRelationship);
		tagByName.put("PatientPhysiologicalStateSequence",TagFromName.PatientPhysiologicalStateSequence);
		tagByName.put("PatientPhysiologicalStateCodeSequence",TagFromName.PatientPhysiologicalStateCodeSequence);
		tagByName.put("DepthsOfFocus",TagFromName.DepthsOfFocus);
		tagByName.put("ExcludedIntervalsSequence",TagFromName.ExcludedIntervalsSequence);
		tagByName.put("ExclusionStartDatetime",TagFromName.ExclusionStartDatetime);
		tagByName.put("ExclusionDuration",TagFromName.ExclusionDuration);
		tagByName.put("USImageDescriptionSequence",TagFromName.USImageDescriptionSequence);
		tagByName.put("ImageDataTypeSequence",TagFromName.ImageDataTypeSequence);
		tagByName.put("DataType",TagFromName.DataType);
		tagByName.put("TransducerScanPatternCodeSequence",TagFromName.TransducerScanPatternCodeSequence);
		tagByName.put("AliasedDataType",TagFromName.AliasedDataType);
		tagByName.put("PositionMeasuringDeviceUsed",TagFromName.PositionMeasuringDeviceUsed);
		tagByName.put("TransducerGeometryCodeSequence",TagFromName.TransducerGeometryCodeSequence);
		tagByName.put("TransducerBeamSteeringCodeSequence",TagFromName.TransducerBeamSteeringCodeSequence);
		tagByName.put("TransducerApplicationCodeSequence",TagFromName.TransducerApplicationCodeSequence);
		tagByName.put("ContributingEquipmentSequence",TagFromName.ContributingEquipmentSequence);
		tagByName.put("ContributionDateTime",TagFromName.ContributionDateTime);
		tagByName.put("ContributionDescription",TagFromName.ContributionDescription);
		tagByName.put("StudyInstanceUID",TagFromName.StudyInstanceUID);
		tagByName.put("SeriesInstanceUID",TagFromName.SeriesInstanceUID);
		tagByName.put("StudyID",TagFromName.StudyID);
		tagByName.put("SeriesNumber",TagFromName.SeriesNumber);
		tagByName.put("AcquisitionNumber",TagFromName.AcquisitionNumber);
		tagByName.put("InstanceNumber",TagFromName.InstanceNumber);
		tagByName.put("IsotopeNumber",TagFromName.IsotopeNumber);
		tagByName.put("PhaseNumber",TagFromName.PhaseNumber);
		tagByName.put("IntervalNumber",TagFromName.IntervalNumber);
		tagByName.put("TimeSlotNumber",TagFromName.TimeSlotNumber);
		tagByName.put("AngleNumber",TagFromName.AngleNumber);
		tagByName.put("ItemNumber",TagFromName.ItemNumber);
		tagByName.put("PatientOrientation",TagFromName.PatientOrientation);
		tagByName.put("OverlayNumber",TagFromName.OverlayNumber);
		tagByName.put("CurveNumber",TagFromName.CurveNumber);
		tagByName.put("LUTNumber",TagFromName.LUTNumber);
		tagByName.put("ImagePosition",TagFromName.ImagePosition);
		tagByName.put("ImagePositionPatient",TagFromName.ImagePositionPatient);
		tagByName.put("ImageOrientation",TagFromName.ImageOrientation);
		tagByName.put("ImageOrientationPatient",TagFromName.ImageOrientationPatient);
		tagByName.put("Location",TagFromName.Location);
		tagByName.put("FrameOfReferenceUID",TagFromName.FrameOfReferenceUID);
		tagByName.put("Laterality",TagFromName.Laterality);
		tagByName.put("ImageLaterality",TagFromName.ImageLaterality);
		tagByName.put("ImageGeometryType",TagFromName.ImageGeometryType);
		tagByName.put("MaskingImage",TagFromName.MaskingImage);
		tagByName.put("ReportNumberTrial",TagFromName.ReportNumberTrial);
		tagByName.put("TemporalPositionIdentifier",TagFromName.TemporalPositionIdentifier);
		tagByName.put("NumberOfTemporalPositions",TagFromName.NumberOfTemporalPositions);
		tagByName.put("TemporalResolution",TagFromName.TemporalResolution);
		tagByName.put("SynchronizationFrameOfReferenceUID",TagFromName.SynchronizationFrameOfReferenceUID);
		tagByName.put("SeriesInStudy",TagFromName.SeriesInStudy);
		tagByName.put("AcquisitionsInSeries",TagFromName.AcquisitionsInSeries);
		tagByName.put("ImagesInAcquisition",TagFromName.ImagesInAcquisition);
		tagByName.put("ImagesInSeries",TagFromName.ImagesInSeries);
		tagByName.put("AcquisitionsInStudy",TagFromName.AcquisitionsInStudy);
		tagByName.put("ImagesInStudy",TagFromName.ImagesInStudy);
		tagByName.put("Reference",TagFromName.Reference);
		tagByName.put("PositionReferenceIndicator",TagFromName.PositionReferenceIndicator);
		tagByName.put("SliceLocation",TagFromName.SliceLocation);
		tagByName.put("OtherStudyNumbers",TagFromName.OtherStudyNumbers);
		tagByName.put("NumberOfPatientRelatedStudies",TagFromName.NumberOfPatientRelatedStudies);
		tagByName.put("NumberOfPatientRelatedSeries",TagFromName.NumberOfPatientRelatedSeries);
		tagByName.put("NumberOfPatientRelatedInstances",TagFromName.NumberOfPatientRelatedInstances);
		tagByName.put("NumberOfStudyRelatedSeries",TagFromName.NumberOfStudyRelatedSeries);
		tagByName.put("NumberOfStudyRelatedInstances",TagFromName.NumberOfStudyRelatedInstances);
		tagByName.put("NumberOfSeriesRelatedInstances",TagFromName.NumberOfSeriesRelatedInstances);
		tagByName.put("SourceImageID",TagFromName.SourceImageID);
		tagByName.put("ModifyingDeviceID",TagFromName.ModifyingDeviceID);
		tagByName.put("ModifiedImageID",TagFromName.ModifiedImageID);
		tagByName.put("ModifiedImageDate",TagFromName.ModifiedImageDate);
		tagByName.put("ModifyingDeviceManufacturer",TagFromName.ModifyingDeviceManufacturer);
		tagByName.put("ModifiedImageTime",TagFromName.ModifiedImageTime);
		tagByName.put("ModifiedImageDescription",TagFromName.ModifiedImageDescription);
		tagByName.put("ImageComments",TagFromName.ImageComments);
		tagByName.put("OriginalImageIdentification",TagFromName.OriginalImageIdentification);
		tagByName.put("OriginalImageIdentificationNomenclature",TagFromName.OriginalImageIdentificationNomenclature);
		tagByName.put("StackID",TagFromName.StackID);
		tagByName.put("InStackPositionNumber",TagFromName.InStackPositionNumber);
		tagByName.put("FrameAnatomySequence",TagFromName.FrameAnatomySequence);
		tagByName.put("FrameLaterality",TagFromName.FrameLaterality);
		tagByName.put("FrameContentSequence",TagFromName.FrameContentSequence);
		tagByName.put("PlanePositionSequence",TagFromName.PlanePositionSequence);
		tagByName.put("PlaneOrientationSequence",TagFromName.PlaneOrientationSequence);
		tagByName.put("TemporalPositionIndex",TagFromName.TemporalPositionIndex);
		tagByName.put("NominalCardiacTriggerDelayTime",TagFromName.NominalCardiacTriggerDelayTime);
		tagByName.put("FrameAcquisitionNumber",TagFromName.FrameAcquisitionNumber);
		tagByName.put("DimensionIndexValues",TagFromName.DimensionIndexValues);
		tagByName.put("FrameComments",TagFromName.FrameComments);
		tagByName.put("ConcatenationUID",TagFromName.ConcatenationUID);
		tagByName.put("InConcatenationNumber",TagFromName.InConcatenationNumber);
		tagByName.put("InConcatenationTotalNumber",TagFromName.InConcatenationTotalNumber);
		tagByName.put("DimensionOrganizationUID",TagFromName.DimensionOrganizationUID);
		tagByName.put("DimensionIndexPointer",TagFromName.DimensionIndexPointer);
		tagByName.put("FunctionalGroupPointer",TagFromName.FunctionalGroupPointer);
		tagByName.put("DimensionIndexPrivateCreator",TagFromName.DimensionIndexPrivateCreator);
		tagByName.put("DimensionOrganizationSequence",TagFromName.DimensionOrganizationSequence);
		tagByName.put("DimensionIndexSequence",TagFromName.DimensionIndexSequence);
		tagByName.put("ConcatenationFrameOffsetNumber",TagFromName.ConcatenationFrameOffsetNumber);
		tagByName.put("FunctionalGroupPrivateCreator",TagFromName.FunctionalGroupPrivateCreator);
		tagByName.put("NominalPercentageOfCardiacPhase",TagFromName.NominalPercentageOfCardiacPhase);
		tagByName.put("NominalPercentageOfRespiratoryPhase",TagFromName.NominalPercentageOfRespiratoryPhase);
		tagByName.put("StartingRespiratoryAmplitude",TagFromName.StartingRespiratoryAmplitude);
		tagByName.put("StartingRespiratoryPhase",TagFromName.StartingRespiratoryPhase);
		tagByName.put("EndingRespiratoryAmplitude",TagFromName.EndingRespiratoryAmplitude);
		tagByName.put("EndingRespiratoryPhase",TagFromName.EndingRespiratoryPhase);
		tagByName.put("RespiratoryTriggerType",TagFromName.RespiratoryTriggerType);
		tagByName.put("RRIntervalTimeNominal",TagFromName.RRIntervalTimeNominal);
		tagByName.put("ActualCardiacTriggerDelayTime",TagFromName.ActualCardiacTriggerDelayTime);
		tagByName.put("RespiratorySynchronizationSequence",TagFromName.RespiratorySynchronizationSequence);
		tagByName.put("RespiratoryIntervalTime",TagFromName.RespiratoryIntervalTime);
		tagByName.put("NominalRespiratoryTriggerDelayTime",TagFromName.NominalRespiratoryTriggerDelayTime);
		tagByName.put("RespiratoryTriggerDelayThreshold",TagFromName.RespiratoryTriggerDelayThreshold);
		tagByName.put("ActualRespiratoryTriggerDelayTime",TagFromName.ActualRespiratoryTriggerDelayTime);
		tagByName.put("ImagePositionVolume",TagFromName.ImagePositionVolume);
		tagByName.put("ImageOrientationVolume",TagFromName.ImageOrientationVolume);
		tagByName.put("UltrasoundAcquisitionGeometry",TagFromName.UltrasoundAcquisitionGeometry);
		tagByName.put("ApexPosition",TagFromName.ApexPosition);
		tagByName.put("VolumeToTransducerMappingMatrix",TagFromName.VolumeToTransducerMappingMatrix);
		tagByName.put("VolumeToTableMappingMatrix",TagFromName.VolumeToTableMappingMatrix);
		tagByName.put("PatientFrameofReferenceSource",TagFromName.PatientFrameofReferenceSource);
		tagByName.put("TemporalPositionTimeOffset",TagFromName.TemporalPositionTimeOffset);
		tagByName.put("PlanePositionVolumeSequence",TagFromName.PlanePositionVolumeSequence);
		tagByName.put("PlaneOrientationVolumeSequence",TagFromName.PlaneOrientationVolumeSequence);
		tagByName.put("TemporalPositionSequence",TagFromName.TemporalPositionSequence);
		tagByName.put("DimensionOrganizationType",TagFromName.DimensionOrganizationType);
		tagByName.put("VolumeFrameOfReferenceUID",TagFromName.VolumeFrameOfReferenceUID);
		tagByName.put("TableFrameOfReferenceUID",TagFromName.TableFrameOfReferenceUID);
		tagByName.put("DimensionDescriptionLabel",TagFromName.DimensionDescriptionLabel);
		tagByName.put("PatientOrientationInFrameSequence",TagFromName.PatientOrientationInFrameSequence);
		tagByName.put("FrameLabel",TagFromName.FrameLabel);
		tagByName.put("AcquisitionIndex",TagFromName.AcquisitionIndex);
		tagByName.put("ContributingSOPInstancesReferenceSequence",TagFromName.ContributingSOPInstancesReferenceSequence);
		tagByName.put("ReconstructionIndex",TagFromName.ReconstructionIndex);
		tagByName.put("LightPathFilterPassThroughWavelength",TagFromName.LightPathFilterPassThroughWavelength);
		tagByName.put("LightPathFilterPassBand",TagFromName.LightPathFilterPassBand);
		tagByName.put("ImagePathFilterPassThroughWavelength",TagFromName.ImagePathFilterPassThroughWavelength);
		tagByName.put("ImagePathFilterPassBand",TagFromName.ImagePathFilterPassBand);
		tagByName.put("PatientEyeMovementCommanded",TagFromName.PatientEyeMovementCommanded);
		tagByName.put("PatientEyeMovementCommandedCodeSequence",TagFromName.PatientEyeMovementCommandedCodeSequence);
		tagByName.put("SphericalLensPower",TagFromName.SphericalLensPower);
		tagByName.put("CylinderLensPower",TagFromName.CylinderLensPower);
		tagByName.put("CylinderAxis",TagFromName.CylinderAxis);
		tagByName.put("EmmetropicMagnification",TagFromName.EmmetropicMagnification);
		tagByName.put("IntraOcularPressure",TagFromName.IntraOcularPressure);
		tagByName.put("HorizontalFieldOfView",TagFromName.HorizontalFieldOfView);
		tagByName.put("PupilDilated",TagFromName.PupilDilated);
		tagByName.put("DegreeOfDilation",TagFromName.DegreeOfDilation);
		tagByName.put("StereoBaselineAngle",TagFromName.StereoBaselineAngle);
		tagByName.put("StereoBaselineDisplacement",TagFromName.StereoBaselineDisplacement);
		tagByName.put("StereoHorizontalPixelOffset",TagFromName.StereoHorizontalPixelOffset);
		tagByName.put("StereoVerticalPixelOffset",TagFromName.StereoVerticalPixelOffset);
		tagByName.put("StereoRotation",TagFromName.StereoRotation);
		tagByName.put("AcquisitionDeviceTypeCodeSequence",TagFromName.AcquisitionDeviceTypeCodeSequence);
		tagByName.put("IlluminationTypeCodeSequence",TagFromName.IlluminationTypeCodeSequence);
		tagByName.put("LightPathFilterTypeStackCodeSequence",TagFromName.LightPathFilterTypeStackCodeSequence);
		tagByName.put("ImagePathFilterTypeStackCodeSequence",TagFromName.ImagePathFilterTypeStackCodeSequence);
		tagByName.put("LensesCodeSequence",TagFromName.LensesCodeSequence);
		tagByName.put("ChannelDescriptionCodeSequence",TagFromName.ChannelDescriptionCodeSequence);
		tagByName.put("RefractiveStateSequence",TagFromName.RefractiveStateSequence);
		tagByName.put("MydriaticAgentCodeSequence",TagFromName.MydriaticAgentCodeSequence);
		tagByName.put("RelativeImagePositionCodeSequence",TagFromName.RelativeImagePositionCodeSequence);
		tagByName.put("StereoPairsSequence",TagFromName.StereoPairsSequence);
		tagByName.put("LeftImageSequence",TagFromName.LeftImageSequence);
		tagByName.put("RightImageSequence",TagFromName.RightImageSequence);
		tagByName.put("AxialLengthOfEye",TagFromName.AxialLengthOfEye);
		tagByName.put("OphthalmicFrameLocationSequence",TagFromName.OphthalmicFrameLocationSequence);
		tagByName.put("ReferenceCoordinates",TagFromName.ReferenceCoordinates);
		tagByName.put("DepthSpatialResolution",TagFromName.DepthSpatialResolution);
		tagByName.put("MaximumDepthDistortion",TagFromName.MaximumDepthDistortion);
		tagByName.put("AlongScanSpatialResolution",TagFromName.AlongScanSpatialResolution);
		tagByName.put("MaximumAlongScanDistortion",TagFromName.MaximumAlongScanDistortion);
		tagByName.put("OphthalmicImageOrientation",TagFromName.OphthalmicImageOrientation);
		tagByName.put("DepthOfTransverseImage",TagFromName.DepthOfTransverseImage);
		tagByName.put("MydriaticAgentConcentrationUnitsSequence",TagFromName.MydriaticAgentConcentrationUnitsSequence);
		tagByName.put("AcrossScanSpatialResolution",TagFromName.AcrossScanSpatialResolution);
		tagByName.put("MaximumAcrossScanDistortion",TagFromName.MaximumAcrossScanDistortion);
		tagByName.put("MydriaticAgentConcentration",TagFromName.MydriaticAgentConcentration);
		tagByName.put("IlluminationWaveLength",TagFromName.IlluminationWaveLength);
		tagByName.put("IlluminationPower",TagFromName.IlluminationPower);
		tagByName.put("IlluminationBandwidth",TagFromName.IlluminationBandwidth);
		tagByName.put("MydriaticAgentSequence",TagFromName.MydriaticAgentSequence);
		tagByName.put("SamplesPerPixel",TagFromName.SamplesPerPixel);
		tagByName.put("SamplesPerPixelUsed",TagFromName.SamplesPerPixelUsed);
		tagByName.put("PhotometricInterpretation",TagFromName.PhotometricInterpretation);
		tagByName.put("ImageDimensions",TagFromName.ImageDimensions);
		tagByName.put("PlanarConfiguration",TagFromName.PlanarConfiguration);
		tagByName.put("NumberOfFrames",TagFromName.NumberOfFrames);
		tagByName.put("FrameIncrementPointer",TagFromName.FrameIncrementPointer);
		tagByName.put("FrameDimensionPointer",TagFromName.FrameDimensionPointer);
		tagByName.put("Rows",TagFromName.Rows);
		tagByName.put("Columns",TagFromName.Columns);
		tagByName.put("Planes",TagFromName.Planes);
		tagByName.put("UltrasoundColorDataPresent",TagFromName.UltrasoundColorDataPresent);
		tagByName.put("PixelSpacing",TagFromName.PixelSpacing);
		tagByName.put("ZoomFactor",TagFromName.ZoomFactor);
		tagByName.put("ZoomCenter",TagFromName.ZoomCenter);
		tagByName.put("PixelAspectRatio",TagFromName.PixelAspectRatio);
		tagByName.put("ImageFormat",TagFromName.ImageFormat);
		tagByName.put("ManipulatedImage",TagFromName.ManipulatedImage);
		tagByName.put("CorrectedImage",TagFromName.CorrectedImage);
		tagByName.put("CompressionRecognitionCode",TagFromName.CompressionRecognitionCode);
		tagByName.put("CompressionCode",TagFromName.CompressionCode);
		tagByName.put("CompressionOriginator",TagFromName.CompressionOriginator);
		tagByName.put("CompressionLabel",TagFromName.CompressionLabel);
		tagByName.put("CompressionDescription",TagFromName.CompressionDescription);
		tagByName.put("CompressionSequence",TagFromName.CompressionSequence);
		tagByName.put("CompressionStepPointers",TagFromName.CompressionStepPointers);
		tagByName.put("RepeatInterval",TagFromName.RepeatInterval);
		tagByName.put("BitsGrouped",TagFromName.BitsGrouped);
		tagByName.put("PerimeterTable",TagFromName.PerimeterTable);
		tagByName.put("PerimeterValue",TagFromName.PerimeterValue);
		tagByName.put("PredictorRows",TagFromName.PredictorRows);
		tagByName.put("PredictorColumns",TagFromName.PredictorColumns);
		tagByName.put("PredictorConstants",TagFromName.PredictorConstants);
		tagByName.put("BlockedPixels",TagFromName.BlockedPixels);
		tagByName.put("BlockRows",TagFromName.BlockRows);
		tagByName.put("BlockColumns",TagFromName.BlockColumns);
		tagByName.put("RowOverlap",TagFromName.RowOverlap);
		tagByName.put("ColumnOverlap",TagFromName.ColumnOverlap);
		tagByName.put("BitsAllocated",TagFromName.BitsAllocated);
		tagByName.put("BitsStored",TagFromName.BitsStored);
		tagByName.put("HighBit",TagFromName.HighBit);
		tagByName.put("PixelRepresentation",TagFromName.PixelRepresentation);
		tagByName.put("SmallestValidPixelValue",TagFromName.SmallestValidPixelValue);
		tagByName.put("LargestValidPixelValue",TagFromName.LargestValidPixelValue);
		tagByName.put("SmallestImagePixelValue",TagFromName.SmallestImagePixelValue);
		tagByName.put("LargestImagePixelValue",TagFromName.LargestImagePixelValue);
		tagByName.put("SmallestPixelValueInSeries",TagFromName.SmallestPixelValueInSeries);
		tagByName.put("LargestPixelValueInSeries",TagFromName.LargestPixelValueInSeries);
		tagByName.put("SmallestPixelValueInPlane",TagFromName.SmallestPixelValueInPlane);
		tagByName.put("LargestPixelValueInPlane",TagFromName.LargestPixelValueInPlane);
		tagByName.put("PixelPaddingValue",TagFromName.PixelPaddingValue);
		tagByName.put("PixelPaddingRangeLimit",TagFromName.PixelPaddingRangeLimit);
		tagByName.put("ImageLocation",TagFromName.ImageLocation);
		tagByName.put("QualityControlImage",TagFromName.QualityControlImage);
		tagByName.put("BurnedInAnnotation",TagFromName.BurnedInAnnotation);
		tagByName.put("TransformLabel",TagFromName.TransformLabel);
		tagByName.put("TransformVersionNumber",TagFromName.TransformVersionNumber);
		tagByName.put("SequenceOfCompressedData",TagFromName.SequenceOfCompressedData);
		tagByName.put("DCTLabel",TagFromName.DCTLabel);
		tagByName.put("DataBlockDescription",TagFromName.DataBlockDescription);
		tagByName.put("DataBlock",TagFromName.DataBlock);
		tagByName.put("NormalizationFactorFormat",TagFromName.NormalizationFactorFormat);
		tagByName.put("ZonalMapNumberFormat",TagFromName.ZonalMapNumberFormat);
		tagByName.put("ZonalMapLocation",TagFromName.ZonalMapLocation);
		tagByName.put("ZonalMapFormat",TagFromName.ZonalMapFormat);
		tagByName.put("AdaptiveMapFormat",TagFromName.AdaptiveMapFormat);
		tagByName.put("CodeNumberFormat",TagFromName.CodeNumberFormat);
		tagByName.put("PixelSpacingCalibrationType",TagFromName.PixelSpacingCalibrationType);
		tagByName.put("PixelSpacingCalibrationDescription",TagFromName.PixelSpacingCalibrationDescription);
		tagByName.put("PixelIntensityRelationship",TagFromName.PixelIntensityRelationship);
		tagByName.put("PixelIntensityRelationshipSign",TagFromName.PixelIntensityRelationshipSign);
		tagByName.put("WindowCenter",TagFromName.WindowCenter);
		tagByName.put("WindowWidth",TagFromName.WindowWidth);
		tagByName.put("RescaleIntercept",TagFromName.RescaleIntercept);
		tagByName.put("RescaleSlope",TagFromName.RescaleSlope);
		tagByName.put("RescaleType",TagFromName.RescaleType);
		tagByName.put("WindowCenterWidthExplanation",TagFromName.WindowCenterWidthExplanation);
		tagByName.put("VOILUTFunction",TagFromName.VOILUTFunction);
		tagByName.put("GrayScale",TagFromName.GrayScale);
		tagByName.put("RecommendedViewingMode",TagFromName.RecommendedViewingMode);
		tagByName.put("GrayLookupTableDescriptor",TagFromName.GrayLookupTableDescriptor);
		tagByName.put("RedPaletteColorLookupTableDescriptor",TagFromName.RedPaletteColorLookupTableDescriptor);
		tagByName.put("GreenPaletteColorLookupTableDescriptor",TagFromName.GreenPaletteColorLookupTableDescriptor);
		tagByName.put("BluePaletteColorLookupTableDescriptor",TagFromName.BluePaletteColorLookupTableDescriptor);
		tagByName.put("AlphaPaletteColorLookupTableDescriptor",TagFromName.AlphaPaletteColorLookupTableDescriptor);
		tagByName.put("LargeRedPaletteColorLookupTableDescriptor",TagFromName.LargeRedPaletteColorLookupTableDescriptor);
		tagByName.put("LargeGreenPaletteColorLookupTableDescriptor",TagFromName.LargeGreenPaletteColorLookupTableDescriptor);
		tagByName.put("LargeBluePaletteColorLookupTableDescriptor",TagFromName.LargeBluePaletteColorLookupTableDescriptor);
		tagByName.put("PaletteColorLookupTableUID",TagFromName.PaletteColorLookupTableUID);
		tagByName.put("GrayLookupTableData",TagFromName.GrayLookupTableData);
		tagByName.put("RedPaletteColorLookupTableData",TagFromName.RedPaletteColorLookupTableData);
		tagByName.put("GreenPaletteColorLookupTableData",TagFromName.GreenPaletteColorLookupTableData);
		tagByName.put("BluePaletteColorLookupTableData",TagFromName.BluePaletteColorLookupTableData);
		tagByName.put("AlphaPaletteColorLookupTableData",TagFromName.AlphaPaletteColorLookupTableData);
		tagByName.put("LargeRedPaletteColorLookupTableData",TagFromName.LargeRedPaletteColorLookupTableData);
		tagByName.put("LargeGreenPaletteColorLookupTableData",TagFromName.LargeGreenPaletteColorLookupTableData);
		tagByName.put("LargeBluePaletteColorLookupTableData",TagFromName.LargeBluePaletteColorLookupTableData);
		tagByName.put("LargePaletteColorLookupTableUID",TagFromName.LargePaletteColorLookupTableUID);
		tagByName.put("SegmentedRedPaletteColorLookupTableData",TagFromName.SegmentedRedPaletteColorLookupTableData);
		tagByName.put("SegmentedGreenPaletteColorLookupTableData",TagFromName.SegmentedGreenPaletteColorLookupTableData);
		tagByName.put("SegmentedBluePaletteColorLookupTableData",TagFromName.SegmentedBluePaletteColorLookupTableData);
		tagByName.put("BreastImplantPresent",TagFromName.BreastImplantPresent);
		tagByName.put("PartialView",TagFromName.PartialView);
		tagByName.put("PartialViewDescription",TagFromName.PartialViewDescription);
		tagByName.put("PartialViewCodeSequence",TagFromName.PartialViewCodeSequence);
		tagByName.put("SpatialLocationsPreserved",TagFromName.SpatialLocationsPreserved);
		tagByName.put("DataFrameAssignmentSequence",TagFromName.DataFrameAssignmentSequence);
		tagByName.put("DataPathAssignment",TagFromName.DataPathAssignment);
		tagByName.put("BitsMappedToColorLookupTable",TagFromName.BitsMappedToColorLookupTable);
		tagByName.put("BlendingLUT1Sequence",TagFromName.BlendingLUT1Sequence);
		tagByName.put("BlendingLUT1TransferFunction",TagFromName.BlendingLUT1TransferFunction);
		tagByName.put("BlendingWeightConstant",TagFromName.BlendingWeightConstant);
		tagByName.put("BlendingLookupTableDescriptor",TagFromName.BlendingLookupTableDescriptor);
		tagByName.put("BlendingLookupTableData",TagFromName.BlendingLookupTableData);
		tagByName.put("EnhancedPaletteColorLookupTableSequence",TagFromName.EnhancedPaletteColorLookupTableSequence);
		tagByName.put("BlendingLUT2Sequence",TagFromName.BlendingLUT2Sequence);
		tagByName.put("BlendingLUT2TransferFunction",TagFromName.BlendingLUT2TransferFunction);
		tagByName.put("DataPathID",TagFromName.DataPathID);
		tagByName.put("RGBLUTTransferFunction",TagFromName.RGBLUTTransferFunction);
		tagByName.put("AlphaLUTTransferFunction",TagFromName.AlphaLUTTransferFunction);
		tagByName.put("ICCProfile",TagFromName.ICCProfile);
		tagByName.put("LossyImageCompression",TagFromName.LossyImageCompression);
		tagByName.put("LossyImageCompressionRatio",TagFromName.LossyImageCompressionRatio);
		tagByName.put("LossyImageCompressionMethod",TagFromName.LossyImageCompressionMethod);
		tagByName.put("ModalityLUTSequence",TagFromName.ModalityLUTSequence);
		tagByName.put("LUTDescriptor",TagFromName.LUTDescriptor);
		tagByName.put("LUTExplanation",TagFromName.LUTExplanation);
		tagByName.put("ModalityLUTType",TagFromName.ModalityLUTType);
		tagByName.put("LUTData",TagFromName.LUTData);
		tagByName.put("VOILUTSequence",TagFromName.VOILUTSequence);
		tagByName.put("SoftcopyVOILUTSequence",TagFromName.SoftcopyVOILUTSequence);
		tagByName.put("ImagePresentationComments",TagFromName.ImagePresentationComments);
		tagByName.put("BiplaneAcquisitionSequence",TagFromName.BiplaneAcquisitionSequence);
		tagByName.put("RepresentativeFrameNumber",TagFromName.RepresentativeFrameNumber);
		tagByName.put("FrameNumbersOfInterest",TagFromName.FrameNumbersOfInterest);
		tagByName.put("FrameOfInterestDescription",TagFromName.FrameOfInterestDescription);
		tagByName.put("FrameOfInterestType",TagFromName.FrameOfInterestType);
		tagByName.put("MaskPointer",TagFromName.MaskPointer);
		tagByName.put("RWavePointer",TagFromName.RWavePointer);
		tagByName.put("MaskSubtractionSequence",TagFromName.MaskSubtractionSequence);
		tagByName.put("MaskOperation",TagFromName.MaskOperation);
		tagByName.put("ApplicableFrameRange",TagFromName.ApplicableFrameRange);
		tagByName.put("MaskFrameNumbers",TagFromName.MaskFrameNumbers);
		tagByName.put("ContrastFrameAveraging",TagFromName.ContrastFrameAveraging);
		tagByName.put("MaskSubPixelShift",TagFromName.MaskSubPixelShift);
		tagByName.put("TIDOffset",TagFromName.TIDOffset);
		tagByName.put("MaskOperationExplanation",TagFromName.MaskOperationExplanation);
		tagByName.put("PixelDataProviderURL",TagFromName.PixelDataProviderURL);
		tagByName.put("DataPointRows",TagFromName.DataPointRows);
		tagByName.put("DataPointColumns",TagFromName.DataPointColumns);
		tagByName.put("SignalDomainColumns",TagFromName.SignalDomainColumns);
		tagByName.put("LargestMonochromePixelValue",TagFromName.LargestMonochromePixelValue);
		tagByName.put("DataRepresentation",TagFromName.DataRepresentation);
		tagByName.put("PixelMeasuresSequence",TagFromName.PixelMeasuresSequence);
		tagByName.put("FrameVOILUTSequence",TagFromName.FrameVOILUTSequence);
		tagByName.put("PixelValueTransformationSequence",TagFromName.PixelValueTransformationSequence);
		tagByName.put("SignalDomainRows",TagFromName.SignalDomainRows);
		tagByName.put("DisplayFilterPercentage",TagFromName.DisplayFilterPercentage);
		tagByName.put("FramePixelShiftSequence",TagFromName.FramePixelShiftSequence);
		tagByName.put("SubtractionItemID",TagFromName.SubtractionItemID);
		tagByName.put("PixelIntensityRelationshipLUTSequence",TagFromName.PixelIntensityRelationshipLUTSequence);
		tagByName.put("FramePixelDataPropertiesSequence",TagFromName.FramePixelDataPropertiesSequence);
		tagByName.put("GeometricalProperties",TagFromName.GeometricalProperties);
		tagByName.put("GeometricMaximumDistortion",TagFromName.GeometricMaximumDistortion);
		tagByName.put("ImageProcessingApplied",TagFromName.ImageProcessingApplied);
		tagByName.put("MaskSelectionMode",TagFromName.MaskSelectionMode);
		tagByName.put("LUTFunction",TagFromName.LUTFunction);
		tagByName.put("MaskVisibilityPercentage",TagFromName.MaskVisibilityPercentage);
		tagByName.put("PixelShiftSequence",TagFromName.PixelShiftSequence);
		tagByName.put("RegionPixelShiftSequence",TagFromName.RegionPixelShiftSequence);
		tagByName.put("VerticesOfTheRegion",TagFromName.VerticesOfTheRegion);
		tagByName.put("MultiframePresentationSequence",TagFromName.MultiframePresentationSequence);
		tagByName.put("PixelShiftFrameRange",TagFromName.PixelShiftFrameRange);
		tagByName.put("LUTFrameRange",TagFromName.LUTFrameRange);
		tagByName.put("ImageToEquipmentMappingMatrix",TagFromName.ImageToEquipmentMappingMatrix);
		tagByName.put("EquipmentCoordinateSystemIdentification",TagFromName.EquipmentCoordinateSystemIdentification);
		tagByName.put("StudyStatusID",TagFromName.StudyStatusID);
		tagByName.put("StudyPriorityID",TagFromName.StudyPriorityID);
		tagByName.put("StudyIDIssuer",TagFromName.StudyIDIssuer);
		tagByName.put("StudyVerifiedDate",TagFromName.StudyVerifiedDate);
		tagByName.put("StudyVerifiedTime",TagFromName.StudyVerifiedTime);
		tagByName.put("StudyReadDate",TagFromName.StudyReadDate);
		tagByName.put("StudyReadTime",TagFromName.StudyReadTime);
		tagByName.put("ScheduledStudyStartDate",TagFromName.ScheduledStudyStartDate);
		tagByName.put("ScheduledStudyStartTime",TagFromName.ScheduledStudyStartTime);
		tagByName.put("ScheduledStudyStopDate",TagFromName.ScheduledStudyStopDate);
		tagByName.put("ScheduledStudyStopTime",TagFromName.ScheduledStudyStopTime);
		tagByName.put("ScheduledStudyLocation",TagFromName.ScheduledStudyLocation);
		tagByName.put("ScheduledStudyLocationAETitle",TagFromName.ScheduledStudyLocationAETitle);
		tagByName.put("ReasonForStudy",TagFromName.ReasonForStudy);
		tagByName.put("RequestingPhysicianIdentificationSequence",TagFromName.RequestingPhysicianIdentificationSequence);
		tagByName.put("RequestingPhysician",TagFromName.RequestingPhysician);
		tagByName.put("RequestingService",TagFromName.RequestingService);
		tagByName.put("StudyArrivalDate",TagFromName.StudyArrivalDate);
		tagByName.put("StudyArrivalTime",TagFromName.StudyArrivalTime);
		tagByName.put("StudyCompletionDate",TagFromName.StudyCompletionDate);
		tagByName.put("StudyCompletionTime",TagFromName.StudyCompletionTime);
		tagByName.put("StudyComponentStatusID",TagFromName.StudyComponentStatusID);
		tagByName.put("RequestedProcedureDescription",TagFromName.RequestedProcedureDescription);
		tagByName.put("RequestedProcedureCodeSequence",TagFromName.RequestedProcedureCodeSequence);
		tagByName.put("RequestedContrastAgent",TagFromName.RequestedContrastAgent);
		tagByName.put("StudyComments",TagFromName.StudyComments);
		tagByName.put("ReferencedPatientAliasSequence",TagFromName.ReferencedPatientAliasSequence);
		tagByName.put("VisitStatusID",TagFromName.VisitStatusID);
		tagByName.put("AdmissionID",TagFromName.AdmissionID);
		tagByName.put("IssuerOfAdmissionID",TagFromName.IssuerOfAdmissionID);
		tagByName.put("IssuerOfAdmissionIDSequence",TagFromName.IssuerOfAdmissionIDSequence);
		tagByName.put("RouteOfAdmissions",TagFromName.RouteOfAdmissions);
		tagByName.put("ScheduledAdmissionDate",TagFromName.ScheduledAdmissionDate);
		tagByName.put("ScheduledAdmissionTime",TagFromName.ScheduledAdmissionTime);
		tagByName.put("ScheduledDischargeDate",TagFromName.ScheduledDischargeDate);
		tagByName.put("ScheduledDischargeTime",TagFromName.ScheduledDischargeTime);
		tagByName.put("ScheduledPatientInstitutionResidence",TagFromName.ScheduledPatientInstitutionResidence);
		tagByName.put("AdmittingDate",TagFromName.AdmittingDate);
		tagByName.put("AdmittingTime",TagFromName.AdmittingTime);
		tagByName.put("DischargeDate",TagFromName.DischargeDate);
		tagByName.put("DischargeTime",TagFromName.DischargeTime);
		tagByName.put("DischargeDiagnosisDescription",TagFromName.DischargeDiagnosisDescription);
		tagByName.put("DischargeDiagnosisCodeSequence",TagFromName.DischargeDiagnosisCodeSequence);
		tagByName.put("SpecialNeeds",TagFromName.SpecialNeeds);
		tagByName.put("ServiceEpisodeID",TagFromName.ServiceEpisodeID);
		tagByName.put("IssuerOfServiceEpisodeID",TagFromName.IssuerOfServiceEpisodeID);
		tagByName.put("ServiceEpisodeDescription",TagFromName.ServiceEpisodeDescription);
		tagByName.put("IssuerOfServiceEpisodeIDSequence",TagFromName.IssuerOfServiceEpisodeIDSequence);
		tagByName.put("PertinentDocumentsSequence",TagFromName.PertinentDocumentsSequence);
		tagByName.put("CurrentPatientLocation",TagFromName.CurrentPatientLocation);
		tagByName.put("PatientInstitutionResidence",TagFromName.PatientInstitutionResidence);
		tagByName.put("PatientState",TagFromName.PatientState);
		tagByName.put("PatientClinicalTrialParticipationSequence",TagFromName.PatientClinicalTrialParticipationSequence);
		tagByName.put("VisitComments",TagFromName.VisitComments);
		tagByName.put("WaveformOriginality",TagFromName.WaveformOriginality);
		tagByName.put("NumberOfWaveformChannels",TagFromName.NumberOfWaveformChannels);
		tagByName.put("NumberOfWaveformSamples",TagFromName.NumberOfWaveformSamples);
		tagByName.put("SamplingFrequency",TagFromName.SamplingFrequency);
		tagByName.put("MultiplexGroupLabel",TagFromName.MultiplexGroupLabel);
		tagByName.put("ChannelDefinitionSequence",TagFromName.ChannelDefinitionSequence);
		tagByName.put("WaveformChannelNumber",TagFromName.WaveformChannelNumber);
		tagByName.put("ChannelLabel",TagFromName.ChannelLabel);
		tagByName.put("ChannelStatus",TagFromName.ChannelStatus);
		tagByName.put("ChannelSourceSequence",TagFromName.ChannelSourceSequence);
		tagByName.put("ChannelSourceModifiersSequence",TagFromName.ChannelSourceModifiersSequence);
		tagByName.put("SourceWaveformSequence",TagFromName.SourceWaveformSequence);
		tagByName.put("ChannelDerivationDescription",TagFromName.ChannelDerivationDescription);
		tagByName.put("ChannelSensitivity",TagFromName.ChannelSensitivity);
		tagByName.put("ChannelSensitivityUnitsSequence",TagFromName.ChannelSensitivityUnitsSequence);
		tagByName.put("ChannelSensitivityCorrectionFactor",TagFromName.ChannelSensitivityCorrectionFactor);
		tagByName.put("ChannelBaseline",TagFromName.ChannelBaseline);
		tagByName.put("ChannelTimeSkew",TagFromName.ChannelTimeSkew);
		tagByName.put("ChannelSampleSkew",TagFromName.ChannelSampleSkew);
		tagByName.put("ChannelOffset",TagFromName.ChannelOffset);
		tagByName.put("WaveformBitsStored",TagFromName.WaveformBitsStored);
		tagByName.put("FilterLowFrequency",TagFromName.FilterLowFrequency);
		tagByName.put("FilterHighFrequency",TagFromName.FilterHighFrequency);
		tagByName.put("NotchFilterFrequency",TagFromName.NotchFilterFrequency);
		tagByName.put("NotchFilterBandwidth",TagFromName.NotchFilterBandwidth);
		tagByName.put("WaveformDataDisplayScale",TagFromName.WaveformDataDisplayScale);
		tagByName.put("WaveformDisplayBackgroundCIELabValue",TagFromName.WaveformDisplayBackgroundCIELabValue);
		tagByName.put("WaveformPresentationGroupSequence",TagFromName.WaveformPresentationGroupSequence);
		tagByName.put("PresentationGroupNumber",TagFromName.PresentationGroupNumber);
		tagByName.put("ChannelDisplaySequence",TagFromName.ChannelDisplaySequence);
		tagByName.put("ChannelRecommendedDisplayCIELabValue",TagFromName.ChannelRecommendedDisplayCIELabValue);
		tagByName.put("ChannelPosition",TagFromName.ChannelPosition);
		tagByName.put("DisplayShadingFlag",TagFromName.DisplayShadingFlag);
		tagByName.put("FractionalChannelDisplayScale",TagFromName.FractionalChannelDisplayScale);
		tagByName.put("AbsoluteChannelDisplayScale",TagFromName.AbsoluteChannelDisplayScale);
		tagByName.put("MultiplexedAudioChannelsDescriptionCodeSequence",TagFromName.MultiplexedAudioChannelsDescriptionCodeSequence);
		tagByName.put("ChannelIdentificationCode",TagFromName.ChannelIdentificationCode);
		tagByName.put("ChannelMode",TagFromName.ChannelMode);
		tagByName.put("ScheduledStationAETitle",TagFromName.ScheduledStationAETitle);
		tagByName.put("ScheduledProcedureStepStartDate",TagFromName.ScheduledProcedureStepStartDate);
		tagByName.put("ScheduledProcedureStepStartTime",TagFromName.ScheduledProcedureStepStartTime);
		tagByName.put("ScheduledProcedureStepEndDate",TagFromName.ScheduledProcedureStepEndDate);
		tagByName.put("ScheduledProcedureStepEndTime",TagFromName.ScheduledProcedureStepEndTime);
		tagByName.put("ScheduledPerformingPhysicianName",TagFromName.ScheduledPerformingPhysicianName);
		tagByName.put("ScheduledProcedureStepDescription",TagFromName.ScheduledProcedureStepDescription);
		tagByName.put("ScheduledProtocolCodeSequence",TagFromName.ScheduledProtocolCodeSequence);
		tagByName.put("ScheduledProcedureStepID",TagFromName.ScheduledProcedureStepID);
		tagByName.put("StageCodeSequence",TagFromName.StageCodeSequence);
		tagByName.put("ScheduledPerformingPhysicianIdentificationSequence",TagFromName.ScheduledPerformingPhysicianIdentificationSequence);
		tagByName.put("ScheduledStationName",TagFromName.ScheduledStationName);
		tagByName.put("ScheduledProcedureStepLocation",TagFromName.ScheduledProcedureStepLocation);
		tagByName.put("PreMedication",TagFromName.PreMedication);
		tagByName.put("ScheduledProcedureStepStatus",TagFromName.ScheduledProcedureStepStatus);
		tagByName.put("OrderPlacerIdentifierSequence",TagFromName.OrderPlacerIdentifierSequence);
		tagByName.put("OrderFillerIdentifierSequence",TagFromName.OrderFillerIdentifierSequence);
		tagByName.put("LocalNamespaceEntityID",TagFromName.LocalNamespaceEntityID);
		tagByName.put("UniversalEntityID",TagFromName.UniversalEntityID);
		tagByName.put("UniversalEntityIDType",TagFromName.UniversalEntityIDType);
		tagByName.put("IdentifierTypeCode",TagFromName.IdentifierTypeCode);
		tagByName.put("AssigningFacilitySequence",TagFromName.AssigningFacilitySequence);
		tagByName.put("AssigningJurisdictionCodeSequence",TagFromName.AssigningJurisdictionCodeSequence);
		tagByName.put("AssigningAgencyOrDepartmentCodeSequence",TagFromName.AssigningAgencyOrDepartmentCodeSequence);
		tagByName.put("ScheduledProcedureStepSequence",TagFromName.ScheduledProcedureStepSequence);
		tagByName.put("ReferencedNonImageCompositeSOPInstanceSequence",TagFromName.ReferencedNonImageCompositeSOPInstanceSequence);
		tagByName.put("PerformedStationAETitle",TagFromName.PerformedStationAETitle);
		tagByName.put("PerformedStationName",TagFromName.PerformedStationName);
		tagByName.put("PerformedLocation",TagFromName.PerformedLocation);
		tagByName.put("PerformedProcedureStepStartDate",TagFromName.PerformedProcedureStepStartDate);
		tagByName.put("PerformedProcedureStepStartTime",TagFromName.PerformedProcedureStepStartTime);
		tagByName.put("PerformedProcedureStepEndDate",TagFromName.PerformedProcedureStepEndDate);
		tagByName.put("PerformedProcedureStepEndTime",TagFromName.PerformedProcedureStepEndTime);
		tagByName.put("PerformedProcedureStepStatus",TagFromName.PerformedProcedureStepStatus);
		tagByName.put("PerformedProcedureStepID",TagFromName.PerformedProcedureStepID);
		tagByName.put("PerformedProcedureStepDescription",TagFromName.PerformedProcedureStepDescription);
		tagByName.put("PerformedProcedureTypeDescription",TagFromName.PerformedProcedureTypeDescription);
		tagByName.put("PerformedProtocolCodeSequence",TagFromName.PerformedProtocolCodeSequence);
		tagByName.put("PerformedProtocolType",TagFromName.PerformedProtocolType);
		tagByName.put("ScheduledStepAttributesSequence",TagFromName.ScheduledStepAttributesSequence);
		tagByName.put("RequestAttributesSequence",TagFromName.RequestAttributesSequence);
		tagByName.put("CommentsOnPerformedProcedureStep",TagFromName.CommentsOnPerformedProcedureStep);
		tagByName.put("PerformedProcedureStepDiscontinuationReasonCodeSequence",TagFromName.PerformedProcedureStepDiscontinuationReasonCodeSequence);
		tagByName.put("QuantitySequence",TagFromName.QuantitySequence);
		tagByName.put("Quantity",TagFromName.Quantity);
		tagByName.put("MeasuringUnitsSequence",TagFromName.MeasuringUnitsSequence);
		tagByName.put("BillingItemSequence",TagFromName.BillingItemSequence);
		tagByName.put("TotalTimeOfFluoroscopy",TagFromName.TotalTimeOfFluoroscopy);
		tagByName.put("TotalNumberOfExposures",TagFromName.TotalNumberOfExposures);
		tagByName.put("EntranceDose",TagFromName.EntranceDose);
		tagByName.put("ExposedArea",TagFromName.ExposedArea);
		tagByName.put("DistanceSourceToEntrance",TagFromName.DistanceSourceToEntrance);
		tagByName.put("DistanceSourceToSupport",TagFromName.DistanceSourceToSupport);
		tagByName.put("ExposureDoseSequence",TagFromName.ExposureDoseSequence);
		tagByName.put("CommentsOnRadiationDose",TagFromName.CommentsOnRadiationDose);
		tagByName.put("XRayOutput",TagFromName.XRayOutput);
		tagByName.put("HalfValueLayer",TagFromName.HalfValueLayer);
		tagByName.put("OrganDose",TagFromName.OrganDose);
		tagByName.put("OrganExposed",TagFromName.OrganExposed);
		tagByName.put("BillingProcedureStepSequence",TagFromName.BillingProcedureStepSequence);
		tagByName.put("FilmConsumptionSequence",TagFromName.FilmConsumptionSequence);
		tagByName.put("BillingSuppliesAndDevicesSequence",TagFromName.BillingSuppliesAndDevicesSequence);
		tagByName.put("ReferencedProcedureStepSequence",TagFromName.ReferencedProcedureStepSequence);
		tagByName.put("PerformedSeriesSequence",TagFromName.PerformedSeriesSequence);
		tagByName.put("CommentsOnScheduledProcedureStep",TagFromName.CommentsOnScheduledProcedureStep);
		tagByName.put("ProtocolContextSequence",TagFromName.ProtocolContextSequence);
		tagByName.put("ContentItemModifierSequence",TagFromName.ContentItemModifierSequence);
		tagByName.put("ScheduledSpecimenSequence",TagFromName.ScheduledSpecimenSequence);
		tagByName.put("SpecimenAccessionNumber",TagFromName.SpecimenAccessionNumber);
		tagByName.put("ContainerIdentifier",TagFromName.ContainerIdentifier);
		tagByName.put("IssuerOfTheContainerIdentifierSequence",TagFromName.IssuerOfTheContainerIdentifierSequence);
		tagByName.put("AlternateContainerIdentifierSequence",TagFromName.AlternateContainerIdentifierSequence);
		tagByName.put("ContainerTypeCodeSequence",TagFromName.ContainerTypeCodeSequence);
		tagByName.put("ContainerDescription",TagFromName.ContainerDescription);
		tagByName.put("ContainerComponentSequence",TagFromName.ContainerComponentSequence);
		tagByName.put("SpecimenSequence",TagFromName.SpecimenSequence);
		tagByName.put("SpecimenIdentifier",TagFromName.SpecimenIdentifier);
		tagByName.put("SpecimenDescriptionSequenceTrial",TagFromName.SpecimenDescriptionSequenceTrial);
		tagByName.put("SpecimenDescriptionTrial",TagFromName.SpecimenDescriptionTrial);
		tagByName.put("SpecimenUID",TagFromName.SpecimenUID);
		tagByName.put("AcquisitionContextSequence",TagFromName.AcquisitionContextSequence);
		tagByName.put("AcquisitionContextDescription",TagFromName.AcquisitionContextDescription);
		tagByName.put("SpecimenDescriptionSequence",TagFromName.SpecimenDescriptionSequence);
		tagByName.put("IssuerOfTheSpecimenIdentifierSequence",TagFromName.IssuerOfTheSpecimenIdentifierSequence);
		tagByName.put("SpecimenTypeCodeSequence",TagFromName.SpecimenTypeCodeSequence);
		tagByName.put("SpecimenShortDescription",TagFromName.SpecimenShortDescription);
		tagByName.put("SpecimenDetailedDescription",TagFromName.SpecimenDetailedDescription);
		tagByName.put("SpecimenPreparationSequence",TagFromName.SpecimenPreparationSequence);
		tagByName.put("SpecimenPreparationStepContentItemSequence",TagFromName.SpecimenPreparationStepContentItemSequence);
		tagByName.put("SpecimenLocalizationContentItemSequence",TagFromName.SpecimenLocalizationContentItemSequence);
		tagByName.put("SlideIdentifier",TagFromName.SlideIdentifier);
		tagByName.put("ImageCenterPointCoordinatesSequence",TagFromName.ImageCenterPointCoordinatesSequence);
		tagByName.put("XOffsetInSlideCoordinateSystem",TagFromName.XOffsetInSlideCoordinateSystem);
		tagByName.put("YOffsetInSlideCoordinateSystem",TagFromName.YOffsetInSlideCoordinateSystem);
		tagByName.put("ZOffsetInSlideCoordinateSystem",TagFromName.ZOffsetInSlideCoordinateSystem);
		tagByName.put("PixelSpacingSequence",TagFromName.PixelSpacingSequence);
		tagByName.put("CoordinateSystemAxisCodeSequence",TagFromName.CoordinateSystemAxisCodeSequence);
		tagByName.put("MeasurementUnitsCodeSequence",TagFromName.MeasurementUnitsCodeSequence);
		tagByName.put("VitalStainCodeSequenceTrial",TagFromName.VitalStainCodeSequenceTrial);
		tagByName.put("RequestedProcedureID",TagFromName.RequestedProcedureID);
		tagByName.put("ReasonForRequestedProcedure",TagFromName.ReasonForRequestedProcedure);
		tagByName.put("RequestedProcedurePriority",TagFromName.RequestedProcedurePriority);
		tagByName.put("PatientTransportArrangements",TagFromName.PatientTransportArrangements);
		tagByName.put("RequestedProcedureLocation",TagFromName.RequestedProcedureLocation);
		tagByName.put("PlacerOrderNumberOfProcedure",TagFromName.PlacerOrderNumberOfProcedure);
		tagByName.put("FillerOrderNumberOfProcedure",TagFromName.FillerOrderNumberOfProcedure);
		tagByName.put("ConfidentialityCode",TagFromName.ConfidentialityCode);
		tagByName.put("ReportingPriority",TagFromName.ReportingPriority);
		tagByName.put("ReasonForRequestedProcedureCodeSequence",TagFromName.ReasonForRequestedProcedureCodeSequence);
		tagByName.put("NamesOfIntendedRecipientsOfResults",TagFromName.NamesOfIntendedRecipientsOfResults);
		tagByName.put("IntendedRecipientsOfResultsIdentificationSequence",TagFromName.IntendedRecipientsOfResultsIdentificationSequence);
		tagByName.put("PersonIdentificationCodeSequence",TagFromName.PersonIdentificationCodeSequence);
		tagByName.put("PersonAddress",TagFromName.PersonAddress);
		tagByName.put("PersonTelephoneNumbers",TagFromName.PersonTelephoneNumbers);
		tagByName.put("RequestedProcedureComments",TagFromName.RequestedProcedureComments);
		tagByName.put("ReasonForImagingServiceRequest",TagFromName.ReasonForImagingServiceRequest);
		tagByName.put("IssueDateOfImagingServiceRequest",TagFromName.IssueDateOfImagingServiceRequest);
		tagByName.put("IssueTimeOfImagingServiceRequest",TagFromName.IssueTimeOfImagingServiceRequest);
		tagByName.put("PlacerOrderNumberOfImagingServiceRequestRetired",TagFromName.PlacerOrderNumberOfImagingServiceRequestRetired);
		tagByName.put("FillerOrderNumberOfImagingServiceRequestRetired",TagFromName.FillerOrderNumberOfImagingServiceRequestRetired);
		tagByName.put("OrderEnteredBy",TagFromName.OrderEnteredBy);
		tagByName.put("OrderEntererLocation",TagFromName.OrderEntererLocation);
		tagByName.put("OrderCallbackPhoneNumber",TagFromName.OrderCallbackPhoneNumber);
		tagByName.put("PlacerOrderNumberOfImagingServiceRequest",TagFromName.PlacerOrderNumberOfImagingServiceRequest);
		tagByName.put("FillerOrderNumberOfImagingServiceRequest",TagFromName.FillerOrderNumberOfImagingServiceRequest);
		tagByName.put("ImagingServiceRequestComments",TagFromName.ImagingServiceRequestComments);
		tagByName.put("ConfidentialityConstraintOnPatientDataDescription",TagFromName.ConfidentialityConstraintOnPatientDataDescription);
		tagByName.put("GeneralPurposeScheduledProcedureStepStatus",TagFromName.GeneralPurposeScheduledProcedureStepStatus);
		tagByName.put("GeneralPurposePerformedProcedureStepStatus",TagFromName.GeneralPurposePerformedProcedureStepStatus);
		tagByName.put("GeneralPurposeScheduledProcedureStepPriority",TagFromName.GeneralPurposeScheduledProcedureStepPriority);
		tagByName.put("ScheduledProcessingApplicationsCodeSequence",TagFromName.ScheduledProcessingApplicationsCodeSequence);
		tagByName.put("ScheduledProcedureStepStartDateAndTime",TagFromName.ScheduledProcedureStepStartDateAndTime);
		tagByName.put("MultipleCopiesFlag",TagFromName.MultipleCopiesFlag);
		tagByName.put("PerformedProcessingApplicationsCodeSequence",TagFromName.PerformedProcessingApplicationsCodeSequence);
		tagByName.put("HumanPerformerCodeSequence",TagFromName.HumanPerformerCodeSequence);
		tagByName.put("ScheduledProcedureStepModificationDateAndTime",TagFromName.ScheduledProcedureStepModificationDateAndTime);
		tagByName.put("ExpectedCompletionDateAndTime",TagFromName.ExpectedCompletionDateAndTime);
		tagByName.put("ResultingGeneralPurposePerformedProcedureStepsSequence",TagFromName.ResultingGeneralPurposePerformedProcedureStepsSequence);
		tagByName.put("ReferencedGeneralPurposeScheduledProcedureStepSequence",TagFromName.ReferencedGeneralPurposeScheduledProcedureStepSequence);
		tagByName.put("ScheduledWorkitemCodeSequence",TagFromName.ScheduledWorkitemCodeSequence);
		tagByName.put("PerformedWorkitemCodeSequence",TagFromName.PerformedWorkitemCodeSequence);
		tagByName.put("InputAvailabilityFlag",TagFromName.InputAvailabilityFlag);
		tagByName.put("InputInformationSequence",TagFromName.InputInformationSequence);
		tagByName.put("RelevantInformationSequence",TagFromName.RelevantInformationSequence);
		tagByName.put("ReferencedGeneralPurposeScheduledProcedureStepTransactionUID",TagFromName.ReferencedGeneralPurposeScheduledProcedureStepTransactionUID);
		tagByName.put("ScheduledStationNameCodeSequence",TagFromName.ScheduledStationNameCodeSequence);
		tagByName.put("ScheduledStationClassCodeSequence",TagFromName.ScheduledStationClassCodeSequence);
		tagByName.put("ScheduledStationGeographicLocationCodeSequence",TagFromName.ScheduledStationGeographicLocationCodeSequence);
		tagByName.put("PerformedStationNameCodeSequence",TagFromName.PerformedStationNameCodeSequence);
		tagByName.put("PerformedStationClassCodeSequence",TagFromName.PerformedStationClassCodeSequence);
		tagByName.put("PerformedStationGeographicLocationCodeSequence",TagFromName.PerformedStationGeographicLocationCodeSequence);
		tagByName.put("RequestedSubsequentWorkitemCodeSequence",TagFromName.RequestedSubsequentWorkitemCodeSequence);
		tagByName.put("NonDICOMOutputCodeSequence",TagFromName.NonDICOMOutputCodeSequence);
		tagByName.put("OutputInformationSequence",TagFromName.OutputInformationSequence);
		tagByName.put("ScheduledHumanPerformersSequence",TagFromName.ScheduledHumanPerformersSequence);
		tagByName.put("ActualHumanPerformersSequence",TagFromName.ActualHumanPerformersSequence);
		tagByName.put("HumanPerformersOrganization",TagFromName.HumanPerformersOrganization);
		tagByName.put("HumanPerformersName",TagFromName.HumanPerformersName);
		tagByName.put("EntranceDoseInmGy",TagFromName.EntranceDoseInmGy);
		tagByName.put("ReferencedImageRealWorldValueMappingSequence",TagFromName.ReferencedImageRealWorldValueMappingSequence);
		tagByName.put("RealWorldValueMappingSequence",TagFromName.RealWorldValueMappingSequence);
		tagByName.put("PixelValueMappingCodeSequence",TagFromName.PixelValueMappingCodeSequence);
		tagByName.put("LUTLabel",TagFromName.LUTLabel);
		tagByName.put("RealWorldValueLastValueMapped",TagFromName.RealWorldValueLastValueMapped);
		tagByName.put("RealWorldValueLUTData",TagFromName.RealWorldValueLUTData);
		tagByName.put("RealWorldValueFirstValueMapped",TagFromName.RealWorldValueFirstValueMapped);
		tagByName.put("RealWorldValueIntercept",TagFromName.RealWorldValueIntercept);
		tagByName.put("RealWorldValueSlope",TagFromName.RealWorldValueSlope);
		tagByName.put("FindingsFlagTrial",TagFromName.FindingsFlagTrial);
		tagByName.put("RelationshipType",TagFromName.RelationshipType);
		tagByName.put("FindingsSequenceTrial",TagFromName.FindingsSequenceTrial);
		tagByName.put("FindingsGroupUIDTrial",TagFromName.FindingsGroupUIDTrial);
		tagByName.put("ReferencedFindingsGroupUIDTrial",TagFromName.ReferencedFindingsGroupUIDTrial);
		tagByName.put("FindingsGroupRecordingDateTrial",TagFromName.FindingsGroupRecordingDateTrial);
		tagByName.put("FindingsGroupRecordingTimeTrial",TagFromName.FindingsGroupRecordingTimeTrial);
		tagByName.put("FindingsSourceCategoryCodeSequenceTrial",TagFromName.FindingsSourceCategoryCodeSequenceTrial);
		tagByName.put("VerifyingOrganization",TagFromName.VerifyingOrganization);
		tagByName.put("DocumentingOrganizationIdentifierCodeSequenceTrial",TagFromName.DocumentingOrganizationIdentifierCodeSequenceTrial);
		tagByName.put("VerificationDateTime",TagFromName.VerificationDateTime);
		tagByName.put("ObservationDateTime",TagFromName.ObservationDateTime);
		tagByName.put("ValueType",TagFromName.ValueType);
		tagByName.put("ConceptNameCodeSequence",TagFromName.ConceptNameCodeSequence);
		tagByName.put("MeasurementPrecisionDescriptionTrial",TagFromName.MeasurementPrecisionDescriptionTrial);
		tagByName.put("ContinuityOfContent",TagFromName.ContinuityOfContent);
		tagByName.put("UrgencyOrPriorityAlertsTrial",TagFromName.UrgencyOrPriorityAlertsTrial);
		tagByName.put("SequencingIndicatorTrial",TagFromName.SequencingIndicatorTrial);
		tagByName.put("DocumentIdentifierCodeSequenceTrial",TagFromName.DocumentIdentifierCodeSequenceTrial);
		tagByName.put("DocumentAuthorTrial",TagFromName.DocumentAuthorTrial);
		tagByName.put("DocumentAuthorIdentifierCodeSequenceTrial",TagFromName.DocumentAuthorIdentifierCodeSequenceTrial);
		tagByName.put("IdentifierCodeSequenceTrial",TagFromName.IdentifierCodeSequenceTrial);
		tagByName.put("VerifyingObserverSequence",TagFromName.VerifyingObserverSequence);
		tagByName.put("ObjectBinaryIdentifierTrial",TagFromName.ObjectBinaryIdentifierTrial);
		tagByName.put("VerifyingObserverName",TagFromName.VerifyingObserverName);
		tagByName.put("DocumentingObserverIdentifierCodeSequenceTrial",TagFromName.DocumentingObserverIdentifierCodeSequenceTrial);
		tagByName.put("AuthorObserverSequence",TagFromName.AuthorObserverSequence);
		tagByName.put("ParticipantSequence",TagFromName.ParticipantSequence);
		tagByName.put("CustodialOrganizationSequence",TagFromName.CustodialOrganizationSequence);
		tagByName.put("ParticipationType",TagFromName.ParticipationType);
		tagByName.put("ParticipationDateTime",TagFromName.ParticipationDateTime);
		tagByName.put("ObserverType",TagFromName.ObserverType);
		tagByName.put("ProcedureIdentifierCodeSequenceTrial",TagFromName.ProcedureIdentifierCodeSequenceTrial);
		tagByName.put("VerifyingObserverIdentificationCodeSequence",TagFromName.VerifyingObserverIdentificationCodeSequence);
		tagByName.put("ObjectDirectoryBinaryIdentifierTrial",TagFromName.ObjectDirectoryBinaryIdentifierTrial);
		tagByName.put("EquivalentCDADocumentSequence",TagFromName.EquivalentCDADocumentSequence);
		tagByName.put("ReferencedWaveformChannels",TagFromName.ReferencedWaveformChannels);
		tagByName.put("DateOfDocumentOrVerbalTransactionTrial",TagFromName.DateOfDocumentOrVerbalTransactionTrial);
		tagByName.put("TimeOfDocumentCreationOrVerbalTransactionTrial",TagFromName.TimeOfDocumentCreationOrVerbalTransactionTrial);
		tagByName.put("DateTime",TagFromName.DateTime);
		tagByName.put("Date",TagFromName.Date);
		tagByName.put("Time",TagFromName.Time);
		tagByName.put("PersonName",TagFromName.PersonName);
		tagByName.put("UID",TagFromName.UID);
		tagByName.put("ReportStatusIDTrial",TagFromName.ReportStatusIDTrial);
		tagByName.put("TemporalRangeType",TagFromName.TemporalRangeType);
		tagByName.put("ReferencedSamplePositions",TagFromName.ReferencedSamplePositions);
		tagByName.put("ReferencedFrameNumbers",TagFromName.ReferencedFrameNumbers);
		tagByName.put("ReferencedTimeOffsets",TagFromName.ReferencedTimeOffsets);
		tagByName.put("ReferencedDateTime",TagFromName.ReferencedDateTime);
		tagByName.put("TextValue",TagFromName.TextValue);
		tagByName.put("ObservationCategoryCodeSequenceTrial",TagFromName.ObservationCategoryCodeSequenceTrial);
		tagByName.put("ConceptCodeSequence",TagFromName.ConceptCodeSequence);
		tagByName.put("BibliographicCitationTrial",TagFromName.BibliographicCitationTrial);
		tagByName.put("PurposeOfReferenceCodeSequence",TagFromName.PurposeOfReferenceCodeSequence);
		tagByName.put("ObservationUIDTrial",TagFromName.ObservationUIDTrial);
		tagByName.put("ReferencedObservationUIDTrial",TagFromName.ReferencedObservationUIDTrial);
		tagByName.put("ReferencedObservationClassTrial",TagFromName.ReferencedObservationClassTrial);
		tagByName.put("ReferencedObjectObservationClassTrial",TagFromName.ReferencedObjectObservationClassTrial);
		tagByName.put("AnnotationGroupNumber",TagFromName.AnnotationGroupNumber);
		tagByName.put("ObservationDateTrial",TagFromName.ObservationDateTrial);
		tagByName.put("ObservationTimeTrial",TagFromName.ObservationTimeTrial);
		tagByName.put("MeasurementAutomationTrial",TagFromName.MeasurementAutomationTrial);
		tagByName.put("ModifierCodeSequence",TagFromName.ModifierCodeSequence);
		tagByName.put("IdentificationDescriptionTrial",TagFromName.IdentificationDescriptionTrial);
		tagByName.put("CoordinatesSetGeometricTypeTrial",TagFromName.CoordinatesSetGeometricTypeTrial);
		tagByName.put("AlgorithmCodeSequenceTrial",TagFromName.AlgorithmCodeSequenceTrial);
		tagByName.put("AlgorithmDescriptionTrial",TagFromName.AlgorithmDescriptionTrial);
		tagByName.put("PixelCoordinatesSetTrial",TagFromName.PixelCoordinatesSetTrial);
		tagByName.put("MeasuredValueSequence",TagFromName.MeasuredValueSequence);
		tagByName.put("NumericValueQualifierCodeSequence",TagFromName.NumericValueQualifierCodeSequence);
		tagByName.put("CurrentObserverTrial",TagFromName.CurrentObserverTrial);
		tagByName.put("NumericValue",TagFromName.NumericValue);
		tagByName.put("ReferencedAccessionSequenceTrial",TagFromName.ReferencedAccessionSequenceTrial);
		tagByName.put("ReportStatusCommentTrial",TagFromName.ReportStatusCommentTrial);
		tagByName.put("ProcedureContextSequenceTrial",TagFromName.ProcedureContextSequenceTrial);
		tagByName.put("VerbalSourceTrial",TagFromName.VerbalSourceTrial);
		tagByName.put("AddressTrial",TagFromName.AddressTrial);
		tagByName.put("TelephoneNumberTrial",TagFromName.TelephoneNumberTrial);
		tagByName.put("VerbalSourceIdentifierCodeSequenceTrial",TagFromName.VerbalSourceIdentifierCodeSequenceTrial);
		tagByName.put("PredecessorDocumentsSequence",TagFromName.PredecessorDocumentsSequence);
		tagByName.put("ReferencedRequestSequence",TagFromName.ReferencedRequestSequence);
		tagByName.put("PerformedProcedureCodeSequence",TagFromName.PerformedProcedureCodeSequence);
		tagByName.put("CurrentRequestedProcedureEvidenceSequence",TagFromName.CurrentRequestedProcedureEvidenceSequence);
		tagByName.put("ReportDetailSequenceTrial",TagFromName.ReportDetailSequenceTrial);
		tagByName.put("PertinentOtherEvidenceSequence",TagFromName.PertinentOtherEvidenceSequence);
		tagByName.put("HL7StructuredDocumentReferenceSequence",TagFromName.HL7StructuredDocumentReferenceSequence);
		tagByName.put("ObservationSubjectUIDTrial",TagFromName.ObservationSubjectUIDTrial);
		tagByName.put("ObservationSubjectClassTrial",TagFromName.ObservationSubjectClassTrial);
		tagByName.put("ObservationSubjectTypeCodeSequenceTrial",TagFromName.ObservationSubjectTypeCodeSequenceTrial);
		tagByName.put("CompletionFlag",TagFromName.CompletionFlag);
		tagByName.put("CompletionFlagDescription",TagFromName.CompletionFlagDescription);
		tagByName.put("VerificationFlag",TagFromName.VerificationFlag);
		tagByName.put("ArchiveRequested",TagFromName.ArchiveRequested);
		tagByName.put("PreliminaryFlag",TagFromName.PreliminaryFlag);
		tagByName.put("ContentTemplateSequence",TagFromName.ContentTemplateSequence);
		tagByName.put("IdenticalDocumentsSequence",TagFromName.IdenticalDocumentsSequence);
		tagByName.put("ObservationSubjectContextFlagTrial",TagFromName.ObservationSubjectContextFlagTrial);
		tagByName.put("ObserverContextFlagTrial",TagFromName.ObserverContextFlagTrial);
		tagByName.put("ProcedureContextFlagTrial",TagFromName.ProcedureContextFlagTrial);
		tagByName.put("ContentSequence",TagFromName.ContentSequence);
		tagByName.put("RelationshipSequenceTrial",TagFromName.RelationshipSequenceTrial);
		tagByName.put("RelationshipTypeCodeSequenceTrial",TagFromName.RelationshipTypeCodeSequenceTrial);
		tagByName.put("LanguageCodeSequenceTrial",TagFromName.LanguageCodeSequenceTrial);
		tagByName.put("UniformResourceLocatorTrial",TagFromName.UniformResourceLocatorTrial);
		tagByName.put("WaveformAnnotationSequence",TagFromName.WaveformAnnotationSequence);
		tagByName.put("TemplateIdentifier",TagFromName.TemplateIdentifier);
		tagByName.put("TemplateVersion",TagFromName.TemplateVersion);
		tagByName.put("TemplateLocalVersion",TagFromName.TemplateLocalVersion);
		tagByName.put("TemplateExtensionFlag",TagFromName.TemplateExtensionFlag);
		tagByName.put("TemplateExtensionOrganizationUID",TagFromName.TemplateExtensionOrganizationUID);
		tagByName.put("TemplateExtensionCreatorUID",TagFromName.TemplateExtensionCreatorUID);
		tagByName.put("RelationshipTypeCodeSequenceModifierTrial",TagFromName.RelationshipTypeCodeSequenceModifierTrial);
		tagByName.put("ReferencedContentItemIdentifier",TagFromName.ReferencedContentItemIdentifier);
		tagByName.put("HL7InstanceIdentifier",TagFromName.HL7InstanceIdentifier);
		tagByName.put("HL7DocumentEffectiveTime",TagFromName.HL7DocumentEffectiveTime);
		tagByName.put("HL7DocumentTypeCodeSequence",TagFromName.HL7DocumentTypeCodeSequence);
		tagByName.put("RetrieveURI",TagFromName.RetrieveURI);
		tagByName.put("RetrieveLocationUID",TagFromName.RetrieveLocationUID);
		tagByName.put("DocumentTitle",TagFromName.DocumentTitle);
		tagByName.put("EncapsulatedDocument",TagFromName.EncapsulatedDocument);
		tagByName.put("MIMETypeOfEncapsulatedDocument",TagFromName.MIMETypeOfEncapsulatedDocument);
		tagByName.put("SourceInstanceSequence",TagFromName.SourceInstanceSequence);
		tagByName.put("ListOfMIMETypes",TagFromName.ListOfMIMETypes);
		tagByName.put("ProductPackageIdentifier",TagFromName.ProductPackageIdentifier);
		tagByName.put("SubstanceAdministrationApproval",TagFromName.SubstanceAdministrationApproval);
		tagByName.put("ApprovalStatusFurtherDescription",TagFromName.ApprovalStatusFurtherDescription);
		tagByName.put("ApprovalStatusDateTime",TagFromName.ApprovalStatusDateTime);
		tagByName.put("ProductTypeCodeSequence",TagFromName.ProductTypeCodeSequence);
		tagByName.put("ProductName",TagFromName.ProductName);
		tagByName.put("ProductDescription",TagFromName.ProductDescription);
		tagByName.put("ProductLotIdentifier",TagFromName.ProductLotIdentifier);
		tagByName.put("ProductExpirationDateTime",TagFromName.ProductExpirationDateTime);
		tagByName.put("SubstanceAdministrationDateTime",TagFromName.SubstanceAdministrationDateTime);
		tagByName.put("SubstanceAdministrationNotes",TagFromName.SubstanceAdministrationNotes);
		tagByName.put("SubstanceAdministrationDeviceID",TagFromName.SubstanceAdministrationDeviceID);
		tagByName.put("ProductParameterSequence",TagFromName.ProductParameterSequence);
		tagByName.put("SubstanceAdministrationParameterSequence",TagFromName.SubstanceAdministrationParameterSequence);
		tagByName.put("LensDescription",TagFromName.LensDescription);
		tagByName.put("RightLensSequence",TagFromName.RightLensSequence);
		tagByName.put("LeftLensSequence",TagFromName.LeftLensSequence);
		tagByName.put("UnspecifiedLateralityLensSequence",TagFromName.UnspecifiedLateralityLensSequence);
		tagByName.put("CylinderSequence",TagFromName.CylinderSequence);
		tagByName.put("PrismSequence",TagFromName.PrismSequence);
		tagByName.put("HorizontalPrismPower",TagFromName.HorizontalPrismPower);
		tagByName.put("HorizontalPrismBase",TagFromName.HorizontalPrismBase);
		tagByName.put("VerticalPrismPower",TagFromName.VerticalPrismPower);
		tagByName.put("VerticalPrismBase",TagFromName.VerticalPrismBase);
		tagByName.put("LensSegmentType",TagFromName.LensSegmentType);
		tagByName.put("OpticalTransmittance",TagFromName.OpticalTransmittance);
		tagByName.put("ChannelWidth",TagFromName.ChannelWidth);
		tagByName.put("PupilSize",TagFromName.PupilSize);
		tagByName.put("CornealSize",TagFromName.CornealSize);
		tagByName.put("AutorefractionRightEyeSequence",TagFromName.AutorefractionRightEyeSequence);
		tagByName.put("AutorefractionLeftEyeSequence",TagFromName.AutorefractionLeftEyeSequence);
		tagByName.put("DistancePupillaryDistance",TagFromName.DistancePupillaryDistance);
		tagByName.put("NearPupillaryDistance",TagFromName.NearPupillaryDistance);
		tagByName.put("IntermediatePupillaryDistance",TagFromName.IntermediatePupillaryDistance);
		tagByName.put("OtherPupillaryDistance",TagFromName.OtherPupillaryDistance);
		tagByName.put("KeratometryRightEyeSequence",TagFromName.KeratometryRightEyeSequence);
		tagByName.put("KeratometryLeftEyeSequence",TagFromName.KeratometryLeftEyeSequence);
		tagByName.put("SteepKeratometricAxisSequence",TagFromName.SteepKeratometricAxisSequence);
		tagByName.put("RadiusOfCurvature",TagFromName.RadiusOfCurvature);
		tagByName.put("KeratometricPower",TagFromName.KeratometricPower);
		tagByName.put("KeratometricAxis",TagFromName.KeratometricAxis);
		tagByName.put("FlatKeratometricAxisSequence",TagFromName.FlatKeratometricAxisSequence);
		tagByName.put("BackgroundColor",TagFromName.BackgroundColor);
		tagByName.put("Optotype",TagFromName.Optotype);
		tagByName.put("OptotypePresentation",TagFromName.OptotypePresentation);
		tagByName.put("SubjectiveRefractionRightEyeSequence",TagFromName.SubjectiveRefractionRightEyeSequence);
		tagByName.put("SubjectiveRefractionLeftEyeSequence",TagFromName.SubjectiveRefractionLeftEyeSequence);
		tagByName.put("AddNearSequence",TagFromName.AddNearSequence);
		tagByName.put("AddIntermediateSequence",TagFromName.AddIntermediateSequence);
		tagByName.put("AddOtherSequence",TagFromName.AddOtherSequence);
		tagByName.put("AddPower",TagFromName.AddPower);
		tagByName.put("ViewingDistance",TagFromName.ViewingDistance);
		tagByName.put("VisualAcuityTypeCodeSequence",TagFromName.VisualAcuityTypeCodeSequence);
		tagByName.put("VisualAcuityRightEyeSequence",TagFromName.VisualAcuityRightEyeSequence);
		tagByName.put("VisualAcuityLeftEyeSequence",TagFromName.VisualAcuityLeftEyeSequence);
		tagByName.put("VisualAcuityBothEyesOpenSequence",TagFromName.VisualAcuityBothEyesOpenSequence);
		tagByName.put("ViewingDistanceType",TagFromName.ViewingDistanceType);
		tagByName.put("VisualAcuityModifiers",TagFromName.VisualAcuityModifiers);
		tagByName.put("DecimalVisualAcuity",TagFromName.DecimalVisualAcuity);
		tagByName.put("OptotypeDetailedDefinition",TagFromName.OptotypeDetailedDefinition);
		tagByName.put("ReferencedRefractiveMeasurementsSequence",TagFromName.ReferencedRefractiveMeasurementsSequence);
		tagByName.put("SpherePower",TagFromName.SpherePower);
		tagByName.put("CylinderPower",TagFromName.CylinderPower);
		tagByName.put("CalibrationImage",TagFromName.CalibrationImage);
		tagByName.put("DeviceSequence",TagFromName.DeviceSequence);
		tagByName.put("ContainerComponentTypeCodeSequence",TagFromName.ContainerComponentTypeCodeSequence);
		tagByName.put("ContainerComponentThickness",TagFromName.ContainerComponentThickness);
		tagByName.put("DeviceLength",TagFromName.DeviceLength);
		tagByName.put("ContainerComponentWidth",TagFromName.ContainerComponentWidth);
		tagByName.put("DeviceDiameter",TagFromName.DeviceDiameter);
		tagByName.put("DeviceDiameterUnits",TagFromName.DeviceDiameterUnits);
		tagByName.put("DeviceVolume",TagFromName.DeviceVolume);
		tagByName.put("InterMarkerDistance",TagFromName.InterMarkerDistance);
		tagByName.put("ContainerComponentMaterial",TagFromName.ContainerComponentMaterial);
		tagByName.put("ContainerComponentID",TagFromName.ContainerComponentID);
		tagByName.put("ContainerComponentLength",TagFromName.ContainerComponentLength);
		tagByName.put("ContainerComponentDiameter",TagFromName.ContainerComponentDiameter);
		tagByName.put("ContainerComponentDescription",TagFromName.ContainerComponentDescription);
		tagByName.put("DeviceDescription",TagFromName.DeviceDescription);
		tagByName.put("EnergyWindowVector",TagFromName.EnergyWindowVector);
		tagByName.put("NumberOfEnergyWindows",TagFromName.NumberOfEnergyWindows);
		tagByName.put("EnergyWindowInformationSequence",TagFromName.EnergyWindowInformationSequence);
		tagByName.put("EnergyWindowRangeSequence",TagFromName.EnergyWindowRangeSequence);
		tagByName.put("EnergyWindowLowerLimit",TagFromName.EnergyWindowLowerLimit);
		tagByName.put("EnergyWindowUpperLimit",TagFromName.EnergyWindowUpperLimit);
		tagByName.put("RadiopharmaceuticalInformationSequence",TagFromName.RadiopharmaceuticalInformationSequence);
		tagByName.put("ResidualSyringeCounts",TagFromName.ResidualSyringeCounts);
		tagByName.put("EnergyWindowName",TagFromName.EnergyWindowName);
		tagByName.put("DetectorVector",TagFromName.DetectorVector);
		tagByName.put("NumberOfDetectors",TagFromName.NumberOfDetectors);
		tagByName.put("DetectorInformationSequence",TagFromName.DetectorInformationSequence);
		tagByName.put("PhaseVector",TagFromName.PhaseVector);
		tagByName.put("NumberOfPhases",TagFromName.NumberOfPhases);
		tagByName.put("PhaseInformationSequence",TagFromName.PhaseInformationSequence);
		tagByName.put("NumberOfFramesInPhase",TagFromName.NumberOfFramesInPhase);
		tagByName.put("PhaseDelay",TagFromName.PhaseDelay);
		tagByName.put("PauseBetweenFrames",TagFromName.PauseBetweenFrames);
		tagByName.put("PhaseDescription",TagFromName.PhaseDescription);
		tagByName.put("RotationVector",TagFromName.RotationVector);
		tagByName.put("NumberOfRotations",TagFromName.NumberOfRotations);
		tagByName.put("RotationInformationSequence",TagFromName.RotationInformationSequence);
		tagByName.put("NumberOfFramesInRotation",TagFromName.NumberOfFramesInRotation);
		tagByName.put("RRIntervalVector",TagFromName.RRIntervalVector);
		tagByName.put("NumberOfRRIntervals",TagFromName.NumberOfRRIntervals);
		tagByName.put("GatedInformationSequence",TagFromName.GatedInformationSequence);
		tagByName.put("DataInformationSequence",TagFromName.DataInformationSequence);
		tagByName.put("TimeSlotVector",TagFromName.TimeSlotVector);
		tagByName.put("NumberOfTimeSlots",TagFromName.NumberOfTimeSlots);
		tagByName.put("TimeSlotInformationSequence",TagFromName.TimeSlotInformationSequence);
		tagByName.put("TimeSlotTime",TagFromName.TimeSlotTime);
		tagByName.put("SliceVector",TagFromName.SliceVector);
		tagByName.put("NumberOfSlices",TagFromName.NumberOfSlices);
		tagByName.put("AngularViewVector",TagFromName.AngularViewVector);
		tagByName.put("TimeSliceVector",TagFromName.TimeSliceVector);
		tagByName.put("NumberOfTimeSlices",TagFromName.NumberOfTimeSlices);
		tagByName.put("StartAngle",TagFromName.StartAngle);
		tagByName.put("TypeOfDetectorMotion",TagFromName.TypeOfDetectorMotion);
		tagByName.put("TriggerVector",TagFromName.TriggerVector);
		tagByName.put("NumberOfTriggersInPhase",TagFromName.NumberOfTriggersInPhase);
		tagByName.put("ViewCodeSequence",TagFromName.ViewCodeSequence);
		tagByName.put("ViewModifierCodeSequence",TagFromName.ViewModifierCodeSequence);
		tagByName.put("RadionuclideCodeSequence",TagFromName.RadionuclideCodeSequence);
		tagByName.put("AdministrationRouteCodeSequence",TagFromName.AdministrationRouteCodeSequence);
		tagByName.put("RadiopharmaceuticalCodeSequence",TagFromName.RadiopharmaceuticalCodeSequence);
		tagByName.put("CalibrationDataSequence",TagFromName.CalibrationDataSequence);
		tagByName.put("EnergyWindowNumber",TagFromName.EnergyWindowNumber);
		tagByName.put("ImageID",TagFromName.ImageID);
		tagByName.put("PatientOrientationCodeSequence",TagFromName.PatientOrientationCodeSequence);
		tagByName.put("PatientOrientationModifierCodeSequence",TagFromName.PatientOrientationModifierCodeSequence);
		tagByName.put("PatientGantryRelationshipCodeSequence",TagFromName.PatientGantryRelationshipCodeSequence);
		tagByName.put("SliceProgressionDirection",TagFromName.SliceProgressionDirection);
		tagByName.put("SeriesType",TagFromName.SeriesType);
		tagByName.put("Units",TagFromName.Units);
		tagByName.put("CountsSource",TagFromName.CountsSource);
		tagByName.put("ReprojectionMethod",TagFromName.ReprojectionMethod);
		tagByName.put("RandomsCorrectionMethod",TagFromName.RandomsCorrectionMethod);
		tagByName.put("AttenuationCorrectionMethod",TagFromName.AttenuationCorrectionMethod);
		tagByName.put("DecayCorrection",TagFromName.DecayCorrection);
		tagByName.put("ReconstructionMethod",TagFromName.ReconstructionMethod);
		tagByName.put("DetectorLinesOfResponseUsed",TagFromName.DetectorLinesOfResponseUsed);
		tagByName.put("ScatterCorrectionMethod",TagFromName.ScatterCorrectionMethod);
		tagByName.put("AxialAcceptance",TagFromName.AxialAcceptance);
		tagByName.put("AxialMash",TagFromName.AxialMash);
		tagByName.put("TransverseMash",TagFromName.TransverseMash);
		tagByName.put("DetectorElementSize",TagFromName.DetectorElementSize);
		tagByName.put("CoincidenceWindowWidth",TagFromName.CoincidenceWindowWidth);
		tagByName.put("SecondaryCountsType",TagFromName.SecondaryCountsType);
		tagByName.put("FrameReferenceTime",TagFromName.FrameReferenceTime);
		tagByName.put("PrimaryPromptsCountsAccumulated",TagFromName.PrimaryPromptsCountsAccumulated);
		tagByName.put("SecondaryCountsAccumulated",TagFromName.SecondaryCountsAccumulated);
		tagByName.put("SliceSensitivityFactor",TagFromName.SliceSensitivityFactor);
		tagByName.put("DecayFactor",TagFromName.DecayFactor);
		tagByName.put("DoseCalibrationFactor",TagFromName.DoseCalibrationFactor);
		tagByName.put("ScatterFractionFactor",TagFromName.ScatterFractionFactor);
		tagByName.put("DeadTimeFactor",TagFromName.DeadTimeFactor);
		tagByName.put("ImageIndex",TagFromName.ImageIndex);
		tagByName.put("CountsIncluded",TagFromName.CountsIncluded);
		tagByName.put("DeadTimeCorrectionFlag",TagFromName.DeadTimeCorrectionFlag);
		tagByName.put("HistogramSequence",TagFromName.HistogramSequence);
		tagByName.put("HistogramNumberOfBins",TagFromName.HistogramNumberOfBins);
		tagByName.put("HistogramFirstBinValue",TagFromName.HistogramFirstBinValue);
		tagByName.put("HistogramLastBinValue",TagFromName.HistogramLastBinValue);
		tagByName.put("HistogramBinWidth",TagFromName.HistogramBinWidth);
		tagByName.put("HistogramExplanation",TagFromName.HistogramExplanation);
		tagByName.put("HistogramData",TagFromName.HistogramData);
		tagByName.put("SegmentationType",TagFromName.SegmentationType);
		tagByName.put("SegmentSequence",TagFromName.SegmentSequence);
		tagByName.put("SegmentedPropertyCategoryCodeSequence",TagFromName.SegmentedPropertyCategoryCodeSequence);
		tagByName.put("SegmentNumber",TagFromName.SegmentNumber);
		tagByName.put("SegmentLabel",TagFromName.SegmentLabel);
		tagByName.put("SegmentDescription",TagFromName.SegmentDescription);
		tagByName.put("SegmentAlgorithmType",TagFromName.SegmentAlgorithmType);
		tagByName.put("SegmentAlgorithmName",TagFromName.SegmentAlgorithmName);
		tagByName.put("SegmentIdentificationSequence",TagFromName.SegmentIdentificationSequence);
		tagByName.put("ReferencedSegmentNumber",TagFromName.ReferencedSegmentNumber);
		tagByName.put("RecommendedDisplayGrayscaleValue",TagFromName.RecommendedDisplayGrayscaleValue);
		tagByName.put("RecommendedDisplayCIELabValue",TagFromName.RecommendedDisplayCIELabValue);
		tagByName.put("MaximumFractionalValue",TagFromName.MaximumFractionalValue);
		tagByName.put("SegmentedPropertyTypeCodeSequence",TagFromName.SegmentedPropertyTypeCodeSequence);
		tagByName.put("SegmentationFractionalType",TagFromName.SegmentationFractionalType);
		tagByName.put("DeformableRegistrationSequence",TagFromName.DeformableRegistrationSequence);
		tagByName.put("SourceFrameOfReferenceUID",TagFromName.SourceFrameOfReferenceUID);
		tagByName.put("DeformableRegistrationGridSequence",TagFromName.DeformableRegistrationGridSequence);
		tagByName.put("GridDimensions",TagFromName.GridDimensions);
		tagByName.put("GridResolution",TagFromName.GridResolution);
		tagByName.put("VectorGridData",TagFromName.VectorGridData);
		tagByName.put("PreDeformationMatrixRegistrationSequence",TagFromName.PreDeformationMatrixRegistrationSequence);
		tagByName.put("PostDeformationMatrixRegistrationSequence",TagFromName.PostDeformationMatrixRegistrationSequence);
		tagByName.put("NumberOfSurfaces",TagFromName.NumberOfSurfaces);
		tagByName.put("SurfaceSequence",TagFromName.SurfaceSequence);
		tagByName.put("SurfaceNumber",TagFromName.SurfaceNumber);
		tagByName.put("SurfaceComments",TagFromName.SurfaceComments);
		tagByName.put("SurfaceProcessing",TagFromName.SurfaceProcessing);
		tagByName.put("SurfaceProcessingRatio",TagFromName.SurfaceProcessingRatio);
		tagByName.put("SurfaceProcessingDescription",TagFromName.SurfaceProcessingDescription);
		tagByName.put("RecommendedPresentationOpacity",TagFromName.RecommendedPresentationOpacity);
		tagByName.put("RecommendedPresentationType",TagFromName.RecommendedPresentationType);
		tagByName.put("FiniteVolume",TagFromName.FiniteVolume);
		tagByName.put("Manifold",TagFromName.Manifold);
		tagByName.put("SurfacePointsSequence",TagFromName.SurfacePointsSequence);
		tagByName.put("SurfacePointsNormalsSequence",TagFromName.SurfacePointsNormalsSequence);
		tagByName.put("SurfaceMeshPrimitivesSequence",TagFromName.SurfaceMeshPrimitivesSequence);
		tagByName.put("SurfaceNumberOfPoints",TagFromName.SurfaceNumberOfPoints);
		tagByName.put("PointCoordinatesData",TagFromName.PointCoordinatesData);
		tagByName.put("PointPositionAccuracy",TagFromName.PointPositionAccuracy);
		tagByName.put("MeanPointDistance",TagFromName.MeanPointDistance);
		tagByName.put("MaximumPointDistance",TagFromName.MaximumPointDistance);
		tagByName.put("PointsBoundingBoxCoordinates",TagFromName.PointsBoundingBoxCoordinates);
		tagByName.put("AxisOfRotation",TagFromName.AxisOfRotation);
		tagByName.put("CenterOfRotation",TagFromName.CenterOfRotation);
		tagByName.put("NumberOfVectors",TagFromName.NumberOfVectors);
		tagByName.put("VectorDimensionality",TagFromName.VectorDimensionality);
		tagByName.put("VectorAccuracy",TagFromName.VectorAccuracy);
		tagByName.put("VectorCoordinateData",TagFromName.VectorCoordinateData);
		tagByName.put("TrianglePointIndexList",TagFromName.TrianglePointIndexList);
		tagByName.put("EdgePointIndexList",TagFromName.EdgePointIndexList);
		tagByName.put("VertexPointIndexList",TagFromName.VertexPointIndexList);
		tagByName.put("TriangleStripSequence",TagFromName.TriangleStripSequence);
		tagByName.put("TriangleFanSequence",TagFromName.TriangleFanSequence);
		tagByName.put("LineSequence",TagFromName.LineSequence);
		tagByName.put("PrimitivePointIndexList",TagFromName.PrimitivePointIndexList);
		tagByName.put("SurfaceCount",TagFromName.SurfaceCount);
		tagByName.put("ReferencedSurfaceSequence",TagFromName.ReferencedSurfaceSequence);
		tagByName.put("ReferencedSurfaceNumber",TagFromName.ReferencedSurfaceNumber);
		tagByName.put("SegmentSurfaceGenerationAlgorithmIdentificationSequence",TagFromName.SegmentSurfaceGenerationAlgorithmIdentificationSequence);
		tagByName.put("SegmentSurfaceSourceInstanceSequence",TagFromName.SegmentSurfaceSourceInstanceSequence);
		tagByName.put("AlgorithmFamilyCodeSequence",TagFromName.AlgorithmFamilyCodeSequence);
		tagByName.put("AlgorithmNameCodeSequence",TagFromName.AlgorithmNameCodeSequence);
		tagByName.put("AlgorithmVersion",TagFromName.AlgorithmVersion);
		tagByName.put("AlgorithmParameters",TagFromName.AlgorithmParameters);
		tagByName.put("FacetSequence",TagFromName.FacetSequence);
		tagByName.put("SurfaceProcessingAlgorithmIdentificationSequence",TagFromName.SurfaceProcessingAlgorithmIdentificationSequence);
		tagByName.put("AlgorithmName",TagFromName.AlgorithmName);
		tagByName.put("GraphicAnnotationSequence",TagFromName.GraphicAnnotationSequence);
		tagByName.put("GraphicLayer",TagFromName.GraphicLayer);
		tagByName.put("BoundingBoxAnnotationUnits",TagFromName.BoundingBoxAnnotationUnits);
		tagByName.put("AnchorPointAnnotationUnits",TagFromName.AnchorPointAnnotationUnits);
		tagByName.put("GraphicAnnotationUnits",TagFromName.GraphicAnnotationUnits);
		tagByName.put("UnformattedTextValue",TagFromName.UnformattedTextValue);
		tagByName.put("TextObjectSequence",TagFromName.TextObjectSequence);
		tagByName.put("GraphicObjectSequence",TagFromName.GraphicObjectSequence);
		tagByName.put("BoundingBoxTopLeftHandCorner",TagFromName.BoundingBoxTopLeftHandCorner);
		tagByName.put("BoundingBoxBottomRightHandCorner",TagFromName.BoundingBoxBottomRightHandCorner);
		tagByName.put("BoundingBoxTextHorizontalJustification",TagFromName.BoundingBoxTextHorizontalJustification);
		tagByName.put("AnchorPoint",TagFromName.AnchorPoint);
		tagByName.put("AnchorPointVisibility",TagFromName.AnchorPointVisibility);
		tagByName.put("GraphicDimensions",TagFromName.GraphicDimensions);
		tagByName.put("NumberOfGraphicPoints",TagFromName.NumberOfGraphicPoints);
		tagByName.put("GraphicData",TagFromName.GraphicData);
		tagByName.put("GraphicType",TagFromName.GraphicType);
		tagByName.put("GraphicFilled",TagFromName.GraphicFilled);
		tagByName.put("ImageRotationTrial",TagFromName.ImageRotationTrial);
		tagByName.put("ImageHorizontalFlip",TagFromName.ImageHorizontalFlip);
		tagByName.put("ImageRotation",TagFromName.ImageRotation);
		tagByName.put("DisplayedAreaTopLeftHandCornerTrial",TagFromName.DisplayedAreaTopLeftHandCornerTrial);
		tagByName.put("DisplayedAreaBottomRightHandCornerTrial",TagFromName.DisplayedAreaBottomRightHandCornerTrial);
		tagByName.put("DisplayedAreaTopLeftHandCorner",TagFromName.DisplayedAreaTopLeftHandCorner);
		tagByName.put("DisplayedAreaBottomRightHandCorner",TagFromName.DisplayedAreaBottomRightHandCorner);
		tagByName.put("DisplayedAreaSelectionSequence",TagFromName.DisplayedAreaSelectionSequence);
		tagByName.put("GraphicLayerSequence",TagFromName.GraphicLayerSequence);
		tagByName.put("GraphicLayerOrder",TagFromName.GraphicLayerOrder);
		tagByName.put("GraphicLayerRecommendedDisplayGrayscaleValue",TagFromName.GraphicLayerRecommendedDisplayGrayscaleValue);
		tagByName.put("GraphicLayerRecommendedDisplayRGBValue",TagFromName.GraphicLayerRecommendedDisplayRGBValue);
		tagByName.put("GraphicLayerDescription",TagFromName.GraphicLayerDescription);
		tagByName.put("ContentLabel",TagFromName.ContentLabel);
		tagByName.put("ContentDescription",TagFromName.ContentDescription);
		tagByName.put("PresentationCreationDate",TagFromName.PresentationCreationDate);
		tagByName.put("PresentationCreationTime",TagFromName.PresentationCreationTime);
		tagByName.put("ContentCreatorsName",TagFromName.ContentCreatorsName);
		tagByName.put("ContentCreatorsIdentificationCodeSequence",TagFromName.ContentCreatorsIdentificationCodeSequence);
		tagByName.put("AlternateContentDescriptionSequence",TagFromName.AlternateContentDescriptionSequence);
		tagByName.put("PresentationSizeMode",TagFromName.PresentationSizeMode);
		tagByName.put("PresentationPixelSpacing",TagFromName.PresentationPixelSpacing);
		tagByName.put("PresentationPixelAspectRatio",TagFromName.PresentationPixelAspectRatio);
		tagByName.put("PresentationPixelMagnificationRatio",TagFromName.PresentationPixelMagnificationRatio);
		tagByName.put("ShapeType",TagFromName.ShapeType);
		tagByName.put("RegistrationSequence",TagFromName.RegistrationSequence);
		tagByName.put("MatrixRegistrationSequence",TagFromName.MatrixRegistrationSequence);
		tagByName.put("MatrixSequence",TagFromName.MatrixSequence);
		tagByName.put("FrameOfReferenceTransformationMatrixType",TagFromName.FrameOfReferenceTransformationMatrixType);
		tagByName.put("RegistrationTypeCodeSequence",TagFromName.RegistrationTypeCodeSequence);
		tagByName.put("FiducialDescription",TagFromName.FiducialDescription);
		tagByName.put("FiducialIdentifier",TagFromName.FiducialIdentifier);
		tagByName.put("FiducialIdentifierCodeSequence",TagFromName.FiducialIdentifierCodeSequence);
		tagByName.put("ContourUncertaintyRadius",TagFromName.ContourUncertaintyRadius);
		tagByName.put("UsedFiducialsSequence",TagFromName.UsedFiducialsSequence);
		tagByName.put("GraphicCoordinatesDataSequence",TagFromName.GraphicCoordinatesDataSequence);
		tagByName.put("FiducialUID",TagFromName.FiducialUID);
		tagByName.put("FiducialSetSequence",TagFromName.FiducialSetSequence);
		tagByName.put("FiducialSequence",TagFromName.FiducialSequence);
		tagByName.put("GraphicLayerRecommendedDisplayCIELabValue",TagFromName.GraphicLayerRecommendedDisplayCIELabValue);
		tagByName.put("BlendingSequence",TagFromName.BlendingSequence);
		tagByName.put("RelativeOpacity",TagFromName.RelativeOpacity);
		tagByName.put("ReferencedSpatialRegistrationSequence",TagFromName.ReferencedSpatialRegistrationSequence);
		tagByName.put("BlendingPosition",TagFromName.BlendingPosition);
		tagByName.put("HangingProtocolName",TagFromName.HangingProtocolName);
		tagByName.put("HangingProtocolDescription",TagFromName.HangingProtocolDescription);
		tagByName.put("HangingProtocolLevel",TagFromName.HangingProtocolLevel);
		tagByName.put("HangingProtocolCreator",TagFromName.HangingProtocolCreator);
		tagByName.put("HangingProtocolCreationDateTime",TagFromName.HangingProtocolCreationDateTime);
		tagByName.put("HangingProtocolDefinitionSequence",TagFromName.HangingProtocolDefinitionSequence);
		tagByName.put("HangingProtocolUserIdentificationCodeSequence",TagFromName.HangingProtocolUserIdentificationCodeSequence);
		tagByName.put("HangingProtocolUserGroupName",TagFromName.HangingProtocolUserGroupName);
		tagByName.put("SourceHangingProtocolSequence",TagFromName.SourceHangingProtocolSequence);
		tagByName.put("NumberOfPriorsReferenced",TagFromName.NumberOfPriorsReferenced);
		tagByName.put("ImageSetsSequence",TagFromName.ImageSetsSequence);
		tagByName.put("ImageSetSelectorSequence",TagFromName.ImageSetSelectorSequence);
		tagByName.put("ImageSetSelectorUsageFlag",TagFromName.ImageSetSelectorUsageFlag);
		tagByName.put("SelectorAttribute",TagFromName.SelectorAttribute);
		tagByName.put("SelectorValueNumber",TagFromName.SelectorValueNumber);
		tagByName.put("TimeBasedImageSetsSequence",TagFromName.TimeBasedImageSetsSequence);
		tagByName.put("ImageSetNumber",TagFromName.ImageSetNumber);
		tagByName.put("ImageSetSelectorCategory",TagFromName.ImageSetSelectorCategory);
		tagByName.put("RelativeTime",TagFromName.RelativeTime);
		tagByName.put("RelativeTimeUnits",TagFromName.RelativeTimeUnits);
		tagByName.put("AbstractPriorValue",TagFromName.AbstractPriorValue);
		tagByName.put("AbstractPriorCodeSequence",TagFromName.AbstractPriorCodeSequence);
		tagByName.put("ImageSetLabel",TagFromName.ImageSetLabel);
		tagByName.put("SelectorAttributeVR",TagFromName.SelectorAttributeVR);
		tagByName.put("SelectorSequencePointer",TagFromName.SelectorSequencePointer);
		tagByName.put("SelectorSequencePointerPrivateCreator",TagFromName.SelectorSequencePointerPrivateCreator);
		tagByName.put("SelectorAttributePrivateCreator",TagFromName.SelectorAttributePrivateCreator);
		tagByName.put("SelectorATValue",TagFromName.SelectorATValue);
		tagByName.put("SelectorCSValue",TagFromName.SelectorCSValue);
		tagByName.put("SelectorISValue",TagFromName.SelectorISValue);
		tagByName.put("SelectorLOValue",TagFromName.SelectorLOValue);
		tagByName.put("SelectorLTValue",TagFromName.SelectorLTValue);
		tagByName.put("SelectorPNValue",TagFromName.SelectorPNValue);
		tagByName.put("SelectorSHValue",TagFromName.SelectorSHValue);
		tagByName.put("SelectorSTValue",TagFromName.SelectorSTValue);
		tagByName.put("SelectorUTValue",TagFromName.SelectorUTValue);
		tagByName.put("SelectorDSValue",TagFromName.SelectorDSValue);
		tagByName.put("SelectorFDValue",TagFromName.SelectorFDValue);
		tagByName.put("SelectorFLValue",TagFromName.SelectorFLValue);
		tagByName.put("SelectorULValue",TagFromName.SelectorULValue);
		tagByName.put("SelectorUSValue",TagFromName.SelectorUSValue);
		tagByName.put("SelectorSLValue",TagFromName.SelectorSLValue);
		tagByName.put("SelectorSSValue",TagFromName.SelectorSSValue);
		tagByName.put("SelectorCodeSequenceValue",TagFromName.SelectorCodeSequenceValue);
		tagByName.put("NumberOfScreens",TagFromName.NumberOfScreens);
		tagByName.put("NominalScreenDefinitionSequence",TagFromName.NominalScreenDefinitionSequence);
		tagByName.put("NumberOfVerticalPixels",TagFromName.NumberOfVerticalPixels);
		tagByName.put("NumberOfHorizontalPixels",TagFromName.NumberOfHorizontalPixels);
		tagByName.put("DisplayEnvironmentSpatialPosition",TagFromName.DisplayEnvironmentSpatialPosition);
		tagByName.put("ScreenMinimumGrayscaleBitDepth",TagFromName.ScreenMinimumGrayscaleBitDepth);
		tagByName.put("ScreenMinimumColorBitDepth",TagFromName.ScreenMinimumColorBitDepth);
		tagByName.put("ApplicationMaximumRepaintTime",TagFromName.ApplicationMaximumRepaintTime);
		tagByName.put("DisplaySetsSequence",TagFromName.DisplaySetsSequence);
		tagByName.put("DisplaySetNumber",TagFromName.DisplaySetNumber);
		tagByName.put("DisplaySetLabel",TagFromName.DisplaySetLabel);
		tagByName.put("DisplaySetPresentationGroup",TagFromName.DisplaySetPresentationGroup);
		tagByName.put("DisplaySetPresentationGroupDescription",TagFromName.DisplaySetPresentationGroupDescription);
		tagByName.put("PartialDataDisplayHandling",TagFromName.PartialDataDisplayHandling);
		tagByName.put("SynchronizedScrollingSequence",TagFromName.SynchronizedScrollingSequence);
		tagByName.put("DisplaySetScrollingGroup",TagFromName.DisplaySetScrollingGroup);
		tagByName.put("NavigationIndicatorSequence",TagFromName.NavigationIndicatorSequence);
		tagByName.put("NavigationDisplaySet",TagFromName.NavigationDisplaySet);
		tagByName.put("ReferenceDisplaySets",TagFromName.ReferenceDisplaySets);
		tagByName.put("ImageBoxesSequence",TagFromName.ImageBoxesSequence);
		tagByName.put("ImageBoxNumber",TagFromName.ImageBoxNumber);
		tagByName.put("ImageBoxLayoutType",TagFromName.ImageBoxLayoutType);
		tagByName.put("ImageBoxTileHorizontalDimension",TagFromName.ImageBoxTileHorizontalDimension);
		tagByName.put("ImageBoxTileVerticalDimension",TagFromName.ImageBoxTileVerticalDimension);
		tagByName.put("ImageBoxScrollDirection",TagFromName.ImageBoxScrollDirection);
		tagByName.put("ImageBoxSmallScrollType",TagFromName.ImageBoxSmallScrollType);
		tagByName.put("ImageBoxSmallScrollAmount",TagFromName.ImageBoxSmallScrollAmount);
		tagByName.put("ImageBoxLargeScrollType",TagFromName.ImageBoxLargeScrollType);
		tagByName.put("ImageBoxLargeScrollAmount",TagFromName.ImageBoxLargeScrollAmount);
		tagByName.put("ImageBoxOverlapPriority",TagFromName.ImageBoxOverlapPriority);
		tagByName.put("CineRelativeToRealTime",TagFromName.CineRelativeToRealTime);
		tagByName.put("FilterOperationsSequence",TagFromName.FilterOperationsSequence);
		tagByName.put("FilterByCategory",TagFromName.FilterByCategory);
		tagByName.put("FilterByAttributePresence",TagFromName.FilterByAttributePresence);
		tagByName.put("FilterByOperator",TagFromName.FilterByOperator);
		tagByName.put("StructuredDisplayBackgroundCIELabValue",TagFromName.StructuredDisplayBackgroundCIELabValue);
		tagByName.put("EmptyImageBoxCIELabValue",TagFromName.EmptyImageBoxCIELabValue);
		tagByName.put("StructuredDisplayImageBoxSequence",TagFromName.StructuredDisplayImageBoxSequence);
		tagByName.put("StructuredDisplayTextBoxSequence",TagFromName.StructuredDisplayTextBoxSequence);
		tagByName.put("ReferencedFirstFrameSequence",TagFromName.ReferencedFirstFrameSequence);
		tagByName.put("ImageBoxSynchronizationSequence",TagFromName.ImageBoxSynchronizationSequence);
		tagByName.put("SynchronizedImageBoxList",TagFromName.SynchronizedImageBoxList);
		tagByName.put("TypeOfSynchronization",TagFromName.TypeOfSynchronization);
		tagByName.put("BlendingOperationType",TagFromName.BlendingOperationType);
		tagByName.put("ReformattingOperationType",TagFromName.ReformattingOperationType);
		tagByName.put("ReformattingThickness",TagFromName.ReformattingThickness);
		tagByName.put("ReformattingInterval",TagFromName.ReformattingInterval);
		tagByName.put("ReformattingOperationInitialViewDirection",TagFromName.ReformattingOperationInitialViewDirection);
		tagByName.put("ThreeDRenderingType",TagFromName.ThreeDRenderingType);
		tagByName.put("SortingOperationsSequence",TagFromName.SortingOperationsSequence);
		tagByName.put("SortByCategory",TagFromName.SortByCategory);
		tagByName.put("SortingDirection",TagFromName.SortingDirection);
		tagByName.put("DisplaySetPatientOrientation",TagFromName.DisplaySetPatientOrientation);
		tagByName.put("VOIType",TagFromName.VOIType);
		tagByName.put("PseudocolorType",TagFromName.PseudocolorType);
		tagByName.put("ShowGrayscaleInverted",TagFromName.ShowGrayscaleInverted);
		tagByName.put("ShowImageTrueSizeFlag",TagFromName.ShowImageTrueSizeFlag);
		tagByName.put("ShowGraphicAnnotationFlag",TagFromName.ShowGraphicAnnotationFlag);
		tagByName.put("ShowPatientDemographicsFlag",TagFromName.ShowPatientDemographicsFlag);
		tagByName.put("ShowAcquisitionTechniquesFlag",TagFromName.ShowAcquisitionTechniquesFlag);
		tagByName.put("DisplaySetHorizontalJustification",TagFromName.DisplaySetHorizontalJustification);
		tagByName.put("DisplaySetVerticalJustification",TagFromName.DisplaySetVerticalJustification);
		tagByName.put("StorageMediaFileSetID",TagFromName.StorageMediaFileSetID);
		tagByName.put("StorageMediaFileSetUID",TagFromName.StorageMediaFileSetUID);
		tagByName.put("IconImageSequence",TagFromName.IconImageSequence);
		tagByName.put("TopicTitle",TagFromName.TopicTitle);
		tagByName.put("TopicSubject",TagFromName.TopicSubject);
		tagByName.put("TopicAuthor",TagFromName.TopicAuthor);
		tagByName.put("TopicKeyWords",TagFromName.TopicKeyWords);
		tagByName.put("SOPInstanceStatus",TagFromName.SOPInstanceStatus);
		tagByName.put("SOPAuthorizationDateAndTime",TagFromName.SOPAuthorizationDateAndTime);
		tagByName.put("SOPAuthorizationComment",TagFromName.SOPAuthorizationComment);
		tagByName.put("AuthorizationEquipmentCertificationNumber",TagFromName.AuthorizationEquipmentCertificationNumber);
		tagByName.put("MACIDNumber",TagFromName.MACIDNumber);
		tagByName.put("MACCalculationTransferSyntaxUID",TagFromName.MACCalculationTransferSyntaxUID);
		tagByName.put("MACAlgorithm",TagFromName.MACAlgorithm);
		tagByName.put("DataElementsSigned",TagFromName.DataElementsSigned);
		tagByName.put("DigitalSignatureUID",TagFromName.DigitalSignatureUID);
		tagByName.put("DigitalSignatureDateTime",TagFromName.DigitalSignatureDateTime);
		tagByName.put("CertificateType",TagFromName.CertificateType);
		tagByName.put("CertificateOfSigner",TagFromName.CertificateOfSigner);
		tagByName.put("Signature",TagFromName.Signature);
		tagByName.put("CertifiedTimestampType",TagFromName.CertifiedTimestampType);
		tagByName.put("CertifiedTimestamp",TagFromName.CertifiedTimestamp);
		tagByName.put("DigitalSignaturePurposeCodeSequence",TagFromName.DigitalSignaturePurposeCodeSequence);
		tagByName.put("ReferencedDigitalSignatureSequence",TagFromName.ReferencedDigitalSignatureSequence);
		tagByName.put("ReferencedSOPInstanceMACSequence",TagFromName.ReferencedSOPInstanceMACSequence);
		tagByName.put("MAC",TagFromName.MAC);
		tagByName.put("EncryptedAttributesSequence",TagFromName.EncryptedAttributesSequence);
		tagByName.put("EncryptedContentTransferSyntaxUID",TagFromName.EncryptedContentTransferSyntaxUID);
		tagByName.put("EncryptedContent",TagFromName.EncryptedContent);
		tagByName.put("ModifiedAttributesSequence",TagFromName.ModifiedAttributesSequence);
		tagByName.put("OriginalAttributesSequence",TagFromName.OriginalAttributesSequence);
		tagByName.put("AttributeModificationDateTime",TagFromName.AttributeModificationDateTime);
		tagByName.put("ModifyingSystem",TagFromName.ModifyingSystem);
		tagByName.put("SourceOfPreviousValues",TagFromName.SourceOfPreviousValues);
		tagByName.put("ReasonForTheAttributeModification",TagFromName.ReasonForTheAttributeModification);
		tagByName.put("ZonalMap",TagFromName.ZonalMap);
		tagByName.put("NumberOfCopies",TagFromName.NumberOfCopies);
		tagByName.put("PrinterConfigurationSequence",TagFromName.PrinterConfigurationSequence);
		tagByName.put("PrintPriority",TagFromName.PrintPriority);
		tagByName.put("MediumType",TagFromName.MediumType);
		tagByName.put("FilmDestination",TagFromName.FilmDestination);
		tagByName.put("FilmSessionLabel",TagFromName.FilmSessionLabel);
		tagByName.put("MemoryAllocation",TagFromName.MemoryAllocation);
		tagByName.put("MaximumMemoryAllocation",TagFromName.MaximumMemoryAllocation);
		tagByName.put("ColorImagePrintingFlag",TagFromName.ColorImagePrintingFlag);
		tagByName.put("CollationFlag",TagFromName.CollationFlag);
		tagByName.put("AnnotationFlag",TagFromName.AnnotationFlag);
		tagByName.put("ImageOverlayFlag",TagFromName.ImageOverlayFlag);
		tagByName.put("PresentationLUTFlag",TagFromName.PresentationLUTFlag);
		tagByName.put("ImageBoxPresentationLUTFlag",TagFromName.ImageBoxPresentationLUTFlag);
		tagByName.put("MemoryBitDepth",TagFromName.MemoryBitDepth);
		tagByName.put("PrintingBitDepth",TagFromName.PrintingBitDepth);
		tagByName.put("MediaInstalledSequence",TagFromName.MediaInstalledSequence);
		tagByName.put("OtherMediaAvailableSequence",TagFromName.OtherMediaAvailableSequence);
		tagByName.put("SupportedImageDisplayFormatsSequence",TagFromName.SupportedImageDisplayFormatsSequence);
		tagByName.put("ReferencedFilmBoxSequence",TagFromName.ReferencedFilmBoxSequence);
		tagByName.put("ReferencedStoredPrintSequence",TagFromName.ReferencedStoredPrintSequence);
		tagByName.put("ImageDisplayFormat",TagFromName.ImageDisplayFormat);
		tagByName.put("AnnotationDisplayFormatID",TagFromName.AnnotationDisplayFormatID);
		tagByName.put("FilmOrientation",TagFromName.FilmOrientation);
		tagByName.put("FilmSizeID",TagFromName.FilmSizeID);
		tagByName.put("PrinterResolutionID",TagFromName.PrinterResolutionID);
		tagByName.put("DefaultPrinterResolutionID",TagFromName.DefaultPrinterResolutionID);
		tagByName.put("MagnificationType",TagFromName.MagnificationType);
		tagByName.put("SmoothingType",TagFromName.SmoothingType);
		tagByName.put("DefaultMagnificationType",TagFromName.DefaultMagnificationType);
		tagByName.put("OtherMagnificationTypesAvailable",TagFromName.OtherMagnificationTypesAvailable);
		tagByName.put("DefaultSmoothingType",TagFromName.DefaultSmoothingType);
		tagByName.put("OtherSmoothingTypesAvailable",TagFromName.OtherSmoothingTypesAvailable);
		tagByName.put("BorderDensity",TagFromName.BorderDensity);
		tagByName.put("EmptyImageDensity",TagFromName.EmptyImageDensity);
		tagByName.put("MinDensity",TagFromName.MinDensity);
		tagByName.put("MaxDensity",TagFromName.MaxDensity);
		tagByName.put("Trim",TagFromName.Trim);
		tagByName.put("ConfigurationInformation",TagFromName.ConfigurationInformation);
		tagByName.put("ConfigurationInformationDescription",TagFromName.ConfigurationInformationDescription);
		tagByName.put("MaximumCollatedFilms",TagFromName.MaximumCollatedFilms);
		tagByName.put("Illumination",TagFromName.Illumination);
		tagByName.put("ReflectedAmbientLight",TagFromName.ReflectedAmbientLight);
		tagByName.put("PrinterPixelSpacing",TagFromName.PrinterPixelSpacing);
		tagByName.put("ReferencedFilmSessionSequence",TagFromName.ReferencedFilmSessionSequence);
		tagByName.put("ReferencedImageBoxSequence",TagFromName.ReferencedImageBoxSequence);
		tagByName.put("ReferencedBasicAnnotationBoxSequence",TagFromName.ReferencedBasicAnnotationBoxSequence);
		tagByName.put("ImageBoxPosition",TagFromName.ImageBoxPosition);
		tagByName.put("Polarity",TagFromName.Polarity);
		tagByName.put("RequestedImageSize",TagFromName.RequestedImageSize);
		tagByName.put("RequestedDecimateCropBehavior",TagFromName.RequestedDecimateCropBehavior);
		tagByName.put("RequestedResolutionID",TagFromName.RequestedResolutionID);
		tagByName.put("RequestedImageSizeFlag",TagFromName.RequestedImageSizeFlag);
		tagByName.put("DecimateCropResult",TagFromName.DecimateCropResult);
		tagByName.put("BasicGrayscaleImageSequence",TagFromName.BasicGrayscaleImageSequence);
		tagByName.put("BasicColorImageSequence",TagFromName.BasicColorImageSequence);
		tagByName.put("ReferencedImageOverlayBoxSequence",TagFromName.ReferencedImageOverlayBoxSequence);
		tagByName.put("ReferencedVOILUTBoxSequence",TagFromName.ReferencedVOILUTBoxSequence);
		tagByName.put("AnnotationPosition",TagFromName.AnnotationPosition);
		tagByName.put("TextString",TagFromName.TextString);
		tagByName.put("ReferencedOverlayPlaneSequence",TagFromName.ReferencedOverlayPlaneSequence);
		tagByName.put("ReferencedOverlayPlaneGroups",TagFromName.ReferencedOverlayPlaneGroups);
		tagByName.put("OverlayPixelDataSequence",TagFromName.OverlayPixelDataSequence);
		tagByName.put("OverlayMagnificationType",TagFromName.OverlayMagnificationType);
		tagByName.put("OverlaySmoothingType",TagFromName.OverlaySmoothingType);
		tagByName.put("OverlayOrImageMagnification",TagFromName.OverlayOrImageMagnification);
		tagByName.put("MagnifyToNumberOfColumns",TagFromName.MagnifyToNumberOfColumns);
		tagByName.put("OverlayForegroundDensity",TagFromName.OverlayForegroundDensity);
		tagByName.put("OverlayBackgroundDensity",TagFromName.OverlayBackgroundDensity);
		tagByName.put("OverlayMode",TagFromName.OverlayMode);
		tagByName.put("ThresholdDensity",TagFromName.ThresholdDensity);
		tagByName.put("ReferencedOverlayImageBoxSequence",TagFromName.ReferencedOverlayImageBoxSequence);
		tagByName.put("PresentationLUTSequence",TagFromName.PresentationLUTSequence);
		tagByName.put("PresentationLUTShape",TagFromName.PresentationLUTShape);
		tagByName.put("ReferencedPresentationLUTSequence",TagFromName.ReferencedPresentationLUTSequence);
		tagByName.put("PrintJobID",TagFromName.PrintJobID);
		tagByName.put("ExecutionStatus",TagFromName.ExecutionStatus);
		tagByName.put("ExecutionStatusInfo",TagFromName.ExecutionStatusInfo);
		tagByName.put("CreationDate",TagFromName.CreationDate);
		tagByName.put("CreationTime",TagFromName.CreationTime);
		tagByName.put("Originator",TagFromName.Originator);
		tagByName.put("DestinationAE",TagFromName.DestinationAE);
		tagByName.put("OwnerID",TagFromName.OwnerID);
		tagByName.put("NumberOfFilms",TagFromName.NumberOfFilms);
		tagByName.put("ReferencedPrintJobSequencePull",TagFromName.ReferencedPrintJobSequencePull);
		tagByName.put("PrinterStatus",TagFromName.PrinterStatus);
		tagByName.put("PrinterStatusInfo",TagFromName.PrinterStatusInfo);
		tagByName.put("PrinterName",TagFromName.PrinterName);
		tagByName.put("PrintQueueID",TagFromName.PrintQueueID);
		tagByName.put("QueueStatus",TagFromName.QueueStatus);
		tagByName.put("PrintJobDescriptionSequence",TagFromName.PrintJobDescriptionSequence);
		tagByName.put("ReferencedPrintJobSequenceQueue",TagFromName.ReferencedPrintJobSequenceQueue);
		tagByName.put("PrintManagementCapabilitiesSequence",TagFromName.PrintManagementCapabilitiesSequence);
		tagByName.put("PrinterCharacteristicsSequence",TagFromName.PrinterCharacteristicsSequence);
		tagByName.put("FilmBoxContentSequence",TagFromName.FilmBoxContentSequence);
		tagByName.put("ImageBoxContentSequence",TagFromName.ImageBoxContentSequence);
		tagByName.put("AnnotationContentSequence",TagFromName.AnnotationContentSequence);
		tagByName.put("ImageOverlayBoxContentSequence",TagFromName.ImageOverlayBoxContentSequence);
		tagByName.put("PresentationLUTContentSequence",TagFromName.PresentationLUTContentSequence);
		tagByName.put("ProposedStudySequence",TagFromName.ProposedStudySequence);
		tagByName.put("OriginalImageSequence",TagFromName.OriginalImageSequence);
		tagByName.put("LabelUsingInformationExtractedFromInstances",TagFromName.LabelUsingInformationExtractedFromInstances);
		tagByName.put("LabelText",TagFromName.LabelText);
		tagByName.put("LabelStyleSelection",TagFromName.LabelStyleSelection);
		tagByName.put("MediaDisposition",TagFromName.MediaDisposition);
		tagByName.put("BarcodeValue",TagFromName.BarcodeValue);
		tagByName.put("BarcodeSymbology",TagFromName.BarcodeSymbology);
		tagByName.put("AllowMediaSplitting",TagFromName.AllowMediaSplitting);
		tagByName.put("IncludeNonDICOMObjects",TagFromName.IncludeNonDICOMObjects);
		tagByName.put("IncludeDisplayApplication",TagFromName.IncludeDisplayApplication);
		tagByName.put("PreserveCompositeInstancesAfterMediaCreation",TagFromName.PreserveCompositeInstancesAfterMediaCreation);
		tagByName.put("TotalNumberOfPiecesOfMediaCreated",TagFromName.TotalNumberOfPiecesOfMediaCreated);
		tagByName.put("RequestedMediaApplicationProfile",TagFromName.RequestedMediaApplicationProfile);
		tagByName.put("ReferencedStorageMediaSequence",TagFromName.ReferencedStorageMediaSequence);
		tagByName.put("FailureAttributes",TagFromName.FailureAttributes);
		tagByName.put("AllowLossyCompression",TagFromName.AllowLossyCompression);
		tagByName.put("RequestPriority",TagFromName.RequestPriority);
		tagByName.put("RTImageLabel",TagFromName.RTImageLabel);
		tagByName.put("RTImageName",TagFromName.RTImageName);
		tagByName.put("RTImageDescription",TagFromName.RTImageDescription);
		tagByName.put("ReportedValuesOrigin",TagFromName.ReportedValuesOrigin);
		tagByName.put("RTImagePlane",TagFromName.RTImagePlane);
		tagByName.put("XRayImageReceptorTranslation",TagFromName.XRayImageReceptorTranslation);
		tagByName.put("XRayImageReceptorAngle",TagFromName.XRayImageReceptorAngle);
		tagByName.put("RTImageOrientation",TagFromName.RTImageOrientation);
		tagByName.put("ImagePlanePixelSpacing",TagFromName.ImagePlanePixelSpacing);
		tagByName.put("RTImagePosition",TagFromName.RTImagePosition);
		tagByName.put("RadiationMachineName",TagFromName.RadiationMachineName);
		tagByName.put("RadiationMachineSAD",TagFromName.RadiationMachineSAD);
		tagByName.put("RadiationMachineSSD",TagFromName.RadiationMachineSSD);
		tagByName.put("RTImageSID",TagFromName.RTImageSID);
		tagByName.put("SourceToReferenceObjectDistance",TagFromName.SourceToReferenceObjectDistance);
		tagByName.put("FractionNumber",TagFromName.FractionNumber);
		tagByName.put("ExposureSequence",TagFromName.ExposureSequence);
		tagByName.put("MetersetExposure",TagFromName.MetersetExposure);
		tagByName.put("DiaphragmPosition",TagFromName.DiaphragmPosition);
		tagByName.put("FluenceMapSequence",TagFromName.FluenceMapSequence);
		tagByName.put("FluenceDataSource",TagFromName.FluenceDataSource);
		tagByName.put("FluenceDataScale",TagFromName.FluenceDataScale);
		tagByName.put("DVHType",TagFromName.DVHType);
		tagByName.put("DoseUnits",TagFromName.DoseUnits);
		tagByName.put("DoseType",TagFromName.DoseType);
		tagByName.put("DoseComment",TagFromName.DoseComment);
		tagByName.put("NormalizationPoint",TagFromName.NormalizationPoint);
		tagByName.put("DoseSummationType",TagFromName.DoseSummationType);
		tagByName.put("GridFrameOffsetVector",TagFromName.GridFrameOffsetVector);
		tagByName.put("DoseGridScaling",TagFromName.DoseGridScaling);
		tagByName.put("RTDoseROISequence",TagFromName.RTDoseROISequence);
		tagByName.put("DoseValue",TagFromName.DoseValue);
		tagByName.put("TissueHeterogeneityCorrection",TagFromName.TissueHeterogeneityCorrection);
		tagByName.put("DVHNormalizationPoint",TagFromName.DVHNormalizationPoint);
		tagByName.put("DVHNormalizationDoseValue",TagFromName.DVHNormalizationDoseValue);
		tagByName.put("DVHSequence",TagFromName.DVHSequence);
		tagByName.put("DVHDoseScaling",TagFromName.DVHDoseScaling);
		tagByName.put("DVHVolumeUnits",TagFromName.DVHVolumeUnits);
		tagByName.put("DVHNumberOfBins",TagFromName.DVHNumberOfBins);
		tagByName.put("DVHData",TagFromName.DVHData);
		tagByName.put("DVHReferencedROISequence",TagFromName.DVHReferencedROISequence);
		tagByName.put("DVHROIContributionType",TagFromName.DVHROIContributionType);
		tagByName.put("DVHMinimumDose",TagFromName.DVHMinimumDose);
		tagByName.put("DVHMaximumDose",TagFromName.DVHMaximumDose);
		tagByName.put("DVHMeanDose",TagFromName.DVHMeanDose);
		tagByName.put("StructureSetLabel",TagFromName.StructureSetLabel);
		tagByName.put("StructureSetName",TagFromName.StructureSetName);
		tagByName.put("StructureSetDescription",TagFromName.StructureSetDescription);
		tagByName.put("StructureSetDate",TagFromName.StructureSetDate);
		tagByName.put("StructureSetTime",TagFromName.StructureSetTime);
		tagByName.put("ReferencedFrameOfReferenceSequence",TagFromName.ReferencedFrameOfReferenceSequence);
		tagByName.put("RTReferencedStudySequence",TagFromName.RTReferencedStudySequence);
		tagByName.put("RTReferencedSeriesSequence",TagFromName.RTReferencedSeriesSequence);
		tagByName.put("ContourImageSequence",TagFromName.ContourImageSequence);
		tagByName.put("StructureSetROISequence",TagFromName.StructureSetROISequence);
		tagByName.put("ROINumber",TagFromName.ROINumber);
		tagByName.put("ReferencedFrameOfReferenceUID",TagFromName.ReferencedFrameOfReferenceUID);
		tagByName.put("ROIName",TagFromName.ROIName);
		tagByName.put("ROIDescription",TagFromName.ROIDescription);
		tagByName.put("ROIDisplayColor",TagFromName.ROIDisplayColor);
		tagByName.put("ROIVolume",TagFromName.ROIVolume);
		tagByName.put("RTRelatedROISequence",TagFromName.RTRelatedROISequence);
		tagByName.put("RTROIRelationship",TagFromName.RTROIRelationship);
		tagByName.put("ROIGenerationAlgorithm",TagFromName.ROIGenerationAlgorithm);
		tagByName.put("ROIGenerationDescription",TagFromName.ROIGenerationDescription);
		tagByName.put("ROIContourSequence",TagFromName.ROIContourSequence);
		tagByName.put("ContourSequence",TagFromName.ContourSequence);
		tagByName.put("ContourGeometricType",TagFromName.ContourGeometricType);
		tagByName.put("ContourSlabThickness",TagFromName.ContourSlabThickness);
		tagByName.put("ContourOffsetVector",TagFromName.ContourOffsetVector);
		tagByName.put("NumberOfContourPoints",TagFromName.NumberOfContourPoints);
		tagByName.put("ContourNumber",TagFromName.ContourNumber);
		tagByName.put("AttachedContours",TagFromName.AttachedContours);
		tagByName.put("ContourData",TagFromName.ContourData);
		tagByName.put("RTROIObservationsSequence",TagFromName.RTROIObservationsSequence);
		tagByName.put("ObservationNumber",TagFromName.ObservationNumber);
		tagByName.put("ReferencedROINumber",TagFromName.ReferencedROINumber);
		tagByName.put("ROIObservationLabel",TagFromName.ROIObservationLabel);
		tagByName.put("RTROIIdentificationCodeSequence",TagFromName.RTROIIdentificationCodeSequence);
		tagByName.put("ROIObservationDescription",TagFromName.ROIObservationDescription);
		tagByName.put("RelatedRTROIObservationsSequence",TagFromName.RelatedRTROIObservationsSequence);
		tagByName.put("RTROIInterpretedType",TagFromName.RTROIInterpretedType);
		tagByName.put("ROIInterpreter",TagFromName.ROIInterpreter);
		tagByName.put("ROIPhysicalPropertiesSequence",TagFromName.ROIPhysicalPropertiesSequence);
		tagByName.put("ROIPhysicalProperty",TagFromName.ROIPhysicalProperty);
		tagByName.put("ROIPhysicalPropertyValue",TagFromName.ROIPhysicalPropertyValue);
		tagByName.put("ROIElementalCompositionSequence",TagFromName.ROIElementalCompositionSequence);
		tagByName.put("ROIElementalCompositionAtomicNumber",TagFromName.ROIElementalCompositionAtomicNumber);
		tagByName.put("ROIElementalCompositionAtomicMassFraction",TagFromName.ROIElementalCompositionAtomicMassFraction);
		tagByName.put("FrameOfReferenceRelationshipSequence",TagFromName.FrameOfReferenceRelationshipSequence);
		tagByName.put("RelatedFrameOfReferenceUID",TagFromName.RelatedFrameOfReferenceUID);
		tagByName.put("FrameOfReferenceTransformationType",TagFromName.FrameOfReferenceTransformationType);
		tagByName.put("FrameOfReferenceTransformationMatrix",TagFromName.FrameOfReferenceTransformationMatrix);
		tagByName.put("FrameOfReferenceTransformationComment",TagFromName.FrameOfReferenceTransformationComment);
		tagByName.put("MeasuredDoseReferenceSequence",TagFromName.MeasuredDoseReferenceSequence);
		tagByName.put("MeasuredDoseDescription",TagFromName.MeasuredDoseDescription);
		tagByName.put("MeasuredDoseType",TagFromName.MeasuredDoseType);
		tagByName.put("MeasuredDoseValue",TagFromName.MeasuredDoseValue);
		tagByName.put("TreatmentSessionBeamSequence",TagFromName.TreatmentSessionBeamSequence);
		tagByName.put("TreatmentSessionIonBeamSequence",TagFromName.TreatmentSessionIonBeamSequence);
		tagByName.put("CurrentFractionNumber",TagFromName.CurrentFractionNumber);
		tagByName.put("TreatmentControlPointDate",TagFromName.TreatmentControlPointDate);
		tagByName.put("TreatmentControlPointTime",TagFromName.TreatmentControlPointTime);
		tagByName.put("TreatmentTerminationStatus",TagFromName.TreatmentTerminationStatus);
		tagByName.put("TreatmentTerminationCode",TagFromName.TreatmentTerminationCode);
		tagByName.put("TreatmentVerificationStatus",TagFromName.TreatmentVerificationStatus);
		tagByName.put("ReferencedTreatmentRecordSequence",TagFromName.ReferencedTreatmentRecordSequence);
		tagByName.put("SpecifiedPrimaryMeterset",TagFromName.SpecifiedPrimaryMeterset);
		tagByName.put("SpecifiedSecondaryMeterset",TagFromName.SpecifiedSecondaryMeterset);
		tagByName.put("DeliveredPrimaryMeterset",TagFromName.DeliveredPrimaryMeterset);
		tagByName.put("DeliveredSecondaryMeterset",TagFromName.DeliveredSecondaryMeterset);
		tagByName.put("SpecifiedTreatmentTime",TagFromName.SpecifiedTreatmentTime);
		tagByName.put("DeliveredTreatmentTime",TagFromName.DeliveredTreatmentTime);
		tagByName.put("ControlPointDeliverySequence",TagFromName.ControlPointDeliverySequence);
		tagByName.put("IonControlPointDeliverySequence",TagFromName.IonControlPointDeliverySequence);
		tagByName.put("SpecifiedMeterset",TagFromName.SpecifiedMeterset);
		tagByName.put("DeliveredMeterset",TagFromName.DeliveredMeterset);
		tagByName.put("MetersetRateSet",TagFromName.MetersetRateSet);
		tagByName.put("MetersetRateDelivered",TagFromName.MetersetRateDelivered);
		tagByName.put("ScanSpotMetersetsDelivered",TagFromName.ScanSpotMetersetsDelivered);
		tagByName.put("DoseRateDelivered",TagFromName.DoseRateDelivered);
		tagByName.put("TreatmentSummaryCalculatedDoseReferenceSequence",TagFromName.TreatmentSummaryCalculatedDoseReferenceSequence);
		tagByName.put("CumulativeDoseToDoseReference",TagFromName.CumulativeDoseToDoseReference);
		tagByName.put("FirstTreatmentDate",TagFromName.FirstTreatmentDate);
		tagByName.put("MostRecentTreatmentDate",TagFromName.MostRecentTreatmentDate);
		tagByName.put("NumberOfFractionsDelivered",TagFromName.NumberOfFractionsDelivered);
		tagByName.put("OverrideSequence",TagFromName.OverrideSequence);
		tagByName.put("ParameterSequencePointer",TagFromName.ParameterSequencePointer);
		tagByName.put("OverrideParameterPointer",TagFromName.OverrideParameterPointer);
		tagByName.put("ParameterItemIndex",TagFromName.ParameterItemIndex);
		tagByName.put("MeasuredDoseReferenceNumber",TagFromName.MeasuredDoseReferenceNumber);
		tagByName.put("ParameterPointer",TagFromName.ParameterPointer);
		tagByName.put("OverrideReason",TagFromName.OverrideReason);
		tagByName.put("CorrectedParameterSequence",TagFromName.CorrectedParameterSequence);
		tagByName.put("CorrectionValue",TagFromName.CorrectionValue);
		tagByName.put("CalculatedDoseReferenceSequence",TagFromName.CalculatedDoseReferenceSequence);
		tagByName.put("CalculatedDoseReferenceNumber",TagFromName.CalculatedDoseReferenceNumber);
		tagByName.put("CalculatedDoseReferenceDescription",TagFromName.CalculatedDoseReferenceDescription);
		tagByName.put("CalculatedDoseReferenceDoseValue",TagFromName.CalculatedDoseReferenceDoseValue);
		tagByName.put("StartMeterset",TagFromName.StartMeterset);
		tagByName.put("EndMeterset",TagFromName.EndMeterset);
		tagByName.put("ReferencedMeasuredDoseReferenceSequence",TagFromName.ReferencedMeasuredDoseReferenceSequence);
		tagByName.put("ReferencedMeasuredDoseReferenceNumber",TagFromName.ReferencedMeasuredDoseReferenceNumber);
		tagByName.put("ReferencedCalculatedDoseReferenceSequence",TagFromName.ReferencedCalculatedDoseReferenceSequence);
		tagByName.put("ReferencedCalculatedDoseReferenceNumber",TagFromName.ReferencedCalculatedDoseReferenceNumber);
		tagByName.put("BeamLimitingDeviceLeafPairsSequence",TagFromName.BeamLimitingDeviceLeafPairsSequence);
		tagByName.put("RecordedWedgeSequence",TagFromName.RecordedWedgeSequence);
		tagByName.put("RecordedCompensatorSequence",TagFromName.RecordedCompensatorSequence);
		tagByName.put("RecordedBlockSequence",TagFromName.RecordedBlockSequence);
		tagByName.put("TreatmentSummaryMeasuredDoseReferenceSequence",TagFromName.TreatmentSummaryMeasuredDoseReferenceSequence);
		tagByName.put("RecordedSnoutSequence",TagFromName.RecordedSnoutSequence);
		tagByName.put("RecordedRangeShifterSequence",TagFromName.RecordedRangeShifterSequence);
		tagByName.put("RecordedLateralSpreadingDeviceSequence",TagFromName.RecordedLateralSpreadingDeviceSequence);
		tagByName.put("RecordedRangeModulatorSequence",TagFromName.RecordedRangeModulatorSequence);
		tagByName.put("RecordedSourceSequence",TagFromName.RecordedSourceSequence);
		tagByName.put("SourceSerialNumber",TagFromName.SourceSerialNumber);
		tagByName.put("TreatmentSessionApplicationSetupSequence",TagFromName.TreatmentSessionApplicationSetupSequence);
		tagByName.put("ApplicationSetupCheck",TagFromName.ApplicationSetupCheck);
		tagByName.put("RecordedBrachyAccessoryDeviceSequence",TagFromName.RecordedBrachyAccessoryDeviceSequence);
		tagByName.put("ReferencedBrachyAccessoryDeviceNumber",TagFromName.ReferencedBrachyAccessoryDeviceNumber);
		tagByName.put("RecordedChannelSequence",TagFromName.RecordedChannelSequence);
		tagByName.put("SpecifiedChannelTotalTime",TagFromName.SpecifiedChannelTotalTime);
		tagByName.put("DeliveredChannelTotalTime",TagFromName.DeliveredChannelTotalTime);
		tagByName.put("SpecifiedNumberOfPulses",TagFromName.SpecifiedNumberOfPulses);
		tagByName.put("DeliveredNumberOfPulses",TagFromName.DeliveredNumberOfPulses);
		tagByName.put("SpecifiedPulseRepetitionInterval",TagFromName.SpecifiedPulseRepetitionInterval);
		tagByName.put("DeliveredPulseRepetitionInterval",TagFromName.DeliveredPulseRepetitionInterval);
		tagByName.put("RecordedSourceApplicatorSequence",TagFromName.RecordedSourceApplicatorSequence);
		tagByName.put("ReferencedSourceApplicatorNumber",TagFromName.ReferencedSourceApplicatorNumber);
		tagByName.put("RecordedChannelShieldSequence",TagFromName.RecordedChannelShieldSequence);
		tagByName.put("ReferencedChannelShieldNumber",TagFromName.ReferencedChannelShieldNumber);
		tagByName.put("BrachyControlPointDeliveredSequence",TagFromName.BrachyControlPointDeliveredSequence);
		tagByName.put("SafePositionExitDate",TagFromName.SafePositionExitDate);
		tagByName.put("SafePositionExitTime",TagFromName.SafePositionExitTime);
		tagByName.put("SafePositionReturnDate",TagFromName.SafePositionReturnDate);
		tagByName.put("SafePositionReturnTime",TagFromName.SafePositionReturnTime);
		tagByName.put("CurrentTreatmentStatus",TagFromName.CurrentTreatmentStatus);
		tagByName.put("TreatmentStatusComment",TagFromName.TreatmentStatusComment);
		tagByName.put("FractionGroupSummarySequence",TagFromName.FractionGroupSummarySequence);
		tagByName.put("ReferencedFractionNumber",TagFromName.ReferencedFractionNumber);
		tagByName.put("FractionGroupType",TagFromName.FractionGroupType);
		tagByName.put("BeamStopperPosition",TagFromName.BeamStopperPosition);
		tagByName.put("FractionStatusSummarySequence",TagFromName.FractionStatusSummarySequence);
		tagByName.put("TreatmentDate",TagFromName.TreatmentDate);
		tagByName.put("TreatmentTime",TagFromName.TreatmentTime);
		tagByName.put("RTPlanLabel",TagFromName.RTPlanLabel);
		tagByName.put("RTPlanName",TagFromName.RTPlanName);
		tagByName.put("RTPlanDescription",TagFromName.RTPlanDescription);
		tagByName.put("RTPlanDate",TagFromName.RTPlanDate);
		tagByName.put("RTPlanTime",TagFromName.RTPlanTime);
		tagByName.put("TreatmentProtocols",TagFromName.TreatmentProtocols);
		tagByName.put("PlanIntent",TagFromName.PlanIntent);
		tagByName.put("TreatmentSites",TagFromName.TreatmentSites);
		tagByName.put("RTPlanGeometry",TagFromName.RTPlanGeometry);
		tagByName.put("PrescriptionDescription",TagFromName.PrescriptionDescription);
		tagByName.put("DoseReferenceSequence",TagFromName.DoseReferenceSequence);
		tagByName.put("DoseReferenceNumber",TagFromName.DoseReferenceNumber);
		tagByName.put("DoseReferenceUID",TagFromName.DoseReferenceUID);
		tagByName.put("DoseReferenceStructureType",TagFromName.DoseReferenceStructureType);
		tagByName.put("NominalBeamEnergyUnit",TagFromName.NominalBeamEnergyUnit);
		tagByName.put("DoseReferenceDescription",TagFromName.DoseReferenceDescription);
		tagByName.put("DoseReferencePointCoordinates",TagFromName.DoseReferencePointCoordinates);
		tagByName.put("NominalPriorDose",TagFromName.NominalPriorDose);
		tagByName.put("DoseReferenceType",TagFromName.DoseReferenceType);
		tagByName.put("ConstraintWeight",TagFromName.ConstraintWeight);
		tagByName.put("DeliveryWarningDose",TagFromName.DeliveryWarningDose);
		tagByName.put("DeliveryMaximumDose",TagFromName.DeliveryMaximumDose);
		tagByName.put("TargetMinimumDose",TagFromName.TargetMinimumDose);
		tagByName.put("TargetPrescriptionDose",TagFromName.TargetPrescriptionDose);
		tagByName.put("TargetMaximumDose",TagFromName.TargetMaximumDose);
		tagByName.put("TargetUnderdoseVolumeFraction",TagFromName.TargetUnderdoseVolumeFraction);
		tagByName.put("OrganAtRiskFullVolumeDose",TagFromName.OrganAtRiskFullVolumeDose);
		tagByName.put("OrganAtRiskLimitDose",TagFromName.OrganAtRiskLimitDose);
		tagByName.put("OrganAtRiskMaximumDose",TagFromName.OrganAtRiskMaximumDose);
		tagByName.put("OrganAtRiskOverdoseVolumeFraction",TagFromName.OrganAtRiskOverdoseVolumeFraction);
		tagByName.put("ToleranceTableSequence",TagFromName.ToleranceTableSequence);
		tagByName.put("ToleranceTableNumber",TagFromName.ToleranceTableNumber);
		tagByName.put("ToleranceTableLabel",TagFromName.ToleranceTableLabel);
		tagByName.put("GantryAngleTolerance",TagFromName.GantryAngleTolerance);
		tagByName.put("BeamLimitingDeviceAngleTolerance",TagFromName.BeamLimitingDeviceAngleTolerance);
		tagByName.put("BeamLimitingDeviceToleranceSequence",TagFromName.BeamLimitingDeviceToleranceSequence);
		tagByName.put("BeamLimitingDevicePositionTolerance",TagFromName.BeamLimitingDevicePositionTolerance);
		tagByName.put("SnoutPositionTolerance",TagFromName.SnoutPositionTolerance);
		tagByName.put("PatientSupportAngleTolerance",TagFromName.PatientSupportAngleTolerance);
		tagByName.put("TableTopEccentricAngleTolerance",TagFromName.TableTopEccentricAngleTolerance);
		tagByName.put("TableTopPitchAngleTolerance",TagFromName.TableTopPitchAngleTolerance);
		tagByName.put("TableTopRollAngleTolerance",TagFromName.TableTopRollAngleTolerance);
		tagByName.put("TableTopVerticalPositionTolerance",TagFromName.TableTopVerticalPositionTolerance);
		tagByName.put("TableTopLongitudinalPositionTolerance",TagFromName.TableTopLongitudinalPositionTolerance);
		tagByName.put("TableTopLateralPositionTolerance",TagFromName.TableTopLateralPositionTolerance);
		tagByName.put("RTPlanRelationship",TagFromName.RTPlanRelationship);
		tagByName.put("FractionGroupSequence",TagFromName.FractionGroupSequence);
		tagByName.put("FractionGroupNumber",TagFromName.FractionGroupNumber);
		tagByName.put("FractionGroupDescription",TagFromName.FractionGroupDescription);
		tagByName.put("NumberOfFractionsPlanned",TagFromName.NumberOfFractionsPlanned);
		tagByName.put("NumberOfFractionPatternDigitsPerDay",TagFromName.NumberOfFractionPatternDigitsPerDay);
		tagByName.put("RepeatFractionCycleLength",TagFromName.RepeatFractionCycleLength);
		tagByName.put("FractionPattern",TagFromName.FractionPattern);
		tagByName.put("NumberOfBeams",TagFromName.NumberOfBeams);
		tagByName.put("BeamDoseSpecificationPoint",TagFromName.BeamDoseSpecificationPoint);
		tagByName.put("BeamDose",TagFromName.BeamDose);
		tagByName.put("BeamMeterset",TagFromName.BeamMeterset);
		tagByName.put("BeamDosePointDepth",TagFromName.BeamDosePointDepth);
		tagByName.put("BeamDosePointEquivalentDepth",TagFromName.BeamDosePointEquivalentDepth);
		tagByName.put("BeamDosePointSSD",TagFromName.BeamDosePointSSD);
		tagByName.put("NumberOfBrachyApplicationSetups",TagFromName.NumberOfBrachyApplicationSetups);
		tagByName.put("BrachyApplicationSetupDoseSpecificationPoint",TagFromName.BrachyApplicationSetupDoseSpecificationPoint);
		tagByName.put("BrachyApplicationSetupDose",TagFromName.BrachyApplicationSetupDose);
		tagByName.put("BeamSequence",TagFromName.BeamSequence);
		tagByName.put("TreatmentMachineName",TagFromName.TreatmentMachineName);
		tagByName.put("PrimaryDosimeterUnit",TagFromName.PrimaryDosimeterUnit);
		tagByName.put("SourceAxisDistance",TagFromName.SourceAxisDistance);
		tagByName.put("BeamLimitingDeviceSequence",TagFromName.BeamLimitingDeviceSequence);
		tagByName.put("RTBeamLimitingDeviceType",TagFromName.RTBeamLimitingDeviceType);
		tagByName.put("SourceToBeamLimitingDeviceDistance",TagFromName.SourceToBeamLimitingDeviceDistance);
		tagByName.put("IsocenterToBeamLimitingDeviceDistance",TagFromName.IsocenterToBeamLimitingDeviceDistance);
		tagByName.put("NumberOfLeafJawPairs",TagFromName.NumberOfLeafJawPairs);
		tagByName.put("LeafPositionBoundaries",TagFromName.LeafPositionBoundaries);
		tagByName.put("BeamNumber",TagFromName.BeamNumber);
		tagByName.put("BeamName",TagFromName.BeamName);
		tagByName.put("BeamDescription",TagFromName.BeamDescription);
		tagByName.put("BeamType",TagFromName.BeamType);
		tagByName.put("RadiationType",TagFromName.RadiationType);
		tagByName.put("HighDoseTechniqueType",TagFromName.HighDoseTechniqueType);
		tagByName.put("ReferenceImageNumber",TagFromName.ReferenceImageNumber);
		tagByName.put("PlannedVerificationImageSequence",TagFromName.PlannedVerificationImageSequence);
		tagByName.put("ImagingDeviceSpecificAcquisitionParameters",TagFromName.ImagingDeviceSpecificAcquisitionParameters);
		tagByName.put("TreatmentDeliveryType",TagFromName.TreatmentDeliveryType);
		tagByName.put("NumberOfWedges",TagFromName.NumberOfWedges);
		tagByName.put("WedgeSequence",TagFromName.WedgeSequence);
		tagByName.put("WedgeNumber",TagFromName.WedgeNumber);
		tagByName.put("WedgeType",TagFromName.WedgeType);
		tagByName.put("WedgeID",TagFromName.WedgeID);
		tagByName.put("WedgeAngle",TagFromName.WedgeAngle);
		tagByName.put("WedgeFactor",TagFromName.WedgeFactor);
		tagByName.put("TotalWedgeTrayWaterEquivalentThickness",TagFromName.TotalWedgeTrayWaterEquivalentThickness);
		tagByName.put("WedgeOrientation",TagFromName.WedgeOrientation);
		tagByName.put("IsocenterToWedgeTrayDistance",TagFromName.IsocenterToWedgeTrayDistance);
		tagByName.put("SourceToWedgeTrayDistance",TagFromName.SourceToWedgeTrayDistance);
		tagByName.put("WedgeThinEdgePosition",TagFromName.WedgeThinEdgePosition);
		tagByName.put("BolusID",TagFromName.BolusID);
		tagByName.put("BolusDescription",TagFromName.BolusDescription);
		tagByName.put("NumberOfCompensators",TagFromName.NumberOfCompensators);
		tagByName.put("MaterialID",TagFromName.MaterialID);
		tagByName.put("TotalCompensatorTrayFactor",TagFromName.TotalCompensatorTrayFactor);
		tagByName.put("CompensatorSequence",TagFromName.CompensatorSequence);
		tagByName.put("CompensatorNumber",TagFromName.CompensatorNumber);
		tagByName.put("CompensatorID",TagFromName.CompensatorID);
		tagByName.put("SourceToCompensatorTrayDistance",TagFromName.SourceToCompensatorTrayDistance);
		tagByName.put("CompensatorRows",TagFromName.CompensatorRows);
		tagByName.put("CompensatorColumns",TagFromName.CompensatorColumns);
		tagByName.put("CompensatorPixelSpacing",TagFromName.CompensatorPixelSpacing);
		tagByName.put("CompensatorPosition",TagFromName.CompensatorPosition);
		tagByName.put("CompensatorTransmissionData",TagFromName.CompensatorTransmissionData);
		tagByName.put("CompensatorThicknessData",TagFromName.CompensatorThicknessData);
		tagByName.put("NumberOfBoli",TagFromName.NumberOfBoli);
		tagByName.put("CompensatorType",TagFromName.CompensatorType);
		tagByName.put("NumberOfBlocks",TagFromName.NumberOfBlocks);
		tagByName.put("TotalBlockTrayFactor",TagFromName.TotalBlockTrayFactor);
		tagByName.put("TotalBlockTrayWaterEquivalentThickness",TagFromName.TotalBlockTrayWaterEquivalentThickness);
		tagByName.put("BlockSequence",TagFromName.BlockSequence);
		tagByName.put("BlockTrayID",TagFromName.BlockTrayID);
		tagByName.put("SourceToBlockTrayDistance",TagFromName.SourceToBlockTrayDistance);
		tagByName.put("IsocenterToBlockTrayDistance",TagFromName.IsocenterToBlockTrayDistance);
		tagByName.put("BlockType",TagFromName.BlockType);
		tagByName.put("AccessoryCode",TagFromName.AccessoryCode);
		tagByName.put("BlockDivergence",TagFromName.BlockDivergence);
		tagByName.put("BlockMountingPosition",TagFromName.BlockMountingPosition);
		tagByName.put("BlockNumber",TagFromName.BlockNumber);
		tagByName.put("BlockName",TagFromName.BlockName);
		tagByName.put("BlockThickness",TagFromName.BlockThickness);
		tagByName.put("BlockTransmission",TagFromName.BlockTransmission);
		tagByName.put("BlockNumberOfPoints",TagFromName.BlockNumberOfPoints);
		tagByName.put("BlockData",TagFromName.BlockData);
		tagByName.put("ApplicatorSequence",TagFromName.ApplicatorSequence);
		tagByName.put("ApplicatorID",TagFromName.ApplicatorID);
		tagByName.put("ApplicatorType",TagFromName.ApplicatorType);
		tagByName.put("ApplicatorDescription",TagFromName.ApplicatorDescription);
		tagByName.put("CumulativeDoseReferenceCoefficient",TagFromName.CumulativeDoseReferenceCoefficient);
		tagByName.put("FinalCumulativeMetersetWeight",TagFromName.FinalCumulativeMetersetWeight);
		tagByName.put("NumberOfControlPoints",TagFromName.NumberOfControlPoints);
		tagByName.put("ControlPointSequence",TagFromName.ControlPointSequence);
		tagByName.put("ControlPointIndex",TagFromName.ControlPointIndex);
		tagByName.put("NominalBeamEnergy",TagFromName.NominalBeamEnergy);
		tagByName.put("DoseRateSet",TagFromName.DoseRateSet);
		tagByName.put("WedgePositionSequence",TagFromName.WedgePositionSequence);
		tagByName.put("WedgePosition",TagFromName.WedgePosition);
		tagByName.put("BeamLimitingDevicePositionSequence",TagFromName.BeamLimitingDevicePositionSequence);
		tagByName.put("LeafJawPositions",TagFromName.LeafJawPositions);
		tagByName.put("GantryAngle",TagFromName.GantryAngle);
		tagByName.put("GantryRotationDirection",TagFromName.GantryRotationDirection);
		tagByName.put("BeamLimitingDeviceAngle",TagFromName.BeamLimitingDeviceAngle);
		tagByName.put("BeamLimitingDeviceRotationDirection",TagFromName.BeamLimitingDeviceRotationDirection);
		tagByName.put("PatientSupportAngle",TagFromName.PatientSupportAngle);
		tagByName.put("PatientSupportRotationDirection",TagFromName.PatientSupportRotationDirection);
		tagByName.put("TableTopEccentricAxisDistance",TagFromName.TableTopEccentricAxisDistance);
		tagByName.put("TableTopEccentricAngle",TagFromName.TableTopEccentricAngle);
		tagByName.put("TableTopEccentricRotationDirection",TagFromName.TableTopEccentricRotationDirection);
		tagByName.put("TableTopVerticalPosition",TagFromName.TableTopVerticalPosition);
		tagByName.put("TableTopLongitudinalPosition",TagFromName.TableTopLongitudinalPosition);
		tagByName.put("TableTopLateralPosition",TagFromName.TableTopLateralPosition);
		tagByName.put("IsocenterPosition",TagFromName.IsocenterPosition);
		tagByName.put("SurfaceEntryPoint",TagFromName.SurfaceEntryPoint);
		tagByName.put("SourceToSurfaceDistance",TagFromName.SourceToSurfaceDistance);
		tagByName.put("CumulativeMetersetWeight",TagFromName.CumulativeMetersetWeight);
		tagByName.put("TableTopPitchAngle",TagFromName.TableTopPitchAngle);
		tagByName.put("TableTopPitchRotationDirection",TagFromName.TableTopPitchRotationDirection);
		tagByName.put("TableTopRollAngle",TagFromName.TableTopRollAngle);
		tagByName.put("TableTopRollRotationDirection",TagFromName.TableTopRollRotationDirection);
		tagByName.put("HeadFixationAngle",TagFromName.HeadFixationAngle);
		tagByName.put("GantryPitchAngle",TagFromName.GantryPitchAngle);
		tagByName.put("GantryPitchRotationDirection",TagFromName.GantryPitchRotationDirection);
		tagByName.put("GantryPitchAngleTolerance",TagFromName.GantryPitchAngleTolerance);
		tagByName.put("PatientSetupSequence",TagFromName.PatientSetupSequence);
		tagByName.put("PatientSetupNumber",TagFromName.PatientSetupNumber);
		tagByName.put("PatientSetupLabel",TagFromName.PatientSetupLabel);
		tagByName.put("PatientAdditionalPosition",TagFromName.PatientAdditionalPosition);
		tagByName.put("FixationDeviceSequence",TagFromName.FixationDeviceSequence);
		tagByName.put("FixationDeviceType",TagFromName.FixationDeviceType);
		tagByName.put("FixationDeviceLabel",TagFromName.FixationDeviceLabel);
		tagByName.put("FixationDeviceDescription",TagFromName.FixationDeviceDescription);
		tagByName.put("FixationDevicePosition",TagFromName.FixationDevicePosition);
		tagByName.put("FixationDevicePitchAngle",TagFromName.FixationDevicePitchAngle);
		tagByName.put("FixationDeviceRollAngle",TagFromName.FixationDeviceRollAngle);
		tagByName.put("ShieldingDeviceSequence",TagFromName.ShieldingDeviceSequence);
		tagByName.put("ShieldingDeviceType",TagFromName.ShieldingDeviceType);
		tagByName.put("ShieldingDeviceLabel",TagFromName.ShieldingDeviceLabel);
		tagByName.put("ShieldingDeviceDescription",TagFromName.ShieldingDeviceDescription);
		tagByName.put("ShieldingDevicePosition",TagFromName.ShieldingDevicePosition);
		tagByName.put("SetupTechnique",TagFromName.SetupTechnique);
		tagByName.put("SetupTechniqueDescription",TagFromName.SetupTechniqueDescription);
		tagByName.put("SetupDeviceSequence",TagFromName.SetupDeviceSequence);
		tagByName.put("SetupDeviceType",TagFromName.SetupDeviceType);
		tagByName.put("SetupDeviceLabel",TagFromName.SetupDeviceLabel);
		tagByName.put("SetupDeviceDescription",TagFromName.SetupDeviceDescription);
		tagByName.put("SetupDeviceParameter",TagFromName.SetupDeviceParameter);
		tagByName.put("SetupReferenceDescription",TagFromName.SetupReferenceDescription);
		tagByName.put("TableTopVerticalSetupDisplacement",TagFromName.TableTopVerticalSetupDisplacement);
		tagByName.put("TableTopLongitudinalSetupDisplacement",TagFromName.TableTopLongitudinalSetupDisplacement);
		tagByName.put("TableTopLateralSetupDisplacement",TagFromName.TableTopLateralSetupDisplacement);
		tagByName.put("BrachyTreatmentTechnique",TagFromName.BrachyTreatmentTechnique);
		tagByName.put("BrachyTreatmentType",TagFromName.BrachyTreatmentType);
		tagByName.put("TreatmentMachineSequence",TagFromName.TreatmentMachineSequence);
		tagByName.put("SourceSequence",TagFromName.SourceSequence);
		tagByName.put("SourceNumber",TagFromName.SourceNumber);
		tagByName.put("SourceType",TagFromName.SourceType);
		tagByName.put("SourceManufacturer",TagFromName.SourceManufacturer);
		tagByName.put("ActiveSourceDiameter",TagFromName.ActiveSourceDiameter);
		tagByName.put("ActiveSourceLength",TagFromName.ActiveSourceLength);
		tagByName.put("SourceEncapsulationNominalThickness",TagFromName.SourceEncapsulationNominalThickness);
		tagByName.put("SourceEncapsulationNominalTransmission",TagFromName.SourceEncapsulationNominalTransmission);
		tagByName.put("SourceIsotopeName",TagFromName.SourceIsotopeName);
		tagByName.put("SourceIsotopeHalfLife",TagFromName.SourceIsotopeHalfLife);
		tagByName.put("SourceStrengthUnits",TagFromName.SourceStrengthUnits);
		tagByName.put("ReferenceAirKermaRate",TagFromName.ReferenceAirKermaRate);
		tagByName.put("SourceStrength",TagFromName.SourceStrength);
		tagByName.put("SourceStrengthReferenceDate",TagFromName.SourceStrengthReferenceDate);
		tagByName.put("SourceStrengthReferenceTime",TagFromName.SourceStrengthReferenceTime);
		tagByName.put("ApplicationSetupSequence",TagFromName.ApplicationSetupSequence);
		tagByName.put("ApplicationSetupType",TagFromName.ApplicationSetupType);
		tagByName.put("ApplicationSetupNumber",TagFromName.ApplicationSetupNumber);
		tagByName.put("ApplicationSetupName",TagFromName.ApplicationSetupName);
		tagByName.put("ApplicationSetupManufacturer",TagFromName.ApplicationSetupManufacturer);
		tagByName.put("TemplateNumber",TagFromName.TemplateNumber);
		tagByName.put("TemplateType",TagFromName.TemplateType);
		tagByName.put("TemplateName",TagFromName.TemplateName);
		tagByName.put("TotalReferenceAirKerma",TagFromName.TotalReferenceAirKerma);
		tagByName.put("BrachyAccessoryDeviceSequence",TagFromName.BrachyAccessoryDeviceSequence);
		tagByName.put("BrachyAccessoryDeviceNumber",TagFromName.BrachyAccessoryDeviceNumber);
		tagByName.put("BrachyAccessoryDeviceID",TagFromName.BrachyAccessoryDeviceID);
		tagByName.put("BrachyAccessoryDeviceType",TagFromName.BrachyAccessoryDeviceType);
		tagByName.put("BrachyAccessoryDeviceName",TagFromName.BrachyAccessoryDeviceName);
		tagByName.put("BrachyAccessoryDeviceNominalThickness",TagFromName.BrachyAccessoryDeviceNominalThickness);
		tagByName.put("BrachyAccessoryDeviceNominalTransmission",TagFromName.BrachyAccessoryDeviceNominalTransmission);
		tagByName.put("ChannelSequence",TagFromName.ChannelSequence);
		tagByName.put("ChannelNumber",TagFromName.ChannelNumber);
		tagByName.put("ChannelLength",TagFromName.ChannelLength);
		tagByName.put("ChannelTotalTime",TagFromName.ChannelTotalTime);
		tagByName.put("SourceMovementType",TagFromName.SourceMovementType);
		tagByName.put("NumberOfPulses",TagFromName.NumberOfPulses);
		tagByName.put("PulseRepetitionInterval",TagFromName.PulseRepetitionInterval);
		tagByName.put("SourceApplicatorNumber",TagFromName.SourceApplicatorNumber);
		tagByName.put("SourceApplicatorID",TagFromName.SourceApplicatorID);
		tagByName.put("SourceApplicatorType",TagFromName.SourceApplicatorType);
		tagByName.put("SourceApplicatorName",TagFromName.SourceApplicatorName);
		tagByName.put("SourceApplicatorLength",TagFromName.SourceApplicatorLength);
		tagByName.put("SourceApplicatorManufacturer",TagFromName.SourceApplicatorManufacturer);
		tagByName.put("SourceApplicatorWallNominalThickness",TagFromName.SourceApplicatorWallNominalThickness);
		tagByName.put("SourceApplicatorWallNominalTransmission",TagFromName.SourceApplicatorWallNominalTransmission);
		tagByName.put("SourceApplicatorStepSize",TagFromName.SourceApplicatorStepSize);
		tagByName.put("TransferTubeNumber",TagFromName.TransferTubeNumber);
		tagByName.put("TransferTubeLength",TagFromName.TransferTubeLength);
		tagByName.put("ChannelShieldSequence",TagFromName.ChannelShieldSequence);
		tagByName.put("ChannelShieldNumber",TagFromName.ChannelShieldNumber);
		tagByName.put("ChannelShieldID",TagFromName.ChannelShieldID);
		tagByName.put("ChannelShieldName",TagFromName.ChannelShieldName);
		tagByName.put("ChannelShieldNominalThickness",TagFromName.ChannelShieldNominalThickness);
		tagByName.put("ChannelShieldNominalTransmission",TagFromName.ChannelShieldNominalTransmission);
		tagByName.put("FinalCumulativeTimeWeight",TagFromName.FinalCumulativeTimeWeight);
		tagByName.put("BrachyControlPointSequence",TagFromName.BrachyControlPointSequence);
		tagByName.put("ControlPointRelativePosition",TagFromName.ControlPointRelativePosition);
		tagByName.put("ControlPoint3DPosition",TagFromName.ControlPoint3DPosition);
		tagByName.put("CumulativeTimeWeight",TagFromName.CumulativeTimeWeight);
		tagByName.put("CompensatorDivergence",TagFromName.CompensatorDivergence);
		tagByName.put("CompensatorMountingPosition",TagFromName.CompensatorMountingPosition);
		tagByName.put("SourceToCompensatorDistance",TagFromName.SourceToCompensatorDistance);
		tagByName.put("TotalCompensatorTrayWaterEquivalentThickness",TagFromName.TotalCompensatorTrayWaterEquivalentThickness);
		tagByName.put("IsocenterToCompensatorTrayDistance",TagFromName.IsocenterToCompensatorTrayDistance);
		tagByName.put("CompensatorColumnOffset",TagFromName.CompensatorColumnOffset);
		tagByName.put("IsocenterToCompensatorDistances",TagFromName.IsocenterToCompensatorDistances);
		tagByName.put("CompensatorRelativeStoppingPowerRatio",TagFromName.CompensatorRelativeStoppingPowerRatio);
		tagByName.put("CompensatorMillingToolDiameter",TagFromName.CompensatorMillingToolDiameter);
		tagByName.put("IonRangeCompensatorSequence",TagFromName.IonRangeCompensatorSequence);
		tagByName.put("CompensatorDescription",TagFromName.CompensatorDescription);
		tagByName.put("RadiationMassNumber",TagFromName.RadiationMassNumber);
		tagByName.put("RadiationAtomicNumber",TagFromName.RadiationAtomicNumber);
		tagByName.put("RadiationChargeState",TagFromName.RadiationChargeState);
		tagByName.put("ScanMode",TagFromName.ScanMode);
		tagByName.put("VirtualSourceAxisDistances",TagFromName.VirtualSourceAxisDistances);
		tagByName.put("SnoutSequence",TagFromName.SnoutSequence);
		tagByName.put("SnoutPosition",TagFromName.SnoutPosition);
		tagByName.put("SnoutID",TagFromName.SnoutID);
		tagByName.put("NumberOfRangeShifters",TagFromName.NumberOfRangeShifters);
		tagByName.put("RangeShifterSequence",TagFromName.RangeShifterSequence);
		tagByName.put("RangeShifterNumber",TagFromName.RangeShifterNumber);
		tagByName.put("RangeShifterID",TagFromName.RangeShifterID);
		tagByName.put("RangeShifterType",TagFromName.RangeShifterType);
		tagByName.put("RangeShifterDescription",TagFromName.RangeShifterDescription);
		tagByName.put("NumberOfLateralSpreadingDevices",TagFromName.NumberOfLateralSpreadingDevices);
		tagByName.put("LateralSpreadingDeviceSequence",TagFromName.LateralSpreadingDeviceSequence);
		tagByName.put("LateralSpreadingDeviceNumber",TagFromName.LateralSpreadingDeviceNumber);
		tagByName.put("LateralSpreadingDeviceID",TagFromName.LateralSpreadingDeviceID);
		tagByName.put("LateralSpreadingDeviceType",TagFromName.LateralSpreadingDeviceType);
		tagByName.put("LateralSpreadingDeviceDescription",TagFromName.LateralSpreadingDeviceDescription);
		tagByName.put("LateralSpreadingDeviceWaterEquivalentThickness",TagFromName.LateralSpreadingDeviceWaterEquivalentThickness);
		tagByName.put("NumberOfRangeModulators",TagFromName.NumberOfRangeModulators);
		tagByName.put("RangeModulatorSequence",TagFromName.RangeModulatorSequence);
		tagByName.put("RangeModulatorNumber",TagFromName.RangeModulatorNumber);
		tagByName.put("RangeModulatorID",TagFromName.RangeModulatorID);
		tagByName.put("RangeModulatorType",TagFromName.RangeModulatorType);
		tagByName.put("RangeModulatorDescription",TagFromName.RangeModulatorDescription);
		tagByName.put("BeamCurrentModulationID",TagFromName.BeamCurrentModulationID);
		tagByName.put("PatientSupportType",TagFromName.PatientSupportType);
		tagByName.put("PatientSupportID",TagFromName.PatientSupportID);
		tagByName.put("PatientSupportAccessoryCode",TagFromName.PatientSupportAccessoryCode);
		tagByName.put("FixationLightAzimuthalAngle",TagFromName.FixationLightAzimuthalAngle);
		tagByName.put("FixationLightPolarAngle",TagFromName.FixationLightPolarAngle);
		tagByName.put("MetersetRate",TagFromName.MetersetRate);
		tagByName.put("RangeShifterSettingsSequence",TagFromName.RangeShifterSettingsSequence);
		tagByName.put("RangeShifterSetting",TagFromName.RangeShifterSetting);
		tagByName.put("IsocenterToRangeShifterDistance",TagFromName.IsocenterToRangeShifterDistance);
		tagByName.put("RangeShifterWaterEquivalentThickness",TagFromName.RangeShifterWaterEquivalentThickness);
		tagByName.put("LateralSpreadingDeviceSettingsSequence",TagFromName.LateralSpreadingDeviceSettingsSequence);
		tagByName.put("LateralSpreadingDeviceSetting",TagFromName.LateralSpreadingDeviceSetting);
		tagByName.put("IsocenterToLateralSpreadingDeviceDistance",TagFromName.IsocenterToLateralSpreadingDeviceDistance);
		tagByName.put("RangeModulatorSettingsSequence",TagFromName.RangeModulatorSettingsSequence);
		tagByName.put("RangeModulatorGatingStartValue",TagFromName.RangeModulatorGatingStartValue);
		tagByName.put("RangeModulatorGatingStopValue",TagFromName.RangeModulatorGatingStopValue);
		tagByName.put("RangeModulatorGatingStartWaterEquivalentThickness",TagFromName.RangeModulatorGatingStartWaterEquivalentThickness);
		tagByName.put("RangeModulatorGatingStopWaterEquivalentThickness",TagFromName.RangeModulatorGatingStopWaterEquivalentThickness);
		tagByName.put("IsocenterToRangeModulatorDistance",TagFromName.IsocenterToRangeModulatorDistance);
		tagByName.put("ScanSpotTuneID",TagFromName.ScanSpotTuneID);
		tagByName.put("NumberOfScanSpotPositions",TagFromName.NumberOfScanSpotPositions);
		tagByName.put("ScanSpotPositionMap",TagFromName.ScanSpotPositionMap);
		tagByName.put("ScanSpotMetersetWeights",TagFromName.ScanSpotMetersetWeights);
		tagByName.put("ScanningSpotSize",TagFromName.ScanningSpotSize);
		tagByName.put("NumberOfPaintings",TagFromName.NumberOfPaintings);
		tagByName.put("IonToleranceTableSequence",TagFromName.IonToleranceTableSequence);
		tagByName.put("IonBeamSequence",TagFromName.IonBeamSequence);
		tagByName.put("IonBeamLimitingDeviceSequence",TagFromName.IonBeamLimitingDeviceSequence);
		tagByName.put("IonBlockSequence",TagFromName.IonBlockSequence);
		tagByName.put("IonControlPointSequence",TagFromName.IonControlPointSequence);
		tagByName.put("IonWedgeSequence",TagFromName.IonWedgeSequence);
		tagByName.put("IonWedgePositionSequence",TagFromName.IonWedgePositionSequence);
		tagByName.put("ReferencedSetupImageSequence",TagFromName.ReferencedSetupImageSequence);
		tagByName.put("SetupImageComment",TagFromName.SetupImageComment);
		tagByName.put("MotionSynchronizationSequence",TagFromName.MotionSynchronizationSequence);
		tagByName.put("ControlPointOrientation",TagFromName.ControlPointOrientation);
		tagByName.put("GeneralAccessorySequence",TagFromName.GeneralAccessorySequence);
		tagByName.put("GeneralAccessoryID",TagFromName.GeneralAccessoryID);
		tagByName.put("GeneralAccessoryDescription",TagFromName.GeneralAccessoryDescription);
		tagByName.put("GeneralAccessoryType",TagFromName.GeneralAccessoryType);
		tagByName.put("GeneralAccessoryNumber",TagFromName.GeneralAccessoryNumber);
		tagByName.put("ReferencedRTPlanSequence",TagFromName.ReferencedRTPlanSequence);
		tagByName.put("ReferencedBeamSequence",TagFromName.ReferencedBeamSequence);
		tagByName.put("ReferencedBeamNumber",TagFromName.ReferencedBeamNumber);
		tagByName.put("ReferencedReferenceImageNumber",TagFromName.ReferencedReferenceImageNumber);
		tagByName.put("StartCumulativeMetersetWeight",TagFromName.StartCumulativeMetersetWeight);
		tagByName.put("EndCumulativeMetersetWeight",TagFromName.EndCumulativeMetersetWeight);
		tagByName.put("ReferencedBrachyApplicationSetupSequence",TagFromName.ReferencedBrachyApplicationSetupSequence);
		tagByName.put("ReferencedBrachyApplicationSetupNumber",TagFromName.ReferencedBrachyApplicationSetupNumber);
		tagByName.put("ReferencedSourceNumber",TagFromName.ReferencedSourceNumber);
		tagByName.put("ReferencedFractionGroupSequence",TagFromName.ReferencedFractionGroupSequence);
		tagByName.put("ReferencedFractionGroupNumber",TagFromName.ReferencedFractionGroupNumber);
		tagByName.put("ReferencedVerificationImageSequence",TagFromName.ReferencedVerificationImageSequence);
		tagByName.put("ReferencedReferenceImageSequence",TagFromName.ReferencedReferenceImageSequence);
		tagByName.put("ReferencedDoseReferenceSequence",TagFromName.ReferencedDoseReferenceSequence);
		tagByName.put("ReferencedDoseReferenceNumber",TagFromName.ReferencedDoseReferenceNumber);
		tagByName.put("BrachyReferencedDoseReferenceSequence",TagFromName.BrachyReferencedDoseReferenceSequence);
		tagByName.put("ReferencedStructureSetSequence",TagFromName.ReferencedStructureSetSequence);
		tagByName.put("ReferencedPatientSetupNumber",TagFromName.ReferencedPatientSetupNumber);
		tagByName.put("ReferencedDoseSequence",TagFromName.ReferencedDoseSequence);
		tagByName.put("ReferencedToleranceTableNumber",TagFromName.ReferencedToleranceTableNumber);
		tagByName.put("ReferencedBolusSequence",TagFromName.ReferencedBolusSequence);
		tagByName.put("ReferencedWedgeNumber",TagFromName.ReferencedWedgeNumber);
		tagByName.put("ReferencedCompensatorNumber",TagFromName.ReferencedCompensatorNumber);
		tagByName.put("ReferencedBlockNumber",TagFromName.ReferencedBlockNumber);
		tagByName.put("ReferencedControlPointIndex",TagFromName.ReferencedControlPointIndex);
		tagByName.put("ReferencedControlPointSequence",TagFromName.ReferencedControlPointSequence);
		tagByName.put("ReferencedStartControlPointIndex",TagFromName.ReferencedStartControlPointIndex);
		tagByName.put("ReferencedStopControlPointIndex",TagFromName.ReferencedStopControlPointIndex);
		tagByName.put("ReferencedRangeShifterNumber",TagFromName.ReferencedRangeShifterNumber);
		tagByName.put("ReferencedLateralSpreadingDeviceNumber",TagFromName.ReferencedLateralSpreadingDeviceNumber);
		tagByName.put("ReferencedRangeModulatorNumber",TagFromName.ReferencedRangeModulatorNumber);
		tagByName.put("ApprovalStatus",TagFromName.ApprovalStatus);
		tagByName.put("ReviewDate",TagFromName.ReviewDate);
		tagByName.put("ReviewTime",TagFromName.ReviewTime);
		tagByName.put("ReviewerName",TagFromName.ReviewerName);
		tagByName.put("Arbitrary",TagFromName.Arbitrary);
		tagByName.put("TextComments",TagFromName.TextComments);
		tagByName.put("ResultsID",TagFromName.ResultsID);
		tagByName.put("ResultsIDIssuer",TagFromName.ResultsIDIssuer);
		tagByName.put("ReferencedInterpretationSequence",TagFromName.ReferencedInterpretationSequence);
		tagByName.put("ReportProductionStatusTrial",TagFromName.ReportProductionStatusTrial);
		tagByName.put("InterpretationRecordedDate",TagFromName.InterpretationRecordedDate);
		tagByName.put("InterpretationRecordedTime",TagFromName.InterpretationRecordedTime);
		tagByName.put("InterpretationRecorder",TagFromName.InterpretationRecorder);
		tagByName.put("ReferenceToRecordedSound",TagFromName.ReferenceToRecordedSound);
		tagByName.put("InterpretationTranscriptionDate",TagFromName.InterpretationTranscriptionDate);
		tagByName.put("InterpretationTranscriptionTime",TagFromName.InterpretationTranscriptionTime);
		tagByName.put("InterpretationTranscriber",TagFromName.InterpretationTranscriber);
		tagByName.put("InterpretationText",TagFromName.InterpretationText);
		tagByName.put("InterpretationAuthor",TagFromName.InterpretationAuthor);
		tagByName.put("InterpretationApproverSequence",TagFromName.InterpretationApproverSequence);
		tagByName.put("InterpretationApprovalDate",TagFromName.InterpretationApprovalDate);
		tagByName.put("InterpretationApprovalTime",TagFromName.InterpretationApprovalTime);
		tagByName.put("PhysicianApprovingInterpretation",TagFromName.PhysicianApprovingInterpretation);
		tagByName.put("InterpretationDiagnosisDescription",TagFromName.InterpretationDiagnosisDescription);
		tagByName.put("InterpretationDiagnosisCodeSequence",TagFromName.InterpretationDiagnosisCodeSequence);
		tagByName.put("ResultsDistributionListSequence",TagFromName.ResultsDistributionListSequence);
		tagByName.put("DistributionName",TagFromName.DistributionName);
		tagByName.put("DistributionAddress",TagFromName.DistributionAddress);
		tagByName.put("InterpretationID",TagFromName.InterpretationID);
		tagByName.put("InterpretationIDIssuer",TagFromName.InterpretationIDIssuer);
		tagByName.put("InterpretationTypeID",TagFromName.InterpretationTypeID);
		tagByName.put("InterpretationStatusID",TagFromName.InterpretationStatusID);
		tagByName.put("Impressions",TagFromName.Impressions);
		tagByName.put("ResultsComments",TagFromName.ResultsComments);
		tagByName.put("MACParametersSequence",TagFromName.MACParametersSequence);
		tagByName.put("CurveDimensions",TagFromName.CurveDimensions);
		tagByName.put("NumberOfPoints",TagFromName.NumberOfPoints);
		tagByName.put("TypeOfData",TagFromName.TypeOfData);
		tagByName.put("CurveDescription",TagFromName.CurveDescription);
		tagByName.put("AxisUnits",TagFromName.AxisUnits);
		tagByName.put("AxisLabels",TagFromName.AxisLabels);
		tagByName.put("DataValueRepresentation",TagFromName.DataValueRepresentation);
		tagByName.put("MinimumCoordinateValue",TagFromName.MinimumCoordinateValue);
		tagByName.put("MaximumCoordinateValue",TagFromName.MaximumCoordinateValue);
		tagByName.put("CurveRange",TagFromName.CurveRange);
		tagByName.put("CurveDataDescriptor",TagFromName.CurveDataDescriptor);
		tagByName.put("CoordinateStartValue",TagFromName.CoordinateStartValue);
		tagByName.put("CoordinateStepValue",TagFromName.CoordinateStepValue);
		tagByName.put("CurveActivationLayer",TagFromName.CurveActivationLayer);
		tagByName.put("AudioType",TagFromName.AudioType);
		tagByName.put("AudioSampleFormat",TagFromName.AudioSampleFormat);
		tagByName.put("NumberOfChannels",TagFromName.NumberOfChannels);
		tagByName.put("NumberOfSamples",TagFromName.NumberOfSamples);
		tagByName.put("SampleRate",TagFromName.SampleRate);
		tagByName.put("TotalTime",TagFromName.TotalTime);
		tagByName.put("AudioSampleData",TagFromName.AudioSampleData);
		tagByName.put("AudioComments",TagFromName.AudioComments);
		tagByName.put("CurveLabel",TagFromName.CurveLabel);
		tagByName.put("CurveReferencedOverlaySequence",TagFromName.CurveReferencedOverlaySequence);
		tagByName.put("CurveReferencedOverlayGroup",TagFromName.CurveReferencedOverlayGroup);
		tagByName.put("CurveData",TagFromName.CurveData);
		tagByName.put("SharedFunctionalGroupsSequence",TagFromName.SharedFunctionalGroupsSequence);
		tagByName.put("PerFrameFunctionalGroupsSequence",TagFromName.PerFrameFunctionalGroupsSequence);
		tagByName.put("WaveformSequence",TagFromName.WaveformSequence);
		tagByName.put("ChannelMinimumValue",TagFromName.ChannelMinimumValue);
		tagByName.put("ChannelMaximumValue",TagFromName.ChannelMaximumValue);
		tagByName.put("WaveformBitsAllocated",TagFromName.WaveformBitsAllocated);
		tagByName.put("WaveformSampleInterpretation",TagFromName.WaveformSampleInterpretation);
		tagByName.put("WaveformPaddingValue",TagFromName.WaveformPaddingValue);
		tagByName.put("WaveformData",TagFromName.WaveformData);
		tagByName.put("FirstOrderPhaseCorrectionAngle",TagFromName.FirstOrderPhaseCorrectionAngle);
		tagByName.put("SpectroscopyData",TagFromName.SpectroscopyData);
		tagByName.put("OverlayRows",TagFromName.OverlayRows);
		tagByName.put("OverlayColumns",TagFromName.OverlayColumns);
		tagByName.put("OverlayPlanes",TagFromName.OverlayPlanes);
		tagByName.put("NumberOfFramesInOverlay",TagFromName.NumberOfFramesInOverlay);
		tagByName.put("OverlayDescription",TagFromName.OverlayDescription);
		tagByName.put("OverlayType",TagFromName.OverlayType);
		tagByName.put("OverlaySubtype",TagFromName.OverlaySubtype);
		tagByName.put("OverlayOrigin",TagFromName.OverlayOrigin);
		tagByName.put("ImageFrameOrigin",TagFromName.ImageFrameOrigin);
		tagByName.put("PlaneOrigin",TagFromName.PlaneOrigin);
		tagByName.put("OverlayCompressionCode",TagFromName.OverlayCompressionCode);
		tagByName.put("OverlayCompressionOriginator",TagFromName.OverlayCompressionOriginator);
		tagByName.put("OverlayCompressionLabel",TagFromName.OverlayCompressionLabel);
		tagByName.put("OverlayCompressionDescription",TagFromName.OverlayCompressionDescription);
		tagByName.put("OverlayCompressionStepPointers",TagFromName.OverlayCompressionStepPointers);
		tagByName.put("OverlayRepeatInterval",TagFromName.OverlayRepeatInterval);
		tagByName.put("OverlayBitsGrouped",TagFromName.OverlayBitsGrouped);
		tagByName.put("OverlayBitsAllocated",TagFromName.OverlayBitsAllocated);
		tagByName.put("OverlayBitPosition",TagFromName.OverlayBitPosition);
		tagByName.put("OverlayFormat",TagFromName.OverlayFormat);
		tagByName.put("OverlayLocation",TagFromName.OverlayLocation);
		tagByName.put("OverlayCodeLabel",TagFromName.OverlayCodeLabel);
		tagByName.put("OverlayNumberOfTables",TagFromName.OverlayNumberOfTables);
		tagByName.put("OverlayCodeTableLocation",TagFromName.OverlayCodeTableLocation);
		tagByName.put("OverlayBitsForCodeWord",TagFromName.OverlayBitsForCodeWord);
		tagByName.put("OverlayActivationLayer",TagFromName.OverlayActivationLayer);
		tagByName.put("OverlayDescriptorGray",TagFromName.OverlayDescriptorGray);
		tagByName.put("OverlayDescriptorRed",TagFromName.OverlayDescriptorRed);
		tagByName.put("OverlayDescriptorGreen",TagFromName.OverlayDescriptorGreen);
		tagByName.put("OverlayDescriptorBlue",TagFromName.OverlayDescriptorBlue);
		tagByName.put("OverlayGray",TagFromName.OverlayGray);
		tagByName.put("OverlayRed",TagFromName.OverlayRed);
		tagByName.put("OverlayGreen",TagFromName.OverlayGreen);
		tagByName.put("OverlayBlue",TagFromName.OverlayBlue);
		tagByName.put("ROIArea",TagFromName.ROIArea);
		tagByName.put("ROIMean",TagFromName.ROIMean);
		tagByName.put("ROIStandardDeviation",TagFromName.ROIStandardDeviation);
		tagByName.put("OverlayLabel",TagFromName.OverlayLabel);
		tagByName.put("OverlayData",TagFromName.OverlayData);
		tagByName.put("OverlayComments",TagFromName.OverlayComments);
		tagByName.put("PixelData",TagFromName.PixelData);
		tagByName.put("CoefficientsSDVN",TagFromName.CoefficientsSDVN);
		tagByName.put("CoefficientsSDHN",TagFromName.CoefficientsSDHN);
		tagByName.put("CoefficientsSDDN",TagFromName.CoefficientsSDDN);
		tagByName.put("VariablePixelData",TagFromName.VariablePixelData);
		tagByName.put("VariableNextDataGroup",TagFromName.VariableNextDataGroup);
		tagByName.put("VariableCoefficientsSDVN",TagFromName.VariableCoefficientsSDVN);
		tagByName.put("VariableCoefficientsSDHN",TagFromName.VariableCoefficientsSDHN);
		tagByName.put("VariableCoefficientsSDDN",TagFromName.VariableCoefficientsSDDN);
		tagByName.put("DigitalSignaturesSequence",TagFromName.DigitalSignaturesSequence);
		tagByName.put("DataSetTrailingPadding",TagFromName.DataSetTrailingPadding);
	}

	protected void createNameByTag() {

		nameByTag = new HashMap(100);

		nameByTag.put(TagFromName.CommandGroupLength,"CommandGroupLength");
		nameByTag.put(TagFromName.CommandLengthToEnd,"CommandLengthToEnd");
		nameByTag.put(TagFromName.AffectedSOPClassUID,"AffectedSOPClassUID");
		nameByTag.put(TagFromName.RequestedSOPClassUID,"RequestedSOPClassUID");
		nameByTag.put(TagFromName.CommandRecognitionCode,"CommandRecognitionCode");
		nameByTag.put(TagFromName.CommandField,"CommandField");
		nameByTag.put(TagFromName.MessageID,"MessageID");
		nameByTag.put(TagFromName.MessageIDBeingRespondedTo,"MessageIDBeingRespondedTo");
		nameByTag.put(TagFromName.Initiator,"Initiator");
		nameByTag.put(TagFromName.Receiver,"Receiver");
		nameByTag.put(TagFromName.FindLocation,"FindLocation");
		nameByTag.put(TagFromName.MoveDestination,"MoveDestination");
		nameByTag.put(TagFromName.Priority,"Priority");
		nameByTag.put(TagFromName.DataSetType,"DataSetType");
		nameByTag.put(TagFromName.NumberOfMatches,"NumberOfMatches");
		nameByTag.put(TagFromName.ResponseSequenceNumber,"ResponseSequenceNumber");
		nameByTag.put(TagFromName.Status,"Status");
		nameByTag.put(TagFromName.OffendingElement,"OffendingElement");
		nameByTag.put(TagFromName.ErrorComment,"ErrorComment");
		nameByTag.put(TagFromName.ErrorID,"ErrorID");
		nameByTag.put(TagFromName.AffectedSOPInstanceUID,"AffectedSOPInstanceUID");
		nameByTag.put(TagFromName.RequestedSOPInstanceUID,"RequestedSOPInstanceUID");
		nameByTag.put(TagFromName.EventTypeID,"EventTypeID");
		nameByTag.put(TagFromName.AttributeIdentifierList,"AttributeIdentifierList");
		nameByTag.put(TagFromName.ActionTypeID,"ActionTypeID");
		nameByTag.put(TagFromName.NumberOfRemainingSuboperations,"NumberOfRemainingSuboperations");
		nameByTag.put(TagFromName.NumberOfCompletedSuboperations,"NumberOfCompletedSuboperations");
		nameByTag.put(TagFromName.NumberOfFailedSuboperations,"NumberOfFailedSuboperations");
		nameByTag.put(TagFromName.NumberOfWarningSuboperations,"NumberOfWarningSuboperations");
		nameByTag.put(TagFromName.MoveOriginatorApplicationEntityTitle,"MoveOriginatorApplicationEntityTitle");
		nameByTag.put(TagFromName.MoveOriginatorMessageID,"MoveOriginatorMessageID");
		nameByTag.put(TagFromName.DialogReceiver,"DialogReceiver");
		nameByTag.put(TagFromName.TerminalType,"TerminalType");
		nameByTag.put(TagFromName.MessageSetID,"MessageSetID");
		nameByTag.put(TagFromName.EndMessageSet,"EndMessageSet");
		nameByTag.put(TagFromName.DisplayFormat,"DisplayFormat");
		nameByTag.put(TagFromName.PagePositionID,"PagePositionID");
		nameByTag.put(TagFromName.TextFormatID,"TextFormatID");
		nameByTag.put(TagFromName.NormalReverse,"NormalReverse");
		nameByTag.put(TagFromName.AddGrayScale,"AddGrayScale");
		nameByTag.put(TagFromName.Borders,"Borders");
		nameByTag.put(TagFromName.Copies,"Copies");
		nameByTag.put(TagFromName.OldMagnificationType,"OldMagnificationType");
		nameByTag.put(TagFromName.Erase,"Erase");
		nameByTag.put(TagFromName.Print,"Print");
		nameByTag.put(TagFromName.Overlays,"Overlays");
		nameByTag.put(TagFromName.FileMetaInformationGroupLength,"FileMetaInformationGroupLength");
		nameByTag.put(TagFromName.FileMetaInformationVersion,"FileMetaInformationVersion");
		nameByTag.put(TagFromName.MediaStorageSOPClassUID,"MediaStorageSOPClassUID");
		nameByTag.put(TagFromName.MediaStorageSOPInstanceUID,"MediaStorageSOPInstanceUID");
		nameByTag.put(TagFromName.TransferSyntaxUID,"TransferSyntaxUID");
		nameByTag.put(TagFromName.ImplementationClassUID,"ImplementationClassUID");
		nameByTag.put(TagFromName.ImplementationVersionName,"ImplementationVersionName");
		nameByTag.put(TagFromName.SourceApplicationEntityTitle,"SourceApplicationEntityTitle");
		nameByTag.put(TagFromName.PrivateInformationCreatorUID,"PrivateInformationCreatorUID");
		nameByTag.put(TagFromName.PrivateInformation,"PrivateInformation");
		nameByTag.put(TagFromName.FileSetID,"FileSetID");
		nameByTag.put(TagFromName.FileSetDescriptorFileID,"FileSetDescriptorFileID");
		nameByTag.put(TagFromName.FileSetCharacterSet,"FileSetCharacterSet");
		nameByTag.put(TagFromName.RootDirectoryFirstRecord,"RootDirectoryFirstRecord");
		nameByTag.put(TagFromName.RootDirectoryLastRecord,"RootDirectoryLastRecord");
		nameByTag.put(TagFromName.FileSetConsistencyFlag,"FileSetConsistencyFlag");
		nameByTag.put(TagFromName.DirectoryRecordSequence,"DirectoryRecordSequence");
		nameByTag.put(TagFromName.NextDirectoryRecordOffset,"NextDirectoryRecordOffset");
		nameByTag.put(TagFromName.RecordInUseFlag,"RecordInUseFlag");
		nameByTag.put(TagFromName.LowerLevelDirectoryOffset,"LowerLevelDirectoryOffset");
		nameByTag.put(TagFromName.DirectoryRecordType,"DirectoryRecordType");
		nameByTag.put(TagFromName.PrivateRecordUID,"PrivateRecordUID");
		nameByTag.put(TagFromName.ReferencedFileID,"ReferencedFileID");
		nameByTag.put(TagFromName.MRDRDirectoryRecordOffset,"MRDRDirectoryRecordOffset");
		nameByTag.put(TagFromName.ReferencedSOPClassUIDInFile,"ReferencedSOPClassUIDInFile");
		nameByTag.put(TagFromName.ReferencedSOPInstanceUIDInFile,"ReferencedSOPInstanceUIDInFile");
		nameByTag.put(TagFromName.ReferencedTransferSyntaxUIDInFile,"ReferencedTransferSyntaxUIDInFile");
		nameByTag.put(TagFromName.ReferencedRelatedGeneralSOPClassUIDInFile,"ReferencedRelatedGeneralSOPClassUIDInFile");
		nameByTag.put(TagFromName.NumberOfReferences,"NumberOfReferences");
		nameByTag.put(TagFromName.LengthToEnd,"LengthToEnd");
		nameByTag.put(TagFromName.SpecificCharacterSet,"SpecificCharacterSet");
		nameByTag.put(TagFromName.LanguageCodeSequence,"LanguageCodeSequence");
		nameByTag.put(TagFromName.ImageType,"ImageType");
		nameByTag.put(TagFromName.RecognitionCode,"RecognitionCode");
		nameByTag.put(TagFromName.InstanceCreationDate,"InstanceCreationDate");
		nameByTag.put(TagFromName.InstanceCreationTime,"InstanceCreationTime");
		nameByTag.put(TagFromName.InstanceCreatorUID,"InstanceCreatorUID");
		nameByTag.put(TagFromName.SOPClassUID,"SOPClassUID");
		nameByTag.put(TagFromName.SOPInstanceUID,"SOPInstanceUID");
		nameByTag.put(TagFromName.RelatedGeneralSOPClassUID,"RelatedGeneralSOPClassUID");
		nameByTag.put(TagFromName.OriginalSpecializedSOPClassUID,"OriginalSpecializedSOPClassUID");
		nameByTag.put(TagFromName.StudyDate,"StudyDate");
		nameByTag.put(TagFromName.SeriesDate,"SeriesDate");
		nameByTag.put(TagFromName.AcquisitionDate,"AcquisitionDate");
		nameByTag.put(TagFromName.ContentDate,"ContentDate");
		nameByTag.put(TagFromName.OverlayDate,"OverlayDate");
		nameByTag.put(TagFromName.CurveDate,"CurveDate");
		nameByTag.put(TagFromName.AcquisitionDateTime,"AcquisitionDateTime");
		nameByTag.put(TagFromName.StudyTime,"StudyTime");
		nameByTag.put(TagFromName.SeriesTime,"SeriesTime");
		nameByTag.put(TagFromName.AcquisitionTime,"AcquisitionTime");
		nameByTag.put(TagFromName.ContentTime,"ContentTime");
		nameByTag.put(TagFromName.OverlayTime,"OverlayTime");
		nameByTag.put(TagFromName.CurveTime,"CurveTime");
		nameByTag.put(TagFromName.OldDataSetType,"OldDataSetType");
		nameByTag.put(TagFromName.OldDataSetSubtype,"OldDataSetSubtype");
		nameByTag.put(TagFromName.NuclearMedicineSeriesTypeRetired,"NuclearMedicineSeriesTypeRetired");
		nameByTag.put(TagFromName.AccessionNumber,"AccessionNumber");
		nameByTag.put(TagFromName.IssuerOfAccessionNumberSequence,"IssuerOfAccessionNumberSequence");
		nameByTag.put(TagFromName.QueryRetrieveLevel,"QueryRetrieveLevel");
		nameByTag.put(TagFromName.RetrieveAETitle,"RetrieveAETitle");
		nameByTag.put(TagFromName.InstanceAvailability,"InstanceAvailability");
		nameByTag.put(TagFromName.FailedSOPInstanceUIDList,"FailedSOPInstanceUIDList");
		nameByTag.put(TagFromName.Modality,"Modality");
		nameByTag.put(TagFromName.ModalitiesInStudy,"ModalitiesInStudy");
		nameByTag.put(TagFromName.SOPClassesInStudy,"SOPClassesInStudy");
		nameByTag.put(TagFromName.ConversionType,"ConversionType");
		nameByTag.put(TagFromName.PresentationIntentType,"PresentationIntentType");
		nameByTag.put(TagFromName.Manufacturer,"Manufacturer");
		nameByTag.put(TagFromName.InstitutionName,"InstitutionName");
		nameByTag.put(TagFromName.InstitutionAddress,"InstitutionAddress");
		nameByTag.put(TagFromName.InstitutionCodeSequence,"InstitutionCodeSequence");
		nameByTag.put(TagFromName.ReferringPhysicianName,"ReferringPhysicianName");
		nameByTag.put(TagFromName.ReferringPhysicianAddress,"ReferringPhysicianAddress");
		nameByTag.put(TagFromName.ReferringPhysicianTelephoneNumber,"ReferringPhysicianTelephoneNumber");
		nameByTag.put(TagFromName.ReferringPhysicianIdentificationSequence,"ReferringPhysicianIdentificationSequence");
		nameByTag.put(TagFromName.CodeValue,"CodeValue");
		nameByTag.put(TagFromName.CodingSchemeDesignator,"CodingSchemeDesignator");
		nameByTag.put(TagFromName.CodingSchemeVersion,"CodingSchemeVersion");
		nameByTag.put(TagFromName.CodeMeaning,"CodeMeaning");
		nameByTag.put(TagFromName.MappingResource,"MappingResource");
		nameByTag.put(TagFromName.ContextGroupVersion,"ContextGroupVersion");
		nameByTag.put(TagFromName.ContextGroupLocalVersion,"ContextGroupLocalVersion");
		nameByTag.put(TagFromName.ContextGroupExtensionFlag,"ContextGroupExtensionFlag");
		nameByTag.put(TagFromName.CodingSchemeUID,"CodingSchemeUID");
		nameByTag.put(TagFromName.ContextGroupExtensionCreatorUID,"ContextGroupExtensionCreatorUID");
		nameByTag.put(TagFromName.ContextIdentifier,"ContextIdentifier");
		nameByTag.put(TagFromName.CodingSchemeIdentificationSequence,"CodingSchemeIdentificationSequence");
		nameByTag.put(TagFromName.CodingSchemeRegistry,"CodingSchemeRegistry");
		nameByTag.put(TagFromName.CodingSchemeExternalID,"CodingSchemeExternalID");
		nameByTag.put(TagFromName.CodingSchemeName,"CodingSchemeName");
		nameByTag.put(TagFromName.CodingSchemeResponsibleOrganization,"CodingSchemeResponsibleOrganization");
		nameByTag.put(TagFromName.ContextUID,"ContextUID");
		nameByTag.put(TagFromName.TimezoneOffsetFromUTC,"TimezoneOffsetFromUTC");
		nameByTag.put(TagFromName.NetworkID,"NetworkID");
		nameByTag.put(TagFromName.StationName,"StationName");
		nameByTag.put(TagFromName.StudyDescription,"StudyDescription");
		nameByTag.put(TagFromName.ProcedureCodeSequence,"ProcedureCodeSequence");
		nameByTag.put(TagFromName.SeriesDescription,"SeriesDescription");
		nameByTag.put(TagFromName.InstitutionalDepartmentName,"InstitutionalDepartmentName");
		nameByTag.put(TagFromName.PhysicianOfRecord,"PhysicianOfRecord");
		nameByTag.put(TagFromName.PhysicianOfRecordIdentificationSequence,"PhysicianOfRecordIdentificationSequence");
		nameByTag.put(TagFromName.PerformingPhysicianName,"PerformingPhysicianName");
		nameByTag.put(TagFromName.PerformingPhysicianIdentificationSequence,"PerformingPhysicianIdentificationSequence");
		nameByTag.put(TagFromName.PhysicianReadingStudy,"PhysicianReadingStudy");
		nameByTag.put(TagFromName.PhysicianReadingStudyIdentificationSequence,"PhysicianReadingStudyIdentificationSequence");
		nameByTag.put(TagFromName.OperatorName,"OperatorName");
		nameByTag.put(TagFromName.OperatorIdentificationSequence,"OperatorIdentificationSequence");
		nameByTag.put(TagFromName.AdmittingDiagnosesDescription,"AdmittingDiagnosesDescription");
		nameByTag.put(TagFromName.AdmittingDiagnosesCodeSequence,"AdmittingDiagnosesCodeSequence");
		nameByTag.put(TagFromName.ManufacturerModelName,"ManufacturerModelName");
		nameByTag.put(TagFromName.ReferencedResultsSequence,"ReferencedResultsSequence");
		nameByTag.put(TagFromName.ReferencedStudySequence,"ReferencedStudySequence");
		nameByTag.put(TagFromName.ReferencedPerformedProcedureStepSequence,"ReferencedPerformedProcedureStepSequence");
		nameByTag.put(TagFromName.ReferencedSeriesSequence,"ReferencedSeriesSequence");
		nameByTag.put(TagFromName.ReferencedPatientSequence,"ReferencedPatientSequence");
		nameByTag.put(TagFromName.ReferencedVisitSequence,"ReferencedVisitSequence");
		nameByTag.put(TagFromName.ReferencedOverlaySequence,"ReferencedOverlaySequence");
		nameByTag.put(TagFromName.ReferencedStereometricInstanceSequence,"ReferencedStereometricInstanceSequence");
		nameByTag.put(TagFromName.ReferencedWaveformSequence,"ReferencedWaveformSequence");
		nameByTag.put(TagFromName.ReferencedImageSequence,"ReferencedImageSequence");
		nameByTag.put(TagFromName.ReferencedCurveSequence,"ReferencedCurveSequence");
		nameByTag.put(TagFromName.ReferencedInstanceSequence,"ReferencedInstanceSequence");
		nameByTag.put(TagFromName.ReferencedRealWorldValueMappingInstanceSequence,"ReferencedRealWorldValueMappingInstanceSequence");
		nameByTag.put(TagFromName.ReferencedSOPClassUID,"ReferencedSOPClassUID");
		nameByTag.put(TagFromName.ReferencedSOPInstanceUID,"ReferencedSOPInstanceUID");
		nameByTag.put(TagFromName.SOPClassesSupported,"SOPClassesSupported");
		nameByTag.put(TagFromName.ReferencedFrameNumber,"ReferencedFrameNumber");
		nameByTag.put(TagFromName.TransactionUID,"TransactionUID");
		nameByTag.put(TagFromName.FailureReason,"FailureReason");
		nameByTag.put(TagFromName.FailedSOPSequence,"FailedSOPSequence");
		nameByTag.put(TagFromName.ReferencedSOPSequence,"ReferencedSOPSequence");
		nameByTag.put(TagFromName.StudiesContainingOtherReferencedInstancesSequence,"StudiesContainingOtherReferencedInstancesSequence");
		nameByTag.put(TagFromName.RelatedSeriesSequence,"RelatedSeriesSequence");
		nameByTag.put(TagFromName.OldLossyImageCompression,"OldLossyImageCompression");
		nameByTag.put(TagFromName.DerivationDescription,"DerivationDescription");
		nameByTag.put(TagFromName.SourceImageSequence,"SourceImageSequence");
		nameByTag.put(TagFromName.StageName,"StageName");
		nameByTag.put(TagFromName.StageNumber,"StageNumber");
		nameByTag.put(TagFromName.NumberOfStages,"NumberOfStages");
		nameByTag.put(TagFromName.ViewName,"ViewName");
		nameByTag.put(TagFromName.ViewNumber,"ViewNumber");
		nameByTag.put(TagFromName.NumberOfEventTimers,"NumberOfEventTimers");
		nameByTag.put(TagFromName.NumberOfViewsInStage,"NumberOfViewsInStage");
		nameByTag.put(TagFromName.EventElapsedTime,"EventElapsedTime");
		nameByTag.put(TagFromName.EventTimerName,"EventTimerName");
		nameByTag.put(TagFromName.EventTimerSequence,"EventTimerSequence");
		nameByTag.put(TagFromName.EventTimeOffset,"EventTimeOffset");
		nameByTag.put(TagFromName.EventCodeSequence,"EventCodeSequence");
		nameByTag.put(TagFromName.StartTrim,"StartTrim");
		nameByTag.put(TagFromName.StopTrim,"StopTrim");
		nameByTag.put(TagFromName.RecommendedDisplayFrameRate,"RecommendedDisplayFrameRate");
		nameByTag.put(TagFromName.TransducerPosition,"TransducerPosition");
		nameByTag.put(TagFromName.TransducerOrientation,"TransducerOrientation");
		nameByTag.put(TagFromName.AnatomicStructure,"AnatomicStructure");
		nameByTag.put(TagFromName.AnatomicRegionSequence,"AnatomicRegionSequence");
		nameByTag.put(TagFromName.AnatomicRegionModifierSequence,"AnatomicRegionModifierSequence");
		nameByTag.put(TagFromName.PrimaryAnatomicStructureSequence,"PrimaryAnatomicStructureSequence");
		nameByTag.put(TagFromName.AnatomicStructureSpaceOrRegionSequence,"AnatomicStructureSpaceOrRegionSequence");
		nameByTag.put(TagFromName.PrimaryAnatomicStructureModifierSequence,"PrimaryAnatomicStructureModifierSequence");
		nameByTag.put(TagFromName.TransducerPositionSequence,"TransducerPositionSequence");
		nameByTag.put(TagFromName.TransducerPositionModifierSequence,"TransducerPositionModifierSequence");
		nameByTag.put(TagFromName.TransducerOrientationSequence,"TransducerOrientationSequence");
		nameByTag.put(TagFromName.TransducerOrientationModifierSequence,"TransducerOrientationModifierSequence");
		nameByTag.put(TagFromName.AnatomicStructureSpaceOrRegionCodeSequenceTrial,"AnatomicStructureSpaceOrRegionCodeSequenceTrial");
		nameByTag.put(TagFromName.AnatomicPortalOfEntranceCodeSequenceTrial,"AnatomicPortalOfEntranceCodeSequenceTrial");
		nameByTag.put(TagFromName.AnatomicApproachDirectionCodeSequenceTrial,"AnatomicApproachDirectionCodeSequenceTrial");
		nameByTag.put(TagFromName.AnatomicPerspectiveDescriptionTrial,"AnatomicPerspectiveDescriptionTrial");
		nameByTag.put(TagFromName.AnatomicPerspectiveCodeSequenceTrial,"AnatomicPerspectiveCodeSequenceTrial");
		nameByTag.put(TagFromName.AnatomicLocationOfExaminingInstrumentDescriptionTrial,"AnatomicLocationOfExaminingInstrumentDescriptionTrial");
		nameByTag.put(TagFromName.AnatomicLocationOfExaminingInstrumentCodeSequenceTrial,"AnatomicLocationOfExaminingInstrumentCodeSequenceTrial");
		nameByTag.put(TagFromName.AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial,"AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial");
		nameByTag.put(TagFromName.OnAxisBackgroundAnatomicStructureCodeSequenceTrial,"OnAxisBackgroundAnatomicStructureCodeSequenceTrial");
		nameByTag.put(TagFromName.AlternateRepresentationSequence,"AlternateRepresentationSequence");
		nameByTag.put(TagFromName.IrradiationEventUID,"IrradiationEventUID");
		nameByTag.put(TagFromName.IdentifyingComments,"IdentifyingComments");
		nameByTag.put(TagFromName.FrameType,"FrameType");
		nameByTag.put(TagFromName.ReferencedImageEvidenceSequence,"ReferencedImageEvidenceSequence");
		nameByTag.put(TagFromName.ReferencedRawDataSequence,"ReferencedRawDataSequence");
		nameByTag.put(TagFromName.CreatorVersionUID,"CreatorVersionUID");
		nameByTag.put(TagFromName.DerivationImageSequence,"DerivationImageSequence");
		nameByTag.put(TagFromName.SourceImageEvidenceSequence,"SourceImageEvidenceSequence");
		nameByTag.put(TagFromName.PixelPresentation,"PixelPresentation");
		nameByTag.put(TagFromName.VolumetricProperties,"VolumetricProperties");
		nameByTag.put(TagFromName.VolumeBasedCalculationTechnique,"VolumeBasedCalculationTechnique");
		nameByTag.put(TagFromName.ComplexImageComponent,"ComplexImageComponent");
		nameByTag.put(TagFromName.AcquisitionContrast,"AcquisitionContrast");
		nameByTag.put(TagFromName.DerivationCodeSequence,"DerivationCodeSequence");
		nameByTag.put(TagFromName.ReferencedPresentationStateSequence,"ReferencedPresentationStateSequence");
		nameByTag.put(TagFromName.ReferencedOtherPlaneSequence,"ReferencedOtherPlaneSequence");
		nameByTag.put(TagFromName.FrameDisplaySequence,"FrameDisplaySequence");
		nameByTag.put(TagFromName.RecommendedDisplayFrameRateInFloat,"RecommendedDisplayFrameRateInFloat");
		nameByTag.put(TagFromName.SkipFrameRangeFlag,"SkipFrameRangeFlag");
		nameByTag.put(TagFromName.PatientName,"PatientName");
		nameByTag.put(TagFromName.PatientID,"PatientID");
		nameByTag.put(TagFromName.IssuerOfPatientID,"IssuerOfPatientID");
		nameByTag.put(TagFromName.TypeOfPatientID,"TypeOfPatientID");
		nameByTag.put(TagFromName.IssuerOfPatientIDQualifiersSequence,"IssuerOfPatientIDQualifiersSequence");
		nameByTag.put(TagFromName.PatientBirthDate,"PatientBirthDate");
		nameByTag.put(TagFromName.PatientBirthTime,"PatientBirthTime");
		nameByTag.put(TagFromName.PatientSex,"PatientSex");
		nameByTag.put(TagFromName.PatientInsurancePlanCodeSequence,"PatientInsurancePlanCodeSequence");
		nameByTag.put(TagFromName.PatientPrimaryLanguageCodeSequence,"PatientPrimaryLanguageCodeSequence");
		nameByTag.put(TagFromName.PatientPrimaryLanguageModifierCodeSequence,"PatientPrimaryLanguageModifierCodeSequence");
		nameByTag.put(TagFromName.OtherPatientID,"OtherPatientID");
		nameByTag.put(TagFromName.OtherPatientName,"OtherPatientName");
		nameByTag.put(TagFromName.OtherPatientIDSequence,"OtherPatientIDSequence");
		nameByTag.put(TagFromName.PatientBirthName,"PatientBirthName");
		nameByTag.put(TagFromName.PatientAge,"PatientAge");
		nameByTag.put(TagFromName.PatientSize,"PatientSize");
		nameByTag.put(TagFromName.PatientWeight,"PatientWeight");
		nameByTag.put(TagFromName.PatientAddress,"PatientAddress");
		nameByTag.put(TagFromName.InsurancePlanIdentification,"InsurancePlanIdentification");
		nameByTag.put(TagFromName.PatientMotherBirthName,"PatientMotherBirthName");
		nameByTag.put(TagFromName.MilitaryRank,"MilitaryRank");
		nameByTag.put(TagFromName.BranchOfService,"BranchOfService");
		nameByTag.put(TagFromName.MedicalRecordLocator,"MedicalRecordLocator");
		nameByTag.put(TagFromName.MedicalAlerts,"MedicalAlerts");
		nameByTag.put(TagFromName.Allergies,"Allergies");
		nameByTag.put(TagFromName.CountryOfResidence,"CountryOfResidence");
		nameByTag.put(TagFromName.RegionOfResidence,"RegionOfResidence");
		nameByTag.put(TagFromName.PatientTelephoneNumber,"PatientTelephoneNumber");
		nameByTag.put(TagFromName.EthnicGroup,"EthnicGroup");
		nameByTag.put(TagFromName.Occupation,"Occupation");
		nameByTag.put(TagFromName.SmokingStatus,"SmokingStatus");
		nameByTag.put(TagFromName.AdditionalPatientHistory,"AdditionalPatientHistory");
		nameByTag.put(TagFromName.PregnancyStatus,"PregnancyStatus");
		nameByTag.put(TagFromName.LastMenstrualDate,"LastMenstrualDate");
		nameByTag.put(TagFromName.PatientReligiousPreference,"PatientReligiousPreference");
		nameByTag.put(TagFromName.PatientSpeciesDescription,"PatientSpeciesDescription");
		nameByTag.put(TagFromName.PatientSpeciesCodeSequence,"PatientSpeciesCodeSequence");
		nameByTag.put(TagFromName.PatientSexNeutered,"PatientSexNeutered");
		nameByTag.put(TagFromName.PatientBreedDescription,"PatientBreedDescription");
		nameByTag.put(TagFromName.PatientBreedCodeSequence,"PatientBreedCodeSequence");
		nameByTag.put(TagFromName.BreedRegistrationSequence,"BreedRegistrationSequence");
		nameByTag.put(TagFromName.BreedRegistrationNumber,"BreedRegistrationNumber");
		nameByTag.put(TagFromName.BreedRegistryCodeSequence,"BreedRegistryCodeSequence");
		nameByTag.put(TagFromName.ResponsiblePerson,"ResponsiblePerson");
		nameByTag.put(TagFromName.ResponsiblePersonRole,"ResponsiblePersonRole");
		nameByTag.put(TagFromName.ResponsibleOrganization,"ResponsibleOrganization");
		nameByTag.put(TagFromName.PatientComments,"PatientComments");
		nameByTag.put(TagFromName.ExaminedBodyThickness,"ExaminedBodyThickness");
		nameByTag.put(TagFromName.ClinicalTrialSponsorName,"ClinicalTrialSponsorName");
		nameByTag.put(TagFromName.ClinicalTrialProtocolID,"ClinicalTrialProtocolID");
		nameByTag.put(TagFromName.ClinicalTrialProtocolName,"ClinicalTrialProtocolName");
		nameByTag.put(TagFromName.ClinicalTrialSiteID,"ClinicalTrialSiteID");
		nameByTag.put(TagFromName.ClinicalTrialSiteName,"ClinicalTrialSiteName");
		nameByTag.put(TagFromName.ClinicalTrialSubjectID,"ClinicalTrialSubjectID");
		nameByTag.put(TagFromName.ClinicalTrialSubjectReadingID,"ClinicalTrialSubjectReadingID");
		nameByTag.put(TagFromName.ClinicalTrialTimePointID,"ClinicalTrialTimePointID");
		nameByTag.put(TagFromName.ClinicalTrialTimePointDescription,"ClinicalTrialTimePointDescription");
		nameByTag.put(TagFromName.ClinicalTrialCoordinatingCenterName,"ClinicalTrialCoordinatingCenterName");
		nameByTag.put(TagFromName.PatientIdentityRemoved,"PatientIdentityRemoved");
		nameByTag.put(TagFromName.DeidentificationMethod,"DeidentificationMethod");
		nameByTag.put(TagFromName.DeidentificationMethodCodeSequence,"DeidentificationMethodCodeSequence");
		nameByTag.put(TagFromName.ClinicalTrialSeriesID,"ClinicalTrialSeriesID");
		nameByTag.put(TagFromName.ClinicalTrialSeriesDescription,"ClinicalTrialSeriesDescription");
		nameByTag.put(TagFromName.ClinicalTrialProtocolEthicsCommitteeName,"ClinicalTrialProtocolEthicsCommitteeName");
		nameByTag.put(TagFromName.ClinicalTrialProtocolEthicsCommitteeApprovalNumber,"ClinicalTrialProtocolEthicsCommitteeApprovalNumber");
		nameByTag.put(TagFromName.ConsentForClinicalTrialUseSequence,"ConsentForClinicalTrialUseSequence");
		nameByTag.put(TagFromName.DistributionType,"DistributionType");
		nameByTag.put(TagFromName.ConsentForDistributionFlag,"ConsentForDistributionFlag");
		nameByTag.put(TagFromName.ContrastBolusAgent,"ContrastBolusAgent");
		nameByTag.put(TagFromName.ContrastBolusAgentSequence,"ContrastBolusAgentSequence");
		nameByTag.put(TagFromName.ContrastBolusAdministrationRouteSequence,"ContrastBolusAdministrationRouteSequence");
		nameByTag.put(TagFromName.BodyPartExamined,"BodyPartExamined");
		nameByTag.put(TagFromName.ScanningSequence,"ScanningSequence");
		nameByTag.put(TagFromName.SequenceVariant,"SequenceVariant");
		nameByTag.put(TagFromName.ScanOptions,"ScanOptions");
		nameByTag.put(TagFromName.MRAcquisitionType,"MRAcquisitionType");
		nameByTag.put(TagFromName.SequenceName,"SequenceName");
		nameByTag.put(TagFromName.AngioFlag,"AngioFlag");
		nameByTag.put(TagFromName.InterventionDrugInformationSequence,"InterventionDrugInformationSequence");
		nameByTag.put(TagFromName.InterventionDrugStopTime,"InterventionDrugStopTime");
		nameByTag.put(TagFromName.InterventionDrugDose,"InterventionDrugDose");
		nameByTag.put(TagFromName.InterventionDrugCodeSequence,"InterventionDrugCodeSequence");
		nameByTag.put(TagFromName.AdditionalDrugSequence,"AdditionalDrugSequence");
		nameByTag.put(TagFromName.Radionuclide,"Radionuclide");
		nameByTag.put(TagFromName.Radiopharmaceutical,"Radiopharmaceutical");
		nameByTag.put(TagFromName.EnergyWindowCenterline,"EnergyWindowCenterline");
		nameByTag.put(TagFromName.EnergyWindowTotalWidth,"EnergyWindowTotalWidth");
		nameByTag.put(TagFromName.InterventionDrugName,"InterventionDrugName");
		nameByTag.put(TagFromName.InterventionDrugStartTime,"InterventionDrugStartTime");
		nameByTag.put(TagFromName.InterventionSequence,"InterventionSequence");
		nameByTag.put(TagFromName.TherapyType,"TherapyType");
		nameByTag.put(TagFromName.InterventionStatus,"InterventionStatus");
		nameByTag.put(TagFromName.TherapyDescription,"TherapyDescription");
		nameByTag.put(TagFromName.InterventionDescription,"InterventionDescription");
		nameByTag.put(TagFromName.CineRate,"CineRate");
		nameByTag.put(TagFromName.InitialCineRunState,"InitialCineRunState");
		nameByTag.put(TagFromName.SliceThickness,"SliceThickness");
		nameByTag.put(TagFromName.KVP,"KVP");
		nameByTag.put(TagFromName.CountsAccumulated,"CountsAccumulated");
		nameByTag.put(TagFromName.AcquisitionTerminationCondition,"AcquisitionTerminationCondition");
		nameByTag.put(TagFromName.EffectiveDuration,"EffectiveDuration");
		nameByTag.put(TagFromName.AcquisitionStartCondition,"AcquisitionStartCondition");
		nameByTag.put(TagFromName.AcquisitionStartConditionData,"AcquisitionStartConditionData");
		nameByTag.put(TagFromName.AcquisitionTerminationConditionData,"AcquisitionTerminationConditionData");
		nameByTag.put(TagFromName.RepetitionTime,"RepetitionTime");
		nameByTag.put(TagFromName.EchoTime,"EchoTime");
		nameByTag.put(TagFromName.InversionTime,"InversionTime");
		nameByTag.put(TagFromName.NumberOfAverages,"NumberOfAverages");
		nameByTag.put(TagFromName.ImagingFrequency,"ImagingFrequency");
		nameByTag.put(TagFromName.ImagedNucleus,"ImagedNucleus");
		nameByTag.put(TagFromName.EchoNumber,"EchoNumber");
		nameByTag.put(TagFromName.MagneticFieldStrength,"MagneticFieldStrength");
		nameByTag.put(TagFromName.SpacingBetweenSlices,"SpacingBetweenSlices");
		nameByTag.put(TagFromName.NumberOfPhaseEncodingSteps,"NumberOfPhaseEncodingSteps");
		nameByTag.put(TagFromName.DataCollectionDiameter,"DataCollectionDiameter");
		nameByTag.put(TagFromName.EchoTrainLength,"EchoTrainLength");
		nameByTag.put(TagFromName.PercentSampling,"PercentSampling");
		nameByTag.put(TagFromName.PercentPhaseFieldOfView,"PercentPhaseFieldOfView");
		nameByTag.put(TagFromName.PixelBandwidth,"PixelBandwidth");
		nameByTag.put(TagFromName.DeviceSerialNumber,"DeviceSerialNumber");
		nameByTag.put(TagFromName.DeviceUID,"DeviceUID");
		nameByTag.put(TagFromName.PlateID,"PlateID");
		nameByTag.put(TagFromName.GeneratorID,"GeneratorID");
		nameByTag.put(TagFromName.GridID,"GridID");
		nameByTag.put(TagFromName.CassetteID,"CassetteID");
		nameByTag.put(TagFromName.GantryID,"GantryID");
		nameByTag.put(TagFromName.SecondaryCaptureDeviceID,"SecondaryCaptureDeviceID");
		nameByTag.put(TagFromName.HardcopyCreationDeviceID,"HardcopyCreationDeviceID");
		nameByTag.put(TagFromName.DateOfSecondaryCapture,"DateOfSecondaryCapture");
		nameByTag.put(TagFromName.TimeOfSecondaryCapture,"TimeOfSecondaryCapture");
		nameByTag.put(TagFromName.SecondaryCaptureDeviceManufacturer,"SecondaryCaptureDeviceManufacturer");
		nameByTag.put(TagFromName.HardcopyDeviceManufacturer,"HardcopyDeviceManufacturer");
		nameByTag.put(TagFromName.SecondaryCaptureDeviceManufacturerModelName,"SecondaryCaptureDeviceManufacturerModelName");
		nameByTag.put(TagFromName.SecondaryCaptureDeviceSoftwareVersion,"SecondaryCaptureDeviceSoftwareVersion");
		nameByTag.put(TagFromName.HardcopyDeviceSoftwareVersion,"HardcopyDeviceSoftwareVersion");
		nameByTag.put(TagFromName.HardcopyDeviceManufacturerModelName,"HardcopyDeviceManufacturerModelName");
		nameByTag.put(TagFromName.SoftwareVersion,"SoftwareVersion");
		nameByTag.put(TagFromName.VideoImageFormatAcquired,"VideoImageFormatAcquired");
		nameByTag.put(TagFromName.DigitalImageFormatAcquired,"DigitalImageFormatAcquired");
		nameByTag.put(TagFromName.ProtocolName,"ProtocolName");
		nameByTag.put(TagFromName.ContrastBolusRoute,"ContrastBolusRoute");
		nameByTag.put(TagFromName.ContrastBolusVolume,"ContrastBolusVolume");
		nameByTag.put(TagFromName.ContrastBolusStartTime,"ContrastBolusStartTime");
		nameByTag.put(TagFromName.ContrastBolusStopTime,"ContrastBolusStopTime");
		nameByTag.put(TagFromName.ContrastBolusTotalDose,"ContrastBolusTotalDose");
		nameByTag.put(TagFromName.SyringeCounts,"SyringeCounts");
		nameByTag.put(TagFromName.ContrastFlowRate,"ContrastFlowRate");
		nameByTag.put(TagFromName.ContrastFlowDuration,"ContrastFlowDuration");
		nameByTag.put(TagFromName.ContrastBolusIngredient,"ContrastBolusIngredient");
		nameByTag.put(TagFromName.ContrastBolusIngredientConcentration,"ContrastBolusIngredientConcentration");
		nameByTag.put(TagFromName.SpatialResolution,"SpatialResolution");
		nameByTag.put(TagFromName.TriggerTime,"TriggerTime");
		nameByTag.put(TagFromName.TriggerSourceOrType,"TriggerSourceOrType");
		nameByTag.put(TagFromName.NominalInterval,"NominalInterval");
		nameByTag.put(TagFromName.FrameTime,"FrameTime");
		nameByTag.put(TagFromName.CardiacFramingType,"CardiacFramingType");
		nameByTag.put(TagFromName.FrameTimeVector,"FrameTimeVector");
		nameByTag.put(TagFromName.FrameDelay,"FrameDelay");
		nameByTag.put(TagFromName.ImageTriggerDelay,"ImageTriggerDelay");
		nameByTag.put(TagFromName.MultiplexGroupTimeOffset,"MultiplexGroupTimeOffset");
		nameByTag.put(TagFromName.TriggerTimeOffset,"TriggerTimeOffset");
		nameByTag.put(TagFromName.SynchronizationTrigger,"SynchronizationTrigger");
		nameByTag.put(TagFromName.SynchronizationChannel,"SynchronizationChannel");
		nameByTag.put(TagFromName.TriggerSamplePosition,"TriggerSamplePosition");
		nameByTag.put(TagFromName.RadiopharmaceuticalRoute,"RadiopharmaceuticalRoute");
		nameByTag.put(TagFromName.RadiopharmaceuticalVolume,"RadiopharmaceuticalVolume");
		nameByTag.put(TagFromName.RadiopharmaceuticalStartTime,"RadiopharmaceuticalStartTime");
		nameByTag.put(TagFromName.RadiopharmaceuticalStopTime,"RadiopharmaceuticalStopTime");
		nameByTag.put(TagFromName.RadionuclideTotalDose,"RadionuclideTotalDose");
		nameByTag.put(TagFromName.RadionuclideHalfLife,"RadionuclideHalfLife");
		nameByTag.put(TagFromName.RadionuclidePositronFraction,"RadionuclidePositronFraction");
		nameByTag.put(TagFromName.RadiopharmaceuticalSpecificActivity,"RadiopharmaceuticalSpecificActivity");
		nameByTag.put(TagFromName.RadiopharmaceuticalStartDateTime,"RadiopharmaceuticalStartDateTime");
		nameByTag.put(TagFromName.RadiopharmaceuticalStopDateTime,"RadiopharmaceuticalStopDateTime");
		nameByTag.put(TagFromName.BeatRejectionFlag,"BeatRejectionFlag");
		nameByTag.put(TagFromName.LowRRValue,"LowRRValue");
		nameByTag.put(TagFromName.HighRRValue,"HighRRValue");
		nameByTag.put(TagFromName.IntervalsAcquired,"IntervalsAcquired");
		nameByTag.put(TagFromName.IntervalsRejected,"IntervalsRejected");
		nameByTag.put(TagFromName.PVCRejection,"PVCRejection");
		nameByTag.put(TagFromName.SkipBeats,"SkipBeats");
		nameByTag.put(TagFromName.HeartRate,"HeartRate");
		nameByTag.put(TagFromName.CardiacNumberOfImages,"CardiacNumberOfImages");
		nameByTag.put(TagFromName.TriggerWindow,"TriggerWindow");
		nameByTag.put(TagFromName.ReconstructionDiameter,"ReconstructionDiameter");
		nameByTag.put(TagFromName.DistanceSourceToDetector,"DistanceSourceToDetector");
		nameByTag.put(TagFromName.DistanceSourceToPatient,"DistanceSourceToPatient");
		nameByTag.put(TagFromName.EstimatedRadiographicMagnificationFactor,"EstimatedRadiographicMagnificationFactor");
		nameByTag.put(TagFromName.GantryDetectorTilt,"GantryDetectorTilt");
		nameByTag.put(TagFromName.GantryDetectorSlew,"GantryDetectorSlew");
		nameByTag.put(TagFromName.TableHeight,"TableHeight");
		nameByTag.put(TagFromName.TableTraverse,"TableTraverse");
		nameByTag.put(TagFromName.TableMotion,"TableMotion");
		nameByTag.put(TagFromName.TableVerticalIncrement,"TableVerticalIncrement");
		nameByTag.put(TagFromName.TableLateralIncrement,"TableLateralIncrement");
		nameByTag.put(TagFromName.TableLongitudinalIncrement,"TableLongitudinalIncrement");
		nameByTag.put(TagFromName.TableAngle,"TableAngle");
		nameByTag.put(TagFromName.TableType,"TableType");
		nameByTag.put(TagFromName.RotationDirection,"RotationDirection");
		nameByTag.put(TagFromName.AngularPosition,"AngularPosition");
		nameByTag.put(TagFromName.RadialPosition,"RadialPosition");
		nameByTag.put(TagFromName.ScanArc,"ScanArc");
		nameByTag.put(TagFromName.AngularStep,"AngularStep");
		nameByTag.put(TagFromName.CenterOfRotationOffset,"CenterOfRotationOffset");
		nameByTag.put(TagFromName.RotationOffset,"RotationOffset");
		nameByTag.put(TagFromName.FieldOfViewShape,"FieldOfViewShape");
		nameByTag.put(TagFromName.FieldOfViewDimensions,"FieldOfViewDimensions");
		nameByTag.put(TagFromName.ExposureTime,"ExposureTime");
		nameByTag.put(TagFromName.XRayTubeCurrent,"XRayTubeCurrent");
		nameByTag.put(TagFromName.Exposure,"Exposure");
		nameByTag.put(TagFromName.ExposureInuAs,"ExposureInuAs");
		nameByTag.put(TagFromName.AveragePulseWidth,"AveragePulseWidth");
		nameByTag.put(TagFromName.RadiationSetting,"RadiationSetting");
		nameByTag.put(TagFromName.RectificationType,"RectificationType");
		nameByTag.put(TagFromName.RadiationMode,"RadiationMode");
		nameByTag.put(TagFromName.ImageAndFluoroscopyAreaDoseProduct,"ImageAndFluoroscopyAreaDoseProduct");
		nameByTag.put(TagFromName.FilterType,"FilterType");
		nameByTag.put(TagFromName.TypeOfFilters,"TypeOfFilters");
		nameByTag.put(TagFromName.IntensifierSize,"IntensifierSize");
		nameByTag.put(TagFromName.ImagerPixelSpacing,"ImagerPixelSpacing");
		nameByTag.put(TagFromName.Grid,"Grid");
		nameByTag.put(TagFromName.GeneratorPower,"GeneratorPower");
		nameByTag.put(TagFromName.CollimatorGridName,"CollimatorGridName");
		nameByTag.put(TagFromName.CollimatorType,"CollimatorType");
		nameByTag.put(TagFromName.FocalDistance,"FocalDistance");
		nameByTag.put(TagFromName.XFocusCenter,"XFocusCenter");
		nameByTag.put(TagFromName.YFocusCenter,"YFocusCenter");
		nameByTag.put(TagFromName.FocalSpot,"FocalSpot");
		nameByTag.put(TagFromName.AnodeTargetMaterial,"AnodeTargetMaterial");
		nameByTag.put(TagFromName.BodyPartThickness,"BodyPartThickness");
		nameByTag.put(TagFromName.CompressionForce,"CompressionForce");
		nameByTag.put(TagFromName.DateOfLastCalibration,"DateOfLastCalibration");
		nameByTag.put(TagFromName.TimeOfLastCalibration,"TimeOfLastCalibration");
		nameByTag.put(TagFromName.ConvolutionKernel,"ConvolutionKernel");
		nameByTag.put(TagFromName.UpperLowerPixelValues,"UpperLowerPixelValues");
		nameByTag.put(TagFromName.ActualFrameDuration,"ActualFrameDuration");
		nameByTag.put(TagFromName.CountRate,"CountRate");
		nameByTag.put(TagFromName.PreferredPlaybackSequencing,"PreferredPlaybackSequencing");
		nameByTag.put(TagFromName.ReceiveCoilName,"ReceiveCoilName");
		nameByTag.put(TagFromName.TransmitCoilName,"TransmitCoilName");
		nameByTag.put(TagFromName.PlateType,"PlateType");
		nameByTag.put(TagFromName.PhosphorType,"PhosphorType");
		nameByTag.put(TagFromName.ScanVelocity,"ScanVelocity");
		nameByTag.put(TagFromName.WholeBodyTechnique,"WholeBodyTechnique");
		nameByTag.put(TagFromName.ScanLength,"ScanLength");
		nameByTag.put(TagFromName.AcquisitionMatrix,"AcquisitionMatrix");
		nameByTag.put(TagFromName.InPlanePhaseEncodingDirection,"InPlanePhaseEncodingDirection");
		nameByTag.put(TagFromName.FlipAngle,"FlipAngle");
		nameByTag.put(TagFromName.VariableFlipAngleFlag,"VariableFlipAngleFlag");
		nameByTag.put(TagFromName.SAR,"SAR");
		nameByTag.put(TagFromName.dBdt,"dBdt");
		nameByTag.put(TagFromName.AcquisitionDeviceProcessingDescription,"AcquisitionDeviceProcessingDescription");
		nameByTag.put(TagFromName.AcquisitionDeviceProcessingCode,"AcquisitionDeviceProcessingCode");
		nameByTag.put(TagFromName.CassetteOrientation,"CassetteOrientation");
		nameByTag.put(TagFromName.CassetteSize,"CassetteSize");
		nameByTag.put(TagFromName.ExposuresOnPlate,"ExposuresOnPlate");
		nameByTag.put(TagFromName.RelativeXRayExposure,"RelativeXRayExposure");
		nameByTag.put(TagFromName.ColumnAngulation,"ColumnAngulation");
		nameByTag.put(TagFromName.TomoLayerHeight,"TomoLayerHeight");
		nameByTag.put(TagFromName.TomoAngle,"TomoAngle");
		nameByTag.put(TagFromName.TomoTime,"TomoTime");
		nameByTag.put(TagFromName.TomoType,"TomoType");
		nameByTag.put(TagFromName.TomoClass,"TomoClass");
		nameByTag.put(TagFromName.NumberOfTomosynthesisSourceImages,"NumberOfTomosynthesisSourceImages");
		nameByTag.put(TagFromName.PositionerMotion,"PositionerMotion");
		nameByTag.put(TagFromName.PositionerType,"PositionerType");
		nameByTag.put(TagFromName.PositionerPrimaryAngle,"PositionerPrimaryAngle");
		nameByTag.put(TagFromName.PositionerSecondaryAngle,"PositionerSecondaryAngle");
		nameByTag.put(TagFromName.PositionerPrimaryAngleIncrement,"PositionerPrimaryAngleIncrement");
		nameByTag.put(TagFromName.PositionerSecondaryAngleIncrement,"PositionerSecondaryAngleIncrement");
		nameByTag.put(TagFromName.DetectorPrimaryAngle,"DetectorPrimaryAngle");
		nameByTag.put(TagFromName.DetectorSecondaryAngle,"DetectorSecondaryAngle");
		nameByTag.put(TagFromName.ShutterShape,"ShutterShape");
		nameByTag.put(TagFromName.ShutterLeftVerticalEdge,"ShutterLeftVerticalEdge");
		nameByTag.put(TagFromName.ShutterRightVerticalEdge,"ShutterRightVerticalEdge");
		nameByTag.put(TagFromName.ShutterUpperHorizontalEdge,"ShutterUpperHorizontalEdge");
		nameByTag.put(TagFromName.ShutterLowerHorizontalEdge,"ShutterLowerHorizontalEdge");
		nameByTag.put(TagFromName.CenterOfCircularShutter,"CenterOfCircularShutter");
		nameByTag.put(TagFromName.RadiusOfCircularShutter,"RadiusOfCircularShutter");
		nameByTag.put(TagFromName.VerticesOfPolygonalShutter,"VerticesOfPolygonalShutter");
		nameByTag.put(TagFromName.ShutterPresentationValue,"ShutterPresentationValue");
		nameByTag.put(TagFromName.ShutterOverlayGroup,"ShutterOverlayGroup");
		nameByTag.put(TagFromName.ShutterPresentationColorCIELabValue,"ShutterPresentationColorCIELabValue");
		nameByTag.put(TagFromName.CollimatorShape,"CollimatorShape");
		nameByTag.put(TagFromName.CollimatorLeftVerticalEdge,"CollimatorLeftVerticalEdge");
		nameByTag.put(TagFromName.CollimatorRightVerticalEdge,"CollimatorRightVerticalEdge");
		nameByTag.put(TagFromName.CollimatorUpperHorizontalEdge,"CollimatorUpperHorizontalEdge");
		nameByTag.put(TagFromName.CollimatorLowerHorizontalEdge,"CollimatorLowerHorizontalEdge");
		nameByTag.put(TagFromName.CenterOfCircularCollimator,"CenterOfCircularCollimator");
		nameByTag.put(TagFromName.RadiusOfCircularCollimator,"RadiusOfCircularCollimator");
		nameByTag.put(TagFromName.VerticesOfPolygonalCollimator,"VerticesOfPolygonalCollimator");
		nameByTag.put(TagFromName.AcquisitionTimeSynchronized,"AcquisitionTimeSynchronized");
		nameByTag.put(TagFromName.TimeSource,"TimeSource");
		nameByTag.put(TagFromName.TimeDistributionProtocol,"TimeDistributionProtocol");
		nameByTag.put(TagFromName.NTPSourceAddress,"NTPSourceAddress");
		nameByTag.put(TagFromName.PageNumberVector,"PageNumberVector");
		nameByTag.put(TagFromName.FrameLabelVector,"FrameLabelVector");
		nameByTag.put(TagFromName.FramePrimaryAngleVector,"FramePrimaryAngleVector");
		nameByTag.put(TagFromName.FrameSecondaryAngleVector,"FrameSecondaryAngleVector");
		nameByTag.put(TagFromName.SliceLocationVector,"SliceLocationVector");
		nameByTag.put(TagFromName.DisplayWindowLabelVector,"DisplayWindowLabelVector");
		nameByTag.put(TagFromName.NominalScannedPixelSpacing,"NominalScannedPixelSpacing");
		nameByTag.put(TagFromName.DigitizingDeviceTransportDirection,"DigitizingDeviceTransportDirection");
		nameByTag.put(TagFromName.RotationOfScannedFilm,"RotationOfScannedFilm");
		nameByTag.put(TagFromName.IVUSAcquisition,"IVUSAcquisition");
		nameByTag.put(TagFromName.IVUSPullbackRate,"IVUSPullbackRate");
		nameByTag.put(TagFromName.IVUSGatedRate,"IVUSGatedRate");
		nameByTag.put(TagFromName.IVUSPullbackStartFrameNumber,"IVUSPullbackStartFrameNumber");
		nameByTag.put(TagFromName.IVUSPullbackStopFrameNumber,"IVUSPullbackStopFrameNumber");
		nameByTag.put(TagFromName.LesionNumber,"LesionNumber");
		nameByTag.put(TagFromName.AcquisitionComments,"AcquisitionComments");
		nameByTag.put(TagFromName.OutputPower,"OutputPower");
		nameByTag.put(TagFromName.TransducerData,"TransducerData");
		nameByTag.put(TagFromName.FocusDepth,"FocusDepth");
		nameByTag.put(TagFromName.ProcessingFunction,"ProcessingFunction");
		nameByTag.put(TagFromName.PostprocessingFunction,"PostprocessingFunction");
		nameByTag.put(TagFromName.MechanicalIndex,"MechanicalIndex");
		nameByTag.put(TagFromName.BoneThermalIndex,"BoneThermalIndex");
		nameByTag.put(TagFromName.CranialThermalIndex,"CranialThermalIndex");
		nameByTag.put(TagFromName.SoftTissueThermalIndex,"SoftTissueThermalIndex");
		nameByTag.put(TagFromName.SoftTissueFocusThermalIndex,"SoftTissueFocusThermalIndex");
		nameByTag.put(TagFromName.SoftTissueSurfaceThermalIndex,"SoftTissueSurfaceThermalIndex");
		nameByTag.put(TagFromName.DynamicRange,"DynamicRange");
		nameByTag.put(TagFromName.TotalGain,"TotalGain");
		nameByTag.put(TagFromName.DepthOfScanField,"DepthOfScanField");
		nameByTag.put(TagFromName.PatientPosition,"PatientPosition");
		nameByTag.put(TagFromName.ViewPosition,"ViewPosition");
		nameByTag.put(TagFromName.ProjectionEponymousNameCodeSequence,"ProjectionEponymousNameCodeSequence");
		nameByTag.put(TagFromName.ImageTransformationMatrix,"ImageTransformationMatrix");
		nameByTag.put(TagFromName.ImageTranslationVector,"ImageTranslationVector");
		nameByTag.put(TagFromName.Sensitivity,"Sensitivity");
		nameByTag.put(TagFromName.SequenceOfUltrasoundRegions,"SequenceOfUltrasoundRegions");
		nameByTag.put(TagFromName.RegionSpatialFormat,"RegionSpatialFormat");
		nameByTag.put(TagFromName.RegionDataType,"RegionDataType");
		nameByTag.put(TagFromName.RegionFlags,"RegionFlags");
		nameByTag.put(TagFromName.RegionLocationMinX0,"RegionLocationMinX0");
		nameByTag.put(TagFromName.RegionLocationMinY0,"RegionLocationMinY0");
		nameByTag.put(TagFromName.RegionLocationMaxX1,"RegionLocationMaxX1");
		nameByTag.put(TagFromName.RegionLocationMaxY1,"RegionLocationMaxY1");
		nameByTag.put(TagFromName.ReferencePixelX0,"ReferencePixelX0");
		nameByTag.put(TagFromName.ReferencePixelY0,"ReferencePixelY0");
		nameByTag.put(TagFromName.PhysicalUnitsXDirection,"PhysicalUnitsXDirection");
		nameByTag.put(TagFromName.PhysicalUnitsYDirection,"PhysicalUnitsYDirection");
		nameByTag.put(TagFromName.ReferencePixelPhysicalValueX,"ReferencePixelPhysicalValueX");
		nameByTag.put(TagFromName.ReferencePixelPhysicalValueY,"ReferencePixelPhysicalValueY");
		nameByTag.put(TagFromName.PhysicalDeltaX,"PhysicalDeltaX");
		nameByTag.put(TagFromName.PhysicalDeltaY,"PhysicalDeltaY");
		nameByTag.put(TagFromName.TransducerFrequency,"TransducerFrequency");
		nameByTag.put(TagFromName.TransducerType,"TransducerType");
		nameByTag.put(TagFromName.PulseRepetitionFrequency,"PulseRepetitionFrequency");
		nameByTag.put(TagFromName.DopplerCorrectionAngle,"DopplerCorrectionAngle");
		nameByTag.put(TagFromName.SteeringAngle,"SteeringAngle");
		nameByTag.put(TagFromName.DopplerSampleVolumeXPositionRetired,"DopplerSampleVolumeXPositionRetired");
		nameByTag.put(TagFromName.DopplerSampleVolumeXPosition,"DopplerSampleVolumeXPosition");
		nameByTag.put(TagFromName.DopplerSampleVolumeYPositionRetired,"DopplerSampleVolumeYPositionRetired");
		nameByTag.put(TagFromName.DopplerSampleVolumeYPosition,"DopplerSampleVolumeYPosition");
		nameByTag.put(TagFromName.TMLinePositionX0Retired,"TMLinePositionX0Retired");
		nameByTag.put(TagFromName.TMLinePositionX0,"TMLinePositionX0");
		nameByTag.put(TagFromName.TMLinePositionY0Retired,"TMLinePositionY0Retired");
		nameByTag.put(TagFromName.TMLinePositionY0,"TMLinePositionY0");
		nameByTag.put(TagFromName.TMLinePositionX1Retired,"TMLinePositionX1Retired");
		nameByTag.put(TagFromName.TMLinePositionX1,"TMLinePositionX1");
		nameByTag.put(TagFromName.TMLinePositionY1Retired,"TMLinePositionY1Retired");
		nameByTag.put(TagFromName.TMLinePositionY1,"TMLinePositionY1");
		nameByTag.put(TagFromName.PixelComponentOrganization,"PixelComponentOrganization");
		nameByTag.put(TagFromName.PixelComponentMask,"PixelComponentMask");
		nameByTag.put(TagFromName.PixelComponentRangeStart,"PixelComponentRangeStart");
		nameByTag.put(TagFromName.PixelComponentRangeStop,"PixelComponentRangeStop");
		nameByTag.put(TagFromName.PixelComponentPhysicalUnits,"PixelComponentPhysicalUnits");
		nameByTag.put(TagFromName.PixelComponentDataType,"PixelComponentDataType");
		nameByTag.put(TagFromName.NumberOfTableBreakPoints,"NumberOfTableBreakPoints");
		nameByTag.put(TagFromName.TableOfXBreakPoints,"TableOfXBreakPoints");
		nameByTag.put(TagFromName.TableOfYBreakPoints,"TableOfYBreakPoints");
		nameByTag.put(TagFromName.NumberOfTableEntries,"NumberOfTableEntries");
		nameByTag.put(TagFromName.TableOfPixelValues,"TableOfPixelValues");
		nameByTag.put(TagFromName.TableOfParameterValues,"TableOfParameterValues");
		nameByTag.put(TagFromName.RWaveTimeVector,"RWaveTimeVector");
		nameByTag.put(TagFromName.DetectorConditionsNominalFlag,"DetectorConditionsNominalFlag");
		nameByTag.put(TagFromName.DetectorTemperature,"DetectorTemperature");
		nameByTag.put(TagFromName.DetectorType,"DetectorType");
		nameByTag.put(TagFromName.DetectorConfiguration,"DetectorConfiguration");
		nameByTag.put(TagFromName.DetectorDescription,"DetectorDescription");
		nameByTag.put(TagFromName.DetectorMode,"DetectorMode");
		nameByTag.put(TagFromName.DetectorID,"DetectorID");
		nameByTag.put(TagFromName.DateOfLastDetectorCalibration,"DateOfLastDetectorCalibration");
		nameByTag.put(TagFromName.TimeOfLastDetectorCalibration,"TimeOfLastDetectorCalibration");
		nameByTag.put(TagFromName.ExposuresOnDetectorSinceLastCalibration,"ExposuresOnDetectorSinceLastCalibration");
		nameByTag.put(TagFromName.ExposuresOnDetectorSinceManufactured,"ExposuresOnDetectorSinceManufactured");
		nameByTag.put(TagFromName.DetectorTimeSinceLastExposure,"DetectorTimeSinceLastExposure");
		nameByTag.put(TagFromName.DetectorActiveTime,"DetectorActiveTime");
		nameByTag.put(TagFromName.DetectorActivationOffsetFromExposure,"DetectorActivationOffsetFromExposure");
		nameByTag.put(TagFromName.DetectorBinning,"DetectorBinning");
		nameByTag.put(TagFromName.DetectorElementPhysicalSize,"DetectorElementPhysicalSize");
		nameByTag.put(TagFromName.DetectorElementSpacing,"DetectorElementSpacing");
		nameByTag.put(TagFromName.DetectorActiveShape,"DetectorActiveShape");
		nameByTag.put(TagFromName.DetectorActiveDimensions,"DetectorActiveDimensions");
		nameByTag.put(TagFromName.DetectorActiveOrigin,"DetectorActiveOrigin");
		nameByTag.put(TagFromName.DetectorManufacturerName,"DetectorManufacturerName");
		nameByTag.put(TagFromName.DetectorManufacturerModelName,"DetectorManufacturerModelName");
		nameByTag.put(TagFromName.FieldOfViewOrigin,"FieldOfViewOrigin");
		nameByTag.put(TagFromName.FieldOfViewRotation,"FieldOfViewRotation");
		nameByTag.put(TagFromName.FieldOfViewHorizontalFlip,"FieldOfViewHorizontalFlip");
		nameByTag.put(TagFromName.GridAbsorbingMaterial,"GridAbsorbingMaterial");
		nameByTag.put(TagFromName.GridSpacingMaterial,"GridSpacingMaterial");
		nameByTag.put(TagFromName.GridThickness,"GridThickness");
		nameByTag.put(TagFromName.GridPitch,"GridPitch");
		nameByTag.put(TagFromName.GridAspectRatio,"GridAspectRatio");
		nameByTag.put(TagFromName.GridPeriod,"GridPeriod");
		nameByTag.put(TagFromName.GridFocalDistance,"GridFocalDistance");
		nameByTag.put(TagFromName.FilterMaterial,"FilterMaterial");
		nameByTag.put(TagFromName.FilterThicknessMinimum,"FilterThicknessMinimum");
		nameByTag.put(TagFromName.FilterThicknessMaximum,"FilterThicknessMaximum");
		nameByTag.put(TagFromName.ExposureControlMode,"ExposureControlMode");
		nameByTag.put(TagFromName.ExposureControlModeDescription,"ExposureControlModeDescription");
		nameByTag.put(TagFromName.ExposureStatus,"ExposureStatus");
		nameByTag.put(TagFromName.PhototimerSetting,"PhototimerSetting");
		nameByTag.put(TagFromName.ExposureTimeInuS,"ExposureTimeInuS");
		nameByTag.put(TagFromName.XRayTubeCurrentInuA,"XRayTubeCurrentInuA");
		nameByTag.put(TagFromName.ContentQualification,"ContentQualification");
		nameByTag.put(TagFromName.PulseSequenceName,"PulseSequenceName");
		nameByTag.put(TagFromName.MRImagingModifierSequence,"MRImagingModifierSequence");
		nameByTag.put(TagFromName.EchoPulseSequence,"EchoPulseSequence");
		nameByTag.put(TagFromName.InversionRecovery,"InversionRecovery");
		nameByTag.put(TagFromName.FlowCompensation,"FlowCompensation");
		nameByTag.put(TagFromName.MultipleSpinEcho,"MultipleSpinEcho");
		nameByTag.put(TagFromName.MultiplanarExcitation,"MultiplanarExcitation");
		nameByTag.put(TagFromName.PhaseContrast,"PhaseContrast");
		nameByTag.put(TagFromName.TimeOfFlightContrast,"TimeOfFlightContrast");
		nameByTag.put(TagFromName.Spoiling,"Spoiling");
		nameByTag.put(TagFromName.SteadyStatePulseSequence,"SteadyStatePulseSequence");
		nameByTag.put(TagFromName.EchoPlanarPulseSequence,"EchoPlanarPulseSequence");
		nameByTag.put(TagFromName.TagAngleFirstAxis,"TagAngleFirstAxis");
		nameByTag.put(TagFromName.MagnetizationTransfer,"MagnetizationTransfer");
		nameByTag.put(TagFromName.T2Preparation,"T2Preparation");
		nameByTag.put(TagFromName.BloodSignalNulling,"BloodSignalNulling");
		nameByTag.put(TagFromName.SaturationRecovery,"SaturationRecovery");
		nameByTag.put(TagFromName.SpectrallySelectedSuppression,"SpectrallySelectedSuppression");
		nameByTag.put(TagFromName.SpectrallySelectedExcitation,"SpectrallySelectedExcitation");
		nameByTag.put(TagFromName.SpatialPresaturation,"SpatialPresaturation");
		nameByTag.put(TagFromName.Tagging,"Tagging");
		nameByTag.put(TagFromName.OversamplingPhase,"OversamplingPhase");
		nameByTag.put(TagFromName.TagSpacingFirstDimension,"TagSpacingFirstDimension");
		nameByTag.put(TagFromName.GeometryOfKSpaceTraversal,"GeometryOfKSpaceTraversal");
		nameByTag.put(TagFromName.SegmentedKSpaceTraversal,"SegmentedKSpaceTraversal");
		nameByTag.put(TagFromName.RectilinearPhaseEncodeReordering,"RectilinearPhaseEncodeReordering");
		nameByTag.put(TagFromName.TagThickness,"TagThickness");
		nameByTag.put(TagFromName.PartialFourierDirection,"PartialFourierDirection");
		nameByTag.put(TagFromName.CardiacSynchronizationTechnique,"CardiacSynchronizationTechnique");
		nameByTag.put(TagFromName.ReceiveCoilManufacturerName,"ReceiveCoilManufacturerName");
		nameByTag.put(TagFromName.MRReceiveCoilSequence,"MRReceiveCoilSequence");
		nameByTag.put(TagFromName.ReceiveCoilType,"ReceiveCoilType");
		nameByTag.put(TagFromName.QuadratureReceiveCoil,"QuadratureReceiveCoil");
		nameByTag.put(TagFromName.MultiCoilDefinitionSequence,"MultiCoilDefinitionSequence");
		nameByTag.put(TagFromName.MultiCoilConfiguration,"MultiCoilConfiguration");
		nameByTag.put(TagFromName.MultiCoilElementName,"MultiCoilElementName");
		nameByTag.put(TagFromName.MultiCoilElementUsed,"MultiCoilElementUsed");
		nameByTag.put(TagFromName.MRTransmitCoilSequence,"MRTransmitCoilSequence");
		nameByTag.put(TagFromName.TransmitCoilManufacturerName,"TransmitCoilManufacturerName");
		nameByTag.put(TagFromName.TransmitCoilType,"TransmitCoilType");
		nameByTag.put(TagFromName.SpectralWidth,"SpectralWidth");
		nameByTag.put(TagFromName.ChemicalShiftReference,"ChemicalShiftReference");
		nameByTag.put(TagFromName.VolumeLocalizationTechnique,"VolumeLocalizationTechnique");
		nameByTag.put(TagFromName.MRAcquisitionFrequencyEncodingSteps,"MRAcquisitionFrequencyEncodingSteps");
		nameByTag.put(TagFromName.Decoupling,"Decoupling");
		nameByTag.put(TagFromName.DecoupledNucleus,"DecoupledNucleus");
		nameByTag.put(TagFromName.DecouplingFrequency,"DecouplingFrequency");
		nameByTag.put(TagFromName.DecouplingMethod,"DecouplingMethod");
		nameByTag.put(TagFromName.DecouplingChemicalShiftReference,"DecouplingChemicalShiftReference");
		nameByTag.put(TagFromName.KSpaceFiltering,"KSpaceFiltering");
		nameByTag.put(TagFromName.TimeDomainFiltering,"TimeDomainFiltering");
		nameByTag.put(TagFromName.NumberOfZeroFills,"NumberOfZeroFills");
		nameByTag.put(TagFromName.BaselineCorrection,"BaselineCorrection");
		nameByTag.put(TagFromName.ParallelReductionFactorInPlane,"ParallelReductionFactorInPlane");
		nameByTag.put(TagFromName.CardiacRRIntervalSpecified,"CardiacRRIntervalSpecified");
		nameByTag.put(TagFromName.AcquisitionDuration,"AcquisitionDuration");
		nameByTag.put(TagFromName.FrameAcquisitionDateTime,"FrameAcquisitionDateTime");
		nameByTag.put(TagFromName.DiffusionDirectionality,"DiffusionDirectionality");
		nameByTag.put(TagFromName.DiffusionGradientDirectionSequence,"DiffusionGradientDirectionSequence");
		nameByTag.put(TagFromName.ParallelAcquisition,"ParallelAcquisition");
		nameByTag.put(TagFromName.ParallelAcquisitionTechnique,"ParallelAcquisitionTechnique");
		nameByTag.put(TagFromName.InversionTimes,"InversionTimes");
		nameByTag.put(TagFromName.MetaboliteMapDescription,"MetaboliteMapDescription");
		nameByTag.put(TagFromName.PartialFourier,"PartialFourier");
		nameByTag.put(TagFromName.EffectiveEchoTime,"EffectiveEchoTime");
		nameByTag.put(TagFromName.MetaboliteCodeSequence,"MetaboliteCodeSequence");
		nameByTag.put(TagFromName.ChemicalShiftSequence,"ChemicalShiftSequence");
		nameByTag.put(TagFromName.CardiacSignalSource,"CardiacSignalSource");
		nameByTag.put(TagFromName.DiffusionBValue,"DiffusionBValue");
		nameByTag.put(TagFromName.DiffusionGradientOrientation,"DiffusionGradientOrientation");
		nameByTag.put(TagFromName.VelocityEncodingDirection,"VelocityEncodingDirection");
		nameByTag.put(TagFromName.VelocityEncodingMinimumValue,"VelocityEncodingMinimumValue");
		nameByTag.put(TagFromName.NumberOfKSpaceTrajectories,"NumberOfKSpaceTrajectories");
		nameByTag.put(TagFromName.CoverageOfKSpace,"CoverageOfKSpace");
		nameByTag.put(TagFromName.SpectroscopyAcquisitionPhaseRows,"SpectroscopyAcquisitionPhaseRows");
		nameByTag.put(TagFromName.ParallelReductionFactorInPlaneRetired,"ParallelReductionFactorInPlaneRetired");
		nameByTag.put(TagFromName.TransmitterFrequency,"TransmitterFrequency");
		nameByTag.put(TagFromName.ResonantNucleus,"ResonantNucleus");
		nameByTag.put(TagFromName.FrequencyCorrection,"FrequencyCorrection");
		nameByTag.put(TagFromName.MRSpectroscopyFOVGeometrySequence,"MRSpectroscopyFOVGeometrySequence");
		nameByTag.put(TagFromName.SlabThickness,"SlabThickness");
		nameByTag.put(TagFromName.SlabOrientation,"SlabOrientation");
		nameByTag.put(TagFromName.MidSlabPosition,"MidSlabPosition");
		nameByTag.put(TagFromName.MRSpatialSaturationSequence,"MRSpatialSaturationSequence");
		nameByTag.put(TagFromName.MRTimingAndRelatedParametersSequence,"MRTimingAndRelatedParametersSequence");
		nameByTag.put(TagFromName.MREchoSequence,"MREchoSequence");
		nameByTag.put(TagFromName.MRModifierSequence,"MRModifierSequence");
		nameByTag.put(TagFromName.MRDiffusionSequence,"MRDiffusionSequence");
		nameByTag.put(TagFromName.CardiacSynchronizationSequence,"CardiacSynchronizationSequence");
		nameByTag.put(TagFromName.MRAveragesSequence,"MRAveragesSequence");
		nameByTag.put(TagFromName.MRFOVGeometrySequence,"MRFOVGeometrySequence");
		nameByTag.put(TagFromName.VolumeLocalizationSequence,"VolumeLocalizationSequence");
		nameByTag.put(TagFromName.SpectroscopyAcquisitionDataColumns,"SpectroscopyAcquisitionDataColumns");
		nameByTag.put(TagFromName.DiffusionAnisotropyType,"DiffusionAnisotropyType");
		nameByTag.put(TagFromName.FrameReferenceDateTime,"FrameReferenceDateTime");
		nameByTag.put(TagFromName.MRMetaboliteMapSequence,"MRMetaboliteMapSequence");
		nameByTag.put(TagFromName.ParallelReductionFactorOutOfPlane,"ParallelReductionFactorOutOfPlane");
		nameByTag.put(TagFromName.SpectroscopyAcquisitionOutOfPlanePhaseSteps,"SpectroscopyAcquisitionOutOfPlanePhaseSteps");
		nameByTag.put(TagFromName.BulkMotionStatus,"BulkMotionStatus");
		nameByTag.put(TagFromName.ParallelReductionFactorSecondInPlane,"ParallelReductionFactorSecondInPlane");
		nameByTag.put(TagFromName.CardiacBeatRejectionTechnique,"CardiacBeatRejectionTechnique");
		nameByTag.put(TagFromName.RespiratoryMotionCompensationTechnique,"RespiratoryMotionCompensationTechnique");
		nameByTag.put(TagFromName.RespiratorySignalSource,"RespiratorySignalSource");
		nameByTag.put(TagFromName.BulkMotionCompensationTechnique,"BulkMotionCompensationTechnique");
		nameByTag.put(TagFromName.BulkMotionSignalSource,"BulkMotionSignalSource");
		nameByTag.put(TagFromName.ApplicableSafetyStandardAgency,"ApplicableSafetyStandardAgency");
		nameByTag.put(TagFromName.ApplicableSafetyStandardDescription,"ApplicableSafetyStandardDescription");
		nameByTag.put(TagFromName.OperatingModeSequence,"OperatingModeSequence");
		nameByTag.put(TagFromName.OperatingModeType,"OperatingModeType");
		nameByTag.put(TagFromName.OperatingMode,"OperatingMode");
		nameByTag.put(TagFromName.SpecificAbsorptionRateDefinition,"SpecificAbsorptionRateDefinition");
		nameByTag.put(TagFromName.GradientOutputType,"GradientOutputType");
		nameByTag.put(TagFromName.SpecificAbsorptionRateValue,"SpecificAbsorptionRateValue");
		nameByTag.put(TagFromName.GradientOutput,"GradientOutput");
		nameByTag.put(TagFromName.FlowCompensationDirection,"FlowCompensationDirection");
		nameByTag.put(TagFromName.TaggingDelay,"TaggingDelay");
		nameByTag.put(TagFromName.RespiratoryMotionCompensationTechniqueDescription,"RespiratoryMotionCompensationTechniqueDescription");
		nameByTag.put(TagFromName.RespiratorySignalSourceID,"RespiratorySignalSourceID");
		nameByTag.put(TagFromName.ChemicalShiftMinimumIntegrationLimitInHz,"ChemicalShiftMinimumIntegrationLimitInHz");
		nameByTag.put(TagFromName.ChemicalShiftMaximumIntegrationLimitInHz,"ChemicalShiftMaximumIntegrationLimitInHz");
		nameByTag.put(TagFromName.MRVelocityEncodingSequence,"MRVelocityEncodingSequence");
		nameByTag.put(TagFromName.FirstOrderPhaseCorrection,"FirstOrderPhaseCorrection");
		nameByTag.put(TagFromName.WaterReferencedPhaseCorrection,"WaterReferencedPhaseCorrection");
		nameByTag.put(TagFromName.MRSpectroscopyAcquisitionType,"MRSpectroscopyAcquisitionType");
		nameByTag.put(TagFromName.RespiratoryCyclePosition,"RespiratoryCyclePosition");
		nameByTag.put(TagFromName.VelocityEncodingMaximumValue,"VelocityEncodingMaximumValue");
		nameByTag.put(TagFromName.TagSpacingSecondDimension,"TagSpacingSecondDimension");
		nameByTag.put(TagFromName.TagAngleSecondAxis,"TagAngleSecondAxis");
		nameByTag.put(TagFromName.FrameAcquisitionDuration,"FrameAcquisitionDuration");
		nameByTag.put(TagFromName.MRImageFrameTypeSequence,"MRImageFrameTypeSequence");
		nameByTag.put(TagFromName.MRSpectroscopyFrameTypeSequence,"MRSpectroscopyFrameTypeSequence");
		nameByTag.put(TagFromName.MRAcquisitionPhaseEncodingStepsInPlane,"MRAcquisitionPhaseEncodingStepsInPlane");
		nameByTag.put(TagFromName.MRAcquisitionPhaseEncodingStepsOutOfPlane,"MRAcquisitionPhaseEncodingStepsOutOfPlane");
		nameByTag.put(TagFromName.SpectroscopyAcquisitionPhaseColumns,"SpectroscopyAcquisitionPhaseColumns");
		nameByTag.put(TagFromName.CardiacCyclePosition,"CardiacCyclePosition");
		nameByTag.put(TagFromName.SpecificAbsorptionRateSequence,"SpecificAbsorptionRateSequence");
		nameByTag.put(TagFromName.RFEchoTrainLength,"RFEchoTrainLength");
		nameByTag.put(TagFromName.GradientEchoTrainLength,"GradientEchoTrainLength");
		nameByTag.put(TagFromName.ChemicalShiftMinimumIntegrationLimitInPPM,"ChemicalShiftMinimumIntegrationLimitInPPM");
		nameByTag.put(TagFromName.ChemicalShiftMaximumIntegrationLimitInPPM,"ChemicalShiftMaximumIntegrationLimitInPPM");
		nameByTag.put(TagFromName.CTAcquisitionTypeSequence,"CTAcquisitionTypeSequence");
		nameByTag.put(TagFromName.AcquisitionType,"AcquisitionType");
		nameByTag.put(TagFromName.TubeAngle,"TubeAngle");
		nameByTag.put(TagFromName.CTAcquisitionDetailsSequence,"CTAcquisitionDetailsSequence");
		nameByTag.put(TagFromName.RevolutionTime,"RevolutionTime");
		nameByTag.put(TagFromName.SingleCollimationWidth,"SingleCollimationWidth");
		nameByTag.put(TagFromName.TotalCollimationWidth,"TotalCollimationWidth");
		nameByTag.put(TagFromName.CTTableDynamicsSequence,"CTTableDynamicsSequence");
		nameByTag.put(TagFromName.TableSpeed,"TableSpeed");
		nameByTag.put(TagFromName.TableFeedPerRotation,"TableFeedPerRotation");
		nameByTag.put(TagFromName.SpiralPitchFactor,"SpiralPitchFactor");
		nameByTag.put(TagFromName.CTGeometrySequence,"CTGeometrySequence");
		nameByTag.put(TagFromName.DataCollectionCenterPatient,"DataCollectionCenterPatient");
		nameByTag.put(TagFromName.CTReconstructionSequence,"CTReconstructionSequence");
		nameByTag.put(TagFromName.ReconstructionAlgorithm,"ReconstructionAlgorithm");
		nameByTag.put(TagFromName.ConvolutionKernelGroup,"ConvolutionKernelGroup");
		nameByTag.put(TagFromName.ReconstructionFieldOfView,"ReconstructionFieldOfView");
		nameByTag.put(TagFromName.ReconstructionTargetCenterPatient,"ReconstructionTargetCenterPatient");
		nameByTag.put(TagFromName.ReconstructionAngle,"ReconstructionAngle");
		nameByTag.put(TagFromName.ImageFilter,"ImageFilter");
		nameByTag.put(TagFromName.CTExposureSequence,"CTExposureSequence");
		nameByTag.put(TagFromName.ReconstructionPixelSpacing,"ReconstructionPixelSpacing");
		nameByTag.put(TagFromName.ExposureModulationType,"ExposureModulationType");
		nameByTag.put(TagFromName.EstimatedDoseSaving,"EstimatedDoseSaving");
		nameByTag.put(TagFromName.CTXRayDetailsSequence,"CTXRayDetailsSequence");
		nameByTag.put(TagFromName.CTPositionSequence,"CTPositionSequence");
		nameByTag.put(TagFromName.TablePosition,"TablePosition");
		nameByTag.put(TagFromName.ExposureTimeInms,"ExposureTimeInms");
		nameByTag.put(TagFromName.CTImageFrameTypeSequence,"CTImageFrameTypeSequence");
		nameByTag.put(TagFromName.XRayTubeCurrentInmA,"XRayTubeCurrentInmA");
		nameByTag.put(TagFromName.ExposureInmAs,"ExposureInmAs");
		nameByTag.put(TagFromName.ConstantVolumeFlag,"ConstantVolumeFlag");
		nameByTag.put(TagFromName.FluoroscopyFlag,"FluoroscopyFlag");
		nameByTag.put(TagFromName.DistanceSourceToDataCollectionCenter,"DistanceSourceToDataCollectionCenter");
		nameByTag.put(TagFromName.ContrastBolusAgentNumber,"ContrastBolusAgentNumber");
		nameByTag.put(TagFromName.ContrastBolusIngredientCodeSequence,"ContrastBolusIngredientCodeSequence");
		nameByTag.put(TagFromName.ContrastAdministrationProfileSequence,"ContrastAdministrationProfileSequence");
		nameByTag.put(TagFromName.ContrastBolusUsageSequence,"ContrastBolusUsageSequence");
		nameByTag.put(TagFromName.ContrastBolusAgentAdministered,"ContrastBolusAgentAdministered");
		nameByTag.put(TagFromName.ContrastBolusAgentDetected,"ContrastBolusAgentDetected");
		nameByTag.put(TagFromName.ContrastBolusAgentPhase,"ContrastBolusAgentPhase");
		nameByTag.put(TagFromName.CTDIvol,"CTDIvol");
		nameByTag.put(TagFromName.CTDIPhantomTypeCodeSequence,"CTDIPhantomTypeCodeSequence");
		nameByTag.put(TagFromName.CalciumScoringMassFactorPatient,"CalciumScoringMassFactorPatient");
		nameByTag.put(TagFromName.CalciumScoringMassFactorDevice,"CalciumScoringMassFactorDevice");
		nameByTag.put(TagFromName.EnergyWeightingFactor,"EnergyWeightingFactor");
		nameByTag.put(TagFromName.CTAdditionalXRaySourceSequence,"CTAdditionalXRaySourceSequence");
		nameByTag.put(TagFromName.ProjectionPixelCalibrationSequence,"ProjectionPixelCalibrationSequence");
		nameByTag.put(TagFromName.DistanceSourceToIsocenter,"DistanceSourceToIsocenter");
		nameByTag.put(TagFromName.DistanceObjectToTableTop,"DistanceObjectToTableTop");
		nameByTag.put(TagFromName.ObjectPixelSpacingInCenterOfBeam,"ObjectPixelSpacingInCenterOfBeam");
		nameByTag.put(TagFromName.PositionerPositionSequence,"PositionerPositionSequence");
		nameByTag.put(TagFromName.TablePositionSequence,"TablePositionSequence");
		nameByTag.put(TagFromName.CollimatorShapeSequence,"CollimatorShapeSequence");
		nameByTag.put(TagFromName.XAXRFFrameCharacteristicsSequence,"XAXRFFrameCharacteristicsSequence");
		nameByTag.put(TagFromName.FrameAcquisitionSequence,"FrameAcquisitionSequence");
		nameByTag.put(TagFromName.XRayReceptorType,"XRayReceptorType");
		nameByTag.put(TagFromName.AcquisitionProtocolName,"AcquisitionProtocolName");
		nameByTag.put(TagFromName.AcquisitionProtocolDescription,"AcquisitionProtocolDescription");
		nameByTag.put(TagFromName.ContrastBolusIngredientOpaque,"ContrastBolusIngredientOpaque");
		nameByTag.put(TagFromName.DistanceReceptorPlaneToDetectorHousing,"DistanceReceptorPlaneToDetectorHousing");
		nameByTag.put(TagFromName.IntensifierActiveShape,"IntensifierActiveShape");
		nameByTag.put(TagFromName.IntensifierActiveDimensions,"IntensifierActiveDimensions");
		nameByTag.put(TagFromName.PhysicalDetectorSize,"PhysicalDetectorSize");
		nameByTag.put(TagFromName.PositionOfIsocenterProjection,"PositionOfIsocenterProjection");
		nameByTag.put(TagFromName.FieldOfViewSequence,"FieldOfViewSequence");
		nameByTag.put(TagFromName.FieldOfViewDescription,"FieldOfViewDescription");
		nameByTag.put(TagFromName.ExposureControlSensingRegionsSequence,"ExposureControlSensingRegionsSequence");
		nameByTag.put(TagFromName.ExposureControlSensingRegionShape,"ExposureControlSensingRegionShape");
		nameByTag.put(TagFromName.ExposureControlSensingRegionLeftVerticalEdge,"ExposureControlSensingRegionLeftVerticalEdge");
		nameByTag.put(TagFromName.ExposureControlSensingRegionRightVerticalEdge,"ExposureControlSensingRegionRightVerticalEdge");
		nameByTag.put(TagFromName.ExposureControlSensingRegionUpperHorizontalEdge,"ExposureControlSensingRegionUpperHorizontalEdge");
		nameByTag.put(TagFromName.ExposureControlSensingRegionLowerHorizontalEdge,"ExposureControlSensingRegionLowerHorizontalEdge");
		nameByTag.put(TagFromName.CenterOfCircularExposureControlSensingRegion,"CenterOfCircularExposureControlSensingRegion");
		nameByTag.put(TagFromName.RadiusOfCircularExposureControlSensingRegion,"RadiusOfCircularExposureControlSensingRegion");
		nameByTag.put(TagFromName.VerticesOfPolygonalExposureControlSensingRegion,"VerticesOfPolygonalExposureControlSensingRegion");
		nameByTag.put(TagFromName.ColumnAngulationPatient,"ColumnAngulationPatient");
		nameByTag.put(TagFromName.BeamAngle,"BeamAngle");
		nameByTag.put(TagFromName.FrameDetectorParametersSequence,"FrameDetectorParametersSequence");
		nameByTag.put(TagFromName.CalculatedAnatomyThickness,"CalculatedAnatomyThickness");
		nameByTag.put(TagFromName.CalibrationSequence,"CalibrationSequence");
		nameByTag.put(TagFromName.ObjectThicknessSequence,"ObjectThicknessSequence");
		nameByTag.put(TagFromName.PlaneIdentification,"PlaneIdentification");
		nameByTag.put(TagFromName.FieldOfViewDimensionsInFloat,"FieldOfViewDimensionsInFloat");
		nameByTag.put(TagFromName.IsocenterReferenceSystemSequence,"IsocenterReferenceSystemSequence");
		nameByTag.put(TagFromName.PositionerIsocenterPrimaryAngle,"PositionerIsocenterPrimaryAngle");
		nameByTag.put(TagFromName.PositionerIsocenterSecondaryAngle,"PositionerIsocenterSecondaryAngle");
		nameByTag.put(TagFromName.PositionerIsocenterDetectorRotationAngle,"PositionerIsocenterDetectorRotationAngle");
		nameByTag.put(TagFromName.TableXPositionToIsocenter,"TableXPositionToIsocenter");
		nameByTag.put(TagFromName.TableYPositionToIsocenter,"TableYPositionToIsocenter");
		nameByTag.put(TagFromName.TableZPositionToIsocenter,"TableZPositionToIsocenter");
		nameByTag.put(TagFromName.TableHorizontalRotationAngle,"TableHorizontalRotationAngle");
		nameByTag.put(TagFromName.TableHeadTiltAngle,"TableHeadTiltAngle");
		nameByTag.put(TagFromName.TableCradleTiltAngle,"TableCradleTiltAngle");
		nameByTag.put(TagFromName.FrameDisplayShutterSequence,"FrameDisplayShutterSequence");
		nameByTag.put(TagFromName.AcquiredImageAreaDoseProduct,"AcquiredImageAreaDoseProduct");
		nameByTag.put(TagFromName.CArmPositionerTabletopRelationship,"CArmPositionerTabletopRelationship");
		nameByTag.put(TagFromName.XRayGeometrySequence,"XRayGeometrySequence");
		nameByTag.put(TagFromName.IrradiationEventIdentificationSequence,"IrradiationEventIdentificationSequence");
		nameByTag.put(TagFromName.XRay3DFrameTypeSequence,"XRay3DFrameTypeSequence");
		nameByTag.put(TagFromName.ContributingSourcesSequence,"ContributingSourcesSequence");
		nameByTag.put(TagFromName.XRay3DAcquisitionSequence,"XRay3DAcquisitionSequence");
		nameByTag.put(TagFromName.PrimaryPositionerScanArc,"PrimaryPositionerScanArc");
		nameByTag.put(TagFromName.SecondaryPositionerScanArc,"SecondaryPositionerScanArc");
		nameByTag.put(TagFromName.PrimaryPositionerScanStartAngle,"PrimaryPositionerScanStartAngle");
		nameByTag.put(TagFromName.SecondaryPositionerScanStartAngle,"SecondaryPositionerScanStartAngle");
		nameByTag.put(TagFromName.PrimaryPositionerIncrement,"PrimaryPositionerIncrement");
		nameByTag.put(TagFromName.SecondaryPositionerIncrement,"SecondaryPositionerIncrement");
		nameByTag.put(TagFromName.StartAcquisitionDateTime,"StartAcquisitionDateTime");
		nameByTag.put(TagFromName.EndAcquisitionDateTime,"EndAcquisitionDateTime");
		nameByTag.put(TagFromName.ApplicationName,"ApplicationName");
		nameByTag.put(TagFromName.ApplicationVersion,"ApplicationVersion");
		nameByTag.put(TagFromName.ApplicationManufacturer,"ApplicationManufacturer");
		nameByTag.put(TagFromName.AlgorithmType,"AlgorithmType");
		nameByTag.put(TagFromName.AlgorithmDescription,"AlgorithmDescription");
		nameByTag.put(TagFromName.XRay3DReconstructionSequence,"XRay3DReconstructionSequence");
		nameByTag.put(TagFromName.ReconstructionDescription,"ReconstructionDescription");
		nameByTag.put(TagFromName.PerProjectionAcquisitionSequence,"PerProjectionAcquisitionSequence");
		nameByTag.put(TagFromName.DiffusionBMatrixSequence,"DiffusionBMatrixSequence");
		nameByTag.put(TagFromName.DiffusionBMatrixValueXX,"DiffusionBMatrixValueXX");
		nameByTag.put(TagFromName.DiffusionBMatrixValueXY,"DiffusionBMatrixValueXY");
		nameByTag.put(TagFromName.DiffusionBMatrixValueXZ,"DiffusionBMatrixValueXZ");
		nameByTag.put(TagFromName.DiffusionBMatrixValueYY,"DiffusionBMatrixValueYY");
		nameByTag.put(TagFromName.DiffusionBMatrixValueYZ,"DiffusionBMatrixValueYZ");
		nameByTag.put(TagFromName.DiffusionBMatrixValueZZ,"DiffusionBMatrixValueZZ");
		nameByTag.put(TagFromName.DecayCorrectionDateTime,"DecayCorrectionDateTime");
		nameByTag.put(TagFromName.StartDensityThreshold,"StartDensityThreshold");
		nameByTag.put(TagFromName.StartRelativeDensityDifferenceThreshold,"StartRelativeDensityDifferenceThreshold");
		nameByTag.put(TagFromName.StartCardiacTriggerCountThreshold,"StartCardiacTriggerCountThreshold");
		nameByTag.put(TagFromName.StartRespiratoryTriggerCountThreshold,"StartRespiratoryTriggerCountThreshold");
		nameByTag.put(TagFromName.TerminationCountsThreshold,"TerminationCountsThreshold");
		nameByTag.put(TagFromName.TerminationDensityThreshold,"TerminationDensityThreshold");
		nameByTag.put(TagFromName.TerminationRelativeDensityThreshold,"TerminationRelativeDensityThreshold");
		nameByTag.put(TagFromName.TerminationTimeThreshold,"TerminationTimeThreshold");
		nameByTag.put(TagFromName.TerminationCardiacTriggerCountThreshold,"TerminationCardiacTriggerCountThreshold");
		nameByTag.put(TagFromName.TerminationRespiratoryTriggerCountThreshold,"TerminationRespiratoryTriggerCountThreshold");
		nameByTag.put(TagFromName.DetectorGeometry,"DetectorGeometry");
		nameByTag.put(TagFromName.TransverseDetectorSeparation,"TransverseDetectorSeparation");
		nameByTag.put(TagFromName.AxialDetectorDimension,"AxialDetectorDimension");
		nameByTag.put(TagFromName.RadiopharmaceuticalAgentNumber,"RadiopharmaceuticalAgentNumber");
		nameByTag.put(TagFromName.PETFrameAcquisitionSequence,"PETFrameAcquisitionSequence");
		nameByTag.put(TagFromName.PETDetectorMotionDetailsSequence,"PETDetectorMotionDetailsSequence");
		nameByTag.put(TagFromName.PETTableDynamicsSequence,"PETTableDynamicsSequence");
		nameByTag.put(TagFromName.PETPositionSequence,"PETPositionSequence");
		nameByTag.put(TagFromName.PETFrameCorrectionFactorsSequence,"PETFrameCorrectionFactorsSequence");
		nameByTag.put(TagFromName.RadiopharmaceuticalUsageSequence,"RadiopharmaceuticalUsageSequence");
		nameByTag.put(TagFromName.AttenuationCorrectionSource,"AttenuationCorrectionSource");
		nameByTag.put(TagFromName.NumberOfIterations,"NumberOfIterations");
		nameByTag.put(TagFromName.NumberOfSubsets,"NumberOfSubsets");
		nameByTag.put(TagFromName.PETReconstructionSequence,"PETReconstructionSequence");
		nameByTag.put(TagFromName.PETFrameTypeSequence,"PETFrameTypeSequence");
		nameByTag.put(TagFromName.TimeOfFlightInformationUsed,"TimeOfFlightInformationUsed");
		nameByTag.put(TagFromName.ReconstructionType,"ReconstructionType");
		nameByTag.put(TagFromName.DecayCorrected,"DecayCorrected");
		nameByTag.put(TagFromName.AttenuationCorrected,"AttenuationCorrected");
		nameByTag.put(TagFromName.ScatterCorrected,"ScatterCorrected");
		nameByTag.put(TagFromName.DeadTimeCorrected,"DeadTimeCorrected");
		nameByTag.put(TagFromName.GantryMotionCorrected,"GantryMotionCorrected");
		nameByTag.put(TagFromName.PatientMotionCorrected,"PatientMotionCorrected");
		nameByTag.put(TagFromName.CountLossNormalizationCorrected,"CountLossNormalizationCorrected");
		nameByTag.put(TagFromName.RandomsCorrected,"RandomsCorrected");
		nameByTag.put(TagFromName.NonUniformRadialSamplingCorrected,"NonUniformRadialSamplingCorrected");
		nameByTag.put(TagFromName.SensitivityCalibrated,"SensitivityCalibrated");
		nameByTag.put(TagFromName.DetectorNormalizationCorrection,"DetectorNormalizationCorrection");
		nameByTag.put(TagFromName.IterativeReconstructionMethod,"IterativeReconstructionMethod");
		nameByTag.put(TagFromName.AttenuationCorrectionTemporalRelationship,"AttenuationCorrectionTemporalRelationship");
		nameByTag.put(TagFromName.PatientPhysiologicalStateSequence,"PatientPhysiologicalStateSequence");
		nameByTag.put(TagFromName.PatientPhysiologicalStateCodeSequence,"PatientPhysiologicalStateCodeSequence");
		nameByTag.put(TagFromName.DepthsOfFocus,"DepthsOfFocus");
		nameByTag.put(TagFromName.ExcludedIntervalsSequence,"ExcludedIntervalsSequence");
		nameByTag.put(TagFromName.ExclusionStartDatetime,"ExclusionStartDatetime");
		nameByTag.put(TagFromName.ExclusionDuration,"ExclusionDuration");
		nameByTag.put(TagFromName.USImageDescriptionSequence,"USImageDescriptionSequence");
		nameByTag.put(TagFromName.ImageDataTypeSequence,"ImageDataTypeSequence");
		nameByTag.put(TagFromName.DataType,"DataType");
		nameByTag.put(TagFromName.TransducerScanPatternCodeSequence,"TransducerScanPatternCodeSequence");
		nameByTag.put(TagFromName.AliasedDataType,"AliasedDataType");
		nameByTag.put(TagFromName.PositionMeasuringDeviceUsed,"PositionMeasuringDeviceUsed");
		nameByTag.put(TagFromName.TransducerGeometryCodeSequence,"TransducerGeometryCodeSequence");
		nameByTag.put(TagFromName.TransducerBeamSteeringCodeSequence,"TransducerBeamSteeringCodeSequence");
		nameByTag.put(TagFromName.TransducerApplicationCodeSequence,"TransducerApplicationCodeSequence");
		nameByTag.put(TagFromName.ContributingEquipmentSequence,"ContributingEquipmentSequence");
		nameByTag.put(TagFromName.ContributionDateTime,"ContributionDateTime");
		nameByTag.put(TagFromName.ContributionDescription,"ContributionDescription");
		nameByTag.put(TagFromName.StudyInstanceUID,"StudyInstanceUID");
		nameByTag.put(TagFromName.SeriesInstanceUID,"SeriesInstanceUID");
		nameByTag.put(TagFromName.StudyID,"StudyID");
		nameByTag.put(TagFromName.SeriesNumber,"SeriesNumber");
		nameByTag.put(TagFromName.AcquisitionNumber,"AcquisitionNumber");
		nameByTag.put(TagFromName.InstanceNumber,"InstanceNumber");
		nameByTag.put(TagFromName.IsotopeNumber,"IsotopeNumber");
		nameByTag.put(TagFromName.PhaseNumber,"PhaseNumber");
		nameByTag.put(TagFromName.IntervalNumber,"IntervalNumber");
		nameByTag.put(TagFromName.TimeSlotNumber,"TimeSlotNumber");
		nameByTag.put(TagFromName.AngleNumber,"AngleNumber");
		nameByTag.put(TagFromName.ItemNumber,"ItemNumber");
		nameByTag.put(TagFromName.PatientOrientation,"PatientOrientation");
		nameByTag.put(TagFromName.OverlayNumber,"OverlayNumber");
		nameByTag.put(TagFromName.CurveNumber,"CurveNumber");
		nameByTag.put(TagFromName.LUTNumber,"LUTNumber");
		nameByTag.put(TagFromName.ImagePosition,"ImagePosition");
		nameByTag.put(TagFromName.ImagePositionPatient,"ImagePositionPatient");
		nameByTag.put(TagFromName.ImageOrientation,"ImageOrientation");
		nameByTag.put(TagFromName.ImageOrientationPatient,"ImageOrientationPatient");
		nameByTag.put(TagFromName.Location,"Location");
		nameByTag.put(TagFromName.FrameOfReferenceUID,"FrameOfReferenceUID");
		nameByTag.put(TagFromName.Laterality,"Laterality");
		nameByTag.put(TagFromName.ImageLaterality,"ImageLaterality");
		nameByTag.put(TagFromName.ImageGeometryType,"ImageGeometryType");
		nameByTag.put(TagFromName.MaskingImage,"MaskingImage");
		nameByTag.put(TagFromName.ReportNumberTrial,"ReportNumberTrial");
		nameByTag.put(TagFromName.TemporalPositionIdentifier,"TemporalPositionIdentifier");
		nameByTag.put(TagFromName.NumberOfTemporalPositions,"NumberOfTemporalPositions");
		nameByTag.put(TagFromName.TemporalResolution,"TemporalResolution");
		nameByTag.put(TagFromName.SynchronizationFrameOfReferenceUID,"SynchronizationFrameOfReferenceUID");
		nameByTag.put(TagFromName.SeriesInStudy,"SeriesInStudy");
		nameByTag.put(TagFromName.AcquisitionsInSeries,"AcquisitionsInSeries");
		nameByTag.put(TagFromName.ImagesInAcquisition,"ImagesInAcquisition");
		nameByTag.put(TagFromName.ImagesInSeries,"ImagesInSeries");
		nameByTag.put(TagFromName.AcquisitionsInStudy,"AcquisitionsInStudy");
		nameByTag.put(TagFromName.ImagesInStudy,"ImagesInStudy");
		nameByTag.put(TagFromName.Reference,"Reference");
		nameByTag.put(TagFromName.PositionReferenceIndicator,"PositionReferenceIndicator");
		nameByTag.put(TagFromName.SliceLocation,"SliceLocation");
		nameByTag.put(TagFromName.OtherStudyNumbers,"OtherStudyNumbers");
		nameByTag.put(TagFromName.NumberOfPatientRelatedStudies,"NumberOfPatientRelatedStudies");
		nameByTag.put(TagFromName.NumberOfPatientRelatedSeries,"NumberOfPatientRelatedSeries");
		nameByTag.put(TagFromName.NumberOfPatientRelatedInstances,"NumberOfPatientRelatedInstances");
		nameByTag.put(TagFromName.NumberOfStudyRelatedSeries,"NumberOfStudyRelatedSeries");
		nameByTag.put(TagFromName.NumberOfStudyRelatedInstances,"NumberOfStudyRelatedInstances");
		nameByTag.put(TagFromName.NumberOfSeriesRelatedInstances,"NumberOfSeriesRelatedInstances");
		nameByTag.put(TagFromName.SourceImageID,"SourceImageID");
		nameByTag.put(TagFromName.ModifyingDeviceID,"ModifyingDeviceID");
		nameByTag.put(TagFromName.ModifiedImageID,"ModifiedImageID");
		nameByTag.put(TagFromName.ModifiedImageDate,"ModifiedImageDate");
		nameByTag.put(TagFromName.ModifyingDeviceManufacturer,"ModifyingDeviceManufacturer");
		nameByTag.put(TagFromName.ModifiedImageTime,"ModifiedImageTime");
		nameByTag.put(TagFromName.ModifiedImageDescription,"ModifiedImageDescription");
		nameByTag.put(TagFromName.ImageComments,"ImageComments");
		nameByTag.put(TagFromName.OriginalImageIdentification,"OriginalImageIdentification");
		nameByTag.put(TagFromName.OriginalImageIdentificationNomenclature,"OriginalImageIdentificationNomenclature");
		nameByTag.put(TagFromName.StackID,"StackID");
		nameByTag.put(TagFromName.InStackPositionNumber,"InStackPositionNumber");
		nameByTag.put(TagFromName.FrameAnatomySequence,"FrameAnatomySequence");
		nameByTag.put(TagFromName.FrameLaterality,"FrameLaterality");
		nameByTag.put(TagFromName.FrameContentSequence,"FrameContentSequence");
		nameByTag.put(TagFromName.PlanePositionSequence,"PlanePositionSequence");
		nameByTag.put(TagFromName.PlaneOrientationSequence,"PlaneOrientationSequence");
		nameByTag.put(TagFromName.TemporalPositionIndex,"TemporalPositionIndex");
		nameByTag.put(TagFromName.NominalCardiacTriggerDelayTime,"NominalCardiacTriggerDelayTime");
		nameByTag.put(TagFromName.FrameAcquisitionNumber,"FrameAcquisitionNumber");
		nameByTag.put(TagFromName.DimensionIndexValues,"DimensionIndexValues");
		nameByTag.put(TagFromName.FrameComments,"FrameComments");
		nameByTag.put(TagFromName.ConcatenationUID,"ConcatenationUID");
		nameByTag.put(TagFromName.InConcatenationNumber,"InConcatenationNumber");
		nameByTag.put(TagFromName.InConcatenationTotalNumber,"InConcatenationTotalNumber");
		nameByTag.put(TagFromName.DimensionOrganizationUID,"DimensionOrganizationUID");
		nameByTag.put(TagFromName.DimensionIndexPointer,"DimensionIndexPointer");
		nameByTag.put(TagFromName.FunctionalGroupPointer,"FunctionalGroupPointer");
		nameByTag.put(TagFromName.DimensionIndexPrivateCreator,"DimensionIndexPrivateCreator");
		nameByTag.put(TagFromName.DimensionOrganizationSequence,"DimensionOrganizationSequence");
		nameByTag.put(TagFromName.DimensionIndexSequence,"DimensionIndexSequence");
		nameByTag.put(TagFromName.ConcatenationFrameOffsetNumber,"ConcatenationFrameOffsetNumber");
		nameByTag.put(TagFromName.FunctionalGroupPrivateCreator,"FunctionalGroupPrivateCreator");
		nameByTag.put(TagFromName.NominalPercentageOfCardiacPhase,"NominalPercentageOfCardiacPhase");
		nameByTag.put(TagFromName.NominalPercentageOfRespiratoryPhase,"NominalPercentageOfRespiratoryPhase");
		nameByTag.put(TagFromName.StartingRespiratoryAmplitude,"StartingRespiratoryAmplitude");
		nameByTag.put(TagFromName.StartingRespiratoryPhase,"StartingRespiratoryPhase");
		nameByTag.put(TagFromName.EndingRespiratoryAmplitude,"EndingRespiratoryAmplitude");
		nameByTag.put(TagFromName.EndingRespiratoryPhase,"EndingRespiratoryPhase");
		nameByTag.put(TagFromName.RespiratoryTriggerType,"RespiratoryTriggerType");
		nameByTag.put(TagFromName.RRIntervalTimeNominal,"RRIntervalTimeNominal");
		nameByTag.put(TagFromName.ActualCardiacTriggerDelayTime,"ActualCardiacTriggerDelayTime");
		nameByTag.put(TagFromName.RespiratorySynchronizationSequence,"RespiratorySynchronizationSequence");
		nameByTag.put(TagFromName.RespiratoryIntervalTime,"RespiratoryIntervalTime");
		nameByTag.put(TagFromName.NominalRespiratoryTriggerDelayTime,"NominalRespiratoryTriggerDelayTime");
		nameByTag.put(TagFromName.RespiratoryTriggerDelayThreshold,"RespiratoryTriggerDelayThreshold");
		nameByTag.put(TagFromName.ActualRespiratoryTriggerDelayTime,"ActualRespiratoryTriggerDelayTime");
		nameByTag.put(TagFromName.ImagePositionVolume,"ImagePositionVolume");
		nameByTag.put(TagFromName.ImageOrientationVolume,"ImageOrientationVolume");
		nameByTag.put(TagFromName.UltrasoundAcquisitionGeometry,"UltrasoundAcquisitionGeometry");
		nameByTag.put(TagFromName.ApexPosition,"ApexPosition");
		nameByTag.put(TagFromName.VolumeToTransducerMappingMatrix,"VolumeToTransducerMappingMatrix");
		nameByTag.put(TagFromName.VolumeToTableMappingMatrix,"VolumeToTableMappingMatrix");
		nameByTag.put(TagFromName.PatientFrameofReferenceSource,"PatientFrameofReferenceSource");
		nameByTag.put(TagFromName.TemporalPositionTimeOffset,"TemporalPositionTimeOffset");
		nameByTag.put(TagFromName.PlanePositionVolumeSequence,"PlanePositionVolumeSequence");
		nameByTag.put(TagFromName.PlaneOrientationVolumeSequence,"PlaneOrientationVolumeSequence");
		nameByTag.put(TagFromName.TemporalPositionSequence,"TemporalPositionSequence");
		nameByTag.put(TagFromName.DimensionOrganizationType,"DimensionOrganizationType");
		nameByTag.put(TagFromName.VolumeFrameOfReferenceUID,"VolumeFrameOfReferenceUID");
		nameByTag.put(TagFromName.TableFrameOfReferenceUID,"TableFrameOfReferenceUID");
		nameByTag.put(TagFromName.DimensionDescriptionLabel,"DimensionDescriptionLabel");
		nameByTag.put(TagFromName.PatientOrientationInFrameSequence,"PatientOrientationInFrameSequence");
		nameByTag.put(TagFromName.FrameLabel,"FrameLabel");
		nameByTag.put(TagFromName.AcquisitionIndex,"AcquisitionIndex");
		nameByTag.put(TagFromName.ContributingSOPInstancesReferenceSequence,"ContributingSOPInstancesReferenceSequence");
		nameByTag.put(TagFromName.ReconstructionIndex,"ReconstructionIndex");
		nameByTag.put(TagFromName.LightPathFilterPassThroughWavelength,"LightPathFilterPassThroughWavelength");
		nameByTag.put(TagFromName.LightPathFilterPassBand,"LightPathFilterPassBand");
		nameByTag.put(TagFromName.ImagePathFilterPassThroughWavelength,"ImagePathFilterPassThroughWavelength");
		nameByTag.put(TagFromName.ImagePathFilterPassBand,"ImagePathFilterPassBand");
		nameByTag.put(TagFromName.PatientEyeMovementCommanded,"PatientEyeMovementCommanded");
		nameByTag.put(TagFromName.PatientEyeMovementCommandedCodeSequence,"PatientEyeMovementCommandedCodeSequence");
		nameByTag.put(TagFromName.SphericalLensPower,"SphericalLensPower");
		nameByTag.put(TagFromName.CylinderLensPower,"CylinderLensPower");
		nameByTag.put(TagFromName.CylinderAxis,"CylinderAxis");
		nameByTag.put(TagFromName.EmmetropicMagnification,"EmmetropicMagnification");
		nameByTag.put(TagFromName.IntraOcularPressure,"IntraOcularPressure");
		nameByTag.put(TagFromName.HorizontalFieldOfView,"HorizontalFieldOfView");
		nameByTag.put(TagFromName.PupilDilated,"PupilDilated");
		nameByTag.put(TagFromName.DegreeOfDilation,"DegreeOfDilation");
		nameByTag.put(TagFromName.StereoBaselineAngle,"StereoBaselineAngle");
		nameByTag.put(TagFromName.StereoBaselineDisplacement,"StereoBaselineDisplacement");
		nameByTag.put(TagFromName.StereoHorizontalPixelOffset,"StereoHorizontalPixelOffset");
		nameByTag.put(TagFromName.StereoVerticalPixelOffset,"StereoVerticalPixelOffset");
		nameByTag.put(TagFromName.StereoRotation,"StereoRotation");
		nameByTag.put(TagFromName.AcquisitionDeviceTypeCodeSequence,"AcquisitionDeviceTypeCodeSequence");
		nameByTag.put(TagFromName.IlluminationTypeCodeSequence,"IlluminationTypeCodeSequence");
		nameByTag.put(TagFromName.LightPathFilterTypeStackCodeSequence,"LightPathFilterTypeStackCodeSequence");
		nameByTag.put(TagFromName.ImagePathFilterTypeStackCodeSequence,"ImagePathFilterTypeStackCodeSequence");
		nameByTag.put(TagFromName.LensesCodeSequence,"LensesCodeSequence");
		nameByTag.put(TagFromName.ChannelDescriptionCodeSequence,"ChannelDescriptionCodeSequence");
		nameByTag.put(TagFromName.RefractiveStateSequence,"RefractiveStateSequence");
		nameByTag.put(TagFromName.MydriaticAgentCodeSequence,"MydriaticAgentCodeSequence");
		nameByTag.put(TagFromName.RelativeImagePositionCodeSequence,"RelativeImagePositionCodeSequence");
		nameByTag.put(TagFromName.StereoPairsSequence,"StereoPairsSequence");
		nameByTag.put(TagFromName.LeftImageSequence,"LeftImageSequence");
		nameByTag.put(TagFromName.RightImageSequence,"RightImageSequence");
		nameByTag.put(TagFromName.AxialLengthOfEye,"AxialLengthOfEye");
		nameByTag.put(TagFromName.OphthalmicFrameLocationSequence,"OphthalmicFrameLocationSequence");
		nameByTag.put(TagFromName.ReferenceCoordinates,"ReferenceCoordinates");
		nameByTag.put(TagFromName.DepthSpatialResolution,"DepthSpatialResolution");
		nameByTag.put(TagFromName.MaximumDepthDistortion,"MaximumDepthDistortion");
		nameByTag.put(TagFromName.AlongScanSpatialResolution,"AlongScanSpatialResolution");
		nameByTag.put(TagFromName.MaximumAlongScanDistortion,"MaximumAlongScanDistortion");
		nameByTag.put(TagFromName.OphthalmicImageOrientation,"OphthalmicImageOrientation");
		nameByTag.put(TagFromName.DepthOfTransverseImage,"DepthOfTransverseImage");
		nameByTag.put(TagFromName.MydriaticAgentConcentrationUnitsSequence,"MydriaticAgentConcentrationUnitsSequence");
		nameByTag.put(TagFromName.AcrossScanSpatialResolution,"AcrossScanSpatialResolution");
		nameByTag.put(TagFromName.MaximumAcrossScanDistortion,"MaximumAcrossScanDistortion");
		nameByTag.put(TagFromName.MydriaticAgentConcentration,"MydriaticAgentConcentration");
		nameByTag.put(TagFromName.IlluminationWaveLength,"IlluminationWaveLength");
		nameByTag.put(TagFromName.IlluminationPower,"IlluminationPower");
		nameByTag.put(TagFromName.IlluminationBandwidth,"IlluminationBandwidth");
		nameByTag.put(TagFromName.MydriaticAgentSequence,"MydriaticAgentSequence");
		nameByTag.put(TagFromName.SamplesPerPixel,"SamplesPerPixel");
		nameByTag.put(TagFromName.SamplesPerPixelUsed,"SamplesPerPixelUsed");
		nameByTag.put(TagFromName.PhotometricInterpretation,"PhotometricInterpretation");
		nameByTag.put(TagFromName.ImageDimensions,"ImageDimensions");
		nameByTag.put(TagFromName.PlanarConfiguration,"PlanarConfiguration");
		nameByTag.put(TagFromName.NumberOfFrames,"NumberOfFrames");
		nameByTag.put(TagFromName.FrameIncrementPointer,"FrameIncrementPointer");
		nameByTag.put(TagFromName.FrameDimensionPointer,"FrameDimensionPointer");
		nameByTag.put(TagFromName.Rows,"Rows");
		nameByTag.put(TagFromName.Columns,"Columns");
		nameByTag.put(TagFromName.Planes,"Planes");
		nameByTag.put(TagFromName.UltrasoundColorDataPresent,"UltrasoundColorDataPresent");
		nameByTag.put(TagFromName.PixelSpacing,"PixelSpacing");
		nameByTag.put(TagFromName.ZoomFactor,"ZoomFactor");
		nameByTag.put(TagFromName.ZoomCenter,"ZoomCenter");
		nameByTag.put(TagFromName.PixelAspectRatio,"PixelAspectRatio");
		nameByTag.put(TagFromName.ImageFormat,"ImageFormat");
		nameByTag.put(TagFromName.ManipulatedImage,"ManipulatedImage");
		nameByTag.put(TagFromName.CorrectedImage,"CorrectedImage");
		nameByTag.put(TagFromName.CompressionRecognitionCode,"CompressionRecognitionCode");
		nameByTag.put(TagFromName.CompressionCode,"CompressionCode");
		nameByTag.put(TagFromName.CompressionOriginator,"CompressionOriginator");
		nameByTag.put(TagFromName.CompressionLabel,"CompressionLabel");
		nameByTag.put(TagFromName.CompressionDescription,"CompressionDescription");
		nameByTag.put(TagFromName.CompressionSequence,"CompressionSequence");
		nameByTag.put(TagFromName.CompressionStepPointers,"CompressionStepPointers");
		nameByTag.put(TagFromName.RepeatInterval,"RepeatInterval");
		nameByTag.put(TagFromName.BitsGrouped,"BitsGrouped");
		nameByTag.put(TagFromName.PerimeterTable,"PerimeterTable");
		nameByTag.put(TagFromName.PerimeterValue,"PerimeterValue");
		nameByTag.put(TagFromName.PredictorRows,"PredictorRows");
		nameByTag.put(TagFromName.PredictorColumns,"PredictorColumns");
		nameByTag.put(TagFromName.PredictorConstants,"PredictorConstants");
		nameByTag.put(TagFromName.BlockedPixels,"BlockedPixels");
		nameByTag.put(TagFromName.BlockRows,"BlockRows");
		nameByTag.put(TagFromName.BlockColumns,"BlockColumns");
		nameByTag.put(TagFromName.RowOverlap,"RowOverlap");
		nameByTag.put(TagFromName.ColumnOverlap,"ColumnOverlap");
		nameByTag.put(TagFromName.BitsAllocated,"BitsAllocated");
		nameByTag.put(TagFromName.BitsStored,"BitsStored");
		nameByTag.put(TagFromName.HighBit,"HighBit");
		nameByTag.put(TagFromName.PixelRepresentation,"PixelRepresentation");
		nameByTag.put(TagFromName.SmallestValidPixelValue,"SmallestValidPixelValue");
		nameByTag.put(TagFromName.LargestValidPixelValue,"LargestValidPixelValue");
		nameByTag.put(TagFromName.SmallestImagePixelValue,"SmallestImagePixelValue");
		nameByTag.put(TagFromName.LargestImagePixelValue,"LargestImagePixelValue");
		nameByTag.put(TagFromName.SmallestPixelValueInSeries,"SmallestPixelValueInSeries");
		nameByTag.put(TagFromName.LargestPixelValueInSeries,"LargestPixelValueInSeries");
		nameByTag.put(TagFromName.SmallestPixelValueInPlane,"SmallestPixelValueInPlane");
		nameByTag.put(TagFromName.LargestPixelValueInPlane,"LargestPixelValueInPlane");
		nameByTag.put(TagFromName.PixelPaddingValue,"PixelPaddingValue");
		nameByTag.put(TagFromName.PixelPaddingRangeLimit,"PixelPaddingRangeLimit");
		nameByTag.put(TagFromName.ImageLocation,"ImageLocation");
		nameByTag.put(TagFromName.QualityControlImage,"QualityControlImage");
		nameByTag.put(TagFromName.BurnedInAnnotation,"BurnedInAnnotation");
		nameByTag.put(TagFromName.TransformLabel,"TransformLabel");
		nameByTag.put(TagFromName.TransformVersionNumber,"TransformVersionNumber");
		nameByTag.put(TagFromName.SequenceOfCompressedData,"SequenceOfCompressedData");
		nameByTag.put(TagFromName.DCTLabel,"DCTLabel");
		nameByTag.put(TagFromName.DataBlockDescription,"DataBlockDescription");
		nameByTag.put(TagFromName.DataBlock,"DataBlock");
		nameByTag.put(TagFromName.NormalizationFactorFormat,"NormalizationFactorFormat");
		nameByTag.put(TagFromName.ZonalMapNumberFormat,"ZonalMapNumberFormat");
		nameByTag.put(TagFromName.ZonalMapLocation,"ZonalMapLocation");
		nameByTag.put(TagFromName.ZonalMapFormat,"ZonalMapFormat");
		nameByTag.put(TagFromName.AdaptiveMapFormat,"AdaptiveMapFormat");
		nameByTag.put(TagFromName.CodeNumberFormat,"CodeNumberFormat");
		nameByTag.put(TagFromName.PixelSpacingCalibrationType,"PixelSpacingCalibrationType");
		nameByTag.put(TagFromName.PixelSpacingCalibrationDescription,"PixelSpacingCalibrationDescription");
		nameByTag.put(TagFromName.PixelIntensityRelationship,"PixelIntensityRelationship");
		nameByTag.put(TagFromName.PixelIntensityRelationshipSign,"PixelIntensityRelationshipSign");
		nameByTag.put(TagFromName.WindowCenter,"WindowCenter");
		nameByTag.put(TagFromName.WindowWidth,"WindowWidth");
		nameByTag.put(TagFromName.RescaleIntercept,"RescaleIntercept");
		nameByTag.put(TagFromName.RescaleSlope,"RescaleSlope");
		nameByTag.put(TagFromName.RescaleType,"RescaleType");
		nameByTag.put(TagFromName.WindowCenterWidthExplanation,"WindowCenterWidthExplanation");
		nameByTag.put(TagFromName.VOILUTFunction,"VOILUTFunction");
		nameByTag.put(TagFromName.GrayScale,"GrayScale");
		nameByTag.put(TagFromName.RecommendedViewingMode,"RecommendedViewingMode");
		nameByTag.put(TagFromName.GrayLookupTableDescriptor,"GrayLookupTableDescriptor");
		nameByTag.put(TagFromName.RedPaletteColorLookupTableDescriptor,"RedPaletteColorLookupTableDescriptor");
		nameByTag.put(TagFromName.GreenPaletteColorLookupTableDescriptor,"GreenPaletteColorLookupTableDescriptor");
		nameByTag.put(TagFromName.BluePaletteColorLookupTableDescriptor,"BluePaletteColorLookupTableDescriptor");
		nameByTag.put(TagFromName.AlphaPaletteColorLookupTableDescriptor,"AlphaPaletteColorLookupTableDescriptor");
		nameByTag.put(TagFromName.LargeRedPaletteColorLookupTableDescriptor,"LargeRedPaletteColorLookupTableDescriptor");
		nameByTag.put(TagFromName.LargeGreenPaletteColorLookupTableDescriptor,"LargeGreenPaletteColorLookupTableDescriptor");
		nameByTag.put(TagFromName.LargeBluePaletteColorLookupTableDescriptor,"LargeBluePaletteColorLookupTableDescriptor");
		nameByTag.put(TagFromName.PaletteColorLookupTableUID,"PaletteColorLookupTableUID");
		nameByTag.put(TagFromName.GrayLookupTableData,"GrayLookupTableData");
		nameByTag.put(TagFromName.RedPaletteColorLookupTableData,"RedPaletteColorLookupTableData");
		nameByTag.put(TagFromName.GreenPaletteColorLookupTableData,"GreenPaletteColorLookupTableData");
		nameByTag.put(TagFromName.BluePaletteColorLookupTableData,"BluePaletteColorLookupTableData");
		nameByTag.put(TagFromName.AlphaPaletteColorLookupTableData,"AlphaPaletteColorLookupTableData");
		nameByTag.put(TagFromName.LargeRedPaletteColorLookupTableData,"LargeRedPaletteColorLookupTableData");
		nameByTag.put(TagFromName.LargeGreenPaletteColorLookupTableData,"LargeGreenPaletteColorLookupTableData");
		nameByTag.put(TagFromName.LargeBluePaletteColorLookupTableData,"LargeBluePaletteColorLookupTableData");
		nameByTag.put(TagFromName.LargePaletteColorLookupTableUID,"LargePaletteColorLookupTableUID");
		nameByTag.put(TagFromName.SegmentedRedPaletteColorLookupTableData,"SegmentedRedPaletteColorLookupTableData");
		nameByTag.put(TagFromName.SegmentedGreenPaletteColorLookupTableData,"SegmentedGreenPaletteColorLookupTableData");
		nameByTag.put(TagFromName.SegmentedBluePaletteColorLookupTableData,"SegmentedBluePaletteColorLookupTableData");
		nameByTag.put(TagFromName.BreastImplantPresent,"BreastImplantPresent");
		nameByTag.put(TagFromName.PartialView,"PartialView");
		nameByTag.put(TagFromName.PartialViewDescription,"PartialViewDescription");
		nameByTag.put(TagFromName.PartialViewCodeSequence,"PartialViewCodeSequence");
		nameByTag.put(TagFromName.SpatialLocationsPreserved,"SpatialLocationsPreserved");
		nameByTag.put(TagFromName.DataFrameAssignmentSequence,"DataFrameAssignmentSequence");
		nameByTag.put(TagFromName.DataPathAssignment,"DataPathAssignment");
		nameByTag.put(TagFromName.BitsMappedToColorLookupTable,"BitsMappedToColorLookupTable");
		nameByTag.put(TagFromName.BlendingLUT1Sequence,"BlendingLUT1Sequence");
		nameByTag.put(TagFromName.BlendingLUT1TransferFunction,"BlendingLUT1TransferFunction");
		nameByTag.put(TagFromName.BlendingWeightConstant,"BlendingWeightConstant");
		nameByTag.put(TagFromName.BlendingLookupTableDescriptor,"BlendingLookupTableDescriptor");
		nameByTag.put(TagFromName.BlendingLookupTableData,"BlendingLookupTableData");
		nameByTag.put(TagFromName.EnhancedPaletteColorLookupTableSequence,"EnhancedPaletteColorLookupTableSequence");
		nameByTag.put(TagFromName.BlendingLUT2Sequence,"BlendingLUT2Sequence");
		nameByTag.put(TagFromName.BlendingLUT2TransferFunction,"BlendingLUT2TransferFunction");
		nameByTag.put(TagFromName.DataPathID,"DataPathID");
		nameByTag.put(TagFromName.RGBLUTTransferFunction,"RGBLUTTransferFunction");
		nameByTag.put(TagFromName.AlphaLUTTransferFunction,"AlphaLUTTransferFunction");
		nameByTag.put(TagFromName.ICCProfile,"ICCProfile");
		nameByTag.put(TagFromName.LossyImageCompression,"LossyImageCompression");
		nameByTag.put(TagFromName.LossyImageCompressionRatio,"LossyImageCompressionRatio");
		nameByTag.put(TagFromName.LossyImageCompressionMethod,"LossyImageCompressionMethod");
		nameByTag.put(TagFromName.ModalityLUTSequence,"ModalityLUTSequence");
		nameByTag.put(TagFromName.LUTDescriptor,"LUTDescriptor");
		nameByTag.put(TagFromName.LUTExplanation,"LUTExplanation");
		nameByTag.put(TagFromName.ModalityLUTType,"ModalityLUTType");
		nameByTag.put(TagFromName.LUTData,"LUTData");
		nameByTag.put(TagFromName.VOILUTSequence,"VOILUTSequence");
		nameByTag.put(TagFromName.SoftcopyVOILUTSequence,"SoftcopyVOILUTSequence");
		nameByTag.put(TagFromName.ImagePresentationComments,"ImagePresentationComments");
		nameByTag.put(TagFromName.BiplaneAcquisitionSequence,"BiplaneAcquisitionSequence");
		nameByTag.put(TagFromName.RepresentativeFrameNumber,"RepresentativeFrameNumber");
		nameByTag.put(TagFromName.FrameNumbersOfInterest,"FrameNumbersOfInterest");
		nameByTag.put(TagFromName.FrameOfInterestDescription,"FrameOfInterestDescription");
		nameByTag.put(TagFromName.FrameOfInterestType,"FrameOfInterestType");
		nameByTag.put(TagFromName.MaskPointer,"MaskPointer");
		nameByTag.put(TagFromName.RWavePointer,"RWavePointer");
		nameByTag.put(TagFromName.MaskSubtractionSequence,"MaskSubtractionSequence");
		nameByTag.put(TagFromName.MaskOperation,"MaskOperation");
		nameByTag.put(TagFromName.ApplicableFrameRange,"ApplicableFrameRange");
		nameByTag.put(TagFromName.MaskFrameNumbers,"MaskFrameNumbers");
		nameByTag.put(TagFromName.ContrastFrameAveraging,"ContrastFrameAveraging");
		nameByTag.put(TagFromName.MaskSubPixelShift,"MaskSubPixelShift");
		nameByTag.put(TagFromName.TIDOffset,"TIDOffset");
		nameByTag.put(TagFromName.MaskOperationExplanation,"MaskOperationExplanation");
		nameByTag.put(TagFromName.PixelDataProviderURL,"PixelDataProviderURL");
		nameByTag.put(TagFromName.DataPointRows,"DataPointRows");
		nameByTag.put(TagFromName.DataPointColumns,"DataPointColumns");
		nameByTag.put(TagFromName.SignalDomainColumns,"SignalDomainColumns");
		nameByTag.put(TagFromName.LargestMonochromePixelValue,"LargestMonochromePixelValue");
		nameByTag.put(TagFromName.DataRepresentation,"DataRepresentation");
		nameByTag.put(TagFromName.PixelMeasuresSequence,"PixelMeasuresSequence");
		nameByTag.put(TagFromName.FrameVOILUTSequence,"FrameVOILUTSequence");
		nameByTag.put(TagFromName.PixelValueTransformationSequence,"PixelValueTransformationSequence");
		nameByTag.put(TagFromName.SignalDomainRows,"SignalDomainRows");
		nameByTag.put(TagFromName.DisplayFilterPercentage,"DisplayFilterPercentage");
		nameByTag.put(TagFromName.FramePixelShiftSequence,"FramePixelShiftSequence");
		nameByTag.put(TagFromName.SubtractionItemID,"SubtractionItemID");
		nameByTag.put(TagFromName.PixelIntensityRelationshipLUTSequence,"PixelIntensityRelationshipLUTSequence");
		nameByTag.put(TagFromName.FramePixelDataPropertiesSequence,"FramePixelDataPropertiesSequence");
		nameByTag.put(TagFromName.GeometricalProperties,"GeometricalProperties");
		nameByTag.put(TagFromName.GeometricMaximumDistortion,"GeometricMaximumDistortion");
		nameByTag.put(TagFromName.ImageProcessingApplied,"ImageProcessingApplied");
		nameByTag.put(TagFromName.MaskSelectionMode,"MaskSelectionMode");
		nameByTag.put(TagFromName.LUTFunction,"LUTFunction");
		nameByTag.put(TagFromName.MaskVisibilityPercentage,"MaskVisibilityPercentage");
		nameByTag.put(TagFromName.PixelShiftSequence,"PixelShiftSequence");
		nameByTag.put(TagFromName.RegionPixelShiftSequence,"RegionPixelShiftSequence");
		nameByTag.put(TagFromName.VerticesOfTheRegion,"VerticesOfTheRegion");
		nameByTag.put(TagFromName.MultiframePresentationSequence,"MultiframePresentationSequence");
		nameByTag.put(TagFromName.PixelShiftFrameRange,"PixelShiftFrameRange");
		nameByTag.put(TagFromName.LUTFrameRange,"LUTFrameRange");
		nameByTag.put(TagFromName.ImageToEquipmentMappingMatrix,"ImageToEquipmentMappingMatrix");
		nameByTag.put(TagFromName.EquipmentCoordinateSystemIdentification,"EquipmentCoordinateSystemIdentification");
		nameByTag.put(TagFromName.StudyStatusID,"StudyStatusID");
		nameByTag.put(TagFromName.StudyPriorityID,"StudyPriorityID");
		nameByTag.put(TagFromName.StudyIDIssuer,"StudyIDIssuer");
		nameByTag.put(TagFromName.StudyVerifiedDate,"StudyVerifiedDate");
		nameByTag.put(TagFromName.StudyVerifiedTime,"StudyVerifiedTime");
		nameByTag.put(TagFromName.StudyReadDate,"StudyReadDate");
		nameByTag.put(TagFromName.StudyReadTime,"StudyReadTime");
		nameByTag.put(TagFromName.ScheduledStudyStartDate,"ScheduledStudyStartDate");
		nameByTag.put(TagFromName.ScheduledStudyStartTime,"ScheduledStudyStartTime");
		nameByTag.put(TagFromName.ScheduledStudyStopDate,"ScheduledStudyStopDate");
		nameByTag.put(TagFromName.ScheduledStudyStopTime,"ScheduledStudyStopTime");
		nameByTag.put(TagFromName.ScheduledStudyLocation,"ScheduledStudyLocation");
		nameByTag.put(TagFromName.ScheduledStudyLocationAETitle,"ScheduledStudyLocationAETitle");
		nameByTag.put(TagFromName.ReasonForStudy,"ReasonForStudy");
		nameByTag.put(TagFromName.RequestingPhysicianIdentificationSequence,"RequestingPhysicianIdentificationSequence");
		nameByTag.put(TagFromName.RequestingPhysician,"RequestingPhysician");
		nameByTag.put(TagFromName.RequestingService,"RequestingService");
		nameByTag.put(TagFromName.StudyArrivalDate,"StudyArrivalDate");
		nameByTag.put(TagFromName.StudyArrivalTime,"StudyArrivalTime");
		nameByTag.put(TagFromName.StudyCompletionDate,"StudyCompletionDate");
		nameByTag.put(TagFromName.StudyCompletionTime,"StudyCompletionTime");
		nameByTag.put(TagFromName.StudyComponentStatusID,"StudyComponentStatusID");
		nameByTag.put(TagFromName.RequestedProcedureDescription,"RequestedProcedureDescription");
		nameByTag.put(TagFromName.RequestedProcedureCodeSequence,"RequestedProcedureCodeSequence");
		nameByTag.put(TagFromName.RequestedContrastAgent,"RequestedContrastAgent");
		nameByTag.put(TagFromName.StudyComments,"StudyComments");
		nameByTag.put(TagFromName.ReferencedPatientAliasSequence,"ReferencedPatientAliasSequence");
		nameByTag.put(TagFromName.VisitStatusID,"VisitStatusID");
		nameByTag.put(TagFromName.AdmissionID,"AdmissionID");
		nameByTag.put(TagFromName.IssuerOfAdmissionID,"IssuerOfAdmissionID");
		nameByTag.put(TagFromName.IssuerOfAdmissionIDSequence,"IssuerOfAdmissionIDSequence");
		nameByTag.put(TagFromName.RouteOfAdmissions,"RouteOfAdmissions");
		nameByTag.put(TagFromName.ScheduledAdmissionDate,"ScheduledAdmissionDate");
		nameByTag.put(TagFromName.ScheduledAdmissionTime,"ScheduledAdmissionTime");
		nameByTag.put(TagFromName.ScheduledDischargeDate,"ScheduledDischargeDate");
		nameByTag.put(TagFromName.ScheduledDischargeTime,"ScheduledDischargeTime");
		nameByTag.put(TagFromName.ScheduledPatientInstitutionResidence,"ScheduledPatientInstitutionResidence");
		nameByTag.put(TagFromName.AdmittingDate,"AdmittingDate");
		nameByTag.put(TagFromName.AdmittingTime,"AdmittingTime");
		nameByTag.put(TagFromName.DischargeDate,"DischargeDate");
		nameByTag.put(TagFromName.DischargeTime,"DischargeTime");
		nameByTag.put(TagFromName.DischargeDiagnosisDescription,"DischargeDiagnosisDescription");
		nameByTag.put(TagFromName.DischargeDiagnosisCodeSequence,"DischargeDiagnosisCodeSequence");
		nameByTag.put(TagFromName.SpecialNeeds,"SpecialNeeds");
		nameByTag.put(TagFromName.ServiceEpisodeID,"ServiceEpisodeID");
		nameByTag.put(TagFromName.IssuerOfServiceEpisodeID,"IssuerOfServiceEpisodeID");
		nameByTag.put(TagFromName.ServiceEpisodeDescription,"ServiceEpisodeDescription");
		nameByTag.put(TagFromName.IssuerOfServiceEpisodeIDSequence,"IssuerOfServiceEpisodeIDSequence");
		nameByTag.put(TagFromName.PertinentDocumentsSequence,"PertinentDocumentsSequence");
		nameByTag.put(TagFromName.CurrentPatientLocation,"CurrentPatientLocation");
		nameByTag.put(TagFromName.PatientInstitutionResidence,"PatientInstitutionResidence");
		nameByTag.put(TagFromName.PatientState,"PatientState");
		nameByTag.put(TagFromName.PatientClinicalTrialParticipationSequence,"PatientClinicalTrialParticipationSequence");
		nameByTag.put(TagFromName.VisitComments,"VisitComments");
		nameByTag.put(TagFromName.WaveformOriginality,"WaveformOriginality");
		nameByTag.put(TagFromName.NumberOfWaveformChannels,"NumberOfWaveformChannels");
		nameByTag.put(TagFromName.NumberOfWaveformSamples,"NumberOfWaveformSamples");
		nameByTag.put(TagFromName.SamplingFrequency,"SamplingFrequency");
		nameByTag.put(TagFromName.MultiplexGroupLabel,"MultiplexGroupLabel");
		nameByTag.put(TagFromName.ChannelDefinitionSequence,"ChannelDefinitionSequence");
		nameByTag.put(TagFromName.WaveformChannelNumber,"WaveformChannelNumber");
		nameByTag.put(TagFromName.ChannelLabel,"ChannelLabel");
		nameByTag.put(TagFromName.ChannelStatus,"ChannelStatus");
		nameByTag.put(TagFromName.ChannelSourceSequence,"ChannelSourceSequence");
		nameByTag.put(TagFromName.ChannelSourceModifiersSequence,"ChannelSourceModifiersSequence");
		nameByTag.put(TagFromName.SourceWaveformSequence,"SourceWaveformSequence");
		nameByTag.put(TagFromName.ChannelDerivationDescription,"ChannelDerivationDescription");
		nameByTag.put(TagFromName.ChannelSensitivity,"ChannelSensitivity");
		nameByTag.put(TagFromName.ChannelSensitivityUnitsSequence,"ChannelSensitivityUnitsSequence");
		nameByTag.put(TagFromName.ChannelSensitivityCorrectionFactor,"ChannelSensitivityCorrectionFactor");
		nameByTag.put(TagFromName.ChannelBaseline,"ChannelBaseline");
		nameByTag.put(TagFromName.ChannelTimeSkew,"ChannelTimeSkew");
		nameByTag.put(TagFromName.ChannelSampleSkew,"ChannelSampleSkew");
		nameByTag.put(TagFromName.ChannelOffset,"ChannelOffset");
		nameByTag.put(TagFromName.WaveformBitsStored,"WaveformBitsStored");
		nameByTag.put(TagFromName.FilterLowFrequency,"FilterLowFrequency");
		nameByTag.put(TagFromName.FilterHighFrequency,"FilterHighFrequency");
		nameByTag.put(TagFromName.NotchFilterFrequency,"NotchFilterFrequency");
		nameByTag.put(TagFromName.NotchFilterBandwidth,"NotchFilterBandwidth");
		nameByTag.put(TagFromName.WaveformDataDisplayScale,"WaveformDataDisplayScale");
		nameByTag.put(TagFromName.WaveformDisplayBackgroundCIELabValue,"WaveformDisplayBackgroundCIELabValue");
		nameByTag.put(TagFromName.WaveformPresentationGroupSequence,"WaveformPresentationGroupSequence");
		nameByTag.put(TagFromName.PresentationGroupNumber,"PresentationGroupNumber");
		nameByTag.put(TagFromName.ChannelDisplaySequence,"ChannelDisplaySequence");
		nameByTag.put(TagFromName.ChannelRecommendedDisplayCIELabValue,"ChannelRecommendedDisplayCIELabValue");
		nameByTag.put(TagFromName.ChannelPosition,"ChannelPosition");
		nameByTag.put(TagFromName.DisplayShadingFlag,"DisplayShadingFlag");
		nameByTag.put(TagFromName.FractionalChannelDisplayScale,"FractionalChannelDisplayScale");
		nameByTag.put(TagFromName.AbsoluteChannelDisplayScale,"AbsoluteChannelDisplayScale");
		nameByTag.put(TagFromName.MultiplexedAudioChannelsDescriptionCodeSequence,"MultiplexedAudioChannelsDescriptionCodeSequence");
		nameByTag.put(TagFromName.ChannelIdentificationCode,"ChannelIdentificationCode");
		nameByTag.put(TagFromName.ChannelMode,"ChannelMode");
		nameByTag.put(TagFromName.ScheduledStationAETitle,"ScheduledStationAETitle");
		nameByTag.put(TagFromName.ScheduledProcedureStepStartDate,"ScheduledProcedureStepStartDate");
		nameByTag.put(TagFromName.ScheduledProcedureStepStartTime,"ScheduledProcedureStepStartTime");
		nameByTag.put(TagFromName.ScheduledProcedureStepEndDate,"ScheduledProcedureStepEndDate");
		nameByTag.put(TagFromName.ScheduledProcedureStepEndTime,"ScheduledProcedureStepEndTime");
		nameByTag.put(TagFromName.ScheduledPerformingPhysicianName,"ScheduledPerformingPhysicianName");
		nameByTag.put(TagFromName.ScheduledProcedureStepDescription,"ScheduledProcedureStepDescription");
		nameByTag.put(TagFromName.ScheduledProtocolCodeSequence,"ScheduledProtocolCodeSequence");
		nameByTag.put(TagFromName.ScheduledProcedureStepID,"ScheduledProcedureStepID");
		nameByTag.put(TagFromName.StageCodeSequence,"StageCodeSequence");
		nameByTag.put(TagFromName.ScheduledPerformingPhysicianIdentificationSequence,"ScheduledPerformingPhysicianIdentificationSequence");
		nameByTag.put(TagFromName.ScheduledStationName,"ScheduledStationName");
		nameByTag.put(TagFromName.ScheduledProcedureStepLocation,"ScheduledProcedureStepLocation");
		nameByTag.put(TagFromName.PreMedication,"PreMedication");
		nameByTag.put(TagFromName.ScheduledProcedureStepStatus,"ScheduledProcedureStepStatus");
		nameByTag.put(TagFromName.OrderPlacerIdentifierSequence,"OrderPlacerIdentifierSequence");
		nameByTag.put(TagFromName.OrderFillerIdentifierSequence,"OrderFillerIdentifierSequence");
		nameByTag.put(TagFromName.LocalNamespaceEntityID,"LocalNamespaceEntityID");
		nameByTag.put(TagFromName.UniversalEntityID,"UniversalEntityID");
		nameByTag.put(TagFromName.UniversalEntityIDType,"UniversalEntityIDType");
		nameByTag.put(TagFromName.IdentifierTypeCode,"IdentifierTypeCode");
		nameByTag.put(TagFromName.AssigningFacilitySequence,"AssigningFacilitySequence");
		nameByTag.put(TagFromName.AssigningJurisdictionCodeSequence,"AssigningJurisdictionCodeSequence");
		nameByTag.put(TagFromName.AssigningAgencyOrDepartmentCodeSequence,"AssigningAgencyOrDepartmentCodeSequence");
		nameByTag.put(TagFromName.ScheduledProcedureStepSequence,"ScheduledProcedureStepSequence");
		nameByTag.put(TagFromName.ReferencedNonImageCompositeSOPInstanceSequence,"ReferencedNonImageCompositeSOPInstanceSequence");
		nameByTag.put(TagFromName.PerformedStationAETitle,"PerformedStationAETitle");
		nameByTag.put(TagFromName.PerformedStationName,"PerformedStationName");
		nameByTag.put(TagFromName.PerformedLocation,"PerformedLocation");
		nameByTag.put(TagFromName.PerformedProcedureStepStartDate,"PerformedProcedureStepStartDate");
		nameByTag.put(TagFromName.PerformedProcedureStepStartTime,"PerformedProcedureStepStartTime");
		nameByTag.put(TagFromName.PerformedProcedureStepEndDate,"PerformedProcedureStepEndDate");
		nameByTag.put(TagFromName.PerformedProcedureStepEndTime,"PerformedProcedureStepEndTime");
		nameByTag.put(TagFromName.PerformedProcedureStepStatus,"PerformedProcedureStepStatus");
		nameByTag.put(TagFromName.PerformedProcedureStepID,"PerformedProcedureStepID");
		nameByTag.put(TagFromName.PerformedProcedureStepDescription,"PerformedProcedureStepDescription");
		nameByTag.put(TagFromName.PerformedProcedureTypeDescription,"PerformedProcedureTypeDescription");
		nameByTag.put(TagFromName.PerformedProtocolCodeSequence,"PerformedProtocolCodeSequence");
		nameByTag.put(TagFromName.PerformedProtocolType,"PerformedProtocolType");
		nameByTag.put(TagFromName.ScheduledStepAttributesSequence,"ScheduledStepAttributesSequence");
		nameByTag.put(TagFromName.RequestAttributesSequence,"RequestAttributesSequence");
		nameByTag.put(TagFromName.CommentsOnPerformedProcedureStep,"CommentsOnPerformedProcedureStep");
		nameByTag.put(TagFromName.PerformedProcedureStepDiscontinuationReasonCodeSequence,"PerformedProcedureStepDiscontinuationReasonCodeSequence");
		nameByTag.put(TagFromName.QuantitySequence,"QuantitySequence");
		nameByTag.put(TagFromName.Quantity,"Quantity");
		nameByTag.put(TagFromName.MeasuringUnitsSequence,"MeasuringUnitsSequence");
		nameByTag.put(TagFromName.BillingItemSequence,"BillingItemSequence");
		nameByTag.put(TagFromName.TotalTimeOfFluoroscopy,"TotalTimeOfFluoroscopy");
		nameByTag.put(TagFromName.TotalNumberOfExposures,"TotalNumberOfExposures");
		nameByTag.put(TagFromName.EntranceDose,"EntranceDose");
		nameByTag.put(TagFromName.ExposedArea,"ExposedArea");
		nameByTag.put(TagFromName.DistanceSourceToEntrance,"DistanceSourceToEntrance");
		nameByTag.put(TagFromName.DistanceSourceToSupport,"DistanceSourceToSupport");
		nameByTag.put(TagFromName.ExposureDoseSequence,"ExposureDoseSequence");
		nameByTag.put(TagFromName.CommentsOnRadiationDose,"CommentsOnRadiationDose");
		nameByTag.put(TagFromName.XRayOutput,"XRayOutput");
		nameByTag.put(TagFromName.HalfValueLayer,"HalfValueLayer");
		nameByTag.put(TagFromName.OrganDose,"OrganDose");
		nameByTag.put(TagFromName.OrganExposed,"OrganExposed");
		nameByTag.put(TagFromName.BillingProcedureStepSequence,"BillingProcedureStepSequence");
		nameByTag.put(TagFromName.FilmConsumptionSequence,"FilmConsumptionSequence");
		nameByTag.put(TagFromName.BillingSuppliesAndDevicesSequence,"BillingSuppliesAndDevicesSequence");
		nameByTag.put(TagFromName.ReferencedProcedureStepSequence,"ReferencedProcedureStepSequence");
		nameByTag.put(TagFromName.PerformedSeriesSequence,"PerformedSeriesSequence");
		nameByTag.put(TagFromName.CommentsOnScheduledProcedureStep,"CommentsOnScheduledProcedureStep");
		nameByTag.put(TagFromName.ProtocolContextSequence,"ProtocolContextSequence");
		nameByTag.put(TagFromName.ContentItemModifierSequence,"ContentItemModifierSequence");
		nameByTag.put(TagFromName.ScheduledSpecimenSequence,"ScheduledSpecimenSequence");
		nameByTag.put(TagFromName.SpecimenAccessionNumber,"SpecimenAccessionNumber");
		nameByTag.put(TagFromName.ContainerIdentifier,"ContainerIdentifier");
		nameByTag.put(TagFromName.IssuerOfTheContainerIdentifierSequence,"IssuerOfTheContainerIdentifierSequence");
		nameByTag.put(TagFromName.AlternateContainerIdentifierSequence,"AlternateContainerIdentifierSequence");
		nameByTag.put(TagFromName.ContainerTypeCodeSequence,"ContainerTypeCodeSequence");
		nameByTag.put(TagFromName.ContainerDescription,"ContainerDescription");
		nameByTag.put(TagFromName.ContainerComponentSequence,"ContainerComponentSequence");
		nameByTag.put(TagFromName.SpecimenSequence,"SpecimenSequence");
		nameByTag.put(TagFromName.SpecimenIdentifier,"SpecimenIdentifier");
		nameByTag.put(TagFromName.SpecimenDescriptionSequenceTrial,"SpecimenDescriptionSequenceTrial");
		nameByTag.put(TagFromName.SpecimenDescriptionTrial,"SpecimenDescriptionTrial");
		nameByTag.put(TagFromName.SpecimenUID,"SpecimenUID");
		nameByTag.put(TagFromName.AcquisitionContextSequence,"AcquisitionContextSequence");
		nameByTag.put(TagFromName.AcquisitionContextDescription,"AcquisitionContextDescription");
		nameByTag.put(TagFromName.SpecimenDescriptionSequence,"SpecimenDescriptionSequence");
		nameByTag.put(TagFromName.IssuerOfTheSpecimenIdentifierSequence,"IssuerOfTheSpecimenIdentifierSequence");
		nameByTag.put(TagFromName.SpecimenTypeCodeSequence,"SpecimenTypeCodeSequence");
		nameByTag.put(TagFromName.SpecimenShortDescription,"SpecimenShortDescription");
		nameByTag.put(TagFromName.SpecimenDetailedDescription,"SpecimenDetailedDescription");
		nameByTag.put(TagFromName.SpecimenPreparationSequence,"SpecimenPreparationSequence");
		nameByTag.put(TagFromName.SpecimenPreparationStepContentItemSequence,"SpecimenPreparationStepContentItemSequence");
		nameByTag.put(TagFromName.SpecimenLocalizationContentItemSequence,"SpecimenLocalizationContentItemSequence");
		nameByTag.put(TagFromName.SlideIdentifier,"SlideIdentifier");
		nameByTag.put(TagFromName.ImageCenterPointCoordinatesSequence,"ImageCenterPointCoordinatesSequence");
		nameByTag.put(TagFromName.XOffsetInSlideCoordinateSystem,"XOffsetInSlideCoordinateSystem");
		nameByTag.put(TagFromName.YOffsetInSlideCoordinateSystem,"YOffsetInSlideCoordinateSystem");
		nameByTag.put(TagFromName.ZOffsetInSlideCoordinateSystem,"ZOffsetInSlideCoordinateSystem");
		nameByTag.put(TagFromName.PixelSpacingSequence,"PixelSpacingSequence");
		nameByTag.put(TagFromName.CoordinateSystemAxisCodeSequence,"CoordinateSystemAxisCodeSequence");
		nameByTag.put(TagFromName.MeasurementUnitsCodeSequence,"MeasurementUnitsCodeSequence");
		nameByTag.put(TagFromName.VitalStainCodeSequenceTrial,"VitalStainCodeSequenceTrial");
		nameByTag.put(TagFromName.RequestedProcedureID,"RequestedProcedureID");
		nameByTag.put(TagFromName.ReasonForRequestedProcedure,"ReasonForRequestedProcedure");
		nameByTag.put(TagFromName.RequestedProcedurePriority,"RequestedProcedurePriority");
		nameByTag.put(TagFromName.PatientTransportArrangements,"PatientTransportArrangements");
		nameByTag.put(TagFromName.RequestedProcedureLocation,"RequestedProcedureLocation");
		nameByTag.put(TagFromName.PlacerOrderNumberOfProcedure,"PlacerOrderNumberOfProcedure");
		nameByTag.put(TagFromName.FillerOrderNumberOfProcedure,"FillerOrderNumberOfProcedure");
		nameByTag.put(TagFromName.ConfidentialityCode,"ConfidentialityCode");
		nameByTag.put(TagFromName.ReportingPriority,"ReportingPriority");
		nameByTag.put(TagFromName.ReasonForRequestedProcedureCodeSequence,"ReasonForRequestedProcedureCodeSequence");
		nameByTag.put(TagFromName.NamesOfIntendedRecipientsOfResults,"NamesOfIntendedRecipientsOfResults");
		nameByTag.put(TagFromName.IntendedRecipientsOfResultsIdentificationSequence,"IntendedRecipientsOfResultsIdentificationSequence");
		nameByTag.put(TagFromName.PersonIdentificationCodeSequence,"PersonIdentificationCodeSequence");
		nameByTag.put(TagFromName.PersonAddress,"PersonAddress");
		nameByTag.put(TagFromName.PersonTelephoneNumbers,"PersonTelephoneNumbers");
		nameByTag.put(TagFromName.RequestedProcedureComments,"RequestedProcedureComments");
		nameByTag.put(TagFromName.ReasonForImagingServiceRequest,"ReasonForImagingServiceRequest");
		nameByTag.put(TagFromName.IssueDateOfImagingServiceRequest,"IssueDateOfImagingServiceRequest");
		nameByTag.put(TagFromName.IssueTimeOfImagingServiceRequest,"IssueTimeOfImagingServiceRequest");
		nameByTag.put(TagFromName.PlacerOrderNumberOfImagingServiceRequestRetired,"PlacerOrderNumberOfImagingServiceRequestRetired");
		nameByTag.put(TagFromName.FillerOrderNumberOfImagingServiceRequestRetired,"FillerOrderNumberOfImagingServiceRequestRetired");
		nameByTag.put(TagFromName.OrderEnteredBy,"OrderEnteredBy");
		nameByTag.put(TagFromName.OrderEntererLocation,"OrderEntererLocation");
		nameByTag.put(TagFromName.OrderCallbackPhoneNumber,"OrderCallbackPhoneNumber");
		nameByTag.put(TagFromName.PlacerOrderNumberOfImagingServiceRequest,"PlacerOrderNumberOfImagingServiceRequest");
		nameByTag.put(TagFromName.FillerOrderNumberOfImagingServiceRequest,"FillerOrderNumberOfImagingServiceRequest");
		nameByTag.put(TagFromName.ImagingServiceRequestComments,"ImagingServiceRequestComments");
		nameByTag.put(TagFromName.ConfidentialityConstraintOnPatientDataDescription,"ConfidentialityConstraintOnPatientDataDescription");
		nameByTag.put(TagFromName.GeneralPurposeScheduledProcedureStepStatus,"GeneralPurposeScheduledProcedureStepStatus");
		nameByTag.put(TagFromName.GeneralPurposePerformedProcedureStepStatus,"GeneralPurposePerformedProcedureStepStatus");
		nameByTag.put(TagFromName.GeneralPurposeScheduledProcedureStepPriority,"GeneralPurposeScheduledProcedureStepPriority");
		nameByTag.put(TagFromName.ScheduledProcessingApplicationsCodeSequence,"ScheduledProcessingApplicationsCodeSequence");
		nameByTag.put(TagFromName.ScheduledProcedureStepStartDateAndTime,"ScheduledProcedureStepStartDateAndTime");
		nameByTag.put(TagFromName.MultipleCopiesFlag,"MultipleCopiesFlag");
		nameByTag.put(TagFromName.PerformedProcessingApplicationsCodeSequence,"PerformedProcessingApplicationsCodeSequence");
		nameByTag.put(TagFromName.HumanPerformerCodeSequence,"HumanPerformerCodeSequence");
		nameByTag.put(TagFromName.ScheduledProcedureStepModificationDateAndTime,"ScheduledProcedureStepModificationDateAndTime");
		nameByTag.put(TagFromName.ExpectedCompletionDateAndTime,"ExpectedCompletionDateAndTime");
		nameByTag.put(TagFromName.ResultingGeneralPurposePerformedProcedureStepsSequence,"ResultingGeneralPurposePerformedProcedureStepsSequence");
		nameByTag.put(TagFromName.ReferencedGeneralPurposeScheduledProcedureStepSequence,"ReferencedGeneralPurposeScheduledProcedureStepSequence");
		nameByTag.put(TagFromName.ScheduledWorkitemCodeSequence,"ScheduledWorkitemCodeSequence");
		nameByTag.put(TagFromName.PerformedWorkitemCodeSequence,"PerformedWorkitemCodeSequence");
		nameByTag.put(TagFromName.InputAvailabilityFlag,"InputAvailabilityFlag");
		nameByTag.put(TagFromName.InputInformationSequence,"InputInformationSequence");
		nameByTag.put(TagFromName.RelevantInformationSequence,"RelevantInformationSequence");
		nameByTag.put(TagFromName.ReferencedGeneralPurposeScheduledProcedureStepTransactionUID,"ReferencedGeneralPurposeScheduledProcedureStepTransactionUID");
		nameByTag.put(TagFromName.ScheduledStationNameCodeSequence,"ScheduledStationNameCodeSequence");
		nameByTag.put(TagFromName.ScheduledStationClassCodeSequence,"ScheduledStationClassCodeSequence");
		nameByTag.put(TagFromName.ScheduledStationGeographicLocationCodeSequence,"ScheduledStationGeographicLocationCodeSequence");
		nameByTag.put(TagFromName.PerformedStationNameCodeSequence,"PerformedStationNameCodeSequence");
		nameByTag.put(TagFromName.PerformedStationClassCodeSequence,"PerformedStationClassCodeSequence");
		nameByTag.put(TagFromName.PerformedStationGeographicLocationCodeSequence,"PerformedStationGeographicLocationCodeSequence");
		nameByTag.put(TagFromName.RequestedSubsequentWorkitemCodeSequence,"RequestedSubsequentWorkitemCodeSequence");
		nameByTag.put(TagFromName.NonDICOMOutputCodeSequence,"NonDICOMOutputCodeSequence");
		nameByTag.put(TagFromName.OutputInformationSequence,"OutputInformationSequence");
		nameByTag.put(TagFromName.ScheduledHumanPerformersSequence,"ScheduledHumanPerformersSequence");
		nameByTag.put(TagFromName.ActualHumanPerformersSequence,"ActualHumanPerformersSequence");
		nameByTag.put(TagFromName.HumanPerformersOrganization,"HumanPerformersOrganization");
		nameByTag.put(TagFromName.HumanPerformersName,"HumanPerformersName");
		nameByTag.put(TagFromName.EntranceDoseInmGy,"EntranceDoseInmGy");
		nameByTag.put(TagFromName.ReferencedImageRealWorldValueMappingSequence,"ReferencedImageRealWorldValueMappingSequence");
		nameByTag.put(TagFromName.RealWorldValueMappingSequence,"RealWorldValueMappingSequence");
		nameByTag.put(TagFromName.PixelValueMappingCodeSequence,"PixelValueMappingCodeSequence");
		nameByTag.put(TagFromName.LUTLabel,"LUTLabel");
		nameByTag.put(TagFromName.RealWorldValueLastValueMapped,"RealWorldValueLastValueMapped");
		nameByTag.put(TagFromName.RealWorldValueLUTData,"RealWorldValueLUTData");
		nameByTag.put(TagFromName.RealWorldValueFirstValueMapped,"RealWorldValueFirstValueMapped");
		nameByTag.put(TagFromName.RealWorldValueIntercept,"RealWorldValueIntercept");
		nameByTag.put(TagFromName.RealWorldValueSlope,"RealWorldValueSlope");
		nameByTag.put(TagFromName.FindingsFlagTrial,"FindingsFlagTrial");
		nameByTag.put(TagFromName.RelationshipType,"RelationshipType");
		nameByTag.put(TagFromName.FindingsSequenceTrial,"FindingsSequenceTrial");
		nameByTag.put(TagFromName.FindingsGroupUIDTrial,"FindingsGroupUIDTrial");
		nameByTag.put(TagFromName.ReferencedFindingsGroupUIDTrial,"ReferencedFindingsGroupUIDTrial");
		nameByTag.put(TagFromName.FindingsGroupRecordingDateTrial,"FindingsGroupRecordingDateTrial");
		nameByTag.put(TagFromName.FindingsGroupRecordingTimeTrial,"FindingsGroupRecordingTimeTrial");
		nameByTag.put(TagFromName.FindingsSourceCategoryCodeSequenceTrial,"FindingsSourceCategoryCodeSequenceTrial");
		nameByTag.put(TagFromName.VerifyingOrganization,"VerifyingOrganization");
		nameByTag.put(TagFromName.DocumentingOrganizationIdentifierCodeSequenceTrial,"DocumentingOrganizationIdentifierCodeSequenceTrial");
		nameByTag.put(TagFromName.VerificationDateTime,"VerificationDateTime");
		nameByTag.put(TagFromName.ObservationDateTime,"ObservationDateTime");
		nameByTag.put(TagFromName.ValueType,"ValueType");
		nameByTag.put(TagFromName.ConceptNameCodeSequence,"ConceptNameCodeSequence");
		nameByTag.put(TagFromName.MeasurementPrecisionDescriptionTrial,"MeasurementPrecisionDescriptionTrial");
		nameByTag.put(TagFromName.ContinuityOfContent,"ContinuityOfContent");
		nameByTag.put(TagFromName.UrgencyOrPriorityAlertsTrial,"UrgencyOrPriorityAlertsTrial");
		nameByTag.put(TagFromName.SequencingIndicatorTrial,"SequencingIndicatorTrial");
		nameByTag.put(TagFromName.DocumentIdentifierCodeSequenceTrial,"DocumentIdentifierCodeSequenceTrial");
		nameByTag.put(TagFromName.DocumentAuthorTrial,"DocumentAuthorTrial");
		nameByTag.put(TagFromName.DocumentAuthorIdentifierCodeSequenceTrial,"DocumentAuthorIdentifierCodeSequenceTrial");
		nameByTag.put(TagFromName.IdentifierCodeSequenceTrial,"IdentifierCodeSequenceTrial");
		nameByTag.put(TagFromName.VerifyingObserverSequence,"VerifyingObserverSequence");
		nameByTag.put(TagFromName.ObjectBinaryIdentifierTrial,"ObjectBinaryIdentifierTrial");
		nameByTag.put(TagFromName.VerifyingObserverName,"VerifyingObserverName");
		nameByTag.put(TagFromName.DocumentingObserverIdentifierCodeSequenceTrial,"DocumentingObserverIdentifierCodeSequenceTrial");
		nameByTag.put(TagFromName.AuthorObserverSequence,"AuthorObserverSequence");
		nameByTag.put(TagFromName.ParticipantSequence,"ParticipantSequence");
		nameByTag.put(TagFromName.CustodialOrganizationSequence,"CustodialOrganizationSequence");
		nameByTag.put(TagFromName.ParticipationType,"ParticipationType");
		nameByTag.put(TagFromName.ParticipationDateTime,"ParticipationDateTime");
		nameByTag.put(TagFromName.ObserverType,"ObserverType");
		nameByTag.put(TagFromName.ProcedureIdentifierCodeSequenceTrial,"ProcedureIdentifierCodeSequenceTrial");
		nameByTag.put(TagFromName.VerifyingObserverIdentificationCodeSequence,"VerifyingObserverIdentificationCodeSequence");
		nameByTag.put(TagFromName.ObjectDirectoryBinaryIdentifierTrial,"ObjectDirectoryBinaryIdentifierTrial");
		nameByTag.put(TagFromName.EquivalentCDADocumentSequence,"EquivalentCDADocumentSequence");
		nameByTag.put(TagFromName.ReferencedWaveformChannels,"ReferencedWaveformChannels");
		nameByTag.put(TagFromName.DateOfDocumentOrVerbalTransactionTrial,"DateOfDocumentOrVerbalTransactionTrial");
		nameByTag.put(TagFromName.TimeOfDocumentCreationOrVerbalTransactionTrial,"TimeOfDocumentCreationOrVerbalTransactionTrial");
		nameByTag.put(TagFromName.DateTime,"DateTime");
		nameByTag.put(TagFromName.Date,"Date");
		nameByTag.put(TagFromName.Time,"Time");
		nameByTag.put(TagFromName.PersonName,"PersonName");
		nameByTag.put(TagFromName.UID,"UID");
		nameByTag.put(TagFromName.ReportStatusIDTrial,"ReportStatusIDTrial");
		nameByTag.put(TagFromName.TemporalRangeType,"TemporalRangeType");
		nameByTag.put(TagFromName.ReferencedSamplePositions,"ReferencedSamplePositions");
		nameByTag.put(TagFromName.ReferencedFrameNumbers,"ReferencedFrameNumbers");
		nameByTag.put(TagFromName.ReferencedTimeOffsets,"ReferencedTimeOffsets");
		nameByTag.put(TagFromName.ReferencedDateTime,"ReferencedDateTime");
		nameByTag.put(TagFromName.TextValue,"TextValue");
		nameByTag.put(TagFromName.ObservationCategoryCodeSequenceTrial,"ObservationCategoryCodeSequenceTrial");
		nameByTag.put(TagFromName.ConceptCodeSequence,"ConceptCodeSequence");
		nameByTag.put(TagFromName.BibliographicCitationTrial,"BibliographicCitationTrial");
		nameByTag.put(TagFromName.PurposeOfReferenceCodeSequence,"PurposeOfReferenceCodeSequence");
		nameByTag.put(TagFromName.ObservationUIDTrial,"ObservationUIDTrial");
		nameByTag.put(TagFromName.ReferencedObservationUIDTrial,"ReferencedObservationUIDTrial");
		nameByTag.put(TagFromName.ReferencedObservationClassTrial,"ReferencedObservationClassTrial");
		nameByTag.put(TagFromName.ReferencedObjectObservationClassTrial,"ReferencedObjectObservationClassTrial");
		nameByTag.put(TagFromName.AnnotationGroupNumber,"AnnotationGroupNumber");
		nameByTag.put(TagFromName.ObservationDateTrial,"ObservationDateTrial");
		nameByTag.put(TagFromName.ObservationTimeTrial,"ObservationTimeTrial");
		nameByTag.put(TagFromName.MeasurementAutomationTrial,"MeasurementAutomationTrial");
		nameByTag.put(TagFromName.ModifierCodeSequence,"ModifierCodeSequence");
		nameByTag.put(TagFromName.IdentificationDescriptionTrial,"IdentificationDescriptionTrial");
		nameByTag.put(TagFromName.CoordinatesSetGeometricTypeTrial,"CoordinatesSetGeometricTypeTrial");
		nameByTag.put(TagFromName.AlgorithmCodeSequenceTrial,"AlgorithmCodeSequenceTrial");
		nameByTag.put(TagFromName.AlgorithmDescriptionTrial,"AlgorithmDescriptionTrial");
		nameByTag.put(TagFromName.PixelCoordinatesSetTrial,"PixelCoordinatesSetTrial");
		nameByTag.put(TagFromName.MeasuredValueSequence,"MeasuredValueSequence");
		nameByTag.put(TagFromName.NumericValueQualifierCodeSequence,"NumericValueQualifierCodeSequence");
		nameByTag.put(TagFromName.CurrentObserverTrial,"CurrentObserverTrial");
		nameByTag.put(TagFromName.NumericValue,"NumericValue");
		nameByTag.put(TagFromName.ReferencedAccessionSequenceTrial,"ReferencedAccessionSequenceTrial");
		nameByTag.put(TagFromName.ReportStatusCommentTrial,"ReportStatusCommentTrial");
		nameByTag.put(TagFromName.ProcedureContextSequenceTrial,"ProcedureContextSequenceTrial");
		nameByTag.put(TagFromName.VerbalSourceTrial,"VerbalSourceTrial");
		nameByTag.put(TagFromName.AddressTrial,"AddressTrial");
		nameByTag.put(TagFromName.TelephoneNumberTrial,"TelephoneNumberTrial");
		nameByTag.put(TagFromName.VerbalSourceIdentifierCodeSequenceTrial,"VerbalSourceIdentifierCodeSequenceTrial");
		nameByTag.put(TagFromName.PredecessorDocumentsSequence,"PredecessorDocumentsSequence");
		nameByTag.put(TagFromName.ReferencedRequestSequence,"ReferencedRequestSequence");
		nameByTag.put(TagFromName.PerformedProcedureCodeSequence,"PerformedProcedureCodeSequence");
		nameByTag.put(TagFromName.CurrentRequestedProcedureEvidenceSequence,"CurrentRequestedProcedureEvidenceSequence");
		nameByTag.put(TagFromName.ReportDetailSequenceTrial,"ReportDetailSequenceTrial");
		nameByTag.put(TagFromName.PertinentOtherEvidenceSequence,"PertinentOtherEvidenceSequence");
		nameByTag.put(TagFromName.HL7StructuredDocumentReferenceSequence,"HL7StructuredDocumentReferenceSequence");
		nameByTag.put(TagFromName.ObservationSubjectUIDTrial,"ObservationSubjectUIDTrial");
		nameByTag.put(TagFromName.ObservationSubjectClassTrial,"ObservationSubjectClassTrial");
		nameByTag.put(TagFromName.ObservationSubjectTypeCodeSequenceTrial,"ObservationSubjectTypeCodeSequenceTrial");
		nameByTag.put(TagFromName.CompletionFlag,"CompletionFlag");
		nameByTag.put(TagFromName.CompletionFlagDescription,"CompletionFlagDescription");
		nameByTag.put(TagFromName.VerificationFlag,"VerificationFlag");
		nameByTag.put(TagFromName.ArchiveRequested,"ArchiveRequested");
		nameByTag.put(TagFromName.PreliminaryFlag,"PreliminaryFlag");
		nameByTag.put(TagFromName.ContentTemplateSequence,"ContentTemplateSequence");
		nameByTag.put(TagFromName.IdenticalDocumentsSequence,"IdenticalDocumentsSequence");
		nameByTag.put(TagFromName.ObservationSubjectContextFlagTrial,"ObservationSubjectContextFlagTrial");
		nameByTag.put(TagFromName.ObserverContextFlagTrial,"ObserverContextFlagTrial");
		nameByTag.put(TagFromName.ProcedureContextFlagTrial,"ProcedureContextFlagTrial");
		nameByTag.put(TagFromName.ContentSequence,"ContentSequence");
		nameByTag.put(TagFromName.RelationshipSequenceTrial,"RelationshipSequenceTrial");
		nameByTag.put(TagFromName.RelationshipTypeCodeSequenceTrial,"RelationshipTypeCodeSequenceTrial");
		nameByTag.put(TagFromName.LanguageCodeSequenceTrial,"LanguageCodeSequenceTrial");
		nameByTag.put(TagFromName.UniformResourceLocatorTrial,"UniformResourceLocatorTrial");
		nameByTag.put(TagFromName.WaveformAnnotationSequence,"WaveformAnnotationSequence");
		nameByTag.put(TagFromName.TemplateIdentifier,"TemplateIdentifier");
		nameByTag.put(TagFromName.TemplateVersion,"TemplateVersion");
		nameByTag.put(TagFromName.TemplateLocalVersion,"TemplateLocalVersion");
		nameByTag.put(TagFromName.TemplateExtensionFlag,"TemplateExtensionFlag");
		nameByTag.put(TagFromName.TemplateExtensionOrganizationUID,"TemplateExtensionOrganizationUID");
		nameByTag.put(TagFromName.TemplateExtensionCreatorUID,"TemplateExtensionCreatorUID");
		nameByTag.put(TagFromName.RelationshipTypeCodeSequenceModifierTrial,"RelationshipTypeCodeSequenceModifierTrial");
		nameByTag.put(TagFromName.ReferencedContentItemIdentifier,"ReferencedContentItemIdentifier");
		nameByTag.put(TagFromName.HL7InstanceIdentifier,"HL7InstanceIdentifier");
		nameByTag.put(TagFromName.HL7DocumentEffectiveTime,"HL7DocumentEffectiveTime");
		nameByTag.put(TagFromName.HL7DocumentTypeCodeSequence,"HL7DocumentTypeCodeSequence");
		nameByTag.put(TagFromName.RetrieveURI,"RetrieveURI");
		nameByTag.put(TagFromName.RetrieveLocationUID,"RetrieveLocationUID");
		nameByTag.put(TagFromName.DocumentTitle,"DocumentTitle");
		nameByTag.put(TagFromName.EncapsulatedDocument,"EncapsulatedDocument");
		nameByTag.put(TagFromName.MIMETypeOfEncapsulatedDocument,"MIMETypeOfEncapsulatedDocument");
		nameByTag.put(TagFromName.SourceInstanceSequence,"SourceInstanceSequence");
		nameByTag.put(TagFromName.ListOfMIMETypes,"ListOfMIMETypes");
		nameByTag.put(TagFromName.ProductPackageIdentifier,"ProductPackageIdentifier");
		nameByTag.put(TagFromName.SubstanceAdministrationApproval,"SubstanceAdministrationApproval");
		nameByTag.put(TagFromName.ApprovalStatusFurtherDescription,"ApprovalStatusFurtherDescription");
		nameByTag.put(TagFromName.ApprovalStatusDateTime,"ApprovalStatusDateTime");
		nameByTag.put(TagFromName.ProductTypeCodeSequence,"ProductTypeCodeSequence");
		nameByTag.put(TagFromName.ProductName,"ProductName");
		nameByTag.put(TagFromName.ProductDescription,"ProductDescription");
		nameByTag.put(TagFromName.ProductLotIdentifier,"ProductLotIdentifier");
		nameByTag.put(TagFromName.ProductExpirationDateTime,"ProductExpirationDateTime");
		nameByTag.put(TagFromName.SubstanceAdministrationDateTime,"SubstanceAdministrationDateTime");
		nameByTag.put(TagFromName.SubstanceAdministrationNotes,"SubstanceAdministrationNotes");
		nameByTag.put(TagFromName.SubstanceAdministrationDeviceID,"SubstanceAdministrationDeviceID");
		nameByTag.put(TagFromName.ProductParameterSequence,"ProductParameterSequence");
		nameByTag.put(TagFromName.SubstanceAdministrationParameterSequence,"SubstanceAdministrationParameterSequence");
		nameByTag.put(TagFromName.LensDescription,"LensDescription");
		nameByTag.put(TagFromName.RightLensSequence,"RightLensSequence");
		nameByTag.put(TagFromName.LeftLensSequence,"LeftLensSequence");
		nameByTag.put(TagFromName.UnspecifiedLateralityLensSequence,"UnspecifiedLateralityLensSequence");
		nameByTag.put(TagFromName.CylinderSequence,"CylinderSequence");
		nameByTag.put(TagFromName.PrismSequence,"PrismSequence");
		nameByTag.put(TagFromName.HorizontalPrismPower,"HorizontalPrismPower");
		nameByTag.put(TagFromName.HorizontalPrismBase,"HorizontalPrismBase");
		nameByTag.put(TagFromName.VerticalPrismPower,"VerticalPrismPower");
		nameByTag.put(TagFromName.VerticalPrismBase,"VerticalPrismBase");
		nameByTag.put(TagFromName.LensSegmentType,"LensSegmentType");
		nameByTag.put(TagFromName.OpticalTransmittance,"OpticalTransmittance");
		nameByTag.put(TagFromName.ChannelWidth,"ChannelWidth");
		nameByTag.put(TagFromName.PupilSize,"PupilSize");
		nameByTag.put(TagFromName.CornealSize,"CornealSize");
		nameByTag.put(TagFromName.AutorefractionRightEyeSequence,"AutorefractionRightEyeSequence");
		nameByTag.put(TagFromName.AutorefractionLeftEyeSequence,"AutorefractionLeftEyeSequence");
		nameByTag.put(TagFromName.DistancePupillaryDistance,"DistancePupillaryDistance");
		nameByTag.put(TagFromName.NearPupillaryDistance,"NearPupillaryDistance");
		nameByTag.put(TagFromName.IntermediatePupillaryDistance,"IntermediatePupillaryDistance");
		nameByTag.put(TagFromName.OtherPupillaryDistance,"OtherPupillaryDistance");
		nameByTag.put(TagFromName.KeratometryRightEyeSequence,"KeratometryRightEyeSequence");
		nameByTag.put(TagFromName.KeratometryLeftEyeSequence,"KeratometryLeftEyeSequence");
		nameByTag.put(TagFromName.SteepKeratometricAxisSequence,"SteepKeratometricAxisSequence");
		nameByTag.put(TagFromName.RadiusOfCurvature,"RadiusOfCurvature");
		nameByTag.put(TagFromName.KeratometricPower,"KeratometricPower");
		nameByTag.put(TagFromName.KeratometricAxis,"KeratometricAxis");
		nameByTag.put(TagFromName.FlatKeratometricAxisSequence,"FlatKeratometricAxisSequence");
		nameByTag.put(TagFromName.BackgroundColor,"BackgroundColor");
		nameByTag.put(TagFromName.Optotype,"Optotype");
		nameByTag.put(TagFromName.OptotypePresentation,"OptotypePresentation");
		nameByTag.put(TagFromName.SubjectiveRefractionRightEyeSequence,"SubjectiveRefractionRightEyeSequence");
		nameByTag.put(TagFromName.SubjectiveRefractionLeftEyeSequence,"SubjectiveRefractionLeftEyeSequence");
		nameByTag.put(TagFromName.AddNearSequence,"AddNearSequence");
		nameByTag.put(TagFromName.AddIntermediateSequence,"AddIntermediateSequence");
		nameByTag.put(TagFromName.AddOtherSequence,"AddOtherSequence");
		nameByTag.put(TagFromName.AddPower,"AddPower");
		nameByTag.put(TagFromName.ViewingDistance,"ViewingDistance");
		nameByTag.put(TagFromName.VisualAcuityTypeCodeSequence,"VisualAcuityTypeCodeSequence");
		nameByTag.put(TagFromName.VisualAcuityRightEyeSequence,"VisualAcuityRightEyeSequence");
		nameByTag.put(TagFromName.VisualAcuityLeftEyeSequence,"VisualAcuityLeftEyeSequence");
		nameByTag.put(TagFromName.VisualAcuityBothEyesOpenSequence,"VisualAcuityBothEyesOpenSequence");
		nameByTag.put(TagFromName.ViewingDistanceType,"ViewingDistanceType");
		nameByTag.put(TagFromName.VisualAcuityModifiers,"VisualAcuityModifiers");
		nameByTag.put(TagFromName.DecimalVisualAcuity,"DecimalVisualAcuity");
		nameByTag.put(TagFromName.OptotypeDetailedDefinition,"OptotypeDetailedDefinition");
		nameByTag.put(TagFromName.ReferencedRefractiveMeasurementsSequence,"ReferencedRefractiveMeasurementsSequence");
		nameByTag.put(TagFromName.SpherePower,"SpherePower");
		nameByTag.put(TagFromName.CylinderPower,"CylinderPower");
		nameByTag.put(TagFromName.CalibrationImage,"CalibrationImage");
		nameByTag.put(TagFromName.DeviceSequence,"DeviceSequence");
		nameByTag.put(TagFromName.ContainerComponentTypeCodeSequence,"ContainerComponentTypeCodeSequence");
		nameByTag.put(TagFromName.ContainerComponentThickness,"ContainerComponentThickness");
		nameByTag.put(TagFromName.DeviceLength,"DeviceLength");
		nameByTag.put(TagFromName.ContainerComponentWidth,"ContainerComponentWidth");
		nameByTag.put(TagFromName.DeviceDiameter,"DeviceDiameter");
		nameByTag.put(TagFromName.DeviceDiameterUnits,"DeviceDiameterUnits");
		nameByTag.put(TagFromName.DeviceVolume,"DeviceVolume");
		nameByTag.put(TagFromName.InterMarkerDistance,"InterMarkerDistance");
		nameByTag.put(TagFromName.ContainerComponentMaterial,"ContainerComponentMaterial");
		nameByTag.put(TagFromName.ContainerComponentID,"ContainerComponentID");
		nameByTag.put(TagFromName.ContainerComponentLength,"ContainerComponentLength");
		nameByTag.put(TagFromName.ContainerComponentDiameter,"ContainerComponentDiameter");
		nameByTag.put(TagFromName.ContainerComponentDescription,"ContainerComponentDescription");
		nameByTag.put(TagFromName.DeviceDescription,"DeviceDescription");
		nameByTag.put(TagFromName.EnergyWindowVector,"EnergyWindowVector");
		nameByTag.put(TagFromName.NumberOfEnergyWindows,"NumberOfEnergyWindows");
		nameByTag.put(TagFromName.EnergyWindowInformationSequence,"EnergyWindowInformationSequence");
		nameByTag.put(TagFromName.EnergyWindowRangeSequence,"EnergyWindowRangeSequence");
		nameByTag.put(TagFromName.EnergyWindowLowerLimit,"EnergyWindowLowerLimit");
		nameByTag.put(TagFromName.EnergyWindowUpperLimit,"EnergyWindowUpperLimit");
		nameByTag.put(TagFromName.RadiopharmaceuticalInformationSequence,"RadiopharmaceuticalInformationSequence");
		nameByTag.put(TagFromName.ResidualSyringeCounts,"ResidualSyringeCounts");
		nameByTag.put(TagFromName.EnergyWindowName,"EnergyWindowName");
		nameByTag.put(TagFromName.DetectorVector,"DetectorVector");
		nameByTag.put(TagFromName.NumberOfDetectors,"NumberOfDetectors");
		nameByTag.put(TagFromName.DetectorInformationSequence,"DetectorInformationSequence");
		nameByTag.put(TagFromName.PhaseVector,"PhaseVector");
		nameByTag.put(TagFromName.NumberOfPhases,"NumberOfPhases");
		nameByTag.put(TagFromName.PhaseInformationSequence,"PhaseInformationSequence");
		nameByTag.put(TagFromName.NumberOfFramesInPhase,"NumberOfFramesInPhase");
		nameByTag.put(TagFromName.PhaseDelay,"PhaseDelay");
		nameByTag.put(TagFromName.PauseBetweenFrames,"PauseBetweenFrames");
		nameByTag.put(TagFromName.PhaseDescription,"PhaseDescription");
		nameByTag.put(TagFromName.RotationVector,"RotationVector");
		nameByTag.put(TagFromName.NumberOfRotations,"NumberOfRotations");
		nameByTag.put(TagFromName.RotationInformationSequence,"RotationInformationSequence");
		nameByTag.put(TagFromName.NumberOfFramesInRotation,"NumberOfFramesInRotation");
		nameByTag.put(TagFromName.RRIntervalVector,"RRIntervalVector");
		nameByTag.put(TagFromName.NumberOfRRIntervals,"NumberOfRRIntervals");
		nameByTag.put(TagFromName.GatedInformationSequence,"GatedInformationSequence");
		nameByTag.put(TagFromName.DataInformationSequence,"DataInformationSequence");
		nameByTag.put(TagFromName.TimeSlotVector,"TimeSlotVector");
		nameByTag.put(TagFromName.NumberOfTimeSlots,"NumberOfTimeSlots");
		nameByTag.put(TagFromName.TimeSlotInformationSequence,"TimeSlotInformationSequence");
		nameByTag.put(TagFromName.TimeSlotTime,"TimeSlotTime");
		nameByTag.put(TagFromName.SliceVector,"SliceVector");
		nameByTag.put(TagFromName.NumberOfSlices,"NumberOfSlices");
		nameByTag.put(TagFromName.AngularViewVector,"AngularViewVector");
		nameByTag.put(TagFromName.TimeSliceVector,"TimeSliceVector");
		nameByTag.put(TagFromName.NumberOfTimeSlices,"NumberOfTimeSlices");
		nameByTag.put(TagFromName.StartAngle,"StartAngle");
		nameByTag.put(TagFromName.TypeOfDetectorMotion,"TypeOfDetectorMotion");
		nameByTag.put(TagFromName.TriggerVector,"TriggerVector");
		nameByTag.put(TagFromName.NumberOfTriggersInPhase,"NumberOfTriggersInPhase");
		nameByTag.put(TagFromName.ViewCodeSequence,"ViewCodeSequence");
		nameByTag.put(TagFromName.ViewModifierCodeSequence,"ViewModifierCodeSequence");
		nameByTag.put(TagFromName.RadionuclideCodeSequence,"RadionuclideCodeSequence");
		nameByTag.put(TagFromName.AdministrationRouteCodeSequence,"AdministrationRouteCodeSequence");
		nameByTag.put(TagFromName.RadiopharmaceuticalCodeSequence,"RadiopharmaceuticalCodeSequence");
		nameByTag.put(TagFromName.CalibrationDataSequence,"CalibrationDataSequence");
		nameByTag.put(TagFromName.EnergyWindowNumber,"EnergyWindowNumber");
		nameByTag.put(TagFromName.ImageID,"ImageID");
		nameByTag.put(TagFromName.PatientOrientationCodeSequence,"PatientOrientationCodeSequence");
		nameByTag.put(TagFromName.PatientOrientationModifierCodeSequence,"PatientOrientationModifierCodeSequence");
		nameByTag.put(TagFromName.PatientGantryRelationshipCodeSequence,"PatientGantryRelationshipCodeSequence");
		nameByTag.put(TagFromName.SliceProgressionDirection,"SliceProgressionDirection");
		nameByTag.put(TagFromName.SeriesType,"SeriesType");
		nameByTag.put(TagFromName.Units,"Units");
		nameByTag.put(TagFromName.CountsSource,"CountsSource");
		nameByTag.put(TagFromName.ReprojectionMethod,"ReprojectionMethod");
		nameByTag.put(TagFromName.RandomsCorrectionMethod,"RandomsCorrectionMethod");
		nameByTag.put(TagFromName.AttenuationCorrectionMethod,"AttenuationCorrectionMethod");
		nameByTag.put(TagFromName.DecayCorrection,"DecayCorrection");
		nameByTag.put(TagFromName.ReconstructionMethod,"ReconstructionMethod");
		nameByTag.put(TagFromName.DetectorLinesOfResponseUsed,"DetectorLinesOfResponseUsed");
		nameByTag.put(TagFromName.ScatterCorrectionMethod,"ScatterCorrectionMethod");
		nameByTag.put(TagFromName.AxialAcceptance,"AxialAcceptance");
		nameByTag.put(TagFromName.AxialMash,"AxialMash");
		nameByTag.put(TagFromName.TransverseMash,"TransverseMash");
		nameByTag.put(TagFromName.DetectorElementSize,"DetectorElementSize");
		nameByTag.put(TagFromName.CoincidenceWindowWidth,"CoincidenceWindowWidth");
		nameByTag.put(TagFromName.SecondaryCountsType,"SecondaryCountsType");
		nameByTag.put(TagFromName.FrameReferenceTime,"FrameReferenceTime");
		nameByTag.put(TagFromName.PrimaryPromptsCountsAccumulated,"PrimaryPromptsCountsAccumulated");
		nameByTag.put(TagFromName.SecondaryCountsAccumulated,"SecondaryCountsAccumulated");
		nameByTag.put(TagFromName.SliceSensitivityFactor,"SliceSensitivityFactor");
		nameByTag.put(TagFromName.DecayFactor,"DecayFactor");
		nameByTag.put(TagFromName.DoseCalibrationFactor,"DoseCalibrationFactor");
		nameByTag.put(TagFromName.ScatterFractionFactor,"ScatterFractionFactor");
		nameByTag.put(TagFromName.DeadTimeFactor,"DeadTimeFactor");
		nameByTag.put(TagFromName.ImageIndex,"ImageIndex");
		nameByTag.put(TagFromName.CountsIncluded,"CountsIncluded");
		nameByTag.put(TagFromName.DeadTimeCorrectionFlag,"DeadTimeCorrectionFlag");
		nameByTag.put(TagFromName.HistogramSequence,"HistogramSequence");
		nameByTag.put(TagFromName.HistogramNumberOfBins,"HistogramNumberOfBins");
		nameByTag.put(TagFromName.HistogramFirstBinValue,"HistogramFirstBinValue");
		nameByTag.put(TagFromName.HistogramLastBinValue,"HistogramLastBinValue");
		nameByTag.put(TagFromName.HistogramBinWidth,"HistogramBinWidth");
		nameByTag.put(TagFromName.HistogramExplanation,"HistogramExplanation");
		nameByTag.put(TagFromName.HistogramData,"HistogramData");
		nameByTag.put(TagFromName.SegmentationType,"SegmentationType");
		nameByTag.put(TagFromName.SegmentSequence,"SegmentSequence");
		nameByTag.put(TagFromName.SegmentedPropertyCategoryCodeSequence,"SegmentedPropertyCategoryCodeSequence");
		nameByTag.put(TagFromName.SegmentNumber,"SegmentNumber");
		nameByTag.put(TagFromName.SegmentLabel,"SegmentLabel");
		nameByTag.put(TagFromName.SegmentDescription,"SegmentDescription");
		nameByTag.put(TagFromName.SegmentAlgorithmType,"SegmentAlgorithmType");
		nameByTag.put(TagFromName.SegmentAlgorithmName,"SegmentAlgorithmName");
		nameByTag.put(TagFromName.SegmentIdentificationSequence,"SegmentIdentificationSequence");
		nameByTag.put(TagFromName.ReferencedSegmentNumber,"ReferencedSegmentNumber");
		nameByTag.put(TagFromName.RecommendedDisplayGrayscaleValue,"RecommendedDisplayGrayscaleValue");
		nameByTag.put(TagFromName.RecommendedDisplayCIELabValue,"RecommendedDisplayCIELabValue");
		nameByTag.put(TagFromName.MaximumFractionalValue,"MaximumFractionalValue");
		nameByTag.put(TagFromName.SegmentedPropertyTypeCodeSequence,"SegmentedPropertyTypeCodeSequence");
		nameByTag.put(TagFromName.SegmentationFractionalType,"SegmentationFractionalType");
		nameByTag.put(TagFromName.DeformableRegistrationSequence,"DeformableRegistrationSequence");
		nameByTag.put(TagFromName.SourceFrameOfReferenceUID,"SourceFrameOfReferenceUID");
		nameByTag.put(TagFromName.DeformableRegistrationGridSequence,"DeformableRegistrationGridSequence");
		nameByTag.put(TagFromName.GridDimensions,"GridDimensions");
		nameByTag.put(TagFromName.GridResolution,"GridResolution");
		nameByTag.put(TagFromName.VectorGridData,"VectorGridData");
		nameByTag.put(TagFromName.PreDeformationMatrixRegistrationSequence,"PreDeformationMatrixRegistrationSequence");
		nameByTag.put(TagFromName.PostDeformationMatrixRegistrationSequence,"PostDeformationMatrixRegistrationSequence");
		nameByTag.put(TagFromName.NumberOfSurfaces,"NumberOfSurfaces");
		nameByTag.put(TagFromName.SurfaceSequence,"SurfaceSequence");
		nameByTag.put(TagFromName.SurfaceNumber,"SurfaceNumber");
		nameByTag.put(TagFromName.SurfaceComments,"SurfaceComments");
		nameByTag.put(TagFromName.SurfaceProcessing,"SurfaceProcessing");
		nameByTag.put(TagFromName.SurfaceProcessingRatio,"SurfaceProcessingRatio");
		nameByTag.put(TagFromName.SurfaceProcessingDescription,"SurfaceProcessingDescription");
		nameByTag.put(TagFromName.RecommendedPresentationOpacity,"RecommendedPresentationOpacity");
		nameByTag.put(TagFromName.RecommendedPresentationType,"RecommendedPresentationType");
		nameByTag.put(TagFromName.FiniteVolume,"FiniteVolume");
		nameByTag.put(TagFromName.Manifold,"Manifold");
		nameByTag.put(TagFromName.SurfacePointsSequence,"SurfacePointsSequence");
		nameByTag.put(TagFromName.SurfacePointsNormalsSequence,"SurfacePointsNormalsSequence");
		nameByTag.put(TagFromName.SurfaceMeshPrimitivesSequence,"SurfaceMeshPrimitivesSequence");
		nameByTag.put(TagFromName.SurfaceNumberOfPoints,"SurfaceNumberOfPoints");
		nameByTag.put(TagFromName.PointCoordinatesData,"PointCoordinatesData");
		nameByTag.put(TagFromName.PointPositionAccuracy,"PointPositionAccuracy");
		nameByTag.put(TagFromName.MeanPointDistance,"MeanPointDistance");
		nameByTag.put(TagFromName.MaximumPointDistance,"MaximumPointDistance");
		nameByTag.put(TagFromName.PointsBoundingBoxCoordinates,"PointsBoundingBoxCoordinates");
		nameByTag.put(TagFromName.AxisOfRotation,"AxisOfRotation");
		nameByTag.put(TagFromName.CenterOfRotation,"CenterOfRotation");
		nameByTag.put(TagFromName.NumberOfVectors,"NumberOfVectors");
		nameByTag.put(TagFromName.VectorDimensionality,"VectorDimensionality");
		nameByTag.put(TagFromName.VectorAccuracy,"VectorAccuracy");
		nameByTag.put(TagFromName.VectorCoordinateData,"VectorCoordinateData");
		nameByTag.put(TagFromName.TrianglePointIndexList,"TrianglePointIndexList");
		nameByTag.put(TagFromName.EdgePointIndexList,"EdgePointIndexList");
		nameByTag.put(TagFromName.VertexPointIndexList,"VertexPointIndexList");
		nameByTag.put(TagFromName.TriangleStripSequence,"TriangleStripSequence");
		nameByTag.put(TagFromName.TriangleFanSequence,"TriangleFanSequence");
		nameByTag.put(TagFromName.LineSequence,"LineSequence");
		nameByTag.put(TagFromName.PrimitivePointIndexList,"PrimitivePointIndexList");
		nameByTag.put(TagFromName.SurfaceCount,"SurfaceCount");
		nameByTag.put(TagFromName.ReferencedSurfaceSequence,"ReferencedSurfaceSequence");
		nameByTag.put(TagFromName.ReferencedSurfaceNumber,"ReferencedSurfaceNumber");
		nameByTag.put(TagFromName.SegmentSurfaceGenerationAlgorithmIdentificationSequence,"SegmentSurfaceGenerationAlgorithmIdentificationSequence");
		nameByTag.put(TagFromName.SegmentSurfaceSourceInstanceSequence,"SegmentSurfaceSourceInstanceSequence");
		nameByTag.put(TagFromName.AlgorithmFamilyCodeSequence,"AlgorithmFamilyCodeSequence");
		nameByTag.put(TagFromName.AlgorithmNameCodeSequence,"AlgorithmNameCodeSequence");
		nameByTag.put(TagFromName.AlgorithmVersion,"AlgorithmVersion");
		nameByTag.put(TagFromName.AlgorithmParameters,"AlgorithmParameters");
		nameByTag.put(TagFromName.FacetSequence,"FacetSequence");
		nameByTag.put(TagFromName.SurfaceProcessingAlgorithmIdentificationSequence,"SurfaceProcessingAlgorithmIdentificationSequence");
		nameByTag.put(TagFromName.AlgorithmName,"AlgorithmName");
		nameByTag.put(TagFromName.GraphicAnnotationSequence,"GraphicAnnotationSequence");
		nameByTag.put(TagFromName.GraphicLayer,"GraphicLayer");
		nameByTag.put(TagFromName.BoundingBoxAnnotationUnits,"BoundingBoxAnnotationUnits");
		nameByTag.put(TagFromName.AnchorPointAnnotationUnits,"AnchorPointAnnotationUnits");
		nameByTag.put(TagFromName.GraphicAnnotationUnits,"GraphicAnnotationUnits");
		nameByTag.put(TagFromName.UnformattedTextValue,"UnformattedTextValue");
		nameByTag.put(TagFromName.TextObjectSequence,"TextObjectSequence");
		nameByTag.put(TagFromName.GraphicObjectSequence,"GraphicObjectSequence");
		nameByTag.put(TagFromName.BoundingBoxTopLeftHandCorner,"BoundingBoxTopLeftHandCorner");
		nameByTag.put(TagFromName.BoundingBoxBottomRightHandCorner,"BoundingBoxBottomRightHandCorner");
		nameByTag.put(TagFromName.BoundingBoxTextHorizontalJustification,"BoundingBoxTextHorizontalJustification");
		nameByTag.put(TagFromName.AnchorPoint,"AnchorPoint");
		nameByTag.put(TagFromName.AnchorPointVisibility,"AnchorPointVisibility");
		nameByTag.put(TagFromName.GraphicDimensions,"GraphicDimensions");
		nameByTag.put(TagFromName.NumberOfGraphicPoints,"NumberOfGraphicPoints");
		nameByTag.put(TagFromName.GraphicData,"GraphicData");
		nameByTag.put(TagFromName.GraphicType,"GraphicType");
		nameByTag.put(TagFromName.GraphicFilled,"GraphicFilled");
		nameByTag.put(TagFromName.ImageRotationTrial,"ImageRotationTrial");
		nameByTag.put(TagFromName.ImageHorizontalFlip,"ImageHorizontalFlip");
		nameByTag.put(TagFromName.ImageRotation,"ImageRotation");
		nameByTag.put(TagFromName.DisplayedAreaTopLeftHandCornerTrial,"DisplayedAreaTopLeftHandCornerTrial");
		nameByTag.put(TagFromName.DisplayedAreaBottomRightHandCornerTrial,"DisplayedAreaBottomRightHandCornerTrial");
		nameByTag.put(TagFromName.DisplayedAreaTopLeftHandCorner,"DisplayedAreaTopLeftHandCorner");
		nameByTag.put(TagFromName.DisplayedAreaBottomRightHandCorner,"DisplayedAreaBottomRightHandCorner");
		nameByTag.put(TagFromName.DisplayedAreaSelectionSequence,"DisplayedAreaSelectionSequence");
		nameByTag.put(TagFromName.GraphicLayerSequence,"GraphicLayerSequence");
		nameByTag.put(TagFromName.GraphicLayerOrder,"GraphicLayerOrder");
		nameByTag.put(TagFromName.GraphicLayerRecommendedDisplayGrayscaleValue,"GraphicLayerRecommendedDisplayGrayscaleValue");
		nameByTag.put(TagFromName.GraphicLayerRecommendedDisplayRGBValue,"GraphicLayerRecommendedDisplayRGBValue");
		nameByTag.put(TagFromName.GraphicLayerDescription,"GraphicLayerDescription");
		nameByTag.put(TagFromName.ContentLabel,"ContentLabel");
		nameByTag.put(TagFromName.ContentDescription,"ContentDescription");
		nameByTag.put(TagFromName.PresentationCreationDate,"PresentationCreationDate");
		nameByTag.put(TagFromName.PresentationCreationTime,"PresentationCreationTime");
		nameByTag.put(TagFromName.ContentCreatorsName,"ContentCreatorsName");
		nameByTag.put(TagFromName.ContentCreatorsIdentificationCodeSequence,"ContentCreatorsIdentificationCodeSequence");
		nameByTag.put(TagFromName.AlternateContentDescriptionSequence,"AlternateContentDescriptionSequence");
		nameByTag.put(TagFromName.PresentationSizeMode,"PresentationSizeMode");
		nameByTag.put(TagFromName.PresentationPixelSpacing,"PresentationPixelSpacing");
		nameByTag.put(TagFromName.PresentationPixelAspectRatio,"PresentationPixelAspectRatio");
		nameByTag.put(TagFromName.PresentationPixelMagnificationRatio,"PresentationPixelMagnificationRatio");
		nameByTag.put(TagFromName.ShapeType,"ShapeType");
		nameByTag.put(TagFromName.RegistrationSequence,"RegistrationSequence");
		nameByTag.put(TagFromName.MatrixRegistrationSequence,"MatrixRegistrationSequence");
		nameByTag.put(TagFromName.MatrixSequence,"MatrixSequence");
		nameByTag.put(TagFromName.FrameOfReferenceTransformationMatrixType,"FrameOfReferenceTransformationMatrixType");
		nameByTag.put(TagFromName.RegistrationTypeCodeSequence,"RegistrationTypeCodeSequence");
		nameByTag.put(TagFromName.FiducialDescription,"FiducialDescription");
		nameByTag.put(TagFromName.FiducialIdentifier,"FiducialIdentifier");
		nameByTag.put(TagFromName.FiducialIdentifierCodeSequence,"FiducialIdentifierCodeSequence");
		nameByTag.put(TagFromName.ContourUncertaintyRadius,"ContourUncertaintyRadius");
		nameByTag.put(TagFromName.UsedFiducialsSequence,"UsedFiducialsSequence");
		nameByTag.put(TagFromName.GraphicCoordinatesDataSequence,"GraphicCoordinatesDataSequence");
		nameByTag.put(TagFromName.FiducialUID,"FiducialUID");
		nameByTag.put(TagFromName.FiducialSetSequence,"FiducialSetSequence");
		nameByTag.put(TagFromName.FiducialSequence,"FiducialSequence");
		nameByTag.put(TagFromName.GraphicLayerRecommendedDisplayCIELabValue,"GraphicLayerRecommendedDisplayCIELabValue");
		nameByTag.put(TagFromName.BlendingSequence,"BlendingSequence");
		nameByTag.put(TagFromName.RelativeOpacity,"RelativeOpacity");
		nameByTag.put(TagFromName.ReferencedSpatialRegistrationSequence,"ReferencedSpatialRegistrationSequence");
		nameByTag.put(TagFromName.BlendingPosition,"BlendingPosition");
		nameByTag.put(TagFromName.HangingProtocolName,"HangingProtocolName");
		nameByTag.put(TagFromName.HangingProtocolDescription,"HangingProtocolDescription");
		nameByTag.put(TagFromName.HangingProtocolLevel,"HangingProtocolLevel");
		nameByTag.put(TagFromName.HangingProtocolCreator,"HangingProtocolCreator");
		nameByTag.put(TagFromName.HangingProtocolCreationDateTime,"HangingProtocolCreationDateTime");
		nameByTag.put(TagFromName.HangingProtocolDefinitionSequence,"HangingProtocolDefinitionSequence");
		nameByTag.put(TagFromName.HangingProtocolUserIdentificationCodeSequence,"HangingProtocolUserIdentificationCodeSequence");
		nameByTag.put(TagFromName.HangingProtocolUserGroupName,"HangingProtocolUserGroupName");
		nameByTag.put(TagFromName.SourceHangingProtocolSequence,"SourceHangingProtocolSequence");
		nameByTag.put(TagFromName.NumberOfPriorsReferenced,"NumberOfPriorsReferenced");
		nameByTag.put(TagFromName.ImageSetsSequence,"ImageSetsSequence");
		nameByTag.put(TagFromName.ImageSetSelectorSequence,"ImageSetSelectorSequence");
		nameByTag.put(TagFromName.ImageSetSelectorUsageFlag,"ImageSetSelectorUsageFlag");
		nameByTag.put(TagFromName.SelectorAttribute,"SelectorAttribute");
		nameByTag.put(TagFromName.SelectorValueNumber,"SelectorValueNumber");
		nameByTag.put(TagFromName.TimeBasedImageSetsSequence,"TimeBasedImageSetsSequence");
		nameByTag.put(TagFromName.ImageSetNumber,"ImageSetNumber");
		nameByTag.put(TagFromName.ImageSetSelectorCategory,"ImageSetSelectorCategory");
		nameByTag.put(TagFromName.RelativeTime,"RelativeTime");
		nameByTag.put(TagFromName.RelativeTimeUnits,"RelativeTimeUnits");
		nameByTag.put(TagFromName.AbstractPriorValue,"AbstractPriorValue");
		nameByTag.put(TagFromName.AbstractPriorCodeSequence,"AbstractPriorCodeSequence");
		nameByTag.put(TagFromName.ImageSetLabel,"ImageSetLabel");
		nameByTag.put(TagFromName.SelectorAttributeVR,"SelectorAttributeVR");
		nameByTag.put(TagFromName.SelectorSequencePointer,"SelectorSequencePointer");
		nameByTag.put(TagFromName.SelectorSequencePointerPrivateCreator,"SelectorSequencePointerPrivateCreator");
		nameByTag.put(TagFromName.SelectorAttributePrivateCreator,"SelectorAttributePrivateCreator");
		nameByTag.put(TagFromName.SelectorATValue,"SelectorATValue");
		nameByTag.put(TagFromName.SelectorCSValue,"SelectorCSValue");
		nameByTag.put(TagFromName.SelectorISValue,"SelectorISValue");
		nameByTag.put(TagFromName.SelectorLOValue,"SelectorLOValue");
		nameByTag.put(TagFromName.SelectorLTValue,"SelectorLTValue");
		nameByTag.put(TagFromName.SelectorPNValue,"SelectorPNValue");
		nameByTag.put(TagFromName.SelectorSHValue,"SelectorSHValue");
		nameByTag.put(TagFromName.SelectorSTValue,"SelectorSTValue");
		nameByTag.put(TagFromName.SelectorUTValue,"SelectorUTValue");
		nameByTag.put(TagFromName.SelectorDSValue,"SelectorDSValue");
		nameByTag.put(TagFromName.SelectorFDValue,"SelectorFDValue");
		nameByTag.put(TagFromName.SelectorFLValue,"SelectorFLValue");
		nameByTag.put(TagFromName.SelectorULValue,"SelectorULValue");
		nameByTag.put(TagFromName.SelectorUSValue,"SelectorUSValue");
		nameByTag.put(TagFromName.SelectorSLValue,"SelectorSLValue");
		nameByTag.put(TagFromName.SelectorSSValue,"SelectorSSValue");
		nameByTag.put(TagFromName.SelectorCodeSequenceValue,"SelectorCodeSequenceValue");
		nameByTag.put(TagFromName.NumberOfScreens,"NumberOfScreens");
		nameByTag.put(TagFromName.NominalScreenDefinitionSequence,"NominalScreenDefinitionSequence");
		nameByTag.put(TagFromName.NumberOfVerticalPixels,"NumberOfVerticalPixels");
		nameByTag.put(TagFromName.NumberOfHorizontalPixels,"NumberOfHorizontalPixels");
		nameByTag.put(TagFromName.DisplayEnvironmentSpatialPosition,"DisplayEnvironmentSpatialPosition");
		nameByTag.put(TagFromName.ScreenMinimumGrayscaleBitDepth,"ScreenMinimumGrayscaleBitDepth");
		nameByTag.put(TagFromName.ScreenMinimumColorBitDepth,"ScreenMinimumColorBitDepth");
		nameByTag.put(TagFromName.ApplicationMaximumRepaintTime,"ApplicationMaximumRepaintTime");
		nameByTag.put(TagFromName.DisplaySetsSequence,"DisplaySetsSequence");
		nameByTag.put(TagFromName.DisplaySetNumber,"DisplaySetNumber");
		nameByTag.put(TagFromName.DisplaySetLabel,"DisplaySetLabel");
		nameByTag.put(TagFromName.DisplaySetPresentationGroup,"DisplaySetPresentationGroup");
		nameByTag.put(TagFromName.DisplaySetPresentationGroupDescription,"DisplaySetPresentationGroupDescription");
		nameByTag.put(TagFromName.PartialDataDisplayHandling,"PartialDataDisplayHandling");
		nameByTag.put(TagFromName.SynchronizedScrollingSequence,"SynchronizedScrollingSequence");
		nameByTag.put(TagFromName.DisplaySetScrollingGroup,"DisplaySetScrollingGroup");
		nameByTag.put(TagFromName.NavigationIndicatorSequence,"NavigationIndicatorSequence");
		nameByTag.put(TagFromName.NavigationDisplaySet,"NavigationDisplaySet");
		nameByTag.put(TagFromName.ReferenceDisplaySets,"ReferenceDisplaySets");
		nameByTag.put(TagFromName.ImageBoxesSequence,"ImageBoxesSequence");
		nameByTag.put(TagFromName.ImageBoxNumber,"ImageBoxNumber");
		nameByTag.put(TagFromName.ImageBoxLayoutType,"ImageBoxLayoutType");
		nameByTag.put(TagFromName.ImageBoxTileHorizontalDimension,"ImageBoxTileHorizontalDimension");
		nameByTag.put(TagFromName.ImageBoxTileVerticalDimension,"ImageBoxTileVerticalDimension");
		nameByTag.put(TagFromName.ImageBoxScrollDirection,"ImageBoxScrollDirection");
		nameByTag.put(TagFromName.ImageBoxSmallScrollType,"ImageBoxSmallScrollType");
		nameByTag.put(TagFromName.ImageBoxSmallScrollAmount,"ImageBoxSmallScrollAmount");
		nameByTag.put(TagFromName.ImageBoxLargeScrollType,"ImageBoxLargeScrollType");
		nameByTag.put(TagFromName.ImageBoxLargeScrollAmount,"ImageBoxLargeScrollAmount");
		nameByTag.put(TagFromName.ImageBoxOverlapPriority,"ImageBoxOverlapPriority");
		nameByTag.put(TagFromName.CineRelativeToRealTime,"CineRelativeToRealTime");
		nameByTag.put(TagFromName.FilterOperationsSequence,"FilterOperationsSequence");
		nameByTag.put(TagFromName.FilterByCategory,"FilterByCategory");
		nameByTag.put(TagFromName.FilterByAttributePresence,"FilterByAttributePresence");
		nameByTag.put(TagFromName.FilterByOperator,"FilterByOperator");
		nameByTag.put(TagFromName.StructuredDisplayBackgroundCIELabValue,"StructuredDisplayBackgroundCIELabValue");
		nameByTag.put(TagFromName.EmptyImageBoxCIELabValue,"EmptyImageBoxCIELabValue");
		nameByTag.put(TagFromName.StructuredDisplayImageBoxSequence,"StructuredDisplayImageBoxSequence");
		nameByTag.put(TagFromName.StructuredDisplayTextBoxSequence,"StructuredDisplayTextBoxSequence");
		nameByTag.put(TagFromName.ReferencedFirstFrameSequence,"ReferencedFirstFrameSequence");
		nameByTag.put(TagFromName.ImageBoxSynchronizationSequence,"ImageBoxSynchronizationSequence");
		nameByTag.put(TagFromName.SynchronizedImageBoxList,"SynchronizedImageBoxList");
		nameByTag.put(TagFromName.TypeOfSynchronization,"TypeOfSynchronization");
		nameByTag.put(TagFromName.BlendingOperationType,"BlendingOperationType");
		nameByTag.put(TagFromName.ReformattingOperationType,"ReformattingOperationType");
		nameByTag.put(TagFromName.ReformattingThickness,"ReformattingThickness");
		nameByTag.put(TagFromName.ReformattingInterval,"ReformattingInterval");
		nameByTag.put(TagFromName.ReformattingOperationInitialViewDirection,"ReformattingOperationInitialViewDirection");
		nameByTag.put(TagFromName.ThreeDRenderingType,"ThreeDRenderingType");
		nameByTag.put(TagFromName.SortingOperationsSequence,"SortingOperationsSequence");
		nameByTag.put(TagFromName.SortByCategory,"SortByCategory");
		nameByTag.put(TagFromName.SortingDirection,"SortingDirection");
		nameByTag.put(TagFromName.DisplaySetPatientOrientation,"DisplaySetPatientOrientation");
		nameByTag.put(TagFromName.VOIType,"VOIType");
		nameByTag.put(TagFromName.PseudocolorType,"PseudocolorType");
		nameByTag.put(TagFromName.ShowGrayscaleInverted,"ShowGrayscaleInverted");
		nameByTag.put(TagFromName.ShowImageTrueSizeFlag,"ShowImageTrueSizeFlag");
		nameByTag.put(TagFromName.ShowGraphicAnnotationFlag,"ShowGraphicAnnotationFlag");
		nameByTag.put(TagFromName.ShowPatientDemographicsFlag,"ShowPatientDemographicsFlag");
		nameByTag.put(TagFromName.ShowAcquisitionTechniquesFlag,"ShowAcquisitionTechniquesFlag");
		nameByTag.put(TagFromName.DisplaySetHorizontalJustification,"DisplaySetHorizontalJustification");
		nameByTag.put(TagFromName.DisplaySetVerticalJustification,"DisplaySetVerticalJustification");
		nameByTag.put(TagFromName.StorageMediaFileSetID,"StorageMediaFileSetID");
		nameByTag.put(TagFromName.StorageMediaFileSetUID,"StorageMediaFileSetUID");
		nameByTag.put(TagFromName.IconImageSequence,"IconImageSequence");
		nameByTag.put(TagFromName.TopicTitle,"TopicTitle");
		nameByTag.put(TagFromName.TopicSubject,"TopicSubject");
		nameByTag.put(TagFromName.TopicAuthor,"TopicAuthor");
		nameByTag.put(TagFromName.TopicKeyWords,"TopicKeyWords");
		nameByTag.put(TagFromName.SOPInstanceStatus,"SOPInstanceStatus");
		nameByTag.put(TagFromName.SOPAuthorizationDateAndTime,"SOPAuthorizationDateAndTime");
		nameByTag.put(TagFromName.SOPAuthorizationComment,"SOPAuthorizationComment");
		nameByTag.put(TagFromName.AuthorizationEquipmentCertificationNumber,"AuthorizationEquipmentCertificationNumber");
		nameByTag.put(TagFromName.MACIDNumber,"MACIDNumber");
		nameByTag.put(TagFromName.MACCalculationTransferSyntaxUID,"MACCalculationTransferSyntaxUID");
		nameByTag.put(TagFromName.MACAlgorithm,"MACAlgorithm");
		nameByTag.put(TagFromName.DataElementsSigned,"DataElementsSigned");
		nameByTag.put(TagFromName.DigitalSignatureUID,"DigitalSignatureUID");
		nameByTag.put(TagFromName.DigitalSignatureDateTime,"DigitalSignatureDateTime");
		nameByTag.put(TagFromName.CertificateType,"CertificateType");
		nameByTag.put(TagFromName.CertificateOfSigner,"CertificateOfSigner");
		nameByTag.put(TagFromName.Signature,"Signature");
		nameByTag.put(TagFromName.CertifiedTimestampType,"CertifiedTimestampType");
		nameByTag.put(TagFromName.CertifiedTimestamp,"CertifiedTimestamp");
		nameByTag.put(TagFromName.DigitalSignaturePurposeCodeSequence,"DigitalSignaturePurposeCodeSequence");
		nameByTag.put(TagFromName.ReferencedDigitalSignatureSequence,"ReferencedDigitalSignatureSequence");
		nameByTag.put(TagFromName.ReferencedSOPInstanceMACSequence,"ReferencedSOPInstanceMACSequence");
		nameByTag.put(TagFromName.MAC,"MAC");
		nameByTag.put(TagFromName.EncryptedAttributesSequence,"EncryptedAttributesSequence");
		nameByTag.put(TagFromName.EncryptedContentTransferSyntaxUID,"EncryptedContentTransferSyntaxUID");
		nameByTag.put(TagFromName.EncryptedContent,"EncryptedContent");
		nameByTag.put(TagFromName.ModifiedAttributesSequence,"ModifiedAttributesSequence");
		nameByTag.put(TagFromName.OriginalAttributesSequence,"OriginalAttributesSequence");
		nameByTag.put(TagFromName.AttributeModificationDateTime,"AttributeModificationDateTime");
		nameByTag.put(TagFromName.ModifyingSystem,"ModifyingSystem");
		nameByTag.put(TagFromName.SourceOfPreviousValues,"SourceOfPreviousValues");
		nameByTag.put(TagFromName.ReasonForTheAttributeModification,"ReasonForTheAttributeModification");
		nameByTag.put(TagFromName.ZonalMap,"ZonalMap");
		nameByTag.put(TagFromName.NumberOfCopies,"NumberOfCopies");
		nameByTag.put(TagFromName.PrinterConfigurationSequence,"PrinterConfigurationSequence");
		nameByTag.put(TagFromName.PrintPriority,"PrintPriority");
		nameByTag.put(TagFromName.MediumType,"MediumType");
		nameByTag.put(TagFromName.FilmDestination,"FilmDestination");
		nameByTag.put(TagFromName.FilmSessionLabel,"FilmSessionLabel");
		nameByTag.put(TagFromName.MemoryAllocation,"MemoryAllocation");
		nameByTag.put(TagFromName.MaximumMemoryAllocation,"MaximumMemoryAllocation");
		nameByTag.put(TagFromName.ColorImagePrintingFlag,"ColorImagePrintingFlag");
		nameByTag.put(TagFromName.CollationFlag,"CollationFlag");
		nameByTag.put(TagFromName.AnnotationFlag,"AnnotationFlag");
		nameByTag.put(TagFromName.ImageOverlayFlag,"ImageOverlayFlag");
		nameByTag.put(TagFromName.PresentationLUTFlag,"PresentationLUTFlag");
		nameByTag.put(TagFromName.ImageBoxPresentationLUTFlag,"ImageBoxPresentationLUTFlag");
		nameByTag.put(TagFromName.MemoryBitDepth,"MemoryBitDepth");
		nameByTag.put(TagFromName.PrintingBitDepth,"PrintingBitDepth");
		nameByTag.put(TagFromName.MediaInstalledSequence,"MediaInstalledSequence");
		nameByTag.put(TagFromName.OtherMediaAvailableSequence,"OtherMediaAvailableSequence");
		nameByTag.put(TagFromName.SupportedImageDisplayFormatsSequence,"SupportedImageDisplayFormatsSequence");
		nameByTag.put(TagFromName.ReferencedFilmBoxSequence,"ReferencedFilmBoxSequence");
		nameByTag.put(TagFromName.ReferencedStoredPrintSequence,"ReferencedStoredPrintSequence");
		nameByTag.put(TagFromName.ImageDisplayFormat,"ImageDisplayFormat");
		nameByTag.put(TagFromName.AnnotationDisplayFormatID,"AnnotationDisplayFormatID");
		nameByTag.put(TagFromName.FilmOrientation,"FilmOrientation");
		nameByTag.put(TagFromName.FilmSizeID,"FilmSizeID");
		nameByTag.put(TagFromName.PrinterResolutionID,"PrinterResolutionID");
		nameByTag.put(TagFromName.DefaultPrinterResolutionID,"DefaultPrinterResolutionID");
		nameByTag.put(TagFromName.MagnificationType,"MagnificationType");
		nameByTag.put(TagFromName.SmoothingType,"SmoothingType");
		nameByTag.put(TagFromName.DefaultMagnificationType,"DefaultMagnificationType");
		nameByTag.put(TagFromName.OtherMagnificationTypesAvailable,"OtherMagnificationTypesAvailable");
		nameByTag.put(TagFromName.DefaultSmoothingType,"DefaultSmoothingType");
		nameByTag.put(TagFromName.OtherSmoothingTypesAvailable,"OtherSmoothingTypesAvailable");
		nameByTag.put(TagFromName.BorderDensity,"BorderDensity");
		nameByTag.put(TagFromName.EmptyImageDensity,"EmptyImageDensity");
		nameByTag.put(TagFromName.MinDensity,"MinDensity");
		nameByTag.put(TagFromName.MaxDensity,"MaxDensity");
		nameByTag.put(TagFromName.Trim,"Trim");
		nameByTag.put(TagFromName.ConfigurationInformation,"ConfigurationInformation");
		nameByTag.put(TagFromName.ConfigurationInformationDescription,"ConfigurationInformationDescription");
		nameByTag.put(TagFromName.MaximumCollatedFilms,"MaximumCollatedFilms");
		nameByTag.put(TagFromName.Illumination,"Illumination");
		nameByTag.put(TagFromName.ReflectedAmbientLight,"ReflectedAmbientLight");
		nameByTag.put(TagFromName.PrinterPixelSpacing,"PrinterPixelSpacing");
		nameByTag.put(TagFromName.ReferencedFilmSessionSequence,"ReferencedFilmSessionSequence");
		nameByTag.put(TagFromName.ReferencedImageBoxSequence,"ReferencedImageBoxSequence");
		nameByTag.put(TagFromName.ReferencedBasicAnnotationBoxSequence,"ReferencedBasicAnnotationBoxSequence");
		nameByTag.put(TagFromName.ImageBoxPosition,"ImageBoxPosition");
		nameByTag.put(TagFromName.Polarity,"Polarity");
		nameByTag.put(TagFromName.RequestedImageSize,"RequestedImageSize");
		nameByTag.put(TagFromName.RequestedDecimateCropBehavior,"RequestedDecimateCropBehavior");
		nameByTag.put(TagFromName.RequestedResolutionID,"RequestedResolutionID");
		nameByTag.put(TagFromName.RequestedImageSizeFlag,"RequestedImageSizeFlag");
		nameByTag.put(TagFromName.DecimateCropResult,"DecimateCropResult");
		nameByTag.put(TagFromName.BasicGrayscaleImageSequence,"BasicGrayscaleImageSequence");
		nameByTag.put(TagFromName.BasicColorImageSequence,"BasicColorImageSequence");
		nameByTag.put(TagFromName.ReferencedImageOverlayBoxSequence,"ReferencedImageOverlayBoxSequence");
		nameByTag.put(TagFromName.ReferencedVOILUTBoxSequence,"ReferencedVOILUTBoxSequence");
		nameByTag.put(TagFromName.AnnotationPosition,"AnnotationPosition");
		nameByTag.put(TagFromName.TextString,"TextString");
		nameByTag.put(TagFromName.ReferencedOverlayPlaneSequence,"ReferencedOverlayPlaneSequence");
		nameByTag.put(TagFromName.ReferencedOverlayPlaneGroups,"ReferencedOverlayPlaneGroups");
		nameByTag.put(TagFromName.OverlayPixelDataSequence,"OverlayPixelDataSequence");
		nameByTag.put(TagFromName.OverlayMagnificationType,"OverlayMagnificationType");
		nameByTag.put(TagFromName.OverlaySmoothingType,"OverlaySmoothingType");
		nameByTag.put(TagFromName.OverlayOrImageMagnification,"OverlayOrImageMagnification");
		nameByTag.put(TagFromName.MagnifyToNumberOfColumns,"MagnifyToNumberOfColumns");
		nameByTag.put(TagFromName.OverlayForegroundDensity,"OverlayForegroundDensity");
		nameByTag.put(TagFromName.OverlayBackgroundDensity,"OverlayBackgroundDensity");
		nameByTag.put(TagFromName.OverlayMode,"OverlayMode");
		nameByTag.put(TagFromName.ThresholdDensity,"ThresholdDensity");
		nameByTag.put(TagFromName.ReferencedOverlayImageBoxSequence,"ReferencedOverlayImageBoxSequence");
		nameByTag.put(TagFromName.PresentationLUTSequence,"PresentationLUTSequence");
		nameByTag.put(TagFromName.PresentationLUTShape,"PresentationLUTShape");
		nameByTag.put(TagFromName.ReferencedPresentationLUTSequence,"ReferencedPresentationLUTSequence");
		nameByTag.put(TagFromName.PrintJobID,"PrintJobID");
		nameByTag.put(TagFromName.ExecutionStatus,"ExecutionStatus");
		nameByTag.put(TagFromName.ExecutionStatusInfo,"ExecutionStatusInfo");
		nameByTag.put(TagFromName.CreationDate,"CreationDate");
		nameByTag.put(TagFromName.CreationTime,"CreationTime");
		nameByTag.put(TagFromName.Originator,"Originator");
		nameByTag.put(TagFromName.DestinationAE,"DestinationAE");
		nameByTag.put(TagFromName.OwnerID,"OwnerID");
		nameByTag.put(TagFromName.NumberOfFilms,"NumberOfFilms");
		nameByTag.put(TagFromName.ReferencedPrintJobSequencePull,"ReferencedPrintJobSequencePull");
		nameByTag.put(TagFromName.PrinterStatus,"PrinterStatus");
		nameByTag.put(TagFromName.PrinterStatusInfo,"PrinterStatusInfo");
		nameByTag.put(TagFromName.PrinterName,"PrinterName");
		nameByTag.put(TagFromName.PrintQueueID,"PrintQueueID");
		nameByTag.put(TagFromName.QueueStatus,"QueueStatus");
		nameByTag.put(TagFromName.PrintJobDescriptionSequence,"PrintJobDescriptionSequence");
		nameByTag.put(TagFromName.ReferencedPrintJobSequenceQueue,"ReferencedPrintJobSequenceQueue");
		nameByTag.put(TagFromName.PrintManagementCapabilitiesSequence,"PrintManagementCapabilitiesSequence");
		nameByTag.put(TagFromName.PrinterCharacteristicsSequence,"PrinterCharacteristicsSequence");
		nameByTag.put(TagFromName.FilmBoxContentSequence,"FilmBoxContentSequence");
		nameByTag.put(TagFromName.ImageBoxContentSequence,"ImageBoxContentSequence");
		nameByTag.put(TagFromName.AnnotationContentSequence,"AnnotationContentSequence");
		nameByTag.put(TagFromName.ImageOverlayBoxContentSequence,"ImageOverlayBoxContentSequence");
		nameByTag.put(TagFromName.PresentationLUTContentSequence,"PresentationLUTContentSequence");
		nameByTag.put(TagFromName.ProposedStudySequence,"ProposedStudySequence");
		nameByTag.put(TagFromName.OriginalImageSequence,"OriginalImageSequence");
		nameByTag.put(TagFromName.LabelUsingInformationExtractedFromInstances,"LabelUsingInformationExtractedFromInstances");
		nameByTag.put(TagFromName.LabelText,"LabelText");
		nameByTag.put(TagFromName.LabelStyleSelection,"LabelStyleSelection");
		nameByTag.put(TagFromName.MediaDisposition,"MediaDisposition");
		nameByTag.put(TagFromName.BarcodeValue,"BarcodeValue");
		nameByTag.put(TagFromName.BarcodeSymbology,"BarcodeSymbology");
		nameByTag.put(TagFromName.AllowMediaSplitting,"AllowMediaSplitting");
		nameByTag.put(TagFromName.IncludeNonDICOMObjects,"IncludeNonDICOMObjects");
		nameByTag.put(TagFromName.IncludeDisplayApplication,"IncludeDisplayApplication");
		nameByTag.put(TagFromName.PreserveCompositeInstancesAfterMediaCreation,"PreserveCompositeInstancesAfterMediaCreation");
		nameByTag.put(TagFromName.TotalNumberOfPiecesOfMediaCreated,"TotalNumberOfPiecesOfMediaCreated");
		nameByTag.put(TagFromName.RequestedMediaApplicationProfile,"RequestedMediaApplicationProfile");
		nameByTag.put(TagFromName.ReferencedStorageMediaSequence,"ReferencedStorageMediaSequence");
		nameByTag.put(TagFromName.FailureAttributes,"FailureAttributes");
		nameByTag.put(TagFromName.AllowLossyCompression,"AllowLossyCompression");
		nameByTag.put(TagFromName.RequestPriority,"RequestPriority");
		nameByTag.put(TagFromName.RTImageLabel,"RTImageLabel");
		nameByTag.put(TagFromName.RTImageName,"RTImageName");
		nameByTag.put(TagFromName.RTImageDescription,"RTImageDescription");
		nameByTag.put(TagFromName.ReportedValuesOrigin,"ReportedValuesOrigin");
		nameByTag.put(TagFromName.RTImagePlane,"RTImagePlane");
		nameByTag.put(TagFromName.XRayImageReceptorTranslation,"XRayImageReceptorTranslation");
		nameByTag.put(TagFromName.XRayImageReceptorAngle,"XRayImageReceptorAngle");
		nameByTag.put(TagFromName.RTImageOrientation,"RTImageOrientation");
		nameByTag.put(TagFromName.ImagePlanePixelSpacing,"ImagePlanePixelSpacing");
		nameByTag.put(TagFromName.RTImagePosition,"RTImagePosition");
		nameByTag.put(TagFromName.RadiationMachineName,"RadiationMachineName");
		nameByTag.put(TagFromName.RadiationMachineSAD,"RadiationMachineSAD");
		nameByTag.put(TagFromName.RadiationMachineSSD,"RadiationMachineSSD");
		nameByTag.put(TagFromName.RTImageSID,"RTImageSID");
		nameByTag.put(TagFromName.SourceToReferenceObjectDistance,"SourceToReferenceObjectDistance");
		nameByTag.put(TagFromName.FractionNumber,"FractionNumber");
		nameByTag.put(TagFromName.ExposureSequence,"ExposureSequence");
		nameByTag.put(TagFromName.MetersetExposure,"MetersetExposure");
		nameByTag.put(TagFromName.DiaphragmPosition,"DiaphragmPosition");
		nameByTag.put(TagFromName.FluenceMapSequence,"FluenceMapSequence");
		nameByTag.put(TagFromName.FluenceDataSource,"FluenceDataSource");
		nameByTag.put(TagFromName.FluenceDataScale,"FluenceDataScale");
		nameByTag.put(TagFromName.DVHType,"DVHType");
		nameByTag.put(TagFromName.DoseUnits,"DoseUnits");
		nameByTag.put(TagFromName.DoseType,"DoseType");
		nameByTag.put(TagFromName.DoseComment,"DoseComment");
		nameByTag.put(TagFromName.NormalizationPoint,"NormalizationPoint");
		nameByTag.put(TagFromName.DoseSummationType,"DoseSummationType");
		nameByTag.put(TagFromName.GridFrameOffsetVector,"GridFrameOffsetVector");
		nameByTag.put(TagFromName.DoseGridScaling,"DoseGridScaling");
		nameByTag.put(TagFromName.RTDoseROISequence,"RTDoseROISequence");
		nameByTag.put(TagFromName.DoseValue,"DoseValue");
		nameByTag.put(TagFromName.TissueHeterogeneityCorrection,"TissueHeterogeneityCorrection");
		nameByTag.put(TagFromName.DVHNormalizationPoint,"DVHNormalizationPoint");
		nameByTag.put(TagFromName.DVHNormalizationDoseValue,"DVHNormalizationDoseValue");
		nameByTag.put(TagFromName.DVHSequence,"DVHSequence");
		nameByTag.put(TagFromName.DVHDoseScaling,"DVHDoseScaling");
		nameByTag.put(TagFromName.DVHVolumeUnits,"DVHVolumeUnits");
		nameByTag.put(TagFromName.DVHNumberOfBins,"DVHNumberOfBins");
		nameByTag.put(TagFromName.DVHData,"DVHData");
		nameByTag.put(TagFromName.DVHReferencedROISequence,"DVHReferencedROISequence");
		nameByTag.put(TagFromName.DVHROIContributionType,"DVHROIContributionType");
		nameByTag.put(TagFromName.DVHMinimumDose,"DVHMinimumDose");
		nameByTag.put(TagFromName.DVHMaximumDose,"DVHMaximumDose");
		nameByTag.put(TagFromName.DVHMeanDose,"DVHMeanDose");
		nameByTag.put(TagFromName.StructureSetLabel,"StructureSetLabel");
		nameByTag.put(TagFromName.StructureSetName,"StructureSetName");
		nameByTag.put(TagFromName.StructureSetDescription,"StructureSetDescription");
		nameByTag.put(TagFromName.StructureSetDate,"StructureSetDate");
		nameByTag.put(TagFromName.StructureSetTime,"StructureSetTime");
		nameByTag.put(TagFromName.ReferencedFrameOfReferenceSequence,"ReferencedFrameOfReferenceSequence");
		nameByTag.put(TagFromName.RTReferencedStudySequence,"RTReferencedStudySequence");
		nameByTag.put(TagFromName.RTReferencedSeriesSequence,"RTReferencedSeriesSequence");
		nameByTag.put(TagFromName.ContourImageSequence,"ContourImageSequence");
		nameByTag.put(TagFromName.StructureSetROISequence,"StructureSetROISequence");
		nameByTag.put(TagFromName.ROINumber,"ROINumber");
		nameByTag.put(TagFromName.ReferencedFrameOfReferenceUID,"ReferencedFrameOfReferenceUID");
		nameByTag.put(TagFromName.ROIName,"ROIName");
		nameByTag.put(TagFromName.ROIDescription,"ROIDescription");
		nameByTag.put(TagFromName.ROIDisplayColor,"ROIDisplayColor");
		nameByTag.put(TagFromName.ROIVolume,"ROIVolume");
		nameByTag.put(TagFromName.RTRelatedROISequence,"RTRelatedROISequence");
		nameByTag.put(TagFromName.RTROIRelationship,"RTROIRelationship");
		nameByTag.put(TagFromName.ROIGenerationAlgorithm,"ROIGenerationAlgorithm");
		nameByTag.put(TagFromName.ROIGenerationDescription,"ROIGenerationDescription");
		nameByTag.put(TagFromName.ROIContourSequence,"ROIContourSequence");
		nameByTag.put(TagFromName.ContourSequence,"ContourSequence");
		nameByTag.put(TagFromName.ContourGeometricType,"ContourGeometricType");
		nameByTag.put(TagFromName.ContourSlabThickness,"ContourSlabThickness");
		nameByTag.put(TagFromName.ContourOffsetVector,"ContourOffsetVector");
		nameByTag.put(TagFromName.NumberOfContourPoints,"NumberOfContourPoints");
		nameByTag.put(TagFromName.ContourNumber,"ContourNumber");
		nameByTag.put(TagFromName.AttachedContours,"AttachedContours");
		nameByTag.put(TagFromName.ContourData,"ContourData");
		nameByTag.put(TagFromName.RTROIObservationsSequence,"RTROIObservationsSequence");
		nameByTag.put(TagFromName.ObservationNumber,"ObservationNumber");
		nameByTag.put(TagFromName.ReferencedROINumber,"ReferencedROINumber");
		nameByTag.put(TagFromName.ROIObservationLabel,"ROIObservationLabel");
		nameByTag.put(TagFromName.RTROIIdentificationCodeSequence,"RTROIIdentificationCodeSequence");
		nameByTag.put(TagFromName.ROIObservationDescription,"ROIObservationDescription");
		nameByTag.put(TagFromName.RelatedRTROIObservationsSequence,"RelatedRTROIObservationsSequence");
		nameByTag.put(TagFromName.RTROIInterpretedType,"RTROIInterpretedType");
		nameByTag.put(TagFromName.ROIInterpreter,"ROIInterpreter");
		nameByTag.put(TagFromName.ROIPhysicalPropertiesSequence,"ROIPhysicalPropertiesSequence");
		nameByTag.put(TagFromName.ROIPhysicalProperty,"ROIPhysicalProperty");
		nameByTag.put(TagFromName.ROIPhysicalPropertyValue,"ROIPhysicalPropertyValue");
		nameByTag.put(TagFromName.ROIElementalCompositionSequence,"ROIElementalCompositionSequence");
		nameByTag.put(TagFromName.ROIElementalCompositionAtomicNumber,"ROIElementalCompositionAtomicNumber");
		nameByTag.put(TagFromName.ROIElementalCompositionAtomicMassFraction,"ROIElementalCompositionAtomicMassFraction");
		nameByTag.put(TagFromName.FrameOfReferenceRelationshipSequence,"FrameOfReferenceRelationshipSequence");
		nameByTag.put(TagFromName.RelatedFrameOfReferenceUID,"RelatedFrameOfReferenceUID");
		nameByTag.put(TagFromName.FrameOfReferenceTransformationType,"FrameOfReferenceTransformationType");
		nameByTag.put(TagFromName.FrameOfReferenceTransformationMatrix,"FrameOfReferenceTransformationMatrix");
		nameByTag.put(TagFromName.FrameOfReferenceTransformationComment,"FrameOfReferenceTransformationComment");
		nameByTag.put(TagFromName.MeasuredDoseReferenceSequence,"MeasuredDoseReferenceSequence");
		nameByTag.put(TagFromName.MeasuredDoseDescription,"MeasuredDoseDescription");
		nameByTag.put(TagFromName.MeasuredDoseType,"MeasuredDoseType");
		nameByTag.put(TagFromName.MeasuredDoseValue,"MeasuredDoseValue");
		nameByTag.put(TagFromName.TreatmentSessionBeamSequence,"TreatmentSessionBeamSequence");
		nameByTag.put(TagFromName.TreatmentSessionIonBeamSequence,"TreatmentSessionIonBeamSequence");
		nameByTag.put(TagFromName.CurrentFractionNumber,"CurrentFractionNumber");
		nameByTag.put(TagFromName.TreatmentControlPointDate,"TreatmentControlPointDate");
		nameByTag.put(TagFromName.TreatmentControlPointTime,"TreatmentControlPointTime");
		nameByTag.put(TagFromName.TreatmentTerminationStatus,"TreatmentTerminationStatus");
		nameByTag.put(TagFromName.TreatmentTerminationCode,"TreatmentTerminationCode");
		nameByTag.put(TagFromName.TreatmentVerificationStatus,"TreatmentVerificationStatus");
		nameByTag.put(TagFromName.ReferencedTreatmentRecordSequence,"ReferencedTreatmentRecordSequence");
		nameByTag.put(TagFromName.SpecifiedPrimaryMeterset,"SpecifiedPrimaryMeterset");
		nameByTag.put(TagFromName.SpecifiedSecondaryMeterset,"SpecifiedSecondaryMeterset");
		nameByTag.put(TagFromName.DeliveredPrimaryMeterset,"DeliveredPrimaryMeterset");
		nameByTag.put(TagFromName.DeliveredSecondaryMeterset,"DeliveredSecondaryMeterset");
		nameByTag.put(TagFromName.SpecifiedTreatmentTime,"SpecifiedTreatmentTime");
		nameByTag.put(TagFromName.DeliveredTreatmentTime,"DeliveredTreatmentTime");
		nameByTag.put(TagFromName.ControlPointDeliverySequence,"ControlPointDeliverySequence");
		nameByTag.put(TagFromName.IonControlPointDeliverySequence,"IonControlPointDeliverySequence");
		nameByTag.put(TagFromName.SpecifiedMeterset,"SpecifiedMeterset");
		nameByTag.put(TagFromName.DeliveredMeterset,"DeliveredMeterset");
		nameByTag.put(TagFromName.MetersetRateSet,"MetersetRateSet");
		nameByTag.put(TagFromName.MetersetRateDelivered,"MetersetRateDelivered");
		nameByTag.put(TagFromName.ScanSpotMetersetsDelivered,"ScanSpotMetersetsDelivered");
		nameByTag.put(TagFromName.DoseRateDelivered,"DoseRateDelivered");
		nameByTag.put(TagFromName.TreatmentSummaryCalculatedDoseReferenceSequence,"TreatmentSummaryCalculatedDoseReferenceSequence");
		nameByTag.put(TagFromName.CumulativeDoseToDoseReference,"CumulativeDoseToDoseReference");
		nameByTag.put(TagFromName.FirstTreatmentDate,"FirstTreatmentDate");
		nameByTag.put(TagFromName.MostRecentTreatmentDate,"MostRecentTreatmentDate");
		nameByTag.put(TagFromName.NumberOfFractionsDelivered,"NumberOfFractionsDelivered");
		nameByTag.put(TagFromName.OverrideSequence,"OverrideSequence");
		nameByTag.put(TagFromName.ParameterSequencePointer,"ParameterSequencePointer");
		nameByTag.put(TagFromName.OverrideParameterPointer,"OverrideParameterPointer");
		nameByTag.put(TagFromName.ParameterItemIndex,"ParameterItemIndex");
		nameByTag.put(TagFromName.MeasuredDoseReferenceNumber,"MeasuredDoseReferenceNumber");
		nameByTag.put(TagFromName.ParameterPointer,"ParameterPointer");
		nameByTag.put(TagFromName.OverrideReason,"OverrideReason");
		nameByTag.put(TagFromName.CorrectedParameterSequence,"CorrectedParameterSequence");
		nameByTag.put(TagFromName.CorrectionValue,"CorrectionValue");
		nameByTag.put(TagFromName.CalculatedDoseReferenceSequence,"CalculatedDoseReferenceSequence");
		nameByTag.put(TagFromName.CalculatedDoseReferenceNumber,"CalculatedDoseReferenceNumber");
		nameByTag.put(TagFromName.CalculatedDoseReferenceDescription,"CalculatedDoseReferenceDescription");
		nameByTag.put(TagFromName.CalculatedDoseReferenceDoseValue,"CalculatedDoseReferenceDoseValue");
		nameByTag.put(TagFromName.StartMeterset,"StartMeterset");
		nameByTag.put(TagFromName.EndMeterset,"EndMeterset");
		nameByTag.put(TagFromName.ReferencedMeasuredDoseReferenceSequence,"ReferencedMeasuredDoseReferenceSequence");
		nameByTag.put(TagFromName.ReferencedMeasuredDoseReferenceNumber,"ReferencedMeasuredDoseReferenceNumber");
		nameByTag.put(TagFromName.ReferencedCalculatedDoseReferenceSequence,"ReferencedCalculatedDoseReferenceSequence");
		nameByTag.put(TagFromName.ReferencedCalculatedDoseReferenceNumber,"ReferencedCalculatedDoseReferenceNumber");
		nameByTag.put(TagFromName.BeamLimitingDeviceLeafPairsSequence,"BeamLimitingDeviceLeafPairsSequence");
		nameByTag.put(TagFromName.RecordedWedgeSequence,"RecordedWedgeSequence");
		nameByTag.put(TagFromName.RecordedCompensatorSequence,"RecordedCompensatorSequence");
		nameByTag.put(TagFromName.RecordedBlockSequence,"RecordedBlockSequence");
		nameByTag.put(TagFromName.TreatmentSummaryMeasuredDoseReferenceSequence,"TreatmentSummaryMeasuredDoseReferenceSequence");
		nameByTag.put(TagFromName.RecordedSnoutSequence,"RecordedSnoutSequence");
		nameByTag.put(TagFromName.RecordedRangeShifterSequence,"RecordedRangeShifterSequence");
		nameByTag.put(TagFromName.RecordedLateralSpreadingDeviceSequence,"RecordedLateralSpreadingDeviceSequence");
		nameByTag.put(TagFromName.RecordedRangeModulatorSequence,"RecordedRangeModulatorSequence");
		nameByTag.put(TagFromName.RecordedSourceSequence,"RecordedSourceSequence");
		nameByTag.put(TagFromName.SourceSerialNumber,"SourceSerialNumber");
		nameByTag.put(TagFromName.TreatmentSessionApplicationSetupSequence,"TreatmentSessionApplicationSetupSequence");
		nameByTag.put(TagFromName.ApplicationSetupCheck,"ApplicationSetupCheck");
		nameByTag.put(TagFromName.RecordedBrachyAccessoryDeviceSequence,"RecordedBrachyAccessoryDeviceSequence");
		nameByTag.put(TagFromName.ReferencedBrachyAccessoryDeviceNumber,"ReferencedBrachyAccessoryDeviceNumber");
		nameByTag.put(TagFromName.RecordedChannelSequence,"RecordedChannelSequence");
		nameByTag.put(TagFromName.SpecifiedChannelTotalTime,"SpecifiedChannelTotalTime");
		nameByTag.put(TagFromName.DeliveredChannelTotalTime,"DeliveredChannelTotalTime");
		nameByTag.put(TagFromName.SpecifiedNumberOfPulses,"SpecifiedNumberOfPulses");
		nameByTag.put(TagFromName.DeliveredNumberOfPulses,"DeliveredNumberOfPulses");
		nameByTag.put(TagFromName.SpecifiedPulseRepetitionInterval,"SpecifiedPulseRepetitionInterval");
		nameByTag.put(TagFromName.DeliveredPulseRepetitionInterval,"DeliveredPulseRepetitionInterval");
		nameByTag.put(TagFromName.RecordedSourceApplicatorSequence,"RecordedSourceApplicatorSequence");
		nameByTag.put(TagFromName.ReferencedSourceApplicatorNumber,"ReferencedSourceApplicatorNumber");
		nameByTag.put(TagFromName.RecordedChannelShieldSequence,"RecordedChannelShieldSequence");
		nameByTag.put(TagFromName.ReferencedChannelShieldNumber,"ReferencedChannelShieldNumber");
		nameByTag.put(TagFromName.BrachyControlPointDeliveredSequence,"BrachyControlPointDeliveredSequence");
		nameByTag.put(TagFromName.SafePositionExitDate,"SafePositionExitDate");
		nameByTag.put(TagFromName.SafePositionExitTime,"SafePositionExitTime");
		nameByTag.put(TagFromName.SafePositionReturnDate,"SafePositionReturnDate");
		nameByTag.put(TagFromName.SafePositionReturnTime,"SafePositionReturnTime");
		nameByTag.put(TagFromName.CurrentTreatmentStatus,"CurrentTreatmentStatus");
		nameByTag.put(TagFromName.TreatmentStatusComment,"TreatmentStatusComment");
		nameByTag.put(TagFromName.FractionGroupSummarySequence,"FractionGroupSummarySequence");
		nameByTag.put(TagFromName.ReferencedFractionNumber,"ReferencedFractionNumber");
		nameByTag.put(TagFromName.FractionGroupType,"FractionGroupType");
		nameByTag.put(TagFromName.BeamStopperPosition,"BeamStopperPosition");
		nameByTag.put(TagFromName.FractionStatusSummarySequence,"FractionStatusSummarySequence");
		nameByTag.put(TagFromName.TreatmentDate,"TreatmentDate");
		nameByTag.put(TagFromName.TreatmentTime,"TreatmentTime");
		nameByTag.put(TagFromName.RTPlanLabel,"RTPlanLabel");
		nameByTag.put(TagFromName.RTPlanName,"RTPlanName");
		nameByTag.put(TagFromName.RTPlanDescription,"RTPlanDescription");
		nameByTag.put(TagFromName.RTPlanDate,"RTPlanDate");
		nameByTag.put(TagFromName.RTPlanTime,"RTPlanTime");
		nameByTag.put(TagFromName.TreatmentProtocols,"TreatmentProtocols");
		nameByTag.put(TagFromName.PlanIntent,"PlanIntent");
		nameByTag.put(TagFromName.TreatmentSites,"TreatmentSites");
		nameByTag.put(TagFromName.RTPlanGeometry,"RTPlanGeometry");
		nameByTag.put(TagFromName.PrescriptionDescription,"PrescriptionDescription");
		nameByTag.put(TagFromName.DoseReferenceSequence,"DoseReferenceSequence");
		nameByTag.put(TagFromName.DoseReferenceNumber,"DoseReferenceNumber");
		nameByTag.put(TagFromName.DoseReferenceUID,"DoseReferenceUID");
		nameByTag.put(TagFromName.DoseReferenceStructureType,"DoseReferenceStructureType");
		nameByTag.put(TagFromName.NominalBeamEnergyUnit,"NominalBeamEnergyUnit");
		nameByTag.put(TagFromName.DoseReferenceDescription,"DoseReferenceDescription");
		nameByTag.put(TagFromName.DoseReferencePointCoordinates,"DoseReferencePointCoordinates");
		nameByTag.put(TagFromName.NominalPriorDose,"NominalPriorDose");
		nameByTag.put(TagFromName.DoseReferenceType,"DoseReferenceType");
		nameByTag.put(TagFromName.ConstraintWeight,"ConstraintWeight");
		nameByTag.put(TagFromName.DeliveryWarningDose,"DeliveryWarningDose");
		nameByTag.put(TagFromName.DeliveryMaximumDose,"DeliveryMaximumDose");
		nameByTag.put(TagFromName.TargetMinimumDose,"TargetMinimumDose");
		nameByTag.put(TagFromName.TargetPrescriptionDose,"TargetPrescriptionDose");
		nameByTag.put(TagFromName.TargetMaximumDose,"TargetMaximumDose");
		nameByTag.put(TagFromName.TargetUnderdoseVolumeFraction,"TargetUnderdoseVolumeFraction");
		nameByTag.put(TagFromName.OrganAtRiskFullVolumeDose,"OrganAtRiskFullVolumeDose");
		nameByTag.put(TagFromName.OrganAtRiskLimitDose,"OrganAtRiskLimitDose");
		nameByTag.put(TagFromName.OrganAtRiskMaximumDose,"OrganAtRiskMaximumDose");
		nameByTag.put(TagFromName.OrganAtRiskOverdoseVolumeFraction,"OrganAtRiskOverdoseVolumeFraction");
		nameByTag.put(TagFromName.ToleranceTableSequence,"ToleranceTableSequence");
		nameByTag.put(TagFromName.ToleranceTableNumber,"ToleranceTableNumber");
		nameByTag.put(TagFromName.ToleranceTableLabel,"ToleranceTableLabel");
		nameByTag.put(TagFromName.GantryAngleTolerance,"GantryAngleTolerance");
		nameByTag.put(TagFromName.BeamLimitingDeviceAngleTolerance,"BeamLimitingDeviceAngleTolerance");
		nameByTag.put(TagFromName.BeamLimitingDeviceToleranceSequence,"BeamLimitingDeviceToleranceSequence");
		nameByTag.put(TagFromName.BeamLimitingDevicePositionTolerance,"BeamLimitingDevicePositionTolerance");
		nameByTag.put(TagFromName.SnoutPositionTolerance,"SnoutPositionTolerance");
		nameByTag.put(TagFromName.PatientSupportAngleTolerance,"PatientSupportAngleTolerance");
		nameByTag.put(TagFromName.TableTopEccentricAngleTolerance,"TableTopEccentricAngleTolerance");
		nameByTag.put(TagFromName.TableTopPitchAngleTolerance,"TableTopPitchAngleTolerance");
		nameByTag.put(TagFromName.TableTopRollAngleTolerance,"TableTopRollAngleTolerance");
		nameByTag.put(TagFromName.TableTopVerticalPositionTolerance,"TableTopVerticalPositionTolerance");
		nameByTag.put(TagFromName.TableTopLongitudinalPositionTolerance,"TableTopLongitudinalPositionTolerance");
		nameByTag.put(TagFromName.TableTopLateralPositionTolerance,"TableTopLateralPositionTolerance");
		nameByTag.put(TagFromName.RTPlanRelationship,"RTPlanRelationship");
		nameByTag.put(TagFromName.FractionGroupSequence,"FractionGroupSequence");
		nameByTag.put(TagFromName.FractionGroupNumber,"FractionGroupNumber");
		nameByTag.put(TagFromName.FractionGroupDescription,"FractionGroupDescription");
		nameByTag.put(TagFromName.NumberOfFractionsPlanned,"NumberOfFractionsPlanned");
		nameByTag.put(TagFromName.NumberOfFractionPatternDigitsPerDay,"NumberOfFractionPatternDigitsPerDay");
		nameByTag.put(TagFromName.RepeatFractionCycleLength,"RepeatFractionCycleLength");
		nameByTag.put(TagFromName.FractionPattern,"FractionPattern");
		nameByTag.put(TagFromName.NumberOfBeams,"NumberOfBeams");
		nameByTag.put(TagFromName.BeamDoseSpecificationPoint,"BeamDoseSpecificationPoint");
		nameByTag.put(TagFromName.BeamDose,"BeamDose");
		nameByTag.put(TagFromName.BeamMeterset,"BeamMeterset");
		nameByTag.put(TagFromName.BeamDosePointDepth,"BeamDosePointDepth");
		nameByTag.put(TagFromName.BeamDosePointEquivalentDepth,"BeamDosePointEquivalentDepth");
		nameByTag.put(TagFromName.BeamDosePointSSD,"BeamDosePointSSD");
		nameByTag.put(TagFromName.NumberOfBrachyApplicationSetups,"NumberOfBrachyApplicationSetups");
		nameByTag.put(TagFromName.BrachyApplicationSetupDoseSpecificationPoint,"BrachyApplicationSetupDoseSpecificationPoint");
		nameByTag.put(TagFromName.BrachyApplicationSetupDose,"BrachyApplicationSetupDose");
		nameByTag.put(TagFromName.BeamSequence,"BeamSequence");
		nameByTag.put(TagFromName.TreatmentMachineName,"TreatmentMachineName");
		nameByTag.put(TagFromName.PrimaryDosimeterUnit,"PrimaryDosimeterUnit");
		nameByTag.put(TagFromName.SourceAxisDistance,"SourceAxisDistance");
		nameByTag.put(TagFromName.BeamLimitingDeviceSequence,"BeamLimitingDeviceSequence");
		nameByTag.put(TagFromName.RTBeamLimitingDeviceType,"RTBeamLimitingDeviceType");
		nameByTag.put(TagFromName.SourceToBeamLimitingDeviceDistance,"SourceToBeamLimitingDeviceDistance");
		nameByTag.put(TagFromName.IsocenterToBeamLimitingDeviceDistance,"IsocenterToBeamLimitingDeviceDistance");
		nameByTag.put(TagFromName.NumberOfLeafJawPairs,"NumberOfLeafJawPairs");
		nameByTag.put(TagFromName.LeafPositionBoundaries,"LeafPositionBoundaries");
		nameByTag.put(TagFromName.BeamNumber,"BeamNumber");
		nameByTag.put(TagFromName.BeamName,"BeamName");
		nameByTag.put(TagFromName.BeamDescription,"BeamDescription");
		nameByTag.put(TagFromName.BeamType,"BeamType");
		nameByTag.put(TagFromName.RadiationType,"RadiationType");
		nameByTag.put(TagFromName.HighDoseTechniqueType,"HighDoseTechniqueType");
		nameByTag.put(TagFromName.ReferenceImageNumber,"ReferenceImageNumber");
		nameByTag.put(TagFromName.PlannedVerificationImageSequence,"PlannedVerificationImageSequence");
		nameByTag.put(TagFromName.ImagingDeviceSpecificAcquisitionParameters,"ImagingDeviceSpecificAcquisitionParameters");
		nameByTag.put(TagFromName.TreatmentDeliveryType,"TreatmentDeliveryType");
		nameByTag.put(TagFromName.NumberOfWedges,"NumberOfWedges");
		nameByTag.put(TagFromName.WedgeSequence,"WedgeSequence");
		nameByTag.put(TagFromName.WedgeNumber,"WedgeNumber");
		nameByTag.put(TagFromName.WedgeType,"WedgeType");
		nameByTag.put(TagFromName.WedgeID,"WedgeID");
		nameByTag.put(TagFromName.WedgeAngle,"WedgeAngle");
		nameByTag.put(TagFromName.WedgeFactor,"WedgeFactor");
		nameByTag.put(TagFromName.TotalWedgeTrayWaterEquivalentThickness,"TotalWedgeTrayWaterEquivalentThickness");
		nameByTag.put(TagFromName.WedgeOrientation,"WedgeOrientation");
		nameByTag.put(TagFromName.IsocenterToWedgeTrayDistance,"IsocenterToWedgeTrayDistance");
		nameByTag.put(TagFromName.SourceToWedgeTrayDistance,"SourceToWedgeTrayDistance");
		nameByTag.put(TagFromName.WedgeThinEdgePosition,"WedgeThinEdgePosition");
		nameByTag.put(TagFromName.BolusID,"BolusID");
		nameByTag.put(TagFromName.BolusDescription,"BolusDescription");
		nameByTag.put(TagFromName.NumberOfCompensators,"NumberOfCompensators");
		nameByTag.put(TagFromName.MaterialID,"MaterialID");
		nameByTag.put(TagFromName.TotalCompensatorTrayFactor,"TotalCompensatorTrayFactor");
		nameByTag.put(TagFromName.CompensatorSequence,"CompensatorSequence");
		nameByTag.put(TagFromName.CompensatorNumber,"CompensatorNumber");
		nameByTag.put(TagFromName.CompensatorID,"CompensatorID");
		nameByTag.put(TagFromName.SourceToCompensatorTrayDistance,"SourceToCompensatorTrayDistance");
		nameByTag.put(TagFromName.CompensatorRows,"CompensatorRows");
		nameByTag.put(TagFromName.CompensatorColumns,"CompensatorColumns");
		nameByTag.put(TagFromName.CompensatorPixelSpacing,"CompensatorPixelSpacing");
		nameByTag.put(TagFromName.CompensatorPosition,"CompensatorPosition");
		nameByTag.put(TagFromName.CompensatorTransmissionData,"CompensatorTransmissionData");
		nameByTag.put(TagFromName.CompensatorThicknessData,"CompensatorThicknessData");
		nameByTag.put(TagFromName.NumberOfBoli,"NumberOfBoli");
		nameByTag.put(TagFromName.CompensatorType,"CompensatorType");
		nameByTag.put(TagFromName.NumberOfBlocks,"NumberOfBlocks");
		nameByTag.put(TagFromName.TotalBlockTrayFactor,"TotalBlockTrayFactor");
		nameByTag.put(TagFromName.TotalBlockTrayWaterEquivalentThickness,"TotalBlockTrayWaterEquivalentThickness");
		nameByTag.put(TagFromName.BlockSequence,"BlockSequence");
		nameByTag.put(TagFromName.BlockTrayID,"BlockTrayID");
		nameByTag.put(TagFromName.SourceToBlockTrayDistance,"SourceToBlockTrayDistance");
		nameByTag.put(TagFromName.IsocenterToBlockTrayDistance,"IsocenterToBlockTrayDistance");
		nameByTag.put(TagFromName.BlockType,"BlockType");
		nameByTag.put(TagFromName.AccessoryCode,"AccessoryCode");
		nameByTag.put(TagFromName.BlockDivergence,"BlockDivergence");
		nameByTag.put(TagFromName.BlockMountingPosition,"BlockMountingPosition");
		nameByTag.put(TagFromName.BlockNumber,"BlockNumber");
		nameByTag.put(TagFromName.BlockName,"BlockName");
		nameByTag.put(TagFromName.BlockThickness,"BlockThickness");
		nameByTag.put(TagFromName.BlockTransmission,"BlockTransmission");
		nameByTag.put(TagFromName.BlockNumberOfPoints,"BlockNumberOfPoints");
		nameByTag.put(TagFromName.BlockData,"BlockData");
		nameByTag.put(TagFromName.ApplicatorSequence,"ApplicatorSequence");
		nameByTag.put(TagFromName.ApplicatorID,"ApplicatorID");
		nameByTag.put(TagFromName.ApplicatorType,"ApplicatorType");
		nameByTag.put(TagFromName.ApplicatorDescription,"ApplicatorDescription");
		nameByTag.put(TagFromName.CumulativeDoseReferenceCoefficient,"CumulativeDoseReferenceCoefficient");
		nameByTag.put(TagFromName.FinalCumulativeMetersetWeight,"FinalCumulativeMetersetWeight");
		nameByTag.put(TagFromName.NumberOfControlPoints,"NumberOfControlPoints");
		nameByTag.put(TagFromName.ControlPointSequence,"ControlPointSequence");
		nameByTag.put(TagFromName.ControlPointIndex,"ControlPointIndex");
		nameByTag.put(TagFromName.NominalBeamEnergy,"NominalBeamEnergy");
		nameByTag.put(TagFromName.DoseRateSet,"DoseRateSet");
		nameByTag.put(TagFromName.WedgePositionSequence,"WedgePositionSequence");
		nameByTag.put(TagFromName.WedgePosition,"WedgePosition");
		nameByTag.put(TagFromName.BeamLimitingDevicePositionSequence,"BeamLimitingDevicePositionSequence");
		nameByTag.put(TagFromName.LeafJawPositions,"LeafJawPositions");
		nameByTag.put(TagFromName.GantryAngle,"GantryAngle");
		nameByTag.put(TagFromName.GantryRotationDirection,"GantryRotationDirection");
		nameByTag.put(TagFromName.BeamLimitingDeviceAngle,"BeamLimitingDeviceAngle");
		nameByTag.put(TagFromName.BeamLimitingDeviceRotationDirection,"BeamLimitingDeviceRotationDirection");
		nameByTag.put(TagFromName.PatientSupportAngle,"PatientSupportAngle");
		nameByTag.put(TagFromName.PatientSupportRotationDirection,"PatientSupportRotationDirection");
		nameByTag.put(TagFromName.TableTopEccentricAxisDistance,"TableTopEccentricAxisDistance");
		nameByTag.put(TagFromName.TableTopEccentricAngle,"TableTopEccentricAngle");
		nameByTag.put(TagFromName.TableTopEccentricRotationDirection,"TableTopEccentricRotationDirection");
		nameByTag.put(TagFromName.TableTopVerticalPosition,"TableTopVerticalPosition");
		nameByTag.put(TagFromName.TableTopLongitudinalPosition,"TableTopLongitudinalPosition");
		nameByTag.put(TagFromName.TableTopLateralPosition,"TableTopLateralPosition");
		nameByTag.put(TagFromName.IsocenterPosition,"IsocenterPosition");
		nameByTag.put(TagFromName.SurfaceEntryPoint,"SurfaceEntryPoint");
		nameByTag.put(TagFromName.SourceToSurfaceDistance,"SourceToSurfaceDistance");
		nameByTag.put(TagFromName.CumulativeMetersetWeight,"CumulativeMetersetWeight");
		nameByTag.put(TagFromName.TableTopPitchAngle,"TableTopPitchAngle");
		nameByTag.put(TagFromName.TableTopPitchRotationDirection,"TableTopPitchRotationDirection");
		nameByTag.put(TagFromName.TableTopRollAngle,"TableTopRollAngle");
		nameByTag.put(TagFromName.TableTopRollRotationDirection,"TableTopRollRotationDirection");
		nameByTag.put(TagFromName.HeadFixationAngle,"HeadFixationAngle");
		nameByTag.put(TagFromName.GantryPitchAngle,"GantryPitchAngle");
		nameByTag.put(TagFromName.GantryPitchRotationDirection,"GantryPitchRotationDirection");
		nameByTag.put(TagFromName.GantryPitchAngleTolerance,"GantryPitchAngleTolerance");
		nameByTag.put(TagFromName.PatientSetupSequence,"PatientSetupSequence");
		nameByTag.put(TagFromName.PatientSetupNumber,"PatientSetupNumber");
		nameByTag.put(TagFromName.PatientSetupLabel,"PatientSetupLabel");
		nameByTag.put(TagFromName.PatientAdditionalPosition,"PatientAdditionalPosition");
		nameByTag.put(TagFromName.FixationDeviceSequence,"FixationDeviceSequence");
		nameByTag.put(TagFromName.FixationDeviceType,"FixationDeviceType");
		nameByTag.put(TagFromName.FixationDeviceLabel,"FixationDeviceLabel");
		nameByTag.put(TagFromName.FixationDeviceDescription,"FixationDeviceDescription");
		nameByTag.put(TagFromName.FixationDevicePosition,"FixationDevicePosition");
		nameByTag.put(TagFromName.FixationDevicePitchAngle,"FixationDevicePitchAngle");
		nameByTag.put(TagFromName.FixationDeviceRollAngle,"FixationDeviceRollAngle");
		nameByTag.put(TagFromName.ShieldingDeviceSequence,"ShieldingDeviceSequence");
		nameByTag.put(TagFromName.ShieldingDeviceType,"ShieldingDeviceType");
		nameByTag.put(TagFromName.ShieldingDeviceLabel,"ShieldingDeviceLabel");
		nameByTag.put(TagFromName.ShieldingDeviceDescription,"ShieldingDeviceDescription");
		nameByTag.put(TagFromName.ShieldingDevicePosition,"ShieldingDevicePosition");
		nameByTag.put(TagFromName.SetupTechnique,"SetupTechnique");
		nameByTag.put(TagFromName.SetupTechniqueDescription,"SetupTechniqueDescription");
		nameByTag.put(TagFromName.SetupDeviceSequence,"SetupDeviceSequence");
		nameByTag.put(TagFromName.SetupDeviceType,"SetupDeviceType");
		nameByTag.put(TagFromName.SetupDeviceLabel,"SetupDeviceLabel");
		nameByTag.put(TagFromName.SetupDeviceDescription,"SetupDeviceDescription");
		nameByTag.put(TagFromName.SetupDeviceParameter,"SetupDeviceParameter");
		nameByTag.put(TagFromName.SetupReferenceDescription,"SetupReferenceDescription");
		nameByTag.put(TagFromName.TableTopVerticalSetupDisplacement,"TableTopVerticalSetupDisplacement");
		nameByTag.put(TagFromName.TableTopLongitudinalSetupDisplacement,"TableTopLongitudinalSetupDisplacement");
		nameByTag.put(TagFromName.TableTopLateralSetupDisplacement,"TableTopLateralSetupDisplacement");
		nameByTag.put(TagFromName.BrachyTreatmentTechnique,"BrachyTreatmentTechnique");
		nameByTag.put(TagFromName.BrachyTreatmentType,"BrachyTreatmentType");
		nameByTag.put(TagFromName.TreatmentMachineSequence,"TreatmentMachineSequence");
		nameByTag.put(TagFromName.SourceSequence,"SourceSequence");
		nameByTag.put(TagFromName.SourceNumber,"SourceNumber");
		nameByTag.put(TagFromName.SourceType,"SourceType");
		nameByTag.put(TagFromName.SourceManufacturer,"SourceManufacturer");
		nameByTag.put(TagFromName.ActiveSourceDiameter,"ActiveSourceDiameter");
		nameByTag.put(TagFromName.ActiveSourceLength,"ActiveSourceLength");
		nameByTag.put(TagFromName.SourceEncapsulationNominalThickness,"SourceEncapsulationNominalThickness");
		nameByTag.put(TagFromName.SourceEncapsulationNominalTransmission,"SourceEncapsulationNominalTransmission");
		nameByTag.put(TagFromName.SourceIsotopeName,"SourceIsotopeName");
		nameByTag.put(TagFromName.SourceIsotopeHalfLife,"SourceIsotopeHalfLife");
		nameByTag.put(TagFromName.SourceStrengthUnits,"SourceStrengthUnits");
		nameByTag.put(TagFromName.ReferenceAirKermaRate,"ReferenceAirKermaRate");
		nameByTag.put(TagFromName.SourceStrength,"SourceStrength");
		nameByTag.put(TagFromName.SourceStrengthReferenceDate,"SourceStrengthReferenceDate");
		nameByTag.put(TagFromName.SourceStrengthReferenceTime,"SourceStrengthReferenceTime");
		nameByTag.put(TagFromName.ApplicationSetupSequence,"ApplicationSetupSequence");
		nameByTag.put(TagFromName.ApplicationSetupType,"ApplicationSetupType");
		nameByTag.put(TagFromName.ApplicationSetupNumber,"ApplicationSetupNumber");
		nameByTag.put(TagFromName.ApplicationSetupName,"ApplicationSetupName");
		nameByTag.put(TagFromName.ApplicationSetupManufacturer,"ApplicationSetupManufacturer");
		nameByTag.put(TagFromName.TemplateNumber,"TemplateNumber");
		nameByTag.put(TagFromName.TemplateType,"TemplateType");
		nameByTag.put(TagFromName.TemplateName,"TemplateName");
		nameByTag.put(TagFromName.TotalReferenceAirKerma,"TotalReferenceAirKerma");
		nameByTag.put(TagFromName.BrachyAccessoryDeviceSequence,"BrachyAccessoryDeviceSequence");
		nameByTag.put(TagFromName.BrachyAccessoryDeviceNumber,"BrachyAccessoryDeviceNumber");
		nameByTag.put(TagFromName.BrachyAccessoryDeviceID,"BrachyAccessoryDeviceID");
		nameByTag.put(TagFromName.BrachyAccessoryDeviceType,"BrachyAccessoryDeviceType");
		nameByTag.put(TagFromName.BrachyAccessoryDeviceName,"BrachyAccessoryDeviceName");
		nameByTag.put(TagFromName.BrachyAccessoryDeviceNominalThickness,"BrachyAccessoryDeviceNominalThickness");
		nameByTag.put(TagFromName.BrachyAccessoryDeviceNominalTransmission,"BrachyAccessoryDeviceNominalTransmission");
		nameByTag.put(TagFromName.ChannelSequence,"ChannelSequence");
		nameByTag.put(TagFromName.ChannelNumber,"ChannelNumber");
		nameByTag.put(TagFromName.ChannelLength,"ChannelLength");
		nameByTag.put(TagFromName.ChannelTotalTime,"ChannelTotalTime");
		nameByTag.put(TagFromName.SourceMovementType,"SourceMovementType");
		nameByTag.put(TagFromName.NumberOfPulses,"NumberOfPulses");
		nameByTag.put(TagFromName.PulseRepetitionInterval,"PulseRepetitionInterval");
		nameByTag.put(TagFromName.SourceApplicatorNumber,"SourceApplicatorNumber");
		nameByTag.put(TagFromName.SourceApplicatorID,"SourceApplicatorID");
		nameByTag.put(TagFromName.SourceApplicatorType,"SourceApplicatorType");
		nameByTag.put(TagFromName.SourceApplicatorName,"SourceApplicatorName");
		nameByTag.put(TagFromName.SourceApplicatorLength,"SourceApplicatorLength");
		nameByTag.put(TagFromName.SourceApplicatorManufacturer,"SourceApplicatorManufacturer");
		nameByTag.put(TagFromName.SourceApplicatorWallNominalThickness,"SourceApplicatorWallNominalThickness");
		nameByTag.put(TagFromName.SourceApplicatorWallNominalTransmission,"SourceApplicatorWallNominalTransmission");
		nameByTag.put(TagFromName.SourceApplicatorStepSize,"SourceApplicatorStepSize");
		nameByTag.put(TagFromName.TransferTubeNumber,"TransferTubeNumber");
		nameByTag.put(TagFromName.TransferTubeLength,"TransferTubeLength");
		nameByTag.put(TagFromName.ChannelShieldSequence,"ChannelShieldSequence");
		nameByTag.put(TagFromName.ChannelShieldNumber,"ChannelShieldNumber");
		nameByTag.put(TagFromName.ChannelShieldID,"ChannelShieldID");
		nameByTag.put(TagFromName.ChannelShieldName,"ChannelShieldName");
		nameByTag.put(TagFromName.ChannelShieldNominalThickness,"ChannelShieldNominalThickness");
		nameByTag.put(TagFromName.ChannelShieldNominalTransmission,"ChannelShieldNominalTransmission");
		nameByTag.put(TagFromName.FinalCumulativeTimeWeight,"FinalCumulativeTimeWeight");
		nameByTag.put(TagFromName.BrachyControlPointSequence,"BrachyControlPointSequence");
		nameByTag.put(TagFromName.ControlPointRelativePosition,"ControlPointRelativePosition");
		nameByTag.put(TagFromName.ControlPoint3DPosition,"ControlPoint3DPosition");
		nameByTag.put(TagFromName.CumulativeTimeWeight,"CumulativeTimeWeight");
		nameByTag.put(TagFromName.CompensatorDivergence,"CompensatorDivergence");
		nameByTag.put(TagFromName.CompensatorMountingPosition,"CompensatorMountingPosition");
		nameByTag.put(TagFromName.SourceToCompensatorDistance,"SourceToCompensatorDistance");
		nameByTag.put(TagFromName.TotalCompensatorTrayWaterEquivalentThickness,"TotalCompensatorTrayWaterEquivalentThickness");
		nameByTag.put(TagFromName.IsocenterToCompensatorTrayDistance,"IsocenterToCompensatorTrayDistance");
		nameByTag.put(TagFromName.CompensatorColumnOffset,"CompensatorColumnOffset");
		nameByTag.put(TagFromName.IsocenterToCompensatorDistances,"IsocenterToCompensatorDistances");
		nameByTag.put(TagFromName.CompensatorRelativeStoppingPowerRatio,"CompensatorRelativeStoppingPowerRatio");
		nameByTag.put(TagFromName.CompensatorMillingToolDiameter,"CompensatorMillingToolDiameter");
		nameByTag.put(TagFromName.IonRangeCompensatorSequence,"IonRangeCompensatorSequence");
		nameByTag.put(TagFromName.CompensatorDescription,"CompensatorDescription");
		nameByTag.put(TagFromName.RadiationMassNumber,"RadiationMassNumber");
		nameByTag.put(TagFromName.RadiationAtomicNumber,"RadiationAtomicNumber");
		nameByTag.put(TagFromName.RadiationChargeState,"RadiationChargeState");
		nameByTag.put(TagFromName.ScanMode,"ScanMode");
		nameByTag.put(TagFromName.VirtualSourceAxisDistances,"VirtualSourceAxisDistances");
		nameByTag.put(TagFromName.SnoutSequence,"SnoutSequence");
		nameByTag.put(TagFromName.SnoutPosition,"SnoutPosition");
		nameByTag.put(TagFromName.SnoutID,"SnoutID");
		nameByTag.put(TagFromName.NumberOfRangeShifters,"NumberOfRangeShifters");
		nameByTag.put(TagFromName.RangeShifterSequence,"RangeShifterSequence");
		nameByTag.put(TagFromName.RangeShifterNumber,"RangeShifterNumber");
		nameByTag.put(TagFromName.RangeShifterID,"RangeShifterID");
		nameByTag.put(TagFromName.RangeShifterType,"RangeShifterType");
		nameByTag.put(TagFromName.RangeShifterDescription,"RangeShifterDescription");
		nameByTag.put(TagFromName.NumberOfLateralSpreadingDevices,"NumberOfLateralSpreadingDevices");
		nameByTag.put(TagFromName.LateralSpreadingDeviceSequence,"LateralSpreadingDeviceSequence");
		nameByTag.put(TagFromName.LateralSpreadingDeviceNumber,"LateralSpreadingDeviceNumber");
		nameByTag.put(TagFromName.LateralSpreadingDeviceID,"LateralSpreadingDeviceID");
		nameByTag.put(TagFromName.LateralSpreadingDeviceType,"LateralSpreadingDeviceType");
		nameByTag.put(TagFromName.LateralSpreadingDeviceDescription,"LateralSpreadingDeviceDescription");
		nameByTag.put(TagFromName.LateralSpreadingDeviceWaterEquivalentThickness,"LateralSpreadingDeviceWaterEquivalentThickness");
		nameByTag.put(TagFromName.NumberOfRangeModulators,"NumberOfRangeModulators");
		nameByTag.put(TagFromName.RangeModulatorSequence,"RangeModulatorSequence");
		nameByTag.put(TagFromName.RangeModulatorNumber,"RangeModulatorNumber");
		nameByTag.put(TagFromName.RangeModulatorID,"RangeModulatorID");
		nameByTag.put(TagFromName.RangeModulatorType,"RangeModulatorType");
		nameByTag.put(TagFromName.RangeModulatorDescription,"RangeModulatorDescription");
		nameByTag.put(TagFromName.BeamCurrentModulationID,"BeamCurrentModulationID");
		nameByTag.put(TagFromName.PatientSupportType,"PatientSupportType");
		nameByTag.put(TagFromName.PatientSupportID,"PatientSupportID");
		nameByTag.put(TagFromName.PatientSupportAccessoryCode,"PatientSupportAccessoryCode");
		nameByTag.put(TagFromName.FixationLightAzimuthalAngle,"FixationLightAzimuthalAngle");
		nameByTag.put(TagFromName.FixationLightPolarAngle,"FixationLightPolarAngle");
		nameByTag.put(TagFromName.MetersetRate,"MetersetRate");
		nameByTag.put(TagFromName.RangeShifterSettingsSequence,"RangeShifterSettingsSequence");
		nameByTag.put(TagFromName.RangeShifterSetting,"RangeShifterSetting");
		nameByTag.put(TagFromName.IsocenterToRangeShifterDistance,"IsocenterToRangeShifterDistance");
		nameByTag.put(TagFromName.RangeShifterWaterEquivalentThickness,"RangeShifterWaterEquivalentThickness");
		nameByTag.put(TagFromName.LateralSpreadingDeviceSettingsSequence,"LateralSpreadingDeviceSettingsSequence");
		nameByTag.put(TagFromName.LateralSpreadingDeviceSetting,"LateralSpreadingDeviceSetting");
		nameByTag.put(TagFromName.IsocenterToLateralSpreadingDeviceDistance,"IsocenterToLateralSpreadingDeviceDistance");
		nameByTag.put(TagFromName.RangeModulatorSettingsSequence,"RangeModulatorSettingsSequence");
		nameByTag.put(TagFromName.RangeModulatorGatingStartValue,"RangeModulatorGatingStartValue");
		nameByTag.put(TagFromName.RangeModulatorGatingStopValue,"RangeModulatorGatingStopValue");
		nameByTag.put(TagFromName.RangeModulatorGatingStartWaterEquivalentThickness,"RangeModulatorGatingStartWaterEquivalentThickness");
		nameByTag.put(TagFromName.RangeModulatorGatingStopWaterEquivalentThickness,"RangeModulatorGatingStopWaterEquivalentThickness");
		nameByTag.put(TagFromName.IsocenterToRangeModulatorDistance,"IsocenterToRangeModulatorDistance");
		nameByTag.put(TagFromName.ScanSpotTuneID,"ScanSpotTuneID");
		nameByTag.put(TagFromName.NumberOfScanSpotPositions,"NumberOfScanSpotPositions");
		nameByTag.put(TagFromName.ScanSpotPositionMap,"ScanSpotPositionMap");
		nameByTag.put(TagFromName.ScanSpotMetersetWeights,"ScanSpotMetersetWeights");
		nameByTag.put(TagFromName.ScanningSpotSize,"ScanningSpotSize");
		nameByTag.put(TagFromName.NumberOfPaintings,"NumberOfPaintings");
		nameByTag.put(TagFromName.IonToleranceTableSequence,"IonToleranceTableSequence");
		nameByTag.put(TagFromName.IonBeamSequence,"IonBeamSequence");
		nameByTag.put(TagFromName.IonBeamLimitingDeviceSequence,"IonBeamLimitingDeviceSequence");
		nameByTag.put(TagFromName.IonBlockSequence,"IonBlockSequence");
		nameByTag.put(TagFromName.IonControlPointSequence,"IonControlPointSequence");
		nameByTag.put(TagFromName.IonWedgeSequence,"IonWedgeSequence");
		nameByTag.put(TagFromName.IonWedgePositionSequence,"IonWedgePositionSequence");
		nameByTag.put(TagFromName.ReferencedSetupImageSequence,"ReferencedSetupImageSequence");
		nameByTag.put(TagFromName.SetupImageComment,"SetupImageComment");
		nameByTag.put(TagFromName.MotionSynchronizationSequence,"MotionSynchronizationSequence");
		nameByTag.put(TagFromName.ControlPointOrientation,"ControlPointOrientation");
		nameByTag.put(TagFromName.GeneralAccessorySequence,"GeneralAccessorySequence");
		nameByTag.put(TagFromName.GeneralAccessoryID,"GeneralAccessoryID");
		nameByTag.put(TagFromName.GeneralAccessoryDescription,"GeneralAccessoryDescription");
		nameByTag.put(TagFromName.GeneralAccessoryType,"GeneralAccessoryType");
		nameByTag.put(TagFromName.GeneralAccessoryNumber,"GeneralAccessoryNumber");
		nameByTag.put(TagFromName.ReferencedRTPlanSequence,"ReferencedRTPlanSequence");
		nameByTag.put(TagFromName.ReferencedBeamSequence,"ReferencedBeamSequence");
		nameByTag.put(TagFromName.ReferencedBeamNumber,"ReferencedBeamNumber");
		nameByTag.put(TagFromName.ReferencedReferenceImageNumber,"ReferencedReferenceImageNumber");
		nameByTag.put(TagFromName.StartCumulativeMetersetWeight,"StartCumulativeMetersetWeight");
		nameByTag.put(TagFromName.EndCumulativeMetersetWeight,"EndCumulativeMetersetWeight");
		nameByTag.put(TagFromName.ReferencedBrachyApplicationSetupSequence,"ReferencedBrachyApplicationSetupSequence");
		nameByTag.put(TagFromName.ReferencedBrachyApplicationSetupNumber,"ReferencedBrachyApplicationSetupNumber");
		nameByTag.put(TagFromName.ReferencedSourceNumber,"ReferencedSourceNumber");
		nameByTag.put(TagFromName.ReferencedFractionGroupSequence,"ReferencedFractionGroupSequence");
		nameByTag.put(TagFromName.ReferencedFractionGroupNumber,"ReferencedFractionGroupNumber");
		nameByTag.put(TagFromName.ReferencedVerificationImageSequence,"ReferencedVerificationImageSequence");
		nameByTag.put(TagFromName.ReferencedReferenceImageSequence,"ReferencedReferenceImageSequence");
		nameByTag.put(TagFromName.ReferencedDoseReferenceSequence,"ReferencedDoseReferenceSequence");
		nameByTag.put(TagFromName.ReferencedDoseReferenceNumber,"ReferencedDoseReferenceNumber");
		nameByTag.put(TagFromName.BrachyReferencedDoseReferenceSequence,"BrachyReferencedDoseReferenceSequence");
		nameByTag.put(TagFromName.ReferencedStructureSetSequence,"ReferencedStructureSetSequence");
		nameByTag.put(TagFromName.ReferencedPatientSetupNumber,"ReferencedPatientSetupNumber");
		nameByTag.put(TagFromName.ReferencedDoseSequence,"ReferencedDoseSequence");
		nameByTag.put(TagFromName.ReferencedToleranceTableNumber,"ReferencedToleranceTableNumber");
		nameByTag.put(TagFromName.ReferencedBolusSequence,"ReferencedBolusSequence");
		nameByTag.put(TagFromName.ReferencedWedgeNumber,"ReferencedWedgeNumber");
		nameByTag.put(TagFromName.ReferencedCompensatorNumber,"ReferencedCompensatorNumber");
		nameByTag.put(TagFromName.ReferencedBlockNumber,"ReferencedBlockNumber");
		nameByTag.put(TagFromName.ReferencedControlPointIndex,"ReferencedControlPointIndex");
		nameByTag.put(TagFromName.ReferencedControlPointSequence,"ReferencedControlPointSequence");
		nameByTag.put(TagFromName.ReferencedStartControlPointIndex,"ReferencedStartControlPointIndex");
		nameByTag.put(TagFromName.ReferencedStopControlPointIndex,"ReferencedStopControlPointIndex");
		nameByTag.put(TagFromName.ReferencedRangeShifterNumber,"ReferencedRangeShifterNumber");
		nameByTag.put(TagFromName.ReferencedLateralSpreadingDeviceNumber,"ReferencedLateralSpreadingDeviceNumber");
		nameByTag.put(TagFromName.ReferencedRangeModulatorNumber,"ReferencedRangeModulatorNumber");
		nameByTag.put(TagFromName.ApprovalStatus,"ApprovalStatus");
		nameByTag.put(TagFromName.ReviewDate,"ReviewDate");
		nameByTag.put(TagFromName.ReviewTime,"ReviewTime");
		nameByTag.put(TagFromName.ReviewerName,"ReviewerName");
		nameByTag.put(TagFromName.Arbitrary,"Arbitrary");
		nameByTag.put(TagFromName.TextComments,"TextComments");
		nameByTag.put(TagFromName.ResultsID,"ResultsID");
		nameByTag.put(TagFromName.ResultsIDIssuer,"ResultsIDIssuer");
		nameByTag.put(TagFromName.ReferencedInterpretationSequence,"ReferencedInterpretationSequence");
		nameByTag.put(TagFromName.ReportProductionStatusTrial,"ReportProductionStatusTrial");
		nameByTag.put(TagFromName.InterpretationRecordedDate,"InterpretationRecordedDate");
		nameByTag.put(TagFromName.InterpretationRecordedTime,"InterpretationRecordedTime");
		nameByTag.put(TagFromName.InterpretationRecorder,"InterpretationRecorder");
		nameByTag.put(TagFromName.ReferenceToRecordedSound,"ReferenceToRecordedSound");
		nameByTag.put(TagFromName.InterpretationTranscriptionDate,"InterpretationTranscriptionDate");
		nameByTag.put(TagFromName.InterpretationTranscriptionTime,"InterpretationTranscriptionTime");
		nameByTag.put(TagFromName.InterpretationTranscriber,"InterpretationTranscriber");
		nameByTag.put(TagFromName.InterpretationText,"InterpretationText");
		nameByTag.put(TagFromName.InterpretationAuthor,"InterpretationAuthor");
		nameByTag.put(TagFromName.InterpretationApproverSequence,"InterpretationApproverSequence");
		nameByTag.put(TagFromName.InterpretationApprovalDate,"InterpretationApprovalDate");
		nameByTag.put(TagFromName.InterpretationApprovalTime,"InterpretationApprovalTime");
		nameByTag.put(TagFromName.PhysicianApprovingInterpretation,"PhysicianApprovingInterpretation");
		nameByTag.put(TagFromName.InterpretationDiagnosisDescription,"InterpretationDiagnosisDescription");
		nameByTag.put(TagFromName.InterpretationDiagnosisCodeSequence,"InterpretationDiagnosisCodeSequence");
		nameByTag.put(TagFromName.ResultsDistributionListSequence,"ResultsDistributionListSequence");
		nameByTag.put(TagFromName.DistributionName,"DistributionName");
		nameByTag.put(TagFromName.DistributionAddress,"DistributionAddress");
		nameByTag.put(TagFromName.InterpretationID,"InterpretationID");
		nameByTag.put(TagFromName.InterpretationIDIssuer,"InterpretationIDIssuer");
		nameByTag.put(TagFromName.InterpretationTypeID,"InterpretationTypeID");
		nameByTag.put(TagFromName.InterpretationStatusID,"InterpretationStatusID");
		nameByTag.put(TagFromName.Impressions,"Impressions");
		nameByTag.put(TagFromName.ResultsComments,"ResultsComments");
		nameByTag.put(TagFromName.MACParametersSequence,"MACParametersSequence");
		nameByTag.put(TagFromName.CurveDimensions,"CurveDimensions");
		nameByTag.put(TagFromName.NumberOfPoints,"NumberOfPoints");
		nameByTag.put(TagFromName.TypeOfData,"TypeOfData");
		nameByTag.put(TagFromName.CurveDescription,"CurveDescription");
		nameByTag.put(TagFromName.AxisUnits,"AxisUnits");
		nameByTag.put(TagFromName.AxisLabels,"AxisLabels");
		nameByTag.put(TagFromName.DataValueRepresentation,"DataValueRepresentation");
		nameByTag.put(TagFromName.MinimumCoordinateValue,"MinimumCoordinateValue");
		nameByTag.put(TagFromName.MaximumCoordinateValue,"MaximumCoordinateValue");
		nameByTag.put(TagFromName.CurveRange,"CurveRange");
		nameByTag.put(TagFromName.CurveDataDescriptor,"CurveDataDescriptor");
		nameByTag.put(TagFromName.CoordinateStartValue,"CoordinateStartValue");
		nameByTag.put(TagFromName.CoordinateStepValue,"CoordinateStepValue");
		nameByTag.put(TagFromName.CurveActivationLayer,"CurveActivationLayer");
		nameByTag.put(TagFromName.AudioType,"AudioType");
		nameByTag.put(TagFromName.AudioSampleFormat,"AudioSampleFormat");
		nameByTag.put(TagFromName.NumberOfChannels,"NumberOfChannels");
		nameByTag.put(TagFromName.NumberOfSamples,"NumberOfSamples");
		nameByTag.put(TagFromName.SampleRate,"SampleRate");
		nameByTag.put(TagFromName.TotalTime,"TotalTime");
		nameByTag.put(TagFromName.AudioSampleData,"AudioSampleData");
		nameByTag.put(TagFromName.AudioComments,"AudioComments");
		nameByTag.put(TagFromName.CurveLabel,"CurveLabel");
		nameByTag.put(TagFromName.CurveReferencedOverlaySequence,"CurveReferencedOverlaySequence");
		nameByTag.put(TagFromName.CurveReferencedOverlayGroup,"CurveReferencedOverlayGroup");
		nameByTag.put(TagFromName.CurveData,"CurveData");
		nameByTag.put(TagFromName.SharedFunctionalGroupsSequence,"SharedFunctionalGroupsSequence");
		nameByTag.put(TagFromName.PerFrameFunctionalGroupsSequence,"PerFrameFunctionalGroupsSequence");
		nameByTag.put(TagFromName.WaveformSequence,"WaveformSequence");
		nameByTag.put(TagFromName.ChannelMinimumValue,"ChannelMinimumValue");
		nameByTag.put(TagFromName.ChannelMaximumValue,"ChannelMaximumValue");
		nameByTag.put(TagFromName.WaveformBitsAllocated,"WaveformBitsAllocated");
		nameByTag.put(TagFromName.WaveformSampleInterpretation,"WaveformSampleInterpretation");
		nameByTag.put(TagFromName.WaveformPaddingValue,"WaveformPaddingValue");
		nameByTag.put(TagFromName.WaveformData,"WaveformData");
		nameByTag.put(TagFromName.FirstOrderPhaseCorrectionAngle,"FirstOrderPhaseCorrectionAngle");
		nameByTag.put(TagFromName.SpectroscopyData,"SpectroscopyData");
		nameByTag.put(TagFromName.OverlayRows,"OverlayRows");
		nameByTag.put(TagFromName.OverlayColumns,"OverlayColumns");
		nameByTag.put(TagFromName.OverlayPlanes,"OverlayPlanes");
		nameByTag.put(TagFromName.NumberOfFramesInOverlay,"NumberOfFramesInOverlay");
		nameByTag.put(TagFromName.OverlayDescription,"OverlayDescription");
		nameByTag.put(TagFromName.OverlayType,"OverlayType");
		nameByTag.put(TagFromName.OverlaySubtype,"OverlaySubtype");
		nameByTag.put(TagFromName.OverlayOrigin,"OverlayOrigin");
		nameByTag.put(TagFromName.ImageFrameOrigin,"ImageFrameOrigin");
		nameByTag.put(TagFromName.PlaneOrigin,"PlaneOrigin");
		nameByTag.put(TagFromName.OverlayCompressionCode,"OverlayCompressionCode");
		nameByTag.put(TagFromName.OverlayCompressionOriginator,"OverlayCompressionOriginator");
		nameByTag.put(TagFromName.OverlayCompressionLabel,"OverlayCompressionLabel");
		nameByTag.put(TagFromName.OverlayCompressionDescription,"OverlayCompressionDescription");
		nameByTag.put(TagFromName.OverlayCompressionStepPointers,"OverlayCompressionStepPointers");
		nameByTag.put(TagFromName.OverlayRepeatInterval,"OverlayRepeatInterval");
		nameByTag.put(TagFromName.OverlayBitsGrouped,"OverlayBitsGrouped");
		nameByTag.put(TagFromName.OverlayBitsAllocated,"OverlayBitsAllocated");
		nameByTag.put(TagFromName.OverlayBitPosition,"OverlayBitPosition");
		nameByTag.put(TagFromName.OverlayFormat,"OverlayFormat");
		nameByTag.put(TagFromName.OverlayLocation,"OverlayLocation");
		nameByTag.put(TagFromName.OverlayCodeLabel,"OverlayCodeLabel");
		nameByTag.put(TagFromName.OverlayNumberOfTables,"OverlayNumberOfTables");
		nameByTag.put(TagFromName.OverlayCodeTableLocation,"OverlayCodeTableLocation");
		nameByTag.put(TagFromName.OverlayBitsForCodeWord,"OverlayBitsForCodeWord");
		nameByTag.put(TagFromName.OverlayActivationLayer,"OverlayActivationLayer");
		nameByTag.put(TagFromName.OverlayDescriptorGray,"OverlayDescriptorGray");
		nameByTag.put(TagFromName.OverlayDescriptorRed,"OverlayDescriptorRed");
		nameByTag.put(TagFromName.OverlayDescriptorGreen,"OverlayDescriptorGreen");
		nameByTag.put(TagFromName.OverlayDescriptorBlue,"OverlayDescriptorBlue");
		nameByTag.put(TagFromName.OverlayGray,"OverlayGray");
		nameByTag.put(TagFromName.OverlayRed,"OverlayRed");
		nameByTag.put(TagFromName.OverlayGreen,"OverlayGreen");
		nameByTag.put(TagFromName.OverlayBlue,"OverlayBlue");
		nameByTag.put(TagFromName.ROIArea,"ROIArea");
		nameByTag.put(TagFromName.ROIMean,"ROIMean");
		nameByTag.put(TagFromName.ROIStandardDeviation,"ROIStandardDeviation");
		nameByTag.put(TagFromName.OverlayLabel,"OverlayLabel");
		nameByTag.put(TagFromName.OverlayData,"OverlayData");
		nameByTag.put(TagFromName.OverlayComments,"OverlayComments");
		nameByTag.put(TagFromName.PixelData,"PixelData");
		nameByTag.put(TagFromName.CoefficientsSDVN,"CoefficientsSDVN");
		nameByTag.put(TagFromName.CoefficientsSDHN,"CoefficientsSDHN");
		nameByTag.put(TagFromName.CoefficientsSDDN,"CoefficientsSDDN");
		nameByTag.put(TagFromName.VariablePixelData,"VariablePixelData");
		nameByTag.put(TagFromName.VariableNextDataGroup,"VariableNextDataGroup");
		nameByTag.put(TagFromName.VariableCoefficientsSDVN,"VariableCoefficientsSDVN");
		nameByTag.put(TagFromName.VariableCoefficientsSDHN,"VariableCoefficientsSDHN");
		nameByTag.put(TagFromName.VariableCoefficientsSDDN,"VariableCoefficientsSDDN");
		nameByTag.put(TagFromName.DigitalSignaturesSequence,"DigitalSignaturesSequence");
		nameByTag.put(TagFromName.DataSetTrailingPadding,"DataSetTrailingPadding");
	}
	protected void createFullNameByTag() {

		fullNameByTag = new HashMap(100);

		fullNameByTag.put(TagFromName.CommandGroupLength,"Command Group Length");
		fullNameByTag.put(TagFromName.CommandLengthToEnd,"Command Length to End");
		fullNameByTag.put(TagFromName.AffectedSOPClassUID,"Affected SOP Class UID");
		fullNameByTag.put(TagFromName.RequestedSOPClassUID,"Requested SOP Class UID");
		fullNameByTag.put(TagFromName.CommandRecognitionCode,"Command Recognition Code");
		fullNameByTag.put(TagFromName.CommandField,"Command Field");
		fullNameByTag.put(TagFromName.MessageID,"Message ID");
		fullNameByTag.put(TagFromName.MessageIDBeingRespondedTo,"Message ID Being Responded To");
		fullNameByTag.put(TagFromName.Initiator,"Initiator");
		fullNameByTag.put(TagFromName.Receiver,"Receiver");
		fullNameByTag.put(TagFromName.FindLocation,"Find Location");
		fullNameByTag.put(TagFromName.MoveDestination,"Move Destination");
		fullNameByTag.put(TagFromName.Priority,"Priority");
		fullNameByTag.put(TagFromName.DataSetType,"Data Set Type");
		fullNameByTag.put(TagFromName.NumberOfMatches,"Number of Matches");
		fullNameByTag.put(TagFromName.ResponseSequenceNumber,"Response Sequence Number");
		fullNameByTag.put(TagFromName.Status,"Status");
		fullNameByTag.put(TagFromName.OffendingElement,"Offending Element");
		fullNameByTag.put(TagFromName.ErrorComment,"Error Comment");
		fullNameByTag.put(TagFromName.ErrorID,"Error ID");
		fullNameByTag.put(TagFromName.AffectedSOPInstanceUID,"Affected SOP Instance UID");
		fullNameByTag.put(TagFromName.RequestedSOPInstanceUID,"Requested SOP Instance UID");
		fullNameByTag.put(TagFromName.EventTypeID,"Event Type ID");
		fullNameByTag.put(TagFromName.AttributeIdentifierList,"Attribute Identifier List");
		fullNameByTag.put(TagFromName.ActionTypeID,"Action Type ID");
		fullNameByTag.put(TagFromName.NumberOfRemainingSuboperations,"Number of Remaining Suboperations");
		fullNameByTag.put(TagFromName.NumberOfCompletedSuboperations,"Number of Completed Suboperations");
		fullNameByTag.put(TagFromName.NumberOfFailedSuboperations,"Number of Failed Suboperations");
		fullNameByTag.put(TagFromName.NumberOfWarningSuboperations,"Number of Warning Suboperations");
		fullNameByTag.put(TagFromName.MoveOriginatorApplicationEntityTitle,"Move Originator Application Entity Title");
		fullNameByTag.put(TagFromName.MoveOriginatorMessageID,"Move Originator Message ID");
		fullNameByTag.put(TagFromName.DialogReceiver,"Dialog Receiver");
		fullNameByTag.put(TagFromName.TerminalType,"Terminal Type");
		fullNameByTag.put(TagFromName.MessageSetID,"Message Set ID");
		fullNameByTag.put(TagFromName.EndMessageSet,"End Message Set");
		fullNameByTag.put(TagFromName.DisplayFormat,"Display Format");
		fullNameByTag.put(TagFromName.PagePositionID,"Page Position ID");
		fullNameByTag.put(TagFromName.TextFormatID,"Text Format ID");
		fullNameByTag.put(TagFromName.NormalReverse,"Normal Reverse");
		fullNameByTag.put(TagFromName.AddGrayScale,"Add Gray Scale");
		fullNameByTag.put(TagFromName.Borders,"Borders");
		fullNameByTag.put(TagFromName.Copies,"Copies");
		fullNameByTag.put(TagFromName.OldMagnificationType,"Old Magnification Type");
		fullNameByTag.put(TagFromName.Erase,"Erase");
		fullNameByTag.put(TagFromName.Print,"Print");
		fullNameByTag.put(TagFromName.Overlays,"Overlays");
		fullNameByTag.put(TagFromName.FileMetaInformationGroupLength,"File Meta Information Group Length");
		fullNameByTag.put(TagFromName.FileMetaInformationVersion,"File Meta Information Version");
		fullNameByTag.put(TagFromName.MediaStorageSOPClassUID,"Media Storage SOP Class UID");
		fullNameByTag.put(TagFromName.MediaStorageSOPInstanceUID,"Media Storage SOP Instance UID");
		fullNameByTag.put(TagFromName.TransferSyntaxUID,"Transfer Syntax UID");
		fullNameByTag.put(TagFromName.ImplementationClassUID,"Implementation Class UID");
		fullNameByTag.put(TagFromName.ImplementationVersionName,"Implementation Version Name");
		fullNameByTag.put(TagFromName.SourceApplicationEntityTitle,"Source Application Entity Title");
		fullNameByTag.put(TagFromName.PrivateInformationCreatorUID,"Private Information Creator UID");
		fullNameByTag.put(TagFromName.PrivateInformation,"Private Information");
		fullNameByTag.put(TagFromName.FileSetID,"File Set ID");
		fullNameByTag.put(TagFromName.FileSetDescriptorFileID,"File Set Descriptor File ID");
		fullNameByTag.put(TagFromName.FileSetCharacterSet,"File Set Descriptor File Specific Character Set");
		fullNameByTag.put(TagFromName.RootDirectoryFirstRecord,"Root Directory Entity First Directory Record Offset");
		fullNameByTag.put(TagFromName.RootDirectoryLastRecord,"Root Directory Entity Last Directory Record Offset");
		fullNameByTag.put(TagFromName.FileSetConsistencyFlag,"File Set Consistency Flag");
		fullNameByTag.put(TagFromName.DirectoryRecordSequence,"Directory Record Sequence");
		fullNameByTag.put(TagFromName.NextDirectoryRecordOffset,"Next Directory Record Offset");
		fullNameByTag.put(TagFromName.RecordInUseFlag,"Record In Use Flag");
		fullNameByTag.put(TagFromName.LowerLevelDirectoryOffset,"Referenced Lower Level Directory Entity Offset");
		fullNameByTag.put(TagFromName.DirectoryRecordType,"Directory Record Type");
		fullNameByTag.put(TagFromName.PrivateRecordUID,"Private Record UID");
		fullNameByTag.put(TagFromName.ReferencedFileID,"Referenced File ID");
		fullNameByTag.put(TagFromName.MRDRDirectoryRecordOffset,"MRDR Directory Record Offset");
		fullNameByTag.put(TagFromName.ReferencedSOPClassUIDInFile,"Referenced SOP Class UID In File");
		fullNameByTag.put(TagFromName.ReferencedSOPInstanceUIDInFile,"Referenced SOP Instance UID In File");
		fullNameByTag.put(TagFromName.ReferencedTransferSyntaxUIDInFile,"Referenced Transfer Syntax UID In File");
		fullNameByTag.put(TagFromName.ReferencedRelatedGeneralSOPClassUIDInFile,"Referenced Related General SOP Class UID in File");
		fullNameByTag.put(TagFromName.NumberOfReferences,"Number of References");
		fullNameByTag.put(TagFromName.LengthToEnd,"Length to End");
		fullNameByTag.put(TagFromName.SpecificCharacterSet,"Specific Character Set");
		fullNameByTag.put(TagFromName.LanguageCodeSequence,"Language Code Sequence");
		fullNameByTag.put(TagFromName.ImageType,"Image Type");
		fullNameByTag.put(TagFromName.RecognitionCode,"Recognition Code");
		fullNameByTag.put(TagFromName.InstanceCreationDate,"Instance Creation Date");
		fullNameByTag.put(TagFromName.InstanceCreationTime,"Instance Creation Time");
		fullNameByTag.put(TagFromName.InstanceCreatorUID,"Instance Creator UID");
		fullNameByTag.put(TagFromName.SOPClassUID,"SOP Class UID");
		fullNameByTag.put(TagFromName.SOPInstanceUID,"SOP Instance UID");
		fullNameByTag.put(TagFromName.RelatedGeneralSOPClassUID,"Related General SOP Class UID");
		fullNameByTag.put(TagFromName.OriginalSpecializedSOPClassUID,"Original Specialized SOP Class UID");
		fullNameByTag.put(TagFromName.StudyDate,"Study Date");
		fullNameByTag.put(TagFromName.SeriesDate,"Series Date");
		fullNameByTag.put(TagFromName.AcquisitionDate,"Acquisition Date");
		fullNameByTag.put(TagFromName.ContentDate,"Content (formerly Image) Date");
		fullNameByTag.put(TagFromName.OverlayDate,"Overlay Date");
		fullNameByTag.put(TagFromName.CurveDate,"Curve Date");
		fullNameByTag.put(TagFromName.AcquisitionDateTime,"Acquisition Date Time");
		fullNameByTag.put(TagFromName.StudyTime,"Study Time");
		fullNameByTag.put(TagFromName.SeriesTime,"Series Time");
		fullNameByTag.put(TagFromName.AcquisitionTime,"Acquisition Time");
		fullNameByTag.put(TagFromName.ContentTime,"Content (formerly Image) Time");
		fullNameByTag.put(TagFromName.OverlayTime,"Overlay Time");
		fullNameByTag.put(TagFromName.CurveTime,"Curve Time");
		fullNameByTag.put(TagFromName.OldDataSetType,"Old Data Set Type");
		fullNameByTag.put(TagFromName.OldDataSetSubtype,"Old Data Set Subtype");
		fullNameByTag.put(TagFromName.NuclearMedicineSeriesTypeRetired,"Nuclear Medicine Series Type (Retired)");
		fullNameByTag.put(TagFromName.AccessionNumber,"Accession Number");
		fullNameByTag.put(TagFromName.IssuerOfAccessionNumberSequence,"Issuer of Accession Number Sequence");
		fullNameByTag.put(TagFromName.QueryRetrieveLevel,"Query/Retrieve Level");
		fullNameByTag.put(TagFromName.RetrieveAETitle,"Retrieve AE Title");
		fullNameByTag.put(TagFromName.InstanceAvailability,"Instance Availability");
		fullNameByTag.put(TagFromName.FailedSOPInstanceUIDList,"Failed SOP Instance UID List");
		fullNameByTag.put(TagFromName.Modality,"Modality");
		fullNameByTag.put(TagFromName.ModalitiesInStudy,"Modalities in Study");
		fullNameByTag.put(TagFromName.SOPClassesInStudy,"SOP Classes in Study");
		fullNameByTag.put(TagFromName.ConversionType,"Conversion Type");
		fullNameByTag.put(TagFromName.PresentationIntentType,"Presentation Intent Type");
		fullNameByTag.put(TagFromName.Manufacturer,"Manufacturer");
		fullNameByTag.put(TagFromName.InstitutionName,"Institution Name");
		fullNameByTag.put(TagFromName.InstitutionAddress,"Institution Address");
		fullNameByTag.put(TagFromName.InstitutionCodeSequence,"Institution Code Sequence");
		fullNameByTag.put(TagFromName.ReferringPhysicianName,"Referring Physician's Name");
		fullNameByTag.put(TagFromName.ReferringPhysicianAddress,"Referring Physician's Address");
		fullNameByTag.put(TagFromName.ReferringPhysicianTelephoneNumber,"Referring Physician's Telephone Numbers");
		fullNameByTag.put(TagFromName.ReferringPhysicianIdentificationSequence,"Referring Physician Identification Sequence");
		fullNameByTag.put(TagFromName.CodeValue,"Code Value");
		fullNameByTag.put(TagFromName.CodingSchemeDesignator,"Coding Scheme Designator");
		fullNameByTag.put(TagFromName.CodingSchemeVersion,"Coding Scheme Version");
		fullNameByTag.put(TagFromName.CodeMeaning,"Code Meaning");
		fullNameByTag.put(TagFromName.MappingResource,"Mapping Resource");
		fullNameByTag.put(TagFromName.ContextGroupVersion,"Context Group Version");
		fullNameByTag.put(TagFromName.ContextGroupLocalVersion,"Context Group Local Version");
		fullNameByTag.put(TagFromName.ContextGroupExtensionFlag,"Context Group Extension Flag");
		fullNameByTag.put(TagFromName.CodingSchemeUID,"Coding Scheme UID");
		fullNameByTag.put(TagFromName.ContextGroupExtensionCreatorUID,"Context Group Extension Creator UID");
		fullNameByTag.put(TagFromName.ContextIdentifier,"Context Identifier");
		fullNameByTag.put(TagFromName.CodingSchemeIdentificationSequence,"Coding Scheme Identification Sequence");
		fullNameByTag.put(TagFromName.CodingSchemeRegistry,"Coding Scheme Registry");
		fullNameByTag.put(TagFromName.CodingSchemeExternalID,"Coding Scheme External ID");
		fullNameByTag.put(TagFromName.CodingSchemeName,"Coding Scheme Name");
		fullNameByTag.put(TagFromName.CodingSchemeResponsibleOrganization,"Coding Scheme Responsible Organization");
		fullNameByTag.put(TagFromName.ContextUID,"Context UID");
		fullNameByTag.put(TagFromName.TimezoneOffsetFromUTC,"Timezone Offset From UTC");
		fullNameByTag.put(TagFromName.NetworkID,"Network ID");
		fullNameByTag.put(TagFromName.StationName,"Station Name");
		fullNameByTag.put(TagFromName.StudyDescription,"Study Description");
		fullNameByTag.put(TagFromName.ProcedureCodeSequence,"Procedure Code Sequence");
		fullNameByTag.put(TagFromName.SeriesDescription,"Series Description");
		fullNameByTag.put(TagFromName.InstitutionalDepartmentName,"Institutional Department Name");
		fullNameByTag.put(TagFromName.PhysicianOfRecord,"Physician of Record");
		fullNameByTag.put(TagFromName.PhysicianOfRecordIdentificationSequence,"Physician(s) of Record Identification Sequence");
		fullNameByTag.put(TagFromName.PerformingPhysicianName,"Performing Physician's Name");
		fullNameByTag.put(TagFromName.PerformingPhysicianIdentificationSequence,"Performing Physician Identification Sequence");
		fullNameByTag.put(TagFromName.PhysicianReadingStudy,"Name of Physician(s) Reading Study");
		fullNameByTag.put(TagFromName.PhysicianReadingStudyIdentificationSequence,"Physician(s) Reading Study Identification Sequence");
		fullNameByTag.put(TagFromName.OperatorName,"Operators' Name");
		fullNameByTag.put(TagFromName.OperatorIdentificationSequence,"Operator Identification Sequence");
		fullNameByTag.put(TagFromName.AdmittingDiagnosesDescription,"Admitting Diagnoses Description");
		fullNameByTag.put(TagFromName.AdmittingDiagnosesCodeSequence,"Admitting Diagnoses Code Sequence");
		fullNameByTag.put(TagFromName.ManufacturerModelName,"Manufacturer's Model Name");
		fullNameByTag.put(TagFromName.ReferencedResultsSequence,"Referenced Results Sequence");
		fullNameByTag.put(TagFromName.ReferencedStudySequence,"Referenced Study Sequence");
		fullNameByTag.put(TagFromName.ReferencedPerformedProcedureStepSequence,"Referenced Performed Procedure Step Sequence");
		fullNameByTag.put(TagFromName.ReferencedSeriesSequence,"Referenced Series Sequence");
		fullNameByTag.put(TagFromName.ReferencedPatientSequence,"Referenced Patient Sequence");
		fullNameByTag.put(TagFromName.ReferencedVisitSequence,"Referenced Visit Sequence");
		fullNameByTag.put(TagFromName.ReferencedOverlaySequence,"Referenced Overlay Sequence");
		fullNameByTag.put(TagFromName.ReferencedStereometricInstanceSequence,"Referenced Stereometric Instance Sequence");
		fullNameByTag.put(TagFromName.ReferencedWaveformSequence,"Referenced Waveform Sequence");
		fullNameByTag.put(TagFromName.ReferencedImageSequence,"Referenced Image Sequence");
		fullNameByTag.put(TagFromName.ReferencedCurveSequence,"Referenced Curve Sequence");
		fullNameByTag.put(TagFromName.ReferencedInstanceSequence,"Referenced Instance Sequence");
		fullNameByTag.put(TagFromName.ReferencedRealWorldValueMappingInstanceSequence,"Referenced Real World Value Mapping Instance Sequence");
		fullNameByTag.put(TagFromName.ReferencedSOPClassUID,"Referenced SOP Class UID");
		fullNameByTag.put(TagFromName.ReferencedSOPInstanceUID,"Referenced SOP Instance UID");
		fullNameByTag.put(TagFromName.SOPClassesSupported,"SOP Classes Supported");
		fullNameByTag.put(TagFromName.ReferencedFrameNumber,"Referenced Frame Number");
		fullNameByTag.put(TagFromName.TransactionUID,"Transaction UID");
		fullNameByTag.put(TagFromName.FailureReason,"Failure Reason");
		fullNameByTag.put(TagFromName.FailedSOPSequence,"Failed SOP Sequence");
		fullNameByTag.put(TagFromName.ReferencedSOPSequence,"Referenced SOP Sequence");
		fullNameByTag.put(TagFromName.StudiesContainingOtherReferencedInstancesSequence,"Studies Containing Other Referenced Instances Sequence");
		fullNameByTag.put(TagFromName.RelatedSeriesSequence,"Related Series Sequence");
		fullNameByTag.put(TagFromName.OldLossyImageCompression,"Old Lossy Image Compression");
		fullNameByTag.put(TagFromName.DerivationDescription,"Derivation Description");
		fullNameByTag.put(TagFromName.SourceImageSequence,"Source Image Sequence");
		fullNameByTag.put(TagFromName.StageName,"Stage Name");
		fullNameByTag.put(TagFromName.StageNumber,"Stage Number");
		fullNameByTag.put(TagFromName.NumberOfStages,"Number of Stages");
		fullNameByTag.put(TagFromName.ViewName,"View Name");
		fullNameByTag.put(TagFromName.ViewNumber,"View Number");
		fullNameByTag.put(TagFromName.NumberOfEventTimers,"Number of Event Timers");
		fullNameByTag.put(TagFromName.NumberOfViewsInStage,"Number of Views in Stage");
		fullNameByTag.put(TagFromName.EventElapsedTime,"Event Elapsed Time(s)");
		fullNameByTag.put(TagFromName.EventTimerName,"Event Timer Name(s)");
		fullNameByTag.put(TagFromName.EventTimerSequence,"Event Timer Sequence");
		fullNameByTag.put(TagFromName.EventTimeOffset,"Event Time Offset");
		fullNameByTag.put(TagFromName.EventCodeSequence,"Event Code Sequence");
		fullNameByTag.put(TagFromName.StartTrim,"Start Trim");
		fullNameByTag.put(TagFromName.StopTrim,"Stop Trim");
		fullNameByTag.put(TagFromName.RecommendedDisplayFrameRate,"Recommended Display Frame Rate");
		fullNameByTag.put(TagFromName.TransducerPosition,"Transducer Position");
		fullNameByTag.put(TagFromName.TransducerOrientation,"Transducer Orientation");
		fullNameByTag.put(TagFromName.AnatomicStructure,"Anatomic Structure");
		fullNameByTag.put(TagFromName.AnatomicRegionSequence,"Anatomic Region Sequence");
		fullNameByTag.put(TagFromName.AnatomicRegionModifierSequence,"Anatomic Region Modifier Sequence");
		fullNameByTag.put(TagFromName.PrimaryAnatomicStructureSequence,"Primary Anatomic Structure Sequence");
		fullNameByTag.put(TagFromName.AnatomicStructureSpaceOrRegionSequence,"Anatomic Structure, Space or Region Sequence");
		fullNameByTag.put(TagFromName.PrimaryAnatomicStructureModifierSequence,"Primary Anatomic Structure Modifier Sequence");
		fullNameByTag.put(TagFromName.TransducerPositionSequence,"Transducer Position Sequence");
		fullNameByTag.put(TagFromName.TransducerPositionModifierSequence,"Transducer Position Modifier Sequence");
		fullNameByTag.put(TagFromName.TransducerOrientationSequence,"Transducer Orientation Sequence");
		fullNameByTag.put(TagFromName.TransducerOrientationModifierSequence,"Transducer Orientation Modifier Sequence");
		fullNameByTag.put(TagFromName.AnatomicStructureSpaceOrRegionCodeSequenceTrial,"Anatomic Structure Space Or Region Code Sequence (Trial)");
		fullNameByTag.put(TagFromName.AnatomicPortalOfEntranceCodeSequenceTrial,"Anatomic Portal Of Entrance Code Sequence (Trial)");
		fullNameByTag.put(TagFromName.AnatomicApproachDirectionCodeSequenceTrial,"Anatomic Approach Direction Code Sequence (Trial)");
		fullNameByTag.put(TagFromName.AnatomicPerspectiveDescriptionTrial,"Anatomic Perspective Description (Trial)");
		fullNameByTag.put(TagFromName.AnatomicPerspectiveCodeSequenceTrial,"Anatomic Perspective Code Sequence (Trial)");
		fullNameByTag.put(TagFromName.AnatomicLocationOfExaminingInstrumentDescriptionTrial,"Anatomic Location Of Examining Instrument Description (Trial)");
		fullNameByTag.put(TagFromName.AnatomicLocationOfExaminingInstrumentCodeSequenceTrial,"Anatomic Location Of Examining Instrument Code Sequence (Trial)");
		fullNameByTag.put(TagFromName.AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial,"Anatomic Structure Space Or Region Modifier Code Sequence (Trial)");
		fullNameByTag.put(TagFromName.OnAxisBackgroundAnatomicStructureCodeSequenceTrial,"OnAxis Background Anatomic Structure Code Sequence (Trial)");
		fullNameByTag.put(TagFromName.AlternateRepresentationSequence,"Alternate Representation Sequence");
		fullNameByTag.put(TagFromName.IrradiationEventUID,"Irradiation Event UID");
		fullNameByTag.put(TagFromName.IdentifyingComments,"Identifying Comments");
		fullNameByTag.put(TagFromName.FrameType,"Frame Type");
		fullNameByTag.put(TagFromName.ReferencedImageEvidenceSequence,"Referenced Image Evidence Sequence");
		fullNameByTag.put(TagFromName.ReferencedRawDataSequence,"Referenced Raw Data Sequence");
		fullNameByTag.put(TagFromName.CreatorVersionUID,"Creator-Version UID");
		fullNameByTag.put(TagFromName.DerivationImageSequence,"Derivation Image Sequence");
		fullNameByTag.put(TagFromName.SourceImageEvidenceSequence,"Source Image Evidence Sequence");
		fullNameByTag.put(TagFromName.PixelPresentation,"Pixel Presentation");
		fullNameByTag.put(TagFromName.VolumetricProperties,"Volumetric Properties");
		fullNameByTag.put(TagFromName.VolumeBasedCalculationTechnique,"Volume Based Calculation Technique");
		fullNameByTag.put(TagFromName.ComplexImageComponent,"Complex Image Component");
		fullNameByTag.put(TagFromName.AcquisitionContrast,"Acquisition Contrast");
		fullNameByTag.put(TagFromName.DerivationCodeSequence,"Derivation Code Sequence");
		fullNameByTag.put(TagFromName.ReferencedPresentationStateSequence,"Referenced Presentation State Sequence");
		fullNameByTag.put(TagFromName.ReferencedOtherPlaneSequence,"Referenced Other Plane Sequence");
		fullNameByTag.put(TagFromName.FrameDisplaySequence,"Frame Display Sequence");
		fullNameByTag.put(TagFromName.RecommendedDisplayFrameRateInFloat,"Recommended Display Frame Rate in Float");
		fullNameByTag.put(TagFromName.SkipFrameRangeFlag,"Skip Frame Range Flag");
		fullNameByTag.put(TagFromName.PatientName,"Patient's Name");
		fullNameByTag.put(TagFromName.PatientID,"Patient's ID");
		fullNameByTag.put(TagFromName.IssuerOfPatientID,"Issuer of Patient's ID");
		fullNameByTag.put(TagFromName.TypeOfPatientID,"Type of Patient ID");
		fullNameByTag.put(TagFromName.IssuerOfPatientIDQualifiersSequence,"Issuer of Patient ID Qualifiers Sequence");
		fullNameByTag.put(TagFromName.PatientBirthDate,"Patient's Birth Date");
		fullNameByTag.put(TagFromName.PatientBirthTime,"Patient's Birth Time");
		fullNameByTag.put(TagFromName.PatientSex,"Patient's Sex");
		fullNameByTag.put(TagFromName.PatientInsurancePlanCodeSequence,"Patient's Insurance Plan Code Sequence");
		fullNameByTag.put(TagFromName.PatientPrimaryLanguageCodeSequence,"Patient's Primary Language Code Sequence");
		fullNameByTag.put(TagFromName.PatientPrimaryLanguageModifierCodeSequence,"Patient's Primary Language Modifier Code Sequence");
		fullNameByTag.put(TagFromName.OtherPatientID,"Other Patient's ID's");
		fullNameByTag.put(TagFromName.OtherPatientName,"Other Patient's Names");
		fullNameByTag.put(TagFromName.OtherPatientIDSequence,"Other Patient IDs Sequence");
		fullNameByTag.put(TagFromName.PatientBirthName,"Patient's Birth Name");
		fullNameByTag.put(TagFromName.PatientAge,"Patient's Age");
		fullNameByTag.put(TagFromName.PatientSize,"Patient's Size");
		fullNameByTag.put(TagFromName.PatientWeight,"Patient's Weight");
		fullNameByTag.put(TagFromName.PatientAddress,"Patient's Address");
		fullNameByTag.put(TagFromName.InsurancePlanIdentification,"Insurance Plan Identification");
		fullNameByTag.put(TagFromName.PatientMotherBirthName,"Patient's Mother's Birth Name");
		fullNameByTag.put(TagFromName.MilitaryRank,"Military Rank");
		fullNameByTag.put(TagFromName.BranchOfService,"Branch of Service");
		fullNameByTag.put(TagFromName.MedicalRecordLocator,"Medical Record Locator");
		fullNameByTag.put(TagFromName.MedicalAlerts,"Medical Alerts");
		fullNameByTag.put(TagFromName.Allergies,"Allergies");
		fullNameByTag.put(TagFromName.CountryOfResidence,"Country of Residence");
		fullNameByTag.put(TagFromName.RegionOfResidence,"Region of Residence");
		fullNameByTag.put(TagFromName.PatientTelephoneNumber,"Patient's Telephone Numbers");
		fullNameByTag.put(TagFromName.EthnicGroup,"Ethnic Group");
		fullNameByTag.put(TagFromName.Occupation,"Occupation");
		fullNameByTag.put(TagFromName.SmokingStatus,"Smoking Status");
		fullNameByTag.put(TagFromName.AdditionalPatientHistory,"Additional Patient History");
		fullNameByTag.put(TagFromName.PregnancyStatus,"Pregnancy Status");
		fullNameByTag.put(TagFromName.LastMenstrualDate,"Last Menstrual Date");
		fullNameByTag.put(TagFromName.PatientReligiousPreference,"Patient's Religious Preference");
		fullNameByTag.put(TagFromName.PatientSpeciesDescription,"Patient Species Description");
		fullNameByTag.put(TagFromName.PatientSpeciesCodeSequence,"Patient Species Code Sequence");
		fullNameByTag.put(TagFromName.PatientSexNeutered,"Patient's Sex Neutered");
		fullNameByTag.put(TagFromName.PatientBreedDescription,"Patient Breed Description");
		fullNameByTag.put(TagFromName.PatientBreedCodeSequence,"Patient Breed Code Sequence");
		fullNameByTag.put(TagFromName.BreedRegistrationSequence,"Breed Registration Sequence");
		fullNameByTag.put(TagFromName.BreedRegistrationNumber,"Breed Registration Number");
		fullNameByTag.put(TagFromName.BreedRegistryCodeSequence,"Breed Registry Code Sequence");
		fullNameByTag.put(TagFromName.ResponsiblePerson,"Responsible Person");
		fullNameByTag.put(TagFromName.ResponsiblePersonRole,"Responsible Person Role");
		fullNameByTag.put(TagFromName.ResponsibleOrganization,"Responsible Organization");
		fullNameByTag.put(TagFromName.PatientComments,"Patient Comments");
		fullNameByTag.put(TagFromName.ExaminedBodyThickness,"ExaminedBodyThickness");
		fullNameByTag.put(TagFromName.ClinicalTrialSponsorName,"Clinical Trial Sponsor Name");
		fullNameByTag.put(TagFromName.ClinicalTrialProtocolID,"Clinical Trial Protocol ID");
		fullNameByTag.put(TagFromName.ClinicalTrialProtocolName,"Clinical Trial Protocol Name");
		fullNameByTag.put(TagFromName.ClinicalTrialSiteID,"Clinical Trial Site ID");
		fullNameByTag.put(TagFromName.ClinicalTrialSiteName,"Clinical Trial Site Name");
		fullNameByTag.put(TagFromName.ClinicalTrialSubjectID,"Clinical Trial Subject ID");
		fullNameByTag.put(TagFromName.ClinicalTrialSubjectReadingID,"Clinical Trial Subject Reading ID");
		fullNameByTag.put(TagFromName.ClinicalTrialTimePointID,"Clinical Trial Time Point ID");
		fullNameByTag.put(TagFromName.ClinicalTrialTimePointDescription,"Clinical Trial Time Point Description");
		fullNameByTag.put(TagFromName.ClinicalTrialCoordinatingCenterName,"Clinical Trial Coordinating Center Name");
		fullNameByTag.put(TagFromName.PatientIdentityRemoved,"Patient Identity Removed");
		fullNameByTag.put(TagFromName.DeidentificationMethod,"De-identification Method");
		fullNameByTag.put(TagFromName.DeidentificationMethodCodeSequence,"De-identification Method Code Sequence");
		fullNameByTag.put(TagFromName.ClinicalTrialSeriesID,"Clinical Trial Series ID");
		fullNameByTag.put(TagFromName.ClinicalTrialSeriesDescription,"Clinical Trial Series Description");
		fullNameByTag.put(TagFromName.ClinicalTrialProtocolEthicsCommitteeName,"Clinical Trial Protocol Ethics Committee Name");
		fullNameByTag.put(TagFromName.ClinicalTrialProtocolEthicsCommitteeApprovalNumber,"Clinical Trial Protocol Ethics Committee Approval Number");
		fullNameByTag.put(TagFromName.ConsentForClinicalTrialUseSequence,"Consent for Clinical Trial Use Sequence");
		fullNameByTag.put(TagFromName.DistributionType,"Distribution Type");
		fullNameByTag.put(TagFromName.ConsentForDistributionFlag,"Consent for Distribution Flag");
		fullNameByTag.put(TagFromName.ContrastBolusAgent,"Contrast/Bolus Agent");
		fullNameByTag.put(TagFromName.ContrastBolusAgentSequence,"Contrast/Bolus Agent Sequence");
		fullNameByTag.put(TagFromName.ContrastBolusAdministrationRouteSequence,"Contrast/Bolus Administration Route Sequence");
		fullNameByTag.put(TagFromName.BodyPartExamined,"Body Part Examined");
		fullNameByTag.put(TagFromName.ScanningSequence,"Scanning Sequence");
		fullNameByTag.put(TagFromName.SequenceVariant,"Sequence Variant");
		fullNameByTag.put(TagFromName.ScanOptions,"Scan Options");
		fullNameByTag.put(TagFromName.MRAcquisitionType,"MR Acquisition Type");
		fullNameByTag.put(TagFromName.SequenceName,"Sequence Name");
		fullNameByTag.put(TagFromName.AngioFlag,"Angio Flag");
		fullNameByTag.put(TagFromName.InterventionDrugInformationSequence,"Intervention Drug Information Sequence");
		fullNameByTag.put(TagFromName.InterventionDrugStopTime,"Intervention Drug Stop Time");
		fullNameByTag.put(TagFromName.InterventionDrugDose,"Intervention Drug Dose");
		fullNameByTag.put(TagFromName.InterventionDrugCodeSequence,"Intervention Drug Code Sequence");
		fullNameByTag.put(TagFromName.AdditionalDrugSequence,"Additional Drug Sequence");
		fullNameByTag.put(TagFromName.Radionuclide,"Radionuclide");
		fullNameByTag.put(TagFromName.Radiopharmaceutical,"Radiopharmaceutical");
		fullNameByTag.put(TagFromName.EnergyWindowCenterline,"Energy Window Centerline");
		fullNameByTag.put(TagFromName.EnergyWindowTotalWidth,"Energy Window Total Width");
		fullNameByTag.put(TagFromName.InterventionDrugName,"Intervention Drug Name");
		fullNameByTag.put(TagFromName.InterventionDrugStartTime,"Intervention Drug Start Time");
		fullNameByTag.put(TagFromName.InterventionSequence,"Intervention Sequence");
		fullNameByTag.put(TagFromName.TherapyType,"Therapy Type");
		fullNameByTag.put(TagFromName.InterventionStatus,"Intervention Status");
		fullNameByTag.put(TagFromName.TherapyDescription,"Therapy Description");
		fullNameByTag.put(TagFromName.InterventionDescription,"Intervention Description");
		fullNameByTag.put(TagFromName.CineRate,"Cine Rate");
		fullNameByTag.put(TagFromName.InitialCineRunState,"Initial Cine Run State");
		fullNameByTag.put(TagFromName.SliceThickness,"Slice Thickness");
		fullNameByTag.put(TagFromName.KVP,"KVP");
		fullNameByTag.put(TagFromName.CountsAccumulated,"Counts Accumulated");
		fullNameByTag.put(TagFromName.AcquisitionTerminationCondition,"Acquisition Termination Condition");
		fullNameByTag.put(TagFromName.EffectiveDuration,"Effective Duration");
		fullNameByTag.put(TagFromName.AcquisitionStartCondition,"Acquisition Start Condition");
		fullNameByTag.put(TagFromName.AcquisitionStartConditionData,"Acquisition Start Condition Data");
		fullNameByTag.put(TagFromName.AcquisitionTerminationConditionData,"Acquisition Termination Condition Data");
		fullNameByTag.put(TagFromName.RepetitionTime,"Repetition Time");
		fullNameByTag.put(TagFromName.EchoTime,"Echo Time");
		fullNameByTag.put(TagFromName.InversionTime,"Inversion Time");
		fullNameByTag.put(TagFromName.NumberOfAverages,"Number of Averages");
		fullNameByTag.put(TagFromName.ImagingFrequency,"Imaging Frequency");
		fullNameByTag.put(TagFromName.ImagedNucleus,"Imaged Nucleus");
		fullNameByTag.put(TagFromName.EchoNumber,"Echo Number(s)");
		fullNameByTag.put(TagFromName.MagneticFieldStrength,"Magnetic Field Strength");
		fullNameByTag.put(TagFromName.SpacingBetweenSlices,"Spacing Between Slices");
		fullNameByTag.put(TagFromName.NumberOfPhaseEncodingSteps,"Number of Phase Encoding Steps");
		fullNameByTag.put(TagFromName.DataCollectionDiameter,"Data Collection Diameter");
		fullNameByTag.put(TagFromName.EchoTrainLength,"Echo Train Length");
		fullNameByTag.put(TagFromName.PercentSampling,"Percent Sampling");
		fullNameByTag.put(TagFromName.PercentPhaseFieldOfView,"Percent Phase Field of View");
		fullNameByTag.put(TagFromName.PixelBandwidth,"Pixel Bandwidth");
		fullNameByTag.put(TagFromName.DeviceSerialNumber,"Device Serial Number");
		fullNameByTag.put(TagFromName.DeviceUID,"Device UID");
		fullNameByTag.put(TagFromName.PlateID,"Plate ID");
		fullNameByTag.put(TagFromName.GeneratorID,"Generator ID");
		fullNameByTag.put(TagFromName.GridID,"Grid ID");
		fullNameByTag.put(TagFromName.CassetteID,"Cassette ID");
		fullNameByTag.put(TagFromName.GantryID,"Gantry ID");
		fullNameByTag.put(TagFromName.SecondaryCaptureDeviceID,"Secondary Capture Device ID");
		fullNameByTag.put(TagFromName.HardcopyCreationDeviceID,"Hardcopy Creation Device ID");
		fullNameByTag.put(TagFromName.DateOfSecondaryCapture,"Date of Secondary Capture");
		fullNameByTag.put(TagFromName.TimeOfSecondaryCapture,"Time of Secondary Capture");
		fullNameByTag.put(TagFromName.SecondaryCaptureDeviceManufacturer,"Secondary Capture Device Manufacturer");
		fullNameByTag.put(TagFromName.HardcopyDeviceManufacturer,"Hardcopy Device Manufacturer");
		fullNameByTag.put(TagFromName.SecondaryCaptureDeviceManufacturerModelName,"Secondary Capture Device Manufacturer's Model Name");
		fullNameByTag.put(TagFromName.SecondaryCaptureDeviceSoftwareVersion,"Secondary Capture Device Software Version(s)");
		fullNameByTag.put(TagFromName.HardcopyDeviceSoftwareVersion,"Hardcopy Device Software Version");
		fullNameByTag.put(TagFromName.HardcopyDeviceManufacturerModelName,"Hardcopy Device Manufacturer's Model Name");
		fullNameByTag.put(TagFromName.SoftwareVersion,"Software Version(s)");
		fullNameByTag.put(TagFromName.VideoImageFormatAcquired,"Video Image Format Acquired");
		fullNameByTag.put(TagFromName.DigitalImageFormatAcquired,"Digital Image Format Acquired");
		fullNameByTag.put(TagFromName.ProtocolName,"Protocol Name");
		fullNameByTag.put(TagFromName.ContrastBolusRoute,"Contrast/Bolus Route");
		fullNameByTag.put(TagFromName.ContrastBolusVolume,"Contrast/Bolus Volume");
		fullNameByTag.put(TagFromName.ContrastBolusStartTime,"Contrast/Bolus Start Time");
		fullNameByTag.put(TagFromName.ContrastBolusStopTime,"Contrast/Bolus Stop Time");
		fullNameByTag.put(TagFromName.ContrastBolusTotalDose,"Contrast/Bolus Total Dose");
		fullNameByTag.put(TagFromName.SyringeCounts,"Syringe Counts");
		fullNameByTag.put(TagFromName.ContrastFlowRate,"Contrast Flow Rate");
		fullNameByTag.put(TagFromName.ContrastFlowDuration,"Contrast Flow Duration");
		fullNameByTag.put(TagFromName.ContrastBolusIngredient,"Contrast/Bolus Ingredient");
		fullNameByTag.put(TagFromName.ContrastBolusIngredientConcentration,"Contrast/Bolus Ingredient Concentration");
		fullNameByTag.put(TagFromName.SpatialResolution,"Spatial Resolution");
		fullNameByTag.put(TagFromName.TriggerTime,"Trigger Time");
		fullNameByTag.put(TagFromName.TriggerSourceOrType,"Trigger Source or Type");
		fullNameByTag.put(TagFromName.NominalInterval,"Nominal Interval");
		fullNameByTag.put(TagFromName.FrameTime,"Frame Time");
		fullNameByTag.put(TagFromName.CardiacFramingType,"Cardiac Framing Type");
		fullNameByTag.put(TagFromName.FrameTimeVector,"Frame Time Vector");
		fullNameByTag.put(TagFromName.FrameDelay,"Frame Delay");
		fullNameByTag.put(TagFromName.ImageTriggerDelay,"Image Trigger Delay");
		fullNameByTag.put(TagFromName.MultiplexGroupTimeOffset,"Multiplex Group Time Offset");
		fullNameByTag.put(TagFromName.TriggerTimeOffset,"Trigger Time Offset");
		fullNameByTag.put(TagFromName.SynchronizationTrigger,"Synchronization Trigger");
		fullNameByTag.put(TagFromName.SynchronizationChannel,"Synchronization Channel");
		fullNameByTag.put(TagFromName.TriggerSamplePosition,"Trigger Sample Position");
		fullNameByTag.put(TagFromName.RadiopharmaceuticalRoute,"Radiopharmaceutical Route");
		fullNameByTag.put(TagFromName.RadiopharmaceuticalVolume,"Radiopharmaceutical Volume");
		fullNameByTag.put(TagFromName.RadiopharmaceuticalStartTime,"Radiopharmaceutical Start Time");
		fullNameByTag.put(TagFromName.RadiopharmaceuticalStopTime,"Radiopharmaceutical Stop Time");
		fullNameByTag.put(TagFromName.RadionuclideTotalDose,"Radionuclide Total Dose");
		fullNameByTag.put(TagFromName.RadionuclideHalfLife,"Radionuclide Half Life");
		fullNameByTag.put(TagFromName.RadionuclidePositronFraction,"Radionuclide Positron Fraction");
		fullNameByTag.put(TagFromName.RadiopharmaceuticalSpecificActivity,"Radiopharmaceutical Specific Activity");
		fullNameByTag.put(TagFromName.RadiopharmaceuticalStartDateTime,"Radiopharmaceutical Start DateTime");
		fullNameByTag.put(TagFromName.RadiopharmaceuticalStopDateTime,"Radiopharmaceutical Stop DateTime");
		fullNameByTag.put(TagFromName.BeatRejectionFlag,"Beat Rejection Flag");
		fullNameByTag.put(TagFromName.LowRRValue,"Low R-R Value");
		fullNameByTag.put(TagFromName.HighRRValue,"High R-R Value");
		fullNameByTag.put(TagFromName.IntervalsAcquired,"Intervals Acquired");
		fullNameByTag.put(TagFromName.IntervalsRejected,"Intervals Rejected");
		fullNameByTag.put(TagFromName.PVCRejection,"PVC Rejection");
		fullNameByTag.put(TagFromName.SkipBeats,"Skip Beats");
		fullNameByTag.put(TagFromName.HeartRate,"Heart Rate");
		fullNameByTag.put(TagFromName.CardiacNumberOfImages,"Cardiac Number of Images");
		fullNameByTag.put(TagFromName.TriggerWindow,"Trigger Window");
		fullNameByTag.put(TagFromName.ReconstructionDiameter,"Reconstruction Diameter");
		fullNameByTag.put(TagFromName.DistanceSourceToDetector,"Distance Source to Detector");
		fullNameByTag.put(TagFromName.DistanceSourceToPatient,"Distance Source to Patient");
		fullNameByTag.put(TagFromName.EstimatedRadiographicMagnificationFactor,"Estimated Radiographic Magnification Factor");
		fullNameByTag.put(TagFromName.GantryDetectorTilt,"Gantry/Detector Tilt");
		fullNameByTag.put(TagFromName.GantryDetectorSlew,"Gantry/Detector Slew");
		fullNameByTag.put(TagFromName.TableHeight,"Table Height");
		fullNameByTag.put(TagFromName.TableTraverse,"Table Traverse");
		fullNameByTag.put(TagFromName.TableMotion,"Table Motion");
		fullNameByTag.put(TagFromName.TableVerticalIncrement,"Table Vertical Increment");
		fullNameByTag.put(TagFromName.TableLateralIncrement,"Table Lateral Increment");
		fullNameByTag.put(TagFromName.TableLongitudinalIncrement,"Table Longitudinal Increment");
		fullNameByTag.put(TagFromName.TableAngle,"Table Angle");
		fullNameByTag.put(TagFromName.TableType,"Table Type");
		fullNameByTag.put(TagFromName.RotationDirection,"Rotation Direction");
		fullNameByTag.put(TagFromName.AngularPosition,"Angular Position");
		fullNameByTag.put(TagFromName.RadialPosition,"Radial Position");
		fullNameByTag.put(TagFromName.ScanArc,"Scan Arc");
		fullNameByTag.put(TagFromName.AngularStep,"Angular Step");
		fullNameByTag.put(TagFromName.CenterOfRotationOffset,"Center of Rotation Offset");
		fullNameByTag.put(TagFromName.RotationOffset,"Rotation Offset");
		fullNameByTag.put(TagFromName.FieldOfViewShape,"Field of View Shape");
		fullNameByTag.put(TagFromName.FieldOfViewDimensions,"Field of View Dimension(s)");
		fullNameByTag.put(TagFromName.ExposureTime,"Exposure Time");
		fullNameByTag.put(TagFromName.XRayTubeCurrent,"X-Ray Tube Current");
		fullNameByTag.put(TagFromName.Exposure,"Exposure");
		fullNameByTag.put(TagFromName.ExposureInuAs,"Exposure in uAs");
		fullNameByTag.put(TagFromName.AveragePulseWidth,"Average Pulse Width");
		fullNameByTag.put(TagFromName.RadiationSetting,"Radiation Setting");
		fullNameByTag.put(TagFromName.RectificationType,"Rectification Type");
		fullNameByTag.put(TagFromName.RadiationMode,"Radiation Mode");
		fullNameByTag.put(TagFromName.ImageAndFluoroscopyAreaDoseProduct,"Image and Fluoroscopy Area Dose Product");
		fullNameByTag.put(TagFromName.FilterType,"Filter Type");
		fullNameByTag.put(TagFromName.TypeOfFilters,"Type Of Filters");
		fullNameByTag.put(TagFromName.IntensifierSize,"Intensifier Size");
		fullNameByTag.put(TagFromName.ImagerPixelSpacing,"Imager Pixel Spacing");
		fullNameByTag.put(TagFromName.Grid,"Grid");
		fullNameByTag.put(TagFromName.GeneratorPower,"Generator Power");
		fullNameByTag.put(TagFromName.CollimatorGridName,"Collimator/Grid Name");
		fullNameByTag.put(TagFromName.CollimatorType,"Collimator Type");
		fullNameByTag.put(TagFromName.FocalDistance,"Focal Distance");
		fullNameByTag.put(TagFromName.XFocusCenter,"X Focus Center");
		fullNameByTag.put(TagFromName.YFocusCenter,"Y Focus Center");
		fullNameByTag.put(TagFromName.FocalSpot,"Focal Spot(s)");
		fullNameByTag.put(TagFromName.AnodeTargetMaterial,"Anode Target Material");
		fullNameByTag.put(TagFromName.BodyPartThickness,"Body Part Thickness");
		fullNameByTag.put(TagFromName.CompressionForce,"Compression Force");
		fullNameByTag.put(TagFromName.DateOfLastCalibration,"Date of Last Calibration");
		fullNameByTag.put(TagFromName.TimeOfLastCalibration,"Time of Last Calibration");
		fullNameByTag.put(TagFromName.ConvolutionKernel,"Convolution Kernel");
		fullNameByTag.put(TagFromName.UpperLowerPixelValues,"Upper/Lower Pixel Values");
		fullNameByTag.put(TagFromName.ActualFrameDuration,"Actual Frame Duration");
		fullNameByTag.put(TagFromName.CountRate,"Count Rate");
		fullNameByTag.put(TagFromName.PreferredPlaybackSequencing,"Preferred Playback Sequencing");
		fullNameByTag.put(TagFromName.ReceiveCoilName,"Receive Coil Name");
		fullNameByTag.put(TagFromName.TransmitCoilName,"Transmit Coil Name");
		fullNameByTag.put(TagFromName.PlateType,"Plate Type");
		fullNameByTag.put(TagFromName.PhosphorType,"Phosphor Type");
		fullNameByTag.put(TagFromName.ScanVelocity,"Scan Velocity");
		fullNameByTag.put(TagFromName.WholeBodyTechnique,"Whole Body Technique");
		fullNameByTag.put(TagFromName.ScanLength,"Scan Length");
		fullNameByTag.put(TagFromName.AcquisitionMatrix,"Acquisition Matrix");
		fullNameByTag.put(TagFromName.InPlanePhaseEncodingDirection,"In-plane Phase Encoding Direction");
		fullNameByTag.put(TagFromName.FlipAngle,"Flip Angle");
		fullNameByTag.put(TagFromName.VariableFlipAngleFlag,"Variable Flip Angle Flag");
		fullNameByTag.put(TagFromName.SAR,"SAR");
		fullNameByTag.put(TagFromName.dBdt,"dB/dt");
		fullNameByTag.put(TagFromName.AcquisitionDeviceProcessingDescription,"Acquisition Device Processing Description");
		fullNameByTag.put(TagFromName.AcquisitionDeviceProcessingCode,"Acquisition Device Processing Code");
		fullNameByTag.put(TagFromName.CassetteOrientation,"Cassette Orientation");
		fullNameByTag.put(TagFromName.CassetteSize,"Cassette Size");
		fullNameByTag.put(TagFromName.ExposuresOnPlate,"Exposures on Plate");
		fullNameByTag.put(TagFromName.RelativeXRayExposure,"Relative X-Ray Exposure");
		fullNameByTag.put(TagFromName.ColumnAngulation,"Column Angulation");
		fullNameByTag.put(TagFromName.TomoLayerHeight,"Tomo Layer Height");
		fullNameByTag.put(TagFromName.TomoAngle,"Tomo Angle");
		fullNameByTag.put(TagFromName.TomoTime,"Tomo Time");
		fullNameByTag.put(TagFromName.TomoType,"Tomo Type");
		fullNameByTag.put(TagFromName.TomoClass,"Tomo Class");
		fullNameByTag.put(TagFromName.NumberOfTomosynthesisSourceImages,"Number of Tomosynthesis Source Images");
		fullNameByTag.put(TagFromName.PositionerMotion,"Positioner Motion");
		fullNameByTag.put(TagFromName.PositionerType,"Positioner Type");
		fullNameByTag.put(TagFromName.PositionerPrimaryAngle,"Positioner Primary Angle");
		fullNameByTag.put(TagFromName.PositionerSecondaryAngle,"Positioner Secondary Angle");
		fullNameByTag.put(TagFromName.PositionerPrimaryAngleIncrement,"Positioner Primary Angle Increment");
		fullNameByTag.put(TagFromName.PositionerSecondaryAngleIncrement,"Positioner Secondary Angle Increment");
		fullNameByTag.put(TagFromName.DetectorPrimaryAngle,"Detector Primary Angle");
		fullNameByTag.put(TagFromName.DetectorSecondaryAngle,"Detector Secondary Angle");
		fullNameByTag.put(TagFromName.ShutterShape,"Shutter Shape");
		fullNameByTag.put(TagFromName.ShutterLeftVerticalEdge,"Shutter Left Vertical Edge");
		fullNameByTag.put(TagFromName.ShutterRightVerticalEdge,"Shutter Right Vertical Edge");
		fullNameByTag.put(TagFromName.ShutterUpperHorizontalEdge,"Shutter Upper Horizontal Edge");
		fullNameByTag.put(TagFromName.ShutterLowerHorizontalEdge,"Shutter Lower Horizontal Edge");
		fullNameByTag.put(TagFromName.CenterOfCircularShutter,"Center of Circular Shutter");
		fullNameByTag.put(TagFromName.RadiusOfCircularShutter,"Radius of Circular Shutter");
		fullNameByTag.put(TagFromName.VerticesOfPolygonalShutter,"Vertices of Polygonal Shutter");
		fullNameByTag.put(TagFromName.ShutterPresentationValue,"Shutter Presentation Value");
		fullNameByTag.put(TagFromName.ShutterOverlayGroup,"Shutter Overlay Group");
		fullNameByTag.put(TagFromName.ShutterPresentationColorCIELabValue,"Shutter Presentation Color CIELab Value");
		fullNameByTag.put(TagFromName.CollimatorShape,"Collimator Shape");
		fullNameByTag.put(TagFromName.CollimatorLeftVerticalEdge,"Collimator Left Vertical Edge");
		fullNameByTag.put(TagFromName.CollimatorRightVerticalEdge,"Collimator Right Vertical Edge");
		fullNameByTag.put(TagFromName.CollimatorUpperHorizontalEdge,"Collimator Upper Horizontal Edge");
		fullNameByTag.put(TagFromName.CollimatorLowerHorizontalEdge,"Collimator Lower Horizontal Edge");
		fullNameByTag.put(TagFromName.CenterOfCircularCollimator,"Center of Circular Collimator");
		fullNameByTag.put(TagFromName.RadiusOfCircularCollimator,"Radius of Circular Collimator");
		fullNameByTag.put(TagFromName.VerticesOfPolygonalCollimator,"Vertices of Polygonal Collimator");
		fullNameByTag.put(TagFromName.AcquisitionTimeSynchronized,"Acquisition Time Synchronized");
		fullNameByTag.put(TagFromName.TimeSource,"Time Source");
		fullNameByTag.put(TagFromName.TimeDistributionProtocol,"Time Distribution Protocol");
		fullNameByTag.put(TagFromName.NTPSourceAddress,"NTP Source Address");
		fullNameByTag.put(TagFromName.PageNumberVector,"Page Number Vector");
		fullNameByTag.put(TagFromName.FrameLabelVector,"Frame Label Vector");
		fullNameByTag.put(TagFromName.FramePrimaryAngleVector,"Frame Primary Angle Vector");
		fullNameByTag.put(TagFromName.FrameSecondaryAngleVector,"Frame Secondary Angle Vector");
		fullNameByTag.put(TagFromName.SliceLocationVector,"Slice Location Vector");
		fullNameByTag.put(TagFromName.DisplayWindowLabelVector,"Display Window Label Vector");
		fullNameByTag.put(TagFromName.NominalScannedPixelSpacing,"Nominal Scanned Pixel Spacing");
		fullNameByTag.put(TagFromName.DigitizingDeviceTransportDirection,"Digitizing Device Transport Direction");
		fullNameByTag.put(TagFromName.RotationOfScannedFilm,"Rotation of Scanned Film");
		fullNameByTag.put(TagFromName.IVUSAcquisition,"IVUS Acquisition");
		fullNameByTag.put(TagFromName.IVUSPullbackRate,"IVUS Pullback Rate");
		fullNameByTag.put(TagFromName.IVUSGatedRate,"IVUS Gated Rate");
		fullNameByTag.put(TagFromName.IVUSPullbackStartFrameNumber,"IVUS Pull