/* Copyright (c) 2001-2007, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

package com.pixelmed.database;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomInputStream;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;

import java.lang.reflect.Constructor;

/**
 * <p>This class allows the reconstruction of a database from the stored instance files,
 * such as when the database schema model has been changed.</p>
 *
 * @author	dclunie
 */
public class RebuildDatabaseFromInstanceFiles {

	/***/
	private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/RebuildDatabaseFromInstanceFiles.java,v 1.4 2007/08/01 11:41:23 dclunie Exp $";
	
	private static void processFileOrDirectory(DatabaseInformationModel databaseInformationModel,File file) {
//System.err.println("RebuildDatabaseFromInstanceFiles.processFileOrDirectory(): "+file);
		if (file.isDirectory() && !file.getName().toUpperCase().equals("CVS")) {
System.err.println("Recursing into directory "+file);
			try {
				File listOfFiles[] = file.listFiles();
				for (int i=0; i<listOfFiles.length; ++i) {	
					processFileOrDirectory(databaseInformationModel,listOfFiles[i]);
				}
			}
			catch (Exception e) {
				//System.err.println(e);
				e.printStackTrace(System.err);
			}
		}
		else if (file.isFile()) {
			if (!file.isHidden()) {
System.err.println("Doing file "+file);
				try {
					DicomInputStream dfi = new DicomInputStream(new BufferedInputStream(new FileInputStream(file)));
					AttributeList list = new AttributeList();
//System.err.println("Starting read "+file);
					list.read(dfi);
//System.err.println("Finished read "+file);
					dfi.close();
					//d.extendTablesAsNecessary(list);		// doesn't work with Hypersonic ... ALTER command not supported
					databaseInformationModel.insertObject(list,file.getAbsolutePath());
				}
				catch (Exception e) {
					//System.err.println(e);
					e.printStackTrace(System.err);
				}
			}
			else {
System.err.println("Skipping hidden "+file);
			}
		}
		else {
System.err.println("Not a directory or file "+file);
		}
	}

	/**
	 * <p>Read the DICOM files listed on the command line, load them into the specified model and store
	 * the database files in the specified location.</p>
	 *
	 * @param	arg	the class name of the model, the (full) path of the database file prefix, and a list of DICOM file names or directories
	 */
	public static void main(String arg[]) {
		RebuildDatabaseFromInstanceFiles ourselves = new RebuildDatabaseFromInstanceFiles();
		if (arg.length >= 3) {
			String databaseModelClassName = arg[0];
			String databaseFileName = arg[1];
		
			if (databaseModelClassName.indexOf('.') == -1) {					// not already fully qualified
				databaseModelClassName="com.pixelmed.database."+databaseModelClassName;
			}
//System.err.println("Class name = "+databaseModelClassName);

			//DatabaseInformationModel databaseInformationModel = new PatientStudySeriesConcatenationInstanceModel(makePathToFileInUsersHomeDirectory(dataBaseFileName));
			DatabaseInformationModel databaseInformationModel = null;
			try {
				Class classToUse = Thread.currentThread().getContextClassLoader().loadClass(databaseModelClassName);
				Class[] parameterTypes = { databaseFileName.getClass() };
				Constructor constructorToUse = classToUse.getConstructor(parameterTypes);
				Object[] args = { databaseFileName };
				databaseInformationModel = (DatabaseInformationModel)(constructorToUse.newInstance(args));
			}
			catch (Exception e) {
				e.printStackTrace(System.err);
				System.exit(0);
			}

			int i = 2;		// start with 3rd argument
			while (i<arg.length) {
				String name = arg[i++];
				File file = new File(name);
				processFileOrDirectory(databaseInformationModel,file);
			}
		}
		else {
			System.err.println("Usage: java com.pixelmed.database.RebuildDatabaseFromInstanceFiles databaseModelClassName databaseFilePathPrefix databaseFileName path(s)");
		}
	}
}

